unit mDbaseEx;
{$I mODBC.INC}

interface
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,DsgnIntf,
  mDatabas;

type
  TmDataBaseEditor = class(TComponentEditor)
  private
  protected
  public
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
//    procedure Edit;override;
  end;


implementation
uses
  mdbaseed,mDBWiz;

function TmDataBaseEditor.GetVerbCount: Integer;
begin
  Result := 4;
end;

function TmDataBaseEditor.GetVerb(Index: Integer): string;
begin
  case index of
    0: Result := '&DataBase Editor ..';
    1: Result := '&Connect';
    2: Result := '&Disconnect';
    3: Result := '&Add MQuery ..';
    else Result := '';
  end;
end;

procedure TmDataBaseEditor.ExecuteVerb(Index: Integer);
begin
  case index of
    0: begin
         DataBaseEditorForm := TDataBaseEditorForm.Create( Application);
         try
           DataBaseEditorForm.DataBase := TmDataBase(Component);
           if DataBaseEditorForm.ShowModal=mrOk then
           begin
             Designer.Modified;
           end;
         finally
           DataBaseEditorForm.free;
         end;
       end;
    1: begin
         TmDataBase(Component).Connect;
       end;
    2: begin
         TmDataBase(Component).Disconnect;
       end;
    3: begin

         dbWizForm:=TdbWizForm.Create( Application);
         try
           dbWizForm.DataBase := TmDataBase(Component);
           dbWizForm.showDataSets:=false;
           dbWizForm.theFormDesigner:=designer;
           if dbWizForm.ShowModal=mrOk then
           begin
             Designer.Modified;
           end;
         finally
           dbWizForm.free;
         end;
       end;
  end;
end;



end.
