unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, StdCtrls, ExtCtrls, Buttons, Db, mQuery, mDataBas,
  ComCtrls, DBCtrls;

type
  TForm1 = class(TForm)
    mDB: TmDataBase;
    mQuery: TmQuery;
    Panel2: TPanel;
    Panel3: TPanel;
    ListBox1: TListBox;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    Notebook1: TNotebook;
    DBGrid1: TDBGrid;
    BitBtn2: TBitBtn;
    DataSource1: TDataSource;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    Memo1: TMemo;
    Memo2: TMemo;
    Memo3: TMemo;
    Memo4: TMemo;
    DBNavigator1: TDBNavigator;
    DBMemo1: TDBMemo;
    Memo5: TMemo;
    Button1: TButton;
    Splitter1: TSplitter;
    Splitter2: TSplitter;
    procedure BitBtn1Click(Sender: TObject);
    procedure mQueryAfterOpen(DataSet: TDataSet);
    procedure mQueryAfterClose(DataSet: TDataSet);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure DBGrid1ColEnter(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
     with ListBox1 do begin
        if ItemIndex>=0 then begin
            if mDB.DataBaseName<>Items[ItemIndex] then begin
               if mDB.Connected then mDB.DisConnect;
               mDB.DataBaseName:=Items[ItemIndex];
            end;
        end;
     end;
     mQuery.SQL.Assign(Memo1.Lines);
     mQuery.InsertSQL.Assign(Memo2.Lines);
     mQuery.ModifySQL.Assign(Memo3.Lines);
     mQuery.DeleteSQL.Assign(Memo4.Lines);
     DBMemo1.DataField:='';
     mQuery.Open;
end;

procedure TForm1.mQueryAfterOpen(DataSet: TDataSet);
begin
     Notebook1.PageIndex:=1;
     BitBtn1.Enabled:=False;
     BitBtn2.Enabled:=True;
end;

procedure TForm1.mQueryAfterClose(DataSet: TDataSet);
begin
     Notebook1.PageIndex:=0;
     BitBtn2.Enabled:=False;
     BitBtn1.Enabled:=True;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     mDB.GetDatSourceNames(ListBox1.Items);
     Notebook1.PageIndex:=0;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
     mQuery.Close;
end;

procedure TForm1.DBGrid1ColEnter(Sender: TObject);
begin
     DBMemo1.DataField:=DBGrid1.SelectedField.FieldName;
end;

procedure TForm1.Button1Click(Sender: TObject);
Var
i:integer;
begin
     with Memo5 do begin
        Lines.Clear;
        mQuery.First;
        while not mQuery.Eof do begin
           Lines.add('');
           for i:=0 to mQuery.FieldCount-1 do begin
             Lines[Lines.Count-1]:=Lines[Lines.Count-1]+#9+
                mQuery.Fields[i].AsString;
           end;
           mQuery.Next;
        end;
     end;
end;

end.
