//      MOUSE FRIENDLY PACKAGE
//      ~~~~~~~~~~~~~~~~~~~~~~
//           version 1.0
//
// (c) 1998 by Sergey Kirichenko (ksv@cheerful.com)
//
//  in this release: TMFLabel
//                   TMFPanel
//                   TMFBevel
//                   TMFBitBtn
//

unit MouseFriendly;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, DsgnIntf;

type
  TAboutMouseFriendly = class(TPropertyEditor)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
    function GetValue: string; override;
  end;
{- TMFLabel -}
  TMFLabel = class(TLabel)
  private
    FAbout: TAboutMouseFriendly;
    FMouseFriendy: boolean;
    FOnMouseColor: TColor;
    FOnMouseEnterEvent, FOnMouseExitEvent: TNotifyEvent;
    FFontOnMouse: TFont;
    FOnMouseExitColor: TColor;
    FFontOnMouseExit: TFont;
    procedure SetFont(Value: TFont);
  protected
    procedure CMMouseEnter (var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseExit (var Message: TMessage); message CM_MOUSELEAVE;
  public
    procedure MouseEnterEvent;
    procedure MouseExitEvent;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property About: TAboutMouseFriendly read FAbout write FAbout;
    property EnabledMouseFriendy: Boolean read FMouseFriendy write FMouseFriendy;
    property ColorOnMouse: TColor read FOnMouseColor write FOnMouseColor;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnterEvent write FOnMouseEnterEvent;
    property OnMouseExit: TNotifyEvent read FOnMouseExitEvent write FOnMouseExitEvent;
    property FontOnMouse: TFont read FFontOnMouse write SetFont;
  end;
{- TMFPanel -}
  TMFPanel = class(TPanel)
  private
    FAbout: TAboutMouseFriendly;
    FMouseFriendy: boolean;
    FOnMouseColor, FOnMouseFontColor: TColor;
    FOnMouseEnter, FOnMouseExit: TNotifyEvent;
    FBevelInnerOnMouse,FBevelOuterOnMouse: TPanelBevel;
    FOnMouseExitColor,FOnMouseExitFontColor: TColor;
    FBevelInnerOnMouseExit,FBevelOuterOnMouseExit: TPanelBevel;
  protected
    procedure CMMouseEnter (var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseExit (var Message: TMessage); message CM_MOUSELEAVE;
  public
    procedure MouseEnter;
    procedure MouseExit;
    constructor Create(AOwner: TComponent); override;
  published
    property About: TAboutMouseFriendly read FAbout write FAbout;
    property EnabledMouseFriendy: Boolean read FMouseFriendy write FMouseFriendy;
    property ColorOnMouse: TColor read FOnMouseColor write FOnMouseColor;
    property FontColorOnMouse: TColor read FOnMouseFontColor write FOnMouseFontColor;
    property BevelInnerOnMouse: TPanelBevel read FBevelInnerOnMouse write FBevelInnerOnMouse;
    property BevelOuterOnMouse: TPanelBevel read FBevelOuterOnMouse write FBevelOuterOnMouse;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseExit: TNotifyEvent read FOnMouseExit write FOnMouseExit;
  end;
{- TMFBevel -}
  TMFBevel = class(TBevel)
  private
    FAbout: TAboutMouseFriendly;
    FStyleOnMouseExit: TBevelStyle;
    FOnMouseEnter, FOnMouseExit: TNotifyEvent;
    FStyleOnMouse: TBevelStyle;
    FMouseFriendy: boolean;
  protected
    procedure CMMouseEnter (var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseExit (var Message: TMessage); message CM_MOUSELEAVE;
  public
    procedure MouseEnter;
    procedure MouseExit;
    constructor Create(AOwner: TComponent); override;
  published
    property About: TAboutMouseFriendly read FAbout write FAbout;
    property EnabledMouseFriendy: Boolean read FMouseFriendy write FMouseFriendy;
    property StyleOnMouse: TBevelStyle read FStyleOnMouse write FStyleOnMouse;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseExit: TNotifyEvent read FOnMouseExit write FOnMouseExit;
  end;
{- TMFBitBtn -}
  TMFBitBtn = class(TBitBtn)
  private
    FAbout: TAboutMouseFriendly;
    FMouseFriendy: boolean;
    FOnMouseEnter, FOnMouseExit: TNotifyEvent;
    FFontOnMouse: TFont;
    FGlyphOnMouse: TBitmap;
    FGlyphOnMouseExit: TBitmap;
    FFontOnMouseExit: TFont;
    procedure SetFont(Value: TFont);
    procedure SetGlyph(Value: TBitmap);
  protected
    procedure CMMouseEnter (var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseExit (var Message: TMessage); message CM_MOUSELEAVE;
  public
    procedure MouseEnter;
    procedure MouseExit;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property About: TAboutMouseFriendly read FAbout write FAbout;
    property EnabledMouseFriendy: Boolean read FMouseFriendy write FMouseFriendy;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseExit: TNotifyEvent read FOnMouseExit write FOnMouseExit;
    property FontOnMouse: TFont read FFontOnMouse write SetFont;
    property GlyphOnMouse: TBitmap read FGlyphOnMouse write SetGlyph;            // stored IsCustom;
  end;

procedure Register;

implementation
{----------------------------------------------}
constructor TMFLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FFontOnMouse:= TFont.Create;
  FFontOnMouseExit:= TFont.Create;
  EnabledMouseFriendy:= TRUE;
  ColorOnMouse:= clBtnFace;
  FFontOnMouse.Color:= clYellow;
end;
{----------------------------------------------}
destructor TMFLabel.Destroy;
begin
  FFontOnMouseExit.Free;
  FFontOnMouse.Free;
  inherited Destroy;
end;
{----------------------------------------------}
procedure TMFLabel.SetFont(Value: TFont);
begin
  FFontOnMouse.Assign(Value);
end;
{----------------------------------------------}
procedure TMFLabel.MouseEnterEvent;
begin
  if Enabled and FMouseFriendy then
    begin
      FOnMouseExitColor:= Color;
      FFontOnMouseExit.Assign(Font);
      Color:= FOnMouseColor;
      Font.Assign(FFontOnMouse);
      if Assigned(FOnMouseEnterEvent) then
        FOnMouseEnterEvent (Self);
    end;
end;
{----------------------------------------------}
procedure TMFLabel.MouseExitEvent;
begin
  if Enabled and FMouseFriendy then
    begin
      Color:= FOnMouseExitColor;
      Font.Assign(FFontOnMouseExit);
      if Assigned(FOnMouseExitEvent) then
        FOnMouseExitEvent (Self);
    end;
end;
{----------------------------------------------}
procedure TMFLabel.CMMouseExit(var Message: TMessage);
begin
  inherited;
  MouseExitEvent;
end;
{----------------------------------------------}
procedure TMFLabel.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  MouseEnterEvent;
end;
{----------------------------------------------}
procedure TAboutMouseFriendly.Edit;
begin
 Application.MessageBox('Mouse Friendly Package ver 1.0'+#10#13+
   'by Sergey Kirichenko (ksv@cheerful.com)','* FreeWare *',MB_ICONASTERISK);
end;
function TAboutMouseFriendly.GetValue: string;
begin
 Result := 'about Mouse Friendly Package';
end;
function TAboutMouseFriendly.GetAttributes: TPropertyAttributes;
begin
 Result := [paMultiSelect, paDialog, paReadOnly];
end;
{----------------------------------------------}
constructor TMFPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  EnabledMouseFriendy:= TRUE;
  ColorOnMouse:=   clBtnFace;
  FontColorOnMouse:= clBlue;
  BevelInnerOnMouse:= bvNone;
  BevelOuter:= bvLowered;
  BevelOuterOnMouse:= bvRaised;
end;
{----------------------------------------------}
procedure TMFPanel.MouseEnter;
begin
  if Enabled and FMouseFriendy then
    begin
      FOnMouseExitColor:= Color;
      FOnMouseExitFontColor:= Font.Color;
      FBevelInnerOnMouseExit:= BevelInner;
      FBevelOuterOnMouseExit:= BevelOuter;
      Color:= FOnMouseColor;
      Font.Color:= FOnMouseFontColor;
      BevelInner:= FBevelInnerOnMouse;
      BevelOuter:= FBevelOuterOnMouse;
      if Assigned(FOnMouseEnter) then
        FOnMouseEnter (Self);
    end;
end;
{----------------------------------------------}
procedure TMFPanel.MouseExit;
begin
  if Enabled and FMouseFriendy then
    begin
      Color:= FOnMouseExitColor;
      Font.Color:= FOnMouseExitFontColor;
      BevelInner:= FBevelInnerOnMouseExit;
      BevelOuter:= FBevelOuterOnMouseExit;
      if Assigned(FOnMouseExit) then
        FOnMouseExit (Self);
    end;
end;
{----------------------------------------------}
procedure TMFPanel.CMMouseExit (var Message: TMessage);
begin
  inherited;
  MouseExit;
end;
{----------------------------------------------}
procedure TMFPanel.CMMouseEnter (var Message: TMessage);
begin
  inherited;
  MouseEnter;
end;
{----------------------------------------------}
constructor TMFBevel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  EnabledMouseFriendy:= TRUE;
  Style:= bsLowered;
  StyleOnMouse:= bsRaised;
end;
{----------------------------------------------}
procedure TMFBevel.MouseEnter;
begin
  if Enabled and FMouseFriendy then
    begin
      FStyleOnMouseExit:= Style;
      Style:= FStyleOnMouse;
      if Assigned(FOnMouseEnter) then
        FOnMouseEnter (Self);
    end;
end;
{----------------------------------------------}
procedure TMFBevel.MouseExit;
begin
  if Enabled and FMouseFriendy then
    begin
      Style:= FStyleOnMouseExit;
      if Assigned(FOnMouseExit) then
        FOnMouseExit (Self);
    end;
end;
{----------------------------------------------}
procedure TMFBevel.CMMouseExit (var Message: TMessage);
begin
  inherited;
  MouseExit;
end;
{----------------------------------------------}
procedure TMFBevel.CMMouseEnter (var Message: TMessage);
begin
  inherited;
  MouseEnter;
end;
{----------------------------------------------}
constructor TMFBitBtn.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FGlyphOnMouse:= TBitmap.Create;
  FGlyphOnMouseExit:= TBitmap.Create;
  FFontOnMouse:= TFont.Create;
  FFontOnMouseExit:= TFont.Create;
  EnabledMouseFriendy:= TRUE;
  FFontOnMouse.Color:= clYellow;
end;
{----------------------------------------------}
destructor TMFBitBtn.Destroy;
begin
  FFontOnMouseExit.Free;
  FFontOnMouse.Free;
  FGlyphOnMouse.Free;
  FGlyphOnMouseExit.Free;
  inherited Destroy;
end;
{----------------------------------------------}
procedure TMFBitBtn.SetGlyph(Value: TBitmap);
begin
  FGlyphOnMouse.Assign(Value);
end;
{----------------------------------------------}
procedure TMFBitBtn.SetFont(Value: TFont);
begin
  FFontOnMouse.Assign(Value);
end;
{----------------------------------------------}
procedure TMFBitBtn.MouseEnter;
begin
  if Enabled and FMouseFriendy then
    begin
      if assigned(FGlyphOnMouse) then
        begin
          FGlyphOnMouseExit.Assign(Glyph);
          Glyph.Assign(FGlyphOnMouse);
        end;
      FFontOnMouseExit.Assign(Font);
      Font.Assign(FFontOnMouse);
      if Assigned(FOnMouseEnter) then
        FOnMouseEnter (Self);
    end;
end;
{----------------------------------------------}
procedure TMFBitBtn.MouseExit;
begin
  if Enabled and FMouseFriendy then
    begin
      if assigned(FGlyphOnMouseExit) then
        Glyph.Assign(FGlyphOnMouseExit);
      Font.Assign(FFontOnMouseExit);
      if Assigned(FOnMouseExit) then
        FOnMouseExit (Self);
    end;
end;
{----------------------------------------------}
procedure TMFBitBtn.CMMouseExit (var Message: TMessage);
begin
  inherited;
  MouseExit;
end;
{----------------------------------------------}
procedure TMFBitBtn.CMMouseEnter (var Message: TMessage);
begin
  inherited;
  MouseEnter;
end;
{----------------------------------------------}
procedure Register;
begin
  RegisterComponents('Mouse Friendly', [TMFLabel,TMFPanel,TMFBevel,TMFBitBtn]);
  RegisterPropertyEditor(TypeInfo(TAboutMouseFriendly), TMFLabel, 'About', TAboutMouseFriendly);
end;

end.
