unit Menu98;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, ExtCtrls,
  Forms, Dialogs, Menus, TB97;

type
  TAnimation = (anNone, anVSlide, anHSlide, anUnfold, anSmart, anRandom);


  TMainMenu98 = class(TToolbar97)
  private
    FTimeout: Integer;
    FMainMenu: TMainMenu;
    FOpenAnimation: TAnimation;
    FCloseAnimation: TAnimation;
    FDoubleSpeed: Boolean;

    procedure SetMainMenu(Value: TMainMenu);

  protected
    procedure Loaded; override;
    procedure SetVirtualBounds (ALeft, ATop, AWidth, AHeight: Integer); override;

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

  published
    property OpenAnimation: TAnimation read FOpenAnimation write FOpenAnimation;
    property CloseAnimation: TAnimation read FCloseAnimation write FCloseAnimation;
    property MainMenu: TMainMenu read FMainMenu write SetMainMenu;
    property Timeout: Integer read FTimeout write FTimeout;
    property DoubleSpeed: Boolean read FDoubleSpeed write FDoubleSpeed;

  end;


  TMenuButton98 = class(TToolbarButton97)
  protected
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure Paint; override;

  public
    procedure Click; override;

  end;


  TPopupMenu98 = class(TPopupMenu)
  private
    FOpenAnimation: TAnimation;
    FCloseAnimation: TAnimation;
    FTimeout: Integer;
    FDoubleSpeed: Boolean;
    Form: TForm;

    function Button: TMenuButton98;

  public
    MenuItems: TMenuItem;
    procedure Popup(X, Y: Integer); override;

  published
    property OpenAnimation: TAnimation read FOpenAnimation write FOpenAnimation;
    property CloseAnimation: TAnimation read FCloseAnimation write FCloseAnimation;
    property Timeout: Integer read FTimeout write FTimeout;
    property DoubleSpeed: Boolean read FDoubleSpeed write FDoubleSpeed;

  end;


procedure Register;

implementation
uses
  MmSystem;

{$R PopupMenu98Form.dfm }

const
  menu_ItemHeight = 19;
  menu_Indent = 27;
  menu_SepHeight = 11;


type
  TPopupMenu98Form = class(TForm)
  private
    PaintMenu: Boolean;
    Buffer: TBitmap;
    SelectedChanged: Boolean;
    FSelectedIndex: Integer;
    LastSelectedIndex: Integer;
    Timeout: Integer;
    OpenAnimation: TAnimation;
    CloseAnimation: TAnimation;
    DoubleSpeed: Boolean;
    FromTopToBottom: Boolean;

    CurSubMenu: TPopupMenu98Form;
    ParentPopupMenu98Form: TPopupMenu98Form;

    Timer: TTimer;

    function GetRealHeight: Integer;
    function GetRealWidth: Integer;
    function GetMainWidth: Integer;
    function CurItemTop: Integer;

    procedure SetSelectedIndex(Value: Integer);

    procedure WMSetFocus(var Message: TWMSetFocus); message WM_SetFOCUS;
    procedure PopupMenu98FormTimer(Sender: TObject);

  protected
    procedure Click; override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure Paint; override;

  public
    MenuItems: TMenuItem;
    Animated: Boolean;
    KillAnimation: Boolean;

    property SelectedIndex: Integer read FSelectedIndex write SetSelectedIndex;

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function GetIndexAt(X, Y: Integer): Integer;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    procedure Animate; virtual;

    procedure PopupCurSubMenu;

  published
    property Font;
    property ParentFont;

  end;


const
  ActivePopupMenu98: TPopupMenu98 = nil;
  ActiveMenu98: TMainMenu98 = nil;
  Pattern: TBitmap = nil;
  MouseHookHandle: THandle = 0;      // hook for clicking outside of MenuForm
  KeyboardHookHandle: THandle = 0;   // hook for keyboard management
  IgnoreNextMenuUp: Boolean = False; // ignore alt key up after alt key down

  LastButtonMouseInControl: TToolbarButton97 = nil;

{ Routines }

function AssignedActivePopupMenu98Form: Boolean;
begin
  Result:= Assigned(ActivePopupMenu98) and Assigned(ActivePopupMenu98.Form);
end;

procedure KillActivePopupMenu98;
begin
  if AssignedActivePopupMenu98Form then
    with ActivePopupMenu98, Form as TPopupMenu98Form do begin
      Form.Hide;
      TForm(Owner).Repaint;
      
      if Animated then KillAnimation:= True
                  else Form.Release;
      Form:= nil;

      LastButtonMouseInControl:= Button;
      Button.MouseLeft;
      Button.Down:= False;
    end;

  ActivePopupMenu98:= nil;
end;

function MouseHook(Code, wParam, lParam: Integer): Integer; export; stdcall;
// verify for clicking outside of ActivePopupMenu98 menu
type
  TMouseHook = record
    Pos: TPoint;
    Hwnd: THandle;
    wHitTestCode: Integer;
    dwExtraInfo: Cardinal;
  end;
  PMouseHook = ^TMouseHook;

var
  F: TPopupMenu98Form;
begin
  Result:= 0;

  if (Code >= 0)
  and (AssignedActivePopupMenu98Form)
  then begin
    F:= TPopupMenu98Form(ActivePopupMenu98.Form);

    if (wParam = wm_LButtonUp)
    or (wParam = wm_LButtonDown)
    or (wParam = wm_LButtonDblClk)
    or (wParam = wm_RButtonUp)
    or (wParam = wm_RButtonDown)
    or (wParam = wm_RButtonDblClk)
    or (wParam = wm_MButtonUp)
    or (wParam = wm_MButtonDown)
    or (wParam = wm_MButtonDblClk)
    or (wParam = wm_NCLButtonUp)
    or (wParam = wm_NCLButtonDown)
    or (wParam = wm_NCLButtonDblClk)
    or (wParam = wm_NCRButtonUp)
    or (wParam = wm_NCRButtonDown)
    or (wParam = wm_NCRButtonDblClk)
    or (wParam = wm_NCMButtonUp)
    or (wParam = wm_NCMButtonDown)
    or (wParam = wm_NCMButtonDblClk)
    then
      with PMouseHook(lParam)^.Pos do begin
        // check for MenuButton97
        with ActivePopupMenu98.Button do
          if (X >= ClientOrigin.X) and (X <= ClientOrigin.X + Width)
          and (Y >= ClientOrigin.Y) and (Y <= ClientOrigin.Y + Height)
          then Exit;

        // check for each window
        while F <> nil do
          if (X >= F.Left) and (X <= F.Left + F.Width)
          and (Y >= F.Top) and (Y <= F.Top + F.Height)
          then Exit
          else F:= F.CurSubMenu;

        with TForm(ActivePopupMenu98.Owner) do begin
          KillActivePopupMenu98;
          Refresh;
        end;
      end;
  end
  else
    Result:= CallNextHookEx(MouseHookHandle, Code, wParam, lParam);
end;

function KeyboardHook(Code, wParam, lParam: Integer): Integer; export; stdcall;
// keyboard management
const
  kbd_Transition = 1 shl 31; // transition code = 0 if keydown, = 1 if key up

  // directions for GetNextMenuButton98
  drLeft  = -1;
  drRight = 1;

var
  F: TPopupMenu98Form;
  I, P: Integer;
  S: String;


  function GetNextMenuButton98(const Control: TControl; const Direction: Integer): TMenuButton98;
  var
    I: Integer;
  begin
    I:= 0;
    while (I < ActiveMenu98.ControlCount)
    and (ActiveMenu98.Controls[I] <> Control) do Inc(I);

    Inc(I, Direction);
    if I <= -1 then I:= ActiveMenu98.ControlCount -1;
    if I >= ActiveMenu98.ControlCount then I:= 0;

    Result:= TMenuButton98(ActiveMenu98.Controls[I]);
  end;

  function SearchShortcut: Integer;
  begin
    Result:= 0;
  end;

begin
  Result:= 0;

  if (Code >= 0) then begin
    if (AssignedActivePopupMenu98Form) then begin // one of menus is popupped

      // only OnKeyDown (not OnKeyUp)
      if (lParam and kbd_Transition <> 0) then Exit;

      // seeking for lowest popupped menu
      F:= ActivePopupMenu98.Form as TPopupMenu98Form;
      while F.CurSubMenu <> nil do F:= F.CurSubMenu;

      case wParam of
        vk_Escape:
          if not Assigned(F.ParentPopupMenu98Form)
          then begin
            KillActivePopupMenu98;

            ButtonMouseInControl:= LastButtonMouseInControl;
            if Assigned(LastButtonMouseInControl) then
              LastButtonMouseInControl.MouseEntered;
          end
          else begin
            F.ParentPopupMenu98Form.CurSubMenu:= nil;
            F.Release;
          end;

        vk_Return:
          begin
            F.Click;
            IgnoreNextMenuUp:= True;
          end;

        vk_Menu, vk_F10:
          begin
            KillActivePopupMenu98;
            IgnoreNextMenuUp:= True;
          end;

        vk_F1:
          if (Application.HelpFile <> '')
          and (F.SelectedIndex <> -1)
          and (F.MenuItems[F.SelectedIndex].HelpContext <> 0)
          then
            Application.HelpContext(F.MenuItems[F.SelectedIndex].HelpContext);

        vk_Up:
          begin
            F.SelectedIndex:= F.SelectedIndex -1;
            F.Paint;
            F.Timer.Enabled:= False;
          end;

        vk_Down:
          begin
            F.SelectedIndex:= F.SelectedIndex +1;
            F.Paint;
            F.Timer.Enabled:= False;
          end;

        vk_Left:
          if not Assigned(F.ParentPopupMenu98Form)
          then
            try
              GetNextMenuButton98(ActivePopupMenu98.Button, drLeft).Click
            except
            end
          else begin
            F.ParentPopupMenu98Form.CurSubMenu:= nil;
            F.Release;
          end;

        vk_Right:
          if (F.SelectedIndex = -1)
          or (F.MenuItems[F.SelectedIndex].Count = 0)
          then
            try
              GetNextMenuButton98(ActivePopupMenu98.Button, drRight).Click
            except
            end
          else 
            F.PopupCurSubMenu;

        else
          if (GetKeyState(wParam) and vk_Control <> vk_Control)
          and (wParam in [Byte('0')..Byte('9'), Byte('A')..Byte('Z')])
          then begin // just a symbol key - seeking for menu item
            for I:= 0 to F.MenuItems.Count -1 do begin
              S:= F.MenuItems[I].Caption;

              repeat
                P:= Pos('&', S);
                if P = 0 then Break;

                Delete(S, 1, P);
                if (S <> '') and (Byte(UpCase(S[1])) = wParam) then  // symbol found!!!!
                  with F.MenuItems[I] do begin
                    if (not Enabled) then System.Break;

                    if Count = 0 then
                    try // ordinary item
                      if Assigned(ButtonMouseInControl) then
                        ButtonMouseInControl.MouseLeft;
                        
                      KillActivePopupMenu98;
                      sndPlaySound('MenuCommand', snd_Async + snd_NoDefault);
                      OnClick(F.MenuItems[I]);
                    except
                    end
                    else begin // SubMenu
                      F.SelectedIndex:= I;
                      F.SelectedChanged:= False;
                      F.PopupCurSubMenu;
                    end;

                    Exit;
                  end;

              until False;
            end;

            MessageBeep(-1);
          end
          else begin // shortcut
            Result:= SearchShortcut;
            Exit;
          end;

      end;

      Result:= 1;
    end
    else // no one of menus is popupped
      if Assigned(ActiveMenu98)
      and (not (csDesigning in ActiveMenu98.ComponentState))
      and (ActiveMenu98.ControlCount > 0) then
        case wParam of
          vk_Escape:
            if (lParam and kbd_Transition = 0)
            and Assigned(ButtonMouseInControl) then begin
              ButtonMouseInControl.MouseLeft;
              Result:= 1;
            end;

          vk_Menu, vk_F10:
            begin
              if not Assigned(LastButtonMouseInControl) then
                LastButtonMouseInControl:= TMenuButton98(ActiveMenu98.Controls[0]);

              with LastButtonMouseInControl as TMenuButton98 do begin
                if (FState <> bsMouseIn)
                and (lParam and kbd_Transition <> 0)
                then
                  if IgnoreNextMenuUp
                  then
                    IgnoreNextMenuUp:= False
                  else
                    begin
                      ButtonMouseInControl:= LastButtonMouseInControl;
                      MouseEntered;
                    end;

                if (lParam and kbd_Transition = 0)
                and Assigned(ButtonMouseInControl)
                then begin
                  LastButtonMouseInControl:= ButtonMouseInControl;
                  ButtonMouseInControl.MouseLeft;
                  IgnoreNextMenuUp:= True;
                end;

                Result:= 1;
              end;
            end;

          vk_Return:
            if Assigned(ButtonMouseInControl)
            and not IgnoreNextMenuUp
            then begin
              if (lParam and kbd_Transition = 0)
              then ButtonMouseInControl.Down:= True
              else ButtonMouseInControl.Click;

              Result:= 1;
            end
            else
              IgnoreNextMenuUp:= False;

          vk_Left:
            if Assigned(ButtonMouseInControl)
            and (lParam and kbd_Transition = 0)
            then begin
              LastButtonMouseInControl:= ButtonMouseInControl;
              ButtonMouseInControl.MouseLeft;
              ButtonMouseInControl:= GetNextMenuButton98(LastButtonMouseInControl, drLeft);
              ButtonMouseInControl.MouseEntered;
            end;

          vk_Right:
            if Assigned(ButtonMouseInControl)
            and (lParam and kbd_Transition = 0)
            then begin
              LastButtonMouseInControl:= ButtonMouseInControl;
              ButtonMouseInControl.MouseLeft;
              ButtonMouseInControl:= GetNextMenuButton98(LastButtonMouseInControl, drRight);
              ButtonMouseInControl.MouseEntered;
            end;
        end;

  end
  else
    Result:= CallNextHookEx(KeyboardHookHandle, Code, wParam, lParam);
end;

procedure Register;
begin
  RegisterComponents('Toolbar97', [TMainMenu98, TPopupMenu98]);
end;


{ TMainMenu98 }

constructor TMainMenu98.Create(AOwner: TComponent);
var
  I: Integer;
begin
  inherited;

  Caption:=         'Menu Bar';
  FTimeout:=        10;
  FDoubleSpeed:=    True;
  FOpenAnimation:=  anSmart;
  FCloseAnimation:= anNone;

  for I:= 0 to TForm(Owner).ComponentCount -1 do
    if TForm(Owner).Components[I] is TMainMenu then begin
      FMainMenu:= TForm(Owner).Components[I] as TMainMenu;
      Break;
    end;

  ActiveMenu98:= Self;
end;


destructor TMainMenu98.Destroy; 
begin
  ActiveMenu98:= nil;

  inherited;
end;

procedure TMainMenu98.Loaded;
var
  I: Integer;
  B: TMenuButton98;

begin
  inherited;

  if (csDesigning in ComponentState) then Exit;

  for I:= 0 to FMainMenu.Items.Count -1 do begin
    B:= TMenuButton98.Create(Self);
    B.DisplayMode:= dmTextOnly;
    B.Height:= 19;
    B.Caption:= FMainMenu.Items[I].Caption;
    B.Width:= Canvas.TextWidth(B.Caption) + 10;
    B.DropdownArrow:= False;
    B.GroupIndex:= 1;
    B.AllowAllUp:= True;
    B.Font.Assign(Font);

    B.DropdownMenu:= TPopupMenu98.Create(Owner);

    with B.DropdownMenu as TPopupMenu98 do begin
      MenuItems:=      FMainMenu.Items[I];
      OpenAnimation:=  Self.OpenAnimation;
      CloseAnimation:= Self.CloseAnimation;
      Timeout:=        Self.Timeout;
      DoubleSpeed:=    Self.DoubleSpeed;
    end;

    InsertControl(B);
  end;

  SetMenu(TForm(Owner).Handle, 0);
end;

procedure TMainMenu98.SetVirtualBounds(ALeft, ATop, AWidth, AHeight: Integer);
begin
  if Assigned(DockedTo) then
    if DockedTo.Position in [dpTop, dpBottom]
    then AWidth:= DockedTo.Width
    else AHeight:= DockedTo.Height;

  inherited SetVirtualBounds(ALeft, ATop, AWidth, AHeight);
end;

procedure TMainMenu98.SetMainMenu(Value: TMainMenu);
begin
  FMainMenu:= Value;
end;


{ TMenuBotton98 }

procedure TMenuButton98.MouseMove(Shift: TShiftState; X, Y: Integer);
const
  LastX: Integer = 0;
  LastY: Integer = 0;
begin
  // ignore some little movements
  if (Abs(X - LastX) <= 2) and (Abs(Y - LastY) <= 2) then Exit;

  LastX:= X;
  LastY:= Y;

  inherited MouseMove(Shift, X, Y);

  if (not Down) and AssignedActivePopupMenu98Form then Click;
  LastButtonMouseInControl:= Self;
end;

procedure TMenuButton98.Click;
begin
  if Down and AssignedActivePopupMenu98Form then begin
    KillActivePopupMenu98;
    Down:= False;
    MouseLeft;
  end
  else begin
    Down:= True;
    inherited Click;
  end;
end;

procedure TMenuButton98.Paint;
var
  F: Boolean;
begin
  F:= FState = bsExclusive;
  if F then FState:= bsDown;

  inherited Paint;

  if F then FState:= bsExclusive;
end;

{ TPopupMenu98 }

procedure TPopupMenu98.Popup(X, Y: Integer);
begin
  KillActivePopupMenu98;
  if Assigned(Owner) then TForm(Owner).Repaint;
  TMainMenu98(Button.Parent).Repaint;

  ActivePopupMenu98:= Self;

  LockWindowUpdate(GetDesktopWindow);

  Form:= TPopupMenu98Form.Create(Owner);
  with Form as TPopupMenu98Form do begin
    ParentPopupMenu98Form:= nil;

    if Self.MenuItems <> nil
    then MenuItems:= Self.MenuItems
    else MenuItems:= Self.Items;

    SetBounds(X, Y, 0, 0);

    OpenAnimation:=  Self.OpenAnimation;
    CloseAnimation:= Self.CloseAnimation;
    Timeout:=        Self.Timeout;
    DoubleSpeed:=    Self.DoubleSpeed;

    Animate;
  end;
end;

function TPopupMenu98.Button: TMenuButton98;
begin
  Result:= TMenuButton98(PopupComponent);
end;


{ TPopupMenu98Form }

constructor TPopupMenu98Form.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  FSelectedIndex:= 0;
  OpenAnimation:=  anVSlide;
  CloseAnimation:= anVSlide;

  Timer:= TTimer.Create(Self);
  Timer.Interval:= 250;
  Timer.OnTimer:= PopupMenu98FormTimer;

  Buffer:= TBitmap.Create;
  Buffer.Canvas.Font.Assign(TForm(AOwner).Font);
end;

destructor TPopupMenu98Form.Destroy;
begin
  MenuItems:= nil;

  Timer.Free;

  Buffer.Free;

  // this checking is necessary when submenu going to be killed
  // by MainForm (Owner property), not by ParentPopupMenu98
  if Assigned(ParentPopupMenu98Form) then
    ParentPopupMenu98Form.CurSubMenu:= nil;

  if Assigned(CurSubMenu) then
    CurSubMenu.Release;

  inherited Destroy;
end;

{ Properties }

function TPopupMenu98Form.GetRealHeight: Integer;
var
  I: Integer;
begin
  Result:= 0;
  if not Assigned(MenuItems) then Exit;

  for I:= 0 to MenuItems.Count -1 do
    if MenuItems[I].Visible then
      if MenuItems[I].Caption = '-'
      then Inc(Result, menu_SepHeight)
      else Inc(Result, menu_ItemHeight);
end;

function TPopupMenu98Form.GetRealWidth: Integer;
var
  I, W1, W2, R1, R2: Integer;
begin
  R1:= 0;
  R2:= 0;
  Result:= 0;
  if not Assigned(MenuItems) then Exit;

  for I:= 0 to MenuItems.Count -1 do
     with MenuItems[I] do
       if Visible then begin
         if Default then Canvas.Font.Style:= [fsBold]
                    else Canvas.Font.Style:= [];

         W1:= Canvas.TextWidth(Caption);
         if R1 < W1 then R1:= W1;

         if ShortCut <> 0 then begin
           W2:= Canvas.TextWidth(ShortCutToText(ShortCut));
           if R2 < W2 then R2:= W2;
         end;
       end;

  Result:= R1 + R2;
end;

function TPopupMenu98Form.GetMainWidth: Integer;
var
  I, W: Integer;
begin
  Result:= 0;
  if not Assigned(MenuItems) then Exit;

  for I:= 0 to MenuItems.Count -1 do
     with MenuItems[I] do
       if Visible then begin
         if Default then Canvas.Font.Style:= [fsBold]
                    else Canvas.Font.Style:= [];

         W:= Canvas.TextWidth(Caption);
         if Result < W then Result:= W;
       end;
end;

function TPopupMenu98Form.GetIndexAt(X, Y: Integer): Integer;
var
  I, H: Integer;
begin
  H:= 0;
  Result:= -1;
  if not Assigned(MenuItems) then Exit;

  for I:= 0 to MenuItems.Count -1 do
    if MenuItems[I].Visible then
      if Y <= H then begin
        Result:= I -1;
        Exit;
      end
      else begin
        if MenuItems[I].Caption = '-'
        then Inc(H, menu_SepHeight)
        else Inc(H, menu_ItemHeight);
      end;

  if Y <= H then Result:= MenuItems.Count -1;
end;

function TPopupMenu98Form.CurItemTop: Integer;
var
  I, J: Integer;
begin
  J:= 0;
  Result:= 0;
  if (not Assigned(MenuItems)) or (SelectedIndex = -1) then Exit;

  for I:= 0 to MenuItems.Count -1 do
    if MenuItems[I].Visible then
      if J = SelectedIndex
      then
        Exit
      else begin
        Inc(J);

        if MenuItems[I].Caption = '-'
        then Inc(Result, menu_SepHeight)
        else Inc(Result, menu_ItemHeight);
      end;
end;

procedure TPopupMenu98Form.SetBounds(ALeft, ATop, AWidth, AHeight: Integer);
var
  R: TRect;
begin
  if Assigned(MenuItems) and not Animated then begin
    AWidth:= GetRealWidth + 2 * menu_Indent + 10;
    AHeight:= GetRealHeight + 6;
    Buffer.Width:= AWidth;
    Buffer.Height:= AHeight;

    with Buffer.Canvas do begin
      R:= ClipRect;
      DrawEdge(Handle, R, bdr_RaisedInner + bdr_RaisedOuter, bf_Rect);

      Pen.Color:= clMenu;
      PolyLine([Point(2, 2), Point(AWidth -2, 2)]);
      PolyLine([Point(2, AHeight -3), Point(AWidth -3, AHeight -3)]);
    end;
  end;

  inherited SetBounds(ALeft, ATop, AWidth, AHeight);
end;

procedure TPopupMenu98Form.SetSelectedIndex(Value: Integer);
var
  Direction: Integer;
begin
  if Value <> SelectedIndex then begin

    if Value > FSelectedIndex then Direction:= 1
                              else Direction:= -1;

    LastSelectedIndex:= FSelectedIndex;
    FSelectedIndex:= Value;
    SelectedChanged:= True;

    repeat
      // in case if LastSelectedItem = -1
      if (FSelectedIndex = LastSelectedIndex) then Break;

      if FSelectedIndex < 0 then FSelectedIndex:= MenuItems.Count -1;
      if FSelectedIndex >= MenuItems.Count then FSelectedIndex:= 0;

      // in other cases
      if ((MenuItems[FSelectedIndex].Caption <> '-')
      and MenuItems[FSelectedIndex].Visible
      and MenuItems[FSelectedIndex].Enabled)
      or (FSelectedIndex = LastSelectedIndex)
      then Break;

      Inc(FSelectedIndex, Direction);

    until False;

    Paint;
  end;
end;


{ Events }

procedure TPopupMenu98Form.WMSetFocus(var Message: TWMSetFocus);
begin
  if Animated
  then TForm(Owner).SetFocus
  else inherited;
end;

procedure TPopupMenu98Form.MouseDown;
begin
  TForm(Owner).SetFocus;
  Click;
end;

procedure TPopupMenu98Form.Click;
begin
  if SelectedIndex = -1 then Exit;

  with MenuItems[SelectedIndex] do begin
    if Assigned(CurSubMenu) then begin
      CurSubMenu.BringToFront;
      TForm(Owner).SetFocus;
    end;

    if (Caption = '-') or (not Enabled) or (Count <> 0) then Exit;

    Timer.Enabled:= False;

    Hide;
    ActivePopupMenu98.Button.MouseLeft;
    ActivePopupMenu98.Button.Down:= False;
    TForm(Owner).Repaint;

    sndPlaySound('MenuCommand', snd_Async + snd_NoDefault);

    try
      OnClick(MenuItems[SelectedIndex]);
    except
    end;

    KillActivePopupMenu98;
  end;
end;

procedure TPopupMenu98Form.MouseMove(Shift: TShiftState; X, Y: Integer);
const
  LastX: Integer = 0;
  LastY: Integer = 0;
var
  I: Integer;
begin
  // ignore some little movements
  if (Abs(X - LastX) <= 2) and (Abs(Y - LastY) <= 2) then Exit;

  LastX:= X;
  LastY:= Y;

  I:= GetIndexAt(X, Y);
  if I <> SelectedIndex then begin
    Timer.Enabled:= False;

    LastSelectedIndex:= FSelectedIndex;
    FSelectedIndex:= I;
    SelectedChanged:= True;
    Paint;

    if Assigned(CurSubMenu) then begin
      if Animated then CurSubMenu.KillAnimation:= True
                  else CurSubMenu.Release;
      CurSubMenu:= nil;
    end;

    Timer.Enabled:= True;
  end;
end;

procedure TPopupMenu98Form.PopupMenu98FormTimer(Sender: TObject);
var
  F: TPopupMenu98Form;
begin
  Timer.Enabled:= False;
  if (SelectedChanged)
  and (SelectedIndex <> -1) then
    PopupCurSubMenu;

  // close menus when owner *and* menu windows is not active
  if (not Animated)
  and (not TForm(Owner).Active) then begin
    F:= TPopupMenu98Form(ActivePopupMenu98.Form);
    while (F <> nil) and (not F.Active) do F:= F.CurSubMenu;

    if F = nil then KillActivePopupMenu98;
  end;

  SelectedChanged:= False;
  Timer.Enabled:= True;
end;

procedure TPopupMenu98Form.PopupCurSubMenu;
begin
  if Assigned(CurSubMenu) then begin
    if CurSubMenu.Animated
    then CurSubMenu.KillAnimation:= True
    else CurSubMenu.Release;

    CurSubMenu:= nil;
  end;

  if (MenuItems[SelectedIndex].Count > 0) then begin
    CurSubMenu:= TPopupMenu98Form.Create(Owner);
    CurSubMenu.Font.Assign(Font);
    CurSubMenu.MenuItems:= MenuItems[SelectedIndex];
    CurSubMenu.ParentPopupMenu98Form:= Self;

    with ClientToScreen(Point(Width -7, CurItemTop)) do
      CurSubMenu.SetBounds(X, Y, 0, 0);

    CurSubMenu.OpenAnimation:=  OpenAnimation;
    CurSubMenu.CloseAnimation:= CloseAnimation;
    CurSubMenu.Timeout:=        Timeout;
    CurSubMenu.DoubleSpeed:=    DoubleSpeed;

    CurSubMenu.Animate;
  end;
end;

{ Main Routines }

procedure TPopupMenu98Form.Animate;
var
  NewTop, NewWidth, NewHeight, SY, DX, DY, MX, MY: Integer;
  CurAnim: TAnimation;
begin
  DX:= 1;
  DY:= 1;
  MX:= 0;
  MY:= 0;
  Animated:= True;
  KillAnimation:= False;

  if (Left + Width) > GetSystemMetrics(sm_CxMaxTrack) then Left:= Left - Width;
  if Left < 0 then Left:= 0;

  SY:= GetSystemMetrics(sm_CyFullScreen) + GetSystemMetrics(sm_CyCaption);
  FromTopToBottom:= ((Top + Height) < SY) or (Top < Height);

  if not FromTopToBottom
  then Top:= Top - ActivePopupMenu98.Button.Height
  else if SY - Top - Height < 0 then Top:= SY - Height;

  NewTop:= Top;
  NewWidth:= Width;
  NewHeight:= Height;

  CurAnim:= OpenAnimation;          // current effect
  if CurAnim = anRandom then begin
    if Random(2) = 0 then CurAnim:= anHSlide
                     else CurAnim:= anVSlide;
  end;

  if CurAnim = anSmart then begin
    OpenAnimation:= anHSlide;
    CurAnim:= anVSlide;
  end;

  if CurAnim in [anVSlide, anUnfold] then begin
    MY:= Height;

    if DoubleSpeed
    then DY:= MY div (2 * menu_ItemHeight) +1
    else DY:= MY div menu_ItemHeight +1;
  end;

  if CurAnim in [anHSlide, anUnfold] then begin
    MX:= Width;

    if DoubleSpeed
    then DX:= MX div Round(1.5 * menu_ItemHeight) +1
    else DX:= MX div Round(0.75 * menu_ItemHeight) +1;
  end;

  if DX < DY
  then begin
    DX:= MX div DY +1;
    DY:= MY div DY;
  end
  else begin
    DY:= MY div DX +1;
    DX:= MX div DX;
  end;

  PaintMenu:= True;

  if CurAnim in [anVSlide, anUnfold] then Height:= 0{DY};
  if CurAnim in [anHSlide, anUnfold] then Width:=  0{DX};
//  if not FromTopToBottom then Top:= Top - DY;

  Show;

  LockWindowUpdate(0);

  sndPlaySound('MenuPopup', snd_Async + snd_NoDefault);

  // Animation!
  while (Width < MX) or (Height < MY) do begin
    if Width < MX then
      if (Width + DX) < MX
      then NewWidth:= Width + DX
      else NewWidth:= MX;

    if Height < MY then
      if (Height + DY) < MY
      then begin
        NewHeight:= Height + DY;
        if not FromTopToBottom then
          NewTop:= Top - DY;
      end
      else begin
        if not FromTopToBottom then
          NewTop:= Top - (MY - Height);
        NewHeight:= MY;
      end;

    LockWindowUpdate(GetDesktopWindow);

    SetBounds(Left, NewTop, NewWidth, NewHeight);
    Paint;

    LockWindowUpdate(0);

    Application.ProcessMessages;

    if KillAnimation then begin
      Release;
      Break;
    end;

    Sleep(Timeout);
  end;
  Animated:= False;
  KillAnimation:= False;
end;

procedure TPopupMenu98Form.Paint;
var
  I, Y, H, menu_ScLeft: Integer;
  R: TRect;
  MenuItemInfo: TMenuItemInfo;
  UseMenuItemBitmaps: Boolean;
  BitmapDC: HDC;


  procedure DrawTextAt(X, Y: Integer; Text: String; Default, Enabled, Selected: Boolean);
  begin
    with Buffer.Canvas do begin
      if Default
      then Font.Style:= [fsBold]
      else if Font.Style <> [] then Font.Style:= [];

      R:= Rect(X, Y, 0, Y + H);
      Brush.Style:= bsClear;

      if Enabled then
        if Selected
        then Font.Color:= clHighlightText
        else Font.Color:= clMenuText
      else begin
        OffsetRect(R, 1, 1);
        Font.Color:= clBtnHighlight;
        DrawText(Handle, PChar(Text), -1, R, dt_NoClip + dt_VCenter);
        OffsetRect(R, -1, -1);
        Font.Color:= clBtnShadow;
      end;

      DrawText(Handle, PChar(Text), -1, R, dt_NoClip + dt_VCenter);
    end;
  end;

begin
  if not Assigned(MenuItems) then Exit;

  Y:= 3;
  menu_ScLeft:= GetMainWidth + menu_Indent +10;

  MenuItemInfo.cbSize:= SizeOf(MenuItemInfo);
  MenuItemInfo.fMask:= miim_CheckMarks;

  BitmapDC:= CreateCompatibleDC(Canvas.Handle);

  for I:= 0 to MenuItems.Count -1 do
    with MenuItems[I], Buffer, Buffer.Canvas do
    if Visible then begin
      if Caption = '-'
      then H:= menu_SepHeight
      else H:= menu_ItemHeight;

      if PaintMenu or (I = SelectedIndex) or (I = LastSelectedIndex) then begin

        if (I = SelectedIndex) and (Caption <> '-') and (Enabled)
        then Brush.Color:= clHighlight
        else Brush.Color:= clMenu;

        Brush.Style:= bsSolid;
        FillRect(Rect(2, Y, Width -2, Y + H));

        Pen.Color:= clMenu;
        PolyLine([Point(2, Y), Point(2, Y + H)]);           // outer limits
        PolyLine([Point(Width -3, Y -1), Point(Width -3, Y + H)]);

        // caption
        if Caption = '-' then begin
          Pen.Color:= clBtnShadow;
          PolyLine([Point(4, Y +3), Point(Width -4, Y +3)]);
          Pen.Color:= clBtnHighlight;
          PolyLine([Point(4, Y +4), Point(Width -4, Y +4)]);
        end
        else begin
          DrawTextAt(menu_Indent, Y +2, Caption, Default, Enabled, SelectedIndex = I);
          DrawTextAt(menu_ScLeft, Y +2, ShortCutToText(ShortCut), Default, Enabled, SelectedIndex = I);

          // submenu triangle
          if Count <> 0 then begin
            Pen.Color:= Font.Color;
            Brush.Color:= Font.Color;
            PolyGon([Point(Width -14, Y +5), Point(Width -14, Y +11), Point(Width -11, Y +8)]);
          end;
        end;

        // get menu item's bitmaps
        UseMenuItemBitmaps:=
          (Caption <> '-')
          and (GetMenuItemInfo(MenuItems.Handle, I, True, MenuItemInfo))
          and ((MenuItemInfo.hbmpChecked <> 0) or (MenuItemInfo.hbmpUnChecked <> 0));

        if Checked then begin
          // inner limits
          Rectangle(H +3, Y, H +4, Y + H);

          R:= Rect(3, Y, H +3, Y + H);
          DrawEdge(Handle, R, bdr_SunkenOuter, bf_Rect);

          if (SelectedIndex = I)
          then Brush.Color:= clMenu
          else Brush.Bitmap:= Pattern;

          FillRect(Rect(4, Y +1, H +2, Y + H -1));

          if UseMenuItemBitmaps
          and (MenuItemInfo.hbmpChecked <> 0) then begin

            SelectObject(BitmapDC, MenuItemInfo.hbmpChecked);
            BitBlt(Canvas.Handle, 5, Y +2, H -1, H -1, BitmapDC, 0, 0, SrcCopy);

          end
          else begin

            if RadioItem then begin

              // painting radio button
              Pen.Color:= clWhite;
              Brush.Color:= clWhite;
              Ellipse(11, Y +8, H -2, Y + H -5);

              Pen.Color:= clSilver;
              Brush.Color:= clSilver;
              Ellipse(9, Y +6, H -4, Y + H -7);

              Pen.Color:= clBlack;
              Brush.Color:= clBlack;
              Ellipse(10, Y +7, H -3, Y + H -6);

            end
            else begin

              // painting check mark
              Pen.Color:= clBlack;
              PolyLine([Point(9, Y +9), Point(11, Y +11), Point(16, Y +6)]);
              PolyLine([Point(9, Y +10), Point(11, Y +12), Point(16, Y +7)]);

              Pen.Color:= clWhite;
              PolyLine([Point(8, Y +9), Point(8, Y +10), Point(11, Y +13),
                        Point(16, Y +8), Point(16, Y +6)]);

              Pen.Color:= clSilver;
              PolyLine([Point(9, Y +8), Point(11, Y +10), Point(16, Y +5)]);

            end;
          end;
        end
        else
          if UseMenuItemBitmaps
          and (MenuItemInfo.hbmpUnChecked <> 0) then begin

            if SelectedIndex = I then begin
              Brush.Color:= clMenu;
              R:= Rect(3, Y, H +4, Y + H);
              FillRect(R);
              Dec(R.Right);
              DrawEdge(Handle, R, bdr_RaisedInner, bf_Rect);
            end;

            SelectObject(BitmapDC, MenuItemInfo.hbmpUnchecked);
            BitBlt(Canvas.Handle, 4, Y +1, H -1, H -1, BitmapDC, 0, 0, SrcCopy);

          end;
      end;

      Inc(Y, H);
    end;

  if FromTopToBottom
  then // normal
    Canvas.Draw(Width - Buffer.Width, Height - Buffer.Height, Buffer)
  else // animation from bottom to top
    Canvas.Draw(Width - Buffer.Width, 0, Buffer);

  PaintMenu:= False;
  DeleteDC(BitmapDC);
end;


var
  X, Y: Integer;

initialization

  // create pattern
  Pattern:= TBitmap.Create;
  Pattern.Width:= 8;
  Pattern.Height:= 8;
  for Y := 0 to 7 do
    for X := 0 to 7 do
      if (Y mod 2) = (X mod 2)
      then
        Pattern.Canvas.Pixels[X, Y]:= clBtnHighlight
      else
        Pattern.Canvas.Pixels[X, Y]:= clBtnFace;

  // randomization
  Randomize;

  MouseHookHandle:= SetWindowsHookEx(wh_Mouse, MouseHook, HInstance, 0);
  KeyboardHookHandle:= SetWindowsHookEx(wh_Keyboard, KeyboardHook, HInstance, 0);

finalization
  Pattern.Free;

  UnHookWindowsHookEx(MouseHookHandle);
  UnHookWindowsHookEx(KeyboardHookHandle);

end.

