unit PARSEMAP;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ ParseMap 1.0 Type Library }
{ Version 1.0 }

interface

uses Windows, Activex, ComHelp;

const

{ Component class GUIDs }
  Class_MapLookup: TGUID = '{B8817425-4820-11D1-982A-444553540000}';

type

{ Forward declarations: Interfaces }
  IMapLookup = interface;

{ Forward declarations: CoClasses }
  MapLookup = IMapLookup;

{ IMapLookup Interface }

  IMapLookup = interface(IUnknown)
    ['{B8817424-4820-11D1-982A-444553540000}']
    function OpenMap(szfilename: PChar; dwDelta: DWORD ):HRESULT; stdcall;
    function Lookup(iAddr, iMaxSize: DWORD; token: PChar):HRESULT; stdcall;

    function AddAlocUnit(iAddr, isize: SYSINT; dw_bp: UINT):HRESULT; stdcall;

    function RemoveAllocUnit(iAddr: SYSINT):HRESULT; stdcall;
    function ReallocUnit(ioldaddr, iAddr, isize: SYSINT):HRESULT; stdcall;
    function DumpLeaks:HRESULT; stdcall;
  end;

{ MapLookup Class }

  CoMapLookup = class
    class function Create: IMapLookup;
  end;



implementation


class function CoMapLookup.Create: IMapLookup;
begin
  if Failed(CoCreateInstance(Class_MapLookup, nil, CLSCTX_INPROC_SERVER, IMapLookup, Result)) then
    Result := nil;
end;
// I need to call CoInitialize, because ComObj may always allocate memory.
initialization
  CoInitialize(nil);
// Next string will disable any COM Security on Windows 95 systems. See ComHelp.pas
// for explanation.
  EnableAuthentification95;
finalization
  CoUninitialize;
end.
