///////////////////////////////////////////////////////////////////////////////
// This unit must be included in first string in "uses" clause of your project
//  main module (*.dpr). You can reach it through   View/Project Source.
//  You Must run application under any Debugger, that can recieve Debug Messages.
//  For example MS WinDbg available for free download from Microsoft.
//
unit MemDebug;

interface
  procedure SetMDebugState(aState : Boolean); // SetTo True to enable
//  debug messages for each allocation - reallocation.
  function GetUsedSize: Integer;

// How much heap is used

implementation
uses
  Windows, Parsemap;

// from \SOURCE\RTL\SYS\getmem.inc
type
  PUsed = ^TUsed;
  TUsed = record
    sizeFlags: Integer;
  end;




const
  cAlign        = 4;
  cThisUsedFlag = 2;
  cPrevFreeFlag = 1;
  cFillerFlag   = $80000000;
  cFlags        = cThisUsedFlag or cPrevFreeFlag or cFillerFlag;
  cSmallSize    = 4*1024;
  cDecommitMin  = 15*1024;
  peOffset = $3c;

  codename = 'CODE';
  datename = 'DATA';
var
// Base Address of 'Code' sectiom
  codeSub : Integer = 0;
//IMapLookup helper

  theMapLookup : IMapLookup = nil;

var
  Used : Integer = 0;
  ShowMemDebug : Boolean = False;

function GetUsedSize: Integer;
begin
  Result := Used;
end;

type
  PSectArray = ^TSectArray;
  TSectArray = array[0..200] of TImageSectionHeader;

procedure GetImageInfo;
var
  pImg : PImageNtHeaders;
  I : Integer;
  szmapName : array[0..255] of char;
  Sections : PSectArray;
  pSectionCode : PImageSectionHeader;
begin
  pImg := PImageNtHeaders(hInstance + PDWORD(hInstance + peOffset)^);
  OutputDebugString(PChar(pImg));
  Sections := PSectArray(PChar(pImg) + Sizeof(TImageNtHeaders));
  pSectionCode := nil;
  for I := 0 to pImg^.FileHeader.NumberOfSections - 1 do
    if ((Sections[I].Characteristics and IMAGE_SCN_CNT_CODE) <> 0) then
      pSectionCode := @Sections[I];
  if (pSectionCode <> nil) then
    codeSub := hInstance + pSectionCode.VirtualAddress;

  I := GetModuleFileName(0, szmapName, sizeof(szmapName));
  while (szmapName[I - 1] <> '\') and (szmapName[I - 1] <> '.') and (I > 0) do
  begin
    szmapName[I - 1] := #0;
    Dec(I);
  end;
  lstrcpy(szmapName + I, 'map');
  theMapLookup := CoMapLookup.Create;
  if (theMapLookup <> nil) then
  try
    theMapLookup.OpenMap(szmapName, codeSub);
  except
    theMapLookup := nil;
  end;
end;



procedure SetMDebugState(aState : Boolean);
begin
  ShowMemDebug := aState;
end;

procedure OutputFormatTheStr(formatStr : PChar; const args : array of DWORD);
var
  Buff : array[0..255] of char;
begin
  wvsprintf(Buff, formatStr,  PChar(@args[0]));
  OutputDebugString(Buff);
end;

function GetBlockSize(p: Pointer):Integer;
begin
  Result := (PUsed(PChar(p) - sizeof(TUsed)).sizeFlags and not cFlags) - sizeof(TUsed);
end;

function sGetMem(Size: Integer): Pointer;
var
  AllocSize : Integer;
  allocFrom : Integer;
  dw_ebp    : Integer;
  buf : array[0..32] of Char;
begin
  Result := SysGetMem(Size);
  AllocSize := GetBlockSize(Result);
  Used := Used + AllocSize;
  if ShowMemDebug then
  begin
   asm
     mov     edx,[ebp.8]
     sub     edx,[codeSub]
     mov     [allocFrom],edx
   end;
   if(theMapLookup <> nil) then
   begin
     theMapLookup.Lookup( allocFrom, sizeof(buf), buf);
       OutputFormatTheStr(#13#10'total = 0x%08X; Allocated = 0x%08X, Addr = 0x%08X, Req = 0x%08X, From %s(0x%08X)',
     [Used, AllocSize, DWORD(Result), Size, Longint(@buf), allocFrom]);
   end
   else
     OutputFormatTheStr(#13#10'total = 0x%08X; Allocated = 0x%08X, Addr = 0x%08X, Req = 0x%08X, From (0x%08X)',
   [Used, AllocSize, DWORD(Result), Size, allocFrom]);
  end;
  if(theMapLookup <> nil) then
  begin
    asm
     mov     [dw_ebp], ebp
    end;
    theMapLookup.AddAlocUnit(DWORD(Result), Size, dw_ebp);
  end;
end;

function sFreeMem(P: Pointer): Integer;
var
  OldSize : Integer;
begin
  OldSize := GetBlockSize(p);
  Used := Used - OldSize;
  if ShowMemDebug then
    OutputFormatTheStr(#13#10'total = 0x%08X; --Free--- = 0x%08X, Addr = 0x%08X',[Used, OldSize, DWORD(P)]);
  Result := SysFreeMem(P);

  if(theMapLookup <> nil) then
  begin
    theMapLookup.RemoveAllocUnit(DWORD(P));
  end;
end;

function sReallocMem(P: Pointer; Size: Integer): Pointer;
var
  OldSize : Integer;
  AllocSize : Integer;
begin
  OldSize := GetBlockSize(p);
  Result := SysReallocMem(P, Size);
  AllocSize := GetBlockSize(Result);
  Used := Used + AllocSize - OldSize;
  if ShowMemDebug then
    OutputFormatTheStr(#13#10'total = 0x%08X; ReAllocat = 0x%08X, Addr = 0x%08X to 0x%08X, Addr = 0x%08X',
      [Used, OldSize, DWORD(P), AllocSize, DWORD(Result)]);

  if(theMapLookup <> nil) then
  begin
    theMapLookup.ReallocUnit(DWORD(P), DWORD(Result), AllocSize);
  end;
end;




var
  OldMMngr : TMemoryManager;
  MMngr : TMemoryManager =
  (GetMem: sGetMem;FreeMem:sFreeMem;ReallocMem:sReallocMem);


initialization
  GetImageInfo;
  GetMemoryManager(OldMMngr);
  SetMemoryManager(MMngr);
finalization
  if(theMapLookup <> nil) then
  begin
    theMapLookup.DumpLeaks();
    theMapLookup := nil;
  end;
  SetMemoryManager(OldMMngr);
  OutputFormatTheStr(#13#10'__THE_END__ total = 0x%08X',[Used]);
end.
