{* Author: Jimmy Rasmussen
	   Eurosoft Danmark ApS
	   Rosenkaeret 11C
	   2860 Soeborg.

  e-mail: Jimmy@eurosoft.dk

This Component where created with the help of Robert Rossmair's source to a
MDIwallpaper component.
It will also work with normal forms.
*}
unit MDIImage;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  EMDIImageError = class(Exception);

  TMDIImage = class(TImage)
  private
    { Private declarations }
    FClientInstance: Pointer;
    FDefClientProc: TFarProc;
    FCenter : Boolean;
    Function GetClient: TForm;
    Function GetClientHandle: hWnd;
    Procedure SetFCenter(Value : Boolean);
    procedure ConnectToClient;
    Procedure ClientWndProc(var Message: TMessage);
  protected
    destructor Destroy; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    property Client: TForm read GetClient;
    property ClientHandle: hWnd read GetClientHandle;
  published
    { Published declarations }
    Property Picture;
    Property Top;
    Property Left;
    Property Height;
    Property Width;
    //Center the bitmap True, False;
    Property Center : Boolean Read FCenter Write SetFCenter;
  end;

procedure Register;

implementation

procedure Error(Text: string);
var
  StackTop: record end;
  Stack: record
    EBP: Integer;
    ReturnAddress: Pointer;
  end absolute StackTop;
begin
  raise EMDIImageError.Create(Text) at Stack.ReturnAddress;
end;

constructor TMDIImage.Create(AOwner: TComponent);
Var
  i: Integer;
Begin
  if not (AOwner is TForm) then
    Error('not (TMDIImage.Owner is TForm)!')
  else with AOwner do for i := 0 to ComponentCount-1 do if Components[i] is TMDIImage then
    Error('Only one instance of TMDIImage allowed');
  inherited Create(AOwner);
  TForm(Owner).HandleNeeded;
  FCenter:=False;
  ConnectToClient;
End;

Destructor TMDIImage.Destroy;
begin
  if Assigned(Owner) and not (csDesigning in ComponentState) then
  begin
    if Client.HandleAllocated then
    begin
      if SetWindowLong(ClientHandle, GWL_WNDPROC, Longint(FDefClientProc)) <> Longint(FClientInstance)
      then Error('Internal Error in TMDIImage.Destroy');
      FreeObjectInstance(FClientInstance);
    end
    else FreeObjectInstance(FDefClientProc);
  end;
  inherited;
end;

procedure TMDIImage.ClientWndProc(var Message: TMessage);
  procedure Default;
  begin
    with Message do
      Result := CallWindowProc(FDefClientProc, ClientHandle, Msg, wParam, lParam);
  end;
var
  W, H, CBitWidth, CBitHeight : Integer;
  R: TRect;
begin
  with Message do
    If (Picture.Bitmap.Height > 0) And (Picture.Bitmap.Width > 0) Then Begin
      if Msg = WM_ERASEBKGND then Begin
        with Client.Canvas do begin
          Handle := TWMEraseBkGnd(Message).DC;
          Brush := Client.Brush;
          Windows.GetClientRect(ClientHandle, R);
          W := R.Right-R.Left;
          H := R.Bottom-R.Top;
	  FillRect(Rect(0, 0, W, H));//Renser baggrunden
          If FCenter Then Begin
            CBitWidth := Picture.Bitmap.Width;
            CBitHeight := Picture.Bitmap.Height;
            H := H SHR 1; // DIV 2
            W := W SHR 1; // DIV 2
            CBitWidth :=CBitWidth Div 2;
            CBitHeight:=CBitHeight Div 2;
            Left := W-CBitWidth;
            Top  := H-CBitHeight;
          End;
          Draw(Left, Top,Picture.Bitmap);
          Result := 1;
          Exit;
        End;
      End;
    End;
  Default;
end;

Procedure TMDIImage.SetFCenter(Value : Boolean);
Begin
  If Value <> FCenter Then Begin
    FCenter := Value;
    InValidate;
  End;
End;

function TMDIImage.GetClient: TForm;
begin
  Result := TForm(Owner);
end;

function TMDIImage.GetClientHandle: hWnd;
begin
  with Client do
  if ClientHandle <> 0
    then Result := ClientHandle
  else Result := Handle;
end;

procedure TMDIImage.ConnectToClient;
{ This is the dirty way, but heck, who knows a better one? }
begin
  if csDesigning in ComponentState then Exit;
  FClientInstance := MakeObjectInstance(ClientWndProc);
  FDefClientProc := Pointer(GetWindowLong(ClientHandle, GWL_WNDPROC));
  SetWindowLong(ClientHandle, GWL_WNDPROC, Longint(FClientInstance));
end;

procedure Register;
begin
  RegisterComponents('3rd party', [TMDIImage]);
end;

end.
