unit kFQuery;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DBCtrls, Grids, DBGrids, Mask, Buttons,db;

type
  TFQuery = class(TForm)
    DBEdit1: TDBEdit;
    Label1: TLabel;
    DBGrid1: TDBGrid;
    Label2: TLabel;
    Button1: TButton;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBComboBox1: TDBComboBox;
    Label4: TLabel;
    DBEdit3: TDBEdit;
    Label5: TLabel;
    DBMemo1: TDBMemo;
    Label6: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function Execute:Integer;
    procedure SetQueriesSource(s:TDataSource);
    procedure SetParamsSource(s:TDataSource);
  end;

var
  FormQuery: TFQuery;

implementation

{$R *.DFM}

procedure TFQuery.SetQueriesSource(s:TDataSource);
begin
DBEdit1.DataSource:=s;
DBMemo1.DataSource:=s;
end;

procedure TFQuery.SetParamsSource(s:TDataSource);
begin
DBGrid1.DataSource:=s;
DBEdit2.DataSource:=s;
DBComboBox1.DataSource:=s;
DBEdit3.DataSource:=s;
end;

function TFQuery.Execute:integer;
begin
Result:=ShowModal;
end;


procedure TFQuery.Button1Click(Sender: TObject);
begin
if (DBEdit1.DataSource.DataSet.State in [dsEdit,dsInsert]) then
   DBEdit1.DataSource.DataSet.Post;
if (DBGrid1.DataSource.DataSet.State in [dsEdit,dsInsert]) then
   DBGrid1.DataSource.DataSet.Post;
end;

procedure TFQuery.Button2Click(Sender: TObject);
begin
DBEdit1.DataSource.DataSet.Cancel;
// work - deleting list of added or deleted parameters
end;


procedure TFQuery.BitBtn1Click(Sender: TObject);
begin
DBGRid1.DataSource.DataSet.Append;
end;

procedure TFQuery.BitBtn2Click(Sender: TObject);
begin
DBGRid1.DataSource.DataSet.Delete;
end;

end.
