unit MathFns;

interface

implementation
uses Math;

//This one use symmetry to correctly calculate odd roots.  It gets over a little log problem //with the power function.  It's a real cheat but there you go.

function root(base,exponent:extended):extended;
Var
  neg,even:boolean;
  r:integer;
begin
  neg:=False;
  even:=False;
  r:=trunc(exponent);
    If base<0 then
       Begin
        If r mod 2=0 then even:=True;
        If even=False then base:=Abs(base);
        neg:=True;
       end;
If neg and (even=False) then
    root := -Power(base, 1/exponent)
else
    root := Power(base, 1/exponent);
end;

function rnd(arg1:double):double;
Begin
    result := Random * int(arg1);
end;

function arcsinh(arg1:double):double;
begin
       result:=Ln(arg1+sqrt(1+power(arg1,2)));
end;

function arccosh(arg1:double):double;
begin
       result :=Ln(arg1+sqrt(power(arg1,2)-1));
end;

function arctanh(arg1:double):double;
begin
       result :=Ln((1+arg1)/(1-arg1))/2;
end;

function arcsech(arg1:double):double;
begin
       result :=Ln((1/arg1)+sqrt(power((1/arg1),2)-1));
end;

function arccosech(arg1:double):double;
begin
       result :=Ln((1/arg1)+sqrt(1+power((1/arg1),2)));
end;

function arccoth(arg1:double):double;
begin
       result :=Ln((1+(1/arg1))/(1-(1/arg1)))/2;
end;

function degarcsin(arg1:double):double;
begin
       result :=arcsin(DegToRad(arg1));
end;

function arcsec(arg1:double):double;
begin
    result  := arccos(1/arg1);
end;

function degarcsec(arg1:double):double;
begin
    result := RadToDeg(arccos(1/arg1));
end;

function arccosec(arg1:double):double;
begin
    result  := arcsin(1/arg1);
end;

function degarccosec(arg1:double):double;
begin
    result  := RadToDeg(arcsin(1/arg1));
end;

function degarccos(arg1:double):double;
begin
       result :=arccos(DegToRad(arg1));
end;

function arccot(arg1:double):double;
begin
    result  := arctan(1/arg1);
end;

function degarccot(arg1:double):double;
begin
    result  := RadToDeg(arctan(1/arg1));
end;


function cosech(arg1:double):double;
begin
    result  := 2/(exp(arg1)-exp(-arg1));
end;


function sech(arg1:double):double;
begin
    result  := 2/(exp(arg1)+exp(-arg1));
end;



function tanh(arg1:double):double;
begin
    result  := (exp(arg1)-exp(arg1))/(exp(arg1)+exp(-arg1));
end;


function coth(arg1:double):double;
begin
    result := (exp(arg1)+exp(arg1))/(exp(arg1)-exp(-arg1));
end;

function degarctan(arg1:double):double;
begin
    result:= RadToDeg(arctan(arg1));
end;

function arg(arg1,arg2:double):double;
begin
    if arg1 < 0 then
      result := arctan(arg2/arg1)+Pi
    else
      if arg1>0 then
        result  := arctan(arg2/arg1)
      else
        if arg2 > 0 then
          result  := 0.5 * Pi
        else
          result := -0.5 * Pi;
end;

function sinh(arg1:double):double;
begin
    result := (exp(arg1)-exp(-arg1))*0.5;
end;

function cosh(arg1:double):double;
begin
    result  := (exp(arg1)+exp(-arg1))*0.5;
end;


function cot(arg1:double):double;
begin
      if Abs(arg1)>0.000000001 then result  := cotan(arg1) else result :=100000;
end;

function cotrad(arg1:double):double;
begin
    result := cotan(DegToRad(arg1));
end;


function sec(arg1:double):double;
begin
    result := 1/cos(arg1);
end;

function cosec(arg1:double):double;
begin
   if Abs(arg1)>0.000000001 then result:= 1/sin(arg1) else result:=1000000;
end;


function tanrad(arg1:double):double;
begin
    result  := tan(DegToRad(arg1));
end;

function sinrad(arg1:double):double;
begin
    result  := sin(DegToRad(arg1));
end;

function cosrad(arg1:double):double;
begin
    result := cos(DegToRad(arg1));
end;


function cosecrad(arg1:double):double;
begin
    result  := 1/sin(DegToRad(arg1));
end;


function secrad(arg1:double):double;
begin
    result:= 1/cos(DegToRad(arg1));
end;


//This is the Blancmange function which is continuous everywhere and differentiable nowhere.
function blanc(arg1:double):double;
Var
   temp,res:extended;
   count:integer;
begin
  Begin
  res:=0;
   for count := 0 to 49 do
   begin
     arg1:=arg1-int(arg1-(Ord(arg1<0)));
     if (arg1)<0.5 then temp:=(arg1) else temp:=(1-arg1);
     res:=res+ temp/(power(2,count));
     arg1:=2*arg1;
   end;
  end;
  result:=res;
end;

function min(arg1,arg2:double):double;
begin
    if arg1 < arg2 then
      result  := arg1
    else
      result := arg2;
end;

function max(arg1,arg2:double):double;
begin
    if arg1 < arg2 then
      result  := arg2
    else
      result  := arg1;
end;

function heaviside(arg1:double):double;
begin
    if arg1 < 0 then
      result := 0
    else
      result  := 1;
end;

function sign(arg1:double):double;
begin
    if arg1 < 0 then
      result := -1
    else
      if arg1 > 0 then
        result := 1.0
      else
        result := 0.0;
end;

function zero(arg1:double):double;
begin
    if arg1 = 0.0 then
      result := 0.0
    else
      result:= 1.0;
end;


function ceil(arg1:double):double;
begin
    if frac(arg1) > 0 then
      result:= int(arg1 + 1)
    else
      result:= int(arg1);
end;

function floor(arg1:double):double;
begin
    if frac(arg1) < 0 then
      result:= int(arg1 - 1)
    else
      result:= int(arg1);
end;




function radius(arg1,arg2:double):double;
begin
    result:= sqrt(sqr(arg1)+sqr(arg2));
end;


end.
