{++

  t n e f . p a s

  Abstract:

    Automatic conversion of tnef.h.

  Comments:

    This source file automatically converted by
    htrans 0.91 beta 1 Copyright (c) 1997 Alexander Staubo

  Revision history:

    18-06-1997 20:53 alex  [Autogenerated]
    18-06-1997 20:53 alex  Retouched for release

--}

unit Tnef;

{$A+}
{$MINENUMSIZE 4}

interface

uses
  Windows, SysUtils, ActiveX,
  MapiDefs, MapiGuid, MapiX;

(*
 *  T N E F . H
 *
 *
 *  This file contains structure and function definitions for the
 *  MAPI implementation of the Transport Neutral Encapsilation Format
 *  used by MAPI providers for the neutral serialization of a MAPI
 *  message.  This implementation sits on top of the IStream object as
 *  documented in the OLE 2 Specs.
 *
 *  Copyright 1986-1996 Microsoft Corporation. All Rights Reserved.
 *)

{ ------------------------------------ }

{ TNEF Problem and TNEF Problem Arrays }

{ ------------------------------------ }

type
  TSTnefProblem =     
    record
      ulComponent : ULONG;
      ulAttribute : ULONG;
      ulPropTag : ULONG;
      scode : SCODE;
    end;
    
  TSTnefProblemArray =     
    record
      cProblem : ULONG;
      aProblem : array[0..MAPI_DIM - 1] of TSTnefProblem;
    end;
    
  PSTnefProblemArray = ^TSTnefProblemArray;
  
{ Pointers to TNEF Interface ---------------------------------------- }

{  OpenTNEFStream }

const
  TNEF_DECODE = (ULONG(0));
  TNEF_ENCODE = (ULONG(2));
  TNEF_PURE = (ULONG($00010000));
  TNEF_COMPATIBILITY = (ULONG($00020000));
  TNEF_BEST_DATA = (ULONG($00040000));
  TNEF_COMPONENT_ENCODING = (ULONG($80000000));

{  AddProps, ExtractProps }

const
  TNEF_PROP_INCLUDE = (ULONG($00000001));
  TNEF_PROP_EXCLUDE = (ULONG($00000002));
  TNEF_PROP_CONTAINED = (ULONG($00000004));
  TNEF_PROP_MESSAGE_ONLY = (ULONG($00000008));
  TNEF_PROP_ATTACHMENTS_ONLY = (ULONG($00000010));
  TNEF_PROP_CONTAINED_TNEF = (ULONG($00000040));

{  FinishComponent }

const
  TNEF_COMPONENT_MESSAGE = (ULONG($00001000));
  TNEF_COMPONENT_ATTACHMENT = (ULONG($00002000));

type
  ITnef =
    interface(IUnknown)
    [strIID_ITnef]
      function QueryInterface (riid : PIID; var ppvObj : Pointer) : HResult; stdcall;
      function AddRef : ULONG; stdcall;
      function Release : ULONG; stdcall;
      function AddProps (ulFlags : ULONG; ulElemID : ULONG; lpvData : Pointer; 
        lpPropList : PSPropTagArray) : HResult; stdcall;
      function ExtractProps (ulFlags : ULONG; lpPropList : PSPropTagArray; 
        var lpProblems : PSTnefProblemArray) : HResult; stdcall;
      function Finish (ulFlags : ULONG; var lpKey : Word; 
        var lpProblems : PSTnefProblemArray) : HResult; stdcall;
      function OpenTaggedBody (lpMessage : IMessage; ulFlags : ULONG; 
        var lppStream : IStream) : HResult; stdcall;
      function SetProps (ulFlags : ULONG; ulElemID : ULONG; cValues : ULONG; 
        lpProps : PSPropValue) : HResult; stdcall;
      function EncodeRecips (ulFlags : ULONG; lpRecipientTable : IMAPITable) : HResult; stdcall;
      function FinishComponent (ulFlags : ULONG; ulComponentID : ULONG; 
        lpCustomPropList : PSPropTagArray; lpCustomProps : PSPropValue; 
        lpPropList : PSPropTagArray; var lpProblems : PSTnefProblemArray) : HResult; stdcall;
    end;

function OpenTnefStream (lpvSupport : Pointer; lpStream : IStream;
  lpszStreamName : PChar; ulFlags : ULONG; lpMessage : IMessage;
  wKeyVal : Word; var lppTNEF : ITnef) : HResult; stdcall;

type
  TOPENTNEFSTREAM = function (lpvSupport : Pointer; lpStream : IStream;
    lpszStreamName : PChar; ulFlags : ULONG; lpMessage : IMessage;
    wKeyVal : Word; var lppTNEF : ITnef) : HResult; stdcall;

  POPENTNEFSTREAM = ^TOPENTNEFSTREAM;

function OpenTnefStreamEx (lpvSupport : Pointer; lpStream : IStream; 
  lpszStreamName : PChar; ulFlags : ULONG; lpMessage : IMessage;
  wKeyVal : Word; lpAdressBook : IAddrBook;
  var lppTNEF : ITnef) : HResult; stdcall;

type
  TOPENTNEFSTREAMEX = function (lpvSupport : Pointer; lpStream : IStream;
    lpszStreamName : PChar; ulFlags : ULONG; lpMessage : IMessage;
    wKeyVal : Word; lpAdressBook : IAddrBook; var lppTNEF : ITnef) : HResult; stdcall;

  POPENTNEFSTREAMEX = ^TOPENTNEFSTREAMEX;

function GetTnefStreamCodepage (lpStream : IStream; var lpulCodepage : ULONG;
  var lpulSubCodepage : ULONG) : HResult; stdcall;

type
  PGETTNEFSTREAMCODEPAGE = function (lpStream : IStream; var lpulCodepage : ULONG; 
    var lpulSubCodepage : ULONG) : HResult; stdcall;

{!! String renamed with "str" prefix }

const
  strOPENTNEFSTREAM = 'OpenTnefStream';
  strOPENTNEFSTREAMEX = 'OpenTnefStreamEx';
  strGETTNEFSTREAMCODEPAGE = 'GetTnefStreamCodePage';

{ -------------------------- }

{ TNEF Signature and Version }

{ -------------------------- }

const
  TNEF_SIGNATURE = (ULONG($223E9F78));
  TNEF_VERSION = (ULONG((ULONG(1) and $FFFF shl 16) or (ULONG(0) and $FFFF)));

{ ------------------------------------------- }

{ TNEF Down-level Attachment Types/Structures }

{ ------------------------------------------- }

type
  TATYP = Word;

//!! Enum converted to constants

const
  atypNull = 0;
  atypFile = 1;
  atypOle = 2;
  atypPicture = 3;
  atypMax = 4;

const
  MAC_BINARY = (DWORD($00000001));

{!! #pragma pack(1) converted to this directive }
{$A-}

type
  TRENDDATA =     
    record
      atyp : TATYP;
      ulPosition : ULONG;
      dxWidth : Word;
      dyHeight : Word;
      dwFlags : DWORD;
    end;
    
  TPRENDDATA = ^TRENDDATA;

{ ----------------------------------- }

{ TNEF Down-level Date/Time Structure }

{ ----------------------------------- }

  TDTR =
    record
      wYear : Word;
      wMonth : Word;
      wDay : Word;
      wHour : Word;
      wMinute : Word;
      wSecond : Word;
      wDayOfWeek : Word;
    end;

{!! #pragma pack() converted to this directive }
{$A+}

{ ----------------------------- }

{ TNEF Down-level Message Flags }

{ ----------------------------- }

const
  fmsNull = (Byte($00));
  fmsModified = (Byte($01));
  fmsLocal = (Byte($02));
  fmsSubmitted = (Byte($04));
  fmsRead = (Byte($20));
  fmsHasAttach = (Byte($80));

{ ----------------------------------------- }

{ TNEF Down-level Triple Address Structures }

{ ----------------------------------------- }

const
  trpidNull = (Word($0000));
  trpidUnresolved = (Word($0001));
  trpidResolvedNSID = (Word($0002));
  trpidResolvedAddress = (Word($0003));
  trpidOneOff = (Word($0004));
  trpidGroupNSID = (Word($0005));
  trpidOffline = (Word($0006));
  trpidIgnore = (Word($0007));
  trpidClassEntry = (Word($0008));
  trpidResolvedGroupAddress = (Word($0009));

type
  TTRP =     
    record
      trpid : Word;
      cbgrtrp : Word;
      cch : Word;
      cbRgb : Word;
    end;
    
  TPTRP = ^TTRP;
  
  TPGRTRP = ^TPTRP;
  
  PTRP = ^TPGRTRP;
  
  TXTYPE = DWORD;
  
const
  xtypeUnknown = (TXTYPE(0));
  xtypeInternet = (TXTYPE(6));
  cbDisplayName = 41;
  cbEmailName = 11;
  cbSeverName = 12;

type
  TADDRALIAS =     
    record
      rgchName : array[0..cbDisplayName - 1] of Char;
      rgchEName : array[0..cbEmailName - 1] of Char;
      rgchSrvr : array[0..cbSeverName - 1] of Char;
      dibDetail : ULONG;
      _type : Word;  //!! Member "type" renamed to "_type"
    end;
    
  PADDRALIAS = ^TADDRALIAS;
  
const
{!! This construct refers to a non-existent identifier (ALIAS):
  cbALIAS = SizeOf(ALIAS);
}
  cbTYPE = 16;
  cbMaxIdData = 200;

type
  TNSID =
    record
      dwSize : DWORD;
      uchType : array[0..cbTYPE - 1] of Char;
      xtype : TXTYPE;
      lTime : Longint;
      address :         
        record
          case Integer of
            1 : 
              (
                alias : TADDRALIAS;
              );
            2 : 
              (
                rgchInterNet : array[0..1 - 1] of Char;
              );
        end;
    end;
    
  PNSID = ^TNSID;
  
const
  cbNSID = SizeOf(TNSID);

{ -------------------------- }

{ TNEF Down-level Priorities }

{ -------------------------- }

const
  prioLow = 3;
  prioNorm = 2;
  prioHigh = 1;

{ ------------------------------------- }

{ TNEF Down-level Attributes/Properties }

{ ------------------------------------- }

const
  atpTriples = (Word($0000));
  atpString = (Word($0001));
  atpText = (Word($0002));
  atpDate = (Word($0003));
  atpShort = (Word($0004));
  atpLong = (Word($0005));
  atpByte = (Word($0006));
  atpWord = (Word($0007));
  atpDword = (Word($0008));
  atpMax = (Word($0009));

  LVL_MESSAGE = (Byte($01));
  LVL_ATTACHMENT = (Byte($02));

const
  attNull = (DWORD(0) shl 16) or WORD($0000);
  attFrom = (DWORD(atpTriples) shl 16) or WORD($8000); { PR_ORIGINATOR_RETURN_ADDRESS }
  attSubject = (DWORD(atpString) shl 16) or WORD($8004); { PR_SUBJECT }
  attDateSent = (DWORD(atpDate) shl 16) or WORD($8005); { PR_CLIENT_SUBMIT_TIME }
  attDateRecd = (DWORD(atpDate) shl 16) or WORD($8006); { PR_MESSAGE_DELIVERY_TIME }
  attMessageStatus = (DWORD(atpByte) shl 16) or WORD($8007); { PR_MESSAGE_FLAGS }
  attMessageClass = (DWORD(atpWord) shl 16) or WORD($8008); { PR_MESSAGE_CLASS }
  attMessageID = (DWORD(atpString) shl 16) or WORD($8009); { PR_MESSAGE_ID }
  attParentID = (DWORD(atpString) shl 16) or WORD($800A); { PR_PARENT_ID }
  attConversationID = (DWORD(atpString) shl 16) or WORD($800); { PR_CONVERSATION_ID }
  attBody = (DWORD(atpText) shl 16) or WORD($800C); { PR_BODY }
  attPriority = (DWORD(atpShort) shl 16) or WORD($800D); { PR_IMPORTANCE }
  attAttachData = (DWORD(atpByte) shl 16) or WORD($800F); { PR_ATTACH_DATA_xxx }
  attAttachTitle = (DWORD(atpString) shl 16) or WORD($8010); { PR_ATTACH_FILENAME }
  attAttachMetaFile = (DWORD(atpByte) shl 16) or WORD($8011); { PR_ATTACH_RENDERING }
  attAttachCreateDate = (DWORD(atpDate) shl 16) or WORD($8012); { PR_CREATION_TIME }
  attAttachModifyDate = (DWORD(atpDate) shl 16) or WORD($8013); { PR_LAST_MODIFICATION_TIME }
  attDateModified = (DWORD(atpDate) shl 16) or WORD($8020); { PR_LAST_MODIFICATION_TIME }
  attAttachTransportFilename = (DWORD(atpByte) shl 16) or WORD($9001); { PR_ATTACH_TRANSPORT_NAME }
  attAttachRenddata = (DWORD(atpByte) shl 16) or WORD($9002);
  attMAPIProps = (DWORD(atpByte) shl 16) or WORD($9003);
  attRecipTable = (DWORD(atpByte) shl 16) or WORD($9004); { PR_MESSAGE_RECIPIENTS }
  attAttachment = (DWORD(atpByte) shl 16) or WORD($9005);
  attTnefVersion = (DWORD(atpDword) shl 16) or WORD($9006);
  attOemCodepage = (DWORD(atpByte) shl 16) or WORD($9007);
  attOriginalMessageClass = (DWORD(atpWord) shl 16) or WORD($0006); { PR_ORIG_MESSAGE_CLASS }
  attOwner = (DWORD(atpByte) shl 16) or WORD($0000); { PR_RCVD_REPRESENTING_xxx
    or PR_SENT_REPRESENTING_xxx }
  attSentFor = (DWORD(atpByte) shl 16) or WORD($0001); { PR_SENT_REPRESENTING_xxx }
  attDelegate = (DWORD(atpByte) shl 16) or WORD($0002); { PR_RCVD_REPRESENTING_xxx }
  attDateStart = (DWORD(atpDate) shl 16) or WORD($0006); { PR_DATE_START }
  attDateEnd = (DWORD(atpDate) shl 16) or WORD($0007); { PR_DATE_END }
  attAidOwner = (DWORD(atpLong) shl 16) or WORD($0008); { PR_OWNER_APPT_ID }
  attRequestRes = (DWORD(atpShort) shl 16) or WORD($0009); { PR_RESPONSE_REQUESTED }

implementation

const
  Mapi32Dll = 'mapi32.dll';

function OpenTnefStream; external Mapi32Dll name 'OpenTnefStream';
function OpenTnefStreamEx; external Mapi32Dll name 'OpenTnefStreamEx';
function GetTnefStreamCodepage; external Mapi32Dll name 'GetTnefStreamCodepage';

end.

