{++

  m a p i d e f s . p a s

  Abstract:

    Automatic conversion of mapidefs.h.

  Comments:

    This source file automatically converted by
    htrans 0.91 beta 1 Copyright (c) 1997 Alexander Staubo

  Revision history:

    18-06-1997 20:53 alex  [Autogenerated]
    18-06-1997 20:53 alex  Retouched for release

--}

unit MapiDefs;

{$A+}
{$MINENUMSIZE 4}

interface

uses
  Windows, SysUtils, ActiveX,
  MapiGuid;

(*
 *  M A P I D E F S . H
 *
 *  Definitions used by MAPI clients and service providers.
 *
 *  Copyright 1986-1996 Microsoft Corporation. All Rights Reserved.
 *)

{ Array dimension for structures with variable-sized arrays at the end. }

const
  MAPI_DIM = 1;

const
  MAPI_NT_SERVICE = ULONG($00010000)   { Provider is being loaded in an NT service }
  ;

{ Simple data types }

type
  TWCHAR = Word;
  
{$IFDEF UNICODE}

type
  TTCHAR = TWCHAR;
  
{$ELSE}

type
  TTCHAR = Char;
  
{$ENDIF}

type
  PWSTR = ^TWCHAR;
  
  PCWSTR = ^TWCHAR;

  PTSTR = ^TTCHAR;
  
  PCTSTR = ^TTCHAR;
  
  PBYTE = ^Byte;
  
                                       { defined MIDL_PASS }

type
  PULONG = ^ULONG;

type
  TLHANDLE = Longint;

  PLHANDLE = ^TLHANDLE;

type
  TFILETIME =     
    record
      dwLowDateTime : DWORD;
      dwHighDateTime : DWORD;
    end;
    
  PFILETIME = ^TFILETIME;

(*
 *  This flag is used in many different MAPI calls to signify that
 *  the object opened by the call should be modifiable (MAPI_MODIFY).
 *  If the flag MAPI_MAX_ACCESS is set, the object returned should be
 *  returned at the maximum access level allowed.  An additional
 *  property available on the object (PR_ACCESS_LEVEL) uses the same
 *  MAPI_MODIFY flag to say just what this new access level is.
 *)

const
  MAPI_MODIFY = ULONG($00000001);

(*
 *  The following flags are used to indicate to the client what access
 *  level is permissible in the object. They appear in PR_ACCESS in
 *  message and folder objects as well as in contents and associated
 *  contents tables
 *)

const
  MAPI_ACCESS_MODIFY = ULONG($00000001);
  MAPI_ACCESS_READ = ULONG($00000002);
  MAPI_ACCESS_DELETE = ULONG($00000004);
  MAPI_ACCESS_CREATE_HIERARCHY = ULONG($00000008);
  MAPI_ACCESS_CREATE_CONTENTS = ULONG($00000010);
  MAPI_ACCESS_CREATE_ASSOCIATED = ULONG($00000020);

(*
 *  The MAPI_UNICODE flag is used in many different MAPI calls to signify
 *  that strings passed through the interface are in Unicode (a 16-bit
 *  character set). The default is an 8-bit character set.
 *
 *  The value fMapiUnicode can be used as the 'normal' value for
 *  that bit, given the application's default character set.
 *)

const
  MAPI_UNICODE = ULONG($80000000);

{$IFDEF UNICODE}

const
  fMapiUnicode = MAPI_UNICODE;

{$ELSE}

const
  fMapiUnicode = 0;

{$ENDIF}

{ successful HRESULT }

const
  hrSuccess = 0;

{ Recipient types }

const
  MAPI_ORIG = 0                        { Recipient is message originator          }
  ;
  MAPI_TO = 1                          { Recipient is a primary recipient         }
  ;
  MAPI_CC = 2                          { Recipient is a copy recipient            }
  ;
  MAPI_BCC = 3                         { Recipient is blind copy recipient        }
  ;
  MAPI_P1 = $10000000                  { Recipient is a P1 resend recipient       }
  ;
  MAPI_SUBMITTED = $80000000           { Recipient is already processed         }
  ;

{ #define MAPI_AUTHORIZE 4        recipient is a CMC authorizing user      }

{#define MAPI_DISCRETE 0x10000000 Recipient is a P1 resend recipient       }

{ Bit definitions for abFlags[0] of ENTRYID }

const
  MAPI_SHORTTERM = $80;
  MAPI_NOTRECIP = $40;
  MAPI_THISSESSION = $20;
  MAPI_NOW = $10;
  MAPI_NOTRESERVED = $08;

{ Bit definitions for abFlags[1] of ENTRYID }

const
  MAPI_COMPOUND = $80;

{ ENTRYID }

type
  TENTRYID =     
    record
      abFlags : array[0..4 - 1] of Byte;
      ab : array[0..MAPI_DIM - 1] of Byte;
    end;
    
  PENTRYID = ^TENTRYID;
  
{ Byte-order-independent version of GUID (world-unique identifier) }

type
  TMAPIUID =     
    record
      ab : array[0..16 - 1] of Byte;
    end;
    
  PMAPIUID = ^TMAPIUID;
  
{ Note:  need to include C run-times (memory.h) to use this macro }

(*
 * Constants for one-off entry ID:
 * The MAPIUID that identifies the one-off provider;
 * the flag that defines whether the embedded strings are Unicode;
 * the flag that specifies whether the recipient gets TNEF or not.
 *)

const
  MAPI_ONE_OFF_UID : array[0..15] of Integer =
    (
      $81, $2b, $1f, $a4, $be, $a3, $10, $19, $9d, $6e, $00, $dd, $01, 
      $0f, $54, $02
    );
  MAPI_ONE_OFF_UNICODE = $8000;
  MAPI_ONE_OFF_NO_RICH_INFO = $0001;

{ Object type }

const
  MAPI_STORE = ULONG($00000001)        { Message Store }
  ;
  MAPI_ADDRBOOK = ULONG($00000002)     { Address Book }
  ;
  MAPI_FOLDER = ULONG($00000003)       { Folder }
  ;
  MAPI_ABCONT = ULONG($00000004)       { Address Book Container }
  ;
  MAPI_MESSAGE = ULONG($00000005)      { Message }
  ;
  MAPI_MAILUSER = ULONG($00000006)     { Individual Recipient }
  ;
  MAPI_ATTACH = ULONG($00000007)       { Attachment }
  ;
  MAPI_DISTLIST = ULONG($00000008)     { Distribution List Recipient }
  ;
  MAPI_PROFSECT = ULONG($00000009)     { Profile Section }
  ;
  MAPI_STATUS = ULONG($0000000A)       { Status Object }
  ;
  MAPI_SESSION = ULONG($0000000)       { Session }
  ;
  MAPI_FORMINFO = ULONG($0000000C)     { Form Information }
  ;

(*
 *  Maximum length of profile names and passwords, not including
 *  the null termination character.
 *)

const
  cchProfileNameMax = 64;
  cchProfilePassMax = 64;

{ Property Types }

const
  MV_FLAG = $1000                      { Multi-value flag }
  ;
  PT_UNSPECIFIED = ULONG(0)            { (Reserved for interface use) type doesn't matter to caller }
  ;
  PT_NULL = ULONG(1)                   { NULL property value }
  ;
  PT_I2 = ULONG(2)                     { Signed 16-bit value }
  ;
  PT_LONG = ULONG(3)                   { Signed 32-bit value }
  ;
  PT_R4 = ULONG(4)                     { 4-byte floating point }
  ;
  PT_DOUBLE = ULONG(5)                 { Floating point double }
  ;
  PT_CURRENCY = ULONG(6)               { Signed 64-bit int (decimal w/    4 digits right of decimal pt) }
  ;
  PT_APPTIME = ULONG(7)                { Application time }
  ;
  PT_ERROR = ULONG(10)                 { 32-bit error value }
  ;
  PT_BOOLEAN = ULONG(11)               { 16-bit boolean (non-zero true) }
  ;
  PT_OBJECT = ULONG(13)                { Embedded object in a property }
  ;
  PT_I8 = ULONG(20)                    { 8-byte signed integer }
  ;
  PT_STRING8 = ULONG(30)               { Null terminated 8-bit character string }
  ;
  PT_UNICODE = ULONG(31)               { Null terminated Unicode string }
  ;
  PT_SYSTIME = ULONG(64)               { FILETIME 64-bit int w/ number of 100ns periods since Jan 1,1601 }
  ;
  PT_CLSID = ULONG(72)                 { OLE GUID }
  ;
  PT_BINARY = ULONG(258)               { Uninterpreted (counted byte array) }
  ;

{ Changes are likely to these numbers, and to their structures. }

{ Alternate property type names for ease of use }

const
  PT_SHORT = PT_I2;
  PT_I4 = PT_LONG;
  PT_FLOAT = PT_R4;
  PT_R8 = PT_DOUBLE;
  PT_LONGLONG = PT_I8;

(*
 *  The type of a MAPI-defined string property is indirected, so
 *  that it defaults to Unicode string on a Unicode platform and to
 *  String8 on an ANSI or DBCS platform.
 *
 *  Macros are defined here both for the property type, and for the
 *  field of the property value structure which should be
 *  dereferenced to obtain the string pointer.
 *)

{$IFDEF UNICODE}

const
  PT_TSTRING = PT_UNICODE;
  PT_MV_TSTRING = MV_FLAG or PT_UNICODE;

{$ELSE}

const
  PT_TSTRING = PT_STRING8;
  PT_MV_TSTRING = MV_FLAG or PT_STRING8;

{$ENDIF}

{ Property Tags
 *
 * By convention, MAPI never uses 0 or FFFF as a property ID.
 * Use as null values, initializers, sentinels, or what have you.
 }

const
  PROP_TYPE_MASK = ULONG($0000FFFF)    { Mask for Property type }
  ;

const
  PROP_ID_NULL = 0;
  PROP_ID_INVALID = $FFFF;
  PR_NULL = (PT_NULL) or ((PROP_ID_NULL) shl 16);

{ Multi-valued Property Types }

const
  PT_MV_I2 = MV_FLAG or PT_I2;
  PT_MV_LONG = MV_FLAG or PT_LONG;
  PT_MV_R4 = MV_FLAG or PT_R4;
  PT_MV_DOUBLE = MV_FLAG or PT_DOUBLE;
  PT_MV_CURRENCY = MV_FLAG or PT_CURRENCY;
  PT_MV_APPTIME = MV_FLAG or PT_APPTIME;
  PT_MV_SYSTIME = MV_FLAG or PT_SYSTIME;
  PT_MV_STRING8 = MV_FLAG or PT_STRING8;
  PT_MV_BINARY = MV_FLAG or PT_BINARY;
  PT_MV_UNICODE = MV_FLAG or PT_UNICODE;
  PT_MV_CLSID = MV_FLAG or PT_CLSID;
  PT_MV_I8 = MV_FLAG or PT_I8;

{ Alternate property type names for ease of use }

const
  PT_MV_SHORT = PT_MV_I2;
  PT_MV_I4 = PT_MV_LONG;
  PT_MV_FLOAT = PT_MV_R4;
  PT_MV_R8 = PT_MV_DOUBLE;
  PT_MV_LONGLONG = PT_MV_I8;

(*
 *  Property type reserved bits
 *
 *  MV_INSTANCE is used as a flag in table operations to request
 *  that a multi-valued property be presented as a single-valued
 *  property appearing in multiple rows.
 *)

const
  MV_INSTANCE = $2000;
  MVI_FLAG = MV_FLAG or MV_INSTANCE;

{ --------------- }

{ Data Structures }

{ --------------- }

{ Property Tag Array }

type
  TSPropTagArray =     
    record
      cValues : ULONG;
      aulPropTag : array[0..MAPI_DIM - 1] of ULONG;
    end;
    
  PSPropTagArray = ^TSPropTagArray;
  
{  SPropTagArray }

{ -------------- }

{ Property Value }

{ -------------- }

{ 32-bit CURRENCY definition stolen from oaidl.h }

{ real definition that makes the C++ compiler happy }

type
  TCY =
    record
      case Integer of
        1 :
          (
            _noname1 :               
              record

                {$IFDEF _MAC}
                Hi : Longint;
                Lo : Longint;
                {$ELSE}
                Lo : Longint;
                Hi : Longint;
                {$ENDIF}
                
              end;
            );
        2 : 
          (
            int64 : LONGLONG;
          );
    end;
  
                                       { size is 8 }

type
  TCURRENCY = TCY;
  
  TSBinary =     
    record
      cb : ULONG;
      lpb : PBYTE;
    end;
    
  PSBinary = ^TSBinary;
  
  TSShortArray =     
    record
      cValues : ULONG;
      lpi : ^Smallint;
    end;
    
  TSGuidArray =     
    record
      cValues : ULONG;
      lpguid : ^TGUID;
    end;
    
  TSRealArray =     
    record
      cValues : ULONG;
      lpflt : ^Single;
    end;
    
  TSLongArray =     
    record
      cValues : ULONG;
      lpl : ^Longint;
    end;
    
  TSLargeIntegerArray =     
    record
      cValues : ULONG;
      lpli : ^TLargeInteger;
    end;
    
  TSDateTimeArray =     
    record
      cValues : ULONG;
      lpft : ^TFILETIME;
    end;
    
  TSAppTimeArray =     
    record
      cValues : ULONG;
      lpat : ^Double;
    end;
    
  TSCurrencyArray =     
    record
      cValues : ULONG;
      lpcur : ^TCURRENCY;
    end;
    
  TSBinaryArray =     
    record
      cValues : ULONG;
      lpbin : ^TSBinary;
    end;
    
  TSDoubleArray =     
    record
      cValues : ULONG;
      lpdbl : ^Double;
    end;
    
  TSWStringArray =     
    record
      cValues : ULONG;
      lppszW : ^PWSTR;
    end;
    
  TSLPSTRArray =     
    record
      cValues : ULONG;
      lppszA : ^LPSTR;
    end;
    
  T__UPV =     
    record
      case Integer of
        1 : 
          (
            i : Smallint;              { case PT_I2 }
          );
        2 : 
          (
            l : Longint;               { case PT_LONG }
          );
        3 : 
          (
            ul : ULONG;                { alias for PT_LONG }
          );
        4 : 
          (
            flt : Single;              { case PT_R4 }
          );
        5 : 
          (
            dbl : Double;              { case PT_DOUBLE }
          );
        6 : 
          (
            b : Smallint;              { case PT_BOOLEAN }
          );
        7 : 
          (
            cur : TCURRENCY;           { case PT_CURRENCY }
          );
        8 : 
          (
            at : Double;               { case PT_APPTIME }
          );
        9 : 
          (
            ft : TFILETIME;            { case PT_SYSTIME }
          );
        10 : 
          (
            lpszA : LPSTR;             { case PT_STRING8 }
          );
        11 : 
          (
            bin : TSBinary;            { case PT_BINARY }
          );
        12 : 
          (
            lpszW : PWSTR;             { case PT_UNICODE }
          );
        13 : 
          (
            lpguid : PGUID;            { case PT_CLSID }
          );
        14 : 
          (
            li : TLargeInteger;        { case PT_I8 }
          );
        15 : 
          (
            MVi : TSShortArray;        { case PT_MV_I2 }
          );
        16 : 
          (
            MVl : TSLongArray;         { case PT_MV_LONG }
          );
        17 : 
          (
            MVflt : TSRealArray;       { case PT_MV_R4 }
          );
        18 : 
          (
            MVdbl : TSDoubleArray;     { case PT_MV_DOUBLE }
          );
        19 : 
          (
            MVcur : TSCurrencyArray;   { case PT_MV_CURRENCY }
          );
        20 : 
          (
            MVat : TSAppTimeArray;     { case PT_MV_APPTIME }
          );
        21 : 
          (
            MVft : TSDateTimeArray;    { case PT_MV_SYSTIME }
          );
        22 : 
          (
            MVbin : TSBinaryArray;     { case PT_MV_BINARY }
          );
        23 : 
          (
            MVszA : TSLPSTRArray;      { case PT_MV_STRING8 }
          );
        24 : 
          (
            MVszW : TSWStringArray;    { case PT_MV_UNICODE }
          );
        25 : 
          (
            MVguid : TSGuidArray;      { case PT_MV_CLSID }
          );
        26 : 
          (
            MVli : TSLargeIntegerArray;{ case PT_MV_I8 }
          );
        27 : 
          (
            err : SCODE;               { case PT_ERROR }
          );
        28 : 
          (
            x : Longint;               { case PT_NULL, PT_OBJECT (no usable value) }
          );
    end;
  
  TSPropValue =     
    record
      ulPropTag : ULONG;
      dwAlignPad : ULONG;
      Value : T__UPV;
    end;
    
  PSPropValue = ^TSPropValue;
  
{ --------------------------------------------- }

{ Property Problem and Property Problem Arrays }

{ --------------------------------------------- }

type
  TSPropProblem =     
    record
      ulIndex : ULONG;
      ulPropTag : ULONG;
      scode : SCODE;
    end;
    
  PSPropProblem = ^TSPropProblem;
  
  TSPropProblemArray =     
    record
      cProblem : ULONG;
      aProblem : array[0..MAPI_DIM - 1] of TSPropProblem;
    end;
    
  PSPropProblemArray = ^TSPropProblemArray;
  
(*
 *  ENTRYLIST
 *)

type
  TENTRYLIST = TSBinaryArray;
  
  PENTRYLIST = ^TENTRYLIST;
  
(*
 *  FLATENTRYLIST
 *  MTSID
 *  FLATMTSIDLIST
 *)

type
  TFLATENTRY =     
    record
      cb : ULONG;
      abEntry : array[0..MAPI_DIM - 1] of Byte;
    end;
    
  PFLATENTRY = ^TFLATENTRY;
  
  TFLATENTRYLIST =     
    record
      cEntries : ULONG;
      cbEntries : ULONG;
      abEntries : array[0..MAPI_DIM - 1] of Byte;
    end;
    
  PFLATENTRYLIST = ^TFLATENTRYLIST;
  
  TMTSID =     
    record
      cb : ULONG;
      ab : array[0..MAPI_DIM - 1] of Byte;
    end;
    
  PMTSID = ^TMTSID;
  
  TFLATMTSIDLIST =     
    record
      cMTSIDs : ULONG;
      cbMTSIDs : ULONG;
      abMTSIDs : array[0..MAPI_DIM - 1] of Byte;
    end;
    
  PFLATMTSIDLIST = ^TFLATMTSIDLIST;
  
{ No SizedXXX macros for these types. }

{ ------------------------------ }

{ ADRENTRY, ADRLIST }

type
  TADRENTRY =     
    record
      ulReserved1 : ULONG;             { Never used }
      cValues : ULONG;
      rgPropVals : PSPropValue;
    end;
    
  PADRENTRY = ^TADRENTRY;
  
  TADRLIST =     
    record
      cEntries : ULONG;
      aEntries : array[0..MAPI_DIM - 1] of TADRENTRY;
    end;
    
  PADRLIST = ^TADRLIST;
  
{ ------------------------------ }

{ SRow, SRowSet }

type
  {!! Array for containing property values }
  PSPropValueArray = ^TSPropValueArray;
  TSPropValueArray = array[0..0] of TSPropValue;

  TSRow =
    record
      ulAdrEntryPad : ULONG;           { Pad so SRow's can map to ADRENTRY's }
      cValues : ULONG;                 { Count of property values }
      {!! lpProps member converted to array }
      lpProps : PSPropValueArray;      { Property value array }
    end;
    
  PSRow = ^TSRow;
  
  TSRowSet =     
    record
      cRows : ULONG;                   { Count of rows }
      aRow : array[0..MAPI_DIM - 1] of TSRow;
                                       { Array of rows }
    end;
    
  PSRowSet = ^TSRowSet;
  
{ MAPI Allocation Routines ------------------------------------------------ }

type
  TALLOCATEBUFFER = function (cbSize : ULONG; var lppBuffer : Pointer) : SCODE; stdcall;
  
  TALLOCATEMORE = function (cbSize : ULONG; lpObject : Pointer; 
    var lppBuffer : Pointer) : SCODE; stdcall;
  
  TFREEBUFFER = function (lpBuffer : Pointer) : ULONG; stdcall;
  
  PALLOCATEBUFFER = ^TALLOCATEBUFFER;
  
  PALLOCATEMORE = ^TALLOCATEMORE;
  
  PFREEBUFFER = ^TFREEBUFFER;
  
{ MAPI Component Object Model Macros -------------------------------------- }

{ Pointers to MAPI Interfaces --------------------------------------------- }

type
  PCIID = ^TIID;

{ Extended MAPI Error Information ----------------------------------------- }

type
  TMAPIERROR =     
    record
      ulVersion : ULONG;
      lpszError : PChar;
      lpszComponent : PChar;
      ulLowLevelError : ULONG;
      ulContext : ULONG;
    end;
    
  PMAPIERROR = ^TMAPIERROR;
  
{ IMAPIAdviseSink Interface ----------------------------------------------- }

(*
 *  Notification event types. The event types can be combined in a bitmask
 *  for filtering. Each one has a parameter structure associated with it:
 *
 *      fnevCriticalError       ERROR_NOTIFICATION
 *      fnevNewMail             NEWMAIL_NOTIFICATION
 *      fnevObjectCreated       OBJECT_NOTIFICATION
 *      fnevObjectDeleted       OBJECT_NOTIFICATION
 *      fnevObjectModified      OBJECT_NOTIFICATION
 *      fnevObjectCopied        OBJECT_NOTIFICATION
 *      fnevSearchComplete      OBJECT_NOTIFICATION
 *      fnevTableModified       TABLE_NOTIFICATION
 *      fnevStatusObjectModified ?
 *
 *      fnevExtended            EXTENDED_NOTIFICATION
 *)

const
  fnevCriticalError = ULONG($00000001);
  fnevNewMail = ULONG($00000002);
  fnevObjectCreated = ULONG($00000004);
  fnevObjectDeleted = ULONG($00000008);
  fnevObjectModified = ULONG($00000010);
  fnevObjectMoved = ULONG($00000020);
  fnevObjectCopied = ULONG($00000040);
  fnevSearchComplete = ULONG($00000080);
  fnevTableModified = ULONG($00000100);
  fnevStatusObjectModified = ULONG($00000200);
  fnevReservedForMapi = ULONG($40000000);
  fnevExtended = ULONG($80000000);

{ TABLE_NOTIFICATION event types passed in ulTableEvent }

const
  TABLE_CHANGED = 1;
  TABLE_ERROR = 2;
  TABLE_ROW_ADDED = 3;
  TABLE_ROW_DELETED = 4;
  TABLE_ROW_MODIFIED = 5;
  TABLE_SORT_DONE = 6;
  TABLE_RESTRICT_DONE = 7;
  TABLE_SETCOL_DONE = 8;
  TABLE_RELOAD = 9;

{ Event Structures }

type
  TERROR_NOTIFICATION =     
    record
      cbEntryID : ULONG;
      lpEntryID : PENTRYID;
      scode : SCODE;
      ulFlags : ULONG;                 { 0 or MAPI_UNICODE }
      lpMAPIError : PMAPIERROR;        { Detailed error information }
    end;
    
  TNEWMAIL_NOTIFICATION =     
    record
      cbEntryID : ULONG;
      lpEntryID : PENTRYID;            { identifies the new message }
      cbParentID : ULONG;
      lpParentID : PENTRYID;           { identifies the folder it lives in }
      ulFlags : ULONG;                 { 0 or MAPI_UNICODE }
      lpszMessageClass : PChar;        { message class (UNICODE or string8) }
      ulMessageFlags : ULONG;          { copy of PR_MESSAGE_FLAGS }
    end;
    
  TOBJECT_NOTIFICATION =     
    record
      cbEntryID : ULONG;
      lpEntryID : PENTRYID;            { EntryID of object }
      ulObjType : ULONG;               { Type of object }
      cbParentID : ULONG;
      lpParentID : PENTRYID;           { EntryID of parent object }
      cbOldID : ULONG;
      lpOldID : PENTRYID;              { EntryID of old object }
      cbOldParentID : ULONG;
      lpOldParentID : PENTRYID;        { EntryID of old parent }
      lpPropTagArray : PSPropTagArray;
    end;
    
  TTABLE_NOTIFICATION =     
    record
      ulTableEvent : ULONG;            { Identifies WHICH table event }
      hResult : HResult;               { Value for TABLE_ERROR }
      propIndex : TSPropValue;         { This row's "index property" }
      propPrior : TSPropValue;         { Preceding row's "index property" }
      row : TSRow;                     { New data of added/modified row }
      ulPad : ULONG;                   { Force to 8-byte boundary }
    end;
    
  TEXTENDED_NOTIFICATION =     
    record
      ulEvent : ULONG;                 { extended event code }
      cb : ULONG;                      { size of event parameters }
      pbEventParameters : PBYTE;       { event parameters }
    end;
    
  TSTATUS_OBJECT_NOTIFICATION =     
    record
      cbEntryID : ULONG;
      lpEntryID : PENTRYID;
      cValues : ULONG;
      lpPropVals : PSPropValue;
    end;
    
  TNOTIFICATION =     
    record
      ulEventType : ULONG;             { notification type, i.e. fnevSomething }
      ulAlignPad : ULONG;              { Force to 8-byte boundary }
      info :         
        record
          case Integer of
            1 : 
              (
                err : TERROR_NOTIFICATION;
              );
            2 : 
              (
                newmail : TNEWMAIL_NOTIFICATION;
              );
            3 : 
              (
                obj : TOBJECT_NOTIFICATION;
              );
            4 : 
              (
                tab : TTABLE_NOTIFICATION;
              );
            5 : 
              (
                ext : TEXTENDED_NOTIFICATION;
              );
            6 : 
              (
                statobj : TSTATUS_OBJECT_NOTIFICATION;
              );
      end;
    end;
    
  PNOTIFICATION = ^TNOTIFICATION;
  
  { Callback function type for MAPIAllocAdviseSink }
  
  TNOTIFCALLBACK = function (lpvContext : Pointer; cNotification : ULONG; 
    lpNotifications : PNOTIFICATION) : Longint; stdcall;
  
  PNOTIFCALLBACK = ^TNOTIFCALLBACK;
  
(*
 *  Message name for the 16-bit MAPI notififcation engine.
 *  This can be used in 16-bit applications to force processing
 *  of notification callbacks.
 *)

const
  szMAPINotificationMsg = 'MAPI Notify window message';

{ IMAPIProgress Interface ------------------------------------------------- }

{ Flag values for the progress indicator }

const
  MAPI_TOP_LEVEL = ULONG($00000001);

{ IMAPIProp Interface ----------------------------------------------------- }

{ GetLastError }

{***** MAPI_UNICODE            ((ULONG) 0x80000000) above }

(*
 *  Version:
 *)
  
const
  MAPI_ERROR_VERSION = $00000000;
  
  { GetPropList }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  { GetProps }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  { SaveChanges }
  
  KEEP_OPEN_READONLY = ULONG($00000001);
  KEEP_OPEN_READWRITE = ULONG($00000002);
  FORCE_SAVE = ULONG($00000004);
  
  { define MAPI_DEFERRED_ERRORS  ((ULONG) 0x00000008) below }
  
  { OpenProperty  - ulFlags }
  
  {***** MAPI_MODIFY             ((ULONG) 0x00000001) above }
  
  MAPI_CREATE = ULONG($00000002);
  STREAM_APPEND = ULONG($00000004);
  
  {***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) below }
  
  { OpenProperty  - ulInterfaceOptions, IID_IMAPITable }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  { CopyTo, CopyProps }
  
  MAPI_MOVE = ULONG($00000001);
  MAPI_NOREPLACE = ULONG($00000002);
  MAPI_DECLINE_OK = ULONG($00000004);
  
                                       { also defined in mapi.h }
  MAPI_DIALOG = ULONG($00000008);

                                       { also defined in mapi.h }
  MAPI_USE_DEFAULT = $00000040         { Use default profile in logon }
  ;

  { Flags used in GetIDsFromNames  }
  
  {***** MAPI_CREATE             ((ULONG) 0x00000002) above }
  
  { Flags used in GetNamesFromIDs  (bit fields) }
  
  MAPI_NO_STRINGS = ULONG($00000001);
  MAPI_NO_IDS = ULONG($00000002);
  
  {  Union discriminator  }
  
  MNID_ID = 0;
  MNID_STRING = 1;

type
  TMAPINAMEID =     
    record
      lpguid : PGUID;
      ulKind : ULONG;
      Kind :         
        record
          case Integer of
            1 : 
              (
                lID : Longint;
              );
            2 : 
              (
                lpwstrName : PWSTR;
              );
      end;
    end;
    
  PMAPINAMEID = ^TMAPINAMEID;
  
  { Interface used for registering and issuing notification callbacks. }
  IMAPIAdviseSink =
    interface(IUnknown)
    [strIID_IMAPIAdviseSink]
      function OnNotify (cNotif : ULONG; lpNotifications : PNOTIFICATION) : ULONG; stdcall;
    end;

  IMAPIProgress =
    interface(IUnknown)
    [strIID_IMAPIProgress]
      function Progress (ulValue : ULONG; ulCount : ULONG; ulTotal : ULONG) : HResult; stdcall;
      function GetFlags (var lpulFlags : ULONG) : HResult; stdcall;
      function GetMax (var lpulMax : ULONG) : HResult; stdcall;
      function GetMin (var lpulMin : ULONG) : HResult; stdcall;
      function SetLimits (lpulMin : PULONG; lpulMax : PULONG; lpulFlags : PULONG) : HResult; stdcall;
    end;

  IMAPIProp =
    interface(IUnknown)
    [strIID_IMAPIProp]
      function GetLastError (hResult : HResult; ulFlags : ULONG;
        var lppMAPIError : PMAPIERROR) : HResult; stdcall;
      function SaveChanges (ulFlags : ULONG) : HResult; stdcall;
      function GetProps (lpPropTagArray : PSPropTagArray; ulFlags : ULONG; 
        var lpcValues : ULONG;
        var lppPropArray : PSPropValue) : HResult; stdcall;
      function GetPropList (ulFlags : ULONG;
        var lppPropTagArray : PSPropTagArray) : HResult; stdcall;
      function OpenProperty (ulPropTag : ULONG; const lpiid : TIID; 
        ulInterfaceOptions : ULONG; ulFlags : ULONG;
        var lppUnk : IUnknown) : HResult; stdcall;
      function SetProps (cValues : ULONG; lpPropArray : PSPropValue; 
        var lppProblems : PSPropProblemArray) : HResult; stdcall;
      function DeleteProps (lpPropTagArray : PSPropTagArray; 
        var lppProblems : PSPropProblemArray) : HResult; stdcall;
      function CopyTo (ciidExclude : ULONG; const rgiidExclude : TIID; 
        lpExcludeProps : PSPropTagArray; ulUIParam : ULONG; 
        lpProgress : IMAPIProgress; const lpInterface : TIID;
        lpDestObj : Pointer; ulFlags : ULONG;
        var lppProblems : PSPropProblemArray) : HResult; stdcall;
      function CopyProps (lpIncludeProps : PSPropTagArray; ulUIParam : ULONG; 
        lpProgress : IMAPIProgress; const lpInterface : TIID; lpDestObj : Pointer; 
        ulFlags : ULONG; var lppProblems : PSPropProblemArray) : HResult; stdcall;
      function GetNamesFromIDs (var lppPropTags : PSPropTagArray; 
        lpPropSetGuid : PGUID; ulFlags : ULONG; var lpcPropNames : ULONG; 
        var lpppPropNames : PMAPINAMEID) : HResult; stdcall;
      function GetIDsFromNames (cPropNames : ULONG; var lppPropNames : PMAPINAMEID; 
        ulFlags : ULONG; var lppPropTags : PSPropTagArray) : HResult; stdcall;
    end;
  
{ IMAPITable Interface ---------------------------------------------------- }

{ Table status }
  
const
  TBLSTAT_COMPLETE = ULONG(0);
  TBLSTAT_QCHANGED = ULONG(7);
  TBLSTAT_SORTING = ULONG(9);
  TBLSTAT_SORT_ERROR = ULONG(10);
  TBLSTAT_SETTING_COLS = ULONG(11);
  TBLSTAT_SETCOL_ERROR = ULONG(13);
  TBLSTAT_RESTRICTING = ULONG(14);
  TBLSTAT_RESTRICT_ERROR = ULONG(15);
  
  { Table Type }
  
  TBLTYPE_SNAPSHOT = ULONG(0);
  TBLTYPE_KEYSET = ULONG(1);
  TBLTYPE_DYNAMIC = ULONG(2);
  
  { Sort order }
  
  { bit 0: set if descending, clear if ascending }
  
  TABLE_SORT_ASCEND = ULONG($00000000);
  TABLE_SORT_DESCEND = ULONG($00000001);
  TABLE_SORT_COMBINE = ULONG($00000002);
  
  { Data structures }
  
type
  TSSortOrder =     
    record
      ulPropTag : ULONG;               { Column to sort on }
      ulOrder : ULONG;                 { Ascending, descending, combine to left }
    end;
    
  PSSortOrder = ^TSSortOrder;
  
  TSSortOrderSet =     
    record
      cSorts : ULONG;                  { Number of sort columns in aSort below}
      cCategories : ULONG;             { 0 for non-categorized, up to cSorts }
      cExpanded : ULONG;               { 0 if no categories start expanded, }
                                       {      up to cExpanded }
      aSort : array[0..MAPI_DIM - 1] of TSSortOrder;
                                       { The sort orders }
    end;
    
  PSSortOrderSet = ^TSSortOrderSet;
  
type
  TBOOKMARK = ULONG;
  
const
  BOOKMARK_BEGINNING = TBOOKMARK(0)    { Before first row }
  ;
  BOOKMARK_CURRENT = TBOOKMARK(1)      { Before current row }
  ;
  BOOKMARK_END = TBOOKMARK(2)          { After last row }
  ;

{ Fuzzy Level }

const
  FL_FULLSTRING = ULONG($00000000);
  FL_SUBSTRING = ULONG($00000001);
  FL_PREFIX = ULONG($00000002);
  FL_IGNORECASE = ULONG($00010000);
  FL_IGNORENONSPACE = ULONG($00020000);
  FL_LOOSE = ULONG($00040000);

{ Restriction types }

const
  RES_AND = ULONG($00000000);
  RES_OR = ULONG($00000001);
  RES_NOT = ULONG($00000002);
  RES_CONTENT = ULONG($00000003);
  RES_PROPERTY = ULONG($00000004);
  RES_COMPAREPROPS = ULONG($00000005);
  RES_BITMASK = ULONG($00000006);
  RES_SIZE = ULONG($00000007);
  RES_EXIST = ULONG($00000008);
  RES_SUBRESTRICTION = ULONG($00000009);
  RES_COMMENT = ULONG($0000000A);

{ Relational operators. These apply to all property comparison restrictions. }

const
  RELOP_LT = ULONG(0)                  { <  }
  ;
  RELOP_LE = ULONG(1)                  { <= }
  ;
  RELOP_GT = ULONG(2)                  { >  }
  ;
  RELOP_GE = ULONG(3)                  { >= }
  ;
  RELOP_EQ = ULONG(4)                  { == }
  ;
  RELOP_NE = ULONG(5)                  { != }
  ;
  RELOP_RE = ULONG(6)                  { LIKE (Regular expression) }
  ;

{ Bitmask operators, for RES_BITMASK only. }

const
  BMR_EQZ = ULONG(0)                   { ==0 }
  ;
  BMR_NEZ = ULONG(1)                   { !=0 }
  ;

{ Subobject identifiers for RES_SUBRESTRICTION only. See MAPITAGS.H. }

{ #define PR_MESSAGE_RECIPIENTS  PROP_TAG(PT_OBJECT,0x0E12) }

{ #define PR_MESSAGE_ATTACHMENTS PROP_TAG(PT_OBJECT,0x0E13) }

{ Restrictions }

type
  PSRestriction = ^TSRestriction;

  TSAndRestriction =
    record
      cRes : ULONG;
      lpRes : PSRestriction;
    end;
    
  TSOrRestriction =     
    record
      cRes : ULONG;
      lpRes : PSRestriction;
    end;
    
  TSNotRestriction =     
    record
      ulReserved : ULONG;
      lpRes : PSRestriction;
    end;
    
  TSContentRestriction =     
    record
      ulFuzzyLevel : ULONG;
      ulPropTag : ULONG;
      lpProp : PSPropValue;
    end;
    
  TSBitMaskRestriction =     
    record
      relBMR : ULONG;
      ulPropTag : ULONG;
      ulMask : ULONG;
    end;
    
  TSPropertyRestriction =     
    record
      relop : ULONG;
      ulPropTag : ULONG;
      lpProp : PSPropValue;
    end;
    
  TSComparePropsRestriction =     
    record
      relop : ULONG;
      ulPropTag1 : ULONG;
      ulPropTag2 : ULONG;
    end;
    
  TSSizeRestriction =     
    record
      relop : ULONG;
      ulPropTag : ULONG;
      cb : ULONG;
    end;
    
  TSExistRestriction =     
    record
      ulReserved1 : ULONG;
      ulPropTag : ULONG;
      ulReserved2 : ULONG;
    end;
    
  TSSubRestriction =     
    record
      ulSubObject : ULONG;
      lpRes : PSRestriction;
    end;
    
  TSCommentRestriction =     
    record
      cValues : ULONG;                 { # of properties in lpProp }
      lpRes : PSRestriction;
      lpProp : PSPropValue;
    end;
    
  TSRestriction =
    record
      rt : ULONG;                      { Restriction type }
      res :         
        record
          case Integer of
            1 : 
              (
                resCompareProps : TSComparePropsRestriction;
                                       { first }
              );
            2 : 
              (
                resAnd : TSAndRestriction;
              );
            3 : 
              (
                resOr : TSOrRestriction;
              );
            4 : 
              (
                resNot : TSNotRestriction;
              );
            5 : 
              (
                resContent : TSContentRestriction;
              );
            6 : 
              (
                resProperty : TSPropertyRestriction;
              );
            7 : 
              (
                resBitMask : TSBitMaskRestriction;
              );
            8 : 
              (
                resSize : TSSizeRestriction;
              );
            9 : 
              (
                resExist : TSExistRestriction;
              );
            10 : 
              (
                resSub : TSSubRestriction;
              );
            11 : 
              (
                resComment : TSCommentRestriction;
              );
      end;
    end;
    
{ SComparePropsRestriction is first in the union so that }

{ static initializations of 3-value restriction work.    }

{ Flags of the methods of IMAPITable }

{ QueryColumn }

const
  TBL_ALL_COLUMNS = ULONG($00000001);

{ QueryRows }

{ Possible values for PR_ROW_TYPE (for categorization) }

const
  TBL_LEAF_ROW = ULONG(1);
  TBL_EMPTY_CATEGORY = ULONG(2);
  TBL_EXPANDED_CATEGORY = ULONG(3);
  TBL_COLLAPSED_CATEGORY = ULONG(4);

{ Table wait flag }

const
  TBL_NOWAIT = ULONG($00000001);

{ alternative name for TBL_NOWAIT }

const
  TBL_ASYNC = ULONG($00000001);
  TBL_BATCH = ULONG($00000002);

{ FindRow }

const
  DIR_BACKWARD = ULONG($00000001);

{ Table cursor states }

const
  TBL_NOADVANCE = ULONG($00000001);

type
  IMAPITable =
    interface(IUnknown)
    [strIID_IMAPITable]
      function GetLastError (hResult : HResult; ulFlags : ULONG;
        var lppMAPIError : PMAPIERROR) : HResult; stdcall;
      function Advise (ulEventMask : ULONG; lpAdviseSink : IMAPIAdviseSink; 
        var lpulConnection : ULONG) : HResult; stdcall;
      function Unadvise (ulConnection : ULONG) : HResult; stdcall;
      function GetStatus (var lpulTableStatus : ULONG; var lpulTableType : ULONG) : HResult; stdcall;
      function SetColumns (lpPropTagArray : PSPropTagArray; ulFlags : ULONG) : HResult; stdcall;
      function QueryColumns (ulFlags : ULONG; var lpPropTagArray : PSPropTagArray) : HResult; stdcall;
      function GetRowCount (ulFlags : ULONG; var lpulCount : ULONG) : HResult; stdcall;
      function SeekRow (bkOrigin : TBOOKMARK; lRowCount : Longint; 
        var lplRowsSought : Longint) : HResult; stdcall;
      function SeekRowApprox (ulNumerator : ULONG; ulDenominator : ULONG) : HResult; stdcall;
      function QueryPosition (var lpulRow : ULONG; var lpulNumerator : ULONG; 
        var lpulDenominator : ULONG) : HResult; stdcall;
      function FindRow (lpRestriction : PSRestriction; bkOrigin : TBOOKMARK; 
        ulFlags : ULONG) : HResult; stdcall;
      function Restrict (lpRestriction : PSRestriction; ulFlags : ULONG) : HResult; stdcall;
      function CreateBookmark (var lpbkPosition : TBOOKMARK) : HResult; stdcall;
      function FreeBookmark (bkPosition : TBOOKMARK) : HResult; stdcall;
      function SortTable (lpSortCriteria : PSSortOrderSet; ulFlags : ULONG) : HResult; stdcall;
      function QuerySortOrder (var lppSortCriteria : PSSortOrderSet) : HResult; stdcall;
      function QueryRows (lRowCount : Longint; ulFlags : ULONG; 
        var lppRows : PSRowSet) : HResult; stdcall;
      function Abort : HResult; stdcall;
      function ExpandRow (cbInstanceKey : ULONG; pbInstanceKey : PBYTE; 
        ulRowCount : ULONG; ulFlags : ULONG; var lppRows : PSRowSet; 
        var lpulMoreRows : ULONG) : HResult; stdcall;
      function CollapseRow (cbInstanceKey : ULONG; pbInstanceKey : PBYTE; 
        ulFlags : ULONG; var lpulRowCount : ULONG) : HResult; stdcall;
      function WaitForCompletion (ulFlags : ULONG; ulTimeout : ULONG; 
        var lpulTableStatus : ULONG) : HResult; stdcall;
      function GetCollapseState (ulFlags : ULONG; cbInstanceKey : ULONG; 
        lpbInstanceKey : PBYTE; var lpcbCollapseState : ULONG; 
        var lppbCollapseState : PBYTE) : HResult; stdcall;
      function SetCollapseState (ulFlags : ULONG; cbCollapseState : ULONG; 
        pbCollapseState : PBYTE; var lpbkLocation : TBOOKMARK) : HResult; stdcall;
    end;
  
{ IProfSect Interface ----------------------------------------------------- }

{ Standard section for public profile properties }
  
const
  PS_PROFILE_PROPERTIES_INIT : array[0..15] of Integer =
    (
      $98, $15, $AC, $08, $AA, $B0, $10, $1A, $8C, $93, $08, 
      $00, $2, $2A, $56, $C2
    );

type
  IProfSect =
    interface(IMAPIProp)
    [strIID_IProfSect]
    end;

{ IMAPIStatus Interface --------------------------------------------------- }

{ Values for PR_RESOURCE_TYPE, _METHODS, _FLAGS }

const
  MAPI_STORE_PROVIDER = ULONG(33)      { Message Store }
  ;
  MAPI_AB = ULONG(34)                  { Address Book }
  ;
  MAPI_AB_PROVIDER = ULONG(35)         { Address Book Provider }
  ;
  MAPI_TRANSPORT_PROVIDER = ULONG(36)  { Transport Provider }
  ;
  MAPI_SPOOLER = ULONG(37)             { Message Spooler }
  ;
  MAPI_PROFILE_PROVIDER = ULONG(38)    { Profile Provider }
  ;
  MAPI_SUBSYSTEM = ULONG(39)           { Overall Subsystem Status }
  ;
  MAPI_HOOK_PROVIDER = ULONG(40)       { Spooler Hook }
  ;
  STATUS_VALIDATE_STATE = ULONG($00000001);
  STATUS_SETTINGS_DIALOG = ULONG($00000002);
  STATUS_CHANGE_PASSWORD = ULONG($00000004);
  STATUS_FLUSH_QUEUES = ULONG($00000008);
  STATUS_DEFAULT_OUTBOUND = ULONG($00000001);
  STATUS_DEFAULT_STORE = ULONG($00000002);
  STATUS_PRIMARY_IDENTITY = ULONG($00000004);
  STATUS_SIMPLE_STORE = ULONG($00000008);
  STATUS_XP_PREFER_LAST = ULONG($00000010);
  STATUS_NO_PRIMARY_IDENTITY = ULONG($00000020);
  STATUS_NO_DEFAULT_STORE = ULONG($00000040);
  STATUS_TEMP_SECTION = ULONG($00000080);
  STATUS_OWN_STORE = ULONG($00000100);
  
  {***** HOOK_INBOUND            ((ULONG) 0x00000200) Defined in MAPIHOOK.H }
  
  {***** HOOK_OUTBOUND           ((ULONG) 0x00000400) Defined in MAPIHOOK.H }
  
  STATUS_NEED_IPM_TREE = ULONG($00000800);
  STATUS_PRIMARY_STORE = ULONG($00001000);
  STATUS_SECONDARY_STORE = ULONG($00002000);
  
  (*
   * PR_STATUS_CODE bit. Low 16 bits for common values; High 16 bits
   * for provider type-specific values. (DCR 304)
   *)
  
  STATUS_AVAILABLE = ULONG($00000001);
  STATUS_OFFLINE = ULONG($00000002);
  STATUS_FAILURE = ULONG($00000004);
  
  { Transport values of PR_STATUS_CODE }
  
  STATUS_INBOUND_ENABLED = ULONG($00010000);
  STATUS_INBOUND_ACTIVE = ULONG($00020000);
  STATUS_INBOUND_FLUSH = ULONG($00040000);
  STATUS_OUTBOUND_ENABLED = ULONG($00100000);
  STATUS_OUTBOUND_ACTIVE = ULONG($00200000);
  STATUS_OUTBOUND_FLUSH = ULONG($00400000);
  STATUS_REMOTE_ACCESS = ULONG($00800000);
  
  { ValidateState flags }
  
  SUPPRESS_UI = ULONG($00000001);
  REFRESH_XP_HEADER_CACHE = ULONG($00010000);
  PROCESS_XP_HEADER_CACHE = ULONG($00020000);
  FORCE_XP_CONNECT = ULONG($00040000);
  FORCE_XP_DISCONNECT = ULONG($00080000);
  CONFIG_CHANGED = ULONG($00100000);
  ABORT_XP_HEADER_OPERATION = ULONG($00200000);
  SHOW_XP_SESSION_UI = ULONG($00400000);
  
  { SettingsDialog flags }
  
  UI_READONLY = ULONG($00000001);
  
  { FlushQueues flags }
  
  FLUSH_UPLOAD = ULONG($00000002);
  FLUSH_DOWNLOAD = ULONG($00000004);
  FLUSH_FORCE = ULONG($00000008);
  FLUSH_NO_UI = ULONG($00000010);
  FLUSH_ASYNC_OK = ULONG($00000020);

type
  IMAPIStatus =
    interface(IMAPIProp)
    [strIID_IMAPIStatus]
      function ValidateState (ulUIParam : ULONG; ulFlags : ULONG) : HResult; stdcall;
      function SettingsDialog (ulUIParam : ULONG; ulFlags : ULONG) : HResult; stdcall;
      function ChangePassword (lpOldPass : PChar; lpNewPass : PChar; ulFlags : ULONG) : HResult; stdcall;
      function FlushQueues (ulUIParam : ULONG; cbTargetTransport : ULONG; 
        lpTargetTransport : PENTRYID; ulFlags : ULONG) : HResult; stdcall;
    end;
  
{ IMAPIContainer Interface ------------------------------------------------ }

{ Flags for OpenEntry() }

{***** MAPI_MODIFY             ((ULONG) 0x00000001) above }

{***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) below }
  
const
  MAPI_BEST_ACCESS = ULONG($00000010);
  
  { GetContentsTable() }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  {***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) below }
  
  {***** MAPI_ASSOCIATED         ((ULONG) 0x00000040) below }
  
  { GetHierarchyTable() }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  CONVENIENT_DEPTH = ULONG($00000001);
  
  {***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) below }
  
  { GetSearchCriteria }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  SEARCH_RUNNING = ULONG($00000001);
  SEARCH_REBUILD = ULONG($00000002);
  SEARCH_RECURSIVE = ULONG($00000004);
  SEARCH_FOREGROUND = ULONG($00000008);
  
  { SetSearchCriteria }
  
  STOP_SEARCH = ULONG($00000001);
  RESTART_SEARCH = ULONG($00000002);
  RECURSIVE_SEARCH = ULONG($00000004);
  SHALLOW_SEARCH = ULONG($00000008);
  FOREGROUND_SEARCH = ULONG($00000010);
  BACKGROUND_SEARCH = ULONG($00000020);

type
  IMAPIContainer =
    interface(IMAPIProp)
    [strIID_IMAPIContainer]
      function GetContentsTable (ulFlags : ULONG; var lppTable : IMAPITable) : HResult; stdcall;
      function GetHierarchyTable (ulFlags : ULONG; var lppTable : IMAPITable) : HResult; stdcall;
      function OpenEntry (cbEntryID : ULONG; lpEntryID : PENTRYID; const lpInterface : TIID; 
        ulFlags : ULONG; var lpulObjType : ULONG; var lppUnk : IUnknown) : HResult; stdcall;
      function SetSearchCriteria (lpRestriction : PSRestriction; 
        lpContainerList : PENTRYLIST; ulSearchFlags : ULONG) : HResult; stdcall;
      function GetSearchCriteria (ulFlags : ULONG; var lppRestriction : PSRestriction; 
        var lppContainerList : PENTRYLIST; var lpulSearchState : ULONG) : HResult; stdcall;
    end;
  
{ IABContainer Interface -------------------------------------------------- }

(*
 *  IABContainer PR_CONTAINER_FLAGS values
 *  If AB_UNMODIFIABLE and AB_MODIFIABLE are both set, it means the container
 *  doesn't know if it's modifiable or not, and the client should
 *  try to modify the contents but we won't expect it to work.
 *  If the AB_RECIPIENTS flag is set and neither AB_MODIFIABLE or AB_UNMODIFIABLE
 *  bits are set, it is an error.
 *)
  
  TFlagList =     
    record
      cFlags : ULONG;
      ulFlag : array[0..MAPI_DIM - 1] of ULONG;
    end;
    
  PFlagList = ^TFlagList;
  
(*
 *  Container flags
 *)

const
  AB_RECIPIENTS = ULONG($00000001);
  AB_SUBCONTAINERS = ULONG($00000002);
  AB_MODIFIABLE = ULONG($00000004);
  AB_UNMODIFIABLE = ULONG($00000008);
  AB_FIND_ON_OPEN = ULONG($00000010);
  AB_NOT_DEFAULT = ULONG($00000020);

{ CreateEntry() }

const
  CREATE_CHECK_DUP_STRICT = ULONG($00000001);
  CREATE_CHECK_DUP_LOOSE = ULONG($00000002);
  CREATE_REPLACE = ULONG($00000004);

{ ResolveNames() - ulFlags }

{***** MAPI_UNICODE            ((ULONG) 0x80000000) above }

{ ResolveNames() - rgulFlags }

const
  MAPI_UNRESOLVED = ULONG($00000000);
  MAPI_AMBIGUOUS = ULONG($00000001);
  MAPI_RESOLVED = ULONG($00000002);

type
  IABContainer =
    interface(IMAPIContainer)
    [strIID_IABContainer]
      function CreateEntry (cbEntryID : ULONG; lpEntryID : PENTRYID;
        ulCreateFlags : ULONG; var lppMAPIPropEntry : IMAPIProp) : HResult; stdcall;
      function CopyEntries (lpEntries : PENTRYLIST; ulUIParam : ULONG; 
        lpProgress : IMAPIProgress; ulFlags : ULONG) : HResult; stdcall;
      function DeleteEntries (lpEntries : PENTRYLIST; ulFlags : ULONG) : HResult; stdcall;
      function ResolveNames (lpPropTagArray : PSPropTagArray; ulFlags : ULONG; 
        lpAdrList : PADRLIST; lpFlagList : PFlagList) : HResult; stdcall;
    end;
  
{ IMailUser Interface ----------------------------------------------------- }

{  Any call which can create a one-off entryID (i.e. MAPISupport::CreateOneOff
   or IAdrBook::CreateOneOff) can encode the value for PR_SEND_RICH_INFO by
   passing in the following flag in the ulFlags parameter.  Setting this flag
   indicates that PR_SEND_RICH_INFO will be FALSE.
}
  
const
  MAPI_SEND_NO_RICH_INFO = ULONG($00010000);
  
  { Values of PR_NDR_DIAG_CODE }

  MAPI_DIAG_NO_DIAGNOSTIC = -1;
  MAPI_DIAG_OR_NAME_UNRECOGNIZED = 0;
  MAPI_DIAG_OR_NAME_AMBIGUOUS = 1;
  MAPI_DIAG_MTS_CONGESTED = 2;
  MAPI_DIAG_LOOP_DETECTED = 3;
  MAPI_DIAG_RECIPIENT_UNAVAILABLE = 4;
  MAPI_DIAG_MAXIMUM_TIME_EXPIRED = 5;
  MAPI_DIAG_EITS_UNSUPPORTED = 6;
  MAPI_DIAG_CONTENT_TOO_LONG = 7;
  MAPI_DIAG_IMPRACTICAL_TO_CONVERT = 8;
  MAPI_DIAG_PROHIBITED_TO_CONVERT = 9;
  MAPI_DIAG_CONVERSION_UNSUBSCRIBED = 10;
  MAPI_DIAG_PARAMETERS_INVALID = 11;
  MAPI_DIAG_CONTENT_SYNTAX_IN_ERROR = 12;
  MAPI_DIAG_LENGTH_CONSTRAINT_VIOLATD = 13;
  MAPI_DIAG_NUMBER_CONSTRAINT_VIOLATD = 14;
  MAPI_DIAG_CONTENT_TYPE_UNSUPPORTED = 15;
  MAPI_DIAG_TOO_MANY_RECIPIENTS = 16;
  MAPI_DIAG_NO_BILATERAL_AGREEMENT = 17;
  MAPI_DIAG_CRITICAL_FUNC_UNSUPPORTED = 18;
  MAPI_DIAG_CONVERSION_LOSS_PROHIB = 19;
  MAPI_DIAG_LINE_TOO_LONG = 20;
  MAPI_DIAG_PAGE_TOO_LONG = 21;
  MAPI_DIAG_PICTORIAL_SYMBOL_LOST = 22;
  MAPI_DIAG_PUNCTUATION_SYMBOL_LOST = 23;
  MAPI_DIAG_ALPHABETIC_CHARACTER_LOST = 24;
  MAPI_DIAG_MULTIPLE_INFO_LOSSES = 25;
  MAPI_DIAG_REASSIGNMENT_PROHIBITED = 26;
  MAPI_DIAG_REDIRECTION_LOOP_DETECTED = 27;
  MAPI_DIAG_EXPANSION_PROHIBITED = 28;
  MAPI_DIAG_SUBMISSION_PROHIBITED = 29;
  MAPI_DIAG_EXPANSION_FAILED = 30;
  MAPI_DIAG_RENDITION_UNSUPPORTED = 31;
  MAPI_DIAG_MAIL_ADDRESS_INCORRECT = 32;
  MAPI_DIAG_MAIL_OFFICE_INCOR_OR_INVD = 33;
  MAPI_DIAG_MAIL_ADDRESS_INCOMPLETE = 34;
  MAPI_DIAG_MAIL_RECIPIENT_UNKNOWN = 35;
  MAPI_DIAG_MAIL_RECIPIENT_DECEASED = 36;
  MAPI_DIAG_MAIL_ORGANIZATION_EXPIRED = 37;
  MAPI_DIAG_MAIL_REFUSED = 38;
  MAPI_DIAG_MAIL_UNCLAIMED = 39;
  MAPI_DIAG_MAIL_RECIPIENT_MOVED = 40;
  MAPI_DIAG_MAIL_RECIPIENT_TRAVELLING = 41;
  MAPI_DIAG_MAIL_RECIPIENT_DEPARTED = 42;
  MAPI_DIAG_MAIL_NEW_ADDRESS_UNKNOWN = 43;
  MAPI_DIAG_MAIL_FORWARDING_UNWANTED = 44;
  MAPI_DIAG_MAIL_FORWARDING_PROHIB = 45;
  MAPI_DIAG_SECURE_MESSAGING_ERROR = 46;
  MAPI_DIAG_DOWNGRADING_IMPOSSIBLE = 47;

  { Values of PR_DELIVERY_POINT (MH_T_DELIVERY_POINT) }
  
  MAPI_MH_DP_PUBLIC_UA = ULONG(0);
  MAPI_MH_DP_PRIVATE_UA = ULONG(1);
  MAPI_MH_DP_MS = ULONG(2);
  MAPI_MH_DP_ML = ULONG(3);
  MAPI_MH_DP_PDAU = ULONG(4);
  MAPI_MH_DP_PDS_PATRON = ULONG(5);
  MAPI_MH_DP_OTHER_AU = ULONG(6);

{ IMAPIFolder Interface --------------------------------------------------- }

{ IMAPIFolder folder type (enum) }
  
const
  FOLDER_ROOT = ULONG($00000000);
  FOLDER_GENERIC = ULONG($00000001);
  FOLDER_SEARCH = ULONG($00000002);
  
  { CreateMessage }
  
  {***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) below }
  
  {***** MAPI_ASSOCIATED         ((ULONG) 0x00000040) below }
  
  { CopyMessages }
  
  MESSAGE_MOVE = ULONG($00000001);
  MESSAGE_DIALOG = ULONG($00000002);
  
  {***** MAPI_DECLINE_OK         ((ULONG) 0x00000004) above }
  
  { CreateFolder }
  
  OPEN_IF_EXISTS = ULONG($00000001);
  
  {***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) below }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  { DeleteFolder }
  
  DEL_MESSAGES = ULONG($00000001);
  FOLDER_DIALOG = ULONG($00000002);
  DEL_FOLDERS = ULONG($00000004);
  
  { EmptyFolder }
  
  DEL_ASSOCIATED = ULONG($00000008);
  
  { CopyFolder }
  
  FOLDER_MOVE = ULONG($00000001);
  
  {***** FOLDER_DIALOG           ((ULONG) 0x00000002) above }
  
  {***** MAPI_DECLINE_OK         ((ULONG) 0x00000004) above }
  
  COPY_SUBFOLDERS = ULONG($00000010);
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }

  { SetReadFlags }
  
  {***** SUPPRESS_RECEIPT        ((ULONG) 0x00000001) below }
  
  {***** FOLDER_DIALOG           ((ULONG) 0x00000002) above }
  
  {***** CLEAR_READ_FLAG         ((ULONG) 0x00000004) below }
  
  {***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) below }
  
  {***** GENERATE_RECEIPT_ONLY   ((ULONG) 0x00000010) below }
  
  {***** CLEAR_RN_PENDING        ((ULONG) 0x00000020) below }
  
  {***** CLEAR_NRN_PENDING       ((ULONG) 0x00000040) below }
  
  { GetMessageStatus }
  
  MSGSTATUS_HIGHLIGHTED = ULONG($00000001);
  MSGSTATUS_TAGGED = ULONG($00000002);
  MSGSTATUS_HIDDEN = ULONG($00000004);
  MSGSTATUS_DELMARKED = ULONG($00000008);
  
  { Bits for remote message status }
  
  MSGSTATUS_REMOTE_DOWNLOAD = ULONG($00001000);
  MSGSTATUS_REMOTE_DELETE = ULONG($00002000);
  
  { SaveContentsSort }
  
  RECURSIVE_SORT = ULONG($00000002);
  
  { PR_STATUS property }
  
  FLDSTATUS_HIGHLIGHTED = ULONG($00000001);
  FLDSTATUS_TAGGED = ULONG($00000002);
  FLDSTATUS_HIDDEN = ULONG($00000004);
  FLDSTATUS_DELMARKED = ULONG($00000008);

{ IMessage Interface ------------------------------------------------------ }

{ SubmitMessage }
  
const
  FORCE_SUBMIT = ULONG($00000001);
  
  { Flags defined in PR_MESSAGE_FLAGS }
  
  MSGFLAG_READ = ULONG($00000001);
  MSGFLAG_UNMODIFIED = ULONG($00000002);
  MSGFLAG_SUBMIT = ULONG($00000004);
  MSGFLAG_UNSENT = ULONG($00000008);
  MSGFLAG_HASATTACH = ULONG($00000010);
  MSGFLAG_FROMME = ULONG($00000020);
  MSGFLAG_ASSOCIATED = ULONG($00000040);
  MSGFLAG_RESEND = ULONG($00000080);
  MSGFLAG_RN_PENDING = ULONG($00000100);
  MSGFLAG_NRN_PENDING = ULONG($00000200);
  
  { Flags defined in PR_SUBMIT_FLAGS }

  SUBMITFLAG_LOCKED = ULONG($00000001);
  SUBMITFLAG_PREPROCESS = ULONG($00000002);
  
  { GetAttachmentTable() }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  { GetRecipientTable() }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  { ModifyRecipients }
  
  { ((ULONG) 0x00000001 is not a valid flag on ModifyRecipients. }
  
  MODRECIP_ADD = ULONG($00000002);
  MODRECIP_MODIFY = ULONG($00000004);
  MODRECIP_REMOVE = ULONG($00000008);
  
  { SetReadFlag }
  
  SUPPRESS_RECEIPT = ULONG($00000001);
  CLEAR_READ_FLAG = ULONG($00000004);
  
  {***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) below }
  
  GENERATE_RECEIPT_ONLY = ULONG($00000010);
  CLEAR_RN_PENDING = ULONG($00000020);
  CLEAR_NRN_PENDING = ULONG($00000040);
  
  { DeleteAttach }
  
  ATTACH_DIALOG = ULONG($00000001);
  
  { PR_SECURITY values }
  
  SECURITY_SIGNED = ULONG($00000001);
  SECURITY_ENCRYPTED = ULONG($00000002);
  
  { PR_PRIORITY values }
  
  PRIO_URGENT = Longint(1);
  PRIO_NORMAL = Longint(0);
  PRIO_NONURGENT = Longint(-1);
  
  { PR_SENSITIVITY values }
  
  SENSITIVITY_NONE = ULONG($00000000);
  SENSITIVITY_PERSONAL = ULONG($00000001);
  SENSITIVITY_PRIVATE = ULONG($00000002);
  SENSITIVITY_COMPANY_CONFIDENTIAL = ULONG($00000003);
  
  { PR_IMPORTANCE values }
  
  IMPORTANCE_LOW = Longint(0);
  IMPORTANCE_NORMAL = Longint(1);
  IMPORTANCE_HIGH = Longint(2);

{ IMsgStore Interface ----------------------------------------------------- }

{  PR_STORE_SUPPORT_MASK bits }
  
const
  STORE_ENTRYID_UNIQUE = ULONG($00000001);
  STORE_READONLY = ULONG($00000002);
  STORE_SEARCH_OK = ULONG($00000004);
  STORE_MODIFY_OK = ULONG($00000008);
  STORE_CREATE_OK = ULONG($00000010);
  STORE_ATTACH_OK = ULONG($00000020);
  STORE_OLE_OK = ULONG($00000040);
  STORE_SUBMIT_OK = ULONG($00000080);
  STORE_NOTIFY_OK = ULONG($00000100);
  STORE_MV_PROPS_OK = ULONG($00000200);
  STORE_CATEGORIZE_OK = ULONG($00000400);
  STORE_RTF_OK = ULONG($00000800);
  STORE_RESTRICTION_OK = ULONG($00001000);
  STORE_SORT_OK = ULONG($00002000);
  STORE_PUBLIC_FOLDERS = ULONG($00004000);
  STORE_UNCOMPRESSED_RTF = ULONG($00008000);
  
  { PR_STORE_STATE bits, try not to collide with PR_STORE_SUPPORT_MASK }

  STORE_HAS_SEARCHES = ULONG($01000000);
  
  { OpenEntry() }
  
  {***** MAPI_MODIFY             ((ULONG) 0x00000001) above }
  
  {***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) below }
  
  {***** MAPI_BEST_ACCESS        ((ULONG) 0x00000010) above }
  
  { SetReceiveFolder() }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  { GetReceiveFolder() }
  
  {***** MAPI_UNICODE            ((ULONG) 0x80000000) above }
  
  { GetReceiveFolderTable() }
  
  {***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) below }
  
  { StoreLogoff() }
  
  LOGOFF_NO_WAIT = ULONG($00000001);
  LOGOFF_ORDERLY = ULONG($00000002);
  LOGOFF_PURGE = ULONG($00000004);
  LOGOFF_ABORT = ULONG($00000008);
  LOGOFF_QUIET = ULONG($00000010);
  LOGOFF_COMPLETE = ULONG($00010000);
  LOGOFF_INBOUND = ULONG($00020000);
  LOGOFF_OUTBOUND = ULONG($00040000);
  LOGOFF_OUTBOUND_QUEUE = ULONG($00080000);
  
  { SetLockState() }
  
  MSG_LOCKED = ULONG($00000001);
  MSG_UNLOCKED = ULONG($00000000);
  
  { Flag bits for PR_VALID_FOLDER_MASK }

  FOLDER_IPM_SUBTREE_VALID = ULONG($00000001);
  FOLDER_IPM_INBOX_VALID = ULONG($00000002);
  FOLDER_IPM_OUTBOX_VALID = ULONG($00000004);
  FOLDER_IPM_WASTEBASKET_VALID = ULONG($00000008);
  FOLDER_IPM_SENTMAIL_VALID = ULONG($00000010);
  FOLDER_VIEWS_VALID = ULONG($00000020);
  FOLDER_COMMON_VIEWS_VALID = ULONG($00000040);
  FOLDER_FINDER_VALID = ULONG($00000080);

{ IDistList Interface ----------------------------------------------------- }

{ --------------------------------- }

{ Address Book interface definition }

{ ADRPARM ulFlags - top 4 bits used for versioning }

{  Current versions of ADRPARM  }
  
const
  ADRPARM_HELP_CTX = ULONG($00000000);
  
  {  ulFlags   - bit fields }
  
  DIALOG_MODAL = ULONG($00000001);
  DIALOG_SDI = ULONG($00000002);
  DIALOG_OPTIONS = ULONG($00000004);
  ADDRESS_ONE = ULONG($00000008);
  AB_SELECTONLY = ULONG($00000010);
  AB_RESOLVE = ULONG($00000020);
  
{ --------------------------------- }

{  PR_DISPLAY_TYPEs                 }

(*
 *  These standard display types are
 *  by default handled by MAPI.
 *  They have default icons associated
 *  with them.
 *)

  {  For address book contents tables }

  DT_MAILUSER = ULONG($00000000);
  DT_DISTLIST = ULONG($00000001);
  DT_FORUM = ULONG($00000002);
  DT_AGENT = ULONG($00000003);
  DT_ORGANIZATION = ULONG($00000004);
  DT_PRIVATE_DISTLIST = ULONG($00000005);
  DT_REMOTE_MAILUSER = ULONG($00000006);

  {  For address book hierarchy tables }

  DT_MODIFIABLE = ULONG($00010000);
  DT_GLOBAL = ULONG($00020000);
  DT_LOCAL = ULONG($00030000);
  DT_WAN = ULONG($00040000);
  DT_NOT_SPECIFIC = ULONG($00050000);
  
  {  For folder hierarchy tables }
  
  DT_FOLDER = ULONG($01000000);
  DT_FOLDER_LINK = ULONG($02000000);
  DT_FOLDER_SPECIAL = ULONG($04000000);
  
  {  Accelerator callback for DIALOG_SDI form of AB UI }
  
type
  TACCELERATEABSDI = function (ulUIParam : ULONG; lpvmsg : Pointer) : BOOL; stdcall;
  
  PFNABSDI = ^TACCELERATEABSDI;
  
{  Callback to application telling it that the DIALOG_SDI form of the }

{  AB UI has been dismissed.  This is so that the above LPFNABSDI     }

{  function doesn't keep being called.                                }

type
  TDISMISSMODELESS = function (ulUIParam : ULONG; lpvContext : Pointer) : Pointer; stdcall;
  
  PFNDISMISS = ^TDISMISSMODELESS;
  
(*
 * Prototype for the client function hooked to an optional button on
 * the address book dialog
 *)

type
  PFNBUTTON = function (ulUIParam : ULONG; lpvContext : Pointer; 
    cbEntryID : ULONG; lpSelection : PENTRYID; ulFlags : ULONG) : SCODE; stdcall;
  
{ Parameters for the address book dialog }

type
  TADRPARM =     
    record
      cbABContEntryID : ULONG;
      lpABContEntryID : PENTRYID;
      ulFlags : ULONG;
      lpReserved : Pointer;
      ulHelpContext : ULONG;
      lpszHelpFileName : PChar;
      lpfnABSDI : PFNABSDI;
      lpfnDismiss : PFNDISMISS;
      lpvDismissContext : Pointer;
      lpszCaption : PChar;
      lpszNewEntryTitle : PChar;
      lpszDestWellsTitle : PChar;
      cDestFields : ULONG;
      nDestFieldFocus : ULONG;
      lppszDestTitles : ^PChar;
      lpulDestComps : ^ULONG;
      lpContRestriction : PSRestriction;
      lpHierRestriction : PSRestriction;
    end;
    
  PADRPARM = ^TADRPARM;
  
{ ------------ }

{ Random flags }

{ Flag for deferred error }

const
  MAPI_DEFERRED_ERRORS = ULONG($00000008);

{ Flag for creating and using Folder Associated Information Messages }

const
  MAPI_ASSOCIATED = ULONG($00000040);

{ Flags for OpenMessageStore() }

const
  MDB_NO_DIALOG = ULONG($00000001);
  MDB_WRITE = ULONG($00000004);

{***** MAPI_DEFERRED_ERRORS    ((ULONG) 0x00000008) above }

{***** MAPI_BEST_ACCESS        ((ULONG) 0x00000010) above }

const
  MDB_TEMPORARY = ULONG($00000020);
  MDB_NO_MAIL = ULONG($00000080);

{ Flags for OpenAddressBook }

const
  AB_NO_DIALOG = ULONG($00000001);

{ IMAPIControl Interface -------------------------------------------------- }

{ Interface used in controls (particularly the button) defined by }

{ Display Tables. }

{  Flags for GetState }

const
  MAPI_ENABLED = ULONG($00000000);
  MAPI_DISABLED = ULONG($00000001);

type
  IMAPIControl =
    interface(IUnknown)
    [strIID_IMAPIControl]  
      function GetLastError (hResult : HResult; ulFlags : ULONG;
        var lppMAPIError : PMAPIERROR) : HResult; stdcall;
      function Activate (ulFlags : ULONG; ulUIParam : ULONG) : HResult; stdcall;
      function GetState (ulFlags : ULONG; var lpulState : ULONG) : HResult; stdcall;
    end;

{ Display Tables ---------------------------------------------------------- }

{ Flags used in display tables - that is, PR_CONTROL_FLAGS }

const
  DT_MULTILINE = ULONG($00000001);
  DT_EDITABLE = ULONG($00000002);
  DT_REQUIRED = ULONG($00000004);
  DT_SET_IMMEDIATE = ULONG($00000008);
  DT_PASSWORD_EDIT = ULONG($00000010);
  DT_ACCEPT_DBCS = ULONG($00000020);
  DT_SET_SELECTION = ULONG($00000040);

{ Display Table structures }

const
  DTCT_LABEL = ULONG($00000000);
  DTCT_EDIT = ULONG($00000001);
  DTCT_LBX = ULONG($00000002);
  DTCT_COMBOBOX = ULONG($00000003);
  DTCT_DDLBX = ULONG($00000004);
  DTCT_CHECKBOX = ULONG($00000005);
  DTCT_GROUPBOX = ULONG($00000006);
  DTCT_BUTTON = ULONG($00000007);
  DTCT_PAGE = ULONG($00000008);
  DTCT_RADIOBUTTON = ULONG($00000009);
  DTCT_MVLISTBOX = ULONG($0000000);
  DTCT_MVDDLBX = ULONG($0000000C);

{ Labels }

{ Valid ulFlags:
 *   MAPI_UNICODE
 }

type
  TDTBLLABEL =     
    record
      ulbLpszLabelName : ULONG;
      ulFlags : ULONG;
    end;
    
  PDTBLLABEL = ^TDTBLLABEL;
  
{  Simple Text Edits  }

{ Valid ulFlags:
 *   MAPI_UNICODE
 }

type
  TDTBLEDIT =     
    record
      ulbLpszCharsAllowed : ULONG;
      ulFlags : ULONG;
      ulNumCharsAllowed : ULONG;
      ulPropTag : ULONG;
    end;
    
  PDTBLEDIT = ^TDTBLEDIT;
  
{  List Box  }

{ Valid ulFlags:
 }

const
  MAPI_NO_HBAR = ULONG($00000001);
  MAPI_NO_VBAR = ULONG($00000002);

type
  TDTBLLBX =     
    record
      ulFlags : ULONG;
      ulPRSetProperty : ULONG;
      ulPRTableName : ULONG;
    end;
    
  PDTBLLBX = ^TDTBLLBX;
  
{  Combo Box   }

{ Valid ulFlags:
 *   MAPI_UNICODE
 }

type
  TDTBLCOMBOBOX =     
    record
      ulbLpszCharsAllowed : ULONG;
      ulFlags : ULONG;
      ulNumCharsAllowed : ULONG;
      ulPRPropertyName : ULONG;
      ulPRTableName : ULONG;
    end;
    
  PDTBLCOMBOBOX = ^TDTBLCOMBOBOX;
  
{  Drop Down   }

{ Valid ulFlags:
 *   none
 }

type
  TDTBLDDLBX =     
    record
      ulFlags : ULONG;
      ulPRDisplayProperty : ULONG;
      ulPRSetProperty : ULONG;
      ulPRTableName : ULONG;
    end;
    
  PDTBLDDLBX = ^TDTBLDDLBX;
  
{  Check Box   }

{ Valid ulFlags:
 *   MAPI_UNICODE
 }

type
  TDTBLCHECKBOX =     
    record
      ulbLpszLabel : ULONG;
      ulFlags : ULONG;
      ulPRPropertyName : ULONG;
    end;
    
  PDTBLCHECKBOX = ^TDTBLCHECKBOX;
  
{  Group Box   }

{ Valid ulFlags:
 *   MAPI_UNICODE
 }

type
  TDTBLGROUPBOX =     
    record
      ulbLpszLabel : ULONG;
      ulFlags : ULONG;
    end;
    
  PDTBLGROUPBOX = ^TDTBLGROUPBOX;
  
{  Button control   }

{ Valid ulFlags:
 *   MAPI_UNICODE
 }

type
  TDTBLBUTTON =     
    record
      ulbLpszLabel : ULONG;
      ulFlags : ULONG;
      ulPRControl : ULONG;
    end;
    
  PDTBLBUTTON = ^TDTBLBUTTON;
  
{  Pages   }

{ Valid ulFlags:
 *   MAPI_UNICODE
 }

type
  TDTBLPAGE =     
    record
      ulbLpszLabel : ULONG;
      ulFlags : ULONG;
      ulbLpszComponent : ULONG;
      ulContext : ULONG;
    end;
    
  PDTBLPAGE = ^TDTBLPAGE;
  
{  Radio button   }

{ Valid ulFlags:
 *   MAPI_UNICODE
 }

type
  TDTBLRADIOBUTTON =     
    record
      ulbLpszLabel : ULONG;
      ulFlags : ULONG;
      ulcButtons : ULONG;
      ulPropTag : ULONG;
      lReturnValue : Longint;
    end;
    
  PDTBLRADIOBUTTON = ^TDTBLRADIOBUTTON;
  
{  MultiValued listbox }

{ Valid ulFlags:
 *   none
 }

type
  TDTBLMVLISTBOX =     
    record
      ulFlags : ULONG;
      ulMVPropTag : ULONG;
    end;
    
  PDTBLMVLISTBOX = ^TDTBLMVLISTBOX;
  
{  MultiValued dropdown }

{ Valid ulFlags:
 *   none
 }

type
  TDTBLMVDDLBX =     
    record
      ulFlags : ULONG;
      ulMVPropTag : ULONG;
    end;
    
  PDTBLMVDDLBX = ^TDTBLMVDDLBX;
  
{ IProviderAdmin Interface ---------------------------------------------- }

{ Flags for ConfigureMsgService }

const
  UI_SERVICE = $00000002;
  SERVICE_UI_ALWAYS = $00000002        { Duplicate UI_SERVICE for consistency and compatibility }
  ;
  SERVICE_UI_ALLOWED = $00000010;
  UI_CURRENT_PROVIDER_FIRST = $00000004;

{ MSG_SERVICE_UI_READ_ONLY         0x00000008 - in MAPISPI.H }

{ GetProviderTable() }

{***** MAPI_UNICODE            ((ULONG) 0x80000000) above }

{ Values for PR_RESOURCE_FLAGS in message service table }

{ IAttach Interface ------------------------------------------------------- }

{ IAttach attachment methods: PR_ATTACH_METHOD values }
  
const
  NO_ATTACHMENT = ULONG($00000000);
  ATTACH_BY_VALUE = ULONG($00000001);
  ATTACH_BY_REFERENCE = ULONG($00000002);
  ATTACH_BY_REF_RESOLVE = ULONG($00000003);
  ATTACH_BY_REF_ONLY = ULONG($00000004);
  ATTACH_EMBEDDED_MSG = ULONG($00000005);
  ATTACH_OLE = ULONG($00000006);

{!! Interface declarations }

type
  IMessage = interface;
  IAttach = interface;

  IMailUser =
    interface(IMAPIProp)
    [strIID_IMailUser]
    end;
  
  IDistList =
    interface(IMAPIContainer)
    [strIID_IDistList]
      function CreateEntry (cbEntryID : ULONG; lpEntryID : PENTRYID;
        ulCreateFlags : ULONG; var lppMAPIPropEntry : IMAPIProp) : HResult; stdcall;
      function CopyEntries (lpEntries : PENTRYLIST; ulUIParam : ULONG;
        lpProgress : IMAPIProgress; ulFlags : ULONG) : HResult; stdcall;
      function DeleteEntries (lpEntries : PENTRYLIST; ulFlags : ULONG) : HResult; stdcall;
      function ResolveNames (lpPropTagArray : PSPropTagArray; ulFlags : ULONG; 
        lpAdrList : PADRLIST; lpFlagList : PFlagList) : HResult; stdcall;
    end;
  
  IMAPIFolder =
    interface(IMAPIContainer)
    [strIID_IMAPIFolder]
      function CreateMessage (const lpInterface : TIID; ulFlags : ULONG;
        var lppMessage : IMessage) : HResult; stdcall;
      function CopyMessages (lpMsgList : PENTRYLIST; const lpInterface : TIID;
        lpDestFolder : Pointer; ulUIParam : ULONG; lpProgress : IMAPIProgress;
        ulFlags : ULONG) : HResult; stdcall;
      function DeleteMessages (lpMsgList : PENTRYLIST; ulUIParam : ULONG;
        lpProgress : IMAPIProgress; ulFlags : ULONG) : HResult; stdcall;
      function CreateFolder (ulFolderType : ULONG; lpszFolderName : PChar; 
        lpszFolderComment : PChar; const lpInterface : TIID; ulFlags : ULONG; 
        var lppFolder : IMAPIFolder) : HResult; stdcall;
      function CopyFolder (cbEntryID : ULONG; lpEntryID : PENTRYID;
        const lpInterface : TIID; lpDestFolder : Pointer; lpszNewFolderName : PChar; 
        ulUIParam : ULONG; lpProgress : IMAPIProgress; ulFlags : ULONG) : HResult; stdcall;
      function DeleteFolder (cbEntryID : ULONG; lpEntryID : PENTRYID; 
        ulUIParam : ULONG; lpProgress : IMAPIProgress; ulFlags : ULONG) : HResult; stdcall;
      function SetReadFlags (lpMsgList : PENTRYLIST; ulUIParam : ULONG; 
        lpProgress : IMAPIProgress; ulFlags : ULONG) : HResult; stdcall;
      function GetMessageStatus (cbEntryID : ULONG; lpEntryID : PENTRYID;
        ulFlags : ULONG; var lpulMessageStatus : ULONG) : HResult; stdcall;
      function SetMessageStatus (cbEntryID : ULONG; lpEntryID : PENTRYID;
        ulNewStatus : ULONG; ulNewStatusMask : ULONG; var lpulOldStatus : ULONG) : HResult; stdcall;
      function SaveContentsSort (lpSortCriteria : PSSortOrderSet; ulFlags : ULONG) : HResult; stdcall;
      function EmptyFolder (ulUIParam : ULONG; lpProgress : IMAPIProgress;
        ulFlags : ULONG) : HResult; stdcall;
    end;

  IMsgStore =
    interface(IMAPIProp)
    [strIID_IMsgStore]  
      function Advise (cbEntryID : ULONG; lpEntryID : PENTRYID; ulEventMask : ULONG;
        lpAdviseSink : IMAPIAdviseSink; var lpulConnection : ULONG) : HResult; stdcall;
      function Unadvise (ulConnection : ULONG) : HResult; stdcall;
      function CompareEntryIDs (cbEntryID1 : ULONG; lpEntryID1 : PENTRYID; 
        cbEntryID2 : ULONG; lpEntryID2 : PENTRYID; ulFlags : ULONG; 
        var lpulResult : ULONG) : HResult; stdcall;
      function OpenEntry (cbEntryID : ULONG; lpEntryID : PENTRYID; const lpInterface : TIID;
        ulFlags : ULONG; var lpulObjType : ULONG; var lppUnk : IUnknown) : HResult; stdcall;
      function SetReceiveFolder (lpszMessageClass : PChar; ulFlags : ULONG; 
        cbEntryID : ULONG; lpEntryID : PENTRYID) : HResult; stdcall;
      function GetReceiveFolder (lpszMessageClass : PChar; ulFlags : ULONG; 
        var lpcbEntryID : ULONG; var lppEntryID : PENTRYID; 
        var lppszExplicitClass : PChar) : HResult; stdcall;
      function GetReceiveFolderTable (ulFlags : ULONG; var lppTable : IMAPITable) : HResult; stdcall;
      function StoreLogoff (var lpulFlags : ULONG) : HResult; stdcall;
      function AbortSubmit (cbEntryID : ULONG; lpEntryID : PENTRYID; ulFlags : ULONG) : HResult; stdcall;
      function GetOutgoingQueue (ulFlags : ULONG; var lppTable : IMAPITable) : HResult; stdcall;
      function SetLockState (lpMessage : IMessage; ulLockState : ULONG) : HResult; stdcall;
      function FinishedMsg (ulFlags : ULONG; cbEntryID : ULONG; lpEntryID : PENTRYID) : HResult; stdcall;
      function NotifyNewMail (lpNotification : PNOTIFICATION) : HResult; stdcall;
    end;

  IMessage =
    interface(IMAPIProp)
    [strIID_IMessage]
      function GetAttachmentTable (ulFlags : ULONG; var lppTable : IMAPITable) : HResult; stdcall;
      function OpenAttach (ulAttachmentNum : ULONG; const lpInterface : TIID; 
        ulFlags : ULONG; var lppAttach : IAttach) : HResult; stdcall;
      function CreateAttach (const lpInterface : TIID; ulFlags : ULONG; 
        var lpulAttachmentNum : ULONG; var lppAttach : IAttach) : HResult; stdcall;
      function DeleteAttach (ulAttachmentNum : ULONG; ulUIParam : ULONG; 
        lpProgress : IMAPIProgress; ulFlags : ULONG) : HResult; stdcall;
      function GetRecipientTable (ulFlags : ULONG; var lppTable : IMAPITable) : HResult; stdcall;
      function ModifyRecipients (ulFlags : ULONG; lpMods : PADRLIST) : HResult; stdcall;
      function SubmitMessage (ulFlags : ULONG) : HResult; stdcall;
      function SetReadFlag (ulFlags : ULONG) : HResult; stdcall;
    end;
  
  IAttach =
    interface(IMAPIProp)
    [strIID_IAttachment]
    end;

  IProviderAdmin =
    interface(IUnknown)
    [strIID_IProviderAdmin]
      function GetLastError (hResult : HResult; ulFlags : ULONG;
        var lppMAPIError : PMAPIERROR) : HResult; stdcall;
      function GetProviderTable (ulFlags : ULONG; var lppTable : IMAPITable) : HResult; stdcall;
      function CreateProvider (lpszProvider : PChar; cValues : ULONG;
        lpProps : PSPropValue; ulUIParam : ULONG; ulFlags : ULONG;
        var lpUID : TMAPIUID) : HResult; stdcall;
      function DeleteProvider (lpUID : PMAPIUID) : HResult; stdcall;
      function OpenProfileSection (lpUID : PMAPIUID; const lpInterface : TIID;
        ulFlags : ULONG; var lppProfSect : IProfSect) : HResult; stdcall;
    end;
  
implementation

end.

