unit tmapi1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    ListBox1: TListBox;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  ComObj,
  MapiX, MapiCode, MapiTags, MapiDefs,
  MapiForm, MapiHook, MapiWz, MapiSpi, Imessage, Tnef;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  Session : IMAPISession;
  Table : IMAPITable;
  I, N, RowCount : Integer;
  RowSet : PSRowSet;
  Row : TSRow;
  DisplayName : string;
begin
  { Note: This sample does not implement a particularly good error-checking
    scheme. Do not use OleCheck in "real world" MAPI applications. }

  OleCheck(MAPIInitialize(nil));
  try
    OleCheck(MAPILogonEx(Self.Handle, nil, nil, MAPI_LOGON_UI, Session));

    OleCheck(Session.GetMsgStoresTable(0, Table));
    try
      OleCheck(Table.GetRowCount(0, ULONG(RowCount)));
      OleCheck(Table.QueryRows(RowCount, 0, RowSet));

      DisplayName:='';
      for I:=0 to RowSet^.cRows - 1 do
        begin
          {$R-}  // Needed to avoid run-time errors on array indexes
          Row:=RowSet^.aRow[I];
          for N:=0 to Row.cValues - 1 do
            if Row.lpProps^[N].ulPropTag = PR_DISPLAY_NAME then
              begin
                ListBox1.Items.Add(string(Row.lpProps[N].Value.lpszA));
                Break;
              end;
          {$R+}
        end;

      MAPIFreeBuffer(RowSet);
    finally
      Table:=nil;
    end;

    OleCheck(Session.Logoff(Self.Handle, MAPI_LOGOFF_UI, 0));

    Session:=nil;
  finally
    MAPIUninitialize;
  end;
end;


end.
