unit Unit7;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Class_LotusNotes;

type
  TAclForm = class(TForm)
    btCancel: TButton;
    btOK: TButton;
    Label2: TLabel;
    lbEntry: TListBox;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Label1: TLabel;
    lbRoles: TListBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure btOKClick(Sender: TObject);
    procedure lbEntryClick(Sender: TObject);
    procedure lbRolesClick(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
  private
    Db: TNotesDatabase;
  public
    procedure SetInfo (aDB: TNotesDatabase);
  end;

var
  AclForm: TAclForm;

implementation

{$R *.DFM}

procedure TAclForm.SetInfo;
var
  i: integer;
begin
  DB := aDB;
  lbRoles.clear;
  lbRoles.Items.AddStrings (Db.ACL.Roles);
  lbEntry.clear;
  for i := 0 to Db.ACL.EntriesCount-1 do lbEntry.Items.Add(Db.Acl.EntryByIndex[i].Name);
end;

procedure TAclForm.Button2Click(Sender: TObject);
var
  buf: string;
begin
  with lbRoles do begin
    if itemIndex = -1 then exit;
    buf := Items[itemIndex];
    if InputQuery('Roles','Enter role name', buf) then begin
      DB.ACL.Roles[itemIndex] := buf;
      clear;
      Items.AddStrings (Db.ACL.Roles);
    end;
  end;
end;

procedure TAclForm.Button1Click(Sender: TObject);
var
  buf: string;
begin
  with lbRoles do begin
    buf := '';
    if InputQuery('Roles','Enter role name', buf) then begin
      DB.ACL.Roles.Add (buf);
      clear;
      Items.AddStrings (Db.ACL.Roles);
    end;
  end;
end;

procedure TAclForm.Button3Click(Sender: TObject);
begin
  with lbRoles do begin
    if itemIndex = -1 then exit;
    DB.ACL.Roles.Delete (itemIndex);
    clear;
    Items.AddStrings (Db.ACL.Roles);
  end;
end;

procedure TAclForm.btOKClick(Sender: TObject);
begin
  DB.ACL.Save;
end;

procedure TAclForm.lbEntryClick(Sender: TObject);
var
  s: string;
  i: integer;
begin
  with LbEntry do begin
    if itemIndex = -1 then exit;
    s := Db.ACL.EntryByIndex[itemIndex].Roles;
  end;
  with lbRoles do for i := 0 to Items.count-1 do begin
    Selected[i] := Pos (Items[i] + #13#10, s) > 0;
  end;
end;

procedure TAclForm.lbRolesClick(Sender: TObject);
var
  i: integer;
begin
  if (lbRoles.itemIndex = -1) or (lbEntry.itemIndex = -1) then exit;
  with lbRoles do for i := 0 to Items.count-1 do begin
    if Selected[i]
      then Db.Acl.EntryByIndex[lbEntry.itemIndex].AddRole(Items[i])
      else Db.Acl.EntryByIndex[lbEntry.itemIndex].DeleteRole(Items[i]);
  end;
end;

procedure TAclForm.Button6Click(Sender: TObject);
var
  buf: string;
  e: TNotesACLEntry;
  i: integer;
begin
  with lbEntry do begin
    buf := '';
    if InputQuery('ACL Entries','Enter entry name', buf) then begin
      e := DB.ACL.CreateAclEntry(buf);
      e.Flags := e.Flags + [acfPerson];
      e.AccessLevel := aclManager;
      clear;
      for i := 0 to Db.ACL.EntriesCount-1 do Items.Add(Db.Acl.EntryByIndex[i].Name);
    end;
  end;
end;

procedure TAclForm.Button7Click(Sender: TObject);
var
  buf: string;
  i: integer;
begin
  with lbEntry do begin
    if itemIndex = -1 then exit;
    buf := Items[itemIndex];
    if InputQuery('ACL Entries','Enter entry name', buf) then begin
      DB.ACL.EntryByIndex[itemIndex].Name := buf;
      clear;
      for i := 0 to Db.ACL.EntriesCount-1 do Items.Add(Db.Acl.EntryByIndex[i].Name);
    end;
  end;
end;

procedure TAclForm.Button8Click(Sender: TObject);
var
  i: integer;
begin
  with lbEntry do begin
    if itemIndex = -1 then exit;
    DB.ACL.DeleteACLEntry (Items[itemIndex]);
    clear;
    for i := 0 to Db.ACL.EntriesCount-1 do Items.Add(Db.Acl.EntryByIndex[i].Name);
  end;
end;

end.
