unit Unit6;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Class_LotusNotes;

type
  TViewsForm = class(TForm)
    List: TListBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    procedure FormHide(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
  private
    DB: TNotesDatabase;
    procedure AddView (aView: TNotesView);
    procedure Clear;
  public
    procedure SetInfo (aDB: TNotesDatabase);
  end;

var
  ViewsForm: TViewsForm;

implementation
uses Unit1;

{$R *.DFM}

procedure TViewsForm.Clear;
begin
  List.Clear;
end;

procedure TViewsForm.SetInfo;
var
  View: TNotesView;
  i: integer;
begin
  DB := aDB;
  Clear;
  for i := 0 to Db.ViewCount-1 do begin
    View := Db.ViewByIndex[i];  //don't need to free
    AddView(View);
  end;
end;

procedure TViewsForm.FormHide(Sender: TObject);
begin
  Clear;
end;

procedure TViewsForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caHide;
end;

procedure TViewsForm.AddView;
var
  s: string;
begin
  s := aView.Name;
  if aView is TNotesFolder then begin    //or View.IsFolder
    appendStr (s, ' (');
    if TNotesFolder(aView).IsShared
      then appendStr (s, 'shared folder)')
      else appendStr (s, 'private folder)');
  end;
  List.Items.AddObject(s,aView);
end;

procedure TViewsForm.Button2Click(Sender: TObject);
begin
  with List do begin
    if itemIndex = -1 then exit;
    EnumDocs(Items.Objects[itemIndex] as TNotesView);
  end;
end;

procedure TViewsForm.Button3Click(Sender: TObject);
var
  s: string;
  fShared: boolean;
begin
  s := InputBox('Create folder','Enter a folder name','');
  if s = '' then exit;
  case MessageDlg('Create a shared folder ' + s + '?',mtConfirmation,[mbYes,mbNo,mbCancel],0) of
    mrYes: fShared := True;
    mrNo:  fShared := False;
    else exit;
  end;
  TNotesFolder.CreateNew(Db, s, fShared, nil);
  SetInfo(DB);
end;

procedure TViewsForm.Button4Click(Sender: TObject);
var
  s: string;
  f: TNotesView;
begin
  s := InputBox('Create folder','Enter a folder name','');
  if s = '' then exit;
  with List do begin
    if itemIndex = -1 then exit;
    f := Items.Objects[itemIndex] as TNotesView;
    if not f.IsFolder then exit;
    TNotesFolder(f).Name := s;
  end;
  SetInfo(DB);
end;

procedure TViewsForm.Button5Click(Sender: TObject);
var
  f: TNotesView;
begin
  with List do begin
    if itemIndex = -1 then exit;
    f := Items.Objects[itemIndex] as TNotesView;
    if not f.IsFolder then exit;
    TNotesFolder(f).Delete;
    Items.Delete(itemIndex);
  end;
  SetInfo(DB);
end;

procedure TViewsForm.Button6Click(Sender: TObject);
var
  f: TNotesView;
begin
  with List do begin
    if itemIndex = -1 then exit;
    f := Items.Objects[itemIndex] as TNotesView;
    if not f.IsFolder then exit;
    TNotesFolder(f).Clear;
  end;
end;

end.

