unit Unit5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, Class_LotusNotes, Util_LnAPI;

type
  TReadDocDlg = class(TForm)
    Fields: TStringGrid;
    Label1: TLabel;
    Button1: TButton;
    BtReply: TButton;
    Button3: TButton;
    LSign: TLabel;
    BtReply2: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtReplyClick(Sender: TObject);
    procedure BtReply2Click(Sender: TObject);
  private
    Doc: TNotesDocument;
    fMail: boolean;
  public
    procedure OpenDoc(aDoc: TNotesDocument; aMail: boolean);
  end;

var
  ReadDocDlg: TReadDocDlg;

implementation

uses Unit4;

{$R *.DFM}
type
  TFieldMapRec = record
    fieldType: word;
    fieldName: string;
  end;
const
  FieldNameMap: array[0..31] of TFieldMapRec = (
   (fieldType:TYPE_ERROR; fieldName:               'ERROR'),
   (fieldType:TYPE_UNAVAILABLE; fieldName:         'UNAVAILABLE'),
   (fieldType:TYPE_TEXT; fieldName:                'TEXT'),
   (fieldType:TYPE_TEXT_LIST; fieldName:           'TEXT_LIST'),
   (fieldType:TYPE_NUMBER; fieldName:              'NUMBER'),
   (fieldType:TYPE_NUMBER_RANGE; fieldName:        'NUMBER_RANGE'),
   (fieldType:TYPE_TIME; fieldName:                'TIME'),
   (fieldType:TYPE_TIME_RANGE; fieldName:          'TIME_RANGE'),
   (fieldType:TYPE_FORMULA; fieldName:             'FORMULA'),
   (fieldType:TYPE_USERID; fieldName:              'USERID'),
   (fieldType:TYPE_INVALID_OR_UNKNOWN; fieldName:  'INVALID_OR_UNKNOWN'),
   (fieldType:TYPE_COMPOSITE; fieldName:           'COMPOSITE'),
   (fieldType:TYPE_COLLATION; fieldName:           'COLLATION'),
   (fieldType:TYPE_OBJECT; fieldName:              'OBJECT'),
   (fieldType:TYPE_NOTEREF_LIST; fieldName:        'NOTEREF_LIST'),
   (fieldType:TYPE_VIEW_FORMAT; fieldName:         'VIEW_FORMAT'),
   (fieldType:TYPE_ICON; fieldName:                'ICON'),
   (fieldType:TYPE_NOTELINK_LIST; fieldName:       'NOTELINK_LIST'),
   (fieldType:TYPE_SIGNATURE; fieldName:           'SIGNATURE'),
   (fieldType:TYPE_SEAL; fieldName:                'SEAL'),
   (fieldType:TYPE_SEALDATA; fieldName:            'SEALDATA'),
   (fieldType:TYPE_SEAL_LIST; fieldName:           'SEAL_LIST'),
   (fieldType:TYPE_HIGHLIGHTS; fieldName:          'HIGHLIGHTS'),
   (fieldType:TYPE_WORKSHEET_DATA; fieldName:      'WORKSHEET_DATA'),
   (fieldType:TYPE_USERDATA; fieldName:            'USERDATA'),
   (fieldType:TYPE_QUERY; fieldName:               'QUERY'),
   (fieldType:TYPE_ACTION; fieldName:              'ACTION'),
   (fieldType:TYPE_ASSISTANT_INFO; fieldName:      'ASSISTANT_INFO'),
   (fieldType:TYPE_VIEWMAP_DATASET; fieldName:     'VIEWMAP_DATASET'),
   (fieldType:TYPE_VIEWMAP_LAYOUT; fieldName:      'VIEWMAP_LAYOUT'),
   (fieldType:TYPE_LSOBJECT; fieldName:            'LSOBJECT'),
   (fieldType:TYPE_HTML; fieldName:                'HTML')
  );

procedure TReadDocDlg.OpenDoc(aDoc: TNotesDocument; aMail: boolean);
var
  i, j: integer;
  fname, s, s1: string;
  v: variant;
begin
  Doc := aDoc;
  fMail := aMail;
  BtReply.Enabled := fMail;
  BtReply2.Enabled := fMail;
  with Fields do begin
    RowCount := 2;
    Cells[0,0] := 'Name';
    Cells[1,0] := 'Delphi type';
    Cells[2,0] := 'Notes type';
    Cells[3,0] := 'Value';
    Cells[0,1] := '';
    Cells[1,1] := '';
    Cells[2,1] := '';
    Cells[3,1] := '';
    if Doc.FieldCount > 0 then begin
      RowCount := Doc.FieldCount+1;
      for i := 0 to Doc.FieldCount-1 do begin
        fname := Doc.FieldName[i];
        Cells[0,i+1] := fname;
        try
          v := Doc[fname].Value;
          s := '';
          if (VarType(v) and varArray) <> 0 then s := 'Array of ';
          case VarType (v) and varTypeMask of
            varEmpty:    appendStr (s, 'Empty');
            varNull:     appendStr (s, 'Null');
            varSmallint: appendStr (s, 'Smallint');
            varInteger:  appendStr (s, 'Integer');
            varSingle: appendStr (s, 'Single');
            varDouble: appendStr (s, 'Double');
            varCurrency: appendStr (s, 'Currency');
            varDate: appendStr (s, 'Date');
            varOleStr: appendStr (s, 'OleStr');
            varDispatch: appendStr (s, 'Dispatch');
            varError: appendStr (s, 'Error');
            varBoolean: appendStr (s, 'Boolean');
            varVariant: appendStr (s, 'Variant');
            varUnknown: appendStr (s, 'Unknown');
            varByte: appendStr (s, 'Byte');
            varString: appendStr (s, 'String');
          end;
          if (VarType(v) and varArray) = 0 then s1 := VarAsType(v, varString)
          else begin
            s1 := '';
            for j := VarArrayLowBound(v,1) to VarArrayHighBound(v,1) do begin
              if (VarType(v) and varTypeMask) = varDate
                then appendStr (s1, dateTimeToStr (VarToDateTime (v[j])) + '; ')
                else appendStr (s1, VarAsType (v[j],varString) + '; ');
            end;
          end;
        except
          on E: Exception do s1 := 'ERROR: ' + E.Message;
        end;
        Cells[1,i+1] := s;
        for j := System.Low(FieldNameMap) to System.High(FieldNameMap) do
          if FieldNameMap[j].fieldType = Doc[fname].itemType then
            Cells[2,i+1] := FieldNameMap[j].fieldName;
        Cells[3,i+1] := s1;
      end;
    end;
  end;
  if Doc.GetSignature (s, s1, nil) then
    LSign.Caption := 'Signed by ' + s + ' according to ' + s1;
end;

procedure TReadDocDlg.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caHide;
end;

procedure TReadDocDlg.BtReplyClick(Sender: TObject);
begin
  SendMailDlg.StartReply (Doc, True);
  SendMailDlg.ShowModal;
end;

procedure TReadDocDlg.BtReply2Click(Sender: TObject);
begin
  SendMailDlg.StartReply (Doc, False);
  SendMailDlg.ShowModal;
end;

end.
