unit Unit4;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Class_LotusNotes, Class_NotesRTF;

type
  TSendMailDlg = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    eAddress: TEdit;
    eCc: TEdit;
    ESubject: TEdit;
    mBody: TMemo;
    BtSend: TButton;
    Button2: TButton;
    BtFont: TButton;
    FontDialog: TFontDialog;
    CbRtf: TCheckBox;
    LReply: TLabel;
    procedure BtFontClick(Sender: TObject);
    procedure BtSendClick(Sender: TObject);
  private
    Mail: TNotesDocument;
    SimpleMailSending: boolean;
    MailboxDb: TNotesDatabase;
    procedure Init;
  public
    procedure StartReply (aMail: TNotesDocument; fSimple: boolean);
    procedure StartMail (aMailboxDB: TNotesDatabase; fSimple: boolean);
  end;

var
  SendMailDlg: TSendMailDlg;

implementation

{$R *.DFM}
procedure TSendMailDlg.StartReply;
begin
  Mail := aMail;
  SimpleMailSending := fSimple;
  MailboxDb := Mail.Database;
  Init;
end;

procedure TSendMailDlg.StartMail;
begin
  SimpleMailSending := fSimple;
  MailboxDB := aMailboxDB;
  Mail := nil;
  Init;
end;

procedure TSendMailDlg.BtFontClick(Sender: TObject);
begin
  if FontDialog.Execute then mBody.Font := FontDialog.Font;
end;

procedure TSendMailDlg.BtSendClick(Sender: TObject);
var
  Doc: TNotesDocument;
  Rtf: TNotesRichTextItem;
  i: integer;
begin
  if SimpleMailSending then begin
    // Simple function
    if Mail = nil then begin
      MailboxDb.SendMail (eAddress.text, eSubject.text, mBody.Lines.Text);
      showMessage ('Simple mail sent');
    end
    else begin
      MailboxDb.ReplyMail (Mail, mBody.Lines.Text);
      showMessage ('Simple reply sent');
    end;
  end
  else begin
    // More complex
    if Mail = nil
      then Doc := MailboxDb.CreateDocument
      else Doc := TNotesDocument.CreateResponse (MailboxDB, Mail);
    try
      // Assign simple mail fields
      if Mail = nil then begin
        Doc.SendTo := eAddress.Text;  //or Doc['SendTo'].AsString := ...
        Doc.Subject := eSubject.text; //or Doc['Subject'].AsString := ...
      end;

      // Plain items used in mailing
      Doc['CopyTo'].AsString := eCc.text;

      if not CbRtf.checked then begin
        // Body - simple way
        Doc.Body := mBody.Lines;
        // or Doc.BodyAsString := mBody.Lines.Text
      end
      else begin
        // Body - rich text item
        Rtf := TNotesRichTextItem.CreateNew (Doc, 'Body');
        try
          Rtf.CreateContext;
          Rtf.FontFaceName := mBody.Font.Name;
          Rtf.FontBold := fsBold in mBody.Font.Style;
          Rtf.FontItalic := fsItalic in mBody.Font.Style;
          Rtf.FontUnderline := fsUnderline in mBody.Font.Style;
          Rtf.FontSize := mBody.Font.Size;
          for i := 0 to mBody.Lines.count-1 do begin
            Rtf.AddText (mBody.Lines[i]);
            Rtf.AddPara;
          end;
          Rtf.SaveContext;
        finally
          Rtf.Free;
        end;
      end;

      // Sending
      Doc.CheckAddress;
      Doc.Sign;
      Doc.Send (False, '');
      if Mail = nil
        then showMessage ('Advanced mail sent')
        else showMessage ('Advanced reply sent');
    finally
      Doc.free;
    end;
  end;
end;

procedure TSendMailDlg.Init;
begin
  if Mail = nil then begin
    LReply.Caption := '';
    ESubject.Enabled := True;
    EAddress.Enabled := True;
  end
  else begin
    LReply.Caption := 'Reply to ' + UNIDToStr (Mail.UniversalID);
    ESubject.Enabled := False;
    ESubject.Text := 'Re: ' + Mail.Subject;
    EAddress.Enabled := False;
    EAddress.Text := Mail.MailFrom;
  end;
  eCc.enabled := not SimpleMailSending;
  btFont.enabled := not SimpleMailSending;
  cbRtf.Enabled := not SimpleMailSending;
end;

end.
