unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Class_LotusNotes;

type
  TNameDlg = class(TForm)
    Label1: TLabel;
    EName: TEdit;
    BtOk: TButton;
    BtClose: TButton;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label4: TLabel;
    Edit3: TEdit;
    Label5: TLabel;
    Edit4: TEdit;
    Label6: TLabel;
    Edit5: TEdit;
    Label7: TLabel;
    Edit6: TEdit;
    Label8: TLabel;
    Edit7: TEdit;
    Label9: TLabel;
    Edit11: TEdit;
    Label10: TLabel;
    Edit12: TEdit;
    Label11: TLabel;
    Edit13: TEdit;
    Label12: TLabel;
    Cbh: TCheckBox;
    Label13: TLabel;
    EKey: TEdit;
    Label14: TLabel;
    Edit8: TEdit;
    Label15: TLabel;
    Edit9: TEdit;
    Label16: TLabel;
    Edit10: TEdit;
    Label17: TLabel;
    procedure BtOkClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure GetEdit(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    { Private declarations }
  public
    Name: TNotesName;
		procedure SetEdit (n: integer; aText: string); 
  end;

var
  NameDlg: TNameDlg;

implementation

{$R *.DFM}

procedure TNameDlg.BtOkClick(Sender: TObject);
var
  i: integer;
begin
  Name.free;
  Name := TNotesName.create (EName.text);
  Cbh.checked := Name.IsHirerarchical;
  for i := 0 to 12 do SetEdit (i, Name.GetNameComponent(i));
  EName.text := Name.Canonical;
  EKey.text := Name.Keyword;
end;

procedure TNameDlg.FormDestroy(Sender: TObject);
begin
  Name.free;
end;

//***************************************************
procedure TNameDlg.SetEdit;
var
  c: TEdit;
  i: integer;
  s: string;
begin
  s := 'Edit' + inttoStr(n+1);
  for i := 0 to Groupbox1.ControlCount-1 do begin
    if Groupbox1.Controls[i].Name = s then begin
      c := Groupbox1.Controls[i] as TEdit;
      c.Text := aText;
      break;
    end;
  end;
end;

procedure TNameDlg.GetEdit(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  n: integer;
begin
  if Key <> VK_RETURN then exit;
  n := strToInt (copy (TWinControl(Sender).Name, 5, length(TWinControl(Sender).Name)-4));
  if Name = nil then Name := TNotesName.Create ('');
  Name.SetNameComponent (n-1, (Sender as TEdit).Text);
  EName.Text := Name.Canonical;
end;

end.
