{
  Examples of Lotus Notes object layer
  Sergey Kolchin

  Test.nsf database is used in all examples, check it to see results
  It must exist in Notes data directory
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Class_LotusNotes, Util_LNAPi, Util_LNAPiErr, Form_LNBrowse, Form_OpenMail,
  ComCtrls, Menus, ExtCtrls, Class_NotesRTF, Util_LnPass;

type
  TTestForm = class(TForm)
    SaveDialog: TSaveDialog;
    OpenDialog: TOpenDialog;
    MainMenu1: TMainMenu;
    Database1: TMenuItem;
    New1: TMenuItem;
    StatusBar: TStatusBar;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Documents1: TMenuItem;
    Create1: TMenuItem;
    Mail1: TMenuItem;
    SimpleSendmail1: TMenuItem;
    AdvancedSendmail1: TMenuItem;
    N3: TMenuItem;
    Readmail1: TMenuItem;
    N4: TMenuItem;
    Simpleopenmailbox1: TMenuItem;
    Advancedopenmailbox1: TMenuItem;
    Names1: TMenuItem;
    NameParts1: TMenuItem;
    Closemailbox1: TMenuItem;
    NameLookupexample1: TMenuItem;
    N2: TMenuItem;
    SetTitle1: TMenuItem;
    Attachfile1: TMenuItem;
    DetachFile1: TMenuItem;
    N5: TMenuItem;
    Richtextfield1: TMenuItem;
    List2: TMenuItem;
    Evaluateformula1: TMenuItem;
    Createresponse1: TMenuItem;
    Views1: TMenuItem;
    ACL1: TMenuItem;
    ImportRTFfile1: TMenuItem;
    ExportRTFfile1: TMenuItem;
    AddJPEGimage1: TMenuItem;
    Password1: TMenuItem;
    Install1: TMenuItem;
    Enter1: TMenuItem;
    Clear1: TMenuItem;
    Uninstall1: TMenuItem;
    Richtext1: TMenuItem;
    N6: TMenuItem;
    Replacetext1: TMenuItem;
    Listmultipleitems1: TMenuItem;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormHint(Sender: TObject);
    procedure NameParts1Click(Sender: TObject);
    procedure NameLookupexample1Click(Sender: TObject);
    procedure SetTitle1Click(Sender: TObject);
    procedure OpenTestdatabase1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Simpleopenmailbox1Click(Sender: TObject);
    procedure Advancedopenmailbox1Click(Sender: TObject);
    procedure Closemailbox1Click(Sender: TObject);
    procedure SimpleSendmail1Click(Sender: TObject);
    procedure AdvancedSendmail1Click(Sender: TObject);
    procedure Readmail1Click(Sender: TObject);
    procedure Create1Click(Sender: TObject);
    procedure Attachfile1Click(Sender: TObject);
    procedure DetachFile1Click(Sender: TObject);
    procedure Richtextfield1Click(Sender: TObject);
    procedure List2Click(Sender: TObject);
    procedure Evaluateformula1Click(Sender: TObject);
    procedure Createresponse1Click(Sender: TObject);
    procedure Views1Click(Sender: TObject);
    procedure ACL1Click(Sender: TObject);
    procedure ImportRTFfile1Click(Sender: TObject);
    procedure ExportRTFfile1Click(Sender: TObject);
    procedure AddJPEGimage1Click(Sender: TObject);
    procedure Install1Click(Sender: TObject);
    procedure Uninstall1Click(Sender: TObject);
    procedure Enter1Click(Sender: TObject);
    procedure Clear1Click(Sender: TObject);
    procedure Replacetext1Click(Sender: TObject);
    procedure Listmultipleitems1Click(Sender: TObject);
  private
    Pattern,ReplaceText: string;
    ReplaceCount: integer;
    function ReplaceTextProc(Item: TNotesRichTextItem;
                                 RecordPtr: pointer;
                                 RecordType: WORD;
                                 RecordLength: DWORD): STATUS;
  public
    DB: TNotesDatabase;
    MailboxDb: TNotesDatabase;
    procedure CheckDb;
    procedure CheckMailboxMenu;
  end;

var
  TestForm: TTestForm;
  
procedure EnumDocs (Docs: TNotesDocumentCollection);

implementation

uses Unit2, Unit3, Unit4, Unit5, Unit6, Unit7;

{$R *.DFM}
procedure EnumDocs (Docs: TNotesDocumentCollection);
var
  Doc: TNotesDocument;
  i: integer;
begin
  if Application.MessageBox (pchar(inttoStr(Docs.count)),'Documents count', mb_OkCancel) <> id_ok then Abort;
  for i := 0 to Docs.count-1 do begin
    Doc := Docs.Document[i];
    try
      ReadDocDlg.OpenDoc (Doc, False);
      ReadDocDlg.showModal;
      if ReadDocDlg.modalResult <> mrOk then Abort;
    finally
      Doc.free;
    end;
  end;
end;

procedure TTestForm.CheckDb;
begin
  if Db = nil then Db := TNotesDatabase.create;
  if not Db.Active then try
    Db.open ('', 'Test.nsf');
  except
    on E: Exception do begin
      MessageDlg ('Cannot open test database due to the error:'#13#10 +
        E.Message + #13#10 +
        'This database must exists in Notes\Data directory in order to use this example',
        mtError, [mbOk], 0);
      Abort;
    end;
  end;
end;

procedure TTestForm.CheckMailboxMenu;
var
  b: boolean;
begin
  b := (MailboxDb <> nil) and (MailboxDb.Active);
  Closemailbox1.enabled := b;
  SimpleSendmail1.enabled := b;
  AdvancedSendmail1.enabled := b;
  Readmail1.enabled := b;
  Closemailbox1.enabled := b;
end;

procedure TTestForm.FormDestroy(Sender: TObject);
begin
  MailboxDb.free;
  Db.free;
end;

procedure TTestForm.FormHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TTestForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := FormHint;
end;

procedure TTestForm.NameParts1Click(Sender: TObject);
begin
  NameDlg.showModal;
end;

procedure TTestForm.NameLookupexample1Click(Sender: TObject);
begin
  NameLookupDlg.showModal;
end;

procedure TTestForm.SetTitle1Click(Sender: TObject);
begin
  CheckDb;
  Db.Title := InputBox('Database Title','Enter database title',Db.Title);
end;

procedure TTestForm.OpenTestdatabase1Click(Sender: TObject);
begin
  CheckDb;
end;

procedure TTestForm.Open1Click(Sender: TObject);
var
  Server, Path: string;
  Db: TNotesDatabase;
begin
  Server := '';
  Path := '';
  if LnBrowse ('', Server, Path) then try
    showMessage ('Database to be opened: ' + CombineLnPath (Server,Path));
    Db := TNotesDatabase.create;
    try
      Db.open (Server, Path);
      showMessage ('Opened successfully, title is ' + Db.Title);
      ViewsForm.SetInfo(DB);
      ViewsForm.showModal;
    finally
      Db.free;
    end;
  except                       
    on E: ELotusNotes do MessageDlg(E.message, mtError, [mbOK], 0);
    else raise;
  end;
end;

procedure TTestForm.Exit1Click(Sender: TObject);
begin
  close;
end;

procedure TTestForm.New1Click(Sender: TObject);
var
  Templ, Path: string;
  Db: TNotesDatabase;
begin
  OpenDialog.Title := 'Select template';
  if not OpenDialog.execute then exit;
  Templ := OpenDialog.FileName;
  SaveDialog.Title := 'Select new database location';
  if not SaveDialog.execute then exit;
  Path := SaveDialog.FileName;
  Db := TNotesDatabase.create;
  try
    Db.CreateNew ('', Path, Templ);
    showMessage ('Created successfully, title is ' + Db.Title);
  finally
    Db.free;
  end;
end;

procedure TTestForm.Simpleopenmailbox1Click(Sender: TObject);
begin
  if MailboxDb <> nil then begin
    MailboxDb.free;
    MailboxDb := nil;
    CheckMailboxMenu;
  end;
  MailboxDb := TNotesDatabase.create;
  MailboxDb.OpenMail;
  showMessage ('Mailbox database for ' + MailboxDb.UserName + ' opened:'#13#10 +
    'Path: ' + MailboxDb.FullName + #13#10 +
    'Title: ' + MailboxDb.Title
  );
  CheckMailboxMenu;
end;

procedure TTestForm.Advancedopenmailbox1Click(Sender: TObject);
begin
  if MailboxDb <> nil then begin
    MailboxDb.free;
    MailboxDb := nil;
    CheckMailboxMenu;
  end;
  MailboxDb := OpenMailbox;
  if MailboxDB = nil then exit;
  showMessage ('Mailbox database for ' + MailboxDb.UserName + ' opened:'#13#10 +
    'Path: ' + MailboxDb.FullName + #13#10 +
    'Title: ' + MailboxDb.Title
  );
  CheckMailboxMenu;
end;

procedure TTestForm.Closemailbox1Click(Sender: TObject);
begin
  if MailboxDb <> nil then begin
    MailboxDb.free;
    MailboxDb := nil;
    CheckMailboxMenu;
  end;
end;

procedure TTestForm.SimpleSendmail1Click(Sender: TObject);
begin
  SendMailDlg.StartMail (MailboxDb, True);
  SendMailDlg.ShowModal;
end;

procedure TTestForm.AdvancedSendmail1Click(Sender: TObject);
begin
  SendMailDlg.StartMail (MailboxDb, False);
  SendMailDlg.ShowModal;
end;

procedure TTestForm.Readmail1Click(Sender: TObject);
var
  Docs: TNotesDocumentCollection;
begin
  // Search for all unread messages in a mailbox
  Docs := MailboxDb.UnreadDocuments;
  try
    EnumDocs(Docs);

    // Mark all read
    Docs.MarkAllRead (True);
  finally
    Docs.Free;
  end;
end;

procedure TTestForm.Create1Click(Sender: TObject);
var
  Doc: TNotesDocument;
  v, v1: variant;
  Lst: TStrings;
begin
  // Document creation example
  CheckDb;
  Doc := Db.CreateDocument;
  try
    Doc['Form'].asString := 'Test';
    Doc['Subject'].asString := 'Test';
    Doc['Number'].asNumber := 100;
    Doc['DateTime'].asDateTime := Now;
    v := VarArrayCreate ([0,2], varDouble);
    v[0] := 1.0;
    v[1] := 1.1;
    v[2] := Pi;
    Doc['NumberList'].asNumbers := v;
    v1 := VarArrayCreate ([0,2], varDate);
    v1[0] := VarFromDateTime(Now);
    v1[1] := VarFromDateTime(Now);
    v1[2] := VarFromDateTime(Now);
    Doc['DateTimeList'].asTimes := v1;
    Lst := TStringList.create;
    try
      Lst.add ('1');
      Lst.add ('2');
      Lst.add ('3');
      Doc['TextList'].AsStrings := Lst;
      Lst.clear;
      Lst.add ('Test 1');
      Lst.add ('Test 2');
      Lst.add ('Test 3');
      Doc['RichText'].AsRichText := Lst;
    finally
      Lst.free;
    end;
    Doc.Sign;
    Doc.Save (False, False, False);
    MessageDlg('Document created successfully',mtInformation,[mbOK],0);
  finally
    Doc.free;
  end;
end;

procedure TTestForm.Attachfile1Click(Sender: TObject);
var
  Doc: TNotesDocument;
begin
  // Document-attach file example
  CheckDb;
  OpenDialog.Title := 'Select a file to attach to document';
  if not OpenDialog.execute then exit;
  Doc := Db.CreateDocument;
  try
    Doc.Subject := 'Test attachment';
    Doc.Form := 'Test';
    Doc.Attach (OpenDialog.fileName);
    Doc.Save (false, false, false);
    MessageDlg('File ' + OpenDialog.fileName + ' successfully attached to the document',mtInformation,[mbOK],0);
  finally
    Doc.free;
  end;
end;

procedure TTestForm.DetachFile1Click(Sender: TObject);
var
  Doc: TNotesDocument;
  i: integer;
begin
  // Document-detach file example. Requires Button3 click
  CheckDb;
  Doc := Db.FindDocument ('Subject="Test attachment"');
  if Doc = nil then raise Exception.create ('No "Test attachment" documents found');
  try
    for i := 0 to Doc.AttachmentCount-1 do begin
      SaveDialog.FileName := Doc.Attachment[i];
      if SaveDialog.Execute then begin
        Doc.Detach (i, SaveDialog.FileName);
        MessageDlg('File ' + SaveDialog.fileName + ' successfully detached',mtInformation,[mbOK],0);
      end;
    end;
  finally
    Doc.free;
  end;
end;

procedure TTestForm.Richtextfield1Click(Sender: TObject);
var
  Doc: TNotesDocument;
  Rt: TNotesRichTextItem;
  fAttach: boolean;
begin
  // Rich text creation example
  CheckDb;
  OpenDialog.Title := 'Select a file to attach to rich-text field';
  fAttach := OpenDialog.execute;
  Doc := Db.CreateDocument;
  try
    Doc['Form'].asString := 'Test';
    Doc['Subject'].asString := 'Test';
    Rt := TNotesRichTextItem.createNew (Doc, 'RichText');
    try
      Rt.CreateContext;
      Rt.ParaJustification := rjLeft;
      Rt.AddPara;
      Rt.AddURL ('http://welcome.to/lndelphi','Test');
      Rt.AddPara;
      Rt.StartSection('Section', NOTES_COLOR_BLUE, [rtsExpanded], rtsBorderShadow);
      Rt.AddText('test section');
      Rt.EndSection;
      Rt.ParaLeftMargin := DEFAULT_LEFT_MARGIN;
      Rt.AddPara;
      Rt.AddText ('Sample text');
      Rt.AddPara;
      Rt.FontFace := rfMonospace;
      Rt.AddText ('Sample text');
      Rt.AddPara;
      Rt.FontFaceName := 'Times New Roman';
      Rt.FontSize := 12;
      Rt.AddText ('Sample text');
      Rt.AddPara;
      Rt.FontSize := 10;
      Rt.FontBold := True;
      Rt.FontShadow := True;
      Rt.AddText ('Sample text');
      Rt.AddPara;
      Rt.AddPara;
      if fAttach then Rt.Attach(OpenDialog.fileName,True);
      Rt.SaveContext;
    finally
      Rt.free;
    end;
    Doc.Save (False, False, False);
    MessageDlg('Rich-text field created',mtInformation,[mbOK],0);
  finally
    Doc.free;
  end;
end;

procedure TTestForm.List2Click(Sender: TObject);
var
  Docs: TNotesDocumentCollection;
  query: string;
begin
  CheckDb;
  query := InputBox ('Search example', 'Enter search query', '@All');
  if query = '' then exit;

  Docs := Db.Search (query, 0, 0);
  try
    EnumDocs (Docs);
  finally
    Docs.Free;
  end;
end;

procedure TTestForm.Evaluateformula1Click(Sender: TObject);
var
  Doc: TNotesDocument;
  formula: string;
  res: variant;
  buf: string;
  i: integer;
begin
  CheckDb;
  formula := InputBox ('Formula evaluation', 'Enter a formula', '@Author');
  if formula = '' then exit;
  Doc := Db.FindDocument ('@All');
  if Doc = nil then raise Exception.create ('No documents found');
  try
    res := Doc.Evaluate (formula);
    buf := '';
    if (varType(res) and varArray) = 0 then buf := string(res)
    else for i := VarArrayLowBound(res,1) to VarArrayHighBound(res,1) do
      buf := buf + #13#10 + string(res[i]);
    showMessage (buf);
  finally
    Doc.free;
  end;
end;

procedure TTestForm.Createresponse1Click(Sender: TObject);
var
  Doc, NewDoc: TNotesDocument;
  s: string;
begin
  CheckDb;
  s := InputBox ('Formula', 'Enter selection formula', '@All');
  if s = '' then exit;
  Doc := Db.FindDocument (s);
  if Doc = nil then raise Exception.create ('No documents found');
  try
    NewDoc := TNotesDocument.CreateResponse (Db, Doc);
    NewDoc.Form := 'Test1';
    NewDoc.Save (False, False, False);
  finally
    Doc.free;
  end;
  showMessage ('Response document created');
end;

procedure TTestForm.Views1Click(Sender: TObject);
begin
  CheckDB;
  ViewsForm.SetInfo(DB);
  ViewsForm.showModal;
end;

procedure TTestForm.ACL1Click(Sender: TObject);
begin
  CheckDB;
  AclForm.SetInfo(DB);
  AclForm.ShowModal;
end;

procedure TTestForm.ImportRTFfile1Click(Sender: TObject);
var
  Doc: TNotesDocument;
  Rt: TNotesRichTextItem;
begin
  // Rich text creation example
  CheckDb;
  OpenDialog.Title := 'Select a file to import to rich-text field';
  if not OpenDialog.execute then exit;
  Doc := Db.CreateDocument;
  try
    Doc['Form'].asString := 'Test';
    Doc['Subject'].asString := 'Test';
    Rt := TNotesRichTextItem.createFromFile (Doc, 'RichText', OpenDialog.FileName);
    Rt.free;
    Doc.Save (False, False, False);
    MessageDlg('File ' + OpenDialog.fileName + ' successfully imported to a rich-text field',mtInformation,[mbOK],0);
  finally
    Doc.free;
  end;
end;

procedure TTestForm.ExportRTFfile1Click(Sender: TObject);
var
  Doc: TNotesDocument;
  Rt: TNotesRichTextItem;
begin
  CheckDb;
  SaveDialog.Title := 'Select a file for export';
  if not SaveDialog.execute then exit;
  Doc := Db.FindDocument ('@All');
  Rt := nil;
  if Doc = nil then raise Exception.create ('No documents found');
  try
    Rt := TNotesRichTextItem.create(Doc, 'RichText');
    Rt.ExportRTFFile (SaveDialog.FileName);
    MessageDlg('File ' + SaveDialog.fileName + ' successfully exported',mtInformation,[mbOK],0);
  finally
    Rt.free;
    Doc.free;
  end;
end;

procedure TTestForm.AddJPEGimage1Click(Sender: TObject);
var
  Doc: TNotesDocument;
  Rt: TNotesRichTextItem;
begin
  CheckDb;
  OpenDialog.Title := 'Select a file';
  if not OpenDialog.execute then exit;
  Doc := Db.FindDocument ('@All');
  if Doc = nil then raise Exception.create ('No documents found');
  try
    Rt := TNotesRichTextItem.Create(Doc,'RichText');
    try
      Rt.CheckContext;
      Rt.AddFile(OpenDialog.fileName);
      Rt.SaveContext;
    finally
      Rt.free;
    end;
    Doc.Save (False, False, False);
    MessageDlg('File ' + OpenDialog.fileName + ' successfully added to a rich-text field',mtInformation,[mbOK],0);
  finally
    Doc.free;
  end;
end;

procedure TTestForm.Install1Click(Sender: TObject);
begin
  if InstallLnPass('')
    then MessageDlg('LNPASS add-in successfully installed', mtInformation, [mbOk], 0)
    else MessageDlg('Cannot install LNPASS add-in', mtError, [mbOk], 0)
end;

procedure TTestForm.Uninstall1Click(Sender: TObject);
begin
  UninstallLnPass;
  MessageDlg('LNPASS add-in uninstalled', mtInformation, [mbOk], 0)
end;

procedure TTestForm.Enter1Click(Sender: TObject);
var
  psw: string;
begin
  if not InputQuery('Sample password prompt','Enter Notes password', psw) then exit;
  if setPassword('', psw, True)
    then MessageDlg('Password was successfully set', mtInformation, [mbOk], 0)
    else MessageDlg('Invalid password', mtError, [mbOk], 0)
end;

procedure TTestForm.Clear1Click(Sender: TObject);
begin
  clearPassword;
end;

// Sample callback of how to replace text in RT item
function TTestForm.ReplaceTextProc(Item: TNotesRichTextItem;
                                 RecordPtr: pointer;
                                 RecordType: WORD;
                                 RecordLength: DWORD): STATUS;
type
  PCDTEXT = ^CDTEXT;
var
  pCd:      PCDTEXT;
  pText:    pchar;
  ofs, len: DWORD;
  str:      string;
  rstr:     string;
begin
  Result := NOERROR;
  case RecordType of
    SIG_CD_TEXT: begin // We're interested only in text
      // These records contain CDTEXT structure followed by actual text
      pCd := PCDTEXT(RecordPtr);
      ofs := sizeOf(CDTEXT);
      len := pCd^.Header.Length - sizeOf(CDTEXT);
      rstr := '';
      if len > 0 then begin
        // Here we have a pointer to actual text, get it to String
        pText := pchar(DWORD(RecordPtr) + ofs);
        setLength(str,len+1);
        strLCopy(pchar(str),pText,len);
        str := strPas(pchar(str));          //to calculate Pascal length

        // Compare
        ofs := Pos(Pattern,str);
        if ofs > 0 then begin
          // One or more matches
          while ofs > 0 do begin
            appendStr(rstr, copy(str,1,ofs-1) + ReplaceText);
            inc(ReplaceCount);
            delete(str,1,ofs+length(Pattern)-1);
            ofs := Pos(Pattern,str);
          end;
          appendStr(rstr,str);
        end;
      end;
      if rstr = '' then begin
        // No replacement, so just add original record back to context
        Item.AddToContext(RecordPtr,RecordType,RecordLength);
      end
      else begin
        // Add replaced text to context
        Item.AddTextToContext(pCd^.FontID,rstr);
      end;
    end;

    else begin
      // Save record back to context
      Item.AddToContext(RecordPtr,RecordType,RecordLength);
    end;
  end;
end;

procedure TTestForm.Replacetext1Click(Sender: TObject);
var
  Doc: TNotesDocument;
  Rt: TNotesRichTextItem;
begin
  if not InputQuery('Replace text','Text to find',Pattern) then exit;
  if not InputQuery('Replace text','Replace with',ReplaceText) then exit;

  CheckDb;
  Doc := Db.FindDocument ('@All');
  if Doc = nil then raise Exception.create ('No documents found');
  try
    Rt := TNotesRichTextItem.Create(Doc,'RichText');
    try
      ReplaceCount := 0;
      Rt.ReadItem(ReplaceTextProc);
      if ReplaceCount > 0 then begin
        // Changes were made, delete original item and add new one
        Doc.DeleteItem(Rt.Name);
        Rt.SaveContext;
      end;
    finally
      Rt.free;
    end;
    if ReplaceCount > 0 then Doc.Save (False, False, False);
    MessageDlg('Text replaced ' + inttoStr(ReplaceCount) + ' times',mtInformation,[mbOK],0);
  finally
    Doc.free;
  end;
end;

procedure TTestForm.Listmultipleitems1Click(Sender: TObject);
var
  squery, sitem: string;
  Doc: TNotesDocument;
  List: TList;
  Item: TNotesItem;
  i: integer;
begin
  CheckDb;
  squery := '@All';
  sitem  := '$FILE';
  if not InputQuery('Multiple items example','Enter document selection formula', squery) then exit;
  if not InputQuery('Multiple items example','Enter item name', sitem) then exit;

  List := nil;
  Doc := Db.FindDocument(squery);
  if Doc = nil then raise Exception.create ('No documents found');
  try
    if MessageDlg(inttoStr(Doc.CountMultipleItems(sitem)) + ' items with name ' + sitem + ' were found',
    mtInformation, [mbOK, mbCancel], 0) = mrOK then begin
      // List items
      List := Doc.LoadMultipleItems(sitem);
      for i := 0 to List.count-1 do begin
        item := TNotesItem(List[i]);
        MessageDlg('Class:  ' + item.ClassName + #13#10 +
                   'SeqNo:  ' + inttoStr(item.SeqNo) + #13#10 +
                   'Length: ' + inttoStr(item.ValueLength),
        mtInformation,[mbOK],0);
      end;
    end;
  finally
    //!!! First item belongs to a document and shall not be destroyed!!!
    for i := 1 to List.count-1 do TObject(List[i]).free;
    List.free;
    Doc.free;
  end;
end;

end.
