{==============================================================================|
| Project : Notes/Delphi class library                           | 3.7         |
|==============================================================================|
| Content:                                                                     |
|==============================================================================|
| The contents of this file are subject to the Mozilla Public License Ver. 1.0 |
| (the "License"); you may not use this file except in compliance with the     |
| License. You may obtain a copy of the License at http://www.mozilla.org/MPL/ |
|                                                                              |
| Software distributed under the License is distributed on an "AS IS" basis,   |
| WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for |
| the specific language governing rights and limitations under the License.    |
|==============================================================================|
| Initial Developers of the Original Code are:                                 |
|   Sergey Kolchin (Russia) skolchin@usa.net ICQ#2292387                       |
|   Sergey Kucherov (Russia)                                                   |
|   Sergey Okorochkov (Russia)                                                 |
| All Rights Reserved.                                                         |
|   Last Modified:                                                             |
|     12.10.99, Sergey Kolchin                                                 |
|==============================================================================|
| Contributors and Bug Corrections:                                            |
|   Fujio Kurose                                                               |
|   Noah Silva                                                                 |
|   Tibor Egressi                                                              |
|   Andreas Pape                                                               |
|   Anatoly Ivkov                                                              |
|   Winalot                                                                    |
|     and others...                                                            |
|==============================================================================|
| History: see README.TXT                                                      |
|==============================================================================|
  Notes API error codes
  Transfered from Lotus Notes C-API

  Generated By: HeadConv 3.25 (c) 1998 by Bob Swart (aka Dr.Bob - www.drbob42.com)
          SPECIAL DELPHI-JEDI COMMANDLINE EDITION

    globerr.h
    bsafeerr.h
    nsferr.h
    clerr.h
    eventerr.h
    fterr.h
    miscerr.h
    neterr.h
    niferr.h
    odserr.h
    oserr.h
    regerr.h
    routerr.h
    secerr.h
    srverr.h
|==============================================================================|}
unit Util_LnApiErr;

{$WEAKPACKAGEUNIT}

interface
uses Windows, SysUtils;

// Raises ELotusNotes exception with translated message if errror <> NOERROR
procedure CheckError(Error: word);

(******************************************************************************)
{ from globerr.h }
(******************************************************************************)
{	Define error code packages }
const
  NOERROR = 0;
  PKG_MAIN = $0000;
  PKG_OS = $0100;
  PKG_NSF = $0200;
  PKG_NIF = $0300                      { NIF codes are limited to 0 - 127 }
  ;
  PKG_NSF2 = $0380                     { More NSF codes - limited to 0-127}
  ;
  PKG_MISC = $0400                     { Codes are limited to 0 - 191 }
  ;
  PKG_SERVER2 = $04C0                  { Codes are limited to 0 - 47 }
  ;
  PKG_THUNK = $04F0                    { Codes are limited to 0 - 15 }
  ;
  PKG_FORMULA = $0500                  { FORMULA codes are limited to 0-127 }
  ;
  PKG_COMPILER3 = $0580                { More COMPILER codes, limited to 0-127 }
  ;
  PKG_ODS = $0600                      { ODS codes starting from 0    }
  ;
  PKG_SCHUI = $0680                    { Schedule UI codes are limited to 0 - 63 }
  ;
  PKG_PLUGINS = $06C0                  { plugin codes are limited to 0 - 15 }
  ;
  PKG_UNDERUTIL1 = $06D0               { SPACE IS AVAILABLE limited to 0 - 47 }
  ;
  PKG_NEM = $0700;
  PKG_CLIENT = $0800                   { Client codes limited to 0 - 63 }
  ;
  PKG_APC = $0840                      { APC codes limited to 0 - 63 }
  ;
  PKG_ASSISTANT = $0880                { Your codes are limited to 0 - 127 }
  ;
  PKG_SERVER = $0900;
  PKG_NETWORK = $0A00;
  PKG_WMISC = $0B00                    { Codes are limited to 0 - 127 }
  ;
  PKG_ACTION = $0B80                   { Codes are limited to 0 - 63 }
  ;
  PKG_ACTIONPANE = $0BC0               { Codes are limited to 0 - 63 }
  ;
  PKG_EDIT = $0C00;
  PKG_VIEW = $0D00;
  PKG_MAIL = $0E00;
  PKG_CONV = $0E80;
  PKG_FT = $0F00                       { FT errors are limited to 0 - 127 }
  ;
  PKG_NETWORK2 = $0F80;
  PKG_DEBUG = $1000                    { Debug strings, like for DDE }
  ;
  PKG_ROUTER = $1100                   { Errors returned by ROUTERL, 0 - 79 }
  ;
  PKG_MAILMAN = $1150                  { Errors returned by MAILMAN, 0 - 95 }
  ;
  PKG_LSBE = $11b0                     { LSXBE errors, 0 - 79 }
  ;
  PKG_COMPILER4 = $1200                { still more compiler codes, 0 - 127 }
  ;
  PKG_LSIDE = $1280                    { ide specific errors 0 - 128 }
  ;
  PKG_LOG = $1300;
  PKG_NSF3 = $1380                     { More NSF codes - limited to 0-127}
  ;
  PKG_XPC = $1400;
  PKG_EVENT = $1500                    { Event codes starting from 0 }
  ;
  PKG_BCASE = $1580                    { Briefcase codes are limited to 0 - 127 }
  ;
  PKG_REPL = $1600                     { Errors returned by REPLSUB library }
  ;
  PKG_BSAFE = $1700                    { BSAFE codes are limited to 0 - 151 }
  ;
  PKG_DESK4 = $1798                    { DESK4 Codes are limited to 0 - 103 }
  ;
  PKG_DESK = $1800;
  PKG_SECURE = $1900;
  PKG_AGENT = $1A00;
  PKG_COMPILER = $1B00;
  PKG_NETDRV = $1C00;
  PKG_IMPORT = $1D00                   { Used for all imports - see IMPKG_xxx below }
  ;
  PKG_EXPORT = $1E00                   { Used for all exports - see EXPKG_xxx below }
  ;
  PKG_REG = $2000;

{ Following 8 groups used for native OS error codes, mapped by OSMapError
	and translated by OSLoadString.  These give better feedback in certain
	cases, but should NEVER be interpreted if STS_REMOTE bit is set,
	indicating that another OS on server might have generated the error! }

const
  PKG_NATIVE_FIRST = $2100;
  PKG_NATIVE_LAST = $28FF;

const
  PKG_NSE = $2900                      { Network script engine }
  ;
  PKG_NETDRVLCL = $2A00                { Used for all Network Drivers }
  ;
  PKG_NTI = $2B00                      { Used for NTI and its new Net drivers }
  ;
  PKG_VIEWMAP = $2C00                  { for ViewMap }
  ;
  PKG_BSAFE2 = $2CF0                   { for BSAFE x509 routines }
  ;
  PKG_DESK3 = $2D00                    {	New desk messages.	}
  ;
  PKG_AGENTS = $2E00                   { for agents, limit to 0 - 127 }
  ;
  PKG_ASSISTANT2 = $2E80               { Assistants 2nd block, limit to 0 - 127 }
  ;
  PKG_LSCRIPT = $2F00                  { LotusScript Interface, limit 0-127 }
  ;
  PKG_LSXUI = $2F80                    { LotusScript Front-end classes, 0-127 }
  ;
  PKG_DSGN = $3000                     { Database design package, 0-127 }
  ;
  PKG_ADMIN = $3080                    { Admin facility, 0 - 127 }
  ;
  PKG_DBD = $3100                      { database driver error codes }
  ;
  PKG_VIEW2 = $3200                    { need additional block for view }
  ;
  PKG_ADDIN = $3300                    { For use by mail gateways, etc. }
  ;
  PKG_EDIT2 = $3400                    { need additional block for edit }
  ;
  PKG_IXMETHOD = $3500                 { import/export methods for notes.ini }
  ;
  PKG_GRMISC = $3600                   { Graphics Library 0-31 }
  ;
  PKG_VIMSMI = $3620                   { VIM and SMI block codes 0-31 }
  ;
  PKG_WEB = $3640                      { InterNotes client extensions 0-191 }
  ;
  PKG_ADDIN2 = $3700                   { For extensions to PKG_ADDIN }
  ;
  PKG_COMPILER2 = $3800                { need additional block for compile }
  ;
  PKG_EDIT4 = $3900                    { More editor codes 0-127 }
  ;
  PKG_DESK5 = $3980                    { More desk codes 0-127 }
  ;
  PKG_VIEW3 = $3A00                    { More View. 0 - 199 }
  ;
  PKG_POP3 = $3AC8                     { POP3.  0 - 19 }
  ;
  PKG_MAILMISC = $3ADC                 { Mailmisc. 0 - 11 }
  ;
  PKG_POP3C = $3AE8                    { POP3 CLIENT.  0-2 }
  ;
  PKG_SMTP = $3AE0                     { SMTP.  0 - 23 }
  ;
  PKG_SMTPC = $3AE                     { SMTP.  0 - 23 }
  ;
  PKG_DESK2 = $3B00                    { need additional block for desk }
  ;
  PKG_SMARTI = $3C00                   { To make smart icon res unique }
  ;
  PKG_OLE_ERR = $3D00                  { OLE error codes }
  ;
  PKG_OLE_CMD = $3E00                  { OLE Api Command Descriptions }
  ;
  PKG_JAVAWRAP = $3E00                 { javawrap error codes }
  ;
  PKG_EDIT3 = $3F00                    { More editor codes }
  ;

{	3F00 IS THE LAST PACKAGE THAT CAN BE DEFINED! (LOOK FOR HOLES ABOVE) }

{	DO NOT DEFINE ANOTHER PAST THIS POINT BECAUSE 0x4000-0xFFFF IS USED! }

{  Although we are out of codes, some of the package codes are VERY }

{  underutilized.  I have indicated it above by PKG_UNDERUTIL#.  If }

{  you need a package code, grab one of these and limit yourself to }

{  strings numbers 0 - 127 since these package codes do not start on }

{  an even package code boundary.  Please put comments in both files }

{  to indicate that the the numbering space has been limited. - DWC }

const
  PKG_CODES = 255;

{ Define offsets within PKG_NETDRVLCL for local network drivers }

{	On the Unix, since tcp is compiled into Notes, their strings must have
	unique IDs. We define a separate package for all drivers which are optional
	and each optional driver package will have its own offsets for first string
	as defined below. There is some room for expansion, but people adding
	strings should be aware of the extent  of their allocated ID space, and
	change it here if necessary, afterwards recompiling all dependent drivers.
	Under Windows and PM, since each ixport is a separate DLL with separate DS
	space, all offsets are set to 0.
}

const
  NETPKG_TCP = 0;
  NETPKG_ATALK = 0;
  NETPKG_NWSPX = 0;
  NETPKG_NETBIOS = 0;

{ Define offsets within PKG_IMPORT and PKG_EXPORT for import/exports }

{	On the Mac, since all ixports are compiled into Notes, their strings must have unique IDs.
	We avoid using a separate PKG for each by defining the offset of each ixport's first string below.
	There is some room for expansion, but people adding strings should be aware of the extent
	of their allocated ID space, and change it here if necessary, afterwards recompiling all
	dependent ixports!
	Under Windows and PM, since each ixport is a separate DLL with separate DS space,
	all offsets are set to 0.
	Since TARGA, W4W and WMF are not to be ported to the Mac, we don't currently bother with
	defining offsets for them.
}

const
  IMPKG_IFL = 0;
  IMPKG_IPCX = 0;
  IMPKG_IPIC = 0;
  IMPKG_IRTF = 0;
  IMPKG_ISTF = 0;
  IMPKG_ISTR = 0;
  IMPKG_ITAB = 0;
  IMPKG_ITARGA = 0;
  IMPKG_ITEXT = 0;
  IMPKG_ITIFF = 0;
  IMPKG_IWKSE = 0;
  IMPKG_IWKSV = 0;
  IMPKG_IWMF = 0;
  IMPKG_IBMP = 0;
  IMPKG_IGIF = 0;
  IMPKG_IW4W = 0;
  IMPKG_ISTRNGS = 0;
  IMPKG_IJPEG = 0;
  IMPKG_ALL = 30                       { 20 common strings shared by all Iris IX modules }
  ;
                                       { (Reserve 0-30 for IX-specific strings) }
  EXPKG_XCGM = 0;
  EXPKG_XRTF = 0;
  EXPKG_XSTF = 0;
  EXPKG_XSTR = 0;
  EXPKG_XTAB = 0;
  EXPKG_XTEXT = 0;
  EXPKG_XTIFF = 0;
  EXPKG_XW4W = 0;
  EXPKG_XWKS = 0;
  EXPKG_ALL = 50                       { 20 common strings shared by all Iris IX modules }
  ;
                                       { (Reserve 0-50 for IX-specific strings) }


(******************************************************************************)
{ from bsafeerr.h }
(******************************************************************************)
{ BSAFE (Security package) Error Code Definitions			}
const
  ERR_BSAFE_PSW_PROMPT = PKG_BSAFE + 0;
  ERR_BSAFE_FALSE = PKG_BSAFE + 1;
  ERR_BSAFE_ALLOCATE = PKG_BSAFE + 2;
  ERR_BSAFE_FREE = PKG_BSAFE + 3;
  ERR_BSAFE_ENTRY = PKG_BSAFE + 4;
  ERR_BSAFE_EXIT = PKG_BSAFE + 5;
  ERR_BSAFE_PAUSE = PKG_BSAFE + 6;
  ERR_BSAFE_BADKEY = PKG_BSAFE + 7;
  ERR_BSAFE_BADCTX = PKG_BSAFE + 8;
  ERR_BSAFE_BADOPCODE = PKG_BSAFE + 9;
  ERR_BSAFE_BADCHECKSUM = PKG_BSAFE + 10;
  ERR_BSAFE_BADDATA = PKG_BSAFE + 11;
  ERR_BSAFE_BUG_1 = PKG_BSAFE + 12;

const
  ERR_BSAFE_POOLFULL = PKG_BSAFE + 13;
  ERR_BSAFE_CACHEFULL = PKG_BSAFE + 14;
  ERR_BSAFE_TOOSMALL = PKG_BSAFE + 15;
  ERR_BSAFE_BAD_ATTRIBUTES = PKG_BSAFE + 16;
  ERR_BSAFE_MDLENGTH = PKG_BSAFE + 17;
  ERR_BSAFE_NOT_ALLOWED = PKG_BSAFE + 18;
  ERR_BSAFE_ILLEGAL_IDFILE = PKG_BSAFE + 19;
  ERR_BSAFE_BAD_PI_VERSION = PKG_BSAFE + 20;
  ERR_BSAFE_BAD_PI_CHECKSUM = PKG_BSAFE + 21;
  ERR_BSAFE_MISSING_PI = PKG_BSAFE + 22;
  ERR_BSAFE_TABLE_MUST_BE_HI = PKG_BSAFE + 23;
  ERR_BSAFE_NO_COMMON_CERT = PKG_BSAFE + 24;
  ERR_BSAFE_CERTTABLE_VERSION = PKG_BSAFE + 25;
  ERR_BSAFE_ILLUSE_GENID = PKG_BSAFE + 26;
  ERR_BSAFE_NOT_GENID = PKG_BSAFE + 27;
  ERR_BSAFE_NOSUCH_PRVKEY = PKG_BSAFE + 28;
  ERR_BSAFE_NOSUCH_ESCROW = PKG_BSAFE + 29;
  ERR_BSAFE_NETFILE = PKG_BSAFE + 30;
  ERR_BSAFE_BAD_IDFILE_VERSION = PKG_BSAFE + 31;
  ERR_BSAFE_NOSUCH_PUBKEY = PKG_BSAFE + 32;
  ERR_BSAFE_PROC_NOT_INITED = PKG_BSAFE + 33;
  ERR_BSAFE_SUBPROCESS = PKG_BSAFE + 34;
  ERR_BSAFE_NOMEMORY = PKG_BSAFE + 35;
  ERR_BSAFE_ILLFUNC = PKG_BSAFE + 36;
  ERR_BSAFE_NULLPARAM = PKG_BSAFE + 37;
  ERR_BSAFE_DISPLAY_IDFILE = PKG_BSAFE + 38;
  ERR_BSAFE_ILLUSE_SAFECOPY = PKG_BSAFE + 39;
  ERR_BSAFE_USER_ABORT = PKG_BSAFE + 40;
  ERR_BSAFE_ID_PROTECTED = PKG_BSAFE + 41;
  ERR_BSAFE_ID_CREATE = PKG_BSAFE + 42;
  ERR_BSAFE_ID_TRUNC = PKG_BSAFE + 43;
  ERR_BSAFE_CORRUPTIDFILE = ERR_BSAFE_ID_TRUNC;
  ERR_BSAFE_ID_INVFILENAME = PKG_BSAFE + 44;
  ERR_BSAFE_ID_WRITETRUNC = PKG_BSAFE + 45;
  ERR_BSAFE_ID_INVDRIVE = PKG_BSAFE + 46;
  ERR_BSAFE_NON_EXISTENT = PKG_BSAFE + 47;
  ERR_BSAFE_NEK_NOT_FOUND = PKG_BSAFE + 48;
  ERR_BSAFE_KEY_NOT_FOUND = PKG_BSAFE + 49;
  ERR_BSAFE_KEY_INV_FORMAT = PKG_BSAFE + 50;
  ERR_BSAFE_NO_KEYS = PKG_BSAFE + 51;
  ERR_BSAFE_UNKNOWN_CERTIFICATE = PKG_BSAFE + 52;
  ERR_BSAFE_UNKNOWN_IDFILE = PKG_BSAFE + 53;
  ERR_BSAFE_UNKNOWN_DOCKEY = PKG_BSAFE + 54;
  ERR_BSAFE_UNKNOWN_USERINFO = PKG_BSAFE + 55;
  ERR_BSAFE_UNKNOWN_ITEM = PKG_BSAFE + 56;
  ERR_BSAFE_INV_DNAME = PKG_BSAFE + 57;
  ERR_BSAFE_ODSCERT_TOOBIG = PKG_BSAFE + 58;
  ERR_BSAFE_UNKNOWN_UDO = PKG_BSAFE + 59;
  ERR_BSAFE_FILE_NOT_OPENED = PKG_BSAFE + 60;
  STR_BSAFE_RSA_PRIMARY = PKG_BSAFE + 61;
  STR_BSAFE_RSA_SECONDARY = PKG_BSAFE + 62;
  STR_BSAFE_RC2 = PKG_BSAFE + 63;
  STR_BSAFE_RC4 = PKG_BSAFE + 64;
  STR_BSAFE_USA = PKG_BSAFE + 65;
  STR_BSAFE_NONUSA = PKG_BSAFE + 66;
  STR_BSAFE_SIGNED_MAIL = PKG_BSAFE + 67;
  STR_BSAFE_SEALED_DOC = PKG_BSAFE + 68;
  STR_BSAFE_CERTIFY = PKG_BSAFE + 69;
  STR_BSAFE_IDFILE_ENCRYPTED = PKG_BSAFE + 70;
  STR_BSAFE_AUTHENTICATED = PKG_BSAFE + 71;
  STR_BSAFE_FORCED_AUTH = PKG_BSAFE + 72;
  STR_BSAFE_CERT_EXPIRES = PKG_BSAFE + 73;
  STR_BSAFE_CERT_EXPIRED = PKG_BSAFE + 74;
  STR_BSAFE_INVALID = PKG_BSAFE + 75;
  STR_BSAFE_UNKNOWN = PKG_BSAFE + 76;
  ERR_BSAFE_IDFILE_LOCKED = PKG_BSAFE + 77;
  ERR_BSAFE_NEK_EXISTS = PKG_BSAFE + 78;
  ERR_BSAFE_KFM_INVREADOPT = PKG_BSAFE + 79;
  ERR_BSAFE_MERGE_NONCOPY = PKG_BSAFE + 80;
  ERR_BSAFE_MERGE_NOPRVKEY = PKG_BSAFE + 81;
  ERR_BSAFE_NONAMECHANGE = PKG_BSAFE + 82;
  ERR_BSAFE_NOMERGECERT = PKG_BSAFE + 83;
  ERR_BSAFE_INVUSERIDFILE = PKG_BSAFE + 84;
  ERR_BSAFE_CORRUPTFILE = PKG_BSAFE + 85;
  ERR_BSAFE_REQUIRES_NONFLATID = PKG_BSAFE + 86;
  ERR_BSAFE_NO_CROSS_CERT = PKG_BSAFE + 87;
  ERR_BSAFE_INCOMPLETE_CERTTABLE = PKG_BSAFE + 88;
  ERR_BSAFE_ILLUSE_CERTIFIER = PKG_BSAFE + 89;
  ERR_BSAFE_MUSTBE_CERTIFIER = PKG_BSAFE + 90;
  ERR_BSAFE_WRITEPROTECTED = PKG_BSAFE + 91;
  ERR_BSAFE_NOPSW_ON_SAFECOPY = PKG_BSAFE + 92;
  ERR_BSAFE_YOU_MUST_BE_HI = PKG_BSAFE + 93;
  ERR_BSAFE_WRONG_SUBJECT_KEY = PKG_BSAFE + 94;
  ERR_BSAFE_ILL_CERTTABLE = PKG_BSAFE + 95;
  ERR_BSAFE_CERTIFIER_MUST_BE_HI = PKG_BSAFE + 96;
  ERR_BSAFE_EXTERNAL_PASSWORD = PKG_BSAFE + 97;
  ERR_BSAFE_EXTERNAL_PWD_AND_DATA = PKG_BSAFE + 98;
  ERR_BSAFE_FLAT_KEY_TOO_BIG = PKG_BSAFE + 99;
  STR_BSAFE_CERTIFYING = PKG_BSAFE + 100;
  STR_BSAFE_CERTIFIED = PKG_BSAFE + 101;
  STR_BSAFE_REPLACE_ANCESTRY = PKG_BSAFE + 102;
  ERR_BSAFE_CANCELED = PKG_BSAFE + 103;
  STR_BSAFE_UPGRADETOHI = PKG_BSAFE + 104;
  STR_BSAFE_BLANK = PKG_BSAFE + 105;
  STR_BSAFE_SAFECOPY = PKG_BSAFE + 106;
  STR_BSAFE_FLAT_ID = PKG_BSAFE + 107;
  STR_BSAFE_HIUSER_ID = PKG_BSAFE + 108;
  STR_BSAFE_HICERTIFIER_ID = PKG_BSAFE + 109;
  STR_BSAFE_UNKNOWN_ID = PKG_BSAFE + 110;
  ERR_BSAFE_USA_KEY_ONLY = PKG_BSAFE + 111;
  ERR_BSAFE_ID_READ_ONLY = PKG_BSAFE + 112;
  ERR_BSAFE_NO_PUBLIC_INFO = PKG_BSAFE + 113;
  ERR_BSAFE_TOOMANY_ORG_UNITS = PKG_BSAFE + 114;
  ERR_BSAFE_MUSTBE_HIERARCHICAL = PKG_BSAFE + 115;
  ERR_BSAFE_ID_DRIVE_NOT_READY = PKG_BSAFE + 116;
  ERR_BSAFE_ID_DISK = PKG_BSAFE + 117;
  ERR_BSAFE_ID_IOERROR = PKG_BSAFE + 118;
  ERR_BSAFE_PASSWORD_REQUIRED = PKG_BSAFE + 119;
  ERR_BSAFE_BAD_AUTH_CODE = PKG_BSAFE + 120;
  ERR_BSAFE_ILL_AUTH_CODE_VERSION = PKG_BSAFE + 121;
  ERR_BSAFE_NEWNAME_TOO_LONG = PKG_BSAFE + 122;
  ERR_BSAFE_CERT_NOT_ANCESTOR = PKG_BSAFE + 123;
  ERR_BSAFE_ILL_ATFUNC = PKG_BSAFE + 124;
  ERR_BSAFE_CERTIFIER_NOT_IN_NAB = PKG_BSAFE + 125;
  ERR_BSAFE_ILL_DISTINFO = PKG_BSAFE + 126;
  ERR_BSAFE_INSUF_INPUT_ARGS = PKG_BSAFE + 127;
  ERR_BSAFE_CERT_MISMATCH = PKG_BSAFE + 128;
  ERR_BSAFE_ILLUSE_XCERT = PKG_BSAFE + 129;
  ERR_BSAFE_TOO_MANY_CERTS = PKG_BSAFE + 130;
  ERR_BSAFE_TOO_FEW_CERTS = PKG_BSAFE + 131;
  ERR_BSAFE_ID_MUST_BE_HI = PKG_BSAFE + 132;
  ERR_BSAFE_INV_KFHANDLE = PKG_BSAFE + 133;
  ERR_BSAFE_FILE_LOCKED = PKG_BSAFE + 134;
  ERR_BSAFE_MUST_BE_SERVER = PKG_BSAFE + 135;
  ERR_BSAFE_INAPPROPRIATE_ORGUNIT = PKG_BSAFE + 136;
  STR_BSAFE_ID_FULL = (PKG_BSAFE + 137);
  STR_BSAFE_ID_DESKTOP = (PKG_BSAFE + 138);
  ERR_BSAFE_INVCERT_DATA = (PKG_BSAFE + 139);
  ERR_BSAFE_INVCROSSCERT_SIG = (PKG_BSAFE + 140);
  ERR_BSAFE_WRONG_CERT_SUBJECT = (PKG_BSAFE + 141);
  ERR_BSAFE_WRONG_CERT_ISSUER = (PKG_BSAFE + 142);
  STR_BSAFE_CROSS_CERTIFYING = (PKG_BSAFE + 143);
  STR_BSAFE_CROSS_CERTIFIED = (PKG_BSAFE + 144);
  ERR_BSAFE_INVCERT_SIG = (PKG_BSAFE + 145);
  STR_BSAFE_MAX_IBULKDATAKEY = (PKG_BSAFE + 146);
  ERR_BSAFE_WRONG_SUBJECT_KEY_SRV = PKG_BSAFE + 147;
  ERR_BSAFE_WRONG_SUBJECT_KEY_LOC = PKG_BSAFE + 148;
  ERR_BSAFE_CERT_NOT_ANCESTOR_SRV = PKG_BSAFE + 149;
  ERR_BSAFE_CERT_NOT_ANCESTOR_LOC = PKG_BSAFE + 150;
  ERR_BSAFE_ADDBOOK_CERT_ENTRY = (PKG_BSAFE + 151);
  ERR_BSAFE2_ATTRIBUTE_UNKNOWN = PKG_BSAFE2 + 0;
  ERR_BSAFE2_UNABLE_TO_PARSE_CERT = PKG_BSAFE2 + 1;


(******************************************************************************)
{ from nsferr.h }
(******************************************************************************)
{	Formula Compiler Error Codes }
const
  ERR_FORMULA_COMPILATION = PKG_FORMULA + 1;
  ERR_INVALID_OPERATOR = PKG_FORMULA + 2;
  ERR_INVALID_ARG_TYPE = PKG_FORMULA + 3;
  ERR_TOO_MANY_ARGS = PKG_FORMULA + 4;
  ERR_FN_OR_OP_EXPECTED = PKG_FORMULA + 5;
  ERR_INSUFFICIENT_ARGS = PKG_FORMULA + 6;
  ERR_NOT_UNARY = PKG_FORMULA + 7;
  ERR_NOT_BINARY = PKG_FORMULA + 8;
  ERR_PREMATURE_EOI = PKG_FORMULA + 10;
  ERR_OP_EXPECTED = PKG_FORMULA + 11;
  ERR_INVALID_FORMULA = PKG_FORMULA + 12;
  ERR_PAREN_EXPECTED = PKG_FORMULA + 13;
  ERR_EXTRA_RPAREN = PKG_FORMULA + 14;
  ERR_MISSING_RPAREN = PKG_FORMULA + 15;
  ERR_ASSIGNMENT_POS = PKG_FORMULA + 16;
  ERR_ASSIGNMENT_TARGET = PKG_FORMULA + 17;
  ERR_ASSIGNMENT_MODIFIER = PKG_FORMULA + 18;
  ERR_MISSING_ASS_SEP = PKG_FORMULA + 19;
  ERR_REM_FORMAT = PKG_FORMULA + 20;
  ERR_NO_MAIN_EXPRESSION = PKG_FORMULA + 21;
  ERR_NOT_A_FUNCTION = PKG_FORMULA + 22;
  ERR_UNTERMINATED_LITERAL = PKG_FORMULA + 23;
  ERR_IF_ODD_ARGS = PKG_FORMULA + 24;
  ERR_ONE_MAIN_EXPR = PKG_FORMULA + 25;
  ERR_NO_FORMULA = PKG_FORMULA + 26;
  ERR_UNKNOWN_FUNCTION = PKG_FORMULA + 27;
  ERR_SUMMITEMS_MERGE = PKG_FORMULA + 28;
  ERR_DUPLICATE_IVAR = PKG_FORMULA + 29;
  ERR_ARGS_EXPECTED = PKG_FORMULA + 30;
  ERR_BIG_LITERAL = PKG_FORMULA + 31;

(******************************************************************************)
{ from clerr.h }
(******************************************************************************)
{ CLIENT access routines error code }

const
  ERR_RENAME = PKG_CLIENT + 1;
  ERR_VERSION = PKG_CLIENT + 2;
  ERR_SERVER_NOT_FOUND = PKG_CLIENT + 3;
  ERR_SERVER_NAME_CHANGED = PKG_CLIENT + 4;
  ERR_NOT_IMPLEMENTED = PKG_CLIENT + 5;
  ERR_MULTI_THREAD = PKG_CLIENT + 6;
  ERR_SERVER_NOT_RESPONDING = PKG_CLIENT + 7;
  ERR_RETRY_NOTE_UPDATE = PKG_CLIENT + 8;
  ERR_RETRY_TRANSACTION = PKG_CLIENT + 9;
  ERR_MSG_TOO_SMALL = PKG_CLIENT + 10;
  ERR_MSG_FROM_SERVER = PKG_CLIENT + 11;
  ERR_SERVER_NOT_RESPONDING1 = PKG_CLIENT + 12;
  ERR_SERVER_NOT_RESPONDING2 = PKG_CLIENT + 13;
  ERR_NOT_AUTHENTIC = PKG_CLIENT + 14;
  ERR_SCAN_LOCK_LOST = PKG_CLIENT + 15;
  ERR_MULTI_TRANS = PKG_CLIENT + 16;
  ERR_SERVER_NOT_RESPONDING3 = PKG_CLIENT + 17;
  ERR_CL_NO_REMOTE_CONSOLE_ACCESS = PKG_CLIENT + 18;
  ERR_CL_NO_RESPONSE = PKG_CLIENT + 19;
  ERR_TERMINATE = PKG_CLIENT + 20;
  ERR_CL_NOT_RESPONDING = PKG_CLIENT + 21;
  ERR_NEED_RECEIVE_DATA = PKG_CLIENT + 22;
  ERR_SRV_LENGTH_MISMATCH = PKG_CLIENT + 23;
  ERR_LOG_NOFAILOVER = PKG_CLIENT + 24;
  ERR_LOOKFOR_REPLICA = PKG_CLIENT + 25;
  ERR_LOOKUP = PKG_CLIENT + 26;
  ERR_FOUND_REPLICA = PKG_CLIENT + 27;
  ERR_LOOKFOR_REPLICA_EXT = PKG_CLIENT + 28;
  ERR_RETRY_WITH_NEW_SESSION = PKG_CLIENT + 29;
  ERR_CLUSTER_NOMATES = PKG_CLIENT + 30;
  ERR_NO_CS_SUPPORT = PKG_CLIENT + 31;
  ERR_REACHED_WRONG_SERVER = PKG_CLIENT + 32;
  ERR_BAD_SUMMARY_BUFFER = PKG_CLIENT + 33;


(******************************************************************************)
{ from eventerr.h }
(******************************************************************************)
{	Message codes for the Event Package }

const
  ERR_EVENT_EXCEED_MEM = PKG_EVENT + 1;
  ERR_EVENT_DUPL_QUEUE = PKG_EVENT + 2;
  ERR_EVENT_NOT_Q = PKG_EVENT + 3;
  ERR_EVENT_EXCEED_QUOTA = PKG_EVENT + 4;
  ERR_EVTQUEUE_EMPTY = PKG_EVENT + 5;
  ERR_EVENT_NO_SUCH_QUEUE = PKG_EVENT + 6;
  ERR_EVENT_NOT_YOUR_Q = PKG_EVENT + 7;
  ERR_EVENT_WRONG_VERSION = PKG_EVENT + 8;
  ERR_EVENT_BAD_SEVERITY = PKG_EVENT + 9;
  ERR_EVENT_NOT_INITIALIZED = PKG_EVENT + 10;
  ERR_EVENT_POOLFULL = PKG_EVENT + 11;
  ERR_EVENT_SHUTDOWN = PKG_EVENT + 12;

{ Since this name space is so underutilized, it will share its top }
{ space with the briefcase.  So unlike most error ranges, PKG_EVENT }
{ can only range from 0 to 127.  PKG_BCASE goes from 128 to 256. }


(******************************************************************************)
{ from fterr.h }
(******************************************************************************)
{ FT (Full text) error status codes }

const
  ERR_FT = PKG_FT + 0;
  ERR_FT_RAW = PKG_FT + 1;
  ERR_FT_NOT_INDEXED = PKG_FT + 2;
  ERR_FT_INIT_API = PKG_FT + 3;
  ERR_FT_NOT_FOUND = PKG_FT + 4;
  ERR_FT_NO_EXIST = PKG_FT + 5;
  ERR_FT_TOO_MANY_DBS = PKG_FT + 6;
  ERR_FT_DB_NOT_FOUND = PKG_FT + 7;
  ERR_FT_HIGHLIGHTS = PKG_FT + 8;
  ERR_FT_BAD_QUERY = PKG_FT + 9;
  ERR_STALE_HIGHLIGHTS = PKG_FT + 10;
  ERR_FT_BAD_SEARCH_HANDLE = PKG_FT + 11;
  ERR_FT_IN_USE = PKG_FT + 12;
  ERR_FT_REBUILD = PKG_FT + 13;
  ERR_FT_NEWER_VER = PKG_FT + 14;
  ERR_FT_STRUCT_SIZE = PKG_FT + 15;
  ERR_FT_VER0 = PKG_FT + 16;
  ERR_FT_TOPIC = PKG_FT + 17;
  ERR_FT_DIR_LINK = PKG_FT + 18;
  ERR_FT_BEING_INDEXED = PKG_FT + 19;

{	Log message codes }

const
  LOG_FT_TOPIC_MSG = PKG_FT + 20;
  LOG_FT_TOPIC_ERR_STACK = PKG_FT + 21;
  LOG_FT_TOPIC_ERR = PKG_FT + 22;
  LOG_FT_DELETE_ERR = PKG_FT + 23;
  LOG_FT_LEGACY_ERR = PKG_FT + 24;
  LOG_FT_INDEX_ERR = PKG_FT + 25;

{	More error codes }

const
  ERR_FT_MORE_THAN_5000_DOCS = PKG_FT + 30;
  ERR_FT_BAD_FIELD = PKG_FT + 31;
  ERR_FT_BAD_PAREN = PKG_FT + 32;
  ERR_FT_BAD_OPERATOR = PKG_FT + 33;
  ERR_FT_NOMATCHES = PKG_FT + 34;
  ERR_FT_TEXT_FIELD = PKG_FT + 35;
  ERR_FT_FIELD_NOT_INDEXED = PKG_FT + 36;
  ERR_FT_INDEX_BAD = PKG_FT + 37;
  ERR_FT_TOPIC_NOSEE_LOG = PKG_FT + 38;
  ERR_FT_TOPIC_CORRUPT_INDEX = PKG_FT + 39;

{ String definitions }

const
  STR_FT_LIBNAME_KEY = PKG_FT + 40;
  STR_FT_DEF_LIBNAME = PKG_FT + 41;
  STR_FT_PROGRESS = PKG_FT + 42;
  STR_FT_MERGING = PKG_FT + 43;
  STR_FT_FINISH = PKG_FT + 44;
  STR_FT_KEYWORDS = PKG_FT + 45;
  ERR_FT_NEEDQUOTES = PKG_FT + 46;

(******************************************************************************)
{ from miscerr.h }
(******************************************************************************)
{ MISC error codes }

const
  ERR_QUEUE_NOT_EMPTY = PKG_MISC + 1;
  ERR_QUEUE_EMPTY = PKG_MISC + 2;
  ERR_TEXT_PATTERN = PKG_MISC + 3;
  ERR_NOT_FOUND = PKG_MISC + 4;
  ERR_FLOAT_CONVERSION = PKG_MISC + 5;
  ERR_NO_SUBINDEX = PKG_MISC + 6;
  ERR_NOT_EMPTY = PKG_MISC + 7;
  ERR_DUPLICATE_KEY = PKG_MISC + 8;
  ERR_BUFFER_OVERFLOW = PKG_MISC + 9;
  ERR_IFMT = PKG_MISC + 10;
  ERR_TFMT = PKG_MISC + 11;
  ERR_TDI_CONV = PKG_MISC + 12;
  ERR_TDO_CONV = PKG_MISC + 13;
  ERR_NAME_LENGTH = PKG_MISC + 14;

(******************************************************************************)
{ from neterr.h }
(******************************************************************************)
const
  ERR_NO_MORE_SESSIONS = PKG_NETWORK + 1;
  ERR_SESSION_CLOSED = PKG_NETWORK + 2;
  ERR_NAME_IN_USE = PKG_NETWORK + 3;
  ERR_NET_FLAKY = PKG_NETWORK + 4;
  ERR_NET_HARDWARE = PKG_NETWORK + 5;
  ERR_NET_SOFTWARE = PKG_NETWORK + 6;
  ERR_TIMEOUT = PKG_NETWORK + 7;
  ERR_NET_CMD_CANCELLED = PKG_NETWORK + 8;
  ERR_RETRY = PKG_NETWORK + 9;
  ERR_NOT_RESPONDING = PKG_NETWORK + 10;
  ERR_NAME_IN_USE_HERE = PKG_NETWORK + 11;
  ERR_INSUF_RCVD_DATA = PKG_NETWORK + 12;
  ERR_SEQUENCE_NUMBER = PKG_NETWORK + 13;
  ERR_BFR_TOO_SMALL = PKG_NETWORK + 14;
  ERR_NO_NETBIOS = PKG_NETWORK + 15;
  ERR_WRONG_SERVER = PKG_NETWORK + 16;
  ERR_DISCONNECTED = PKG_NETWORK + 17;
  ERR_HANGUP = PKG_NETWORK + 18;
  ERR_TERMINATED = PKG_NETWORK + 19;
  ERR_WRONG_STATE = PKG_NETWORK + 20;
  ERR_REMOTE_BUSY = PKG_NETWORK + 21;
  ERR_NO_ANSWER = PKG_NETWORK + 22;
  ERR_NO_CARRIER = PKG_NETWORK + 23;
  ERR_NO_DIALTONE = PKG_NETWORK + 24;
  ERR_BADPORT_ARGS = PKG_NETWORK + 25;
  ERR_MODEM_RESPONSE = PKG_NETWORK + 26;
  ERR_MODEM_NORESP = PKG_NETWORK + 27;
  ERR_HANDSHAKE = PKG_NETWORK + 28;
  ERR_SESS_NOT_READY = PKG_NETWORK + 29;
  ERR_NO_SUCH_UNIT = PKG_NETWORK + 30;
  ERR_DEVICE_IN_USE = PKG_NETWORK + 31;
  ERR_DRIVER_IN_USE = PKG_NETWORK + 32;
  ERR_NO_RING_BUFFER = PKG_NETWORK + 33;
  ERR_NO_BUFFERS = PKG_NETWORK + 34;
  ERR_BADDEV_PARAMS = PKG_NETWORK + 35;
  ERR_BAD_RESPONSE = PKG_NETWORK + 36;
  ERR_NO_SUCH_PORT = PKG_NETWORK + 37;
  ERR_NO_SUCH_SESSION = PKG_NETWORK + 38;
  ERR_SERVERS_UNKNOWN = PKG_NETWORK + 39;
  ERR_DUPL_PORTNAME = PKG_NETWORK + 40;
  ERR_MSGQUEUE_EMPTY = PKG_NETWORK + 41;
  ERR_NOT_QUEUE = PKG_NETWORK + 42;
  ERR_INSUFF_ARGS = PKG_NETWORK + 43;
  ERR_INSUFF_ADAP_RES = PKG_NETWORK + 44;
  ERR_NO_PORT_FUNC = PKG_NETWORK + 45;
  ERR_NO_PROGRESS = PKG_NETWORK + 46;

{ 46 Unused }

const
  ERR_NET_NOT_INIT = PKG_NETWORK + 48;
  ERR_NETBFR_YIELD = PKG_NETWORK + 49;
  ERR_NETBFR_ISSUERCV = PKG_NETWORK + 50;
  ERR_NETBFR_ISSUEXMT = PKG_NETWORK + 51;
  ERR_NETBFR_INUSE = PKG_NETWORK + 52;
  ERR_ADAP_NOT_INIT = PKG_NETWORK + 53;
  ERR_NO_SERVER_INFO = PKG_NETWORK + 54;
  ERR_NO_PORT_FROM_DB = PKG_NETWORK + 55;
  ERR_NO_SUCH_SITE = PKG_NETWORK + 56;
  ERR_NO_WORK_SCHEDULED = PKG_NETWORK + 57;
  ERR_UNKNOWN_APPL = PKG_NETWORK + 58;
  ERR_TOO_MANY_APPLS = PKG_NETWORK + 59;
  ERR_LANMAN_PROC_LIMIT = PKG_NETWORK + 60;
  ERR_NET_CONTINUE = PKG_NETWORK + 61;
  STR_MAC_DEFAULT_PORTNAME4 = PKG_NETWORK + 62;
  ERR_LINK_TABLE_FULL = PKG_NETWORK + 63;
  ERR_NET_PORT_VERSION = PKG_NETWORK + 64;
  ERR_NO_SCHED_INFO = PKG_NETWORK + 65;
  ERR_NET_ONPORT_SUFFIX = PKG_NETWORK + 66;
  ERR_NET_CARRIER_DOWN = PKG_NETWORK + 67;
  ERR_NET_CARRIER_UP = PKG_NETWORK + 68;
  ERR_NET_PORT_REINIT = PKG_NETWORK + 69;
  ERR_DIAL_QUERY1 = PKG_NETWORK + 70;
  ERR_DIAL_QUERY2 = PKG_NETWORK + 71;
  ERR_DIAL_QUERY3 = PKG_NETWORK + 72;
  ERR_DIAL_QUERY_NO = PKG_NETWORK + 73;
  ERR_1200_DIAL_ERROR = PKG_NETWORK + 74;
  ERR_MODEM_BADCMD = PKG_NETWORK + 75;
  ERR_STRING_RESOURCE = PKG_NETWORK + 76;
  ERR_NET_CLEARING_DTR = PKG_NETWORK + 77;
  ERR_NET_ANSWERING_PHONE = PKG_NETWORK + 78;
  ERR_NO_SUCH_TASK = PKG_NETWORK + 79;
  ERR_DIAL_TIMER_EXPIRED = PKG_NETWORK + 80;
  ERR_UNKNOWN_LANMAN = PKG_NETWORK + 81;
  ERR_NET_NOT_STARTED = PKG_NETWORK + 82;
  ERR_INTERNAL_LANMAN = PKG_NETWORK + 83;
  ERR_DRIVER_HANDLE = PKG_NETWORK + 84;
  ERR_BAD_UNIT_NUM = PKG_NETWORK + 85;
  ERR_INSUFF_OS_RES = PKG_NETWORK + 86;
  ERR_INSUFF_CMDS = PKG_NETWORK + 87;
  ERR_ADAP_BUSY = PKG_NETWORK + 88;
  ERR_NOLOGFILE = PKG_NETWORK + 89;
  ERR_DRIVER_NOT_INIT = PKG_NETWORK + 90;
  ERR_LOGENTRY_INVALID = PKG_NETWORK + 91;
  ERR_LOG_NULLHANDLE = PKG_NETWORK + 92;
  ERR_LOG_RESERVED_ENTRY = PKG_NETWORK + 93;
  ERR_NO_ITEM_NAME = PKG_NETWORK + 94;
  ERR_DIAL_QUERY2_REMOTE_LAN = PKG_NETWORK + 95;
  ERR_ADAP_CABLE = PKG_NETWORK + 96;
  ERR_ADAP_NAME_TABLE = PKG_NETWORK + 97;
  ERR_CANT_ENABLE_PORTS = PKG_NETWORK + 98;
  ERR_ILL_REQ_CODE = PKG_NETWORK + 99;

{ 100 unused	}

const
  ERR_PORT_NAME_CHARS = PKG_NETWORK + 101;
  ERR_INVALID_NET_PORT_NAME = PKG_NETWORK + 102;
  ERR_INACTIVE_PORT = PKG_NETWORK + 103;
  ERR_BAD_BUFFER = PKG_NETWORK + 104;
  ERR_BAD_BUFFER_POST_MSG = PKG_NETWORK + 105;

{  106-109 unused }

const
  STR_SCHED_REPL_MISSED = PKG_NETWORK + 110;
  STR_ITEM_TARGETSERVER = PKG_NETWORK + 111;
  STR_ITEM_REMOTESERVER = PKG_NETWORK + 112;
  STR_ITEM_PHONENUMBER = PKG_NETWORK + 113;
  STR_ITEM_INCOMINGCALL = PKG_NETWORK + 114;
  STR_NET_PORT_REDUCING_SESSIONS = PKG_NETWORK + 115;
  STR_ITEM_CALLSTATUS = PKG_NETWORK + 116;
  STR_ITEM_INBOUNDCONNECTS = PKG_NETWORK + 117;
  STR_ITEM_OUTBOUNDCONNECTS = PKG_NETWORK + 118;
  STR_ITEM_BYTESXMT = PKG_NETWORK + 119;
  STR_ITEM_BYTESRCV = PKG_NETWORK + 120;
  ERR_SERVER_ONLY = PKG_NETWORK + 121;
  STR_JS_ITEM_NAMES = PKG_NETWORK + 122;
  STR_JS_NAMESPACE = PKG_NETWORK + 123;
  STR_REM_SERVER_SUFFIX = PKG_NETWORK + 124;
  STR_JS_PGM_ITEM_NAMES = PKG_NETWORK + 125;
  STR_JS_PGM_NAMESPACE = PKG_NETWORK + 126;
  STR_JS_WKSREP_NAMESPACE = PKG_NETWORK + 127;
  STR_JS_WKSREP_ITEM_NAMES = PKG_NETWORK + 128;

{ 129 unused }

const
  STR_ITEM_PORTERRORS = PKG_NETWORK + 130;
  STR_ITEM_CRCERRORS = PKG_NETWORK + 131;
  STR_ITEM_REXMTS = PKG_NETWORK + 132;
  STR_ITEM_PORTSPEED = PKG_NETWORK + 133;
  STR_ITEM_CARRIERSPEED = PKG_NETWORK + 134;
  ERR_ANQ_SIZE = PKG_NETWORK + 135;
  STR_ANAME_LOOKUP_RQST = PKG_NETWORK + 136;
  ERR_NET_GROUP_POOLFULL = PKG_NETWORK + 137;
  ERR_NET_SCHEDULE_POOLFULL = PKG_NETWORK + 138;
  ERR_NET_JS_POOLFULL = PKG_NETWORK + 139;
  ERR_NET_POOLFULL = PKG_NETWORK + 140;
  ERR_TASK_POOLFULL = PKG_NETWORK + 141;
  ERR_NET_JSPATH_POOLFULL = PKG_NETWORK + 142;
  ERR_LOG_QUOTA_EXCEEDED = PKG_NETWORK + 143;

{	Strings which are the names of the various NSF/NIF transactions.
	Used to display them for debugging (CLIENT_CLOCK). }

const
  STR_GET_MULT_NOTE_INFO_UNID_RQST = PKG_NETWORK + 144;
  STR_ASYNC_NIFOPENNOTE_RQST = PKG_NETWORK + 145;
  STR_ASYNC_READ_ENTRIES_RQST = PKG_NETWORK + 146;
  STR_ASYNC_CANCEL_RQST = PKG_NETWORK + 147;
  STR_ASYNC_OPEN_NOTE_RQST = PKG_NETWORK + 148;
  STR_ASYNC_READ_OBJECT_RQST = PKG_NETWORK + 149;
  STR_OPEN_DB_RQST = PKG_NETWORK + 150;
  STR_CREATE_DB_RQST = PKG_NETWORK + 151;
  STR_CLOSE_DB_RQST = PKG_NETWORK + 152;
  STR_CLOSE_DB_RQST_ALT = PKG_NETWORK + 153;
  STR_GET_SPECIAL_NOTE_ID_RQST = PKG_NETWORK + 154;
  STR_ITEM_DEF_TABLE_RQST = PKG_NETWORK + 155;
  STR_OPEN_NOTE_RQST = PKG_NETWORK + 156;
  STR_DELETE_NOTE_RQST = PKG_NETWORK + 157;
  STR_GET_NOTE_INFO_RQST = PKG_NETWORK + 158;
  STR_SET_SPECIAL_NOTE_ID_RQST = PKG_NETWORK + 159;
  STR_DB_INFO_GET_RQST = PKG_NETWORK + 160;
  STR_DB_INFO_SET_RQST = PKG_NETWORK + 161;
  STR_DB_MODIFIED_TIME_RQST = PKG_NETWORK + 162;
  STR_SEARCHSTART_RQST = PKG_NETWORK + 163;
  STR_SEARCHSTOP_RQST = PKG_NETWORK + 164;
  STR_SERVER_TIME_RQST = PKG_NETWORK + 165;
  STR_DELETE_DB_RQST = PKG_NETWORK + 166;
  STR_FILE_SUMMARY_RQST = PKG_NETWORK + 167;

{ 168, 169 unused }

const
  STR_DB_REPLINFO_SET_RQST = PKG_NETWORK + 170;
  STR_DB_REPLINFO_GET_RQST = PKG_NETWORK + 171;
  STR_GET_MODIFIED_NOTES_RQST = PKG_NETWORK + 172;
  STR_STAMP_NOTES_RQST = PKG_NETWORK + 173;
  STR_RENAME_DB_RQST = PKG_NETWORK + 174;
  STR_REPLICATE_RQST = PKG_NETWORK + 175;
  STR_GET_OBJECT_SIZE_RQST = PKG_NETWORK + 176;
  STR_FREE_OBJECT_RQST = PKG_NETWORK + 177;
  STR_ALLOC_OBJECT_RQST = PKG_NETWORK + 178;
  STR_REALLOC_OBJECT_RQST = PKG_NETWORK + 179;
  STR_READ_OBJECT_RQST = PKG_NETWORK + 180;
  STR_WRITE_OBJECT_RQST = PKG_NETWORK + 181;
  STR_OPEN_COLLECTION_RQST = PKG_NETWORK + 182;
  STR_CLOSE_COLLECTION_RQST = PKG_NETWORK + 183;
  STR_CLOSE_COLLECTION_RQST_ALT = PKG_NETWORK + 184;
  STR_UPDATE_COLLECTION_RQST = PKG_NETWORK + 185;
  STR_UPDATE_FILTERS_RQST = PKG_NETWORK + 186;
  STR_READ_ENTRIES_RQST = PKG_NETWORK + 187;
  STR_LOCATE_NOTE_RQST = PKG_NETWORK + 188;
  STR_FIND_NOTEID_RQST = PKG_NETWORK + 189;
  STR_UPDATE_NOTE_RQST_ALT = PKG_NETWORK + 190;
  STR_LOOKUP_HELP_NOTE_RQST = PKG_NETWORK + 191;
  STR_FIND_BY_KEY_RQST = PKG_NETWORK + 192;
  STR_NAME_LOOKUP_RQST = PKG_NETWORK + 193;
  STR_AUTHENTICATE_RQST = PKG_NETWORK + 194;
  STR_DB_SPACE_USAGE_RQST = PKG_NETWORK + 195;
  STR_TEXT_SEARCH_RQST = PKG_NETWORK + 196;
  ERR_QUIT = PKG_NETWORK + 197;
  STR_ALLOC_UPOBJECT_RQST = PKG_NETWORK + 198;
  STR_FREE_UPOBJECT_RQST = PKG_NETWORK + 199;
  STR_NIFOPENNOTE_RQST = PKG_NETWORK + 200;
  STR_NIFSTAMPNOTES_RQST = PKG_NETWORK + 201;
  STR_GET_SERVER_NAMES_RQST = PKG_NETWORK + 202;
  STR_GET_SERVER_STATS_RQST = PKG_NETWORK + 203;
  STR_RELAY_EVENT_RQST = PKG_NETWORK + 204;
  STR_FT_SEARCH_RQST = PKG_NETWORK + 205;
  STR_FT_CLOSE_SEARCH_RQST = PKG_NETWORK + 206;
  STR_REMOTE_CONSOLE_RQST = PKG_NETWORK + 207;
  STR_DB_SQUEEZE_RQST = PKG_NETWORK + 208;
  STR_FT_INDEX_RQST = PKG_NETWORK + 209;
  STR_FT_GET_LAST_INDEXTIME_RQST = PKG_NETWORK + 210;
  STR_FT_DELETE_INDEX_RQST = PKG_NETWORK + 211;
  STR_GET_NAMED_OBJECT_ID_RQST = PKG_NETWORK + 212;
  STR_DB_READ_HIST_RQST = PKG_NETWORK + 213;
  STR_DB_WRITE_HIST_RQST = PKG_NETWORK + 214;
  STR_GET_NOTE_INFO_BY_UNID_RQST = PKG_NETWORK + 215;
  STR_NAME_LOOKUPID_RQST = PKG_NETWORK + 216;
  STR_POLL_DEL_SEQNUM_RQST = PKG_NETWORK + 217;
  STR_GET_MULT_NOTE_INFO_RQST = PKG_NETWORK + 218;
  STR_GET_COLLECTION_DATA_RQST = PKG_NETWORK + 219;

{ The following strings are used by newsetup to try to set up Netbios for
	unit number other than 0 - dba }

const
  STR_LANX_PORT = PKG_NETWORK + 220;
  STR_LANX_PORTINFO = PKG_NETWORK + 221;
  STR_LANX_PORTINFO2 = PKG_NETWORK + 222;
  STR_LAN1_PORT = PKG_NETWORK + 223;
  STR_LAN1_PORTINFO = PKG_NETWORK + 224;
  ERR_ILL_SVCTYPE = PKG_NETWORK + 225;

(******************************************************************************)
{ from niferr.h }
(******************************************************************************)
{ NIF error status codes }

const
  ERR_SORT_DATATYPE = PKG_NIF + 1;

{	The ERR_BAD_COLLECTION error is obsolete is only retained for
	compatibility with pre-109 systems. }

const
  ERR_BAD_COLLECTION = PKG_NIF + 2;
  ERR_COLLECTION_HANDLE = PKG_NIF + 3;
  ERR_MORE_TO_DO = PKG_NIF + 4;
  ERR_COLLECTION_DELETED = PKG_NIF + 5;
  ERR_UNSUPPORTED_FLAGS = PKG_NIF + 6;
  ERR_LOOKUP_ERROR = PKG_NIF + 7;
  ERR_TOO_MANY_LEVELS = PKG_NIF + 8;
  ERR_NO_SUCH_NAMESPACE = PKG_NIF + 9;
  ERR_NO_NAMES_FILE = PKG_NIF + 10;
  ERR_COLLECTION_NOT_CREATED = PKG_NIF + 11;
  ERR_NAVIGATE_FAILED = PKG_NIF + 12;
  ERR_VIEW_NOACCESS = PKG_NIF + 13;
  ERR_WRITE_COLLECTION_ERR = PKG_NIF + 14;
  ERR_NO_SUCH_NAMES_BOOK = PKG_NIF + 15;
  ERR_NO_SUCH_ITEM = PKG_NIF + 16;
  ERR_NO_MORE_MEMBERS = PKG_NIF + 17;
  ERR_UNSUPPORTED_TYPE = PKG_NIF + 18;
  ERR_NO_MORE_MATCH = PKG_NIF + 19;
  ERR_NO_REMOTE_INDEX = PKG_NIF + 20;
  ERR_UPDATE_INTERRUPTED = PKG_NIF + 21;
  ERR_CONTAINER_ITEM_NOT_FOUND = PKG_NIF + 22;
  ERR_PARTIAL_MATCH = PKG_NIF + 23;
  ERR_USER_NOT_FOUND = PKG_NIF + 24;
  ERR_IDFILE_NOT_FOUND = PKG_NIF + 25;
  ERR_WAS_PERMUTED = PKG_NIF + 26;
  ERR_BAD_COLLATION = PKG_NIF + 27;
  ERR_BAD_COLLECTION_DATA = PKG_NIF + 28;
  ERR_REBUILD_VIEW = PKG_NIF + 29;
  ERR_RDONLY_DIFF_PLATFORM = PKG_NIF + 30;
  ERR_NIF_COLLREBUILDPDL = PKG_NIF + 31;
  ERR_NIF_POOLFULL = PKG_NIF + 32;
  ERR_NIF_COLLREBUILD = PKG_NIF + 33;
  ERR_NIF_COLLREBUILDNCOI = PKG_NIF + 34;
  ERR_NIF_COLLREBUILDCIL = PKG_NIF + 35;
  ERR_NIF_COLLREBUILDCS = PKG_NIF + 36;
  ERR_NIF_COLLREBUILDDC = PKG_NIF + 37;
  ERR_NIF_COLLREBUILDCDP = PKG_NIF + 38;
  ERR_NIF_COLLREBUILDCDL = PKG_NIF + 39;
  ERR_NIF_COLLREBUILDRC = PKG_NIF + 40;
  ERR_NIF_COLLREBUILDFC = PKG_NIF + 41;
  ERR_NIF_COLLREBUILDCC = PKG_NIF + 42;
  ERR_NIF_COLLREBUILDSCC = PKG_NIF + 43;
  ERR_BAD_COLLATION_NUM = PKG_NIF + 45;
  ERR_BAD_CHASHTBL_DELETION = PKG_NIF + 46;
  ERR_BAD_CUHASHTBL_DELETION = PKG_NIF + 47;
  ERR_NIF_BAD_KEYBUFFER = PKG_NIF + 48;
  ERR_NIF_TOO_MANY_NAMES = PKG_NIF + 49;
  ERR_NAMED_FOLDER_NOT_FOUND = PKG_NIF + 50;
  ERR_COLLHASH_POOLFULL = PKG_NIF + 51;
  ERR_NIF_COLLOBJ = PKG_NIF + 52;
  ERR_NIF_COLLHDR = PKG_NIF + 53;
  ERR_NIF_COLLTBL = PKG_NIF + 54;
  ERR_NIF_REMOTE_NAB = PKG_NIF + 55;
  ERR_NIF_FULLSEARCH = PKG_NIF + 56;
  ERR_NIF_UPDATE_NA_VIEW = PKG_NIF + 57;
  ERR_DA_BUF_INSUF = PKG_NIF + 58;
  ERR_DA_INIT_FAILED = PKG_NIF + 59;
  ERR_DA_RELOAD_FAILED = PKG_NIF + 60;
  ERR_DA_INVALID_RULE = PKG_NIF + 61;
  ERR_DA_INVALID_REPLICA = PKG_NIF + 62;

{ 	The following errors are used in lookup.c for the LDAP Gateway. }

const
  ERR_NIF_BIND = PKG_NIF + 63;
  ERR_NIF_CONNECT = PKG_NIF + 64;
  ERR_NIF_BAD_URL = PKG_NIF + 65;
  ERR_NIF_LDAP_LOOKUP = PKG_NIF + 66;
  ERR_NIF_LDAP_SEARCH = PKG_NIF + 67;

{ 	NOTE: NIF errors can only go up to PKG_NIF+121 - higher values are used in NSF as PKG_NSF2 }


(******************************************************************************)
{ from odserr.h }
(******************************************************************************)
{ ODS Error Codes }

const
  ERR_ODS = PKG_ODS + 1;
  ERR_DATATYPE = PKG_ODS + 2;
  ERR_ODS_TEXT_TOOBIG = PKG_ODS + 3;
  ERR_ODS_ENUM_COMPLETE = PKG_ODS + 4;
  ERR_ODS_NO_SUCH_ENTRY = PKG_ODS + 5;
  ERR_ODS_FILE_ZEROLENGTH = PKG_ODS + 6;
  ERR_ODS_REC_ZEROLENGTH = PKG_ODS + 7;
  ERR_ODS_REC_UNKNOWN = PKG_ODS + 8;
  ERR_ODS_SHORT_INPUT = PKG_ODS + 9;

(******************************************************************************)
{ from oserr. h }
(******************************************************************************)
const
  ERR_UNKNOWN = PKG_OS + 1;
  ERR_PROTECTED = PKG_OS + 2;
  ERR_NOEXIST = PKG_OS + 3;
  ERR_EXISTS = PKG_OS + 4;
  ERR_FILES = PKG_OS + 5;
  ERR_DISK = PKG_OS + 6;
  ERR_MEMORY = PKG_OS + 7;

const
  ERR_CREATE = PKG_OS + 8;
  ERR_TRUNC = PKG_OS + 9;
  ERR_LOCKS = PKG_OS + 10;
  ERR_NO_MORE_FILES = PKG_OS + 11;
  ERR_LOCK = PKG_OS + 12;
  ERR_FD = PKG_OS + 13;
  ERR_IOERROR = PKG_OS + 14;
  ERR_DRIVE_NOT_READY = PKG_OS + 15;
  ERR_ACCESS = PKG_OS + 16;
  ERR_PROGDIR = PKG_OS + 17;
  ERR_INV_SERVER_NAME = PKG_OS + 18;
  ERR_INV_FILE_NAME = PKG_OS + 19;
  ERR_CANCEL = PKG_OS+157;

(******************************************************************************)
{ from regerr.h }
(******************************************************************************)

const
  ERR_REG_INC_CONTEXT = PKG_REG + 1;
  ERR_REG_ADDRBOOK_ENTRY_EXISTS = PKG_REG + 2;
  ERR_REG_USERID_EXISTS = PKG_REG + 3;
  ERR_REG_BEGIN_CERTIFYING = PKG_REG + 4;
  ERR_REG_NO_MAILFILE_CREATED = PKG_REG + 5;
  ERR_REG_BEGIN_REGISTERING = PKG_REG + 6;
  ERR_REG_CREATINGNEWMAIL = PKG_REG + 7;
  ERR_REG_ADDIDTOBOOK = PKG_REG + 8;
  ERR_REG_DONE_REGISTERING = PKG_REG + 9;
  ERR_REG_LOG_ADDRBOOK_EXISTS = PKG_REG + 10;
  ERR_REG_LOG_USERID_EXISTS = PKG_REG + 11;
  ERR_REG_LOG_NO_PASSWORD = PKG_REG + 12;
  ERR_REG_BEGIN_IDFILE_CREATE = PKG_REG + 13;
  ERR_REG_TOO_MANY_ENTRIES = PKG_REG + 14;
  ERR_REG_DONE_CERTIFYING = PKG_REG + 15;
  ERR_REG_NO_IDFILE_NAME = PKG_REG + 16;
  ERR_REG_NO_MAIL_INFO = PKG_REG + 17;
  ERR_REG_NO_LASTNAME = PKG_REG + 18;
  ERR_REG_NO_SERVER_NAME = PKG_REG + 19;
  ERR_REG_NO_CERTIFIER = PKG_REG + 20;
  ERR_REG_NO_PASSWORD = PKG_REG + 21;
  ERR_REG_OPEN_CERTLOG = PKG_REG + 22;
  ERR_REG_ACCESS_CERTLOG = PKG_REG + 23;
  ERR_REG_UPDATE_CERTLOG = PKG_REG + 24;
  ERR_REG_OURSERVERS = PKG_REG + 25;
  STR_REG_UPDATING_CERTLOG = PKG_REG + 26;
  ERR_REG_USER_NOT_FOUND = PKG_REG + 27;
  ERR_REG_IDFILE_NOT_FOUND = PKG_REG + 28;
  ERR_REG_NOSUCHUSER = PKG_REG + 29;
  ERR_REG_NOTUNIQUE = PKG_REG + 30;
  ERR_REG_NOSUCHSERVER = PKG_REG + 31;
  ERR_REG_SERVERNOTUNIQUE = PKG_REG + 32;
  STR_REG_NETWARE_NAME = PKG_REG + 33;
  ERR_REG_NO_STORED_CERTKEY = PKG_REG + 34;
  ERR_REG_NO_SRV_VIEW = PKG_REG + 35;
  ERR_REG_LOG_PASSWORD_ADDRESSBOOK = PKG_REG + 36;
  ERR_REG_LOG_MINPSWDCHARS = PKG_REG + 37;
  ERR_REG_CREATING_ADMINREQTOCREATEMAIL = PKG_REG + 38;
  ERR_REG_NO_ADMINREQTOCREATEMAIL = PKG_REG + 39;
  ERR_REG_NO_ADMINPROCESS = PKG_REG + 40;
  ERR_REG_CREATEMAILSETUP = PKG_REG + 41;
  ERR_REG_NT_PASSWORD_SIZE = PKG_REG + 42;
  ERR_REG_NT_ACCESS_DENIED = PKG_REG + 43;
  ERR_REG_NT_DC_NOT_FOUND = PKG_REG + 44;
  ERR_REG_NT_DLL_NOT_FOUND = PKG_REG + 45;
  ERR_REG_NT_USER_GROUP_ABSENT = PKG_REG + 46;
  ERR_REG_NT_REG_FAILED = PKG_REG + 47;
  ERR_REG_NT_USER_EXISTS = PKG_REG + 48;
  ERR_REG_ADDCERTIFICATETOBOOK = PKG_REG + 49;

{	NOTE:  PKG_REG+51 through PKG_REG+151 are used by the setup program
			to provide network choices.

	The format of the stringtext is five fields separated by | (vertical bar):
		(1) List of platform names on which support is provided separated by
			; (semi-colons) -- must match platform name in global.h EXACTLY
		(2) Flags defined below (WORKSTATION_SUPPORT, etc.)
		(3) PortName in Ports= or DisabledPorts= line in notes.ini
		(4) Notes.ini PortName variable, specifying DLL name, unit number,
			number of simultaneous sessions, and buffer size in bytes
		(5) Dialog box description in Setup (TRANSLATE THIS ONE ONLY!).

	The order of the list of choices during setup for a given platform is
	determined by the order they are in the strings.  
		
	Network support may also be added by having a similar string in a
	text file which is shipped with the given network driver (like SNA).
	These networks will be at the end of the list.

	DO NOT USE PKG_REG+51 through PKG_REG+151!

}

{************************* SETUP Network resource strings ****************}

const
  NUMNETWORKSADDED = 50;
  MAXDLGSTRING = 50;
  MAXDLLNAME = 9;
  WORKSTATION_SUPPORT = $00000001;
  SERVER_SUPPORT = $00000002;
  PHONENUMBER_SUPPORT = $00000004      { Used for SNA support }
  ;
  MODEM_SUPPORT = $00000008;
  PKG_SETUP = PKG_REG + 51;

{	The following template is used so we can dynamically add the port name, unit
	number and driver name after querying the system.
}

const
  SETUP_XPC_TEMPLATE = PKG_SETUP;

{ 	Note the strings, AppleTalk and VINES, in the port name are checked in newsetup.c
	to exclude them from Win95 server setup selection.  If you change the name here,
	change it there in subroutine, PutEntryInTable.  }

const
  SETUP_NETWORK_FIRST = (PKG_SETUP + 10);
  SETUP_NETWORK_LAST = (PKG_SETUP + 100);

{	NOTE:  PKG_REG+51 through PKG_REG+151 are used by the setup program
			to provide network choices.

	DO NOT USE PKG_REG+51 through PKG_REG+151!
}

{ Minimal setup hardcodes network setup to TCP (first entry) }

const
  SETUP_NETWORK_TCPIP = 0;


(******************************************************************************)
{ from routeerr.h }
(******************************************************************************)
{ PUBLIC error messages returned by Router library routines,
	which may be returned to programs other than the Router itself. }

const
  ERR_ROUTER_UNKNOWN = (PKG_ROUTER + 1);
  ERR_ROUTER_NOTUNIQUE = (PKG_ROUTER + 4);
  ERR_ROUTER_NOSUCHUSER = (PKG_ROUTER + 5);
  ERR_ROUTER_NOMAILFILE = (PKG_ROUTER + 6);
  ERR_ROUTER_NEWMAIL = (PKG_ROUTER + 7);
  ERR_ROUTER_NOROUTETOSERVERFROM = (PKG_ROUTER + 8);
  ERR_ROUTER_NOROUTETODOMAINFROM = (PKG_ROUTER + 9);
  ERR_ROUTER_NOROUTETODOMAINVIA = (PKG_ROUTER + 10);
  ERR_ROUTER_DELIVERY_FILE = (PKG_ROUTER + 11);
  ERR_ROUTER_TRANSFER_FILE = (PKG_ROUTER + 12);
  ERR_ROUTER_NOGROUP = (PKG_ROUTER + 13);
  ERR_ROUTER_ROUTING_LOOP = (PKG_ROUTER + 14);
  ERR_ROUTER_ACCESS_DENIED = (PKG_ROUTER + 15);
  ERR_ROUTER_MESSAGE_QUEUE = (PKG_ROUTER + 16);
  ERR_ROUTER_MSGQ_POOLFULL = (PKG_ROUTER + 17);
  ERR_ROUTER_TRANSFER_Q_POOLFULL = (PKG_ROUTER + 18);
  ERR_ROUTER_TOO_MANY_RECIPS = (PKG_ROUTER + 19);
  ERR_ROUTER_LIST_LOOP = (PKG_ROUTER + 20);
  ERR_ROUTER_BILLING_NOMEM = (PKG_ROUTER + 21);
  STR_ROUTER_MSGSIZE_FORMULA = (PKG_ROUTER + 22);
  ERR_ROUTER_DELIVER_LOOP = (PKG_ROUTER + 23);
  ERR_ROUTER_NOROUTETODOMAIN = (PKG_ROUTER + 24);
  ERR_ROUTER_NOROUTETOSERVER = (PKG_ROUTER + 25);
  ERR_ROUTER_NOLOCALSERVER = (PKG_ROUTER + 26);
  ERR_ROUTER_SYMBOL_TABLE_FULL = (PKG_ROUTER + 27);
  ERR_ROUTER_SYMBOL_BUCKET_FULL = (PKG_ROUTER + 28);
  ERR_ROUTER_TOOMANYCONN = (PKG_ROUTER + 29);
  ERR_ROUTER_TOOMANYSERVERS = (PKG_ROUTER + 30);
  ERR_ROUTER_TOOMANYDOMAINS = (PKG_ROUTER + 31);
  ERR_ROUTER_SYMBOL_TASKS_FULL = (PKG_ROUTER + 32);
  ERR_ROUTER_TABLE_MEM_ERROR = (PKG_ROUTER + 33);
  ERR_ROUTER_DOMAIN_NAMESPACE = (PKG_ROUTER + 34);
  ERR_ROUTER_CONNECTION_NAMESPACE = (PKG_ROUTER + 35);
  ERR_ROUTER_SERVER_NAMESPACE = (PKG_ROUTER + 36);
  ERR_ROUTER_TOOMANYADJDOMAINS = (PKG_ROUTER + 37);
  ERR_ROUTER_FIND_VIEW_ERR = (PKG_ROUTER + 38);
  ERR_ROUTER_OPEN_VIEW_ERR = (PKG_ROUTER + 39);
  ERR_ROUTER_DELQ_POOLFULL = (PKG_ROUTER + 40);
  ERR_ROUTER_DOMAIN_BUFFER_EXCEEDED = (PKG_ROUTER + 41);
  ERR_ROUTER_SYMBOL_TABLE = (PKG_ROUTER + 42);
  ERR_ROUTER_SERVERNOTLOCALDOMAIN = (PKG_ROUTER + 43);
  ERR_ROUTER_DUPSERVER = (PKG_ROUTER + 44);
  ERR_ROUTER_NOSERVERENTRY = (PKG_ROUTER + 45);
  ERR_ROUTER_CONNNOTLOCALDOMAIN = (PKG_ROUTER + 46);

{ NOTE:	PKG_ROUTER+79 is the LAST code available for this file.  See }
{ globerr.h for dependency which restricts this string ID space. }


(******************************************************************************)
{ from secerr.h }
(******************************************************************************)
const
  ERR_SECURE_BUG_1 = PKG_SECURE + 1;

const
  ERR_SECURE_NOKEYFILE = PKG_SECURE + 2;
  ERR_SECURE_ENCRYPTED = PKG_SECURE + 3;
  ERR_SECURE_UNKNOWNFCT = PKG_SECURE + 4;
  ERR_SECURE_NOCLIENTCERT = PKG_SECURE + 5;
  ERR_SECURE_NOSERVERCERT = PKG_SECURE + 6;
  ERR_SECURE_ESTABLISHED = PKG_SECURE + 7;
  ERR_SECURE_BADPASSWORD = PKG_SECURE + 8;
  ERR_SECURE_PROTOCOL_1 = PKG_SECURE + 9;

const
  ERR_SECURE_INVALIDCTX = PKG_SECURE + 10;
  ERR_SECURE_INVRESPONSE = PKG_SECURE + 11;
  ERR_SECURE_INVCERTKEY = PKG_SECURE + 13;
  ERR_SECURE_NOUSERINFO = PKG_SECURE + 14;
  ERR_SECURE_INVTICKET = PKG_SECURE + 15;
  ERR_SECURE_FRAUD = PKG_SECURE + 16;
  ERR_SECURE_UNAUTH = PKG_SECURE + 17;
  ERR_SECURE_FAILED_AUTH = PKG_SECURE + 18;
  ERR_SECURE_TOO_MANY_PWDS = PKG_SECURE + 19;
  ERR_SECURE_ZERO_PWDS = PKG_SECURE + 20;
  ERR_SECURE_MAX_PWDS = PKG_SECURE + 21;
  ERR_SECURE_OLDAUTHVERSION = PKG_SECURE + 22;
  ERR_SECURE_NOTRUSTED_CLIENTCERT = PKG_SECURE + 23;
  ERR_SECURE_NOTRUSTED_SERVERCERT = PKG_SECURE + 24;
  ERR_SECURE_BADMSGDATA = PKG_SECURE + 25;
  ERR_SECURE_ZERO_LENGTH_PW = PKG_SECURE + 26;
  ERR_SECURE_SHORTMSG = PKG_SECURE + 27;

(******************************************************************************)
{ from srverr.h }
(******************************************************************************)
{  Server error definitions }

const
  ERR_SUSPEND = PKG_SERVER + 1;
  ERR_TRUE_NOERROR = PKG_SERVER + 2;
  ERR_NO_SERVER_ACCESS_PORT = PKG_SERVER + 3;
  ERR_ABSOLUTE_PATH = PKG_SERVER + 4;
  ERR_CLOSE_SESSION = PKG_SERVER + 5;
  ERR_CL_MSG_TOO_SMALL = PKG_SERVER + 6;
  RESUME = PKG_SERVER + 7;
  ERR_PROTOCOL = PKG_SERVER + 8;
  ERR_AMBIGUOUS = PKG_SERVER + 9;
  ERR_UNKNOWN_SVCTYPE = PKG_SERVER + 10;
  ERR_VALUE = PKG_SERVER + 11;
  ERR_VERSION_MISMATCH = PKG_SERVER + 12;
  ERR_SRV_NO_SUCH_TASK = PKG_SERVER + 13;
  ERR_INV_PRIORITY = PKG_SERVER + 14;
  ERR_INV_SCHED_STATE = PKG_SERVER + 15;
  ERR_VAR_BLOCK_ALLOC = PKG_SERVER + 16;
  ERR_INSUFF_ARGUMENTS = PKG_SERVER + 17;
  ERR_RUNNING_TASK = PKG_SERVER + 18;
  ERR_NOMATCH = PKG_SERVER + 19;
  ERR_NO_MORE = PKG_SERVER + 20;
  ERR_NEED_SEND_BFR = PKG_SERVER + 21;
  ERR_NEED_RCV_BFR = PKG_SERVER + 22;
  ERR_NO_OPEN_DB = PKG_SERVER + 23;
  ERR_FUNC_NOT_IMPL = PKG_SERVER + 24;
  ERR_BFR_MGMT = PKG_SERVER + 25;
  ERR_PROGRAM_DIR = PKG_SERVER + 26;
  ERR_TASK_REMAINING = PKG_SERVER + 27;
  ERR_SVC_IN_USE = PKG_SERVER + 28;
  ERR_FT_TOO_BUSY = PKG_SERVER + 29;
  ERR_NO_OPEN_COLLECTION = PKG_SERVER + 30;
  ERR_SUBPGM_TERM = PKG_SERVER + 31;
  ERR_WAIT_FOR_RQST = PKG_SERVER + 32;
  ERR_CONTINUE = PKG_SERVER + 33;
  ERR_CONNECT_TO_SERVER = PKG_SERVER + 34;
  ERR_OPEN_SESSION = PKG_SERVER + 35;
  ERR_WAIT_EXTERNAL_EVENT = PKG_SERVER + 36;
  ERR_SAME_LICENSE = PKG_SERVER + 37;
  ERR_COMPLETED = PKG_SERVER + 38;
  ERR_YIELD_NEED_SEND_BFR = PKG_SERVER + 39;
  ERR_LICENSE_INVALID = PKG_SERVER + 40;
  ERR_LICENSE_IN_USE = PKG_SERVER + 41;
  ERR_TASK_NOT_FOUND = PKG_SERVER + 42;
  ERR_CANNOT_MULTISERVER = PKG_SERVER + 43;
  ERR_TASK_RUNNING = PKG_SERVER + 44;
  ERR_UNKNOWN_REQUEST = PKG_SERVER + 45;
  ERR_NO_SERVER_ACCESS = PKG_SERVER + 46;
  ERR_SERVER_RUNNING = PKG_SERVER + 47;
  ERR_STARTING_SERVER = PKG_SERVER + 48;
  ERR_WAIT_NETIO = PKG_SERVER + 49;
  ERR_FINAL_WAIT_NETIO = PKG_SERVER + 50;
  ERR_FUNCTION_COMPLETE = PKG_SERVER + 51;
  ERR_PARTITIONSERVER_RUNNING = PKG_SERVER + 52;
  ERR_SERVER_BUG = PKG_SERVER + 53;
  ERR_NOT_ON_MSDOS = PKG_SERVER + 54;
  ERR_TITLE = PKG_SERVER + 55;
  ERR_NO_SERVER_NAME = PKG_SERVER + 56;
  ERR_NO_NETWORK_NAME = PKG_SERVER + 57;
  ERR_FIXUP_BEGIN = PKG_SERVER + 58;
  ERR_FIXUP_END = PKG_SERVER + 59;
  ERR_TOO_MANY_TASKS_DE = PKG_SERVER + 60;
  ERR_CMD_LINE_TOO_LONG = PKG_SERVER + 61;

  ERR_EM_CONTINUE = PKG_NSF+213;

(******************************************************************************)
(******************************************************************************)
implementation
uses Class_LotusNotes, Util_LnAPI;

// Changed by Bernd (be@svd-online.com)
procedure CheckError(Error: word);
const
  ERR_MASK = $3fff;
var
  s: string;
begin
  if Error<>0 then begin
    setLength(S,254);
    Error := Error and ERR_MASK;
    OSLoadString(0, Error, PChar(S), 254);
    s := Lmbcs2Native(StrPas(PChar(S)));
    if s = '' then s := 'General Notes Error';
    raise ELotusNotes.CreateErr (Error, 'Error $' + intToHex (Error, 4) + ':' + s);
  end;
end;


end.
