{==============================================================================|
| Project : Notes/Delphi class library                           | 3.7         |
|==============================================================================|
| Content:                                                                     |
|==============================================================================|
| The contents of this file are subject to the Mozilla Public License Ver. 1.0 |
| (the "License"); you may not use this file except in compliance with the     |
| License. You may obtain a copy of the License at http://www.mozilla.org/MPL/ |
|                                                                              |
| Software distributed under the License is distributed on an "AS IS" basis,   |
| WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for |
| the specific language governing rights and limitations under the License.    |
|==============================================================================|
| Initial Developers of the Original Code are:                                 |
|   Sergey Kolchin (Russia) skolchin@usa.net ICQ#2292387                       |
|   Sergey Kucherov (Russia)                                                   |
|   Sergey Okorochkov (Russia)                                                 |
| All Rights Reserved.                                                         |
|   Last Modified:                                                             |
|     12.10.99, Sergey Kolchin                                                 |
|==============================================================================|
| Contributors and Bug Corrections:                                            |
|   Fujio Kurose                                                               |
|   Noah Silva                                                                 |
|   Tibor Egressi                                                              |
|   Andreas Pape                                                               |
|   Anatoly Ivkov                                                              |
|   Winalot                                                                    |
|     and others...                                                            |
|==============================================================================|
| History: see README.TXT                                                      |
|==============================================================================|
| This unit contains Open Mailbox dialog and OpenMailbox function              |
|  used to open mailbox valid for the current user                             |
|==============================================================================|}
unit Form_OpenMail;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Class_LotusNotes, Form_LnBrowse;

const
  REGISTRY_PATH: string = 'Software\Kol\LNDelphi';  //of HKLM
   
type
  TOpenMailboxDlg = class(TForm)
    Label1: TLabel;
    eIDFile: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    eServer: TEdit;
    ePath: TEdit;
    Bevel1: TBevel;
    BtOk: TButton;
    BtCancel: TButton;
    BtBrowse: TButton;
    Bevel2: TBevel;
    procedure BtBrowseClick(Sender: TObject);
  end;

var
  OpenMailboxDlg: TOpenMailboxDlg;

function OpenMailbox: TNotesDatabase;
// This function returns opened mailbox valid for the current user

implementation
uses Util_LnApi, Registry;

{$R *.DFM}
var
  MailboxDb: TNotesDatabase;

function OpenMailbox: TNotesDatabase;
var
  origId, id, mail, UserName, sServer, sPath: string;
  Reg: TRegistry;

function CheckOpen (const sServer, sPath: string): TNotesDatabase;
begin
  Result := nil;
  try
    MailboxDb.Open (sServer, sPath);
    Result := MailboxDB;                                     
  except
    on E: ELotusNotes do begin
      if E.ErrorCode <= 0 then Abort //user break
      else if E.ErrorCode = 16643 then begin
        // Cannot find file
        MessageDlg ('Cannot open database ' + CombineLnPath(sServer,sPath), mtError, [mbOk], 0);
      end
      else if E.ErrorCode = 582 then begin
        // Access denied
        MessageDlg ('Access to database ' + CombineLnPath(sServer,sPath) + ' is denied', mtError, [mbOk], 0);
      end
      else raise;
    end
    else raise;
  end;
end;

begin
  Result := nil;
  MailboxDb := TNotesDatabase.create;
  try
    // get ID file name
    origId := '';
    setLength (origID, MAXENVVALUE + 1);
    OSGetEnvironmentString ('KeyFilename', pchar(origID), MAXENVVALUE);
    origID := strPas(pchar(origId));
    if origID = '' then origID := changeFileExt (extractFileName (MailboxDb.MailFileName), '.id');

    // Check
    UserName := MailboxDb.UserName;
    mail := changeFileExt (extractFileName(MailboxDb.MailFileName), '');
    id := changeFileExt (extractFileName(origId), '');
 //   Changed by Igor (FileName->MailFileName).
 //   if compareText (mail, id) = 0 then Result := CheckOpen (MailboxDb.MailServer, MailboxDb.FileName);
    if compareText (mail, id) = 0 then Result := CheckOpen (MailboxDb.MailServer, MailboxDb.MailFileName);
    if Result = nil then begin
      // Don't match or cannot open, check registry
      Reg := TRegistry.create;
      try
        Reg.RootKey := HKEY_LOCAL_MACHINE;
        Reg.OpenKey (REGISTRY_PATH, True);
        if Reg.ValueExists (UserName) then begin
          // value exists, check it
          ParseLnPath (Reg.ReadString (UserName), sServer, sPath);
          Result := CheckOpen (sServer, sPath);
        end;

        if Result = nil then begin
          // Value not found or error occurred, bring up the form
          OpenMailboxDlg := TOpenMailboxDlg.create (nil);
          with OpenMailboxDlg do try
            eIdFile.text := origId;
            eServer.text := MailboxDb.MailServer;
            ePath.text := 'mail\' + id;
            while Result = nil do begin
              showModal;
              if modalResult <> mrOk then Abort;
              Result := checkOpen (eServer.text, ePath.text);
            end;

            // Save value for future reference
            Reg.WriteString (UserName, CombineLnPath(eServer.text, ePath.text));
          finally
            OpenMailboxDlg.free;
          end;
        end;
      finally
        Reg.free;
      end;
    end;
    if Result = nil then MailboxDb.free;
  except
    on E: Exception do begin
      MailboxDb.free;
      if not (E is EAbort) then raise;
    end;
  end;
end;

procedure TOpenMailboxDlg.BtBrowseClick(Sender: TObject);
var
  sServer, sPath: string;
begin
  sServer := eServer.text;
  sPath := '';
  if LnBrowse ('', sServer, sPath) then begin
    eServer.text := sServer;
    ePath.text := sPath;
  end;
end;

end.
