unit LinkLbl;

interface

uses StdCtrls, Classes, Graphics, Messages, SysUtils, Controls, ShellAPI, Windows, Forms;

const
  clVisited=clPurple;
  clUnvisited=clBlue;

type

  TLinkLabel = class(TLabel)
  private
    FAutoColors : Boolean;
    FHREF : String;
    FVisited : Boolean;
    FColorUnvisited : TColor;
    FColorVisited : TColor;
    procedure WMClick(var Msg : TMessage); message WM_LBUTTONDOWN;
  protected
    procedure SetAutoColors(AutoCol : Boolean);
    procedure SetColorUnvisited(Col : TColor);
    procedure SetColorVisited(Col : TColor);
    procedure SetVisited(Vis : Boolean);
  public
    constructor Create(AOwner : TComponent); override;
    procedure ChangeColors; virtual;
  published
    property AutoColors : Boolean read FAutoColors write SetAutoColors default True;
    property ColorUnvisited : TColor read FColorUnvisited write SetColorUnvisited default clUnvisited;
    property ColorVisited : TColor read FColorVisited write SetColorVisited default clVisited;
    property HREF : String read FHREF write FHREF;
    property Visited : Boolean read FVisited write SetVisited;
  end;

procedure Register;

implementation

constructor TLinkLabel.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  Visited:=False;
  AutoColors:=True;
  HREF:='http://';
  ColorUnvisited:=clUnvisited;
  ColorVisited:=clVisited;
  Font.Style:=[fsUnderline];
  Cursor:=crHandPoint;
end;

procedure TLinkLabel.ChangeColors;
begin
  if FAutoColors then
    if FVisited then Font.Color:=clVisited else Font.Color:=clUnvisited
  else
    if FVisited then Font.Color:=FColorVisited else Font.Color:=FColorUnvisited
end;

procedure TLinkLabel.SetAutoColors(AutoCol : Boolean);
begin
  if AutoCol<>FAutoColors then begin
    FAutoColors:=AutoCol;
    ChangeColors;
  end;
end;

procedure TLinkLabel.SetColorUnvisited(Col : TColor);
begin
  if FColorUnvisited<>Col then begin
    FColorUnvisited:=Col;
    if not FAutoColors then ChangeColors;
  end;
end;

procedure TLinkLabel.SetColorVisited(Col : TColor);
begin
  if FColorVisited<>Col then begin
    FColorVisited:=Col;
    if not FAutoColors then ChangeColors;
  end;
end;

procedure TLinkLabel.SetVisited(Vis : Boolean);
begin
  if FVisited<>Vis then begin
    FVisited:=Vis;
    ChangeColors;
  end;
end;

procedure TLinkLabel.WMClick(var Msg : TMessage);
begin
  inherited;
  ShellExecute(0, 'open', PChar(FHREF), '', '', SW_SHOW);
end;

procedure Register;
begin
  RegisterComponents('Additional', [TLinkLabel]);
end;

end.
