{*******************************************************}
{                                                       }
{         KAZ JPEG Comment Unit 1.0                     }
{                                                       }
{         Copyright (c) 2001 by KAZ                     }
{                                                       }
{*******************************************************}

{
This is an easy to use JPEG comment unit (for JPG files).
Use this unit for comment a JPG picture. This code is free, but if
you like this, please drop me a mail.

Copyright: Kovacs Attila Zoltan
Hungary

kaz@freemail.hu
szarvasp@freeweb.hu
}

unit uJPEGComment;

interface

uses SysUtils;

function ReadComment(const FileName: string): string;
function ReadCommentAndSize(const FileName: string; var Width, Height: Integer): string;
procedure WriteComment(const FileName: string; Comment: string);

type
  EInvalidJPGFormat = class(Exception)
  end;

resourcestring
  SInvalidJPGFile = '%s is not a valid JPG file, or unknown JPG format';

implementation

uses Windows, Classes;

{ TMyFileStream }

type
  TMyFileStream = class(TFileStream)
  private
    function GetEof: Boolean;
  public
    function ReadByte: Byte;
    function ReadWord: Word;
    function ReadString(const StrSize: Integer): string;
    property Eof: Boolean read GetEof;
  end;

function TMyFileStream.GetEof: Boolean;
begin
  Result:=Position>=Size;
end;

function TMyFileStream.ReadByte: Byte;
begin
  ReadBuffer(Result, sizeof(Result));
end;

function TMyFileStream.ReadWord: Word;
begin
  Result:=ReadByte shl 8 + ReadByte;
end;

function TMyFileStream.ReadString(const StrSize: Integer): string;
begin
  SetLength(Result, StrSize);
  ReadBuffer(PChar(Result)^, Length(Result));
end;


{ TMyMemoryStream }

type
  TMyMemoryStream = class(TMemoryStream)
  public
    function WriteByte(const Value: Byte): Byte;
    function WriteWord(const Value: Word): Word;
    procedure WriteString(const Str: string);
    procedure CopyFromStream(S: TStream; Size: Integer);
  end;

function TMyMemoryStream.WriteByte(const Value: Byte): Byte;
begin
  WriteBuffer(Value, sizeof(Value));
  Result:=Value;
end;

function TMyMemoryStream.WriteWord(const Value: Word): Word;
begin
  WriteByte((Value shr 8) and $FF);
  WriteByte(Value and $FF);
  Result:=Value;
end;

procedure TMyMemoryStream.WriteString(const Str: string);
begin
  WriteBuffer(PChar(Str)^, Length(Str));
end;

procedure TMyMemoryStream.CopyFromStream(S: TStream; Size: Integer);
begin
  if Self.Size<Position+Size then
    SetSize(Position+Size);
  S.ReadBuffer(PChar(Memory)[Position], Size);
  Position:=Position+Size;
end;


function ReadComment(const FileName: string): string;
var
  Width, Height: Integer;
begin
  Result:=ReadCommentAndSize(FileName, Width, Height);
end;

function ReadCommentAndSize(const FileName: string; var Width, Height: Integer): string;
var
  FS: TMyFileStream;
  SegmentType: Byte;
  SegmentLen: Word;
  NewPos: Integer;
begin
  Result:='';
  Width:=0; Height:=0;
  FS:=TMyFileStream.Create(FileName,fmOpenRead or fmShareDenyWrite);
  try
    FS.Position:=2; // skip FF D8
    repeat
      if FS.ReadByte<>$FF then
        raise EInvalidJPGFormat.CreateFmt(SInvalidJPGFile, [FileName]);
      SegmentType:=FS.ReadByte;
      SegmentLen:=FS.ReadWord;
      if SegmentType=$FE then begin // comment
        Result:=FS.ReadString(SegmentLen-2);
      end
      else if (SegmentType=$C0) and (SegmentLen>8) then begin // size
        NewPos:=FS.Position+SegmentLen-2;
        FS.Seek(1, soFromCurrent); // skip data precision
        Height:=FS.ReadWord;
        Width:=FS.ReadWord;
        FS.Position:=NewPos;
      end
      else
        FS.Seek(SegmentLen-2, soFromCurrent); // skip segment
    until FS.Eof or (SegmentType=$DA); // it shoud work
  finally
    FS.Free;
  end;
end;

procedure WriteComment(const FileName: string; Comment: string);
var
  FS: TMyFileStream;
  SegmentType: Byte;
  SegmentLen: Word;
  MemStream: TMyMemoryStream;
  Written: Boolean;
  CT, LAT, LWT: TFileTime;
begin
  if Length(Comment)>65530 then
    SetLength(Comment, 65530);
  Written:=False;
  FS:=TMyFileStream.Create(FileName,fmOpenReadWrite	or fmShareDenyWrite);
  MemStream:=TMyMemoryStream.Create;
  try
    Win32Check(GetFileTime(FS.Handle, @CT, @LAT, @LWT));
    MemStream.Size:=FS.Size; // allocate memory
    MemStream.CopyFromStream(FS, 2); // skip FF D8
    repeat
      if MemStream.WriteByte(FS.ReadByte)<>$FF then
        raise EInvalidJPGFormat.CreateFmt(SInvalidJPGFile, [FileName]);
      SegmentType:=FS.ReadByte;
      SegmentLen:=FS.ReadWord;
      if ((SegmentType=$FE) or ((SegmentType and $F0)=$C0)) and not Written and (Comment<>'') then begin
        MemStream.WriteByte($FE);
        MemStream.WriteWord(Length(Comment)+2);
        MemStream.WriteString(Comment);
        MemStream.WriteByte($FF);
        Written:=True;
      end;
      if SegmentType=$FE then begin // Comment
        FS.Seek(SegmentLen-2, soFromCurrent); // skip
        MemStream.Position:=MemStream.Position-1; // go back
      end
      else begin
        MemStream.WriteByte(SegmentType);
        MemStream.WriteWord(SegmentLen);
        MemStream.CopyFromStream(FS, SegmentLen-2);
      end;
    until FS.Eof or (SegmentType=$DA);
    MemStream.CopyFromStream(FS, FS.Size-FS.Position);
    MemStream.SetSize(MemStream.Position); // truncate
    FS.SetSize(MemStream.Size);
    FS.Position:=0;
    MemStream.Position:=0;
    MemStream.SaveToStream(FS);
    Win32Check(SetFileTime(FS.Handle, @CT, @LAT, @LWT));
  finally
    MemStream.Free;
    FS.Free;
  end;
end;

end.
