unit kb_test_form;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, kambutton;

type
  TForm1 = class(TForm)
    KamButton1: TKamButton;
    KamButton2: TKamButton;
    KamButton3: TKamButton;
    KamButton4: TKamButton;
    Bevel1: TBevel;
    GroupBox1: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    CheckBox1: TCheckBox;
    GroupBox2: TGroupBox;
    bt_ch_color: TKamButton;
    bt_ch_text: TKamButton;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    bt_ch_parent: TKamButton;
    bt_ch_hot: TKamButton;
    bt_ch_hottext: TKamButton;
    bt_reset: TKamButton;
    bt_exit: TKamButton;
    Label1: TLabel;
    ColorDialog1: TColorDialog;
    Label2: TLabel;
    procedure bt_exitClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure KamButton1Click(Sender: TObject);
    procedure bt_ch_colorClick(Sender: TObject);
    procedure bt_ch_textClick(Sender: TObject);
    procedure bt_ch_parentClick(Sender: TObject);
    procedure bt_ch_hotClick(Sender: TObject);
    procedure bt_ch_hottextClick(Sender: TObject);
    procedure bt_resetClick(Sender: TObject);
  private
    bEasy: boolean;
    procedure SetValues(Target: TKamButton);
    procedure GetValues(Source: TKamButton);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.GetValues(Source: TKamButton);
begin
  bEasy:= true;
  with Source do
    begin
      RadioButton1.checked:= KamStyle= kbsNormal;
      RadioButton2.checked:= KamStyle= kbsFramed;
      RadioButton3.checked:= KamStyle= kbsFlat;
      RadioButton4.checked:= KamStyle= kbsCorel;
      CheckBox1.checked:= ShowDefaultMarker;
      CheckBox2.checked:= WordWrap;
      CheckBox3.checked:= ParentColor;
    end;
  bEasy:= false;
end;

procedure TForm1.SetValues(Target: TKamButton);
begin
  if not bEasy then
    with Target do
      begin
        if RadioButton1.checked then KamStyle:= kbsNormal;
        if RadioButton2.checked then KamStyle:= kbsFramed;
        if RadioButton3.checked then KamStyle:= kbsFlat;
        if RadioButton4.checked then KamStyle:= kbsCorel;
        ShowDefaultMarker:= CheckBox1.checked;
        WordWrap:= CheckBox2.checked;
        ParentColor:= CheckBox3.checked;
      end;
end;

procedure TForm1.bt_exitClick(Sender: TObject);
begin
 Close;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  SetValues(KamButton1);
  SetValues(KamButton2);
  SetValues(KamButton3);
  SetValues(KamButton4);
  GetValues(KamButton1);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  GetValues(KamButton1);
end;

procedure TForm1.KamButton1Click(Sender: TObject);
begin
  caption:= 'last clicked: '+(sender as TControl).name;
end;

procedure TForm1.bt_ch_colorClick(Sender: TObject);
begin
  ColorDialog1.Color:= KamButton1.Color;
  if ColorDialog1.Execute then
    begin
      KamButton1.Color:= ColorDialog1.Color;
      KamButton2.Color:= ColorDialog1.Color;
      KamButton3.Color:= ColorDialog1.Color;
      KamButton4.Color:= ColorDialog1.Color;
    end;
  GetValues(KamButton1);
end;

procedure TForm1.bt_ch_textClick(Sender: TObject);
begin
  ColorDialog1.Color:= KamButton1.Font.Color;
  if ColorDialog1.Execute then
    begin
      KamButton1.Font.Color:= ColorDialog1.Color;
      KamButton2.Font.Color:= ColorDialog1.Color;
      KamButton3.Font.Color:= ColorDialog1.Color;
      KamButton4.Font.Color:= ColorDialog1.Color;
    end;
  GetValues(KamButton1);
end;

procedure TForm1.bt_ch_parentClick(Sender: TObject);
begin
  ColorDialog1.Color:= Color;
  if ColorDialog1.Execute then
    Color:= ColorDialog1.Color;
end;

procedure TForm1.bt_ch_hotClick(Sender: TObject);
begin
  ColorDialog1.Color:= KamButton1.HotColor;
  if ColorDialog1.Execute then
    begin
      KamButton1.HotColor:= ColorDialog1.Color;
      KamButton2.HotColor:= ColorDialog1.Color;
      KamButton3.HotColor:= ColorDialog1.Color;
      KamButton4.HotColor:= ColorDialog1.Color;
    end;
  GetValues(KamButton1);
end;

procedure TForm1.bt_ch_hottextClick(Sender: TObject);
begin
  ColorDialog1.Color:= KamButton1.HotTextColor;
  if ColorDialog1.Execute then
    begin
      KamButton1.HotTextColor:= ColorDialog1.Color;
      KamButton2.HotTextColor:= ColorDialog1.Color;
      KamButton3.HotTextColor:= ColorDialog1.Color;
      KamButton4.HotTextColor:= ColorDialog1.Color;
    end;
  GetValues(KamButton1);
end;

procedure TForm1.bt_resetClick(Sender: TObject);
begin
  with KamButton1 do
    begin
      KamStyle:= kbsNormal;
      ShowDefaultMarker:= true;
      WordWrap:= true;
      ParentColor:= true;
    end;
  Color:= clBtnFace;
  GetValues(KamButton1);
  CheckBox1Click(self);
end;

end.
