unit KADaoDBColumnCheckListBox;
{$I KADaoControlsCommonDirectives.pas}
interface

uses
  Windows, Messages, SysUtils, Classes, DB, DBCtrls, CheckLst, Dialogs;

type
  TKADaoDBColumnCheckListBox = class(TCheckListBox)
  private
    { Private declarations }
    F_DataLink       : TFieldDataLink;
    F_InGetting      : Boolean;
    F_Unique         : Boolean;
    F_GetData        : Boolean;
    F_AutoPost       : Boolean;
    F_ReadOnly       : Boolean;
    Procedure          DataChange(Sender: TObject);
    Procedure          UpdateData(Sender: TObject);
    Procedure          EditingChange(Sender: TObject);
    Procedure          ActiveChange(Sender: TObject);
    Procedure          FillData;
  protected
    { Protected declarations }
    Function    F_Get_DataField: string;
    Procedure   F_Set_DataField(const Value: string);
    Function    F_Get_DataSource: TDataSource;
    Procedure   F_Set_DataSource(Value: TDataSource);
    Procedure   F_Set_Unique(Value: Boolean);
    Procedure   Notification(AComponent: TComponent; Operation: TOperation); override;
    Procedure   Click; override;
    Procedure   Loaded; override;
  public
    { Public declarations }
    Constructor Create(AOwner: TComponent);override;
    Destructor  Destroy;override;
  published
    { Published declarations }
    Property    AutoPost          : Boolean     Read F_AutoPost       Write F_AutoPost;
    Property    DataField         : String      Read F_Get_DataField  Write F_Set_DataField;
    Property    DataSource        : TDataSource Read F_Get_DataSource Write F_Set_DataSource;
    Property    ReadOnly          : Boolean     Read F_ReadOnly       Write F_ReadOnly;
    Property    UniqueDataOnly    : Boolean     Read F_Unique         Write F_Set_Unique;
  end;

procedure Register;

implementation

Constructor TKADaoDBColumnCheckListBox.Create(AOwner: TComponent);
Begin
  inherited Create(AOwner);
  F_AutoPost                 := False;
  F_ReadOnly                 := False;
  F_InGetting                := False;
  F_GetData                  := True;
  F_Unique                   := False;
  F_DataLink                 := TFieldDataLink.Create;
  F_DataLink.Control         := Self;
  F_DataLink.OnDataChange    := DataChange;
  F_DataLink.OnEditingChange := EditingChange;
  F_DataLink.OnUpdateData    := UpdateData;
  F_DataLink.OnActiveChange  := ActiveChange;
End;

Destructor TKADaoDBColumnCheckListBox.Destroy;
Begin
 F_DataLink.Free;
 F_DataLink := nil;
 inherited Destroy;
End;

procedure TKADaoDBColumnCheckListBox.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (F_DataLink <> nil) and (AComponent = DataSource) then
      Begin
        DataSource := nil;
      End;
end;


Procedure TKADaoDBColumnCheckListBox.Click;
Begin
  Inherited Click;
  If  (Assigned(F_DataLink.DataSource))
  And (F_DataLink.Active)
  And (F_DataLink.FieldName<> '')
  And (NOT F_InGetting)
  And (Assigned(F_DataLink.Field))
  And (NOT F_DataLink.Field.IsBlob)
  And (NOT F_UNIQUE)
  And (F_ReadOnly) Then
      Begin
        if ItemIndex > -1 Then F_DataLink.Dataset.RecNo := ItemIndex+1;
      End;
  //********************************************************* READ ONLY STATE!!!
  If  (Assigned(F_DataLink.DataSource))
  And (F_DataLink.Active)
  And (F_DataLink.FieldName<> '')
  And (NOT F_InGetting)
  And (Assigned(F_DataLink.Field))
  And (NOT F_DataLink.Field.IsBlob)
  And (NOT F_UNIQUE) Then
      Begin
        if ItemIndex > -1 Then F_DataLink.Dataset.RecNo := ItemIndex+1;
      End;
  Exit;
  //****************************************************************************
  If  (Assigned(F_DataLink.DataSource))
  And (F_DataLink.Active)
  And (F_DataLink.FieldName<> '')
  And (NOT F_InGetting)
  And (Assigned(F_DataLink.Field))
  And (NOT F_DataLink.Field.IsBlob)
  And (NOT F_ReadOnly)
  And (F_DataLink.CanModify)
  And (F_DataLink.Edit)  Then
      Begin
       F_DataLink.Modified;
       F_DataLink.UpdateRecord;
       if F_AutoPost Then F_DataLink.DataSet.Post;
      End;
End;


Procedure TKADaoDBColumnCheckListBox.Loaded;
Begin
 Inherited Loaded;
 Items.Clear;
End;

Procedure TKADaoDBColumnCheckListBox.FillData;
Var
  BK : TBookmarkStr;
  S  : String;
Begin
  If  (Assigned(F_DataLink.DataSource))
  And (F_DataLink.Active)
  And (F_DataLink.FieldName<> '')
  And (F_DataLink.DataSet.State=dsBrowse)
  And (NOT F_DataLink.DataSet.IsEmpty)
  And (NOT F_InGetting)
  And (Assigned(F_DataLink.Field))
  And (NOT F_DataLink.Field.IsBlob) Then
      Begin
        F_InGetting := True;
        BK := F_DataLink.DataSet.Bookmark;
        F_DataLink.DataSet.DisableControls;
        Try
         Items.Clear;
         F_DataLink.DataSet.First;
         While NOT F_DataLink.DataSet.EOF do
           Begin
             S := F_DataLink.DataSet.FieldByName(F_DataLink.FieldName).AsString;
             if F_Unique Then
                Begin
                  if Items.IndexOf(S) = -1 Then Items.Add(S);
                End
             Else
                Begin
                  Items.Add(S);
                End;
             F_DataLink.DataSet.Next;
           End;
        Finally
          F_DataLink.DataSet.Bookmark := BK;
          F_DataLink.DataSet.EnableControls;
          F_InGetting := False;
          F_GetData   := False;
        End;
      End;
End;

Procedure TKADaoDBColumnCheckListBox.ActiveChange(Sender: TObject);
Begin
  if  Assigned(DataSource)
  And Assigned(DataSource.Dataset)
  And (DataSource.DataSet.Active) Then
      Begin
        Enabled := True;
      End
  Else
      Begin
        Items.Clear;
        Enabled := False;
        F_GetData := True;
      End;
End;

Procedure TKADaoDBColumnCheckListBox.DataChange(Sender: TObject);
Var
 S  : String;
Begin
  If  (Assigned(F_DataLink.DataSource))
  And (F_DataLink.Active)
  And (F_DataLink.FieldName<> '')
  And (NOT F_InGetting)
  And (Assigned(F_DataLink.Field))
  And (NOT F_DataLink.Field.IsBlob)
  And (F_DataLink.Dataset.State = dsBrowse) Then
      Begin
       if F_GetData Then
          Begin
           FillData;
          End;
       S := F_DataLink.DataSet.FieldByName(F_DataLink.FieldName).AsString;
       if F_Unique Then
          ItemIndex := Items.IndexOf(S)
       Else
          ItemIndex := F_DataLink.Dataset.RecNo-1;
      End;
End;

Procedure TKADaoDBColumnCheckListBox.UpdateData(Sender: TObject);
Var
  S : String;
Begin
  If  (Assigned(F_DataLink.DataSource))
  And (F_DataLink.Active)
  And (F_DataLink.FieldName<> '')
  And (NOT F_InGetting)
  And (Assigned(F_DataLink.Field))
  And (NOT F_DataLink.Field.IsBlob)
  And (F_DataLink.CanModify) Then
      Begin
       S := Items.Strings[ItemIndex];
       F_DataLink.Dataset.FieldByName(F_DataLink.FieldName).AsString := S;
      End;
End;

Procedure TKADaoDBColumnCheckListBox.EditingChange(Sender: TObject);
Begin
  F_GetData := True;
End;

Function TKADaoDBColumnCheckListBox.F_Get_DataSource: TDataSource;
begin
  Result := F_DataLink.DataSource;
end;

Procedure TKADaoDBColumnCheckListBox.F_Set_DataSource(Value: TDataSource);
begin
  F_GetData := True;
  F_DataLink.DataSource := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

Procedure TKADaoDBColumnCheckListBox.F_Set_Unique(Value: Boolean);
Begin
 F_Unique := Value;
 Items.Clear;
 F_GetData := True;
 DataChange(Self);
End;

Function TKADaoDBColumnCheckListBox.F_Get_DataField: string;
begin
  Result := F_DataLink.FieldName;
end;

Procedure TKADaoDBColumnCheckListBox.F_Set_DataField(const Value: string);
begin
  F_GetData := True;
  F_DataLink.FieldName := Value;
end;


procedure Register;
begin
  RegisterComponents('KADao Controls', [TKADaoDBColumnCheckListBox]);
end;

end.
