unit KADaoIndexesListBox;
{$I KADaoControlsCommonDirectives.pas}
interface

uses
  Windows, Messages, SysUtils, Classes, DB, DBCtrls, StdCtrls, KDaoDatabase, KDaoTable, DaoApi, Dialogs;

type
  TKADaoIndexesListBox = class(TListBox)
  private
    { Private declarations }
    F_DataLink       : TFieldDataLink;
    F_InGetting      : Boolean;
    F_Reopen         : Boolean;
    F_AutoOpen       : Boolean;
    Procedure          ActiveChange(Sender: TObject);
  protected
    { Protected declarations }
    Function    F_Get_DataSource: TDataSource;
    Procedure   F_Set_DataSource(Value: TDataSource);
    Procedure   F_Set_AutoOpen(Value: Boolean);
    Procedure   Notification(AComponent: TComponent; Operation: TOperation); override;
    Procedure   Loaded; override;
    Procedure   Click; override;
  public
    { Public declarations }
    Constructor Create(AOwner: TComponent);override;
    Destructor  Destroy;override;
  published
    { Published declarations }
    Property    AutoOpen          : Boolean     Read F_AutoOpen        Write F_Set_AutoOpen;
    Property    DataSource        : TDataSource  Read F_Get_DataSource Write F_Set_DataSource;
    Property    Reopen            : Boolean     Read F_Reopen          Write F_Reopen;
  end;

procedure Register;

implementation

Constructor TKADaoIndexesListBox.Create(AOwner: TComponent);
Begin
  inherited Create(AOwner);
  F_AutoOpen                 := True;
  F_InGetting                := False;
  F_Reopen                   := False;
  F_DataLink                 := TFieldDataLink.Create;
  F_DataLink.Control         := Self;
  F_DataLink.OnActiveChange  := ActiveChange;
End;

Destructor TKADaoIndexesListBox.Destroy;
Begin
 F_DataLink.Free;
 F_DataLink := nil;
 inherited Destroy;
End;

procedure TKADaoIndexesListBox.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (F_DataLink <> nil) and (AComponent = DataSource) then
      Begin
        DataSource := nil;
      End;
end;


Procedure TKADaoIndexesListBox.Loaded;
Begin
 Items.Clear;
End;

Procedure TKADaoIndexesListBox.Click;
Begin
  Inherited Click;
  if  Assigned(DataSource)
  And Assigned(DataSource.Dataset)
  And (DataSource.Dataset.Active)
  And (DataSource.Dataset is TKaDaoTable)
  And ((DataSource.Dataset as TKaDaoTable).TableType=DaoApi.dbOpenTable)
  And (F_AutoOpen)
  And (NOT F_InGetting) Then
      Begin
        if ItemIndex > -1 Then
           Begin
             F_InGetting := True;
             if F_Reopen Then (DataSource.Dataset as TKaDaoTable).Close;
             (DataSource.Dataset as TKaDaoTable).IndexName := Items.Strings[ItemIndex];
             if F_Reopen Then (DataSource.Dataset as TKaDaoTable).Open;
             F_InGetting := False;
           End;
      End;
End;


Procedure TKADaoIndexesListBox.ActiveChange(Sender: TObject);                              
Var
  II  : Integer;
  Txt : String;
  T   : TStringList;
Begin
  if  Assigned(DataSource)
  And Assigned(DataSource.Dataset)
  And (DataSource.Dataset is TKaDaoTable)
  And ((DataSource.Dataset as TKaDaoTable).TableType=DaoApi.dbOpenTable)
  And (DataSource.DataSet.Active) Then
      Begin
        T  := TStringList.Create;
        Try
         (DataSource.Dataset as TKaDaoTable).GetIndexNames(T);
         Txt := T.Text;
        Finally
         T.Free;
        End;
        if Txt <> Items.Text Then Items.SetText(PChar(Txt));
        II := Items.IndexOf((DataSource.Dataset as TKaDaoTable).IndexName);
        if II <> -1 Then
           Begin
             F_InGetting := True;
             ItemIndex := II;
             F_InGetting := False;
           End;
      End;
End;

Function TKADaoIndexesListBox.F_Get_DataSource: TDataSource;
begin
  Result := F_DataLink.DataSource;
end;

Procedure TKADaoIndexesListBox.F_Set_DataSource(Value: TDataSource);
begin
  F_DataLink.DataSource := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

Procedure TKADaoIndexesListBox.F_Set_AutoOpen(Value: Boolean);
Begin
 F_AutoOpen := Value;
 Items.Clear;
 ActiveChange(Self);
End;

procedure Register;
begin
  RegisterComponents('KADao Controls', [TKADaoIndexesListBox]);
end;

end.
