unit KDaoTable;
{$B-}
//******************************************************************************
//                         Delphi Dao Project
//                 Copyright (c) 2000 by Kiril Antonov
//******************************************************************************
{$DEFINE USEPARAMS}           //  Active only in Delphi 5
{$I CommonDirectives.pas}
//******************************* CHANGES **************************************
// 28.05.2000 - Fixed a minor bug which raises exception when
//              getting GetQueryDefSQLText
// 28.05.2000 - Added FieldChanged TList - each item corresponds to a field                        
//              in the record
//              If  Boolean(FieldChanged[X]) is true then when posting data this
//              field is updated
//              This prevents from writing bak entire record to the database -
//              only changed fields are posted.
// 28.05.2000 - Added new property editor for SortedBy property which allows an
//              easy method to define sort order of a Table/Query
//              A new property SortedByText gives low level access to the
//              SortedBy property
// 28.05.2000 - Added new property editor for QueryDefParameters property which                        
//              allows an easy method to enter parameters to QUERYDEF dao object
//              A new property QueryDefParametersText gives low level access to
//              the QueryDefParameters property
// 30.05.2000 - Fixed a bug in GetRecNo which gives some troubles with DBGrids
//
// 31.05.2000 - Changed InternalSetToRecord method to speedup positioning inside
//              a table
//
// 01.06.2000 - Created Master/Detail Relationship support with property editor
//              similar to Delphi
//              A few new properties are anounced:
//                - MasterSource : TDataSource; - DataSource of the Master Table
//                - MasterFields : TStrings;    - A StringList with
//                  relationships in the form: "DetailField -> MasterField"
// 04.06.2000 - Handled default values for fields
//
// 07.06.2000 - Handled empty fields (WITH NOT REQUITRED VALUE)
//              when posting new records to database
//
// 08.06.2000 - Added support for Dynamycally setting DAO Version
//
// 11.06.2000 - Filter is working properly now
//
// 11.06.2000 - Added FULL support for Master/Detail (Table and Query)
//
// 11.06.2000 - Changed many options for Bookmarks
//              to support Dynamic DAO (OleVariant)
//
// 11.06.2000 - Added support for Locate
//
// 11.06.2000 - Added support for Lookup
//
// 12.06.2000 - InternalGotoBookmark rewrited completely
//
// 12.06.2000 - Locate supports TLocateOptions now
//
// 12.06.2000 - Added four new methods:
//              CreateField
//              CreateIndex
//              DeleteField
//              DeleteIndex
//
// 14.06.2000 - Property Editors for Tables, QueryDefs and Indexes use
//              RefreshDefinitions to reflect changes made outside Delphi
//
// 18.06.2000 - Added another method of Locate whish is very fast but works only
//              if Table supports bookmarks
//
// 18.06.2000 - Added GetIndexNames method for Compatibility with TTable
//
// 18.06.2000 - Added FOUR New methods for fast search in a table:
//                Find_First
//                Find_Last
//                Find_Next
//                Find_Prior
//              These new methods are similar to TTable but can search on
//              NON-INDEXED fields
//              Call them as calling Locate method
// 19.06.2000 - Two new method where added  Find_Nearest and Find_NearestEx
//              Call Find_NearestEx as calling a Locate method
//              For Find_Nearest you must first call SetKeyFields method with a
//              semicolon separated Field names and then Call Find_Nearest
//              See the new demos on KADao site for full explanation
// 19.06.2000 - Added new method Seek_Nearest
//              Seek_Nearest works as Dao Seek method so you must set the index
//              in which you want to search
//              See the new demos on KADao site for full explanation
//
// 19.06.2000 - Fixed a minor bug with empty tables
//
// 19.06.2000 - Added support for OnFilterRecord event
//              GetRecordCount And GetRecNo now works as standard specifications
//              require
//
// 27.06.2000 - Added CompareBookmarks method - now multiselect in DBGrid
//              works fine
//
// 28.06.2000 - Added GetFieldNames - it receives as a parameter TStringList
//              and fills them with Names of the fields
//              Each Name has a corresponding TObject wich is an integer
//              describing a Field original DAO type (Not BDE type)
//
// 28.06.2000 - Added QueryDefODBCMaxRecords (works only on ODBC data sources)
//              to limit number of returned records
//              Setting to 0 means NO LIMIT
//
// 28.06.2000 - Added QueryDefType property - it returns a QueryDef Type
//              as a string. Original DAO value is stored in QueryDefTypeInt
//
// 28.06.2000 - Added RecordsAffected variable
//              When using  ExecSQL it teturns then number of affected records
//              and also sets RecordsAffected to the same value.
//
// 28.06.2000 - Added Requery method which is useful for refreshing dynaset
//              tables
//
// 28.06.2000 - Added Seek_NearestEx method
//              An additional parameter is SeekType (String) which can be one of
//              the following: '<', '<=', '=', '>=', '>'
//
// 28.06.2000 - Added SetRecNo internal dataset method (still in beta testing)
//
// 28.06.2000 - Added two new variables BlobOffset and BlobNumBytes
//              Whend one of this variables is different then zero
//              reading from a blob field starts from BlobOffset position
//              and the return information is BlobNumBytes in size
//              When BlobNumBytes is > of entire blob size a smaller amount
//              of bytes is returned (realized using DAO GetChunk method)
//              Warninng! This is blob wide i.e. all blobs are affected
//              So you must set them to Zero each time when the another blob
//              which must be read at all is readed from the record
//
// 28.06.2000 - Added two new read only properties TableDateCreated and
//              TableLastUpdated - works only on standart tables and QueryDefs
//
// 28.06.2000 - Added a new meton AppendToBlob - uses DAO AppendChunk method
//
// 29.06.2000 - Added a new variable QueryDefReturnParams of type OleVariant
//              It contains a results from a QueryDefRecordset
//              If result is only one QueryDefReturnParams is a single variant
//              otherwise QueryDefReturnParams is VarArray
//
// 29.06.2000 - AT LAST FIXED PROBLEM WITH EMPTY RECORDESTS - GREAT VICTORY!!!!
//
// 29.06.2000 - Removed SetRecNo internal dataset method (not yet understand)
//
//
// 03.07.2000 - Added new property UseRecordCount
//              Since DBGrid uses RecordCount Very extensivelly which can
//              slowdown database performance you can turn it off by setting
//              UseRecordCount
//
// 04.07.2000 - AT LAST FIXED PROBLEM WITH RETRIEVING ACTUAL TYPE OF
//              dbDate FIELD TYPE - NOW YOU CAN USE dbTime AND dbTimeStamp !!!
//
// 05.07.2000 - Fixed a very rediculous bug with RETRIEVING ACTUAL TYPE OF
//              dbDate FIELD. Now a ftDateTime is the default type
//              But if you set Format property in MS Acess a dbDate and dbTime
//              also is used!
// 05.07.2000 - Added additional code to DateTimeToBuffer and TimeToBuffer
//              routines to support both method of retrieving Date/Time info
//
// 05.07.2000 - Added support for Forward Only Tables - Works Good but
//              DBGrid violates forward only restrictions so use with care
//              A more complicated changes will be made in future to avoid these
//
// 17.07.2000 - Fixed a bug which does not free allocated resources in Append
//              With many thanks to Andrew Baylis for reporting the problem
//
// 19.07.2000 - Added new property UseBrackets - True by default
//              It places Field names in squire brackets "[ ]" when using
//              Locate, Lookup, and Master/Detail
//              Since squire brackets are MS Access specific turn this property
//              to FALSE when using other databases than MDB
//
// 19.07.2000 - Added support for working with part of all fields
//              I.E Field Designer is supported now
//              Not copletely tested but working
//
// 21.07.2000 - Added few new Exec Functions
//                - ExecuteSQL - Executes SQL stored in SQL Property
//                - ExecuteQueryDefSQL - Executes SQL stored selected
//                  by QueryDefName QueryDef
//
// 21.07.2000 - Added Property LockEdits for Locking Recods at runtime
//              Immediatly after you call Edit metod locking is activa
//
// 24.07.2000 - Added new method for Locating data
//              If table type is dbOpenTable and IndexName <> ''
//              then locate tryes to use selected index when searching
//              otherwise a standard search is executed
//
// 30.07.2000 - Added new property SQLExecutionType for use when executing SQL
//              by default it is DaoApi.dbFailOnError but you may use andother
//              constants like DaoApi.dbSQLPassThrough
//              (With many thanks to to Baldemaier Florian for this)
//
// 31.07.2000 - Fixed ALL problems with ACCESS Date and Time conversion
//              All Borland types i.e ftDate, ftDateTime and ftTime can be used
//              now. The magic number is 693594. Do you know why? I know!
//
// 31.07.2000 - Added new method for Find_First, Find_Next Etc..
//              if somebody encounter problems please report ...
//
// 04.08.20000 - A specific change made to Locate
//               her must be written a some special notes to use locate with
//               an index
//               Microsoft has made strange things with its Seek method
//               So to work with indexes you must create index containing ALL
//               fields you willlocate on and no EXTRA fields in this index
//               Otherwise Locate will use non index based method
//               And Microsoft's limitation is 13 fileds maximum (0..12)
//               Have a nice locating! :-)
//               P.S If somebody encounter problems please report ...
//
// 14.08.2000  - The TKBlobStream.Truncate Procedure was rewritten becouse
//               it does not clear Blob fields proprly - lets say it was doing
//               NOTHING. Now it works fine
//               With many thanks to Andrew Baylis for reporting the problem
//
//
// 14.08.2000  - Changed SetFieldData so Field.Clear to work
//               With many thanks to Andrew Baylis for reporting the problem
//
// 15.08.2000  - Added some features to speedup adding new records
//               Now a new system var F_UpdatableFields of type tlist
//               presents all records that can be updated                   
//               if Boolean(F_UpdatableFields.Items[xxx]) then field can
//               be changed
//               Also a Resync[] in Internal Post is blocked
//               P.S If somebody encounter problems please report ...
// 18.02.2000  - Added a fix to SortedbyDialogEditor to use brackets
//               With many thanks to Baldemaier Florian for reporting problem
//
// 22.08.2000  - Fixed a bug with setting LockEdits property on tables which
//               does not support Locking
//               With many thanks to Dave Zangger for reporting problem
//
// 28.08.2000  - Fixed a bug with generating SQL for Lookup, Locate etc
//               a ftSmallInt and ftWord was missing. Now included
//               Thanls to Analisis y Estudios Financieros for reporting problem
//
// 29.08.2000  - Added some code for QueryDefTimeOut and ODBCTimeOut
//
// 31.08.2000  - Added IsEmpy Checking for Locate, Lookup and Find methods
//               With many thanks to Jiri Kanda for reporting problem
//
// 07.09.2000 - GetRecNo now retuns a 1 based value not a zero bazed
//              Most of TDatasets do so - also this helps on dbGrids
//              Thanls to Jiri Kanda again
//
// 08.09.2000 - Fixed a bug in F_Set_Filtered method thanks to Oliver Hger
//
// 21.09.2000 - Fixed a strange DAO bug in QueryDefs when concatenating
//              dbText fields. Dao returns ZERO for the result field length.
//              Now this situation is handled - result size is 255!
//              Thanls to Tom Peiffer for reporting problem
//
// 21.09.2000 - Added GotoCurrent Method - same as TTable.GotoCurrent
//
// 01.10.2000 - Fixed a VERY BIG bug with RecordLocking.
//              My apologese to everybody that report problems with
//              record locking. But Borland nas NO Documentation about
//              internal TDataset routines. Now all is OK
//
// 01.10.2000 - Fixed a bug with ExecuteQueryDefSQL - it does not handle
//              QueryDefParameters but now they are supported
//              Thanls to Jiri Kanda for reporting the problem
//
// 01.10.2000 - Fixed a bug with Requery - it does not handle
//              QueryDefParameters but now they are supported
//
// 01.10.2000 - Added support for ftAutoInc
//
// 01.10.2000 - Added two new Functions
//                  - GetSourceTableName
//                  - GetSourceFieldName
//              They are very usual to find source TableName and FieldName when
//              using a result from join query and want to find which is the
//              origin of the field in join table
//
// 01.10.2000 - Added support for BookmarkValid Function
//              Note that after calling BookmarkValid current record is cahnged
//              to those pointed by passed TBookmark to BookmarkValid
//
// 01.10.2000 - Added New Function PercentPosition to get info from DAO method
//              PercentPosition. See DAO help for details
//
// 01.10.2000 - Added New Function GetRows(NumRows:Integer):OleVariant
//              This Function returns Two dimaensional variant array
//              with NumRows number of records and all fields.
//              This is a interface to DAO Method GetRows - see DAO help
//              Function positions current record at the next unread record.
//
// 02.10.2000  - Added Support for Parametrized queryes (stored in SQL property)
//               Unfortenatelly this does not work with Delphi 3.0
//               Also it is not tested with Delphi 4.0
//               If you encounter problems during compilation please UNDEFINE
//               USEPARAMS at the begining of this file.
//               Thanks to Andrew Baylis for all this.
//               Any help how to implement this on Delphi 3.0 will be
//               greatly appreciated.
//
// 02.10.2000  - Dramatically Increased speed of the following methods
//                Find_First
//                Find_Last
//                Find_Next
//                Find_Prior
//
// 02.10.2000  - Added changes for Bookmark (previously TSafeArray, now
//               OleVariant (it is Interesting that in fact bookmarks are
//               OleStrings;
//
// 02.10.2000  - Speed of Bookmark operations is Dramatically Increased
//
// 10.10.2000  - Fixed a bug in ExecSQL,ExecutSQL,ExecuteQueryDefSQL
//               Thanls to D. Gene Bland for reporting the problem
//
// 11.10.2000  - Fixed a bug in BuildXXXSQL routines
//               They now support ftAutoInc Field
//               Thanls to Paul Weaver for reporting the problem
//
// 13.10.2000  - Fixed another bug in BuildXXXSQL routines
//               Thanls to Manfred Zieglmeier for reporting the problem
//
// 13.10.2000  - Fixed a bug with OnPostError Event
//               Now OnPostError is supported
//               Thanls to Henry Martin for reporting the problem
//
// 17.10.2000  - Added eight new routines for some compatibility with TTable
//               See explanation in KADao Help docs.
//
//               Procedure FindNearest
//               Function  FindKey
//               Property  IndexFieldCount
//               Property  IndexFields
//               Procedure SetFindData
//               Procedure SetKey
//               Function  GotoKey
//               Procedure LockTable
//               Procedure UnlockTable
//               Property  IndexFieldNames
//
//******************************************************************************
//
// 25.10.2000  - Found a bug in Rollback method-table rasies 'No current record'
//               after rollback - now fixed thanks to Sergey
//
// 26.10.2000  - Twice increased the speed of reading and writing records
//               Before reconstruction KADao adds 1000 records for about 7 sec
//               Now for 3.3 seconds
//
// 30.10.2000   - Found a bug in default values processing - now fixed thanks to
//                Eric BACHMANN
//
// 31.10.2000   - Removed FieldChanged TList - now information about changed
//                fields is stored in RecordData TStringList as objects
//
// 01.11.2000   - Dramaticaly is increased speed of Master/Detail relations
//                /EXPERIMENTAL/
//
// 02.11.2000   - Added Function PromptQueryDefParameters - it brings
//                same dialog as QueryDefParameters editor in design time.
//                Thanks to Jorge Dantas
//
//******************************************************************************
//
// 06.11.2000 - Removed BlobOffset and BlobNumBytes variables for safety reasons
//              Removed method AppendToBlob for safety reasons
//
// 06.11.2000 - Found a VERY BIG bug in KADaoBlob handling
//              Bug affects only BINARY BLOBS and NOT Memos
//              It is reccomended before upgrade to this version of KADao
//              to save all your binary blobs (created with KADAO) to files
//              The proble is that Delphi coverts String to WideChar before
//              sending data to DAO so in MDB files blobs have size twice
//              bigger then normal. Thanks to Albert Molina for reporting.
//
// 12.11.2000 - Fixed a bug in DataEvent Procedure
//              Now fixed - thanks to Gianluca D'Angelo
//
// 12.11.2000 - Fixed a bug in InternalGotoBookmark and SetBookmarkString
//              Bug is present when trying to delete multiple records
//
// 14.11.2000 - Added some code to speedup opening readonly tables and queryes
//              Thanks to Simone.
//
// 14.11.2000 - Added handling of Required in InternalInitFieldDefs
//
// 14.11.2000 - Added AGAIN SetRecNo internal dataset method
//              Now works as expected - you can use KADaoTable1.RecNo:=10 and
//              cursor will position at RecordNO 10 (counting is NOT ZERO based)
//
// 15.11.2000 - Preprocessor defintion USESLOWRECORDCOUNT is removed
//              Now KADao ALWAYS handle possible RecordCount bugs in DAO
//
//******************************************************************************
//
// 22.11.2000 - Removed a Bug wich does not allow using Databases in other Forms
//              or DataModules - Thanks to Josimar Serhid.
//
// 22.11.2000 - Added some code to speedup opening readonly tables and queryes
//              in InternalInitFieldDefs. Thanks to Simone.
//s
// 27.11.2000 - Added some code to enhance ftBoolean fields
//
// 27.11.2000 - Added new property WarnOnBadDatabase - True by default
//              When KADaoTable finds a corrupted database (bad RecordCount)
//              and WarnOnBadDatabase is True then an exeption is raised to
//              inform that database needs COMPACT and REPAIR
//******************************************************************************
//
// 04.12.2000 - Restored positioning method in Find_XXX methods
//              This is the slow method but is not based on Bookmark calculation
//
// 05.12.2000 - Removed rediculous bug in BooleanToBuffer -
//              thanks to Sergey Polevikov
//
// 05.12.2000 - Fixed a bug in Master/Detail fast opening recordset system
//              Now works fine. Thanks to Ingmar Bode for reporting the problem
//
// 05.12.2000 - Fixed a bug in Locate/Find_XXX/Seek_XXX routines which occurs on
//              special conditions. Also removed handling of DataEvent internal.
//              Thanks to Sergey Polevikov for reporting the problem
//
// 05.12.2000  - All Error messages are moved to resourcestring so you can
//               localize your KADAO.
//               Errors between 1000 and 1999 are rezerved for KADaoDatabase
//               Errors between 2000 and 2999 are rezerved for KADaoTable
//                                                                                                
// 07.12.2000  - Master/Detail Routines are COMPLETELY rewritten
//               Also if Detail is a parametrized Query all query parameters
//               that have Names equal with Detail fields will get data from
//               Master. Thanks to Dusko Vuksanovic - he was right!  
//
// 07.12.2000  - InternalGotoBookmark and BookmarkValid are changed reflecting
//               new information about this internal dataset routines.
//               Why Borland does not publisg tech info about this!?
//
// 07.12.2000  - Change made to CompareBookmarks method
//               Some custom DataGrids like InfoPower TwwDBGrid sends
//               PIntegers instead of BookmarkStrings
//
// 08.12.2000  - Fixed a bug in GetRecordCount - it retunts 1 instead of 0
//               whel last record is deleted - thanks to Mark Hamilton.
//
// 08.12.2000  - Added new property MasterAutoActivate - True by default
//               When this property is True if a Detail dataset is set to active
//               and the corresponding Master dataset is not active then
//               Detail dataset activates the Master. 
//******************************************************************************
//
// 11.12.2000  - Added minor change to BufferToDate routine
//
// 17.12.2000  - Requery now supports Master/Detail Relations
//
// 18.12.2000  - Added SaveToStream, SaveToFile,
//               LoadFromStream and LoadFromFile methods.
//               The Stream and File formats are compatible with kbmMemTable
//               created by Kim Bo Madsen - Scandinavia - kbm@optical.dk,
//               which is the best MemoryTable i have seen.
//               Only Data fields are stored. Blobs are stored too.
//               Use LoadFromBinaryFile and LoadFromBinaryStream methodts
//               of kbmMemTable to Load Datasets saved from KADaoTable.
//               Using this two methods you can move your data to other
//               Database platforms away from your office.
//
// 18.12.2000  - Added support for TField.DisplayText wich is equivalent
//               to Caption Property in Access
//
// 20.12.2000  - Added support for TField.OldValue.
//               TField.CurValue and TField.NewValue always return the
//               NEW value of the field.
//
// 20.12.2000  - Added FULL SUPPORT  for the following Methods:                   
//                 - SetKey
//                 - EditKey
//                 - CancelKey
//                 - GotoKey
//                 - GotoNearest
//               They work now as TTable methods.
//               The old SetKey Method is renamed to SetKeyParam.
//               See explanation of the methods in  the help file.
//
// 22.12.2000 - Fixed a bug in Seek_NearestEx - many thanks to Mark Hamilton
//
// 26.12.2000 - Added support for TField.OnValidate Event
//

// 26.12.2000 - Added FULL SUPPORT  for the following Methods:
//                - SetRange
//                - SetRangeStart
//                - SetRangeEnd
//                - EditRangeStart
//                - EditRangeEnd
//                - ApplyRange
//                - CancelRange
//               They work exactly as TTable methods.
//               See explanation of the methods in  the help file.
//
// 26.12.2000 - Added new propery UseGetRecNo - True by Default
//              Set to False on BIG Datasets wit Applyed Ranges
//              or Filtered Datasets based on OnFilterRecord event
//              This will speedup Table IO at 300%
//
// 26.12.2000 - Fixed a bug in Filtering (when Filtered is false but
//              OnFilterRecord is Assigned the Filtering is done which is not OK
//              Now works as expected
//
// 02.01.2001 - Added SUPERSPEED record positioning for recordsets that support
//              Bookmarks
//
// 02.01.2001 - Fixed a bug in InternalSetDisplayLabels - conflict with Table
//              Editor;
//
// 03.01.2001 - Added new property ProcessMessages - True by default
//              It is used to control processing of windows messages wnen
//              Saving And Loading data to/from File/Stream
//
// 03.01.2001 - Implemented COM cashing which speeds DRAMATICALY KADao I/O
//              Now KADao Adds 1000 records to empty table for 2 Seconds!
//
// 03.01.2001 - Changed the way on which Rollback works
//              Now after Rollback Table's Current record is the first record.
//
// 03.01.2001 - Added new Event OnExportProgress(Current,Total:Integer);
//              The event is triggered each time a new records is SAVED to
//              File or Stream. Current is zero based position
//              Total is nuber of records in the table -1
//
// 03.01.2001 - Added Support for Default values for String, Memos, Date/Time
//              fields. Note that function based defaults are NOT Supported
//              since they are not DAO based!
//
// 03.01.2001 - Added Handling of situation when user edits a record
//              already deleted by another user.
//
//******************************************************************************
//
// 03.01.2001 - Added support for Default values on Master/Detail relationship
//              Thanks to Jiri Kanda for reporting the problem
//
//
// 07.01.2001 - Removed ULTRAFAST positioning based on Bookmarks
//              it gives ERRORS in too many cases (WHY Microsoft WHY?)
//              Added WORKAROUND CODE to support viewing of BLOB fields
//              in enchanced DBGrids like InfoPower's wwDBGrid
//              This code is workaround becouse viewing of blobs
//              moves DAO cursor on records other than editing record and
//              this cancells editing internally. This results
//              "Update or CancelUpdate without AddNew or Edit" ERROR
//              to be raised when Post/Cancel is called
//              Thanks to Andrew Baylis and Jiri Kanda for reporting the problem
//
//
// 07.01.2001 - Added changes for speedup InternalSetDisplayLabels
//              This is the most then can be do for this routine
//              Sorry but DAO is really too slow on Queryes when
//              retrieving such properties
//
//******************************************************************************
//
// 08.01.2001 - Added propertiy UseCaptions - False by Default
//              Quering some field properties is extremely slow with MS Dao
//              This property controls DisplayLabels of Fileds which is equal
//              to MS Access Caption property
//              When set to True DisplayLabels are retrieved from the
//              Caption property orhervise DisplayLabels are set to Field names
//
// 08.01.2001 - Added property UseDaoProperties -True by Default
//              Quering some field properties is extremely slow with MS Dao
//              This property controls some Fileds properties
//              which can make easy adding new records
//              When set to False, Default Values are not shown when adding new records
//              Also Required property is not set on the fields that are required
//              Also you can modify fields that cannot be modified
//              (this will raise exception on Post)
//              Setting this property to False will increase speed
//              of opening Queries about 10000% but You must do coding carefully
//
// 10.01.2000 - Found A bug in SetBookmarkStr - it appears when deleting couple
//              of records trough multiselection in DBGrid
//              Thanls to Alfredo Milani-Comparetti for bugreport
//
// 12.01.2000 - All KADao Routines for positioning are REWRITED due to
//              special considerations with Indexes.
//
// 13.01.2000 - Fixed a small bug in InternalSetDisplayLabels.
//              Thanks to Jiri Kanda for bugfix.
//
// 14.01.2000 - Added Enchancemet which FANTASTICALLY SPEEDSUP adding records to
//              table. Now Append and Insert work at 500% faster.
//              The only need is to set the NEW property BatchMode to True
//              before adding recodrs and to False after that.
//
// 14.01.2000 - Now Default values are suported in Filtered and Sorted Tables
//
// 15.01.2000 - EmptyTable now is 500% faster.
//
// 15.01.2000 - GotoKey now Support StandardTable too
//
// 16.01.2000 - Fixed a bug in Bookmark Handling - with many thanks to
//              Mark Hamilton.
//
// 16.01.2000 - A little much more code added for handling
//              default fields in blobs
//
// 22.01.2000 - Added minor changes in LoadFromSream for compatibility with
//              KBMMemTable - new Event OnImportProgress(Current:Integer);
//              The event is triggered each time a new records is Loaded from
//              File or Stream - by Mark Hamilton.
//
// 23.01.2000 - Fixed a bug assosiated with Lookup and Calc fields
//              Now everything works properly
//
// 23.01.2000 - WarnOnBadDatabase is now False by default
//
// 23.01.2000 - Added new property CacheMemos - True by default
//              Set to False if you dont need displaying memos in dbGrids
//
// 24.01.2000 - KADAO Search Engine modifyed
//              Now Locate, Find and SeekNearestEx methods are much more faster
//
// 24.01.2000 - Removed IndexChacking in Locate! Now programmers are reposible
//              for setting correct Index when callinc Locate on StandardTables
//              CheckFieldsInIndex is NOT called which speeds up operations.
//
// 24.01.2000 - Added a special workaraound for MS Acces Formulas
//              IN DATE FIELDS ONLY - With Many Thanks to Richard Blanchard 
//******************************************************************************



interface
uses
DAOApi,
{$IFDEF DAO35}
DAO35Api,
{$ENDIF}
{$IFDEF DAO36}
DAO36Api,
{$ENDIF}
Windows, SysUtils, Classes, Db, DBCommon, KDaoDataBase, DsgnIntf, ActiveX, Forms;

//******************************************************* DatabaseError Messages
{$I ErrLangTB.pas}
//******************************************************************************


const
        MYBOOKMARKSIZE=8;

Type
TBlobData = String;

TDaoInfo=record
        RecordNo        : Integer;
        RecordData      : TStringList;
        BookmarkFlag    : TBookmarkFlag;
        BookmarkData    : Integer;
End;
PDaoInfo=^TDaoInfo;

TLockType = (ltReadLock, ltWriteLock);
TKeyType  = (KeyValue,RangeStart,RangeEnd);

TLoadMode = (lmAppend, lmEmptyAppend);

TOO    = (
          dbDenyWrite,
          dbDenyRead,
          dbReadOnly,
          dbAppendOnly,
          dbInconsistent,
          dbConsistent,
          dbSQLPassThrough,
          dbFailOnError,
          dbForwardOnly,
          dbSeeChanges,
          dbRunAsync,
          dbExecDirect
          );
TOOSet = Set of TOO;

TExportProgressEvent = procedure(Current,Total:Integer) of object;
TImportProgressEvent = procedure(Current:Integer) of object;

TTableNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TQueryNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TIndexNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TTableTypeEditor = class(TIntegerProperty)
    Public
     Function  GetValue: string; override;
     Procedure GetValues( Proc: TGetStrProc);override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TLockTypeEditor = class(TIntegerProperty)
    Public
     Function  GetValue: string; override;
     Procedure GetValues( Proc: TGetStrProc);override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TSortByEditor = class(TStringProperty)
    Public
     Function  GetValue: string; override;
     Procedure Edit;override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TQueryDefParamsEditor = class(TStringProperty)
    Public
     Function  GetValue: string; override;
     Procedure Edit;override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TMasterFieldsEditor = class(TStringProperty)
    Public
     Procedure Edit;override;
     Function GetValue: string; override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TKADaoTable = class(TDataSet)
private
        F_RecNo           : Integer;
        F_RecPos          : Integer;
        F_LastRecord      : Integer;
        F_RefreshRC       : Boolean;
        F_OldRC           : Integer;
        F_PostMade        : Boolean;
        F_InPost          : Boolean;
        F_BatchMode       : Boolean;


        F_OldValue        : PChar;
        F_ActiveKeyBuffer : PChar;
        F_KeyBuffer       : PChar;
        F_RangeStartBuffer: PChar;
        F_RangeEndBuffer  : PChar;

        F_BookmarkRN      : TList;
        F_BookmarkID      : TList;
        F_Bookmarkable    : Boolean;

        F_FilterBuffer    : PChar;
        F_BufferSize      : Integer;
        F_StartMyInfo     : Integer;
        F_StartCalc       : Integer;
        F_MDisabled       : Boolean;
        F_KeyFields       : TStringList;
        F_UpdatableFields : TList;

        {$IFDEF USEPARAMS}
          {$IFNDEF VER100}
            {$IFNDEF VER110}
        F_ParamCheck      : Boolean;
        F_Params          : TParams;
            {$ENDIF}
          {$ENDIF}
        {$ENDIF}

        Procedure       F_OnGetMemoText(Sender: TField; var Text: String; DisplayText: Boolean);
        Function        GetActiveRecordBuffer:  PChar;
        Function        FilterRecord(Buffer: PChar): Boolean;
        Function        AddLeadingZeros(Value:String):String;
protected
        F_Database               : TKADaoDatabase;
        F_Active                 : Boolean;
        F_ReadOnly               : Boolean;
        F_LockEdits              : Boolean;
        F_ProcessMessages        : Boolean;

        {$IFDEF DYNADAO} //****************************************************
        F_DaoTable               : OleVariant;
        F_DetailRecordset        : OleVariant;
        {$ELSE}
        F_DaoTable               : Recordset;
        F_DetailRecordset        : Recordset;
        {$ENDIF}


        F_SQL                    : TStrings;
        F_SortedBy               : TStrings;
        F_FieldNames             : TStrings;
        F_FieldTypeNames         : TStrings;
        F_DefaultValues          : TStrings;
        F_MDFieldNames           : TStrings;
        F_DisplayLabels          : TStrings;

        F_QD_ParamNames          : TStrings;
        F_QD_ParamDaoTypes       : TStrings;
        F_QD_ParamBDETypes       : TStrings;
        F_QueryDefMaxRecords     : Integer;
        F_QueryDefType           : String;

        F_MasterLink             : TMasterDataLink;
        F_MasterFields           : TStrings;
        F_UseBrackets            : Boolean;
        F_MasterAutoActivate     : Boolean;
        F_UseRecordCountCache    : Boolean;
        F_UseGetRecNo            : Boolean;
        F_UseDisplayLabels       : Boolean;
        F_UseDaoProperties       : Boolean;

        F_Detail                 : TStrings;
        F_Master                 : TStrings;

        F_RangeFiltered          : Boolean;
        F_Filtered               : Boolean;
        F_Filter                 : String;
        F_OnFilterRecord         : TFilterRecordEvent;
        F_OnExportProgress       : TExportProgressEvent;
        F_OnImportProgress       : TImportProgressEvent;

        F_TableName              : String;
        F_QueryDefName           : String;
        F_QueryDefParameters     : TStrings;
        F_QueryDefSQLText        : TStrings;
        F_IndexName              : String;
        F_IndexFieldCount        : Integer;
        F_TableType              : Integer;
        F_LockType               : Integer;
        F_OpenOptions            : TOOSet;
        F_RecordSize             : Integer;

        F_FindKeyFields          : String;
        F_FindKeyValues          : Variant;
        F_FindOptions            : TLocateOptions;

        F_KeyKeyFields           : String;
        F_KeyKeyValues           : Variant;

        F_DateCreated            : String;
        F_LastUpdated            : String;
        F_OLE_ON                 : Boolean;
        F_ComponentVersion       : String;
        F_WarnOnBadDatabase      : Boolean;
        F_CacheMemos             : Boolean;

        DaoFields                : OleVariant;

        Procedure                Loaded; override;

        Procedure       F_Set_ComponentVersion(Value: String);
        Function        F_Get_Database:TKADaoDatabase;
        Procedure       F_Set_Database(Value:TKADaoDatabase);
        Function        F_Get_TableName:String;
        Procedure       F_Set_TableName(Value:String);
        Function        F_Get_DateCreated:String;
        Function        F_Get_LastUpdated:String;

        Function        F_Get_IndexName:String;
        Procedure       F_Set_IndexName(Value:String);
        Function        F_Get_IndexFieldNames:String;
        Procedure       F_Set_IndexFieldNames(Value:String);

        Procedure       F_Set_TableType(Value:Integer);
        Procedure       F_Set_LockType(Value:Integer);
        Procedure       F_Set_OpenOptions(Value:TOOSet);
        Procedure       F_Set_ReadOnly(Value:Boolean);
        Procedure       F_Set_LockEdits(Value:Boolean);
        Procedure       F_Set_Sort(Value:TStrings);

        Procedure       F_Set_SQL(Value:TStrings);
        Procedure       F_Set_QueryDefName(Value:String);
        Procedure       F_Set_QueryDefParameters(Value:TStrings);
        Procedure       F_Set_QueryDefSQLText(Value:TStrings);
        Function        F_Get_QueryDefType:String;

        Function        F_Get_MasterSource: TDataSource;
        Procedure       F_Set_MasterSource(Value: TDataSource);
        Procedure       F_ProcessMasterFields(Value:TStrings);
        Procedure       F_Set_MasterFields(Value:TStrings);

        Procedure       F_Set_Master(Value:TStrings);
        Procedure       F_Set_Detail(Value:TStrings);
        Function        F_ComposeSQL(SQL:TStrings):String;

        Procedure       F_Set_Filtered(Value:Boolean);
        Procedure       F_Set_Filter(Value:String);
        Procedure       F_Set_OnFilterRecord(Value: TFilterRecordEvent);

        Function        F_Get_IndexField(Index: Integer): TField;
        Procedure       F_Set_IndexField(Index: Integer; Value: TField);

        Procedure       F_SetBatchMode(Value:Boolean);
        Procedure       F_Set_CacheMemos(Value:Boolean);

        //**********************************************************************
        {$IFDEF USEPARAMS}
          {$IFNDEF VER100}
            {$IFNDEF VER110}
        Procedure SetParamsList(Value: TParams);
        Procedure UpdateParamsList(Sender: TObject);
        Procedure WriteParamData(Writer: TWriter);
        Function  GetParamsCount: Word;
        Procedure DefineProperties(Filer: TFiler); override;
        Procedure ReadParamData(Reader: TReader);
            {$ENDIF}
          {$ENDIF}
        {$ENDIF}
        //**********************************************************************
        Procedure       MasterDatasetChanged;
        Procedure       UpdateFromMaster;
        Procedure       RefreshQueryParams;
        Procedure       MasterChanged(Sender: TObject);
        Procedure       MasterDisabled(Sender: TObject);
        Procedure       DoOnNewRecord; override;
        //**********************************************************************
        Procedure       ClearKey;
        Procedure       ClearRange(Var Buffer:PChar);
        Function        FilterRange(Buffer:PChar): Boolean;
        Function        CompareRecordsRange(B1,B2: PChar; CT : Integer) : Integer;
        Function        CompareFieldsRange(B1,B2 : String; FieldType: TFieldType):Integer;
        //**********************************************************************
        Function        InternalCalcRecordSize:Integer;
        Function        IntegerToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        FloatToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        BooleanToBuffer(Buffer: Pointer; S: String): Boolean;

        Function        DateToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        TimeToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        DateTimeToBuffer(Buffer: Pointer; S: String): Boolean;

        Function        BufferToDate(Buffer: Pointer): String;
        Function        BufferToTime(Buffer: Pointer): String;
        Function        BufferToDateTime(Buffer: Pointer): String;

        Function        StringToBlob(Field:TBlobField; Data:String):OleVariant;
        Function        BlobToString(Field:TBlobField; Data:OleVariant; DataSize:Integer):String;

        Function        ProcessDTDefault(S:String):String;
        Procedure       OpenDaoRecordset;
        Procedure       ReOpenDaoRecordset;
        Procedure       GetQueryDefReturnParams(QueryDefName:String);
        Procedure       CloseDaoRecordset;

        Procedure       InternalOpen; override;
        Procedure       InternalClose; override;
        Function        IsCursorOpen: Boolean; override;
        Function        GetCanModify: Boolean; override;
        Function        GetRecordSize: Word;override;
        Function        AllocRecordBuffer: PChar; override;
        Procedure       FreeRecordBuffer(var Buffer: PChar); override;
        Function        GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
        Procedure       InternalInitFieldDefs; override;
        Procedure       InternalSetDisplayLabels;
        Procedure       InternalInitRecord(Buffer: PChar); override;
        Procedure       SetFieldData(Field: TField; Buffer: Pointer);override;
        Procedure       ClearCalcFields(Buffer: PChar);override;


        //*********************************************** Navigation and Editing
        Procedure       InternalFirst;override;
        Procedure       InternalLast;override;
        Procedure       InternalMoveToBookmark(Bookmark: Pointer);
        Procedure       InternalSetToRecord(Buffer: PChar); override;
        Procedure       InternalEdit; override;
        Procedure       InternalCancel; override;
        Procedure       InternalPost; override;
        Procedure       InternalAddRecord(Buffer: Pointer; Append: Boolean); override;
        Procedure       InternalDelete; override;
        Procedure       InternalRefresh; override;
        //***********************************************
        Function        GetDaoBookMark(RS:Variant):Integer;
        Function        GetDaoLastModifiedBookMark(RS:Variant):Integer;
        
        Procedure       InternalClearBookmarks;
        Procedure       InternalGotoBookmark(Bookmark: Pointer); override;

        Function        GetBookmarkFlag(Buffer: PChar): TBookmarkFlag; override;
        Procedure       SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag); override;

        Function        GetBookmarkStr: TBookmarkStr; override;
        Procedure       SetBookmarkStr(const Value: TBookmarkStr); override;

        Procedure       GetBookmarkData(Buffer: PChar; Data: Pointer); override;
        Procedure       SetBookmarkData(Buffer: PChar; Data: Pointer); override;

        Procedure       InternalHandleException; override;

        Function        GetRecordCount  : Integer; override;
        Function        GetRecNo        : Integer; override;
        Procedure       SetRecNo        (Value: Integer); override;

        //************************************************* TTable Compatibility
        Function        FindRecord(Restart, GoForward: Boolean): Boolean; override;
        //************************************************* TTable Compatibility

        Procedure       StringToList(Items: String; List: TStringList);
        Procedure       VariantToList(Items: Variant; List: TStringList);
        Procedure       AssignVarValue(Var V :Variant;const Value: TVarRec);
        Function        BuildKeySQL(KN,KV:TStringList):String;
        Function        BuildLocateSQL(KN,KV:TStringList;Options: TLocateOptions):String;
        Function        BuildDetailSQL  : String;

        Function        Find(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions;FindType:Integer): Boolean;
        Function        InsertSQLString(MDString: String): String;


  public
        MainDatabaseShutdown             : Boolean;
        QueryDefTypeInt                  : Integer;
        QueryDefReturnParams             : OleVariant;
        RecordsAffected                  : Integer;

        {$IFDEF DYNADAO}
        CoreRecordset                    : OleVariant;
        {$ELSE}
        CoreRecordset                    : Recordset;
        {$ENDIF}
        SQLExecutionType                 : Integer;
        Constructor                        Create(AOwner: TComponent); override;
        Destructor                         Destroy; override;

        Property                           BatchMode : Boolean Read F_BatchMode Write F_SetBatchMode;

        Procedure                          Post; override;
        Procedure                          RollbackRefresh;

        Function                           FindGoodIndex(KeyFields:String):String;
        Function                           GetFieldData(Field: TField; Buffer: Pointer): Boolean; override;
        Function                           CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream; override;

        Procedure                          SetKeyFields(const KeyFields: string);
        Function                           GetFieldIndexName(FiledName:String):String;
        Function                           CheckFieldsInIndex(KF:TStringList):Boolean;
        Function                           Find_First(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Last(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Next(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Prior(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Nearest(const KeyValues: array of const):Boolean;
        Function                           Find_NearestEx(const KeyFields: string; const KeyValues: Variant):Boolean;
        Function                           Seek_Nearest(const KeyValues: array of const):Boolean;
        Function                           Seek_NearestEx(const KeyValues: array of const; SeekType:String):Boolean;

        //*******************************  For TTable Compatibility
        Procedure                          FindNearest(const KeyValues: array of const);
        Property                           IndexFieldCount : Integer Read F_IndexFieldCount;
        Property                           IndexFieldNames : String Read F_Get_IndexFieldNames Write F_Set_IndexFieldNames;
        Property                           IndexFields[Index: Integer]: TField read F_Get_IndexField write F_Set_IndexField;
        Procedure                          SetFindData(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions);
        Procedure                          LockTable(LockType: TLockType);
        Procedure                          UnlockTable(LockType: TLockType);

        //*******************************  Key Routines
        Procedure                          SetKey;
        Procedure                          EditKey;
        Procedure                          CancelKey;
        Procedure                          SetKeyParam(const KeyFields: Array of String;const KeyValues: array of const);
        Function                           GotoKey: Boolean;
        Procedure                          GotoNearest;
        Function                           FindKey(const KeyValues: array of const):Boolean;
        //*******************************  Key Routines

        //*******************************  Range Routines
        Procedure                          SetRange(const StartValues, EndValues:array of const);
        Procedure                          SetRangeStart;
        Procedure                          SetRangeEnd;
        Procedure                          EditRangeStart;
        Procedure                          EditRangeEnd;
        Procedure                          ApplyRange;
        Procedure                          CancelRange;
        //*******************************  Range Routines

        //*******************************  For TTable Compatibility
        Function                           Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean; override;
        Function                           Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant; override;

        Function                           CreateField(FieldName:String;FieldType:Integer;FiledSize:Integer):Boolean;
        Function                           CreateIndex(FieldName:String;IndexType:Integer):Boolean;
        Function                           DeleteField(FieldName:String):Boolean;
        Function                           DeleteIndex(FieldName:String):Boolean;
        Function                           EmptyTable:Boolean;

        Function                           CompareBookmarks(Bookmark1, Bookmark2: TBookmark): Integer; override;
        Function                           BookmarkValid(Bookmark: TBookmark): Boolean; override;
        Function                           GetRows(NumRows:Integer):OleVariant;

        Property  Bookmarkable           : Boolean         Read F_Bookmarkable;
        Property  MasterLink             : TMasterDataLink Read F_MasterLink;
        Property  FieldNames             : TStrings        Read F_FieldNames;
        Property  LinkableFields         : TStrings        Read F_MDFieldNames;

        {$IFDEF USEPARAMS}
          {$IFNDEF VER100}
            {$IFNDEF VER110}
        Property ParamCount              : Word read GetParamsCount;
            {$ENDIF}
          {$ENDIF}
        {$ENDIF}
        Function                           ExecSQL(SQL:TStrings):Integer;
        Function                           ExecuteSQL:Integer;
        Function                           ExecuteQueryDefSQL:Integer;

        Function                           Requery : Boolean;
        Procedure                          GotoCurrent(Table: TKADaoTable);

        Procedure                          GetIndexNames(List: TStrings);
        Procedure                          GetFieldNames(List: TStrings);
        Function                           PercentPosition:Single;
        Function                           GetSourceFieldName(FieldName:String):String;
        Function                           GetSourceTableName(FieldName:String):String;
        Function                           GetLastDaoError:TDaoErrRec;
        Function                           PropertyExists(PropObject:OleVariant;PropertyName:String):Boolean;

        Function                           PromptQueryDefParameters:Boolean;

        //**************************************************** Storage Functions
        Function  StoreField(X:Integer): Boolean;
        Procedure SaveToStream(Stream: TStream);
        Procedure SaveToFile(const FileName: String);

        Procedure LoadFromStream(Stream: TStream; Mode : TLoadMode);
        Procedure LoadFromFile(const FileName: String; Mode : TLoadMode);
        //**********************************************************************
  published
        Property ComponentVersion        : String  Read F_ComponentVersion Write F_Set_ComponentVersion;
        Property CacheMemos              : Boolean Read F_CacheMemos Write F_Set_CacheMemos;
        Property Database                : TKADaoDatabase Read F_Get_Database Write F_Set_Database;
        Property TableName               : String Read F_Get_TableName Write F_Set_TableName;
        Property SortedBy                : TStrings Read F_SortedBy Write F_Set_Sort;
        Property SortedByText            : TStrings Read F_SortedBy Write F_Set_Sort;
        Property QueryDefName            : String Read F_QueryDefName Write F_Set_QueryDefName;
        Property QueryDefParameters      : TStrings Read F_QueryDefParameters Write F_Set_QueryDefParameters;
        Property QueryDefParametersText  : TStrings Read F_QueryDefParameters Write F_Set_QueryDefParameters;
        Property QueryDefSQLText         : TStrings Read F_QueryDefSQLText Write F_Set_QueryDefSQLText;
        Property QueryDefODBCMaxRecords  : Integer Read F_QueryDefMaxRecords Write F_QueryDefMaxRecords;
        Property QueryDefType            : String Read F_Get_QueryDefType Write F_QueryDefType;
        Property SQL                     : TStrings Read F_SQL Write F_Set_SQL;
        {$IFDEF USEPARAMS}
          {$IFNDEF VER100}
           {$IFNDEF VER110}
        Property Params                  : TParams read F_Params Write SetParamsList Stored False;
           {$ENDIF}
         {$ENDIF}
        {$ENDIF}
        Property TableType               : Integer Read F_TableType Write F_Set_TableType;
        Property TableDateCreated        : String Read F_Get_DateCreated Write F_DateCreated;
        Property TableLastUpdated        : String Read F_Get_LastUpdated Write F_LastUpdated;
        Property LockType                : Integer Read F_LockType Write F_Set_LockType;
        Property OpenOptions             : TOOSet Read F_OpenOptions Write F_Set_OpenOptions;
        Property IndexName               : String Read F_Get_IndexName Write F_Set_IndexName;
        Property ReadOnly                : Boolean Read F_ReadOnly Write F_Set_ReadOnly;
        Property LockEdits               : Boolean Read F_LockEdits Write F_Set_LockEdits;
        Property MasterSource            : TDataSource Read F_Get_MasterSource Write F_Set_MasterSource;
        Property MasterFields            : TStrings Read F_MasterFields Write F_Set_MasterFields;
        Property MasterAutoActivate      : Boolean Read F_MasterAutoActivate Write F_MasterAutoActivate;
        Property UseBrackets             : Boolean Read F_UseBrackets Write F_UseBrackets;
        Property UseCaptions             : Boolean Read F_UseDisplayLabels Write F_UseDisplayLabels;
        Property UseDaoProperties        : Boolean Read F_UseDaoProperties Write F_UseDaoProperties;
        Property UseGetRecNo             : Boolean Read F_UseGetRecNo Write F_UseGetRecNo;
        Property UseRecordCount          : Boolean Read F_UseRecordCountCache Write F_UseRecordCountCache;
        Property WarnOnBadDatabase       : Boolean Read F_WarnOnBadDatabase Write F_WarnOnBadDatabase;
        Property Filtered                : Boolean Read F_Filtered Write F_Set_Filtered;
        Property Filter                  : String Read F_Filter Write F_Set_Filter;
        Property OnExportProgress        : TExportProgressEvent Read F_OnExportProgress Write F_OnExportProgress;
        Property OnImportProgress        : TImportProgressEvent Read F_OnImportProgress Write F_OnImportProgress;
        Property OnFilterRecord          : TFilterRecordEvent read F_OnFilterRecord write F_Set_OnFilterRecord;
        {$IFDEF USEPARAMS}
          {$IFNDEF VER100}
            {$IFNDEF VER110}
        Property ParamCheck              : Boolean Read F_ParamCheck Write F_ParamCheck;
            {$ENDIF}
          {$ENDIF}
        {$ENDIF}
        Property ProcessMessages         : Boolean Read F_ProcessMessages Write F_ProcessMessages;
        Property BeforeOpen;
        Property AfterOpen;
        Property BeforeClose;
        Property AfterClose;
        Property BeforeInsert;
        Property AfterInsert;
        Property BeforeEdit;
        Property AfterEdit;
        Property BeforePost;
        Property AfterPost;
        Property BeforeCancel;
        Property AfterCancel;
        Property BeforeDelete;
        Property AfterDelete;
        Property BeforeScroll;
        Property AfterScroll;
        Property OnCalcFields;
        Property OnDeleteError;
        Property OnEditError;
        Property OnNewRecord;
        Property OnPostError;
        Property Active;
End;


// Handle Memo fields
  TKBlobStream = class(TStream)
  private
    F_Field      : TBlobField;
    F_DataSet    : TKADaoTable;
    F_Buffer     : PChar;
    F_Mode       : TBlobStreamMode;
    F_Opened     : Boolean;
    F_Modified   : Boolean;
    F_Position   : Longint;
    F_BlobData   : TBlobData;
    F_BlobSize   : Integer;
  public
    constructor Create(Field: TBlobField; Mode: TBlobStreamMode);
    destructor Destroy; override;
    Function Read(var Buffer; Count: Longint): Longint; override;
    Function Write(const Buffer; Count: Longint): Longint; override;
    Function Seek(Offset: Longint; Origin: Word): Longint; override;
    Procedure Truncate;
  End;



Procedure Register;

implementation
Uses DaoUtils,Dialogs,SortByDialog,QueryDefDialogUnit,MasterDetailFormUnit;

Const
  CRLF=#13+#10;
  {$IFNDEF D4UP}
  FieldTypeNames: Array[TFieldType] of String = (
    'Unknown', 'String', 'SmallInt', 'Integer', 'Word', 'Boolean', 'Float',
    'Currency', 'BCD', 'Date', 'Time', 'DateTime', 'Bytes', 'VarBytes',
    'AutoInc', 'Blob', 'Memo', 'Graphic', 'FmtMemo', 'ParadoxOle',
    'dBaseOle', 'TypedBinary', 'Cursor');
  {$ENDIF}
//******************************************************************************
//******************************************************************************
constructor TKADaoTable.Create(AOwner: TComponent);
Var
  OLE_INIT:Integer;
Begin
  inherited Create(AOwner);
  MainDatabaseShutdown   := False;
  F_ComponentVersion     := '5.00';
  F_TableName            := '';
  F_TableType            := dbOpenDynaset;
  F_LockType             := dbOptimistic;
  F_OpenOptions          := [];
  F_ReadOnly             := False;
  F_LockEdits            := False;
  F_ProcessMessages      := True;
  F_QueryDefName         := '';
  F_QueryDefSQLText      := TStringList.Create;
  F_QueryDefSQLText.Clear;
  F_QueryDefMaxRecords   := 0;
  F_QueryDefType         := '';
  QueryDefTypeInt        := 0;
  RecordsAffected        := 0;
  F_SQL                  := TStringList.Create;
  F_SQL.Clear;
  F_SortedBy             := TStringList.Create;
  F_SortedBy.Clear;
  F_FieldNames           := TStringList.Create;
  F_FieldNames.Clear;
  F_FieldTypeNames       := TStringList.Create;
  F_FieldTypeNames.Clear;
  F_DefaultValues        := TStringList.Create;
  F_DefaultValues.Clear;
  F_MDFieldNames         := TStringList.Create;
  F_DisplayLabels        := TStringList.Create;
  F_MDFieldNames.Clear;
  F_DateCreated          := '';
  F_LastUpdated          := '';
  //****************************************************************************
  F_QD_ParamNames        := TStringList.Create;
  F_QD_ParamNames.Clear;
  F_QD_ParamDaoTypes     := TStringList.Create;
  F_QD_ParamDaoTypes.Clear;
  F_QD_ParamBDETypes     := TStringList.Create;
  F_QD_ParamBDETypes.Clear;

  F_QueryDefParameters   := TStringList.Create;
  F_QueryDefParameters.Clear;
  SQLExecutionType       :=DaoApi.dbFailOnError;
  //****************************************************************************
  F_FindKeyFields        := '';
  F_FindKeyValues        := VarNull;
  F_FindOptions          := [];

  F_KeyKeyFields         := '';
  F_KeyKeyValues         := VarNull;
  //****************************************************************************
  F_MDisabled                   := False;
  F_MasterFields                := TStringList.Create;
  F_MasterFields.Clear;
  F_MasterLink                  := TMasterDataLink.Create(Self);
  F_MasterLink.OnMasterChange   := MasterChanged;
  F_MasterLink.OnMasterDisable  := MasterDisabled;
  F_Detail               := TStringList.Create;
  F_Detail.Clear;
  F_Master               := TStringList.Create;
  F_Master.Clear;
  //****************************************************************************

  F_KeyFields            := TStringList.Create;
  F_KeyFields.Clear;
  F_UpdatableFields      := TList.Create;
  F_UpdatableFields.Clear;

  F_BookmarkRN           := TList.Create;
  F_BookmarkRN.Clear;
  F_BookmarkID           := TList.Create;
  F_BookmarkID.Clear;
  F_Bookmarkable         := False;
  F_PostMade             := False;
  F_InPost               := False;
  F_BatchMode            := False;

  F_UseBrackets          := True;
  F_MasterAutoActivate   := True;
  F_UseRecordCountCache  := True;
  F_UseGetRecNo          := True;
  F_UseDisplayLabels     := False;
  F_UseDaoProperties     := True;

  F_Filtered             := False;
  F_RangeFiltered        := False;
  //************************************************************
  F_Database             := Nil;
  F_OldValue             := Nil;
  F_WarnOnBadDatabase    := False;
  F_CacheMemos           := True;
  //************************************************************
  {$IFDEF USEPARAMS}
   {$IFNDEF VER100}
    {$IFNDEF VER110}
  TStringList(F_SQL).OnChange := UpdateParamsList;
  F_ParamCheck                := True;
  F_Params                    := TParams.Create(Self);
    {$ENDIF}
   {$ENDIF}
  {$ENDIF}
  //************************************************************
  {$IFDEF DYNADAO}
   F_DetailRecordset   := NULL;
  {$ELSE}
   F_DetailRecordset   := NIL;
  {$ENDIF}

  F_OnFilterRecord   := Nil;
  F_OnExportProgress := Nil;
  F_OnImportProgress := Nil;

  F_OLE_ON:=False;
  OLE_INIT:= CoInitialize(NIL);
  if (OLE_INIT = S_OK) or (OLE_INIT = S_FALSE) then F_OLE_ON:= True
  else DatabaseError(E2001);
  //**************************************************************** Com Cashing
  DaoFields:=VarArrayCreate([0,1],VarVariant);
  //****************************************************************************
End;

destructor TKADaoTable.Destroy;
Begin
  if F_Active Then
      Begin
        InternalClose;
        F_Active:=False;
      End;
  //**************************************************************** Com Cashing
  VarArrayRedim(DaoFields,0);
  DaoFields := NULL;
  //****************************************************************************
  F_SQL.Free;
  F_SortedBy.Free;
  F_FieldNames.Free;
  F_FieldTypeNames.Free;
  F_DefaultValues.Free;
  F_MDFieldNames.Free;
  F_DisplayLabels.Free;
  F_QueryDefParameters.Free;
  F_QueryDefSQLText.Free;
  F_QD_ParamNames.Free;
  F_QD_ParamDaoTypes.Free;
  F_QD_ParamBDETypes.Free;
  F_MasterLink.Free;
  F_MasterFields.Free;
  F_Detail.Free;
  F_Master.Free;
  F_KeyFields.Free;
  F_UpdatableFields.Free;

  F_BookmarkRN.Free;
  F_BookmarkID.Free;

  {$IFDEF USEPARAMS}
   {$IFNDEF VER100}
    {$IFNDEF VER110}
  F_Params.Free;
    {$ENDIF}
   {$ENDIF}
  {$ENDIF}
  {$IFDEF DYNADAO}
  F_DaoTable  := NULL;
  {$ELSE}
  F_DaoTable  := Nil;
  {$ENDIF}
  if F_OLE_ON then CoUninitialize;
  inherited Destroy;
End;

Procedure TKADaoTable.F_Set_ComponentVersion(Value: String);
Begin
 //*************************** ReadOnly
End;

Function TKADaoTable.ExecSQL(SQL:TStrings):Integer;
Begin
 Result:=0;
 RecordsAffected:=Result;
 if Assigned(F_Database) And (F_Database.Connected) Then
    Begin
      F_Database.CoreDatabase.Execute(F_ComposeSQL(SQL),SQLExecutionType);
      Result:=F_Database.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
    End
 Else
    DatabaseError(E2002);
End;

Function TKADaoTable.ExecuteSQL:Integer;
Begin
 Result:=0;
 RecordsAffected:=Result;
 if Assigned(F_Database) And (F_Database.Connected) Then
    Begin
      F_Database.CoreDatabase.Execute(F_ComposeSQL(SQL),SQLExecutionType);
      Result:=F_Database.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
    End
 Else
    DatabaseError(E2003);
End;

Function TKADaoTable.ExecuteQueryDefSQL:Integer;
Var
 X         : Integer;
 TabN      : String;
 NRP       : Integer;
 Dir       : Integer;
Begin
 Result:=0;
 RecordsAffected:=Result;
 if Assigned(F_Database) And (F_Database.Connected) And (F_QueryDefName <> '') Then
    Begin
      TabN:=F_QueryDefName;
      NRP:=0;
      For X:=0 To Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count-1 do
          Begin
            Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
            if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
                Begin
                 Try
                  Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[X].Value:=F_QueryDefParameters.Strings[NRP];
                  Inc(NRP);
                 Except
                  DatabaseError(E2004);
                 End;
                End;
          End;
      if F_Database.QueryTimeout <> 60 Then
      F_Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].ODBCTimeout:=F_Database.QueryTimeout;
      F_Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].Execute(SQLExecutionType);
      Result:=F_Database.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
      GetQueryDefReturnParams(F_QueryDefName);
    End
 Else
    DatabaseError(E2005);
End;

Function  TKADaoTable.Requery : Boolean;
Var
 X         : Integer;
 TabN      : String;
 NRP       : Integer;
 Dir       : Integer;
Begin
  Result:=False;
  If Not F_Active Then Exit;
  if Not F_DaoTable.Restartable Then Exit;
  if (F_QueryDefName <> '') Then
      Begin
        TabN:=F_QueryDefName;
        NRP:=0;
        For X:=0 To Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count-1 do
          Begin
            Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
            if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
                Begin
                 Try
                  Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[X].Value:=F_QueryDefParameters.Strings[NRP];
                  Inc(NRP);
                 Except
                  DatabaseError(E2006);
                 End;
                End;
          End;
      End;
  if (MasterSource <> NIL) And (Not F_MDisabled) then
     Begin
       MasterDatasetChanged;
     End
  Else
     Begin
      ClearBuffers;
      CheckBrowseMode;
      OleVariant(F_DaoTable).Requery;
      ActivateBuffers;
      First;
     End;
  Result:=True;
End;

Procedure TKADaoTable.GotoCurrent(Table: TKADaoTable);
Begin
  CheckBrowseMode;
  Table.CheckBrowseMode;
  if (AnsiCompareText(F_Database.Database, Table.Database.Database) <> 0) or
     (AnsiCompareText(TableName, Table.TableName) <> 0) then
     DatabaseError(E2007);
  Table.UpdateCursorPos;
  First;
  MoveBy(Table.RecNo-1);
  Resync([rmExact, rmCenter]);
End;

Procedure TKADaoTable.GetIndexNames(List: TStrings);
Var
 Count,X : Integer;
Begin
  List.Clear;
  Try
    if Assigned(F_Database) And (F_Database.Connected) Then
     Begin
      F_Database.RefreshDefinitions;
      Count :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Count;
      For X := 0 to  Count-1 do
          Begin
            List.Add(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Name);
          End;
     End;
  Except
  End;
End;

Procedure TKADaoTable.GetFieldNames(List: TStrings);
Var
 Count, X, FT  : Integer;
Begin
  List.Clear;
  Try
     if Assigned(F_Database) And (F_Database.Connected) Then
     Begin
      F_Database.RefreshDefinitions;
      Count :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Count;
      For X := 0 to  Count-1 do
          Begin
            {$IFDEF DYNADAO}
            FT :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Item[X].Type;
            {$ELSE}
            FT :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Item[X].Type_;
            {$ENDIF}
            List.AddObject(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Item[X].Name,TObject(FT));
          End;
     End;
  Except
  End;
End;

Function TKADaoTable.PercentPosition:Single;
Begin
 Result := -1;
 Try
  if F_Active Then Result := F_DaoTable.PercentPosition;
 Except
 End; 
End;

Function  TKADaoTable.GetSourceFieldName(FieldName:String):String;
Begin
 Result :='';
 if Not F_Active Then Exit;
 Try
   Result := F_DaoTable.Fields.Item[FieldName].SourceField;
 Except
 End;
End;

Function  TKADaoTable.GetSourceTableName(FieldName:String):String;
Begin
 Result :='';
 if Not F_Active Then Exit;
 Try
   Result := F_DaoTable.Fields.Item[FieldName].SourceTable;
 Except
 End;
End;

Function  TKADaoTable.GetLastDaoError:TDaoErrRec;
Begin
  if Assigned(F_Database) And (F_Database.Connected) Then
  Result := F_Database.GetLastDaoError;
End;

Function TKADaoTable.PropertyExists(PropObject:OleVariant;PropertyName:String):Boolean;
Var
  X : Integer;
Begin
  Result := False;
  For X := 0 to PropObject.Count-1 do
      Begin
        if AnsiCompareText(PropObject.Item[X].Name,PropertyName)=0 Then
           Begin
             Result := True;
             Exit;
           End;
      End;
End;

Function TKADaoTable.PromptQueryDefParameters:Boolean;
Var
  X       : Integer;
  Dir     : Integer;
  NP      : Integer;
  Typ     : Integer;
Begin
  Result := False;
  if NOT Assigned(F_Database) Then Exit;
  if NOT (F_Database.Connected) Then Exit;
  if F_QueryDefName='' Then Exit;
  if Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count=0 Then
     Begin
      DatabaseError(E2008);
      Exit;
     End;
  F_QD_ParamNames.Clear;
  F_QD_ParamDaoTypes.Clear;
  F_QD_ParamBDETypes.Clear;
  Try
     NP:=0;
     For X := 0 To Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
        Begin
          Dir:= Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
          if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
             Begin
              Inc(NP);
              {$IFDEF DYNADAO}
              Typ :=Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Type;
              {$ELSE}
              Typ :=Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Type_;
              {$ENDIF}
              if (Typ=dbDate) Then Typ:=dbTimeStamp;
              F_QD_ParamNames.Add(Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Name);
              F_QD_ParamDaoTypes.Add(GetDaoFieldTypeNames(Typ));
              F_QD_ParamBDETypes.Add(GetBDEFieldTypeNames(DaoToBDE(Typ)));
             End;
        End;
     if NP=0 Then
        Begin
           DatabaseError(E2009);
           Exit;
        End;
  Except
      DatabaseError(E2010);
      Exit;
  End;
  Application.CreateForm(TQueryDefDialog,QueryDefDialog);
  Result := QueryDefDialog.Execute(F_QD_ParamNames,F_QD_ParamDaoTypes,F_QD_ParamBDETypes,F_QueryDefParameters);
  QueryDefDialog.Free;
End;

Function TKADaoTable.StoreField(X:Integer): Boolean;
Begin
   Case Fields[X].FieldKind of
        fkData       : Result := True;
        fkCalculated : Result := False;
        fkLookup     : Result := False;
   Else                Result := False;
   End;
End;


Procedure TKADaoTable.SaveToStream(Stream: TStream);
Var
   X          : Integer;
   Book       : TBookmark;
   Writer     : TWriter;
   Current    : Integer;
   Total      : Integer;
Begin
  if IsEmpty Then Exit;
  Book         := GetBookmark;
  Try
   DisableControls;
   Writer := TWriter.Create(Stream, 16384);
   Writer.WriteSignature;
   Try
   //*************************************************** Write Structure
   Writer.WriteListBegin;
   For X:=0 to FieldCount-1 do
       Begin
        If F_ProcessMessages Then Application.ProcessMessages;
        if StoreField(X) then
           Begin
            Writer.WriteString(Fields[X].FieldName);
            Writer.WriteString(FieldTypeNames[Fields[X].DataType]);
            Writer.WriteInteger(Fields[X].Size);
            Writer.WriteString(Fields[X].DisplayName);
            Writer.WriteString(Fields[X].EditMask);
            Writer.WriteInteger(Fields[X].DisplayWidth);
            Writer.WriteBoolean(Fields[X].Required);
            Writer.WriteBoolean(Fields[X].ReadOnly);
           End;
       end;
   Writer.WriteListEnd;

   //******************************************************** Write Data
   Total  := RecordCount-1;
   Current:=0;
   Writer.WriteListBegin;
   First;
   While Not EOF do
     Begin
      if Assigned(F_OnExportProgress) Then F_OnExportProgress(Current,Total);
      For X:=0 to FieldCount-1 do
        Begin
          If F_ProcessMessages Then Application.ProcessMessages;
          if StoreField(X) Then
             Begin
               Case Fields[X].DataType of
                    ftBoolean   : Writer.WriteBoolean(Fields[X].AsBoolean);
                    ftSmallInt  ,
                    ftInteger   ,
                    ftWord      ,
                    ftAutoInc   : Writer.WriteInteger(Fields[X].AsInteger);
                    ftFloat     : Writer.WriteFloat(Fields[X].AsFloat);
                    ftBCD       ,
                    ftCurrency  : Writer.WriteFloat(Fields[X].AsCurrency);
                    ftDate      ,
                    ftTime      ,
                    ftDateTime  : Writer.WriteFloat(Fields[X].AsFloat);
               Else
                    Writer.WriteString(Fields[X].AsString);
               End;
             End;
        End;
      Inc(Current);
      Next;
      F_Database.Idle;
     End;
   Writer.WriteListEnd;
   Finally
     Writer.FlushBuffer;
     Writer.Free;
   End;
  Finally
    GotoBookmark(Book);
    EnableControls;
    FreeBookmark(Book);
  End;
End;

Procedure TKADaoTable.SaveToFile(const FileName: String);
Var
 Stream: TStream;
Begin
 Stream := TFileStream.Create(FileName, fmCreate);
 Try
  SaveToStream(Stream);
 Finally
  if Stream.Size=0 Then
     Begin
       Stream.Free;
       DeleteFile(FileName);
     End
  Else
     Begin
       Stream.Free;
     End;
 End;
End;

Procedure TKADaoTable.LoadFromStream(Stream: TStream; Mode : TLoadMode);
Var
  Reader       : TReader;
  FieldName    : String;
  DataTypeName : String;
  DisplayName  : String;
  EditMask     : String;
  DisplayWidth : Integer;
  Required     : Boolean;
  ReadOnly     : Boolean;
  I            : Integer;
  X            : Integer;
  Field        : TField;
  FNames       : TStringList;
  Book         : TBookmark;
  OK           : Boolean;
  Current      : LongInt;
  KbmFileVers  : Integer;                     
Begin
  if Not Active Then DatabaseError(E2058);
  if Mode = lmEmptyAppend Then EmptyTable;
  Book   := GetBookmark;
  Reader := TReader.Create(Stream, 16384);
  FNames := TStringList.Create;
  Try
   DisableControls;
   Reader.ReadSignature;
   if (Reader.NextValue = vaList) Then
       KbmFileVers := 100 Else
       KbmFileVers := Reader.ReadInteger;
   //************************************************************ Read Structure
   Reader.ReadListBegin;
     While (Not Reader.EndOfList) Do
      Begin
       If F_ProcessMessages Then Application.ProcessMessages;
       FieldName    := Reader.ReadString;
       DataTypeName := Reader.ReadString;
                       Reader.ReadInteger;
       DisplayName  := Reader.ReadString;
       EditMask     := Reader.ReadString;
       DisplayWidth := Reader.ReadInteger;
       Required     := Reader.ReadBoolean;
       ReadOnly     := Reader.ReadBoolean;
       if (KbmFileVers >= 250) Then Reader.ReadString;
       FNames.Add(FieldName);
       I := FieldDefs.IndexOf(FieldName);
       if I > -1 Then
          Begin
            Field:=FindField(FieldName);
            if Field <> Nil Then
               Begin
                Field.DisplayLabel := DisplayName;
                Field.EditMask     := EditMask;
                Field.DisplayWidth := DisplayWidth;
                Field.Required     := Required;
                Field.ReadOnly     := ReadOnly;
              End
            Else
              DatabaseError(E2059);
          End
       Else
         DatabaseError(E2059);
     End;
   Reader.ReadListEnd;
   //***************************************************************** Read Data
   Last;
   Reader.ReadListBegin;
   Try
     F_Database.StartTransaction;
   Except
   End;
   Current := 0;
   While (NOT Reader.EndOfList) do
    Begin
     if Assigned(F_OnImportProgress) Then F_OnImportProgress(Current);
     OK := False;
     For X :=0 to FNames.Count-1 do
         Begin
          If F_ProcessMessages Then Application.ProcessMessages;
          Field := FindField(FNames.Strings[X]);
          if Field <> Nil Then
             Begin
               if NOT OK Then
                  Begin
                    OK := True;
                    Insert;
                  End;
               Case Field.DataType of
                    ftBoolean  : Field.AsBoolean := Reader.ReadBoolean;
                    ftSmallInt ,
                    ftInteger  ,
                    ftWord     ,
                    ftAutoInc  : Field.AsInteger := Reader.ReadInteger;
                    ftFloat    : Field.AsFloat := Reader.ReadFloat;
                    ftBCD,
                    ftCurrency : Field.AsCurrency := Reader.ReadFloat;
                    ftDate     ,
                    ftTime     ,
                    ftDateTime : Field.AsFloat := Reader.ReadFloat;
               Else
                    Field.AsString := Reader.ReadString;
               End;
             End;
         End;
     if OK Then Post;
     F_Database.Idle;
     Inc(Current);
    End;
   Try
     F_Database.Commit;
   Except
   End;
   Reader.ReadListEnd;
  Finally
   Reader.Free;
   FNames.Free;
   if Mode = lmAppend Then GotoBookmark(Book);
   EnableControls;
   FreeBookmark(Book);
  End;
End;


Procedure TKADaoTable.LoadFromFile(const FileName: String; Mode : TLoadMode);
Var
 Stream: TStream;
Begin
 if Not Active Then DatabaseError(E2058);
 Stream := TFileStream.Create(FileName, fmOpenRead);
 Try
  LoadFromStream(Stream, Mode);
 Finally
  Stream.Free;
 End;
End;

Function TKADaoTable.F_Get_Database:TKADaoDatabase;
Begin
 Result:=F_Database;
End;

Procedure TKADaoTable.F_Set_Database(Value:TKADaoDatabase);
Begin
 if Active Then DatabaseError(E2011);
 F_Database:=Value;
End;

Function TKADaoTable.F_Get_DateCreated:String;
Begin
 Result := '';
 if F_Active Then
    Begin
     Try
      if TableType=dbOpenTable Then Result:=F_DaoTable.DateCreated
      Else
      if F_QueryDefName <> '' then Result:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].DateCreated;
     Except
     End;
    End;
End;

Function TKADaoTable.F_Get_LastUpdated:String;
Begin
 Result := '';
 if F_Active Then
    Begin
     Try
      if TableType=dbOpenTable Then Result:=F_DaoTable.LastUpdated
      Else
      if F_QueryDefName <> '' then Result:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].LastUpdated;
     Except
     End;
    End;
End;

Function TKADaoTable.F_Get_TableName:String;
Begin
 Result:= F_TableName;
End;

Procedure TKADaoTable.F_Set_TableName(Value:String);
Begin
  if Active Then DatabaseError(E2012);
  F_TableName:=Value;
  if Value <> '' Then
     Begin
      F_IndexName:='';
      F_IndexFieldCount:=0;
      F_SQL.Clear;
      F_QueryDefName:='';
      F_QueryDefParameters.Clear;
      F_SortedBy.Clear;
     End;
End;

Procedure TKADaoTable.F_Set_SQL(Value:TStrings);
Begin
 F_SQL.SetText(Value.GetText);
 if Length(Value.GetText) > 0 Then
    Begin
     F_QueryDefParameters.Clear;
     F_QueryDefName:='';
     F_IndexName:='';;
     F_IndexFieldCount:=0;
     F_TableName:='';
    End;                      
End;

Procedure TKADaoTable.F_Set_QueryDefName(Value:String);
Begin
  Try
    if Assigned(F_Database) And (F_Database.Connected) Then
       Begin
         F_QueryDefSQLText.Clear;
         if Value <> '' Then F_QueryDefSQLText.SetText(PChar(F_Database.GetQueryDefSQLText(Value)));
       End;
  Except
  End;
  F_QueryDefName:=Value;
  F_QueryDefType:=F_Get_QueryDefType;
  if Value <> '' Then
     Begin
      F_IndexName:='';
      F_IndexFieldCount:=0;
      F_TableName:='';
      F_SQL.Clear;
      F_QueryDefParameters.Clear;
      F_Master.Clear;
      F_Detail.Clear;
      F_MasterFields.Clear;
      MasterLink.DataSource:=Nil;
      if (F_TableType=dbOpenTable)
      Or (F_TableType=dbOpenDynamic) Then F_TableType:=dbOpenDynaset;
     End;
End;



Function TKADaoTable.F_Get_IndexName:String;
Begin
 Result:= F_IndexName;
End;

Procedure TKADaoTable.F_Set_IndexName(Value:String);
Begin
  if Active Then
     Begin
       if (TableType=dbOpenTable) And (Value <> '') Then
          Begin
             F_SortedBy.Clear;
             F_DaoTable.Index  := Value;
             F_IndexFieldCount := F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[Value].Fields.Count;
             ClearBuffers;
             CheckBrowseMode;
             ActivateBuffers;
             First;
          End
       Else if Value <> '' Then DatabaseError(E2013);
     End
   Else
     Begin
       if (TableType=dbOpenTable) And (Value <> '') Then
          Begin
            F_SortedBy.Clear;
          End
       Else if Value <> '' Then DatabaseError(E2013);
     End;
  F_IndexName:=Value;
End;

Function  TKADaoTable.F_Get_IndexFieldNames:String;
Var
  X     : Integer;
  Count : Integer;
Begin
  Result := '';
  if F_IndexName='' Then Exit;
  Count := F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[F_IndexName].Fields.Count-1;
  For X := 0 To  Count do
      Begin
        if X = Count Then
           Result := Result + F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[F_IndexName].Fields.Item[X].Name
        Else
           Result := Result + F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[F_IndexName].Fields.Item[X].Name+';';
      End;
End;

Function  TKADaoTable.FindGoodIndex(KeyFields:String):String;
Var
  KF    :  TStringList;
  X,Y,Z :  Integer;
  C     :  Integer;
  NI    :  Integer;
  II    :  Integer;
  BR    :  Integer;
  Exact :  Boolean;
  Value :  String;
Begin
  Result := '';
  if TableType <> dbOpenTable then Exit;
  Value := KeyFields;
  if Value='' Then Exit;
  if Value[1]='!' Then
     Begin
      Exact:=True;
      System.Delete(Value,1,1);
     End
  Else
     Begin
       Exact:=False;
     End;
  KF := TStringList.Create;
  StringToList(Value,KF);
  C := KF.Count;
  if C=0 Then Begin KF.Free; Exit; End;
  NI := F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Count;
  For X :=0 To NI-1 Do
      Begin
        II := F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Fields.Count;
        if Exact Then
           Begin
           if II = C Then
            Begin
             BR:=0;
             For Y := 0 to II-1 do
                 Begin
                   For Z := 0 To C-1 do
                       if AnsiCompareText(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Fields.Item[Y].Name,KF.Strings[Z])=0 Then Inc(BR);
                 End;
             if BR=C Then
                Begin
                  Result:=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Name;
                  KF.Free;
                  Exit;
                End;
            End;
           End
        Else
           Begin
           if II >= C Then
            Begin
             BR:=0;
             For Y := 0 to II-1 do
                 Begin
                   For Z := 0 To C-1 do
                       if AnsiCompareText(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Fields.Item[Y].Name,KF.Strings[Z])=0 Then Inc(BR);
                 End;
             if BR=C Then
                Begin
                  Result := F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Name;
                  KF.Free;
                  Exit;
                End;
            End;
           End;
      End;
  KF.Free;
End;

Procedure TKADaoTable.F_Set_IndexFieldNames(Value:String);
Var
  S : String;
Begin
  if TableType <> dbOpenTable then Exit;
  if Value='' Then Exit;
  S:=FindGoodIndex(Value);
  if S <> '' Then F_Set_IndexName(S);
End;

Function TKADaoTable.F_Get_IndexField(Index: Integer): TField;
Var
 FieldName:String;
Begin
 Result := Nil;
 if NOT Active Then DatabaseError(E2014);
 if F_IndexName='' Then Exit;
 Try
  FieldName:=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[F_IndexName].Fields.Item[Index].Name;
 Except
  Exit;
 End;
 Result := FindField(FieldName);
End;

Procedure TKADaoTable.F_Set_IndexField(Index: Integer; Value: TField);
Begin
 //******************************************************************* Read Only
End;

Procedure TKADaoTable.F_SetBatchMode(Value:Boolean);
Begin
 F_BatchMode := Value;
 if Value Then DisableControls Else EnableControls; 
 if Not Value Then GetRecNo;
End;

Procedure TKADaoTable.F_Set_TableType(Value:Integer);
Begin
  if Active Then DatabaseError(E2015);
  F_TableType:=Value;
  if F_TableType=dbOpenTable Then
     Begin
       F_SortedBy.Clear;
     End
  Else
     Begin
       F_IndexName:='';
     End;
  if F_TableType=dbOpenForwardOnly Then F_SortedBy.Clear;
End;

Procedure TKADaoTable.F_Set_LockType(Value:Integer);
Begin
  if Active Then DatabaseError(E2016);
  F_LockType:=Value;
End;

Procedure TKADaoTable.F_Set_OpenOptions(Value:TOOSet);
Begin
  F_OpenOptions:=Value;
  if F_Active Then
     Begin
       ClearBuffers;
       CheckBrowseMode;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
End;

Procedure TKADaoTable.LockTable(LockType: TLockType);
Var
  OO:TOOSet;
Begin
  if LockType = ltReadLock  Then OO := F_OpenOptions+[dbDenyRead];
  if LockType = ltWriteLock Then OO := F_OpenOptions+[dbDenyWrite];
  if Active Then F_Set_OpenOptions(OO);
End;

Procedure TKADaoTable.UnlockTable(LockType: TLockType);
Var
  OO:TOOSet;
Begin
  if LockType = ltReadLock  Then OO := F_OpenOptions-[dbDenyRead];
  if LockType = ltWriteLock Then OO := F_OpenOptions-[dbDenyWrite];
  if Active Then F_Set_OpenOptions(OO);
End;

Procedure TKADaoTable.F_Set_ReadOnly(Value:Boolean);
Begin
  if Active Then DatabaseError(E2017);
  if Assigned(F_Database) And (F_Database.Connected) and (F_Database.ReadOnly) And (NOT Value) Then
     Begin
       Value := True;
     End;
  F_ReadOnly:=Value;
End;

Procedure TKADaoTable.F_Set_LockEdits(Value:Boolean);
Begin
  if (Active) Then
     Begin
       F_DaoTable.LockEdits:=Value;
     End;
  F_LockEdits :=Value;
End;

Procedure TKADaoTable.F_Set_Sort(Value:TStrings);
Begin
 F_SortedBy.SetText(Value.GetText);
 F_IndexName:='';
 if F_Active Then
    Begin
     ClearBuffers;
     CheckBrowseMode;
     CloseDaoRecordset;
     OpenDaoRecordset;
     ActivateBuffers;
     First;
    End;
End;

Procedure TKADaoTable.F_Set_QueryDefParameters(Value:TStrings);
Begin
 F_QueryDefParameters.SetText(Value.GetText);
End;

Procedure TKADaoTable.F_Set_QueryDefSQLText(Value:TStrings);
Begin
//*************************** READ ONLY
End;

Function TKADaoTable.F_Get_QueryDefType:String;
Var
 QDType : Integer;
Begin
 Result:='';
 QueryDefTypeInt:=0;
 Try
  if Assigned(F_Database) And (F_Database.Connected) And (F_QueryDefName <> '') Then
    Begin
      {$IFDEF DYNADAO}
      QDType:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].Type;
      {$ELSE}
      QDType:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].Type_;
      {$ENDIF}
      if QDType=dbQSelect         Then Begin Result := 'dbQSelect'        ; QueryDefTypeInt := dbQSelect         ; End;
      if QDType=dbQProcedure      Then Begin Result := 'dbQProcedure'     ; QueryDefTypeInt := dbQProcedure      ; End;
      if QDType=dbQAction         Then Begin Result := 'dbQAction'        ; QueryDefTypeInt := dbQAction         ; End;
      if QDType=dbQCrosstab       Then Begin Result := 'dbQCrosstab'      ; QueryDefTypeInt := dbQCrosstab       ; End;
      if QDType=dbQDelete         Then Begin Result := 'dbQDelete'        ; QueryDefTypeInt := dbQDelete         ; End;
      if QDType=dbQUpdate         Then Begin Result := 'dbQUpdate'        ; QueryDefTypeInt := dbQUpdate         ; End;
      if QDType=dbQAppend         Then Begin Result := 'dbQAppend'        ; QueryDefTypeInt := dbQAppend         ; End;
      if QDType=dbQMakeTable      Then Begin Result := 'dbQMakeTable'     ; QueryDefTypeInt := dbQMakeTable      ; End;
      if QDType=dbQDDL            Then Begin Result := 'dbQDDL'           ; QueryDefTypeInt := dbQDDL            ; End;
      if QDType=dbQSQLPassThrough Then Begin Result := 'dbQSQLPassThrough'; QueryDefTypeInt := dbQSQLPassThrough ; End;
      if QDType=dbQSetOperation   Then Begin Result := 'dbQSetOperation'  ; QueryDefTypeInt := dbQSetOperation   ; End;
      if QDType=dbQSPTBulk        Then Begin Result := 'dbQSPTBulk'       ; QueryDefTypeInt := dbQSPTBulk        ; End;
      if QDType=dbQCompound       Then Begin Result := 'dbQCompound'      ; QueryDefTypeInt := dbQCompound       ; End;
    End;
 Except
 End;
End;


Function TKADaoTable.F_ComposeSQL(SQL:TStrings):String;
Var
 X       : Integer;
{$IFDEF USEPARAMS}
 {$IFNDEF VER100}
  {$IFNDEF VER110}
 S, Sep  : String;
  {$ENDIF}
 {$ENDIF}
{$ENDIF}
Begin
 Result:='';
 For X:=0 To SQL.Count-1 do
     Begin
       Result := Result+SQL.Strings[X];
       if X <  SQL.Count-1 Then Result := Result+' ';
     End;
 {$IFDEF USEPARAMS}
  {$IFNDEF VER100}
   {$IFNDEF VER110}
 if F_ParamCheck then
    Begin
      For X := 0 to F_Params.Count - 1 do
        Begin
            Case F_Params[X].DataType of
                 ftDate, ftTime       : Sep := '#';
                 ftUnknown, ftString  : Sep := '"';
            else
                Sep := '';
            end;
            S := Sep + F_Params[X].AsString + sep;
            Result := StringReplace(Result, ':' + F_Params[X].Name, S,[rfReplaceAll, rfIgnoreCase]);
        end;
    End;
   {$ENDIF}
  {$ENDIF}
 {$ENDIF}
End;

Procedure TKADaoTable.F_Set_Filtered(Value:Boolean);
var
  Old_Filtered : Boolean;
Begin
  Old_Filtered := F_Filtered;
  Try
    F_Filtered:=Value;
    if F_Active Then
       Begin
         ClearBuffers;
         CheckBrowseMode;
         CloseDaoRecordset;
         OpenDaoRecordset;
         ActivateBuffers;
         First;
       End;
    Inherited Filtered:=Value;
  Except
    F_Filtered := Old_Filtered;
    Raise;
  End;
End;

Procedure TKADaoTable.F_Set_CacheMemos(Value:Boolean);
Begin
  F_CacheMemos:=Value;
  if (csLoading in ComponentState) Then Exit;
  if (F_Active) Then
     Begin
       Close;
       Open;
       First;
     End;
End;

Procedure TKADaoTable.F_Set_Filter(Value:String);
Begin
  F_Filter:=Value;
  if (F_Active) And (F_Filtered) Then
     Begin
       ClearBuffers;
       CheckBrowseMode;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
  Inherited Filter:=Value;
End;

Procedure TKADaoTable.F_Set_OnFilterRecord(Value: TFilterRecordEvent);
Begin
  F_OnFilterRecord:=Value;
  if (F_Active) And (F_Filtered) Then
     Begin
       ClearBuffers;
       CheckBrowseMode;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
  Inherited OnFilterRecord:=Value;
End;

//******************************************************************************
Function TKADaoTable.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
Begin
  Result:=TKBlobStream.Create(Field As TBlobField,Mode);
End;

Function TKADaoTable.InternalCalcRecordSize:Integer;
Begin
 F_RecordSize:=0;
 Result:=F_RecordSize;
End;


Procedure TKADaoTable.GetQueryDefReturnParams(QueryDefName:String);
Var
  X, Dir, NRP : Integer;
Begin
  if (NOT Assigned(F_Database)) OR (NOT F_Database.Connected) Then Exit;
  if NOT VarIsNull(QueryDefReturnParams) Then QueryDefReturnParams:=NULL;
  NRP:=0;
 Try
  For X:=0 To F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
      Begin
        Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
        if (Dir=dbParamOutput) Or (Dir=dbParamInputOutput) Or (Dir=dbParamReturnValue) Then Inc(NRP);
        F_Database.Idle;
      End;
  if NRP=0 Then Exit;
  if NRP=1 Then
      Begin
       QueryDefReturnParams:=F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[0].Name+'='+F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[0].Value;
      End
  Else
      Begin
        QueryDefReturnParams:=VarArrayCreate([0, NRP],varVariant);
        For X:=0 To F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
           Begin
             Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
             if (Dir=dbParamOutput) Or (Dir=dbParamInputOutput) Or (Dir=dbParamReturnValue) Then
                QueryDefReturnParams[X]:=F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Name+'='+F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Value;
       End;
     End;
 Except
 End;
End;

Function TKADaoTable.ProcessDTDefault(S:String):String;
Var
 P         : Integer;
 M,D,Y     : Integer;
 Ho,Mi,
 Se,Ms     : Integer;
 DT        : TDateTime;
 DTS       : TTimeStamp;
Begin
 Result := '';
 if S = '' Then Exit;
 Try
 Ho := 0;
 Mi := 0;
 Se := 0;
 Ms := 0;
 P := Pos('/',S);
 //********************************** Mesec
 M :=0;
 if P > 0 Then
    Begin
     M := StrToInt(Copy(S,1,P-1));
     System.Delete(S,1,P);
    End;
  //********************************** Den
  D := 0;
  P := Pos('/',S);
  if P > 0 Then
     Begin
      D := StrToInt(Copy(S,1,P-1));
      System.Delete(S,1,P);
     End;
  //********************************** Godina
  P := Pos(' ',S);
  if P=0 Then
     Begin
       Y := StrToInt(S);
       DT:=EncodeDate(Y,M,D);
       DTS:=DateTimeToTimeStamp(DT);
       S:=IntToStr(DTS.Date)+' '+IntToStr(DTS.Time);
     End
  Else
     Begin
       Y := StrToInt(Copy(S,1,P-1));
       System.Delete(S,1,P);

       //********************************** Chasove
       Ho :=0;
       P := Pos(':',S);
       if P > 0 Then
          Begin
           Ho := StrToInt(Copy(S,1,P-1));
           System.Delete(S,1,P);
          End;
       //********************************** Minuti
       Mi := 0;
       P := Pos(':',S);
       if P > 0 Then
          Begin
           Mi := StrToInt(Copy(S,1,P-1));
           System.Delete(S,1,P);
          End;
       //********************************** Secundi
       Se :=0;
       if S <> '' Then Se := StrToInt(S);
       //********************************** MiliSecundi
       Ms := 0;
     End;

  //********************************** Encode All
  DT:=EncodeTime(Ho,Mi,Se,Ms);
  DTS:=DateTimeToTimeStamp(DT);
  S:=IntToStr(DTS.Time);
  DT:=EncodeDate(Y,M,D);
  DTS:=DateTimeToTimeStamp(DT);
  //********************************** Compose Result
  S:=IntToStr(DTS.Date)+' '+S;
  Except
   S:='';
  End;
  Result := S;
End;

Procedure TKADaoTable.OpenDaoRecordset;
Var
 X         : Integer;
 L         : Integer;
 S         : String;
 FldType   : Integer;
 FldAttr   : Integer;
 FldCount  : Integer; 
 TabType   : Integer;
 LoType    : Integer;
 Options   : Integer;
 {$IFDEF DYNADAO}
 TempRS    : OleVariant;
 {$ELSE}
 TempRS    : Recordset;
 {$ENDIF}
 TabN      : String;
 TempSort  : String;
 NRP, Dir  : Integer;
Begin
        if Not Assigned(F_Database) Then
           Begin
             DatabaseError(E2018);
           End;
        if (TableName='') And
           (SQL.Count=0)  And
           (QueryDefName='')
        Then DatabaseError(E2019);
        if F_Database.Connected= False Then DatabaseError(E2020);
        if (F_TableType=dbOpenDynamic) And (F_Database.DatabaseType <> 'ODBC') Then DatabaseError(E2021);
        TabType:=F_TableType;
        LoType:=F_LockType;

        if (F_Database.ReadOnly) And (NOT F_ReadOnly) Then F_ReadOnly:=True;
        if F_TableType=dbOpenForwardOnly Then F_ReadOnly:=True;
        if F_TableType=dbOpenSnapshot Then F_ReadOnly:=True;

        Options:=0;
        if dbDenyWrite      in F_OpenOptions Then Options:=Options + DAOApi.dbDenyWrite;
        if dbDenyRead       in F_OpenOptions Then Options:=Options + DAOApi.dbDenyRead;
        if dbReadOnly       in F_OpenOptions Then Options:=Options + DAOApi.dbReadOnly;
        if dbAppendOnly     in F_OpenOptions Then Options:=Options + DAOApi.dbAppendOnly;
        if dbInconsistent   in F_OpenOptions Then Options:=Options + DAOApi.dbInconsistent;
        if dbConsistent     in F_OpenOptions Then Options:=Options + DAOApi.dbConsistent;
        if dbSQLPassThrough in F_OpenOptions Then Options:=Options + DAOApi.dbSQLPassThrough;
        if dbFailOnError    in F_OpenOptions Then Options:=Options + DAOApi.dbFailOnError;
        if dbForwardOnly    in F_OpenOptions Then Options:=Options + DAOApi.dbForwardOnly;
        if dbSeeChanges     in F_OpenOptions Then Options:=Options + DAOApi.dbSeeChanges;
        if dbRunAsync       in F_OpenOptions Then Options:=Options + DAOApi.dbRunAsync;
        if dbExecDirect     in F_OpenOptions Then Options:=Options + DAOApi.dbExecDirect;


        {$IFDEF DYNADAO}
           if NOT VarIsNull(F_DetailRecordset) Then F_DetailRecordset.Close;
           F_DetailRecordset:=NULL;
        {$ELSE}
           if F_DetailRecordset <> NIL Then F_DetailRecordset.Close;
           F_DetailRecordset:=NIL;
        {$ENDIF}

        RecordsAffected:=0;
        TabN:=TableName;
        if F_SQL.Count > 0 Then TabN:=F_ComposeSQL(F_SQL);
        if F_QueryDefName <> '' Then
           Begin
             TabN:=F_QueryDefName;
             NRP:=0;
               For X:=0 To Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count-1 do
                 Begin
                   Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
                   if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
                       Begin
                        Try
                         Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[X].Value:=F_QueryDefParameters.Strings[NRP];
                         Inc(NRP);
                        Except
                         DatabaseError(E2022);
                        End;
                       End;
                 End;
           End;
        if (F_QueryDefName <> '') And (Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count > 0) Then
            Begin
                F_QueryDefSQLText.Clear;
                if Assigned(F_Database) And (F_Database.Connected) Then
                   F_QueryDefSQLText.SetText(PChar(F_Database.GetQueryDefSQLText(TabN)));
                Database.CoreDatabase.QueryDefs.Item[TabN].MaxRecords:=F_QueryDefMaxRecords;
                if F_Database.QueryTimeout <> 60 Then
                F_Database.CoreDatabase.QueryDefs.Item[TabN].ODBCTimeout:=F_Database.QueryTimeout;
                F_DaoTable:=Database.CoreDatabase.QueryDefs.Item[TabN].OpenRecordset(TabType,Options,LoType);
                GetQueryDefReturnParams(TabN);
            End
        Else
            Begin
               F_QueryDefSQLText.Clear;
               if (F_QueryDefName <> '') Then
                   Begin
                     F_QueryDefSQLText.SetText(PChar(F_Database.GetQueryDefSQLText(TabN)));
                     Database.CoreDatabase.QueryDefs.Item[TabN].MaxRecords:=F_QueryDefMaxRecords;
                     if F_Database.QueryTimeout <> 60 Then
                     F_Database.CoreDatabase.QueryDefs.Item[TabN].ODBCTimeout:=F_Database.QueryTimeout;
                     F_DaoTable:=Database.CoreDatabase.QueryDefs.Item[TabN].OpenRecordset(TabType,Options,LoType);
                     F_Database.Idle;
                   End
               Else
                   Begin
                     F_DaoTable:=Database.CoreDatabase.OpenRecordset(TabN,TabType,Options,LoType);
                     F_Database.Idle;
                   End;
            End;

        F_Bookmarkable := F_DaoTable.Bookmarkable;
        InternalClearBookmarks;

        F_Database.Idle;
        F_Database.RefreshDefinitions;
        RecordsAffected:=F_Database.CoreDatabase.RecordsAffected;

        //******************************************************** Setting Index
        if F_IndexName <> '' Then
           Begin
             Try
               F_DaoTable.Index:=F_IndexName;
             Except
               //******** May raise exception when table is empty
             End;
           End;
        //**********************************************************************
        FldCount := F_DaoTable.Fields.Count;
        //******************************************* Default Values
        F_UpdatableFields.Clear;
        F_DefaultValues.Clear;
        //********************************* Fast Open without quering properties
        For X :=0 To FldCount-1 do
         Begin
           F_DefaultValues.Add('');
           F_UpdatableFields.Add(Pointer(True));
         End;
        //**********************************************************************
        if (NOT F_ReadOnly) And (F_UseDaoProperties) Then
         Begin
          F_UpdatableFields.Clear;
          F_DefaultValues.Clear;
          For X :=0 To FldCount-1 do
            Begin
             {$IFDEF DYNADAO}
             FldType := F_DaoTable.Fields.Item[X].Type;
             {$ELSE}
             FldType := F_DaoTable.Fields.Item[X].Type_;
             {$ENDIF}
             FldAttr := F_DaoTable.Fields.Item[X].Attributes;
             F_UpdatableFields.Add(Pointer(False));
             if (FldAttr And dbUpdatableField) > 0 Then
                Begin
                 if (FldAttr And dbAutoIncrField) = 0 Then
                    Begin
                      if (FldAttr And dbSystemField) = 0 Then
                          Begin
                           F_UpdatableFields.Items[X]:=Pointer(True);
                          End;
                    End;
                End;
             Try
                //**************************************************************
                S:=F_DaoTable.Fields.Item[X].DefaultValue;
                //**************************************************************
                if (FldType=dbText) or (FldType=dbMemo) Then
                   Begin
                     L := Length(S);
                     if (L > 1) And (S[1]='"') And (S[L]='"') Then
                        Begin
                          System.Delete(S,L,1);
                          System.Delete(S,1,1);
                        End;
                   End;
                if (FldType=dbDate) Then
                   Begin
                     L := Length(S);
                     if (L > 1) And (S[1]='#') And (S[L]='#') Then
                        Begin
                          System.Delete(S,L,1);
                          System.Delete(S,1,1);
                          S:=ProcessDTDefault(S);
                        End
                      Else
                        S := '';
                   End;
                F_DefaultValues.Add(S);
                if AnsiCompareText(F_DefaultValues.Strings[X],'Null')=0 Then F_DefaultValues.Strings[X] := '';
              Except
                F_DefaultValues.Add('');
              End;
            End;
         End;
        if F_SortedBy.Count > 0 Then
           Begin
             TempSort:='';
             For X:=0 To F_SortedBy.Count-1 Do
                Begin
                  TempSort:=TempSort+F_SortedBy.Strings[X];
                  if X < F_SortedBy.Count-1 Then TempSort:=TempSort+',';
                  TempSort:=TempSort+' ';
                  F_Database.Idle;
                End;
             F_DaoTable.Sort:=TempSort;
             TempRS:=F_DaoTable;
             F_DaoTable:=TempRS.OpenRecordset(TabType,Options);
             TempRS.Close;
             {$IFDEF DYNADAO}
             TempRS:=NULL;
             {$ELSE}
             TempRS:=Nil;
             {$ENDIF}
           End;
        if F_Filtered Then
           Begin
             if Filter<>'' Then
                Begin
                 F_DaoTable.Filter:=Filter;
                 TempRS:=F_DaoTable;
                 F_DaoTable:=TempRS.OpenRecordset(TabType,Options);
                 TempRS.Close;
                 {$IFDEF DYNADAO}
                 TempRS:=NULL;
                 {$ELSE}
                 TempRS:=Nil;
                 {$ENDIF}
                End;
           End;
        if (MasterSource <> NIL) And (Assigned(F_MasterLink.DataSet)) Then
           Begin
             F_MDisabled := Not (F_MasterLink.DataSet.Active);
             if (F_MDisabled) And (F_MasterAutoActivate) Then
                Begin
                  Try
                    F_MasterLink.DataSet.Active := True;
                  Finally
                    F_MDisabled := Not (F_MasterLink.DataSet.Active);
                  End;
                End;
           End
        Else
           Begin
             F_MDisabled := True;
           End;
        if (MasterSource <> NIL) And (Not(F_MDisabled)) then
            Begin
              F_ProcessMasterFields(F_MasterFields);
              if (F_Master.Count > 0) Then
                  Begin
                   if F_SQL.Count > 0 Then RefreshQueryParams;
                   TabN:=BuildDetailSQL;
                   TabN:=InsertSQLString(TabN);
                   F_DaoTable.Filter:=TabN;
                   F_DetailRecordset:=F_DaoTable;
                   F_DaoTable:=F_DetailRecordset.OpenRecordset(TabType,Options);
                  End;
            End;
        //********************************************************** COM Cashing
        VarArrayRedim(DaoFields,Integer(FldCount-1));
        For X := 0 To FldCount-1 do
            Begin
              DaoFields[X] := OleVariant(F_DaoTable.Fields[X]);
            End;
        //********************************************************** COM Cashing
        CoreRecordset := F_DaoTable;
        if  (F_Database.DatabaseType <> 'ODBC')
        And (NOT F_Database.ReadOnly)
        And (NOT F_ReadOnly) Then
           Begin
             If (F_TableType = dbOpenTable)
             Or (F_TableType = dbOpenDynaset) Then F_DaoTable.LockEdits:=F_LockEdits;
           End;
       F_RefreshRC := True;
       F_OldRC:=-1;
End;

Procedure TKADaoTable.ReOpenDaoRecordset;
Var
  TabN : String;
  X    : Integer;
Begin
  InternalClearBookmarks;
  TabN:=BuildDetailSQL;
  TabN:=InsertSQLString(TabN);
  OleVariant(F_DetailRecordset).Requery;
  F_DetailRecordset.Filter:=TabN;
  {$IFDEF DYNADAO}
  F_DaoTable:=F_DetailRecordset.OpenRecordset(EmptyParam,dbSeeChanges);
  {$ELSE}
  F_DaoTable:=F_DetailRecordset.OpenRecordset(EmptyParam,dbSeeChanges);
  {$ENDIF}
  CoreRecordset := F_DaoTable;
  if  (F_Database.DatabaseType <> 'ODBC')
  And (NOT F_Database.ReadOnly)
  And (NOT F_ReadOnly) Then
  Begin
    If (F_TableType = dbOpenTable)
    Or (F_TableType = dbOpenDynaset) Then F_DaoTable.LockEdits:=F_LockEdits;
  End;
  //**************************************************************** COM Cashing
  VarArrayRedim(DaoFields,Integer(F_DaoTable.Fields.Count-1));
  For X := 0 To F_DaoTable.Fields.Count-1 do
      Begin
        DaoFields[X] := OleVariant(F_DaoTable.Fields[X]);
      End;
  //****************************************************************************
  F_RefreshRC := True;
  F_OldRC:=-1;
  GetRecordCount;
End;

Procedure TKADaoTable.Loaded;
begin
  try
    inherited Loaded;
  except
    Application.HandleException(Self)
  end;
end;


Procedure TKADaoTable.InternalOpen;
Var
   X       : Integer;
   TempMD  : Boolean;
   FF      : TField;
Begin
        OpenDaoRecordset;
        if Self.Name='' Then Self.Name:='KADaoTable_'+IntToStr(GetTickCount);
        F_Database.ActiveTableNames.AddObject(Self.Name,Self);
        InternalInitFieldDefs;
        if DefaultFields then CreateFields;
        BindFields(True);
        if F_UseDisplayLabels Then InternalSetDisplayLabels;
        F_RecNo:=-1;
        F_LastRecord:=-1;
        BookmarkSize:=MYBOOKMARKSIZE;
        F_StartMyInfo:=InternalCalcRecordSize;
        F_StartCalc:=F_StartMyInfo+SizeOf(TDaoInfo);
        F_BufferSize:=F_RecordSize+Sizeof(TDaoInfo)+CalcFieldsSize;
        //****************************************************************
        TempMD:=F_MDisabled;
        F_MDisabled:= True;
        F_FieldNames.Clear;
        F_MDFieldNames.Clear;
        For X:=0 to FieldDefs.Count-1 do
            Begin
             FF  :=FindField(FieldDefs.Items[X].Name);
             if (FF <> Nil) Then
                Begin
                 If (NOT FF.IsBlob) Then
                    Begin
                      F_FieldNames.Add(FieldDefs.Items[X].Name);
                      F_FieldTypeNames.Add(GetBDEFieldTypeNames(FieldDefs.Items[X].DataType));
                    End;
                 if (NOT (FF.DataType=ftBlob)) Then
                    Begin
                     F_MDFieldNames.Add(FieldDefs.Items[X].Name);
                    End;
                 if (FF.DataType=ftMemo) Then
                    Begin
                      if F_CacheMemos Then
                         Begin
                           FF.DisplayWidth:=30;
                           FF.OnGetText:=F_OnGetMemoText;
                         End;
                    End;
                End;
            End;
        F_MDisabled:=TempMD;

        F_OldValue          := Nil;
        F_KeyBuffer         := AllocRecordBuffer;
        F_RangeStartBuffer  := AllocRecordBuffer;
        F_RangeEndBuffer    := AllocRecordBuffer;

        F_Active:=True;
        InternalFirst;
        //****************************************************************
End;

Procedure TKADaoTable.CloseDaoRecordset;
Var
 X : Integer;
Begin
 //****************************************** Com Cashing
 For X :=0 To F_DaoTable.Fields.Count-1 do
     Begin
       DaoFields[X]:=NULL;
     End;
 //******************************************     
 Try
   F_DaoTable.Close;
 Except
 End;  
End;

Procedure TKADaoTable.InternalClose;
Var
  I : Integer;
Begin
        if Not F_Active Then Exit;
        Try
         if State=dsEdit Then OleVariant(F_DaoTable).CancelUpdate;
        Except
        End;
        //************************************************** Changed 16.11.2000
        F_Active:=False;
        //************************************************** Changed 16.11.2000
        BindFields(False);
        if DefaultFields then DestroyFields;
        CloseDaoRecordset;
        {$IFDEF DYNADAO}
        if NOT VarIsNull(F_DetailRecordset) Then F_DetailRecordset.Close;
        F_DetailRecordset := NULL;
        {$ELSE}
        if F_DetailRecordset <> Nil Then F_DetailRecordset.Close;
        F_DetailRecordset := NIL;
        {$ENDIF}
        if Assigned(F_Database) And (Not MainDatabaseShutdown) Then
           Begin
              I := F_Database.ActiveTableNames.IndexOf(Self.Name);
              if I <> -1 Then  F_Database.ActiveTableNames.Delete(I);
           End
        Else
           MainDatabaseShutdown  := False;
           
        if F_OldValue <> Nil then FreeRecordBuffer(F_OldValue);
        FreeRecordBuffer(F_KeyBuffer);
        FreeRecordBuffer(F_RangeStartBuffer);
        FreeRecordBuffer(F_RangeEndBuffer);
End;

//*********************************************************** BOOKMARK Functions
Procedure TKADaoTable.InternalClearBookmarks;
Begin
  F_BookmarkRN.Clear;
  F_BookmarkID.Clear;
End;


//******************************************************* NEW METHOD
Procedure TKADaoTable.InternalGotoBookmark(Bookmark: Pointer);
Var
  I       : Integer;
  X       : Integer;
  BK      : OleVariant;
  P       : PChar;
  Invalid : Boolean;
Begin
  Invalid := False;
  if NOT F_Active Then DatabaseError(E2023);
  X:=PInteger(Bookmark)^;
  if (F_Bookmarkable) And (X <> 0) Then
     Begin
      Try
        I:= F_BookmarkID.IndexOf(Pointer(X));
        if I = -1 Then
           Begin
             Invalid := True;
             DatabaseError(E2024);
           End
        Else
           Begin
             BK  := VarArrayCreate([0, 3],varByte);
             P:=PChar(Bookmark);
             For X := 0 to 3 do BK[X] := Ord(P[X]);
             OleVariant(F_DaoTable).Bookmark:=VarAsType(BK, varOleStr);
             BK:=NULL;
             F_RecNo:=Integer(F_BookmarkRN.Items[I]);
           End;
      Except
        if Invalid Then Raise;
      End;
     End
  Else
     Begin
       DatabaseError(E2025);
     End;
End;//******************************************************* NEW METHOD

Function TKADaoTable.BookmarkValid(Bookmark: TBookmark): Boolean;
Var
  TmpBookmark:TBookmark;
Begin
  Result := False;
  If (F_Active) And (F_Bookmarkable) And (Assigned(Bookmark)) then
  Begin
   TmpBookmark:=GetBookmark;
   Try
    CheckBrowseMode;
    CursorPosChanged;
    DoBeforeScroll;
    InternalGotoBookmark(Bookmark);
    Resync([RmExact, RmCenter]);
    DoAfterScroll;
    Result := True;
   Except
    if Assigned(TmpBookmark) Then
       Begin
        CursorPosChanged;
        DoBeforeScroll;
        InternalGotoBookmark(TmpBookmark);
        Resync([RmExact, RmCenter]);
        DoAfterScroll;
       End;
   End;
  End;
End;


Function TKADaoTable.GetBookmarkFlag(Buffer: PChar): TBookmarkFlag;
Begin
  Result:=PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkFlag;
End;

Procedure TKADaoTable.SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag);
Begin
  PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkFlag := Value;
  if (F_BatchMode) And (ControlsDisabled) Then
     Begin
       if (Value=bfEOF) or (Value=bfInserted) Then F_InPost := True;
     End;
End;

Function TKADaoTable.GetBookmarkStr: TBookmarkStr;
Var
 Buffer : PChar;
 RN     : Integer;
 I      : Integer;
Begin
  Result := '';
  Try
    if F_Bookmarkable Then
       Begin
         Buffer:=GetActiveRecordBuffer;
         if (Buffer <> Nil) Then
             Begin
               Result := AddLeadingZeros(IntToStr(PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData));
               RN     := PDaoInfo(Buffer + F_StartMyInfo)^.RecordNo;
               I      := F_BookmarkRN.IndexOf(Pointer(RN));
               if I=-1 Then
                  Begin
                   F_BookmarkRN.Add(Pointer(RN));
                   F_BookmarkID.Add(Pointer(PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData));
                  End
               Else
                  Begin
                   F_BookmarkID.Items[I]:=Pointer(PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData);
                  End;
             End
         Else
            Result := '';
       End
    Else
       Begin
         Result := AddLeadingZeros('0');
       End;
  Except
    Result := '';
  End;
End;

Procedure TKADaoTable.SetBookmarkStr(const Value: TBookmarkStr);         
var
 PBI : Integer;
Begin
 if (F_Bookmarkable) And (Value <> '') Then
     Begin
      //***************************************************** FOR FUTURE TESTING
      PBI:=StrToInt(Value);
      InternalGotoBookmark(@PBI);
      Resync([]);
      //************************************************************************
     End;
End;

Procedure TKADaoTable.GetBookmarkData(Buffer: PChar; Data: Pointer);
Var
  I  : Integer;
  RN : Integer;
Begin
  if (F_Bookmarkable) And (Buffer <> Nil) Then
    Begin
     PInteger(Data)^ := PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData;
     RN              := PDaoInfo(Buffer + F_StartMyInfo)^.RecordNo;
     I               := F_BookmarkRN.IndexOf(Pointer(RN));
     if I=-1 Then
        Begin
          F_BookmarkRN.Add(Pointer(RN));
          F_BookmarkID.Add(Pointer(PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData));
        End
      Else
        Begin
          F_BookmarkID.Items[I]:=Pointer(PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData);
        End;
    End
  Else
    Begin
     PInteger(Data)^ := 0;
    End;
End;

Procedure TKADaoTable.SetBookmarkData(Buffer: PChar; Data: Pointer);
Begin
     if (Buffer <> Nil) then PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData := PInteger(Data)^;
End;

Function TKADaoTable.CompareBookmarks(Bookmark1, Bookmark2: TBookmark): Integer;
Var
 S1,S2 : String;
Function CompareBookmarkMemory(Buf1,Buf2:PChar;Count:Integer):Integer;
 Var X:integer;
 Begin
   Result := 0;
   for X := 0 to Count-1 do
    Begin
      if Buf1[X] < Buf2[X] then
       Begin
          Result := -1;
          Exit;
       End
      Else
      if Buf1[X] > Buf2[X] then
       Begin
          Result := 1;
          Exit;
       End;
    End;
 End;
Const
  ResultCodes     : array[Boolean, Boolean] of ShortInt = ((2,-1),(1,0));
Begin
  Result := ResultCodes[Bookmark1 = nil, Bookmark2 = nil];
  If Result = 2 then
     Begin
      if (PChar(Bookmark1)[5] = #0) And (PChar(Bookmark2)[5] = #0) Then
         Begin
           S1 := Format('%d',[PInteger(Bookmark1)^]);
           S2 := Format('%d',[PInteger(Bookmark2)^]);
           S1:=AddLeadingZeros(S1);
           S2:=AddLeadingZeros(S2);
           Result := CompareBookmarkMemory(PChar(S1), PChar(S2), BookmarkSize);
         End
      Else
         Begin
           Result := CompareBookmarkMemory(Bookmark1, Bookmark2, BookmarkSize);
         End;
     End;
End;

//*********************************************************************************** BOOKMARK FunctionS

Function TKADaoTable.GetRows(NumRows:Integer):OleVariant;
Begin
  Result:=NULL;
  if (F_Active) And (F_Bookmarkable) Then
     Begin
      Result:=F_DaoTable.GetRows(NumRows);
      Inc(F_RecNo,NumRows);
      Try
        Resync([rmExact]);
      Except
        InternalFirst;
        Resync([]);
        Raise;
      End;
     End;
End;

Procedure TKADaoTable.InternalInitFieldDefs;
Var
  X        : Integer;
  Sz       : Integer;
  Typ      : Integer;
  ResTyp   : TFieldType;
  Nam      : String;
  F_Format : String;
Begin
        FieldDefs.Clear;
        F_DisplayLabels.Clear;
        with FieldDefs do
        Begin
          For X:=0 To F_DaoTable.Fields.Count-1 do
              Begin
                Typ  := DaoFields[X].Type;
                Nam := DaoFields[X].Name;
                Sz:=DaoSizeToBDESize(Typ,DaoFields[X].Size);
                if (Typ=dbDate) And (PropertyExists(OleVariant(DaoFields[X].Properties),'Format')) Then
                   Begin
                     F_Format:=DaoFields[X].Properties.Item['Format'].Value;
                     if AnsiCompareText(F_Format,'Long Time')=0    Then Typ:=dbTime
                        Else
                        if AnsiCompareText(F_Format,'Medium Time')=0  Then Typ:=dbTime
                           Else
                           if AnsiCompareText(F_Format,'Short Time')=0   Then Typ:=dbTime
                              Else
                                if AnsiCompareText(F_Format,'General Date')=0   Then Typ:=dbTimeStamp;
                   End
                Else
                   if (Typ=dbDate) Then Typ:=dbTimeStamp;
                   if (Typ=dbText) And (Sz=0) Then Sz:=255;
                   if (Typ=dbLong) And ((DaoFields[X].Attributes And dbAutoIncrField) > 0) Then Typ := dbAutoIncInteger;
                   //***********************************************************
                   ResTyp := DaoToBDE(Typ);
                   if F_ReadOnly Then
                      Add(Nam,ResTyp,Sz,False)
                   Else
                      if (F_UseDaoProperties) Then
                          Add(Nam,ResTyp,Sz,DaoFields[X].Required)
                      Else
                          Add(Nam,ResTyp,Sz,False);
                   if ResTyp=ftBlob Then F_DefaultValues.Strings[X] := '';
                   //***********************************************************
                if (F_UseDisplayLabels) And (PropertyExists(OleVariant(DaoFields[X].Properties),'Caption')) Then
                   F_DisplayLabels.Add(DaoFields[X].Properties['Caption'])
                Else
                   F_DisplayLabels.Add(Nam);
              End;
        End;
End;

Procedure TKADaoTable.InternalSetDisplayLabels;
Var
  X  : Integer;
  FF : TField;
Begin
 For X:=0 To FieldDefs.Count-1 do
  Begin
   FF := FindField(FieldDefs.Items[X].Name);
   if FF <> Nil Then FF.DisplayLabel:=F_DisplayLabels.Strings[X];
  End;
End;

Function TKADaoTable.GetActiveRecordBuffer:  PChar;
Begin
        case State of
             dsBrowse      : if IsEmpty Then
                                Result := Nil
                             Else
                                Result := ActiveBuffer;
             dsCalcFields  : Result    := CalcBuffer;
             dsFilter      : Result    := F_FilterBuffer;
             dsEdit        ,
             dsInsert      ,
             dsNewValue    ,
             dsCurValue    : Result    := ActiveBuffer;
             dsOldValue:     if F_OldValue=Nil then
                              Result   :=ActiveBuffer
                           Else
                              Result   := F_OldValue;
             dsSetKey      :  Result   := F_ActiveKeyBuffer;
        Else Result:=Nil;
        End;
End;


Procedure TKADaoTable.InternalHandleException;
Begin
     Application.HandleException(Self);
End;

Procedure TKADaoTable.ClearCalcFields(Buffer: PChar);
Begin
    FillChar(Buffer[F_StartCalc],CalcFieldsSize,0);
End;

Procedure TKADaoTable.F_OnGetMemoText(Sender: TField; var Text: String; DisplayText: Boolean);
Var
 P      : Integer;
 Buffer : PChar;
 DInfo  : TDaoInfo;
Begin
   if F_CacheMemos Then
      Begin
       Buffer := GetActiveRecordBuffer;
       if Buffer=Nil Then Exit;
       DInfo := PDaoInfo(Buffer+F_StartMyInfo)^;
       P := Pos(#13,DInfo.RecordData.Strings[Sender.FieldNo-1]);
       if P > 0 Then
          Text := Copy(DInfo.RecordData.Strings[Sender.FieldNo-1],1,P-1)
       Else
          Text := DInfo.RecordData.Strings[Sender.FieldNo-1];
      End
   Else
      Begin
        if DisplayText Then Text:='(Memo)' Else Text:='(MEMO)';
      End;
End;

Function TKADaoTable.GetFieldData(Field: TField; Buffer: Pointer): Boolean;
var
  SourceBuffer : PChar;
  Value        : TStringList;
  FieldNumber  : Integer;
  TempString   : String;
Begin
        Result:=False;
        SourceBuffer:=GetActiveRecordBuffer;
        if (not F_Active) or (SourceBuffer=nil) then
           Begin
              Exit;
           End;
        if (Field.FieldKind=fkCalculated) or (Field.FieldKind=fkLookup) then
          Begin
                Inc(SourceBuffer,F_StartCalc+Field.Offset);
                if (SourceBuffer[0]=#0) or (Buffer=nil) then
                  Begin
                    Exit;
                  End
                Else                                                    
                  Begin
                    Move(SourceBuffer[1], Buffer^, Field.DataSize);
                    Result:=True;
                  End;
          end
        else
          Begin
           Try
             Value :=PDaoInfo(PChar(SourceBuffer)+F_StartMyInfo)^.RecordData;
           Except
             Exit;
           End;
           FieldNumber:=Field.FieldNo-1;
           if (Value=Nil) Then Exit;
           if (Buffer = Nil)  Then
            Begin
              Result:=(Value.Strings[FieldNumber] <> '');
            End
               Else
            Begin
              Case Field.DataType of
                ftBytes     : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftInteger   : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftAutoInc   : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftSmallint  : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftCurrency  : Result:=FloatToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftFloat     : Result:=FloatToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftDate      : Result:=DateToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftString    : Begin
                                TempString:=Value.Strings[FieldNumber];
                                TempString:=TempString+#0;
                                CopyMemory(PChar(Buffer),PChar(TempString),Length(TempString));
                                Result := True;
                              End;
                ftTime      : Result:=TimeToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftDateTime  : Result:=DateTimeToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftBoolean   : Result:=BooleanToBuffer(Buffer,Value.Strings[FieldNumber]);
              End;
            End;
          End;
End;

Procedure TKADaoTable.SetFieldData(Field: TField; Buffer: Pointer);
var
        DestinationBuffer: PChar;
        Tmp              : String;
        BTmp             : WordBool;
        BBTmp            : Boolean;
Begin
        DestinationBuffer:=GetActiveRecordBuffer;
        if DestinationBuffer=Nil Then Exit;
        if (Field.FieldKind=fkCalculated) or (Field.FieldKind=fkLookup) then
           Begin
                Inc(DestinationBuffer,F_StartCalc+Field.Offset);
                Boolean(DestinationBuffer[0]):=(Buffer<>nil);
                if Boolean(DestinationBuffer[0]) then CopyMemory(@DestinationBuffer[1],Buffer,Field.DataSize);
           End
        Else
          Begin
            //************************************** Field Checking And Validation
            if Field.FieldKind in [fkData, fkInternalCalc] then Field.Validate(Buffer);
            if Field.ReadOnly Then DatabaseError(E2060);
            //********************************************************************
            Tmp:='';
            if Buffer <> Nil Then
               Begin
                 Case Field.DataType of
                  ftString     : Tmp := PChar(Buffer);
                  ftSmallint   : Tmp := IntToStr(Integer(Buffer^));
                  ftWord       : Tmp := IntToStr(Integer(Buffer^));
                  ftInteger    : Tmp := IntToStr(Integer(Buffer^));
                  ftAutoInc    : Tmp := IntToStr(Integer(Buffer^));

                  ftBCD        : Tmp := FloatToStr(Double(Buffer^));
                  ftCurrency   : Tmp := FloatToStr(Double(Buffer^));
                  ftFloat      : Tmp := FloatToStr(Double(Buffer^));

                  ftDate       : Tmp := BufferToDate(Buffer);
                  ftTime       : Tmp := BufferToTime(Buffer);
                  ftDateTime   : Tmp := BufferToDateTime(Buffer);
                  ftBoolean    : Begin
                                   BTmp := WordBool(Buffer^);
                                   BBTmp:=Boolean(BTmp);
                                   Case BBTmp Of
                                     True   : Tmp:= 'True';
                                     False  : Tmp:= 'False';
                                   End;
                                 End;
                 End;
               End;
            PDaoInfo(DestinationBuffer+F_StartMyInfo)^.RecordData.Strings[Field.FieldNo-1]:=Tmp;
            PDaoInfo(DestinationBuffer+F_StartMyInfo)^.RecordData.Objects[Field.FieldNo-1]:=TObject(True);
         End;
        DataEvent(deFieldChange, Longint(Field));
End;

Procedure TKADaoTable.InternalFirst;
Begin
  F_RecNo:=-1;
  F_RecPos:=-1;
  if (F_DaoTable.BOF) And (F_DaoTable.EOF) Then Exit;
  if F_TableType = dbOpenForwardOnly Then Exit;
  Try
   F_DaoTable.MoveFirst;
   F_DaoTable.MovePrevious;
  Except
  End;
End;

Procedure TKADaoTable.InternalLast;
Var
 TmpRS        : OleVariant;
 DoRaise      : Boolean;
 OldR         : Integer;
Begin
     if (F_DaoTable.BOF) And (F_DaoTable.EOF) Then Begin F_RecNo:=-1; Exit; End;
     DoRaise := False;
     Try
      if F_TableType = dbOpenForwardOnly Then
        Begin
         if NOT F_DaoTable.EOF Then
           Begin
            While NOT F_DaoTable.EOF Do
              Begin
                F_DaoTable.MoveNext;
                Inc(F_RecPos);
                F_RecNo:=F_RecPos;
              End;
             Dec(F_RecPos);
           End;
          F_RecNo:=F_RecPos;
        End
      Else
        Begin
         OleVariant(F_DaoTable).MoveLast;
         F_DaoTable.MoveNext;
         OldR    := F_RecNo;
         F_RecNo := F_DaoTable.RecordCount;
         if F_TableType = dbOpenTable Then
           Begin
            if (F_RecNo > F_LastRecord) Or (OldR > F_RecNo) Then
                Begin
                 TmpRS:=OleVariant(F_DaoTable).OpenRecordset(dbOpenSnapShot);
                 TmpRS.MoveLast;
                 F_RecNo:=TmpRS.RecordCount;
                 TmpRS.Close;
                 F_LastRecord:=F_RecNo;
                 if (F_RecNo <> F_DaoTable.RecordCount) And (F_WarnOnBadDatabase) Then
                    Begin
                      DoRaise := True;
                      DatabaseError(Format(E2026,[F_Database.Database]));
                    End;
                End;
           End;
        End;
     Except
       if DoRaise Then Raise;
     End;
End;

Procedure TKADaoTable.InternalMoveToBookmark(Bookmark: Pointer);
Var
  X       : Integer;
  BK      : OleVariant;
  P       : PChar;
Begin
   BK  := VarArrayCreate([0, 3],varByte);
   P:=PChar(Bookmark);
   For X := 0 to 3 do BK[X] := Ord(P[X]);
   OleVariant(F_DaoTable).Bookmark:=VarAsType(BK, varOleStr);
   BK:=NULL;
End;

Procedure TKADaoTable.InternalSetToRecord(Buffer: PChar);
Var
  RN     : Integer;
  Delta  : Integer;
  Err    : String;
Begin
  if (F_DaoTable.BOF) And (F_DaoTable.EOF) Then Exit;
  if Buffer=Nil Then Exit;
  IF PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkFlag in [bfCurrent, bfInserted] Then
     Begin
       RN:=F_RecNo;
       F_RecNo:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordNo;
       if F_TableType = dbOpenForwardOnly Then Exit;
       if State = dsSetKey Then Exit;
       if F_Bookmarkable Then
          Begin
            Try
             if (State <> dsEdit) And (State <> dsInsert) Then
             InternalMoveToBookmark(@PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkData);
            Except
              //****************************************** HANDLE DELETED RECORD
              Err := GetLastDaoError.Description;
              Try
                InternalFirst;
                Resync([rmCenter]);
                DatabaseError(Err);
              Finally
              End;
              //****************************************** HANDLE DELETED RECORD
            End;
          End
       Else
          Begin
           Delta:=F_RecNo-RN;
           if Delta=0 Then Exit;
           Try
             If ((F_Filtered) And (Assigned(F_OnFilterRecord))) Or (F_RangeFiltered) Then
                 Begin
                  F_DaoTable.MoveFirst;
                  OleVariant(F_DaoTable).Move(F_RecNo);
                 End
             Else
                 Begin
                   OleVariant(F_DaoTable).Move(Delta);
                 End;
           Except
             F_DaoTable.MoveFirst;
             OleVariant(F_DaoTable).Move(F_RecNo);
           End;
          End;
    End;
End;

Procedure TKADaoTable.InternalEdit;
Var
  PS : PChar;
  PT : PChar;
Begin
     Try
       F_DaoTable.Edit;
     Except
       //******************************** Edit Conflict with other user.
       if GetLastDaoError.ErrNo=3167 Then
          Begin
            InternalRefresh;
          End;
       //***************************************************************
       Raise;
     End;
     inherited InternalEdit;
     //*************************************************************************
     if F_OldValue <> Nil then FreeRecordBuffer(F_OldValue);
     F_OldValue:=AllocRecordBuffer;
     PT := F_OldValue+F_StartMyInfo;
     PS := GetActiveRecordBuffer;
     if PS <> Nil Then
        Begin
         PS := PS+F_StartMyInfo;
         PDaoInfo(PT)^.BookmarkData := PDaoInfo(PS)^.BookmarkData;
         PDaoInfo(PT)^.BookmarkFlag := PDaoInfo(PS)^.BookmarkFlag;
         PDaoInfo(PT)^.RecordNo := PDaoInfo(PS)^.RecordNo;
         PDaoInfo(PT)^.RecordData.SetText(PDaoInfo(PS)^.RecordData.GetText);
        End;
     //*************************************************************************
End;

Procedure TKADaoTable.InternalCancel;
Begin
     Try
       if (State=dsEdit) Then OleVariant(F_DaoTable).CancelUpdate;
     Except
     End;
     if F_OldValue <> Nil Then FreeRecordBuffer(F_OldValue);
     inherited InternalCancel;
End;

Procedure TKADaoTable.InternalPost;
Label Again;
Var
 Buffer    : PChar;
 X         : Integer;
 RData     : TStringList;
 S         : String;
 DTSV      : OleVariant;
 FF        : TField;
 Action    : TDataAction;
 JumpAgain : Boolean;
Begin
 F_PostMade := False;
 CheckActive;
 Again:
 JumpAgain := False;
 if State = dsEdit then //***************************************************** EDITING A RECORD
  Begin
    Buffer:=GetActiveRecordBuffer;
    RData:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordData;
    For X:=0 to RData.Count-1 do
        Begin
        FF:=FindField(FieldDefs.Items[X].Name);
        if (Boolean(RData.Objects[X])) And (FF <> Nil) Then
         Begin
          S:=RData.Strings[X];
          if Boolean(F_UpdatableFields.Items[X]) Then
             Begin
               if S='' Then
                  Begin
                    DaoFields[X].Value:=NULL
                  End
               Else
                  Begin
                    if (FF.DataType=ftDate) or
                       (FF.DataType=ftTime) or
                       (FF.DataType=ftDateTime) Then
                       Begin
                         DTSV:=ComposeDateTimeVariant(S);
                         if DTSV <> NULL Then DaoFields[X].Value:=VarAsType(DTSV,VarDate);
                         DTSV:=NULL;
                       End
                    Else
                       Begin
                         if (FF.IsBlob) Then
                            Begin
                              DTSV := StringToBlob(FF As TBlobField, S);
                              DaoFields[X].Value:=DTSV;
                              DTSV:=NULL;
                            End
                         Else
                            Begin
                              DaoFields[X].Value:=S;
                            End;
                       End;
                  End;
             End;
         End;
        End;
    Try
      OleVariant(F_DaoTable).Update;
    Except
      On E:Exception do
           Begin
            If Assigned(OnPostError) Then
               Begin
                   OnPostError(Self,EDatabaseError(E),Action);
                   if Action = daRetry Then
                      Begin
                        JumpAgain := True;
                      End
                   Else
                   if Action = daAbort Then
                      Begin
                        CursorPosChanged;
                        OleVariant(F_DaoTable).CancelUpdate;
                        SetState(dsBrowse);
                        InternalRefresh;
                      End
                   Else
                   if Action = daFail  Then Raise;
               End
            Else
               Begin
                 CursorPosChanged;
                 OleVariant(F_DaoTable).CancelUpdate;
                 SetState(dsBrowse);
                 InternalRefresh;
                 Raise;
               End;
           End;
    End;
    if JumpAgain Then Goto Again;
  End
 Else
  Begin //****************************************************************** ADDING A NEW RECORD
    Buffer:=GetActiveRecordBuffer;
    RData:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordData;
    F_DaoTable.AddNew;
    For X:=0 to RData.Count-1 do
        Begin
         FF:=FindField(FieldDefs.Items[X].Name);
         if (Boolean(RData.Objects[X])) And (FF <> Nil) Then
         Begin
          S:=RData.Strings[X];
          if Boolean(F_UpdatableFields.Items[X]) Then
             Begin
               if S='' Then
                  Begin
                    DaoFields[X].Value:=NULL
                  End
               Else
                  Begin
                    if (FF.DataType=ftDate) or
                       (FF.DataType=ftTime) or
                       (FF.DataType=ftDateTime) Then
                        Begin
                          DTSV:=ComposeDateTimeVariant(S);
                          if DTSV <> NULL Then DaoFields[X].Value:=VarAsType(DTSV,VarDate);
                          DTSV:=NULL;
                        End
                    Else
                        Begin
                          if (FF.IsBlob) Then
                             Begin
                               DTSV := StringToBlob(FF As TBlobField, S);
                               DaoFields[X].Value:=DTSV;
                               DTSV:=NULL;
                             End
                          Else
                             Begin
                               DaoFields[X].Value:=S;
                             End;
                         End;
                  End;
             End;
          End;
        End;
      Try
        OleVariant(F_DaoTable).Update;
      Except
        On E:Exception do
           Begin
            If Assigned(OnPostError) Then
               Begin
                   OnPostError(Self,EDatabaseError(E),Action);
                   if Action = daRetry Then
                      Begin
                        JumpAgain := True;
                      End
                   Else
                   if Action = daAbort Then
                      Begin
                        CursorPosChanged;
                        OleVariant(F_DaoTable).CancelUpdate;
                      End
                   Else
                   if Action = daFail Then Raise;
               End
            Else
               Begin
                 CursorPosChanged;
                 OleVariant(F_DaoTable).CancelUpdate;
                 Raise;
               End;
           End;
      End;
      if JumpAgain Then Goto Again;
      Try
       //************************************************* CHANGED AT 06.01.2001
       F_RefreshRC := True;
       Inc(F_LastRecord);
       Inc(F_RecNo);
       If Not F_Bookmarkable Then
          Begin
           InternalLast;
           PDaoInfo(Buffer+F_StartMyInfo)^.RecordNo:=F_RecNo-1;
          End;
       //***********************************************************************
      Except
      End;
  End;
  If F_Bookmarkable Then
     Begin
       PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkData:=GetDaoLastModifiedBookMark(F_DaoTable);
       InternalMoveToBookmark(@PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkData);
     End;
  if F_OldValue <> Nil Then FreeRecordBuffer(F_OldValue);
  F_PostMade := True;
End;

Procedure TKADaoTable.Post;
Begin
  F_InPost   := True;
  Try
    Inherited Post;
  Finally
    F_InPost := False;
  End;
End;

Procedure TKADaoTable.InternalAddRecord(Buffer: Pointer; Append: Boolean);
Begin
    if Append Then InternalLast;
    InternalPost;
End;

Procedure TKADaoTable.InternalDelete;
Var
  Buffer : PChar;
  X      : Integer;
  I      : Integer;
  RN     : Integer;
  RR     : Integer;
Begin
  Buffer := GetActiveRecordBuffer;
  if Buffer=Nil Then Exit;
  RN     := PDaoInfo(Buffer + F_StartMyInfo)^.RecordNo;
  I      := F_BookmarkRN.IndexOf(Pointer(RN));
  if I > -1 Then
     Begin
       F_BookmarkRN.Delete(I);
       F_BookmarkID.Delete(I);
     End;
  For X:=0 to F_BookmarkRN.Count-1 do
      Begin
       RR := Integer(F_BookmarkRN.Items[X]);
       if RR > RN Then
          Begin
            Dec(RR);
            F_BookmarkRN.Items[X]:=Pointer(RR);
          End;
      End;
  F_DaoTable.Delete;
  F_RefreshRC := True;
  IF (F_DaoTable.EOF) then OleVariant(F_DaoTable).MoveLast Else F_DaoTable.MoveNext;
End;

Procedure TKADaoTable.RollbackRefresh;
Begin
 ClearBuffers;
 CloseDaoRecordset;
 OpenDaoRecordset;
 ActivateBuffers;
 First;
End;

Procedure TKADaoTable.InternalRefresh;
Var
  TempRecNo:Integer;
Begin
    Try
     F_RefreshRC := True;
     Resync([rmExact, rmCenter]);
    Except
     TempRecNo:=F_RecNo;
     ClearBuffers;
     CloseDaoRecordset;
     OpenDaoRecordset;
     ActivateBuffers;
     First;
     if TempRecNo < RecordCount Then MoveBy(TempRecNo) Else Last;
    End;
End;

Function TKADaoTable.IsCursorOpen: Boolean;
Begin
  Result:=F_Active;
End;

Function TKADaoTable.GetCanModify: Boolean;
Begin
 Result:= NOT F_ReadOnly;
End;

Function TKADaoTable.GetRecordSize: Word;
Begin
  Result:=F_BufferSize;
End;

Function TKADaoTable.AddLeadingZeros(Value:String):String;
Const
  Zeros='0000000000000000';
Var
  L : Integer;
Begin
  Result := Value;
  L:=Length(Value);
  if L < MYBOOKMARKSIZE Then
     Begin
       L:=MYBOOKMARKSIZE-L;
       Result:=Copy(Zeros,1,L)+Result;
     End;
End;

Function TKADaoTable.AllocRecordBuffer: PChar;
Var
  X:Integer;
Begin
        GetMem(Result,F_BufferSize);
        FillChar(Result^,F_BufferSize,0);
        PDaoInfo(Result+F_StartMyInfo)^.RecordData:=TStringList.Create;
        For X:=0 To FieldDefs.Count-1 do
          Begin
            PDaoInfo(Result+F_StartMyInfo)^.RecordData.AddObject('',TObject(False));
          End;
End;

Procedure TKADaoTable.FreeRecordBuffer(var Buffer: PChar);
Begin
        if Buffer=Nil Then Exit;
        PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Free;
        PDaoInfo(Buffer+F_StartMyInfo)^.RecordData:=Nil;
        FreeMem(Buffer,F_BufferSize);
        Buffer:=Nil;
End;

Procedure TKADaoTable.InternalInitRecord(Buffer: PChar);
Var
  X          : Integer;
  PT         : PChar;
  PS         : PChar;
Begin
     //*************************************************************************
     if F_OldValue <> Nil Then FreeRecordBuffer(F_OldValue);
     F_OldValue:=AllocRecordBuffer;
     PT := F_OldValue+F_StartMyInfo;
     PS := GetActiveRecordBuffer;
     if PS <> Nil Then
        Begin
         PS := PS+F_StartMyInfo;
         PDaoInfo(PT)^.BookmarkData := PDaoInfo(PS)^.BookmarkData;
         PDaoInfo(PT)^.BookmarkFlag := PDaoInfo(PS)^.BookmarkFlag;
         PDaoInfo(PT)^.RecordNo := PDaoInfo(PS)^.RecordNo;
         PDaoInfo(PT)^.RecordData.SetText(PDaoInfo(PS)^.RecordData.GetText);
        End;
     //*************************************************************************
     For X:=0 To FieldDefs.Count-1 do
          Begin
            PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Objects[X]:=TObject(False);
            PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Strings[X]:=F_DefaultValues.Strings[X];
          End;
     PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkFlag := bfInserted;
     PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkData := 0;
     PDaoInfo(Buffer+F_StartMyInfo)^.RecordNo     := -1;
End;

Function TKADaoTable.GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult;
var
 Acceptable : Boolean;
 X          : Integer;
 RD         : Variant;
 DTS        : TTimeStamp;
 FF         : TField;
 ReadData   : Boolean;
Begin
   Result:=grOK;
   Acceptable:=False;
   //********************************************************* SKIP UNUSUAL READ
   if (ControlsDisabled) And
      (F_InPost)         And
      (F_BatchMode)      And
      (GetMode <> gmCurrent) Then
      Begin
         if NOT (F_Filtered And Assigned(F_OnFilterRecord)) Then
            Begin
             Result:=grEOF;
             Exit;
            End;
      End;
   //***************************************************************************
   Repeat
    Case GetMode of
       gmCurrent:
          Begin
            Result:=grOK;
            if F_DaoTable.EOF Then Result:=grEOF;
            if F_DaoTable.BOF Then Result:=grBOF;
          End;
       gmNext:
          Begin
             if F_DaoTable.EOF Then Result:=grEOF
             Else
                Begin
                  if F_DaoTable.BOF Then
                     Begin
                       if F_TableType <> dbOpenForwardOnly Then F_DaoTable.MoveFirst;
                     End
                  Else
                     Begin
                       if F_TableType = dbOpenForwardOnly Then
                          Begin
                             if F_RecNo <> -1 Then
                                Begin
                                  F_DaoTable.MoveNext;
                                  Inc(F_RecPos);
                                End;
                          End
                       Else
                          F_DaoTable.MoveNext;
                     End;
                  Inc(F_RecNo);
                  if F_DaoTable.EOF then Result:=grEOF;
                End;
          End;
       gmPrior:
         Begin
           //************************************************ Changed 12.01.2001
           //IF F_RecNo > -1  Then
           If NOT F_DaoTable.BOF Then                
           //*******************************************************************
             Begin
              if F_TableType <> dbOpenForwardOnly Then
                Begin
                  Result:=grOK;
                  F_DaoTable.MovePrevious;
                  Dec(F_RecNo);
                  if F_DaoTable.BOF Then
                     Begin
                       Result:=grBOF;
                       F_RecNo:=-1;
                     End;
                End
                Else  Result:=grError;
             End
           Else
             Begin
               Result:=grBOF;
             End;
         End;
    End;{CASE}
    //**************************************************************************
    if Result=grEOF Then
       Begin
         F_LastRecord := F_RecNo;
       End
    Else
       Begin
         if F_LastRecord < F_RecNo Then F_LastRecord := F_RecNo;
       End;
    //**************************************************************************
    if Result=grOk then
       Begin
        With PDaoInfo(Buffer+F_StartMyInfo)^ do
          Begin
            if F_Bookmarkable Then
               BookmarkData:=GetDaoBookmark(F_DaoTable)
            Else
               BookmarkData:=0;
            RecordNo     := F_RecNo;
            BookmarkFlag := bfCurrent;
            For X:=0 To FieldDefs.Count-1 do
              Begin
                FF := FindField(FieldDefs.Items[X].Name);
                if FF <> Nil Then
                   Begin
                     ReadData := True;
                     if (FF.IsBlob) Then
                        Begin
                          ReadData := False;
                          if  (FF.DataType = ftMemo)
                          And (F_CacheMemos) Then ReadData := True;
                        End;
                     if ReadData Then
                        Begin
                         Try
                           RD:=DaoFields[X].Value;
                         Except
                           RD:=NULL;
                           //******************** Edit Conflict with other user.
                           if GetLastDaoError.ErrNo=3167 Then
                              Begin
                                Result:=grError;
                                Exit;
                              End;
                           //***************************************************
                         End;
                        End
                     Else RD:=''; //************************* EMPTY BLOB
                     if VarType(RD) = varNull then RD := ''
                     Else
                     if (FF.DataType=ftDateTime)
                     Or (FF.DataType=ftDate)
                     Or (FF.DataType=ftTime)
                     Then
                      Begin
                        DTS:=DateTimeToTimeStamp(VarAsType(RD,varDate));
                        RD:=IntToStr(DTS.Date)+' '+IntToStr(DTS.Time);
                      End
                      Else
                        if (FF.DataType=ftBoolean) Then
                           Begin
                             if RD Then RD := 'True' Else RD := 'False';
                           End;
                        RecordData.Strings[X]:=RD;
                        RecordData.Objects[X]:=TObject(False);
                        RD:=NULL;
                   End;
          End;
        End; {WITH}
        ClearCalcFields(Buffer);
        GetCalcFields(Buffer);
        Acceptable:=FilterRecord(Buffer);
        if (GetMode=gmCurrent) And (Not Acceptable) Then Result:=grError;
       End;
   Until (Result <> grOk) or (Acceptable);
End;

Function TKADaoTable.FilterRecord(Buffer: PChar): Boolean;
var
  SaveState: TDatasetState;
Begin
 Result:=True;
 if F_RangeFiltered Then Result:=FilterRange(Buffer);
 if (F_Filtered) And (Result) And (Assigned(F_OnFilterRecord)) Then
    Begin
      SaveState:=SetTempState(dsFilter);
      F_FilterBuffer:=Buffer;
      OnFilterRecord(Self,Result);
      RestoreState(SaveState);
    End;
End;


Function TKADaoTable.GetRecordCount: Integer;
var
  SaveState    : TDataSetState;
  SavePosition : Integer;
  TempBuffer   : PChar;
  TmpRS        : OleVariant;
  DoRaise      : Boolean;
Begin
 Result:=-1;
 if F_TableType=dbOpenForwardOnly Then Exit;
 if F_UseRecordCountCache Then
    Begin
     if NOT F_RefreshRC Then
        Begin
         Result := F_OldRC;
         F_LastRecord:=Result;
         Exit;
        End;
    End;
 DoRaise     := False;
 F_RefreshRC := False;
 if (F_DaoTable.BOF) And (F_DaoTable.EOF) Then
    Begin
      Result:=0;
      F_OldRC:=Result;
      F_LastRecord:=Result;
      F_RecNo := -1;
      Exit;
    End;
 If ((F_Filtered) And (Assigned(F_OnFilterRecord))) Or (F_RangeFiltered) Then
     Begin
       Result:=0;
       SaveState:=SetTempState(dsBrowse);
       SavePosition:=F_RecNo;
       Try
         TempBuffer:=AllocRecordBuffer;
         InternalFirst;
         While GetRecord(TempBuffer,gmNext,True)=grOk do Inc(Result);
       Finally
         RestoreState(SaveState);
         F_RecNo:=SavePosition;
         FreeRecordBuffer(TempBuffer);
       End;
     End
 Else
     Begin
      if F_TableType=dbOpenTable Then
         Begin
           Try
            Result:=F_DaoTable.RecordCount;
            if (Result > F_LastRecord) Then
               Begin
                TmpRS:=OleVariant(F_DaoTable).OpenRecordset(dbOpenSnapShot);
                TmpRS.MoveLast;
                Result:=TmpRS.RecordCount;
                TmpRS.Close;
                TmpRS:=NULL;
                if (Result <> F_DaoTable.RecordCount) And (F_WarnOnBadDatabase) Then
                   Begin
                     DoRaise := True;
                     DatabaseError(Format(E2026,[F_Database.Database]));
                   End;
               End;
           Except
             if DoRaise Then Raise;
           End;
         End
      Else
         Begin
          Try
           F_DaoTable.MoveFirst;
           OleVariant(F_DaoTable).MoveLast;
           Result:=F_DaoTable.RecordCount;
           Except
           End;
          End;
      if F_Bookmarkable Then
         Begin
           TempBuffer := GetActiveRecordBuffer;
           if TempBuffer <> Nil Then
           InternalMoveToBookmark(@PDaoInfo(TempBuffer+F_StartMyInfo)^.BookmarkData);
         End
     Else
         Begin
           F_DaoTable.MoveFirst;
           if F_RecNo=-1 Then
            Begin
             F_DaoTable.MovePrevious;
            End
           Else
            Begin
             if (F_RecNo < Result) Then OleVariant(F_DaoTable).Move(F_RecNo);
            End;
         End;
     End;
     F_OldRC:=Result;
     F_LastRecord:=Result;
End;

Function  TKADaoTable.GetRecNo: Integer;
var
  SaveState: TDataSetState;
  SavePosition: integer;
  TempBuffer: PChar;
Begin
  UpdateCursorPos;
  if NOT F_UseGetRecNo Then
     Begin
       Result := -1;
       Exit;
     End;

  if F_RecNo<-1 Then F_PostMade:=True;

  if F_RecNo=-1 Then
     Begin
       Result := -1;
       Exit;
     End;
  If ((F_Filtered) And (Assigned(F_OnFilterRecord)))  Or (F_RangeFiltered) Then
    Begin
     Result := -1;
     SaveState:=SetTempState(dsBrowse);
     TempBuffer:=GetActiveRecordBuffer;
     if TempBuffer <> Nil Then
        Begin
          SavePosition:=PDaoInfo(TempBuffer+F_StartMyInfo)^.BookmarkData;
          Try
           TempBuffer:=AllocRecordBuffer;
           InternalFirst;
           Result := 0;
           While (GetRecord(TempBuffer,gmNext,True)=grOk) And
                 (PDaoInfo(TempBuffer+F_StartMyInfo)^.BookmarkData <> SavePosition)
                 do Inc(Result);
          Finally
           if (PDaoInfo(TempBuffer+F_StartMyInfo)^.BookmarkData <> SavePosition) Then
              Begin
               InternalSetToRecord(GetActiveRecordBuffer); 
              End;
           FreeRecordBuffer(TempBuffer);
          End;
        End;
     RestoreState(SaveState);
     if Result=-1 Then Exit;
    End
 Else
    Begin
      if F_PostMade Then
         Begin
          TempBuffer:=GetActiveRecordBuffer;
          if TempBuffer <> Nil Then
             Begin
              F_RecNo:=-1;
              While Not F_DaoTable.BOF Do
                Begin
                 Inc(F_RecNo);
                 F_DaoTable.MovePrevious;
                End;
              PDaoInfo(TempBuffer+F_StartMyInfo)^.RecordNo:=F_RecNo;
              InternalMoveToBookmark(@PDaoInfo(TempBuffer+F_StartMyInfo)^.BookmarkData);
              F_PostMade:=False;
              DoBeforeScroll;
              CursorPosChanged;
              Resync([]);
              DoAfterScroll;
             End;
         End;
      Result:=F_RecNo;
    End;
 Inc(Result);
End;

Procedure TKADaoTable.SetRecNo(Value: Integer);
Var
 SaveState      : TDataSetState;
 SavePosition   : Integer;
 TempBuffer     : PChar;
Begin
  CheckBrowseMode;
  CursorPosChanged;
  DoBeforeScroll;
  If ((F_Filtered) And (Assigned(F_OnFilterRecord))) Or (F_RangeFiltered) Then
     Begin
       SaveState:=SetTempState(dsBrowse);
       SavePosition:=F_RecNo;
       try
         TempBuffer:=AllocRecordBuffer;
         InternalFirst;
         Repeat
           Begin
             if GetRecord(TempBuffer,gmNext,True)=grOk Then
               Begin
                Dec(Value);
               End
             Else
               Begin
                 F_RecNo  := SavePosition;
                 Break;
               End;
           End;
         Until Value=0;
       Finally
         RestoreState(SaveState);
         FreeRecordBuffer(TempBuffer);
       End;
     End
  Else
     Begin
      F_RecNo := (Value-1);
      F_DaoTable.MoveFirst;
      OleVariant(F_DaoTable).Move(F_RecNo);
     End;
  Resync([rmExact,rmCenter]);
  DoAfterScroll;
end;

Procedure TKADaoTable.StringToList(Items: String; List: TStringList);
var
  X: Integer;
Begin
  For X:= 1 To Length(Items) Do If Items[X] = ';' Then Items[X]:= #13;
  List.Clear;
  List.Text:=Items;
  For X:= 0 To List.Count - 1 Do List[X]:= Trim(List[X]);
End;

Procedure TKADaoTable.VariantToList(Items: Variant; List: TStringList);
Var
   X    : Integer;
   V    : Variant;
   Count: Integer;
Begin
   List.Clear;
   if VarIsArray(Items) Then
      Begin
        Count:=(VarArrayHighBound(Items, 1) - VarArrayLowBound(Items, 1))+1;
        For X:=0 to Count-1 do
            Begin
             V:=Items[VarArrayLowBound(Items, 1) + X];
             if VarIsNull(V) Then
                List.Add('NULL')                         
             Else
                List.Add(VarAsType(V,VarString));
            End;
      End
   Else
      Begin
         V:=Items;
         if VarIsNull(V) Then
            List.Add('NULL')
         Else
            List.Add(VarAsType(V,VarString));
      End;
End;

Procedure TKADaoTable.AssignVarValue(Var V :Variant; const Value: TVarRec);
Begin
  with Value do
    case VType of
      vtInteger:
        V := VInteger;
      vtBoolean:
        V := VBoolean;
      vtChar:
        V := VChar;
      vtExtended:
        V := VExtended^;
      vtString:
        V := VString^;
      vtPointer:
        if VPointer <> nil then DatabaseError(E2027);
      vtPChar:
        if VPChar <> nil then DatabaseError(E2027);
      vtObject:
         DatabaseError('Invalid object');
      vtAnsiString:
        V := string(VAnsiString);
      vtCurrency:
        V := VCurrency^;
      vtVariant:
        if not VarIsEmpty(VVariant^) then V := VVariant^;
    else
      DatabaseError(E2027);
    End;
End;

Function  TKADaoTable.BuildKeySQL(KN,KV:TStringList):String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if KN.Count > 0 Then
     Begin
      For X:=0 To KN.Count-1 do
         Begin
          S:=S+'(';
          if F_UseBrackets Then S:=S+'[';
          S:=S+KN.Strings[X];
          if F_UseBrackets Then S:=S+']';
          S:=S+' ';
          FT :=FieldByName(KN.Strings[X]);
          if KV.Strings[X]='NULL' Then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftString,
             ftMemo     : S:= S + ' = "' + KV.Strings[X] + '"';
             ftBoolean,
             ftCurrency,
             ftFloat,
             ftSmallint,
             ftWord,
             ftAutoInc,
             ftInteger : S:= S + ' = ' + KV.Strings[X];
             ftDate    : Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy', StrToDateTime(KV.Strings[X])) + '#';
                         End;
             ftTime    : Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                         End;
             ftDateTime: Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                         End;

             Else
             DatabaseError(E2028)
          End;
          S:=S+')';
          if (X < KN.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

Function  TKADaoTable.BuildLocateSQL(KN,KV:TStringList;Options: TLocateOptions):String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if KN.Count > 0 Then
     Begin
      For X:=0 To KN.Count-1 do
         Begin
          S:=S+'(';
          FT :=FieldByName(KN.Strings[X]);
          if F_UseBrackets Then S:=S+'[';
          S:=S+KN.Strings[X];
          if F_UseBrackets Then S:=S+']';
          S:=S+' ';
          if KV.Strings[X]='NULL' Then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftString,
             ftMemo     :  Begin
                             if loCaseInsensitive in Options Then KV.Strings[X]:=AnsiLowerCase(KV.Strings[X]);
                             If loPartialKey in Options Then
                                Begin
                                  if loCaseInsensitive in Options Then
                                     Begin
                                       if Pos('*',KV.Strings[X]) > 0 Then
                                         S:= S + ' LIKE LCASE("' + KV.Strings[X] + '")'
                                       Else
                                         S:= S + ' LIKE LCASE("' + KV.Strings[X] + '*")';
                                     End
                                  Else
                                     Begin
                                       if Pos('*',KV.Strings[X]) > 0 Then
                                         S:= S + ' LIKE "' + KV.Strings[X] + '"'
                                       Else
                                         S:= S + ' LIKE "' + KV.Strings[X] + '*"';
                                     End;
                                End
                             Else
                                Begin
                                  if loCaseInsensitive in Options Then
                                     Begin
                                       S:= S + ' = LCASE("' + KV.Strings[X] + '")';
                                     End
                                   Else
                                     Begin
                                       S:= S + ' = "' + KV.Strings[X] + '"';
                                     End;
                                End;
                           End;
             ftBoolean,
             ftCurrency,
             ftFloat,
             ftSmallint,
             ftWord,
             ftAutoInc,
             ftInteger : S:= S + ' = ' + KV.Strings[X];
             ftDate    : Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy', StrToDateTime(KV.Strings[X])) + '#';
                         End;
             ftTime    : Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                         End;
             ftDateTime: Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                         End;
             Else
             DatabaseError(E2029)
          End;
          S:=S+')';
          if (X < KN.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

Function  TKADaoTable.BuildDetailSQL:String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if F_Master.Count <> F_Detail.Count Then
     Begin
       DatabaseError(E2030);
     End;
if F_Master.Count > 0 Then
     Begin
      For X:=0 To F_Master.Count-1 do
         Begin
          S:=S+'(';
          if F_UseBrackets Then S:=S+'[';
          S:=S+F_Detail.Strings[X];
          if F_UseBrackets Then S:=S+']';
          S:=S+' ';
          FT :=F_MasterLink.Dataset.FieldByName(F_Master.Strings[X]);
          if FT.IsNull then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftString,
             ftMemo     : S:= S + ' = "' + FT.AsString + '"';
             ftCurrency,
             ftFloat,
             ftSmallint,
             ftWord,
             ftAutoInc,
             ftInteger : S:= S + ' = ' + FT.AsString;
             ftBoolean : If FT.AsBoolean then S:= S + ' = True' Else S:= S + ' = False';
             ftDate    : S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy', FT.AsDateTime) + '#';
             ftTime    : S:= S + ' = #' + FormatDateTime('hh":"nn":"ss', FT.AsDateTime) + '#';
             ftDateTime: S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy hh":"nn":"ss', FT.AsDateTime) + '#';
             Else
             DatabaseError(E2031)
          End;
          S:=S+')';
          if (X < F_Master.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

//***************************************************************************************
Function TKADaoTable.GetDaoLastModifiedBookMark(RS:Variant):Integer;
Var
 TempBK : Pointer;
Begin
 Result:=0;
 if (RS.BOF) And (RS.EOF) Then Exit;
 if F_Bookmarkable Then
    Begin
      TempBK:=TVarData(RS.LastModified).VPointer;
      Result:=PInteger(PSafeArray(TempBK)^.pvData)^;
    End
 Else
    Begin
      Result := 0;
    End;
End; 


Function  TKADaoTable.GetDaoBookMark(RS:Variant):Integer;
Var
 TempBK : Pointer;
Begin
 Result:=0;
 if (RS.BOF) Or (RS.EOF) Then Exit;
 if F_Bookmarkable Then
    Begin
      TempBK:=TVarData(RS.Bookmark).VPointer;
      Result:=PInteger(PSafeArray(TempBK)^.pvData)^;
    End
 Else
    Begin
      Result := 0;
    End;
End;



Function TKADaoTable.GetFieldIndexName(FiledName:String):String;
Var
  X,Y : Integer;
Begin
 if Assigned(F_Database) And (F_Database.Connected) Then
 Begin
 Try
  For X :=0 To F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Count-1 do
      Begin
        For Y := 0 To F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[X].Fields.Count-1 do
            Begin
              if AnsiCompareText(FiledName,F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[X].Fields.Item[Y].Name)=0 Then
                 Begin
                  Result :=F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[X].Name;
                  Exit;
                 End;
            End;
      End;
  Except
  End;
  End;
  Result := '';
End;

Function TKADaoTable.CheckFieldsInIndex(KF:TStringList):Boolean;
Var
  X,Y  : Integer;
  OK   : Boolean;
Begin
  Result := False;
  if F_IndexName='' Then Exit;
  if (NOT Assigned(F_Database))  Or (NOT F_Database.Connected) Then Exit;
  For X :=0 To KF.Count-1 do
      Begin
        OK :=False;
        For Y:=0 To F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[F_IndexName].Fields.Count-1 do
            Begin
             if AnsiCompareText(KF.Strings[X],F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[F_IndexName].Fields.Item[Y].Name)=0 Then OK :=True;
            End;
        if Not OK Then Exit;
      End;
  Result := True;
End;

Function  TKADaoTable.Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean;
Var
 KF       : TStringList;
 KV       : TStringList;
 X        : Integer;
 CR       : Integer;
 RI       : Integer;
 FN       : Integer;
 Find     : Boolean;
 S1,S2    : String;
 L        : Integer;
 Filter   : String;
 KVV      : Array[0..12] of OleVariant;
 IdxC     : Integer;
 IndexOK  : Boolean;
 CompText : String;
 //*************************************
 BK       : Integer;
 TempRS   : OleVariant;
 FPP      : Single;
 APOK     : Boolean;
 //*************************************
Begin
 Result:=False;
 if IsEmpty Then Exit;
 If ((F_Filtered) And (Assigned(F_OnFilterRecord))) Or (F_RangeFiltered) Then Exit;
 if (NOT Assigned(F_Database))  Or (NOT F_Database.Connected) Then Exit;
 KF := TStringList.Create;
 KV :=  TStringList.Create;
 StringToList(KeyFields,KF);
 VariantToList(KeyValues,KV);
 If (KF.Count <> KV.Count)  Then DatabaseError(E2032);
 //*****************************************************************************
 APOK := False;
 if     (F_TableType=dbOpenDynaset)
     OR (F_TableType=dbOpenSnapshot)
     OR (F_TableType=dbOpenDynamic) Then APOK:=True;
 //*****************************************************************************
 InternalSetToRecord(GetActiveRecordBuffer);
 CR:=F_RecNo;
 if F_Bookmarkable Then
    Begin
      TempRS:=F_DaoTable.Clone;
      //************************************************** BLOCKED at 24.01.2001
      // IndexOK := CheckFieldsInIndex(KF);
      //************************************************************************               
      IndexOK:=(F_IndexName<>'');
      if (TableType=dbOpenTable) And (IndexOK) Then
         Begin
           For X:=0 to 12 do KVV[X]:=VarNull;
           IdxC:=F_Database.CoreDatabase.TableDefs[F_TableName].Indexes[F_IndexName].Fields.Count;
           For X:=0 to IdxC-1 do
               Begin
                 L:=KF.IndexOf(F_Database.CoreDatabase.TableDefs[F_TableName].Indexes[F_IndexName].Fields.Item[X].Name);
                 if L <> -1 Then
                    Begin
                      KVV[X]:=KV.Strings[L];
                    End;
               End;
           CompText := '=';
           if KF.Count <> F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[F_IndexName].Fields.Count Then CompText := '>=';
           TempRS.Index:=F_IndexName;
           TempRS.MoveFirst;
           if IdxC=1 Then OleVariant(TempRS).Seek(CompText,KVV[0])
           Else
           if IdxC=2 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1])
           Else
           if IdxC=3 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2])
           Else
           if IdxC=4 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2],KVV[3])
           Else
           if IdxC=5 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4])
           Else
           if IdxC=6 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5])
           Else
           if IdxC=7 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6])
           Else
           if IdxC=8 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7])
           Else
           if IdxC=9 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8])
           Else
           if IdxC=10 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9])
           Else
           if IdxC=11 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9],KVV[10])
           Else
           if IdxC=12 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9],KVV[10],KVV[11])
           Else
           if IdxC=13 Then OleVariant(TempRS).Seek(CompText,KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9],KVV[10],KVV[11],KVV[12]);
         End
      Else
         Begin
           if (TableType=dbOpenTable) Then DatabaseError(E2062);
           Filter:=BuildLocateSQL(KF,KV,Options);
           TempRS.MoveFirst;
           OleVariant(TempRS).Move(CR);
           TempRS.FindFirst(Filter);
         End;
      Find:=NOT TempRS.NoMatch;
      if (Find) Then
          Begin
            Result:= True;
            BK:=GetDaoBookMark(TempRS);
            CheckBrowseMode;
            CursorPosChanged;
            DoBeforeScroll;
            if APOK Then
               Begin
                 CR := TempRS.AbsolutePosition;
               End
            Else
               Begin
                  FPP := TempRS.PercentPosition;
                  CR := Round((FPP*RecordCount)/100);
                  TempRS.MoveFirst;
                  TempRS.Move(CR);
                  While GetDaoBookmark(TempRS) <> BK do
                    Begin
                     TempRS.MoveNext;Inc(CR);
                    End;
               End;
            InternalMoveToBookmark(@BK);
            F_RecNo:=CR;
            //ClearBuffers;
            Resync([]);
            DoAfterScroll;
          End;
      TempRS.Close;
      TempRS:=NULL;
    End
 Else
    Begin
      CheckBrowseMode;
      CursorPosChanged;
      DoBeforeScroll;
      F_DaoTable.MoveFirst;
      Find:=False;
      RI:=0;
      While Not (F_DaoTable.EOF) Do
            Begin
             Find:=True;
             For X:=0 to KF.Count-1 do
                 Begin
                  FN:=Integer(KF.Objects[X])-1;
                  S1:=KV[X];
                  S2:=VarAsType(F_DaoTable.Fields.Item[FN].Value,VarString);
                  if loCaseInsensitive in Options Then
                      Begin
                       S1:=AnsiLowerCase(S1);
                       S2:=AnsiLowerCase(S2);
                      End;
                  if loPartialKey in Options Then
                      Begin
                       L:=Length(S1);
                       if S1[L]='*' Then System.Delete(S1,L,1);
                       if S1[1]='*' Then System.Delete(S1,1,1);
                       if Pos(S1,S2) = 0 Then Find:=False;
                      End
                  Else
                      Begin
                       if S1 <> S2 Then Find:=False;
                      End;
                  if NOT Find Then Break;
                 End;
             If Find Then
                Begin
                 DoBeforeScroll;
                 F_RecNo:=RI;
                 Result:= True;
                 //ClearBuffers;
                 Resync([]);
                 DoAfterScroll;
                 Break;
                End
             Else
                Begin
                 Inc(RI);
                 F_DaoTable.MoveNext;
                End;
            End;
      if Not(Find) Then
         Begin
           F_DaoTable.MoveFirst;
           OleVariant(F_DaoTable).Move(CR);
           //ClearBuffers;
           Resync([rmExact, rmCenter]);
          End;
      DoAfterScroll;
    End;
 KV.Free;
 KF.Free;
End;


Function  TKADaoTable.Find(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions;FindType:Integer): Boolean;
Var
 KF       : TStringList;
 KV       : TStringList;
 X        : Integer;
 CR       : Integer;
 Filter   : String;
 //*************************************
 BK       : Integer;
 TempRS   : OleVariant;
 FPP      : Single;
 APOK     : Boolean;
 //*************************************
Begin
 Result:=False;
 if IsEmpty Then Exit;
 If ((F_Filtered) And (Assigned(F_OnFilterRecord))) Or (F_RangeFiltered) Then Exit;
 KF :=  TStringList.Create;
 KV :=  TStringList.Create;
 StringToList(KeyFields,KF);
 VariantToList(KeyValues,KV);
 If (KF.Count <> KV.Count)  Then DatabaseError(E2032);
 For X:=0 To KF.Count-1 do KF.Objects[X]:=Pointer(FieldByName(KF[X]).FieldNo);
 //*****************************************************************************
 APOK := False;
 if     (F_TableType=dbOpenDynaset)
     OR (F_TableType=dbOpenSnapshot)
     OR (F_TableType=dbOpenDynamic) Then APOK:=True;
 //*****************************************************************************
 InternalSetToRecord(GetActiveRecordBuffer);
 CR:=F_RecNo;
 if F_Bookmarkable Then
    Begin
      Filter:=BuildLocateSQL(KF,KV,Options);
      TempRS:=F_DaoTable.Clone;
      TempRS.MoveFirst;
      OleVariant(TempRS).Move(CR);
      Case FindType of
           1 : TempRS.FindFirst(Filter);
           2 : TempRS.FindLast(Filter);
           3 : TempRS.FindNext(Filter);
           4 : TempRS.FindPrevious(Filter);
      End;
      if (Not TempRS.NoMatch) Then
          Begin
            Result:= True;
            BK:=GetDaoBookMark(TempRS);
            CheckBrowseMode;
            CursorPosChanged;
            DoBeforeScroll;
            if APOK Then
               Begin
                 CR := TempRS.AbsolutePosition;
               End
            Else
               Begin
                  FPP := TempRS.PercentPosition;
                  CR := Round((FPP*RecordCount)/100);
                  TempRS.MoveFirst;
                  TempRS.Move(CR);
                  While GetDaoBookmark(TempRS) <> BK do
                    Begin
                     TempRS.MoveNext;Inc(CR);
                    End;
               End;
            InternalMoveToBookmark(@BK);
            F_RecNo:=CR;
            //ClearBuffers;
            Resync([rmExact, rmCenter]);
            DoAfterScroll;
          End;
      TempRS.Close;
      TempRS:=NULL;
    End
 Else
    Result:=False;
End;

Procedure TKADaoTable.SetKeyFields(const KeyFields: string);
Begin
 StringToList(KeyFields,F_KeyFields);
End;

Function TKADaoTable.Find_First(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,1);
End;

Function TKADaoTable.Find_Last(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,2);
End;

Function TKADaoTable.Find_Next(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,3);
End;

Function TKADaoTable.Find_Prior(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,4);
End;

Procedure TKADaoTable.SetFindData(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions);
Begin
 F_FindKeyFields:=KeyFields;
 F_FindKeyValues:=KeyValues;
 F_FindOptions:=Options;
End;

Function TKADaoTable.FindRecord(Restart, GoForward: Boolean): Boolean;
Begin
   Result:=False;
   if F_FindKeyFields='' Then Exit;
   if VarIsNull(F_FindKeyValues) Then Exit;
   if (Restart) And (GoForward)         Then Result:=Find_First(F_FindKeyFields,F_FindKeyValues,F_FindOptions);
   if (Restart) And (NOT GoForward)     Then Result:=Find_Last(F_FindKeyFields,F_FindKeyValues,F_FindOptions);
   if (NOT Restart) And (GoForward)     Then Result:=Find_Next(F_FindKeyFields,F_FindKeyValues,F_FindOptions);
   if (NOT Restart) And (NOT GoForward) Then Result:=Find_Prior(F_FindKeyFields,F_FindKeyValues,F_FindOptions);
End;

//*************************************************************** Range Routines
Function TKADaoTable.CompareFieldsRange(B1, B2: String; FieldType: TFieldType):Integer;
Var
  BOOL1, BOOL2 : WordBool;
  DOUB1, DOUB2 : Double;
  SMAL1, SMAL2 : SmallInt;
  WORD1, WORD2 : Word;
  INTE1, INTE2 : Integer;
Begin
 Result := 0;
 Case FieldType of
      ftString,
      ftMemo     :       Begin
                           Result := AnsiCompareText(B1, B2);
                         End;
      ftBoolean  :       Begin
                           if AnsiLowerCase(B1) = 'true' Then BOOL1 := True Else BOOL1 := False;
                           if AnsiLowerCase(B2) = 'true' Then BOOL2 := True Else BOOL2 := False;
                           if BOOL1 > BOOL2 Then Result:=1
                           Else
                           if BOOL1 < BOOL2 Then Result:=-1;
                         End;
      ftCurrency,
      ftFloat    :       Begin
                           Try
                            DOUB1 := StrToFloat(B1);
                            DOUB2 := StrToFloat(B2);
                            if DOUB1 > DOUB2 Then Result:=1
                            Else
                            if DOUB1 < DOUB2 Then Result:=-1;
                           Except
                           End;
                         End;

      ftSmallInt :       Begin
                           Try
                            SMAL1 := SmallInt(StrToInt(B1));
                            SMAL2 := SmallInt(StrToInt(B2));
                            Result:=SMAL1-SMAL2;
                           Except
                           End;
                         End;

      ftWord     :       Begin
                           Try
                            WORD1 := Word(StrToInt(B1));
                            WORD2 := Word(StrToInt(B2));
                            Result:=WORD1-WORD2;
                           Except
                           End;
                         End;
      ftAutoInc,
      ftInteger  :       Begin
                           Try
                            INTE1 := LongInt(StrToInt(B1));
                            INTE2 := LongInt(StrToInt(B2));
                            Result:=INTE1-INTE2;
                           Except
                           End;
                         End;
      ftDate     :       Begin
                           Result := AnsiCompareText(B1, B2);
                         End;
      ftTime     :       Begin
                           Result := AnsiCompareText(B1, B2);
                         End;
      ftDateTime :       Begin
                           Result := AnsiCompareText(B1, B2);
                         End;
 End;
End;

Function TKADaoTable.CompareRecordsRange(B1,B2 : PChar; CT : Integer) : Integer;
Var
 X       : Integer;
 F1,F2   : String;
Begin
 Result := 0;
 If (B1=Nil) Or (B2=nil) then Exit;
 For X := 0  to FieldCount-1 do
     Begin
       F1 := PDaoInfo(B1+F_StartMyInfo)^.RecordData.Strings[X];
       F2 := PDaoInfo(B2+F_StartMyInfo)^.RecordData.Strings[X];
       if (F1 <> '') And (F2 <> '') Then
          Begin
            Result := CompareFieldsRange(F1,F2,Fields[X].DataType);
          End
       Else
          Begin
            //*************** SET OUTSIDE RANGE IF THERE ARE NO VALUE TO COMPARE
            if F2 <> '' Then
               Begin
                 if (F2 <> '') And (CT=1) Then Result:=-1
                 Else
                 if (F2 <> '') And (CT=2) Then Result:=1;
               End;
          End;
       if (Result < 0) And (CT=1) Then Break;
       if (Result > 0) And (CT=2) Then Break;
     End;
End;

Function TKADaoTable.FilterRange(Buffer:PChar): Boolean;
Var
 R1,R2 : Integer;
Begin
 R1 := CompareRecordsRange(Buffer,F_RangeStartBuffer,1);
 R2 := CompareRecordsRange(Buffer,F_RangeEndBuffer,2);
 Result := (R1 >=0) And (R2 <=0);
End;

Procedure TKADaoTable.ClearRange(Var Buffer:PChar);
Var
  X : Integer;
Begin
  PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Clear;
  For X := 0 To FieldDefs.Count-1 do
      Begin
       PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.AddObject('',TObject(False));
      End;
  SetState(dsBrowse);
End;

Procedure TKADaoTable.ApplyRange;
Var
 B1 : String;
 B2 : String;
Begin
 B1 := StrPas(PDaoInfo(F_RangeStartBuffer+F_StartMyInfo)^.RecordData.GetText);
 B2 := StrPas(PDaoInfo(F_RangeEndBuffer+F_StartMyInfo)^.RecordData.GetText);
 B1 :=Trim(B1);
 B2 :=Trim(B2);
 F_RangeFiltered := (B1 <> '') And (B2 <> '');
 F_RefreshRC     := True;
 SetState(dsBrowse);
 If Not IsEmpty then First;
End;

Procedure TKADaoTable.CancelRange;
Begin
  F_RangeFiltered   := False;
  F_ActiveKeyBuffer := Nil;
  F_RefreshRC       := True;
  First;
  Resync([rmExact]);
End;

Procedure TKADaoTable.SetRange(const StartValues, EndValues : Array of Const);
var
   Maks  : Integer;
   Mini  : Integer;
   X     : Integer;
Begin
     CheckBrowseMode;
     //***************************************************** Setting Start Range
     SetRangeStart;
     Mini := High(StartValues);
     Maks := PDaoInfo(F_RangeStartBuffer+F_StartMyInfo)^.RecordData.Count;
     if Maks > Mini Then Maks := Mini;
     For X := 0 to Maks do Fields[X].AssignValue(StartValues[X]);
     //******************************************************* Setting End Range
     SetRangeEnd;
     Mini := High(StartValues);
     Maks := PDaoInfo(F_RangeEndBuffer+F_StartMyInfo)^.RecordData.Count;
     if Maks > Mini Then Maks := Mini;
     For X := 0 to Maks do Fields[X].AssignValue(EndValues[X]);
     //****************************************************** Applying the Range
     ApplyRange;
End;

Procedure TKADaoTable.SetRangeStart;
Begin
  ClearRange(F_RangeStartBuffer);
  F_ActiveKeyBuffer := F_RangeStartBuffer;
  SetState(dsSetKey);
  DataEvent(deDataSetChange, 0);
End;

Procedure TKADaoTable.SetRangeEnd;
Begin
  ClearRange(F_RangeEndBuffer);
  F_ActiveKeyBuffer := F_RangeEndBuffer;
  SetState(dsSetKey);
  DataEvent(deDataSetChange, 0);
End;

Procedure TKADaoTable.EditRangeStart;
Begin
 F_ActiveKeyBuffer := F_RangeStartBuffer;
 SetState(dsSetKey);
 DataEvent(deDataSetChange, 0);
End;

Procedure TKADaoTable.EditRangeEnd;
Begin
  F_ActiveKeyBuffer := F_RangeEndBuffer;
  SetState(dsSetKey);
  DataEvent(deDataSetChange, 0);
End;
//***************************************************************** Key Routines

Procedure TKADaoTable.SetKeyParam(const KeyFields: Array of String;const KeyValues: array of const);
Var
  X : Integer;
Begin
  F_KeyKeyFields:='';
  F_KeyKeyValues:=VarNull;
  For X:=0 to High(KeyFields) do
      Begin
        if X < High(KeyValues) Then
           F_KeyKeyFields := F_KeyKeyFields+KeyFields[X]+';'
        Else
           F_KeyKeyFields := F_KeyKeyFields+KeyFields[X];
       End;
  if High(KeyValues)=0 then
    Begin
      AssignVarValue(F_KeyKeyValues,KeyValues[0]);
    End
  Else
     Begin
       F_KeyKeyValues:=VarArrayCreate([0,High(KeyValues)],varVariant);
       For X:=0 to High(KeyFields) do AssignVarValue(F_KeyKeyValues,KeyValues[X]);
     End;
End;

Procedure TKADaoTable.CancelKey;
Var
  Buffer : PChar;
  X      : Integer;
begin
     Buffer := F_KeyBuffer;
     PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Clear;
     For X := 0 To FieldDefs.Count-1 do
          Begin
            PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.AddObject('',TObject(False));
          End;
     F_ActiveKeyBuffer := Nil;
     F_KeyKeyFields    := '';
     F_KeyKeyValues    := VarNull;
     SetState(dsBrowse);
     Resync([rmExact]);
end;

Procedure TKADaoTable.ClearKey;
Var
  Buffer : PChar;
  X      : Integer;
begin
     Buffer := F_KeyBuffer;
     PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Clear;
     For X := 0 To FieldDefs.Count-1 do
          Begin
            PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.AddObject('',TObject(False));
          End;
     SetState(dsBrowse);
end;

Procedure TKADaoTable.SetKey;
begin
     ClearKey;
     F_ActiveKeyBuffer := F_KeyBuffer;
     SetState(dsSetKey);
     DataEvent(deDataSetChange, 0);
end;

Procedure TKADaoTable.EditKey;
begin
     F_ActiveKeyBuffer := F_KeyBuffer;
     SetState(dsSetKey);
     DataEvent(deDataSetChange, 0);
end;

Function  TKADaoTable.GotoKey: Boolean;
Var
  Buffer    : PChar;
  X         : Integer;
  Count     : Integer;
  NumFields : Integer;
  NF        : Integer;
Begin
  Result := False;
  if State=dsSetKey Then
     Begin
      Buffer := GetActiveRecordBuffer;
      if Buffer=Nil Then Exit;
      F_KeyKeyFields:='';
      F_KeyKeyValues:=VarNull;
      Count := PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Count-1;
      NumFields := 0;
      For X := 0 To Count Do
          Begin
            if PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Strings[X] <> '' Then
               Begin
                 F_KeyKeyFields := F_KeyKeyFields+FieldDefs[X].Name+';';
                 Inc(NumFields);
               End;
          End;
       if NumFields > 1 Then F_KeyKeyValues:=VarArrayCreate([0,NumFields-1],varVariant);
       NF:=0;
       For X := 0 To Count Do
          Begin
            if PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Strings[X] <> '' Then
               Begin
                 if NumFields > 1 Then F_KeyKeyValues[NF]:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Strings[X]
                 Else F_KeyKeyValues :=PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Strings[X];
                 Inc(NF);
               End;
          End;
      SetState(dsBrowse);
      if (TableType=dbOpenDynaset) or (TableType=dbOpenSnapshot) Then
         Begin
            Result := Find(F_KeyKeyFields,F_KeyKeyValues,[],3);
            if Not Result Then
               Result := Find(F_KeyKeyFields,F_KeyKeyValues,[],1);
         End;
      if (TableType=dbOpenTable) And (F_IndexName <> '') Then
          Begin
            Result := Locate(F_KeyKeyFields,F_KeyKeyValues,[]);
          End;
      if (Not Result) And (Not ISEmpty) Then Resync([]);
     End
  Else
     Begin
       if F_KeyKeyFields = '' Then Exit;
       if (TableType=dbOpenDynaset) or (TableType=dbOpenSnapshot) Then
         Begin
          Result := Find(F_KeyKeyFields,F_KeyKeyValues,[],3);
          if Not Result Then
             Result := Find(F_KeyKeyFields,F_KeyKeyValues,[],1);
         End;
       if (TableType=dbOpenTable) And (F_IndexName <> '') Then
          Begin
            Result := Locate(F_KeyKeyFields,F_KeyKeyValues,[]);
          End;
     End;
End;

Procedure  TKADaoTable.GotoNearest;
Var
  Buffer    : PChar;
  X         : Integer;
  Count     : Integer;
  NumFields : Integer;
  NF        : Integer;
Begin
  if State=dsSetKey Then
     Begin
      Buffer := GetActiveRecordBuffer;
      if Buffer=Nil Then Exit;
      F_KeyKeyFields:='';
      F_KeyKeyValues:=VarNull;
      Count := PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Count-1;
      NumFields := 0;
      For X := 0 To Count Do
          Begin
            if PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Strings[X] <> '' Then
               Begin
                 if X < Count Then
                    F_KeyKeyFields := F_KeyKeyFields+FieldDefs[X].Name+';'
                 Else
                    F_KeyKeyFields := F_KeyKeyFields+FieldDefs[X].Name;
                 Inc(NumFields);
               End;
          End;
       if NumFields > 1 Then F_KeyKeyValues:=VarArrayCreate([0,NumFields-1],varVariant);
       NF:=0;
       For X := 0 To Count Do
          Begin
            if PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Strings[X] <> '' Then
               Begin
                 if NumFields > 1 Then F_KeyKeyValues[NF]:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Strings[X]
                 Else F_KeyKeyValues :=PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Strings[X];
                 Inc(NF);
               End;
          End;
      SetState(dsBrowse);
      Find_NearestEx(F_KeyKeyFields,F_KeyKeyValues);
     End
  Else
     Begin
       if F_KeyKeyFields = '' Then Exit;
       Find_NearestEx(F_KeyKeyFields,F_KeyKeyValues);
     End;
End;

Function TKADaoTable.FindKey(const KeyValues: array of const):Boolean;
Begin
 Result:=Seek_NearestEx(KeyValues,'>=');
End;

//******************************************************************************

Function TKADaoTable.Find_NearestEx(const KeyFields: string; const KeyValues: Variant):Boolean;
Var
  Options:TLocateOptions;
Begin
  Options:=[loCaseInsensitive,loPartialKey];
  Result:=Find(KeyFields,KeyValues,Options,1);
  if Not Result Then Result:=Find(KeyFields,KeyValues,Options,3);
End;

Function TKADaoTable.Find_Nearest(const KeyValues: array of const):Boolean;
Var
  KF         : String;
  KV         : Variant;
  KT         : Variant;
  X          : Integer;
Begin
  KF:='';
  For X:=0 to High(KeyValues) do
      Begin
        if X < High(KeyValues) Then KF := KF+F_KeyFields.Strings[X]+';' Else  KF := KF+F_KeyFields.Strings[X];
       End;
  if High(KeyValues)=0 then
    Begin
      AssignVarValue(KV,KeyValues[0]);
    End
  Else
     Begin
       KV:=VarArrayCreate([0,High(KeyValues)],varVariant);
       For X:=0 to High(KeyValues) do
           Begin
            AssignVarValue(KT,KeyValues[X]);
            KV[X]:=KT;
           End;
     End;
  Result:=Find_NearestEx(KF,KV);
End;


Function TKADaoTable.Seek_NearestEx(const KeyValues: array of const; SeekType:String):Boolean;
Var
 KV     : Variant;
 KT     : Variant;
 X      : Integer;
 CR     : Integer;
 NumVals: Integer;
 //*************************************
 BK       : Integer;
 TempRS   : OleVariant;
 FPP      : Single;
 //*************************************
Begin
 Result:=False;
 if F_IndexName='' Then Exit;
 if IsEmpty Then Exit;
 If ((F_Filtered) And (Assigned(F_OnFilterRecord))) Or (F_RangeFiltered) Then Exit;
 if High(KeyValues)=0 then
    Begin
      NumVals:=1;
      AssignVarValue(KV,KeyValues[0]);
    End
  Else
     Begin
       KV:=VarArrayCreate([0,High(KeyValues)],varVariant);
       NumVals:=High(KeyValues)+1;
       For X:=0 to High(KeyValues) do
           Begin
            AssignVarValue(KT,KeyValues[X]);
            KV[X]:=KT;
           End;
     End;
     InternalSetToRecord(GetActiveRecordBuffer);
     CR:=F_RecNo;
     TempRS:=F_DaoTable.Clone;
     TempRS.Index:=F_IndexName;
     TempRS.Move(CR);
     if NumVals=1 Then TempRS.Seek(SeekType,KV)
     Else
     if NumVals=2 Then TempRS.Seek(SeekType,KV[0],KV[1])
     Else
     if NumVals=3 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2])
     Else
     if NumVals=4 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2],KV[3])
     Else
     if NumVals=5 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4])
     Else
     if NumVals=6 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5])
     Else
     if NumVals=7 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6])
     Else
     if NumVals=8 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7])
     Else
     if NumVals=9 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8])
     Else
     if NumVals=10 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9])
     Else
     if NumVals=11 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9],KV[10])
     Else
     if NumVals=12 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9],KV[10],KV[11])
     Else
     if NumVals=13 Then TempRS.Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9],KV[10],KV[11],KV[12])
     Else
        DatabaseError(E2033);
     if (Not TempRS.NoMatch) Then
          Begin
            Result:= True;
            BK:=GetDaoBookMark(TempRS);
            FPP := TempRS.PercentPosition;
            CR := Round((FPP*RecordCount)/100);
            CheckBrowseMode;
            CursorPosChanged;
            DoBeforeScroll;
            TempRS.MoveFirst;
            TempRS.Move(CR);
            While GetDaoBookmark(TempRS) <> BK do
              Begin
                TempRS.MoveNext;Inc(CR);
              End;
            InternalMoveToBookmark(@BK);
            F_RecNo:=CR;
            //ClearBuffers;
            Resync([rmExact, rmCenter]);
            DoAfterScroll;
          End;
     TempRS.Close;
     TempRS:=NULL;
End;

Function TKADaoTable.Seek_Nearest(const KeyValues: array of const):Boolean;
Begin
 Result:=Seek_NearestEx(KeyValues,'>=');
End;

Procedure TKADaoTable.FindNearest(const KeyValues: array of const);
Begin
 if Seek_NearestEx(KeyValues,'>=')=False Then
    Begin
    End;
End;


Function  TKADaoTable.Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant;
Var
 KF     : TStringList;
 KV     : TStringList;
 RF     : TStringList;
 {$IFDEF DYNADAO}
 RS     : OleVariant;
 TempRS : OleVariant;
 {$ELSE}
 RS     : Recordset;
 TempRS : Recordset;
 {$ENDIF}
 FT     : String;
 X      : Integer;
 FN     : Integer;
Begin
 Result:= NULL;
 if IsEmpty Then Exit;
 KF := TStringList.Create;
 KV := TStringList.Create;
 RF := TStringList.Create;
 StringToList(KeyFields,KF);
 VariantToList(KeyValues,KV);
 StringToList(ResultFields,RF);
 if (KF.Count <> KV.Count)  Then DatabaseError(E2032);
 if (RF.Count=0) Or (ResultFields='') Then DatabaseError(E2034);
 For X:=0 To RF.Count-1 do RF.Objects[X]:=Pointer(FieldByName(RF[X]).FieldNo);
 RS:=F_DaoTable;
 FT:=F_DaoTable.Filter;
 RS.Filter:=BuildKeySQL(KF,KV);
 TempRS:=RS.OpenRecordset(dbOpenSnapshot,dbReadOnly);
 F_Database.Idle;
 If Not(TempRS.EOF and TempRS.BOF) then
    Begin
      TempRS.MoveFirst;
      if RF.Count=1 Then
         Begin
           FN:=Integer(RF.Objects[0])-1;
           Result:=TempRS.Fields.Item[FN].Value
         End
      Else
         Begin
           Result:= VarArrayCreate([0,RF.Count - 1], varVariant);
           For X:=0 To RF.Count-1 do
               Begin
                 FN:=Integer(RF.Objects[X])-1;
                 Result[X]:=TempRS.Fields.Item[FN].Value
               End;
         End;
    End;
 TempRS.Close;
 {$IFDEF DYNADAO}
 TempRS:=NULL;
 {$ELSE}
 TempRS:=Nil;
 {$ENDIF}
 RS.Filter:=FT;
 RF.Free;
 KV.Free;
 KF.Free;
End;

{*************************************************************** DAO FIELD TYPES
  dbBoolean = 1;
  dbByte = 2;
  dbInteger = 3;
  dbLong = 4;
  dbCurrency = 5;
  dbSingle = 6;
  dbDouble = 7;
  dbDate = 8;
  dbBinary = 9;
  dbText = 10;
  dbLongBinary = 11;
  dbMemo = 12;
  dbGUID = 15;
  dbBigInt = 16;
  dbVarBinary = 17;
  dbChar = 18;
  dbNumeric = 19;
  dbDecimal = 20;
  dbFloat = 21;
  dbTime = 22;
  dbTimeStamp = 23;
//******************************************************************************
}

Function TKADaoTable.CreateField(FieldName:String;FieldType:Integer;FiledSize:Integer):Boolean;
Var
  FN,FT,FS,FI,FR:Variant;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError(E2035);
       Exit;
     End;
  if Not Assigned(F_Database) Then
         Begin
           DatabaseError(E2036);
           Exit;
         End;
   if Not (F_Database.Connected) Then
         Begin
           DatabaseError(E2037);
           Exit;
         End;
  if F_Active Then
     Begin
      DatabaseError(E2038);
      Exit;
     End;
  FN:=VarArrayCreate([0, 0], varOleStr);
  FT:=VarArrayCreate([0, 0], varInteger);
  FS:=VarArrayCreate([0, 0], varInteger);
  FI:=VarArrayCreate([0, 0], varInteger);
  FR:=VarArrayCreate([0, 0], varInteger);
  FN[0]:=FieldName;
  FT[0]:=FieldType;
  FS[0]:=DaoSizeToBDESize(FieldType,FiledSize);
  FI[0]:=0;
  FR[0]:=0;
  Try
    Result:=F_Database.AddFieldsToTable(F_TableName,FN,FT,FS,FI,FR);
  Except
    Exit;
  End;
End;

Function TKADaoTable.CreateIndex(FieldName:String;IndexType:Integer):Boolean;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError(E2039);
       Exit;
     End;
  if Not Assigned(F_Database) Then
     Begin
       DatabaseError(E2040);
       Exit;
     End;
   if Not (F_Database.Connected) Then
         Begin
           DatabaseError(E2041);
           Exit;
         End;
  if F_Active Then
     Begin
       DatabaseError(E2042);
       Exit;
     End;
  Result:=F_Database.CreateIndex(F_TableName,FieldName,IndexType);
End;

Function TKADaoTable.DeleteField(FieldName:String):Boolean;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError(E2043);
       Exit;
     End;
  if Not Assigned(F_Database) Then
     Begin
       DatabaseError(E2044);
       Exit;
     End;
  if Not (F_Database.Connected) Then
     Begin
       DatabaseError(E2045);
       Exit;
     End;
  if F_Active Then
     Begin
       DatabaseError(E2046);
       Exit;
     End;
  Try
    F_Database.DeleteField(F_TableName,FieldName);
  Except
    Exit;
  End;
  Result:=True;
End;

Function TKADaoTable.DeleteIndex(FieldName:String):Boolean;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError(E2047);
       Exit;
     End;
  if Not Assigned(F_Database) Then
     Begin
       DatabaseError(E2048);
       Exit;
     End;
  if F_Active Then
     Begin
       DatabaseError(E2049);
       Exit;
     End;
  if Not (F_Database.Connected) Then
     Begin
       DatabaseError(E2050);
       Exit;
     End;

  Try
    F_Database.DeleteIndexByFieldName(F_TableName,FieldName);
  Except
    Exit;
  End;
  Result:=True;
End;

Function TKADaoTable.EmptyTable:Boolean;
Begin
 Result := True;
 if IsEmpty Then Exit;
 DisableControls;
 Try
   First;
   BatchMode:=True;
   While NOT EOF do
     Begin
       F_InPost := True;
       Delete;
       F_InPost := False;
     End;
  CursorPosChanged;
  Resync([]);
 Finally
   BatchMode:=False;
   F_InPost := False;
   EnableControls;
   Result := Not IsEmpty;
 End;
End;


Function TKADaoTable.InsertSQLString(MDString: String): String;
Begin
  Result:='';
  if F_Filtered Then Result:= Filter;
  if MDString <> '' then
    Begin
      if Result <> '' Then
         Result := '('+MDString+') AND ('+Result+')'
      Else
         Result := MDString;
    End;
End;

//******************************************************************************
//*                  Master/Detail Handling
//******************************************************************************
Function  TKADaoTable.F_Get_MasterSource : TDataSource;
Begin
 Result:= F_MasterLink.DataSource;
End;

Procedure TKADaoTable.F_Set_MasterSource(Value: TDataSource);
Begin
 if IsLinkedTo(Value) then DatabaseError(E2057);
 if (Value=Nil) And (F_Active) Then Exit;
 F_MasterLink.DataSource:= Value;
End;

Procedure TKADaoTable.F_ProcessMasterFields(Value:TStrings);
Var
  X                       : Integer;
  I                       : Integer;
  S                       : String;
  MasterField,DetailField : String;
  FieldNames              : String;
Begin
  F_Detail.Clear;
  F_Master.Clear;
  if (Value.Count=1) And (Pos(';',Value.Strings[0]) > 0) Then
     Begin
       S := Value.Strings[0];
       Repeat
        I := Pos(';',S);
        if I > 0 Then
           Begin
            DetailField:=Copy(S,1,I-1);
            System.Delete(S,1,I);
           End
        Else
           Begin
            DetailField:=S;
           End;
        if Length(DetailField) > 0 Then
           Begin
            MasterField:=DetailField;
            F_Detail.Add(DetailField);
            F_Master.Add(MasterField);
           End;
       Until I = 0;
     End
  Else
  For X:=0 to Value.Count-1 do
      Begin
        S := Value.Strings[X];
        I := Pos(' -> ',S);
        if I > 0 Then
        Begin
         DetailField:=Copy(S,1,I-1);
         System.Delete(S,1,I+Length(' -> ')-1);
         MasterField:=S;
         F_Detail.Add(DetailField);
         F_Master.Add(MasterField);
        End;
      End;
  FieldNames:='';
  For X := 0 To F_Detail.Count-1 do
      Begin
        if X < F_Detail.Count-1 Then
           FieldNames:=FieldNames+F_Master.Strings[X]+';'
        Else
           FieldNames:=FieldNames+F_Master.Strings[X];
      End;
  F_MasterLink.FieldNames:=FieldNames;
End;

Procedure TKADaoTable.F_Set_MasterFields(Value:TStrings);
Begin
 F_MasterFields.SetText(Value.GetText);
End;

Procedure TKADaoTable.F_Set_Master(Value:TStrings);
Begin
 F_Master.SetText(Value.GetText);
End;

Procedure TKADaoTable.F_Set_Detail(Value:TStrings);
Begin
 F_Detail.SetText(Value.GetText);
End;


Procedure TKADaoTable.MasterDatasetChanged;
Begin
  if csDestroying in ComponentState then EXIT;
  if (MasterSource <> NIL) And (Not F_MDisabled) then
  Begin
  if F_Master.Count > 0 Then
     Begin
      //*************************************************
      ClearBuffers;
      CheckBrowseMode;
      CloseDaoRecordset;
      if F_SQL.Count > 0 Then
         OpenDaoRecordset
      Else
         ReOpenDaoRecordset;
      ActivateBuffers;
      First;
      //*************************************************
     End;
  End;
End;


Procedure TKADaoTable.RefreshQueryParams;
{$IFDEF USEPARAMS}{$IFNDEF VER100}{$IFNDEF VER110}
var
  DataSet   : TDataSet;
  X         : Integer;
  TempParam : TParam;
{$ENDIF}{$ENDIF}{$ENDIF}
Begin
{$IFDEF USEPARAMS}{$IFNDEF VER100}{$IFNDEF VER110}
  DisableControls;
  Try
    if F_MasterLink.DataSource <> nil then
       Begin
        DataSet := F_MasterLink.DataSource.DataSet;
        if (DataSet <> Nil) And (DataSet.Active) And (DataSet.State <> dsSetKey)
            And (F_ParamCheck)
            And (F_Params.Count > 0) Then
              Begin
                For X := 0 to F_MasterLink.Fields.Count - 1 do
                    Begin
                      TempParam := F_Params.FindParam(TField(F_MasterLink.Fields[X]).FieldName);
                      if TempParam <> Nil Then TempParam.Assign(F_MasterLink.Fields[X]);
                    End;
              End;
       End;
  Finally
    EnableControls;
  End;
{$ENDIF}{$ENDIF}{$ENDIF}
End;


Procedure TKADaoTable.UpdateFromMaster;
Var
  X         : Integer;
  TempField : TField;
Begin
  For X := 0 to F_MasterLink.Fields.Count - 1 do
      Begin
       TempField := FieldByName(F_Detail.Strings[X]);
       TempField.Assign(TField(F_MasterLink.Fields[X]));
      End;
End;

Procedure TKADaoTable.DoOnNewRecord;
begin
  If (F_MasterLink.Active) And (F_MasterLink.Fields.Count>0) Then
     Begin
      UpdateFromMaster;
     End;
  inherited DoOnNewRecord;
end;

Procedure TKADaoTable.MasterChanged(Sender: TObject);
Begin
 if not Active then Exit;
 CheckBrowseMode;
 If (F_MasterLink.Active) And (F_MasterLink.Fields.Count>0)  Then
     Begin
      if F_SQL.Count > 0 Then RefreshQueryParams;
      MasterDatasetChanged;
     End;
End;

Procedure TKADaoTable.MasterDisabled(Sender: TObject);
Begin
 CheckBrowseMode;
 F_MDisabled := Not (F_MasterLink.DataSet.Active);
End;
//******************************************************************************
//*                         Blob Stream Handling
//******************************************************************************
Function TKADaoTable.BlobToString(Field:TBlobField; Data:OleVariant; DataSize:Integer):String;
Var
   RW     : WideString;
   P      : PChar;
Begin
  if Field.BlobType=ftMemo Then
     Begin
       Result:=Data;
     End
  Else
     Begin
       RW:=Data;
       P:=@RW[1];
       SetString(Result,P,DataSize);
     End;
End;

Function TKADaoTable.StringToBlob(Field:TBlobField; Data:String):OleVariant;
Var
   DataSize : Integer;
   P        : PChar;
   pData    : PChar;
Begin
   if Field.DataType=ftMemo Then
      Begin
        Result := Data;
      End
   Else
      Begin
        DataSize := Length(Data);
        Result := VarArrayCreate([0,DataSize-1],VarByte);
        P := VarArrayLock(Result);
        pData := PChar(Data);
        Move(pData[0],P[0],DataSize);
        VarArrayUnlock(Result);
     End;
End;

constructor TKBlobStream.Create(Field: TBlobField; Mode: TBlobStreamMode);
Var
   RD     : OleVariant;
   RS     : Integer;
   DInfo  : TDaoInfo;
Begin
     F_BlobData := '';
     F_BlobSize := 0;
     Size       := F_BlobSize;
     F_Position := 0;
     F_Mode     := Mode;
     F_Field    := Field;
     F_Opened   := True;
     F_DataSet  := F_Field.DataSet as TKADaoTable;
     F_Buffer   := F_DataSet.GetActiveRecordBuffer;
     //************************************************** Table is empty so exit
     if F_Buffer = Nil Then Exit;
     //*************************************************************************
     if Mode = bmWrite then
        Begin
          if F_DataSet.ReadOnly Then DatabaseError(E2056);
          Truncate;
        End
     Else
     if Not F_Field.Modified Then
        Begin
           DInfo := PDaoInfo(F_Buffer+F_DataSet.F_StartMyInfo)^;
           //*******************************************************************
           //              CACHED MEMOS HANDLING
           //*******************************************************************
           if  (Field.DataType = ftMemo)
           And (F_Dataset.F_CacheMemos)  Then
               Begin
                 F_BlobData:=DInfo.RecordData.Strings[F_Field.FieldNo-1];
                 if (DInfo.RecordNo=-1) And (F_BlobData='') Then
                    F_BlobData := F_DataSet.F_DefaultValues.Strings[F_Field.FieldNo-1];
                 F_BlobSize:=Length(F_BlobData);
                 Size := F_BlobSize;
                 Exit;
               End;
           F_DataSet.InternalSetToRecord(F_Buffer);
           //*******************************************************************
           //                 UNIQUE CODE TO SUPPORT VIEW OF BLOBS IN GRIDS
           //*******************************************************************
           if (F_DataSet.State = dsEdit) then
              Begin
                F_BlobData:=DInfo.RecordData.Strings[F_Field.FieldNo-1];
                if F_DataSet.F_OldValue <> Nil Then
                   Begin
                     F_DataSet.InternalSetToRecord(F_DataSet.F_OldValue);
                     F_DataSet.InternalMoveToBookmark(@PDaoInfo(F_DataSet.F_OldValue+F_DataSet.F_StartMyInfo)^.BookmarkData);
                     Try
                      F_DataSet.F_DaoTable.Edit;
                     Except
                     End;
                   End;
               End
           Else
           //*******************************************************************
           //   UNIQUE CODE TO SUPPORT BOTH VIEW OF BLOBS IN GRIDS
           //   AND DEFAULT VALUES FOR BLOBS
           //*******************************************************************
           if (F_DataSet.State = dsInsert) Then
              Begin
                F_BlobData := '';
                if (DInfo.RecordNo=-1) Then
                    Begin
                      F_BlobData := DInfo.RecordData.Strings[F_Field.FieldNo-1];
                      if (F_BlobData='') And
                         (F_DataSet.F_DefaultValues.Strings[F_Field.FieldNo-1] <> '') Then
                         Begin
                          F_BlobData := F_DataSet.F_DefaultValues.Strings[F_Field.FieldNo-1];
                         End;
                    End
                Else
                    Begin
                      if F_Field.DataType=ftMemo Then F_BlobData := '(Memo)'
                      Else F_BlobData := '(Blob)';
                    End;
              End
           Else
              Begin
                Try
                  RD:=F_DataSet.F_DaoTable.Fields.Item[F_Field.FieldNo-1].Value;
                  RS:=F_DataSet.F_DaoTable.Fields.Item[F_Field.FieldNo-1].FieldSize;
                  if VarType(RD) = varNull then F_BlobData := ''
                  Else F_BlobData:=F_DataSet.BlobToString(F_Field,RD,RS);
                Except
                  F_BlobData:='';
                  if F_DataSet.F_TableType <> dbOpenForwardOnly Then F_DataSet.InternalRefresh;
                End;
              End;
           //******************************************* Put blob data in Record
           DInfo.RecordData.Strings[F_Field.FieldNo-1]:=F_BlobData;
           //*******************************************************************
           F_BlobSize:=Length(F_BlobData);
           Size := F_BlobSize;
           //******************************************************** Reposition
            F_DataSet.CursorPosChanged;
            F_DataSet.UpdateCursorPos;
           //*******************************************************************
        End;
End;


destructor TKBlobStream.Destroy;
Begin
 if F_Modified then
   try                                                                                           
     F_DataSet.DataEvent(deFieldChange, Longint(F_Field));
     F_BlobData := '';
     F_Buffer   := Nil;
     F_Opened   := False;
   Except
     Application.HandleException(Self);
   End;
End;


Function TKBlobStream.Read(var Buffer; Count: Longint): Longint;
Begin
  Result := 0;
  if F_Opened then
  Begin
    if Count > Size - F_Position then
       Result := Size - F_Position
    Else
       Result := Count;
    if Result > 0 then
       Begin
         Move(PChar(F_BlobData)[F_Position], Buffer, Result);
         Inc(F_Position, Result);
       End;
     End;
End;


Function TKBlobStream.Write(const Buffer; Count: Longint): Longint;
var
   pTemp  : Pointer;
   sTemp  : String;
   RData  : TStringList;
Begin
 Result := 0;
 if F_Opened then
    Begin
     try
       SetLength(sTemp,Count);
       pTemp:=PChar(sTemp);
       CopyMemory(pTemp, @Buffer, Count);
       F_BlobData  := Copy(F_BlobData,1,F_Position)+sTemp;
       F_BlobSize  := Length(F_BlobData);
       Size := F_BlobSize;
       RData:=PDaoInfo(F_Buffer+F_DataSet.F_StartMyInfo)^.RecordData;
       RData.Strings[F_Field.FieldNo-1]:=F_BlobData;
       RData.Objects[F_Field.FieldNo-1]:=TObject(True);
       F_Modified := True;
     Finally
     End;
     Inc(F_Position, Count);
     Result := Count;
     F_Modified := True;
   End;
End;


Function TKBlobStream.Seek(Offset: Longint; Origin: Word): Longint;
Begin
 Case Origin of
      0: F_Position := Offset;
      1: Inc(F_Position, Offset);
      2: F_Position := F_BlobSize + Offset;
 End;
 Result := F_Position;
End;


Procedure TKBlobStream.Truncate;
Var
   RData  : TStringList;
Begin
 if F_Opened then
    Begin
     RData:=PDaoInfo(F_Buffer+F_DataSet.F_StartMyInfo)^.RecordData;
     SetLength(F_BlobData,F_Position);
     F_BlobSize  := Length(F_BlobData);
     Size := F_BlobSize;
     RData.Strings[F_Field.FieldNo-1]:=F_BlobData;
     RData.Objects[F_Field.FieldNo-1]:=TObject(True);
     F_Modified := True;
   End;
End;

//***********************************************************************************
Function TKADaoTable.IntegerToBuffer(Buffer: Pointer; S: String): Boolean;
Begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = '' then S := '0';
     Try
       Integer(Buffer^) := StrToInt(S);
     Except
       Integer(Buffer^) := Round(StrToFloat(S));
     End;
End;


Function TKADaoTable.FloatToBuffer(Buffer: Pointer; S: String): Boolean;
Begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = '' then S := '0';
     Double(Buffer^) := StrToFloat(S);
End;

Function TKADaoTable.BooleanToBuffer(Buffer: Pointer; S: String): Boolean;
Begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if AnsiLowerCase(S)='false' Then S := '0'
     Else
     if AnsiLowerCase(S)='true'  Then S := '1'
     Else
     if AnsiLowerCase(S)='no'    Then S := '0'
     Else
     if AnsiLowerCase(S)='yes'   Then S := '1'
     Else
     if S = ''    Then S := '0'
     Else
     if S = '-1'  Then S := '1';
     WordBool(Buffer^) := WordBool(StrToInt(S));
End;

//************************************************************************** OK
Function TKADaoTable.DateToBuffer(Buffer: Pointer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
   P    : Integer;
Begin
 Result:=False;
 if Buffer=Nil Then Exit;
 P := Pos(' ',S);
 if P=0 Then Exit;
 Ttmp.Date:=StrToInt(Copy(S,1,P-1));
 System.Delete(S,1,P);
 Ttmp.Time:=StrToInt(S);
 Dtmp := Buffer;
 Dtmp^.Date := Ttmp.Date;
 Result:=True;
End;


//************************************************************************** OK
Function TKADaoTable.TimeToBuffer(Buffer: Pointer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : ^TTimeStamp;
   P    : Integer;
Begin
 Result:=False;
 if Buffer=Nil Then Exit;
 P := Pos(' ',S);
 if P=0 Then Exit;
 Ttmp.Date:=StrToInt(Copy(S,1,P-1));
 System.Delete(S,1,P);
 Ttmp.Time:=StrToInt(S);
 Dtmp:=Buffer;
 Dtmp^.Time:=Ttmp.Time;
 Result:=True;
End;

//************************************************************************** OK
Function TKADaoTable.DateTimeToBuffer(Buffer: Pointer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
   P    : Integer;
Begin
 Result:=False;
 if Buffer=Nil Then Exit;
 P := Pos(' ',S);
 if P=0 Then Exit;
 Ttmp.Date:=StrToInt(Copy(S,1,P-1));
 System.Delete(S,1,P);
 Ttmp.Time:=StrToInt(S);
 Dtmp := Buffer;
 Dtmp^.DateTime := TimeStampToMSecs(Ttmp);
 Result:=True;
End;

//************************************************************************** OK
Function TKADaoTable.BufferToDate(Buffer: Pointer): String;
var
   Dtmp : ^TDateTimeRec;
Begin
     Result := '';
     Dtmp   := Buffer;
     if Dtmp=Nil Then Exit;
     Result := IntToStr(Dtmp.Date)+' '+IntToStr(0);
End;

//************************************************************************** OK
Function TKADaoTable.BufferToDateTime(Buffer: Pointer): String;
var
   TTmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
Begin
     Result := '';
     Dtmp   := Buffer;
     if Dtmp=Nil Then Exit;
     Ttmp   := MsecsToTimeStamp(Dtmp.DateTime);
     Result := IntToStr(Ttmp.Date)+' '+IntToStr(Ttmp.Time);
End;
//************************************************************************** OK
Function TKADaoTable.BufferToTime(Buffer: Pointer): String;
var
   Dtmp : ^TTimeStamp;
Begin
     Result := '';
     Dtmp   := Buffer;
     if Dtmp=Nil Then Exit;
     //******************************* SHAME MICROSOFT!!!
     Result := IntToStr(693594)+' '+IntToStr(Dtmp.Time);
End;


//***************************************************************** TPARAMETERS
{$IFDEF USEPARAMS}
 {$IFNDEF VER100}
  {$IFNDEF VER110}
Procedure TKADaoTable.SetParamsList(Value: TParams);
begin
    F_Params.AssignValues(Value);
end;

Procedure TKADaoTable.UpdateParamsList(Sender: TObject);
var
    List: TParams;
begin
    if not (csReading in ComponentState) then
        if ParamCheck or (csDesigning in ComponentState) then
        begin
            List := TParams.Create(Self);
            try
                List.ParseSQL(SQL.Text, True);
                List.AssignValues(F_Params);
                F_Params.Clear;
                F_Params.Assign(List);
            finally
                List.Free;
            end;
        end;
end;

Function TKADaoTable.GetParamsCount: Word;
begin
    Result := F_Params.Count;
end;

Procedure TKADaoTable.DefineProperties(Filer: TFiler);

    Function WriteData: Boolean;
    begin
        if Filer.Ancestor <> nil then
            Result := not F_Params.IsEqual(TKADaoTable(Filer.Ancestor).F_Params)
        else
            Result := F_Params.Count > 0;
    end;

begin
    inherited DefineProperties(Filer);
    Filer.DefineProperty('ParamData', ReadParamData, WriteParamData, WriteData);
end;

Procedure TKADaoTable.ReadParamData(Reader: TReader);
begin
    Reader.ReadValue;
    Reader.ReadCollection(F_Params);
end;

Procedure TKADaoTable.WriteParamData(Writer: TWriter);
begin
    Writer.WriteCollection(Params);
end;
   {$ENDIF}
 {$ENDIF}
{$ENDIF}
//************************************************************** TPARAMETERS END

//*********************************************************************************** TableName
Procedure TTableNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase  : TKADaodatabase;
  X      : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.F_Database) And (DTable.F_Database.Connected) Then
       Begin
        DBase:=DTable.F_Database;
        DBase.RefreshDefinitions;
        Try
          For X := 0 to DBase.TableNames.Count-1 do Proc(DBase.TableNames.Strings[X]);
        Finally
        End;
       End;
  End;
End;

Function TTableNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;
//*********************************************************************************** QueryName

Procedure TQueryNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase : TKADaodatabase;
  X     : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.F_Database) And (DTable.F_Database.Connected) Then
       Begin
        DBase:=DTable.F_Database;
        DBase.RefreshDefinitions;
        Try
          For X := 0 to DBase.QueryDefNames.Count-1 do Proc(DBase.QueryDefNames.Strings[X]);
        Finally
        End;
       End;
  End;
End;

Function TQueryNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;
//*********************************************************************************** IndexName
Procedure TIndexNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase  : TKADaodatabase;
  X      : Integer;
  Count  : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.F_Database) And (DTable.F_Database.Connected)  Then
    if DTable.TableName <> '' Then
       Begin
        DBase:=DTable.F_Database;
        Try
          DBase.RefreshDefinitions;
          Count :=DBase.CoreDatabase.TableDefs.Item[DTable.TableName].Indexes.Count;
          For X := 0 to  Count-1 do
              Begin
                Proc(DBase.CoreDatabase.TableDefs.Item[DTable.TableName].Indexes.Item[X].Name);
              End;
        Finally
        End;
       End;
  End;
End;


Function TIndexNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;

//***************************************************************************************************************************

Function TTableTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result := Inherited GetAttributes + [paValueList, paSortList];
End;

Function  TTableTypeEditor.GetValue: string;
Begin
 if GetComponent(0) is TKADaoTable then
    Begin
      Result:='StandardTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenTable       then Result:='StandardTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenDynaset     then Result:='DynasetTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenDynamic     then Result:='DynamicTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenSnapshot    then Result:='SnapshotTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenForwardOnly then Result:='ForwardOnlyTable';
    End;
End;

Procedure TTableTypeEditor.GetValues( Proc: TGetStrProc);
Begin
  if GetComponent(0) is TKADaoTable then
     Begin
       Proc('StandardTable');
       Proc('DynasetTable');
       Proc('DynamicTable');
       Proc('SnapshotTable');
       Proc('ForwardOnlyTable');
     End;
End;


Procedure TTableTypeEditor.SetValue(const Value: string);
Var
 Dat : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
       Begin
       Dat:=dbOpenTable;
       if Value='StandardTable'    Then Dat:=dbOpenTable;
       if Value='DynasetTable'     Then Dat:=dbOpenDynaset;
       if Value='DynamicTable'     Then Dat:=dbOpenDynamic;
       if Value='SnapshotTable'    Then Dat:=dbOpenSnapshot;
       if Value='ForwardOnlyTable' Then Dat:=dbOpenForwardOnly;
       Inherited SetValue(IntToStr(Dat));
       Modified;
     End;
End;

//***************************************************************************************************************************

Function TLockTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result := Inherited GetAttributes + [paValueList, paSortList];
End;

Function  TLockTypeEditor.GetValue: string;
Begin
 if GetComponent(0) is TKADaoTable then
    Begin
      Result:='dbPessimistic';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbPessimistic       then Result:='dbPessimistic';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbOptimistic        then Result:='dbOptimistic';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbOptimisticValue   then Result:='dbOptimisticValue';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbReadOnly          then Result:='dbReadOnly';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbOptimisticBatch   then Result:='dbOptimisticBatch';
    End;
End;

Procedure TLockTypeEditor.GetValues( Proc: TGetStrProc);
Begin
  if GetComponent(0) is TKADaoTable then
     Begin
       Proc('dbPessimistic');
       Proc('dbOptimistic');
       Proc('dbOptimisticValue');
       Proc('dbReadOnly');
       Proc('dbOptimisticBatch');
     End;
End;


Procedure TLockTypeEditor.SetValue(const Value: string);
Var
 Dat : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
       Begin
       Dat:=DAOApi.dbPessimistic;
       if Value='dbPessimistic'     Then Dat:=DAOApi.dbPessimistic;
       if Value='dbOptimistic'      Then Dat:=DAOApi.dbOptimistic;
       if Value='dbOptimisticValue' Then Dat:=DAOApi.dbOptimisticValue;
       if Value='dbReadOnly'        Then Dat:=DAOApi.dbReadOnly;
       if Value='dbOptimisticBatch' Then Dat:=DAOApi.dbOptimisticBatch;
       Inherited SetValue(IntToStr(Dat));
       Modified;
     End;
End;


Function TSortByEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TSortByEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TSortByEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

Procedure TSortByEditor.Edit;
Var
 DT:TKADaoTable;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if NOT Assigned(DT.F_Database) Then Exit;
    if NOT (DT.F_Database.Connected) Then Exit;
    if (DT.Active=False) And (Not (csLoading in DT.ComponentState)) Then
       Begin
         Try
           DT.Active:=True;
           DT.Active:=False;
         Except
           DT.F_SortedBy.Clear;
           DT.F_FieldNames.Clear;
           DatabaseError(E2051);
           Exit;
         End;
       End;
    Application.CreateForm(TSortByDialog,SortDialog);
    if SortDialog.Execute(DT.F_FieldNames,DT.F_SortedBy,DT.F_UseBrackets) Then
       Begin
         DT.SortedBy:=DT.F_SortedBy;
       End;
    SortDialog.Free;
  End;
End;

Function TQueryDefParamsEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TQueryDefParamsEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TQueryDefParamsEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

Procedure TQueryDefParamsEditor.Edit;
Var
 DT      : TKADaoTable;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if DT.PromptQueryDefParameters Then Modified;
  End;
End;


//***************************************************************************************************************************
Function TMasterFieldsEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TMasterFieldsEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TMasterFieldsEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

Procedure TMasterFieldsEditor.Edit;
Var
 MT,DT        : TKADaoTable;
 MF,DF,TF     : TStrings;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if NOT Assigned(DT.F_Database) Then Exit;
    If Not (DT.F_Database.Connected) Then Exit;
    if Not Assigned(DT.MasterSource) Then
       Begin
        DT.F_Master.Clear;
        DT.F_Detail.Clear;
        DT.F_MasterFields.Clear;
        DatabaseError(E2052);
        Exit;
       End;
    if NOT (DT.MasterSource.DataSet is TKADaoTable) Then
       Begin
        DT.F_Master.Clear;
        DT.F_Detail.Clear;
        DT.F_MasterFields.Clear;
        DatabaseError(E2053);
        Exit;
       End;
    MT:=DT.MasterSource.DataSet As TKADaoTable;
    if (DT.Active=False) and Not (csLoading in DT.ComponentState) Then
       Begin
         Try
           DT.Active:=True;
           DT.Active:=False;
         Except
           DT.F_Master.Clear;
           DT.F_Detail.Clear;
           DT.F_MasterFields.Clear;
           DatabaseError(E2054);
           Exit;
         End;
       End;
    if (MT.Active=False) and Not (csLoading in DT.ComponentState) Then
       Begin
         Try
           MT.Active:=True;
           MT.Active:=False;
         Except
           DT.F_Master.Clear;
           DT.F_Detail.Clear;
           DT.F_MasterFields.Clear;
           DatabaseError(E2055);
           Exit;
         End;
       End;
    MF     := TStringList.Create;
    DF     := TStringList.Create;
    TF     := TStringList.Create;
    MF.SetText(MT.F_MDFieldNames.GetText);
    DF.SetText(DT.F_MDFieldNames.GetText);
    TF.SetText(DT.F_MasterFields.GetText);
    Application.CreateForm(TMasterDetailForm,MasterDetailForm);
    if MasterDetailForm.Execute(DF,MF,TF) Then;
    MasterDetailForm.Free;
    DT.MasterFields:=TF;
    MF.Free;
    DF.Free;
    TF.Free;
    Modified;
  End;
End;
//***************************************************************************************************************************

Procedure Register;
Begin
    RegisterComponents('KA Dao', [TKADaoTable]);
    RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'TableName',TTableNameEditor);
    RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'QueryDefName',TQueryNameEditor);
    RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'IndexName',TIndexNameEditor);
    RegisterPropertyEditor(TypeInfo(Integer),TKADaoTable,'TableType',TTableTypeEditor);
    RegisterPropertyEditor(TypeInfo(Integer),TKADaoTable,'LockType',TLockTypeEditor);
    RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'SortedBy',TSortByEditor);
    RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'QueryDefParameters',TQueryDefParamsEditor);
    RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'MasterFields',TMasterFieldsEditor);
End;
end.

