unit ODBCDialogUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TODBCDialog = class(TForm)
    RadioGroup1: TRadioGroup;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Button1: TButton;
    Button2: TButton;
    procedure RadioGroup1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Function Execute(SysDsn,UsrDsn:TStrings; Var DsnString:String):Boolean;
  end;

var
  ODBCDialog  : TODBCDialog;

implementation
{$R *.DFM}
Var
 Resultat : String;

procedure TODBCDialog.RadioGroup1Click(Sender: TObject);
begin
  if RadioGroup1.ItemIndex=0 Then
     Begin
       ComboBox1.Enabled:=True;
       ComboBox2.Enabled:=False;
     End
  Else
     Begin
       ComboBox1.Enabled:=False;
       ComboBox2.Enabled:=True;
     End;
end;

procedure TODBCDialog.Button2Click(Sender: TObject);
begin
  ModalResult:=mrCancel;
end;

procedure TODBCDialog.Button1Click(Sender: TObject);
begin
  ModalResult:=mrOk;
  if RadioGroup1.ItemIndex=0 Then
     Begin
       Resultat:=ComboBox1.Items.Strings[ComboBox1.ItemIndex];
     End
  Else
     Begin
       Resultat:=ComboBox2.Items.Strings[ComboBox2.ItemIndex];
     End;
end;

Function TODBCDialog.Execute(SysDsn,UsrDsn:TStrings; Var DsnString:String):Boolean;
begin
  ComboBox1.Clear;
  ComboBox2.Clear;
  ComboBox1.Items.SetText(SysDsn.GetText);                
  ComboBox2.Items.SetText(UsrDsn.GetText);
  ComboBox1.ItemIndex:=0;
  ComboBox2.ItemIndex:=0;
  if ComboBox1.Items.IndexOf(DsnString) > -1 Then
     Begin
       RadioGroup1.ItemIndex:=0;
       ComboBox1.Enabled:=True;
       ComboBox2.Enabled:=False;
       ComboBox1.ItemIndex:=ComboBox1.Items.IndexOf(DsnString);
     End;
  if ComboBox2.Items.IndexOf(DsnString) > -1 Then
     Begin
       RadioGroup1.ItemIndex:=1;
       ComboBox1.Enabled:=False;
       ComboBox2.Enabled:=True;
       ComboBox2.ItemIndex:=ComboBox2.Items.IndexOf(DsnString);
     End;
  if ShowModal=mrOK Then
     Begin
       Result := True;
       DsnString:=Resultat;
     End
     Else Result := False;
end;

end.
