{$B-}
unit KDaoTable;
//******************************************************************************
//                         Delphi Dao Project
//                 Copyright (c) 2000 by Kiril Antonov
//******************************************************************************
{$DEFINE USEPARAMS}
{$DEFINE DYNADAO}     //  This is the preffered way to use DAO - disable if
                      //       one of the bottom options are enabled
{DEFINE DAO35}        //  Disable DYNADAO and DAO36 to USE
{DEFINE DAO36}        //  Disable DYNADAO and DAO35 to USE
//******************************************************************************
// Protection for absent-minded people
//******************************************************************************
{$IFDEF DYNADAO}
  {$IFDEF DAO36}
   YOU CANNOT DEFINE BOTH DYNADAO AND DAO36
  {$ENDIF}                                                  
  {$IFDEF DAO35}
   YOU CANNOT DEFINE BOTH DYNADAO AND DAO35
  {$ENDIF}
{$ELSE}
  {$IFDEF DAO36}
     {$IFDEF DAO35}
        YOU CANNOT DEFINE BOTH DAO35 AND DAO36
     {$ENDIF}
  {$ENDIF}
{$ENDIF}

//******************************* CHANGES **************************************
// 28.05.2000 - Fixed a minor bug which raises exception when
//              getting GetQueryDefSQLText
// 28.05.2000 - Added FieldChanged TList - each item corresponds to a field
//              in the record
//              If  Boolean(FieldChanged[X]) is true then when posting data this
//              field is updated
//              This prevents from writing bak entire record to the database -
//              only changed fields are posted.
// 28.05.2000 - Added new property editor for SortedBy property which allows an
//              easy method to define sort order of a Table/Query
//              A new property SortedByText gives low level access to the
//              SortedBy property
// 28.05.2000 - Added new property editor for QueryDefParameters property which
//              allows an easy method to enter parameters to QUERYDEF dao object
//              A new property QueryDefParametersText gives low level access to
//              the QueryDefParameters property
// 30.05.2000 - Fixed a bug in GetRecNo which gives some troubles with DBGrids
//
// 31.05.2000 - Changed InternalSetToRecord method to speedup positioning inside
//              a table
//
// 01.06.2000 - Created Master/Detail Relationship support with property editor
//              similar to Delphi
//              A few new properties are anounced:
//                - MasterSource : TDataSource; - DataSource of the Master Table
//                - MasterFields : TStrings;    - A StringList with
//                  relationships in the form: "DetailField -> MasterField"
// 04.06.2000 - Handled default values for fields
//
// 07.06.2000 - Handled empty fields (WITH NOT REQUITRED VALUE)
//              when posting new records to database
//
// 08.06.2000 - Added support for Dynamycally setting DAO Version
//
// 11.06.2000 - Filter is working properly now
//
// 11.06.2000 - Added FULL support for Master/Detail (Table and Query)
//
// 11.06.2000 - Changed many options for Bookmarks
//              to support Dynamic DAO (OleVariant)
//
// 11.06.2000 - Added support for Locate
//
// 11.06.2000 - Added support for Lookup
//
// 12.06.2000 - InternalGotoBookmark rewrited completely
//
// 12.06.2000 - Locate supports TLocateOptions now
//
// 12.06.2000 - Added four new methods:
//              CreateField
//              CreateIndex
//              DeleteField
//              DeleteIndex
//
// 14.06.2000 - Property Editors for Tables, QueryDefs and Indexes use
//              RefreshDefinitions to reflect changes made outside Delphi
//
// 18.06.2000 - Added another method of Locate whish is very fast but works only
//              if Table supports bookmarks
//
// 18.06.2000 - Added GetIndexNames method for Compatibility with TTable
//
// 18.06.2000 - Added FOUR New methods for fast search in a table:
//                Find_First
//                Find_Last
//                Find_Next
//                Find_Prior
//              These new methods are similar to TTable but can search on
//              NON-INDEXED fields
//              Call them as calling Locate method
// 19.06.2000 - Two new method where added  Find_Nearest and Find_NearestEx
//              Call Find_NearestEx as calling a Locate method
//              For Find_Nearest you must first call SetKeyFields method with a
//              semicolon separated Field names and then Call Find_Nearest
//              See the new demos on KADao site for full explanation
// 19.06.2000 - Added new method Seek_Nearest
//              Seek_Nearest works as Dao Seek method so you must set the index
//              in which you want to search
//              See the new demos on KADao site for full explanation
//
// 19.06.2000 - Fixed a minor bug with empty tables
//
// 19.06.2000 - Added support for OnFilterRecord event
//              GetRecordCount And GetRecNo now works as standard specifications
//              require
//
// 27.06.2000 - Added CompareBookmarks method - now multiselect in DBGrid
//              works fine
//
// 28.06.2000 - Added GetFieldNames - it receives as a parameter TStringList
//              and fills them with Names of the fields
//              Each Name has a corresponding TObject wich is an integer
//              describing a Field original DAO type (Not BDE type)
//
// 28.06.2000 - Added QueryDefODBCMaxRecords (works only on ODBC data sources)
//              to limit number of returned records
//              Setting to 0 means NO LIMIT
//
// 28.06.2000 - Added QueryDefType property - it returns a QueryDef Type
//              as a string. Original DAO value is stored in QueryDefTypeInt
//
// 28.06.2000 - Added RecordsAffected variable
//              When using  ExecSQL it teturns then number of affected records
//              and also sets RecordsAffected to the same value.
//
// 28.06.2000 - Added Requery method which is useful for refreshing dynaset
//              tables
//
// 28.06.2000 - Added Seek_NearestEx method
//              An additional parameter is SeekType (String) which can be one of
//              the following: '<', '<=', '=', '>=', '>'
//
// 28.06.2000 - Added SetRecNo internal dataset method (still in beta testing)
//
// 28.06.2000 - Added two new variables BlobOffset and BlobNumBytes
//              Whend one of this variables is different then zero
//              reading from a blob field starts from BlobOffset position
//              and the return information is BlobNumBytes in size
//              When BlobNumBytes is > of entire blob size a smaller amount
//              of bytes is returned (realized using DAO GetChunk method)
//              Warninng! This is blob wide i.e. all blobs are affected
//              So you must set them to Zero each time when the another blob
//              which must be read at all is readed from the record
//
// 28.06.2000 - Added two new read only properties TableDateCreated and
//              TableLastUpdated - works only on standart tables and QueryDefs
//
// 28.06.2000 - Added a new meton AppendToBlob - uses DAO AppendChunk method
//
// 29.06.2000 - Added a new variable QueryDefReturnParams of type OleVariant
//              It contains a results from a QueryDefRecordset
//              If result is only one QueryDefReturnParams is a single variant
//              otherwise QueryDefReturnParams is VarArray
//
// 29.06.2000 - AT LAST FIXED PROBLEM WITH EMPTY RECORDESTS - GREAT VICTORY!!!!
//
// 29.06.2000 - Removed SetRecNo internal dataset method (not yet understand)
//
//
// 03.07.2000 - Added new property UseRecordCount
//              Since DBGrid uses RecordCount Very extensivelly which can
//              slowdown database performance you can turn it off by setting
//              UseRecordCount
//
// 04.07.2000 - AT LAST FIXED PROBLEM WITH RETRIEVING ACTUAL TYPE OF
//              dbDate FIELD TYPE - NOW YOU CAN USE dbTime AND dbTimeStamp !!!
//
// 05.07.2000 - Fixed a very rediculous bug with RETRIEVING ACTUAL TYPE OF
//              dbDate FIELD. Now a ftDateTime is the default type
//              But if you set Format property in MS Acess a dbDate and dbTime
//              also is used!
// 05.07.2000 - Added additional code to DateTimeToBuffer and TimeToBuffer
//              routines to support both method of retrieving Date/Time info
//
// 05.07.2000 - Added support for Forward Only Tables - Works Good but
//              DBGrid violates forward only restrictions so use with care
//              A more complicated changes will be made in future to avoid these
//
// 17.07.2000 - Fixed a bug which does not free allocated resources in Append
//              With many thanks to Andrew Baylis for reporting the problem
//
// 19.07.2000 - Added new property UseBrackets - True by default
//              It places Field names in squire brackets "[ ]" when using
//              Locate, Lookup, and Master/Detail
//              Since squire brackets are MS Access specific turn this property
//              to FALSE when using other databases than MDB
//
// 19.07.2000 - Added support for working with part of all fields
//              I.E Field Designer is supported now
//              Not copletely tested but working
//
// 21.07.2000 - Added few new Exec Functions
//                - ExecuteSQL - Executes SQL stored in SQL Property
//                - ExecuteQueryDefSQL - Executes SQL stored selected
//                  by QueryDefName QueryDef
//
// 21.07.2000 - Added Property LockEdits for Locking Recods at runtime
//              Immediatly after you call Edit metod locking is activa
//
// 24.07.2000 - Added new method for Locating data
//              If table type is dbOpenTable and IndexName <> ''
//              then locate tryes to use selected index when searching
//              otherwise a standard search is executed
//
// 30.07.2000 - Added new property SQLExecutionType for use when executing SQL
//              by default it is DaoApi.dbFailOnError but you may use andother
//              constants like DaoApi.dbSQLPassThrough
//              (With many thanks to to Baldemaier Florian for this)
//
// 31.07.2000 - Fixed ALL problems with ACCESS Date and Time conversion
//              All Borland types i.e ftDate, ftDateTime and ftTime can be used
//              now. The magic number is 693594. Do you know why? I know!
//
// 31.07.2000 - Added new method for Find_First, Find_Next Etc..
//              if somebody encounter problems please report ...
//
// 04.08.20000 - A specific change made to Locate
//               her must be written a some special notes to use locate with
//               an index
//               Microsoft has made strange things with its Seek method
//               So to work with indexes you must create index containing ALL
//               fields you willlocate on and no EXTRA fields in this index
//               Otherwise Locate will use non index based method
//               And Microsoft's limitation is 13 fileds maximum (0..12)
//               Have a nice locating! :-)
//               P.S If somebody encounter problems please report ...
//
// 14.08.2000  - The TKBlobStream.Truncate Procedure was rewritten becouse
//               it does not clear Blob fields proprly - lets say it was doing
//               NOTHING. Now it works fine
//               With many thanks to Andrew Baylis for reporting the problem
//
//
// 14.08.2000  - Changed SetFieldData so Field.Clear to work
//               With many thanks to Andrew Baylis for reporting the problem
//
// 15.08.2000  - Added some features to speedup adding new records
//               Now a new system var F_UpdatableFields of type tlist
//               presents all records that can be updated                   
//               if Boolean(F_UpdatableFields.Items[xxx]) then field can
//               be changed
//               Also a Resync[] in Internal Post is blocked
//               P.S If somebody encounter problems please report ...
// 18.02.2000  - Added a fix to SortedbyDialogEditor to use brackets
//               With many thanks to Baldemaier Florian for reporting problem
//
// 22.08.2000  - Fixed a bug with setting LockEdits property on tables which
//               does not support Locking
//               With many thanks to Dave Zangger for reporting problem
//
// 28.08.2000  - Fixed a bug with generating SQL for Lookup, Locate etc
//               a ftSmallInt and ftWord was missing. Now included
//               Thanls to Analisis y Estudios Financieros for reporting problem
//
// 29.08.2000  - Added some code for QueryDefTimeOut and ODBCTimeOut
//
// 31.08.2000  - Added IsEmpy Checking for Locate, Lookup and Find methods
//               With many thanks to Jiri Kanda for reporting problem
//
// 07.09.2000 - GetRecNo now retuns a 1 based value not a zero bazed
//              Most of TDatasets do so - also this helps on dbGrids
//              Thanls to Jiri Kanda again
//
// 08.09.2000 - Fixed a bug in F_Set_Filtered method thanks to Oliver Hger
//
// 21.09.2000 - Fixed a strange DAO bug in QueryDefs when concatenating
//              dbText fields. Dao returns ZERO for the result field length.
//              Now this situation is handled - result size is 255!
//              Thanls to Tom Peiffer for reporting problem
//
// 21.09.2000 - Added GotoCurrent Method - same as TTable.GotoCurrent
//
// 01.10.2000 - Fixed a VERY BIG bug with RecordLocking.
//              My apologese to everybody that report problems with
//              record locking. But Borland nas NO Documentation about
//              internal TDataset routines. Now all is OK
//
// 01.10.2000 - Fixed a bug with ExecuteQueryDefSQL - it does not handle
//              QueryDefParameters but now they are supported
//              Thanls to Jiri Kanda for reporting the problem
//
// 01.10.2000 - Fixed a bug with Requery - it does not handle
//              QueryDefParameters but now they are supported
//
// 01.10.2000 - Added support for ftAutoInc
//
// 01.10.2000 - Added two new functions
//                  - GetSourceTableName
//                  - GetSourceFieldName
//              They are very usual to find source TableName and FieldName when
//              using a result from join query and want to find which is the
//              origin of the field in join table
//
// 01.10.2000 - Added support for BookmarkValid function
//              Note that after calling BookmarkValid current record is cahnged
//              to those pointed by passed TBookmark to BookmarkValid
//
// 01.10.2000 - Added New Function PercentPosition to get info from DAO method
//              PercentPosition. See DAO help for details
//
// 01.10.2000 - Added New Function GetRows(NumRows:Integer):OleVariant
//              This function returns Two dimaensional variant array
//              with NumRows number of records and all fields.
//              This is a interface to DAO Method GetRows - see DAO help
//              Function positions current record at the next unread record.
//
// 02.10.2000  - Added Support for Parametrized queryes (stored in SQL property)
//               Unfortenatelly this does not work with Delphi 3.0
//               Also it is not tested with Delphi 4.0
//               If you encounter problems during compiltion please UNDEFINE
//               USEPARAMS at the begining of this file.
//               Thanks to Andrew Baylis for all this.
//               Any help how to implement this on Delphi 3.0 will be
//               greatly appreciated.
//
// 02.10.2000  - Dramatically Increased speed of the following methods
//                Find_First
//                Find_Last
//                Find_Next
//                Find_Prior
//
// 02.10.2000  - Added changes for Bookmark (previously TSafeArray, now
//               OleVariant (it is Interesting that in fact bookmarks are
//               OleStrings;
//
// 02.10.2000  - Speed of Bookmark operations is Dramatically Increased
//
// 10.10.2000  - Fixed a bug in ExecSQL,ExecutSQL,ExecuteQueryDefSQL
//               Thanls to D. Gene Bland for reporting the problem
//
// 11.10.2000  - Fixed a bug in BuildXXXSQL routines
//               They now support ftAutoInc Field
//               Thanls to Paul Weaver for reporting the problem
//
// 13.10.2000  - Fixed another bug in BuildXXXSQL routines
//               Thanls to Manfred Zieglmeier for reporting the problem
//
// 13.10.2000  - Fixed a bug with OnPostError Event
//               Now OnPostError is supported
//               Thanls to Henry Martin for reporting the problem
//
// 17.10.2000  - Added eight new routines for some compatibility with TTable
//               See explanation in KADao Help docs.
//
//               Procedure FindNearest(const KeyValues: array of const);
//               Function  FindKey(const KeyValues: array of const):Boolean;
//               Property  IndexFieldCount : Integer Read F_IndexFieldCount;
//               Property  IndexFields[Index: Integer]: TField read F_Get_IndexField write F_Set_IndexField;
//               Procedure SetFindData(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions);
//               Procedure SetKey(const KeyFields: Array of String;const KeyValues: array of const);
//               Function  GotoKey: Boolean;
//               Procedure LockTable(LockType: TLockType);
//               Procedure UnlockTable(LockType: TLockType);
//               Property  IndexFieldNames : String Read F_Get_IndexFieldNames Write F_Set_IndexFieldNames;
//
//******************************************************************************

//******************************************************************************


interface
uses
DAOApi,
{$IFDEF DAO35}
DAO35Api,
{$ENDIF}
{$IFDEF DAO36}
DAO36Api,
{$ENDIF}
Windows, SysUtils, Classes, Db, DBCommon, KDaoDataBase, DsgnIntf, ActiveX, Forms;



const
        MYBOOKMARKSIZE=8;

Type
TBlobData = String;

TDaoInfo=record
        RecordNo        : Integer;
        RecordData      : TStringList;
        FieldChanged    : TList;
        BookmarkFlag    : TBookmarkFlag;
        BookmarkData    : Integer;
        BookmarkString  : array[0..MYBOOKMARKSIZE] of Char;
End;
PDaoInfo=^TDaoInfo;

TLockType = (ltReadLock, ltWriteLock);

TOO    = (
          dbDenyWrite,
          dbDenyRead,
          dbReadOnly,
          dbAppendOnly,
          dbInconsistent,
          dbConsistent,
          dbSQLPassThrough,
          dbFailOnError,
          dbForwardOnly,
          dbSeeChanges,
          dbRunAsync,
          dbExecDirect
          );
TOOSet = Set of TOO;

TTableNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TQueryNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TIndexNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TTableTypeEditor = class(TIntegerProperty)
    Public
     Function  GetValue: string; override;
     Procedure GetValues( Proc: TGetStrProc);override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TLockTypeEditor = class(TIntegerProperty)
    Public
     Function  GetValue: string; override;
     Procedure GetValues( Proc: TGetStrProc);override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TSortByEditor = class(TStringProperty)
    Public
     Function  GetValue: string; override;
     Procedure Edit;override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TQueryDefParamsEditor = class(TStringProperty)
    Public
     Function  GetValue: string; override;
     Procedure Edit;override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TMasterFieldsEditor = class(TStringProperty)
    Public
     Procedure Edit;override;
     Function GetValue: string; override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TMasterSourcePropertyEditor = class(TPropertyEditor)
    public
      Function GetAttributes: TPropertyAttributes; override;
      Function  GetValue: String; override;
      Procedure GetValues(Proc: TGetStrProc); override;
      Procedure SetValue(const Value: String); override;
  End;

TKADaoTable = class;
TKADAODataLink = class(TMasterDataLink)
    private
      F_KADaoTable        : TKADaoTable;
      F_MasterIsChanged   : Boolean;
    protected
      Procedure ActiveChanged; override;
      Procedure RecordChanged(Field: TField); override;
      {$IFNDEF VER100}
        {$IFNDEF VER110}
      Function  GetDetailDataSet: TDataSet; override;
        {$ENDIF}
      {$ENDIF}
      Procedure CheckBrowseMode; override;
    public
      constructor Create(DataSet: TKADaoTable);
  End;

TKADaoTable = class(TDataSet)
private
        F_Active          : Boolean;
        F_RecNo           : Integer;
        F_RecPos          : Integer;

        F_BookmarkRN      : TList;
        F_BookmarkID      : TList;

        F_FilterBuffer    : PChar;
        F_BufferSize      : Integer;
        F_StartMyInfo     : Integer;
        F_StartCalc       : Integer;
        F_MDisabled       : Boolean;
        F_KeyFields       : TStringList;
        F_UpdatableFields : TList;
        {$IFDEF USEPARAMS}
          {$IFNDEF VER100}
            {$IFNDEF VER110}
        F_ParamCheck      : Boolean;
        F_Params          : TParams;
            {$ENDIF}
          {$ENDIF}
        {$ENDIF}

        Function        GetActiveRecordBuffer:  PChar;
        Function        FilterRecord(Buffer: PChar): Boolean;
        Function        AddLeadingZeros(Value:String):String;
protected
        F_Database               : TKADaoDatabase;
        F_ReadOnly               : Boolean;
        F_LockEdits              : Boolean;
        {$IFDEF DYNADAO} //****************************************************
        F_DaoTable               : OleVariant;
        {$ELSE}
        F_DaoTable               : Recordset;
        {$ENDIF}
        F_SQL                    : TStrings;
        F_SortedBy               : TStrings;
        F_FieldNames             : TStrings;
        F_FieldTypeNames         : TStrings;
        F_DefaultValues          : TStrings;
        F_MDFieldNames           : TStrings;

        F_QD_ParamNames          : TStrings;
        F_QD_ParamDaoTypes       : TStrings;
        F_QD_ParamBDETypes       : TStrings;
        F_QueryDefMaxRecords     : Integer;
        F_QueryDefType           : String;

        F_MasterLink             : TKADAODataLink;
        F_MasterFields           : TStrings;
        F_UseBrackets            : Boolean;

        F_Detail                 : TStrings;
        F_Master                 : TStrings;

        F_UseRecordCount         : Boolean;
        F_Filtered               : Boolean;
        F_Filter                 : String;
        F_OnFilterRecord         : TFilterRecordEvent;

        F_TableName              : String;
        F_QueryDefName           : String;
        F_QueryDefParameters     : TStrings;
        F_QueryDefSQLText        : TStrings;
        F_IndexName              : String;
        F_IndexFieldCount        : Integer;
        F_TableType              : Integer;
        F_LockType               : Integer;
        F_OpenOptions            : TOOSet;
        F_RecordSize             : Integer;

        F_FindKeyFields          : String;
        F_FindKeyValues          : Variant;
        F_FindOptions            : TLocateOptions;

        F_KeyKeyFields           : String;
        F_KeyKeyValues           : Variant;

        F_DateCreated            : String;
        F_LastUpdated            : String;
        F_OLE_ON                 : Boolean;
        F_ComponentVersion       : String;


        Procedure       F_Set_ComponentVersion(Value: String);
        Function        F_Get_Database:TKADaoDatabase;
        Procedure       F_Set_Database(Value:TKADaoDatabase);
        Function        F_Get_TableName:String;
        Procedure       F_Set_TableName(Value:String);
        Function        F_Get_DateCreated:String;
        Function        F_Get_LastUpdated:String;

        Function        F_Get_IndexName:String;
        Procedure       F_Set_IndexName(Value:String);
        Function        F_Get_IndexFieldNames:String;
        Procedure       F_Set_IndexFieldNames(Value:String);

        Procedure       F_Set_TableType(Value:Integer);
        Procedure       F_Set_LockType(Value:Integer);
        Procedure       F_Set_OpenOptions(Value:TOOSet);
        Procedure       F_Set_ReadOnly(Value:Boolean);
        Procedure       F_Set_LockEdits(Value:Boolean);
        Procedure       F_Set_Sort(Value:TStrings);

        Procedure       F_Set_SQL(Value:TStrings);
        Procedure       F_Set_QueryDefName(Value:String);
        Procedure       F_Set_QueryDefParameters(Value:TStrings);
        Procedure       F_Set_QueryDefSQLText(Value:TStrings);
        Function        F_Get_QueryDefType:String;

        Procedure       F_Set_UseRecordCount(Value: Boolean);

        Function        F_Get_MasterSource: TDataSource;
        Procedure       F_Set_MasterSource(Value: TDataSource);
        Procedure       F_ProcessMasterFields(Value:TStrings);
        Procedure       F_Set_MasterFields(Value:TStrings);

        Procedure       F_Set_Master(Value:TStrings);
        Procedure       F_Set_Detail(Value:TStrings);
        Function        F_ComposeSQL(SQL:TStrings):String;

        Procedure       F_Set_Filtered(Value:Boolean);
        Procedure       F_Set_Filter(Value:String);
        Procedure       F_Set_OnFilterRecord(Value: TFilterRecordEvent);

        Function        F_Get_IndexField(Index: Integer): TField;
        Procedure       F_Set_IndexField(Index: Integer; Value: TField);


        {$IFDEF USEPARAMS}
          {$IFNDEF VER100}
            {$IFNDEF VER110}
        Procedure SetParamsList(Value: TParams);
        Procedure UpdateParamsList(Sender: TObject);
        Procedure WriteParamData(Writer: TWriter);
        Function  GetParamsCount: Word;
        Procedure DefineProperties(Filer: TFiler); override;
        Procedure ReadParamData(Reader: TReader);
            {$ENDIF}
          {$ENDIF}
        {$ENDIF}

        Function        InternalCalcRecordSize:Integer;
        Function        IntegerToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        FloatToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        BooleanToBuffer(Buffer: Pointer; S: String): Boolean;

        Function        DateToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        TimeToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        DateTimeToBuffer(Buffer: Pointer; S: String): Boolean;

        Function        BufferToDate(Buffer: Pointer): String;
        Function        BufferToTime(Buffer: Pointer): String;
        Function        BufferToDateTime(Buffer: Pointer): String;

        Procedure       OpenDaoRecordset;
        Procedure       GetQueryDefReturnParams(QueryDefName:String);
        Procedure       CloseDaoRecordset;

        Procedure       InternalOpen; override;
        Procedure       InternalClose; override;
        Function        IsCursorOpen: Boolean; override;
        Function        GetCanModify: Boolean; override;
        Function        GetRecordSize: Word;override;
        Function        AllocRecordBuffer: PChar; override;
        Procedure       FreeRecordBuffer(var Buffer: PChar); override;
        Function        GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
        Procedure       InternalInitFieldDefs; override;
        Procedure       InternalInitRecord(Buffer: PChar); override;
        Procedure       SetFieldData(Field: TField; Buffer: Pointer);override;
        Procedure       ClearDBCalcFields(Buffer: PChar);


        //*********************************************** Navigation and Editing
        Procedure       InternalFirst;override;
        Procedure       InternalLast;override;
        Procedure       InternalSetToRecord(Buffer: PChar); override;
        Procedure       InternalEdit; override;
        Procedure       InternalCancel; override;
        Procedure       InternalPost; override;
        Procedure       InternalAddRecord(Buffer: Pointer; Append: Boolean); override;
        Procedure       InternalDelete; override;
        Procedure       InternalRefresh; override;
        //***********************************************
        Function        GetDaoBookMark(RS:Variant):Integer;
        Procedure       InternalClearBookmarks;
        Procedure       InternalGotoBookmark(Bookmark: Pointer); override;


        Function        GetBookmarkFlag(Buffer: PChar): TBookmarkFlag; override;
        Procedure       SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag); override;

        Function        GetBookmarkStr: TBookmarkStr; override;
        Procedure       SetBookmarkStr(const Value: TBookmarkStr); override;

        Procedure       GetBookmarkData(Buffer: PChar; Data: Pointer); override;
        Procedure       SetBookmarkData(Buffer: PChar; Data: Pointer); override;


        Procedure       InternalHandleException; override;
        Procedure       DataEvent(Event: TDataEvent; Info: Longint); override;

        Function        GetRecordCount  : Integer; override;
        Function        GetRecNo        : Integer; override;

        //************************************************* TTable Compatibility
        Function        FindRecord(Restart, GoForward: Boolean): Boolean; override;
        //************************************************* TTable Compatibility

        Procedure       StringToList(Items: String; List: TStringList);
        Procedure       VariantToList(Items: Variant; List: TStringList);
        Procedure       AssignVarValue(Var V :Variant;const Value: TVarRec);
        Function        BuildKeySQL(KN,KV:TStringList):String;
        Function        BuildLocateSQL(KN,KV:TStringList;Options: TLocateOptions):String;
        Function        BuildDetailSQL  : String;

        Function        Find(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions;FindType:Integer): Boolean;
        Function        InsertSQLString(MDString: String): String;
        Procedure       MasterDSChanged;
        Procedure       Notification(AComponent: TComponent; Operation: TOperation); override;
  public
        MainDatabaseShutdown             : Boolean;
        QueryDefTypeInt                  : Integer;
        QueryDefReturnParams             : OleVariant;
        RecordsAffected                  : Integer;

        BlobOffset                       : Integer;
        BlobNumBytes                     : Integer;

        {$IFDEF DYNADAO}
        CoreRecordset                    : OleVariant;
        {$ELSE}
        CoreRecordset                    : Recordset;
        {$ENDIF}
        SQLExecutionType                 : Integer;
        Constructor                        Create(AOwner: TComponent); override;
        Destructor                         Destroy; override;
        Function                           GetFieldData(Field: TField; Buffer: Pointer): Boolean; override;
        Function                           CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream; override;
        Function                           AppendToBlob(Field: TField; Data:String):Boolean;

        Procedure                          SetKeyFields(const KeyFields: string);
        Function                           GetFieldIndexName(FiledName:String):String;
        Function                           CheckFieldsInIndex(KF:TStringList):Boolean;
        Function                           Find_First(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Last(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Next(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Prior(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Nearest(const KeyValues: array of const):Boolean;
        Function                           Find_NearestEx(const KeyFields: string; const KeyValues: Variant):Boolean;
        Function                           Seek_Nearest(const KeyValues: array of const):Boolean;
        Function                           Seek_NearestEx(const KeyValues: array of const; SeekType:String):Boolean;

        //*******************************  For TTable Compatibility
        Procedure                          FindNearest(const KeyValues: array of const);
        Function                           FindKey(const KeyValues: array of const):Boolean;
        Property                           IndexFieldCount : Integer Read F_IndexFieldCount;
        Property                           IndexFieldNames : String Read F_Get_IndexFieldNames Write F_Set_IndexFieldNames;
        Property                           IndexFields[Index: Integer]: TField read F_Get_IndexField write F_Set_IndexField;
        Procedure                          SetFindData(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions);
        Procedure                          SetKey(const KeyFields: Array of String;const KeyValues: array of const);
        Function                           GotoKey: Boolean;
        Procedure                          LockTable(LockType: TLockType);
        Procedure                          UnlockTable(LockType: TLockType);
        //*******************************  For TTable Compatibility

        Function                           Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean; override;
        Function                           Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant; override;

        Function                           CreateField(FieldName:String;FieldType:Integer;FiledSize:Integer):Boolean;
        Function                           CreateIndex(FieldName:String;IndexType:Integer):Boolean;
        Function                           DeleteField(FieldName:String):Boolean;
        Function                           DeleteIndex(FieldName:String):Boolean;
        Function                           EmptyTable:Boolean;

        Function                           CompareBookmarks(Bookmark1, Bookmark2: TBookmark): Integer; override;
        Function                           BookmarkValid(Bookmark: TBookmark): Boolean; override;
        Function                           GetRows(NumRows:Integer):OleVariant;
        Property  MasterLink             : TKADAODataLink read F_MasterLink;
        Property  FieldNames             : TStrings Read F_FieldNames;
        Property  LinkableFields         : TStrings Read F_MDFieldNames;

        {$IFDEF USEPARAMS}
          {$IFNDEF VER100}
            {$IFNDEF VER110}
        Property ParamCount              : Word read GetParamsCount;
            {$ENDIF}
          {$ENDIF}
        {$ENDIF}
        Function                           ExecSQL(SQL:TStrings):Integer;
        Function                           ExecuteSQL:Integer;
        Function                           ExecuteQueryDefSQL:Integer;

        Function                           Requery : Boolean;
        Procedure                          GotoCurrent(Table: TKADaoTable);

        Procedure                          GetIndexNames(List: TStrings);
        Procedure                          GetFieldNames(List: TStrings);
        Function                           PercentPosition:Single;
        Function                           GetSourceFieldName(FieldName:String):String;
        Function                           GetSourceTableName(FieldName:String):String;
        Function                           GetLastDaoError:TDaoErrRec;
        Function                           PropertyExists(PropObject:OleVariant;PropertyName:String):Boolean;

  published
        Property ComponentVersion        : String  Read F_ComponentVersion Write F_Set_ComponentVersion;
        Property Database                : TKADaoDatabase Read F_Get_Database Write F_Set_Database;
        Property TableName               : String Read F_Get_TableName Write F_Set_TableName;
        Property SortedBy                : TStrings Read F_SortedBy Write F_Set_Sort;
        Property SortedByText            : TStrings Read F_SortedBy Write F_Set_Sort;
        Property QueryDefName            : String Read F_QueryDefName Write F_Set_QueryDefName;
        Property QueryDefParameters      : TStrings Read F_QueryDefParameters Write F_Set_QueryDefParameters;
        Property QueryDefParametersText  : TStrings Read F_QueryDefParameters Write F_Set_QueryDefParameters;
        Property QueryDefSQLText         : TStrings Read F_QueryDefSQLText Write F_Set_QueryDefSQLText;
        Property QueryDefODBCMaxRecords  : Integer Read F_QueryDefMaxRecords Write F_QueryDefMaxRecords;
        Property QueryDefType            : String Read F_Get_QueryDefType Write F_QueryDefType;
        Property SQL                     : TStrings Read F_SQL Write F_Set_SQL;
        {$IFDEF USEPARAMS}
          {$IFNDEF VER100}
           {$IFNDEF VER110}
        Property Params                  : TParams read F_Params Write SetParamsList Stored False;
           {$ENDIF}
         {$ENDIF}
        {$ENDIF}
        Property TableType               : Integer Read F_TableType Write F_Set_TableType;
        Property TableDateCreated        : String Read F_Get_DateCreated Write F_DateCreated;
        Property TableLastUpdated        : String Read F_Get_LastUpdated Write F_LastUpdated;
        Property LockType                : Integer Read F_LockType Write F_Set_LockType;
        Property OpenOptions             : TOOSet Read F_OpenOptions Write F_Set_OpenOptions;
        Property IndexName               : String Read F_Get_IndexName Write F_Set_IndexName;
        Property ReadOnly                : Boolean Read F_ReadOnly Write F_Set_ReadOnly;
        Property LockEdits               : Boolean Read F_LockEdits Write F_Set_LockEdits;
        Property MasterSource            : TDataSource Read F_Get_MasterSource Write F_Set_MasterSource;
        Property MasterFields            : TStrings Read F_MasterFields Write F_Set_MasterFields;
        Property UseRecordCount          : Boolean Read F_UseRecordCount Write F_Set_UseRecordCount;
        Property UseBrackets             : Boolean Read F_UseBrackets Write F_UseBrackets;
        Property Filtered                : Boolean Read F_Filtered Write F_Set_Filtered;
        Property Filter                  : String Read F_Filter Write F_Set_Filter;
        Property OnFilterRecord          : TFilterRecordEvent read F_OnFilterRecord write F_Set_OnFilterRecord;
        {$IFDEF USEPARAMS}
          {$IFNDEF VER100}
            {$IFNDEF VER110}
        Property ParamCheck              : Boolean Read F_ParamCheck Write F_ParamCheck;
            {$ENDIF}
          {$ENDIF}
        {$ENDIF}
        Property BeforeOpen;
        Property AfterOpen;
        Property BeforeClose;
        Property AfterClose;
        Property BeforeInsert;
        Property AfterInsert;
        Property BeforeEdit;
        Property AfterEdit;
        Property BeforePost;
        Property AfterPost;
        Property BeforeCancel;
        Property AfterCancel;
        Property BeforeDelete;
        Property AfterDelete;
        Property BeforeScroll;
        Property AfterScroll;
        Property OnCalcFields;
        Property OnDeleteError;
        Property OnEditError;
        Property OnNewRecord;
        Property OnPostError;

        Property Active;
End;


// Handle Memo fields
  TKBlobStream = class(TStream)
  private
    F_Field      : TBlobField;
    F_DataSet    : TKADaoTable;
    F_Buffer     : PChar;
    F_Mode       : TBlobStreamMode;
    F_Opened     : Boolean;
    F_Modified   : Boolean;
    F_Position   : Longint;
    F_BlobData   : TBlobData;
    F_BlobSize   : Integer;
  public
    constructor Create(Field: TBlobField; Mode: TBlobStreamMode);
    destructor Destroy; override;
    Function Read(var Buffer; Count: Longint): Longint; override;
    Function Write(const Buffer; Count: Longint): Longint; override;
    Function Seek(Offset: Longint; Origin: Word): Longint; override;
    Procedure Truncate;
  End;



Procedure Register;

implementation
Uses DaoUtils,Dialogs,SortByDialog,QueryDefDialogUnit,MasterDetailFormUnit;

Const
  CRLF=#13+#10;
//******************************************************************************
//******************************************************************************
constructor TKADaoTable.Create(AOwner: TComponent);
Var
  OLE_INIT:Integer;
Begin
  inherited Create(AOwner);
  F_ComponentVersion     := '3.5';
  F_TableName            := '';
  F_TableType            := dbOpenDynaset;
  F_LockType             := dbOptimistic;
  F_OpenOptions          := [];
  F_ReadOnly             := False;
  F_LockEdits            := False;
  F_UseRecordCount       := True;
  MainDatabaseShutdown   := False;
  F_QueryDefName         := '';
  F_QueryDefSQLText      := TStringList.Create;
  F_QueryDefSQLText.Clear;
  F_QueryDefMaxRecords   := 0;
  F_QueryDefType         := '';
  QueryDefTypeInt        := 0;
  RecordsAffected        := 0;
  F_SQL                  := TStringList.Create;
  F_SQL.Clear;
  F_SortedBy             := TStringList.Create;
  F_SortedBy.Clear;
  F_FieldNames           := TStringList.Create;
  F_FieldNames.Clear;
  F_FieldTypeNames       := TStringList.Create;
  F_FieldTypeNames.Clear;
  F_DefaultValues        := TStringList.Create;
  F_DefaultValues.Clear;
  F_MDFieldNames         := TStringList.Create;
  F_MDFieldNames.Clear;
  F_DateCreated          := '';
  F_LastUpdated          := '';
  //****************************************************************************
  F_QD_ParamNames        := TStringList.Create;
  F_QD_ParamNames.Clear;
  F_QD_ParamDaoTypes     := TStringList.Create;
  F_QD_ParamDaoTypes.Clear;
  F_QD_ParamBDETypes     := TStringList.Create;
  F_QD_ParamBDETypes.Clear;

  F_QueryDefParameters   := TStringList.Create;
  F_QueryDefParameters.Clear;
  SQLExecutionType       :=DaoApi.dbFailOnError;
  //****************************************************************************
  F_FindKeyFields        := '';
  F_FindKeyValues        := VarNull;
  F_FindOptions          := [];

  F_KeyKeyFields         := '';
  F_KeyKeyValues         := VarNull;
  //****************************************************************************
  F_MDisabled            := False;
  F_MasterFields         := TStringList.Create;
  F_MasterFields.Clear;
  F_MasterLink           := TKADAODataLink.Create(Self);
  F_Detail               := TStringList.Create;
  F_Detail.Clear;
  F_Master               := TStringList.Create;
  F_Master.Clear;
  F_KeyFields            := TStringList.Create;
  F_KeyFields.Clear;
  F_UpdatableFields      := TList.Create;
  F_UpdatableFields.Clear;

  F_BookmarkRN           := TList.Create;
  F_BookmarkRN.Clear;
  F_BookmarkID           := TList.Create;
  F_BookmarkID.Clear;

  F_UseBrackets          := True;
  //************************************************************
  BlobOffset             := 0;
  BlobNumBytes           := 0;
  //************************************************************
  F_Database             := Nil;
  //************************************************************
  {$IFDEF USEPARAMS}
   {$IFNDEF VER100}
    {$IFNDEF VER110}
  TStringList(F_SQL).OnChange := UpdateParamsList;
  F_ParamCheck                := True;
  F_Params                    := TParams.Create(Self);
    {$ENDIF}
   {$ENDIF}
  {$ENDIF}
  //************************************************************
  F_OLE_ON:=False;
  OLE_INIT:= CoInitialize(NIL);
  if (OLE_INIT = S_OK) or (OLE_INIT = S_FALSE) then F_OLE_ON:= True
  else DatabaseError('Unable to init OLE objects!');
End;

destructor TKADaoTable.Destroy;
Begin
  if F_Active Then
      Begin
        Try
         if State=dsEdit Then OleVariant(F_DaoTable).CancelUpdate;
        Except
        End;
        InternalClose;
        F_Active:=False;
      End;
  F_SQL.Free;
  F_SortedBy.Free;
  F_FieldNames.Free;
  F_FieldTypeNames.Free;
  F_DefaultValues.Free;
  F_MDFieldNames.Free;
  F_QueryDefParameters.Free;
  F_QueryDefSQLText.Free;
  F_QD_ParamNames.Free;
  F_QD_ParamDaoTypes.Free;
  F_QD_ParamBDETypes.Free;
  F_MasterLink.Free;
  F_MasterFields.Free;
  F_Detail.Free;
  F_Master.Free;
  F_KeyFields.Free;
  F_UpdatableFields.Free;

  F_BookmarkRN.Free;
  F_BookmarkID.Free;

  {$IFDEF USEPARAMS}
   {$IFNDEF VER100}
    {$IFNDEF VER110}
  F_Params.Free;
    {$ENDIF}
   {$ENDIF}
  {$ENDIF}
  {$IFDEF DYNADAO}
  F_DaoTable  := NULL;
  {$ELSE}
  F_DaoTable  := Nil;
  {$ENDIF}
  if F_OLE_ON then CoUninitialize;
  inherited Destroy;
End;

Procedure TKADaoTable.F_Set_ComponentVersion(Value: String);
Begin
 //*************************** ReadOnly
End;

Function TKADaoTable.ExecSQL(SQL:TStrings):Integer;
Begin
 Result:=0;
 RecordsAffected:=Result;
 if Assigned(F_Database) And (F_Database.Connected) Then
    Begin
      F_Database.CoreDatabase.Execute(F_ComposeSQL(SQL),SQLExecutionType);
      Result:=F_Database.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
    End
 Else
    DatabaseError('TKADaoTable.ExecSQL: Cannot execute SQL query while Database is not Assigned or Connected!');
End;

Function TKADaoTable.ExecuteSQL:Integer;
Begin
 Result:=0;
 RecordsAffected:=Result;
 if Assigned(F_Database) And (F_Database.Connected) Then
    Begin
      F_Database.CoreDatabase.Execute(F_ComposeSQL(SQL),SQLExecutionType);
      Result:=F_Database.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
    End
 Else
    DatabaseError('TKADaoTable.ExecuteSQL: Cannot execute SQL query while Database is not Assigned or Connected!');
End;

Function TKADaoTable.ExecuteQueryDefSQL:Integer;
Var
 X         : Integer;
 TabN      : String;
 NRP       : Integer;
 Dir       : Integer;
Begin
 Result:=0;
 RecordsAffected:=Result;
 if Assigned(F_Database) And (F_Database.Connected) And (F_QueryDefName <> '') Then
    Begin
      TabN:=F_QueryDefName;
      NRP:=0;
      For X:=0 To Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count-1 do
          Begin
            Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
            if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
                Begin
                 Try
                  Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[X].Value:=F_QueryDefParameters.Strings[NRP];
                  Inc(NRP);
                 Except
                  DatabaseError('Invalid number of QueryDef parameters or parameter is not in valid format!');
                 End;
                End;
          End;
      if F_Database.QueryTimeout <> 60 Then
      F_Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].ODBCTimeout:=F_Database.QueryTimeout;
      F_Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].Execute(SQLExecutionType);
      Result:=F_Database.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
      GetQueryDefReturnParams(F_QueryDefName);
    End
 Else
    DatabaseError('TKADaoTable.ExecuteQueryDefSQL: Cannot execute QueryDef - properties not assigned!');
End;

Function  TKADaoTable.Requery : Boolean;
Var
 X         : Integer;
 TabN      : String;
 NRP       : Integer;
 Dir       : Integer;
Begin
  Result:=False;
  If Not F_Active Then Exit;
  if Not F_DaoTable.Restartable Then Exit;
  if (F_QueryDefName <> '') Then
      Begin
        TabN:=F_QueryDefName;
        NRP:=0;
        For X:=0 To Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count-1 do
          Begin
            Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
            if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
                Begin
                 Try
                  Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[X].Value:=F_QueryDefParameters.Strings[NRP];
                  Inc(NRP);
                 Except
                  DatabaseError('Invalid number of QueryDef parameters or parameter is not in valid format!');
                 End;
                End;
          End;
      End;
  ClearBuffers;
  CheckBrowseMode;
  OleVariant(F_DaoTable).Requery;
  ActivateBuffers;
  First;
  Result:=True;
End;

Procedure TKADaoTable.GotoCurrent(Table: TKADaoTable);
Begin
  CheckBrowseMode;
  Table.CheckBrowseMode;
  if (AnsiCompareText(F_Database.Database, Table.Database.Database) <> 0) or
     (AnsiCompareText(TableName, Table.TableName) <> 0) then
     DatabaseError('Tables not point to the same DAO Table object');
  Table.UpdateCursorPos;
  First;
  MoveBy(Table.RecNo-1);
  Resync([rmExact, rmCenter]);
End;

Procedure TKADaoTable.GetIndexNames(List: TStrings);
Var
 Count,X : Integer;
Begin
  List.Clear;
  Try
    if Assigned(F_Database) And (F_Database.Connected) Then
     Begin
      F_Database.RefreshDefinitions;
      Count :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Count;
      For X := 0 to  Count-1 do
          Begin
            List.Add(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Name);
          End;
     End;
  Except
  End;
End;

Procedure TKADaoTable.GetFieldNames(List: TStrings);
Var
 Count, X, FT  : Integer;
Begin
  List.Clear;
  Try
     if Assigned(F_Database) And (F_Database.Connected) Then
     Begin
      F_Database.RefreshDefinitions;
      Count :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Count;
      For X := 0 to  Count-1 do
          Begin
            {$IFDEF DYNADAO}
            FT :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Item[X].Type;
            {$ELSE}
            FT :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Item[X].Type_;
            {$ENDIF}
            List.AddObject(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Item[X].Name,TObject(FT));
          End;
     End;
  Except
  End;
End;

Function TKADaoTable.PercentPosition:Single;
Begin
 Result := -1;
 Try
  if F_Active Then Result := F_DaoTable.PercentPosition;
 Except
 End; 
End;

Function  TKADaoTable.GetSourceFieldName(FieldName:String):String;
Begin
 Result :='';
 if Not F_Active Then Exit;
 Try
   Result := F_DaoTable.Fields.Item[FieldName].SourceField;
 Except
 End;
End;

Function  TKADaoTable.GetSourceTableName(FieldName:String):String;
Begin
 Result :='';
 if Not F_Active Then Exit;
 Try
   Result := F_DaoTable.Fields.Item[FieldName].SourceTable;
 Except
 End;
End;

Function  TKADaoTable.GetLastDaoError:TDaoErrRec;
Begin
  if Assigned(F_Database) And (F_Database.Connected) Then
  Result := F_Database.GetLastDaoError;
End;

Function TKADaoTable.PropertyExists(PropObject:OleVariant;PropertyName:String):Boolean;
Var
  X : Integer;
Begin
  Result := False;
  For X := 0 to PropObject.Count-1 do
      Begin
        if AnsiCompareText(PropObject.Item[X].Name,PropertyName)=0 Then
           Begin
             Result := True;
             Exit;
           End;
      End;
End;

Function TKADaoTable.F_Get_Database:TKADaoDatabase;
Begin
 Result:=F_Database;
End;

Procedure TKADaoTable.F_Set_Database(Value:TKADaoDatabase);
Begin
 if Active Then DatabaseError('TKADaoTable.F_Set_Database: Cannot set Database while table is Active!');
 F_Database:=Value;
End;

Function TKADaoTable.F_Get_DateCreated:String;
Begin
 Result := '';
 if F_Active Then
    Begin
     Try
      if TableType=dbOpenTable Then Result:=F_DaoTable.DateCreated
      Else
      if F_QueryDefName <> '' then Result:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].DateCreated;
     Except
     End;
    End;
End;

Function TKADaoTable.F_Get_LastUpdated:String;
Begin
 Result := '';
 if F_Active Then
    Begin
     Try
      if TableType=dbOpenTable Then Result:=F_DaoTable.LastUpdated
      Else
      if F_QueryDefName <> '' then Result:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].LastUpdated;
     Except
     End;
    End;
End;

Function TKADaoTable.F_Get_TableName:String;
Begin
 Result:= F_TableName;
End;

Procedure TKADaoTable.F_Set_TableName(Value:String);
Begin
  if Active Then DatabaseError('Cannot set TableName while Table is active!');
  F_TableName:=Value;
  if Value <> '' Then
     Begin
      F_IndexName:='';
      F_IndexFieldCount:=0;
      F_SQL.Clear;
      F_QueryDefName:='';
      F_QueryDefParameters.Clear;
      F_SortedBy.Clear;
     End;
End;

Procedure TKADaoTable.F_Set_SQL(Value:TStrings);
Begin
 F_SQL.SetText(Value.GetText);
 if Length(Value.GetText) > 0 Then
    Begin
     F_QueryDefParameters.Clear;
     F_QueryDefName:='';
     F_IndexName:='';;
     F_IndexFieldCount:=0;
     F_TableName:='';
    End;                      
End;

Procedure TKADaoTable.F_Set_QueryDefName(Value:String);
Begin
  Try
    if Assigned(F_Database) And (F_Database.Connected) Then
       Begin
         F_QueryDefSQLText.Clear;
         if Value <> '' Then F_QueryDefSQLText.SetText(PChar(F_Database.GetQueryDefSQLText(Value)));
       End;
  Except
  End;
  F_QueryDefName:=Value;
  F_QueryDefType:=F_Get_QueryDefType;
  if Value <> '' Then
     Begin
      F_IndexName:='';
      F_IndexFieldCount:=0;
      F_TableName:='';
      F_SQL.Clear;
      F_QueryDefParameters.Clear;
      F_Master.Clear;
      F_Detail.Clear;
      F_MasterFields.Clear;
      MasterLink.DataSource:=Nil;
     End;
End;



Function TKADaoTable.F_Get_IndexName:String;
Begin
 Result:= F_IndexName;
End;

Procedure TKADaoTable.F_Set_IndexName(Value:String);
Begin
  if Active Then
     Begin
       if (TableType=dbOpenTable) And (Value <> '') Then
          Begin
             F_SortedBy.Clear;
             F_DaoTable.Index  := Value;
             F_IndexFieldCount := F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[Value].Fields.Count;
             ClearBuffers;
             CheckBrowseMode;
             ActivateBuffers;
             First;
          End
       Else if Value <> '' Then DatabaseError('Indexes can be set only on Standard Tables!');
     End
   Else
     Begin
       if (TableType=dbOpenTable) And (Value <> '') Then
          Begin
            F_SortedBy.Clear;
          End
       Else if Value <> '' Then DatabaseError('Indexes can be set only on Standard Tables!');
     End;
  F_IndexName:=Value;
End;

Function  TKADaoTable.F_Get_IndexFieldNames:String;
Var
  X     : Integer;
  Count : Integer;
Begin
  Result := '';
  if F_IndexName='' Then Exit;
  Count := F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[F_IndexName].Fields.Count-1;
  For X := 0 To  Count do
      Begin
        if X = Count Then
           Result := Result + F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[F_IndexName].Fields.Item[X].Name
        Else
           Result := Result + F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[F_IndexName].Fields.Item[X].Name+';';
      End;
End;

Procedure TKADaoTable.F_Set_IndexFieldNames(Value:String);
Var
  KF    :  TStringList;
  X,Y,Z :  Integer;
  C     :  Integer;
  NI    :  Integer;
  II    :  Integer;
  BR    :  Integer;
  Exact :  Boolean;
Begin
  if TableType <> dbOpenTable then Exit;
  if Value='' Then Exit;
  if Value[1]='!' Then
     Begin
      Exact:=True;
      System.Delete(Value,1,1);
     End
  Else
     Begin
       Exact:=False;
     End;
  KF := TStringList.Create;
  StringToList(Value,KF);
  C := KF.Count;
  if C=0 Then Begin KF.Free; Exit; End;
  NI := F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Count;
  For X :=0 To NI-1 Do
      Begin
        II := F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Fields.Count;
        if Exact Then
           Begin
           if II = C Then
            Begin
             BR:=0;
             For Y := 0 to II-1 do
                 Begin
                   For Z := 0 To C-1 do
                       if AnsiCompareText(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Fields.Item[Y].Name,KF.Strings[Z])=0 Then Inc(BR);
                 End;
             if BR=C Then
                Begin
                  F_Set_IndexName(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Name);
                  KF.Free;
                  Exit;
                End;
            End;
           End
        Else
           Begin
           if II >= C Then
            Begin
             BR:=0;
             For Y := 0 to II-1 do
                 Begin
                   For Z := 0 To C-1 do
                       if AnsiCompareText(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Fields.Item[Y].Name,KF.Strings[Z])=0 Then Inc(BR);
                 End;
             if BR=C Then
                Begin
                  F_Set_IndexName(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Name);
                  KF.Free;
                  Exit;
                End;
            End;
           End;
      End;
  KF.Free;
End;

Function TKADaoTable.F_Get_IndexField(Index: Integer): TField;
Var
 FieldName:String;
Begin
 Result := Nil;
 if NOT Active Then DatabaseError('Cannot get IndexField while Table is NOT active!');
 if F_IndexName='' Then Exit;
 Try
  FieldName:=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[F_IndexName].Fields.Item[Index].Name;
 Except
  Exit;
 End;
 Result := FindField(FieldName);
End;

Procedure TKADaoTable.F_Set_IndexField(Index: Integer; Value: TField);
Begin
 //******************************************************************* Read Only
End;

Procedure TKADaoTable.F_Set_TableType(Value:Integer);
Begin
  if Active Then DatabaseError('Cannot set TableType while Table is active!');
  F_TableType:=Value;
End;

Procedure TKADaoTable.F_Set_LockType(Value:Integer);
Begin
  if Active Then DatabaseError('Cannot set LockType while Table is active!');
  F_LockType:=Value;
End;

Procedure TKADaoTable.F_Set_OpenOptions(Value:TOOSet);
Begin
  F_OpenOptions:=Value;
  if Active Then
     Begin
       ClearBuffers;
       CheckBrowseMode;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
End;

Procedure TKADaoTable.LockTable(LockType: TLockType);
Var
  OO:TOOSet;
Begin
  if LockType = ltReadLock  Then OO := F_OpenOptions+[dbDenyRead];
  if LockType = ltWriteLock Then OO := F_OpenOptions+[dbDenyWrite];
  if Active Then F_Set_OpenOptions(OO);
End;

Procedure TKADaoTable.UnlockTable(LockType: TLockType);
Var
  OO:TOOSet;
Begin
  if LockType = ltReadLock  Then OO := F_OpenOptions-[dbDenyRead];
  if LockType = ltWriteLock Then OO := F_OpenOptions-[dbDenyWrite];
  if Active Then F_Set_OpenOptions(OO);
End;

Procedure TKADaoTable.F_Set_ReadOnly(Value:Boolean);
Begin
  if Active Then DatabaseError('TKADaoTable.F_Set_ReadOnly: Cannot set ReadOnly while table is Active!');
  if Assigned(F_Database) And (F_Database.Connected) and (F_Database.ReadOnly) And (NOT Value) Then
     Begin
       Value := True;
     End;
  F_ReadOnly:=Value;
End;

Procedure TKADaoTable.F_Set_LockEdits(Value:Boolean);
Begin
  if (Active) Then
     Begin
       F_DaoTable.LockEdits:=Value;
     End;
  F_LockEdits :=Value;
End;

Procedure TKADaoTable.F_Set_Sort(Value:TStrings);
Begin
 F_SortedBy.SetText(Value.GetText);
 F_IndexName:='';
End;

Procedure TKADaoTable.F_Set_QueryDefParameters(Value:TStrings);
Begin
 F_QueryDefParameters.SetText(Value.GetText);
End;

Procedure TKADaoTable.F_Set_QueryDefSQLText(Value:TStrings);
Begin
//*************************** READ ONLY
End;

Function TKADaoTable.F_Get_QueryDefType:String;
Var
 QDType : Integer;
Begin
 Result:='';
 QueryDefTypeInt:=0;
 Try
  if Assigned(F_Database) And (F_Database.Connected) And (F_QueryDefName <> '') Then
    Begin
      {$IFDEF DYNADAO}
      QDType:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].Type;
      {$ELSE}
      QDType:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].Type_;
      {$ENDIF}
      if QDType=dbQSelect         Then Begin Result := 'dbQSelect'        ; QueryDefTypeInt := dbQSelect         ; End;
      if QDType=dbQProcedure      Then Begin Result := 'dbQProcedure'     ; QueryDefTypeInt := dbQProcedure      ; End;
      if QDType=dbQAction         Then Begin Result := 'dbQAction'        ; QueryDefTypeInt := dbQAction         ; End;
      if QDType=dbQCrosstab       Then Begin Result := 'dbQCrosstab'      ; QueryDefTypeInt := dbQCrosstab       ; End;
      if QDType=dbQDelete         Then Begin Result := 'dbQDelete'        ; QueryDefTypeInt := dbQDelete         ; End;
      if QDType=dbQUpdate         Then Begin Result := 'dbQUpdate'        ; QueryDefTypeInt := dbQUpdate         ; End;
      if QDType=dbQAppend         Then Begin Result := 'dbQAppend'        ; QueryDefTypeInt := dbQAppend         ; End;
      if QDType=dbQMakeTable      Then Begin Result := 'dbQMakeTable'     ; QueryDefTypeInt := dbQMakeTable      ; End;
      if QDType=dbQDDL            Then Begin Result := 'dbQDDL'           ; QueryDefTypeInt := dbQDDL            ; End;
      if QDType=dbQSQLPassThrough Then Begin Result := 'dbQSQLPassThrough'; QueryDefTypeInt := dbQSQLPassThrough ; End;
      if QDType=dbQSetOperation   Then Begin Result := 'dbQSetOperation'  ; QueryDefTypeInt := dbQSetOperation   ; End;
      if QDType=dbQSPTBulk        Then Begin Result := 'dbQSPTBulk'       ; QueryDefTypeInt := dbQSPTBulk        ; End;
      if QDType=dbQCompound       Then Begin Result := 'dbQCompound'      ; QueryDefTypeInt := dbQCompound       ; End;
    End;
 Except
 End;
End;

Procedure TKADaoTable.F_Set_UseRecordCount(Value: Boolean);
Begin
 F_UseRecordCount := Value;
 if (F_Active) And (State=dsBrowse) Then InternalRefresh;
End;

Function  TKADaoTable.F_Get_MasterSource : TDataSource;
Begin
 Result:= F_MasterLink.DataSource;
End;

Procedure TKADaoTable.F_Set_MasterSource(Value: TDataSource);
Begin
 F_MasterLink.DataSource:= Value;
End;

Procedure TKADaoTable.F_ProcessMasterFields(Value:TStrings);
Var
  X,I:Integer;
  S,MasterField,DetailField:String;
Begin
  F_Detail.Clear;
  F_Master.Clear;
  if (Value.Count=1) And (Pos(';',Value.Strings[0]) > 0) Then
     Begin
       S := Value.Strings[0]; 
       Repeat
        I := Pos(';',S);
        if I > 0 Then
           Begin
            DetailField:=Copy(S,1,I-1);
            System.Delete(S,1,I);
           End
        Else
           Begin
            DetailField:=S;
           End;
        if Length(DetailField) > 0 Then
           Begin
            MasterField:=DetailField;
            F_Detail.Add(DetailField);
            F_Master.Add(MasterField);
           End;
       Until I = 0;
     End
  Else
  For X:=0 to Value.Count-1 do
      Begin
        S := Value.Strings[X];
        I := Pos(' -> ',S);
        if I > 0 Then
        Begin
         DetailField:=Copy(S,1,I-1);
         System.Delete(S,1,I+Length(' -> ')-1);
         MasterField:=S;
         F_Detail.Add(DetailField);
         F_Master.Add(MasterField);
        End;
      End;
End;

Procedure TKADaoTable.F_Set_MasterFields(Value:TStrings);

Begin
 F_ProcessMasterFields(Value);
 F_MasterFields.SetText(Value.GetText);
End;

Procedure TKADaoTable.F_Set_Master(Value:TStrings);
Begin
 F_Master.SetText(Value.GetText);
End;

Procedure TKADaoTable.F_Set_Detail(Value:TStrings);
Begin
 F_Detail.SetText(Value.GetText);
End;

Function TKADaoTable.F_ComposeSQL(SQL:TStrings):String;
Var
 X       : Integer;
{$IFDEF USEPARAMS}
 {$IFNDEF VER100}
  {$IFNDEF VER110}
 S, Sep  : String;
  {$ENDIF}
 {$ENDIF}
{$ENDIF}
Begin
 Result:='';
 For X:=0 To SQL.Count-1 do
     Begin
       Result := Result+SQL.Strings[X];
       if X <  SQL.Count-1 Then Result := Result+' ';
     End;
 {$IFDEF USEPARAMS}
  {$IFNDEF VER100}
   {$IFNDEF VER110}
 if ParamCheck then
    Begin
      For X := 0 to F_Params.Count - 1 do
        Begin
            Case F_Params[X].DataType of
                 ftDate, ftTime       : Sep := '#';
                 ftUnknown, ftString  : Sep := '"';
            else
                Sep := '';
            end;
            S := Sep + F_Params[X].AsString + sep;
            Result := StringReplace(Result, ':' + F_Params[X].Name, S,[rfReplaceAll, rfIgnoreCase]);
        end;
    End;
   {$ENDIF}
  {$ENDIF}
 {$ENDIF}
End;

Procedure TKADaoTable.F_Set_Filtered(Value:Boolean);
var
  Old_Filtered : Boolean;
Begin
  Old_Filtered := F_Filtered;
  Try
    F_Filtered:=Value;
    if F_Active Then
       Begin
         ClearBuffers;
         CheckBrowseMode;
         CloseDaoRecordset;
         OpenDaoRecordset;
         ActivateBuffers;
         First;
       End;
    Inherited Filtered:=Value;
  Except
    F_Filtered := Old_Filtered;
    Raise;
  End;
End;

Procedure TKADaoTable.F_Set_Filter(Value:String);
Begin
  F_Filter:=Value;
  if (F_Active) And (F_Filtered) Then
     Begin
       ClearBuffers;
       CheckBrowseMode;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
  Inherited Filter:=Value;
End;

Procedure TKADaoTable.F_Set_OnFilterRecord(Value: TFilterRecordEvent);
Begin
  F_OnFilterRecord:=Value;
  if (F_Active) And (F_Filtered) Then
     Begin
       ClearBuffers;
       CheckBrowseMode;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
  Inherited OnFilterRecord:=Value;
End;

//******************************************************************************
Function TKADaoTable.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
Begin
  Result:=TKBlobStream.Create(Field As TBlobField,Mode);
End;

Function TKADaoTable.AppendToBlob(Field: TField; Data:String):Boolean;
Var
 S : String;
Begin
 Result := False;
 If (Not F_Active)
 or (F_ReadOnly)
 or (NOT Assigned(F_Database))
 or (NOT F_Database.Connected)
 or (F_Database.ReadOnly)
 Then Exit;

 F_DaoTable.Edit;
 S:=F_DaoTable.Fields.Item[Field.FieldNo-1].GetChunk(0,F_DaoTable.Fields.Item[Field.FieldNo-1].FieldSize);
 F_DaoTable.Fields.Item[Field.FieldNo-1].AppendChunk(S);
 F_DaoTable.Fields.Item[Field.FieldNo-1].AppendChunk(Data);
 OleVariant(F_DaoTable).Update;
 Result := True;
End;

Function TKADaoTable.InternalCalcRecordSize:Integer;
Begin
 F_RecordSize:=0;
 Result:=F_RecordSize;
End;


Procedure TKADaoTable.GetQueryDefReturnParams(QueryDefName:String);
Var
  X, Dir, NRP : Integer;
Begin
  if (NOT Assigned(F_Database)) OR (NOT F_Database.Connected) Then Exit;
  if NOT VarIsNull(QueryDefReturnParams) Then QueryDefReturnParams:=NULL;
  NRP:=0;
 Try
  For X:=0 To F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
      Begin
        Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
        if (Dir=dbParamOutput) Or (Dir=dbParamInputOutput) Or (Dir=dbParamReturnValue) Then Inc(NRP);
        F_Database.Idle;
      End;
  if NRP=0 Then Exit;
  if NRP=1 Then
      Begin
       QueryDefReturnParams:=F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[0].Name+'='+F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[0].Value;
      End
  Else
      Begin
        QueryDefReturnParams:=VarArrayCreate([0, NRP],varVariant);
        For X:=0 To F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
           Begin
             Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
             if (Dir=dbParamOutput) Or (Dir=dbParamInputOutput) Or (Dir=dbParamReturnValue) Then
                QueryDefReturnParams[X]:=F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Name+'='+F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Value;
       End;
     End;
 Except
 End;
End;

Procedure TKADaoTable.OpenDaoRecordset;
Var
 X         : Integer;
 TabType   : Integer;
 LoType    : Integer;
 Options   : Integer;
 {$IFDEF DYNADAO}
 TempRS    : OleVariant;
 {$ELSE}
 TempRS    : Recordset;
 {$ENDIF}
 TabN      : String;
 TempSort  : String;
 NRP, Dir  : Integer;
Begin
        if Not Assigned(F_Database) Then DatabaseError('TKADaoTable.OpenDaoRecordset: Missing Database');
        if (TableName='') And
           (SQL.Count=0)  And
           (QueryDefName='')
        Then DatabaseError('TKADaoTable.OpenDaoRecordset: Missing TableName or QueryDefName or SQL is empty!');
        if F_Database.Connected= False Then DatabaseError('TKADaoTable.OpenDaoRecordset: Database is NOT connected');
        if (F_TableType=dbOpenDynamic) And (F_Database.DatabaseType <> 'ODBC') Then DatabaseError('TKADaoTable.OpenDaoRecordset: DynamicTables are for ODBC connections only!');
        TabType:=F_TableType;
        LoType:=F_LockType;
        if (F_Database.ReadOnly) And (NOT F_ReadOnly) Then F_ReadOnly:=True;
        Options:=0;

        if dbDenyWrite      in F_OpenOptions Then Options:=Options + DAOApi.dbDenyWrite;
        if dbDenyRead       in F_OpenOptions Then Options:=Options + DAOApi.dbDenyRead;
        if dbReadOnly       in F_OpenOptions Then Options:=Options + DAOApi.dbReadOnly;
        if dbAppendOnly     in F_OpenOptions Then Options:=Options + DAOApi.dbAppendOnly;
        if dbInconsistent   in F_OpenOptions Then Options:=Options + DAOApi.dbInconsistent;
        if dbConsistent     in F_OpenOptions Then Options:=Options + DAOApi.dbConsistent;
        if dbSQLPassThrough in F_OpenOptions Then Options:=Options + DAOApi.dbSQLPassThrough;
        if dbFailOnError    in F_OpenOptions Then Options:=Options + DAOApi.dbFailOnError;
        if dbForwardOnly    in F_OpenOptions Then Options:=Options + DAOApi.dbForwardOnly;
        if dbSeeChanges     in F_OpenOptions Then Options:=Options + DAOApi.dbSeeChanges;
        if dbRunAsync       in F_OpenOptions Then Options:=Options + DAOApi.dbRunAsync;
        if dbExecDirect     in F_OpenOptions Then Options:=Options + DAOApi.dbExecDirect;

        RecordsAffected:=0;
        TabN:=TableName;
        if F_SQL.Count > 0 Then TabN:=F_ComposeSQL(F_SQL);
        if F_QueryDefName <> '' Then
           Begin
             TabN:=F_QueryDefName;
             NRP:=0;
               For X:=0 To Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count-1 do
                 Begin
                   Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
                   if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
                       Begin
                        Try
                         Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[X].Value:=F_QueryDefParameters.Strings[NRP];
                         Inc(NRP);
                        Except
                         DatabaseError('Invalid number of QueryDef parameters or parameter is not in valid format!');
                        End;
                       End;
                 End;
           End;
        if (F_QueryDefName <> '') And (Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count > 0) Then
            Begin
                F_QueryDefSQLText.Clear;
                if Assigned(F_Database) And (F_Database.Connected) Then
                   F_QueryDefSQLText.SetText(PChar(F_Database.GetQueryDefSQLText(TabN)));
                Database.CoreDatabase.QueryDefs.Item[TabN].MaxRecords:=F_QueryDefMaxRecords;
                if F_Database.QueryTimeout <> 60 Then
                F_Database.CoreDatabase.QueryDefs.Item[TabN].ODBCTimeout:=F_Database.QueryTimeout;
                F_DaoTable:=Database.CoreDatabase.QueryDefs.Item[TabN].OpenRecordset(TabType,Options,LoType);
                GetQueryDefReturnParams(TabN);
            End
        Else
            Begin
               F_QueryDefSQLText.Clear;
               if (F_QueryDefName <> '') Then
                   Begin
                     F_QueryDefSQLText.SetText(PChar(F_Database.GetQueryDefSQLText(TabN)));
                     Database.CoreDatabase.QueryDefs.Item[TabN].MaxRecords:=F_QueryDefMaxRecords;
                     if F_Database.QueryTimeout <> 60 Then
                     F_Database.CoreDatabase.QueryDefs.Item[TabN].ODBCTimeout:=F_Database.QueryTimeout;
                     F_DaoTable:=Database.CoreDatabase.QueryDefs.Item[TabN].OpenRecordset(TabType,Options,LoType);
                     F_Database.Idle;
                   End
               Else
                   Begin
                     F_DaoTable:=Database.CoreDatabase.OpenRecordset(TabN,TabType,Options,LoType);
                     F_Database.Idle;
                   End;
            End;

        InternalClearBookmarks;

        F_Database.Idle;
        F_Database.RefreshDefinitions;

        RecordsAffected:=F_Database.CoreDatabase.RecordsAffected;

        F_DefaultValues.Clear;
          For X:=0 To F_DaoTable.Fields.Count-1 do
            Begin
              Try
                F_DefaultValues.Add(F_DaoTable.Fields.Item[X].DefaultValue);
              Except
                F_DefaultValues.Add('');
              End;
              F_Database.Idle;
            End;

        if F_IndexName <> '' Then F_DaoTable.Index:=F_IndexName
        Else
        if F_SortedBy.Count > 0 Then
           Begin
             TempSort:='';
             For X:=0 To F_SortedBy.Count-1 Do
                Begin
                  TempSort:=TempSort+F_SortedBy.Strings[X];
                  if X < F_SortedBy.Count-1 Then TempSort:=TempSort+',';
                  TempSort:=TempSort+' ';
                  F_Database.Idle;
                End;
             F_DaoTable.Sort:=TempSort;
             TempRS:=F_DaoTable;
             F_DaoTable:=TempRS.OpenRecordset(TabType,Options);
             TempRS.Close;
             {$IFDEF DYNADAO}
             TempRS:=NULL;
             {$ELSE}
             TempRS:=Nil;
             {$ENDIF}
           End;
        if Filtered Then
           Begin
             if Filter<>'' Then
                Begin
                 F_DaoTable.Filter:=Filter;
                 TempRS:=F_DaoTable;
                 F_DaoTable:=TempRS.OpenRecordset(TabType,Options);
                 TempRS.Close;
                 {$IFDEF DYNADAO}
                 TempRS:=NULL;
                 {$ELSE}
                 TempRS:=Nil;
                 {$ENDIF}
                End;
           End;
        if (MasterSource <> NIL) and (not(F_MDisabled)) then
            Begin
              F_ProcessMasterFields(F_MasterFields);
              if (F_Master.Count > 0) Then
                  Begin
                   TabN:=BuildDetailSQL;
                   TabN:=InsertSQLString(TabN);
                   F_DaoTable.Filter:=TabN;
                   TempRS:=F_DaoTable;
                   F_DaoTable:=TempRS.OpenRecordset(TabType,Options);
                   TempRS.Close;
                   {$IFDEF DYNADAO}
                   TempRS:=NULL;
                   {$ELSE}
                   TempRS:=Nil;
                   {$ENDIF}
                  End;
            End;
        //*****************************************************************
        F_UpdatableFields.Clear;
        For X :=0 To F_DaoTable.Fields.Count-1 do
            Begin
             F_Database.Idle;
             F_UpdatableFields.Add(Pointer(False));
             if (F_DaoTable.Fields.Item[X].Attributes And dbUpdatableField) > 0 Then
                Begin
                 if (F_DaoTable.Fields.Item[X].Attributes And dbAutoIncrField) = 0 Then
                    Begin
                      if (F_DaoTable.Fields.Item[X].Attributes And dbSystemField) = 0 Then
                          Begin
                           F_UpdatableFields.Items[X]:=Pointer(True);
                          End;
                    End;
                End;
            End;
        CoreRecordset := F_DaoTable;
        if  (F_Database.DatabaseType <> 'ODBC')
        And (NOT F_Database.ReadOnly)
        And (NOT F_ReadOnly) Then
           Begin
             If (F_TableType = dbOpenTable)
             Or (F_TableType = dbOpenDynaset) Then F_DaoTable.LockEdits:=F_LockEdits;
           End;
End;


Procedure TKADaoTable.InternalOpen;
Var
   X       : Integer;
   TempMD  : Boolean;
   FF      : TField;
Begin
        OpenDaoRecordset;
        if Self.Name='' Then Self.Name:='KADaoTable_'+IntToStr(GetTickCount);
        F_Database.ActiveTableNames.AddObject(Self.Name,Self);
        InternalInitFieldDefs;
        if DefaultFields then CreateFields;
        BindFields(True);
        F_RecNo:=-1;
        BookmarkSize:=MYBOOKMARKSIZE;
        F_StartMyInfo:=InternalCalcRecordSize;
        F_StartCalc:=F_StartMyInfo+SizeOf(TDaoInfo);
        F_BufferSize:=F_RecordSize+Sizeof(TDaoInfo)+CalcFieldsSize;
        //****************************************************************
        TempMD:=F_MDisabled;
        F_MDisabled:= True;
        F_FieldNames.Clear;
        F_MDFieldNames.Clear;
        For X:=0 to FieldDefs.Count-1 do
            Begin
             FF  :=FindField(FieldDefs.Items[X].Name);
             if (FF <> Nil) And (NOT FF.IsBlob) Then
                Begin
                  F_FieldNames.Add(FieldDefs.Items[X].Name);
                  F_FieldTypeNames.Add(GetBDEFieldTypeNames(FieldDefs.Items[X].DataType));
                End;
             if (FF <> Nil) And (NOT (FF.DataType=ftBlob)) Then
                Begin
                  F_MDFieldNames.Add(FieldDefs.Items[X].Name);
                End;
            End;
        F_MDisabled:=TempMD;
        F_Active:=True;
        InternalFirst;
        //****************************************************************
End;

Procedure TKADaoTable.CloseDaoRecordset;
Begin
 F_DaoTable.Close;
End;

Procedure TKADaoTable.InternalClose;
Begin
        if Not F_Active Then Exit;
        BindFields(False);
        if DefaultFields then DestroyFields;
        CloseDaoRecordset;
        F_Active:=False;
        if NOT MainDatabaseShutdown Then
           F_Database.ActiveTableNames.Delete(F_Database.ActiveTableNames.IndexOf(Self.Name))
        Else
           MainDatabaseShutdown:=False;
End;

//*********************************************************** BOOKMARK Functions
Procedure TKADaoTable.InternalClearBookmarks;
Begin
  F_BookmarkRN.Clear;
  F_BookmarkID.Clear;
End;
{
Procedure TKADaoTable.InternalGotoBookmark(Bookmark: Pointer);
Var
  Delta   : Integer;
  Buffer  : PChar;
  Invalid : Boolean;
Begin
  Invalid := False;
  if (F_Active) And (F_DaoTable.Bookmarkable) Then
     Begin
      Buffer:=GetActiveRecordBuffer;
      Delta:=PInteger(Bookmark)^-PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData;
      Try
        CheckBrowseMode;
        DoBeforeScroll;
        if Delta = 0 Then F_RecNo:=PDaoInfo(Buffer + F_StartMyInfo)^.RecordNo
        Else
        if Delta < 0 Then
           Begin
            Repeat
              F_DaoTable.MovePrevious;
              Dec(F_RecNo);
              if F_DaoTable.BOF Then
                 Begin
                   Invalid := True;
                   DatabaseError('Invalid bookmark!');
                   Break;
                 End;
            Until GetDaoBookmark(F_DaoTable)=PInteger(Bookmark)^;
           End
        Else
        if Delta > 0 Then
           Begin
            Repeat
              F_DaoTable.MoveNext;
              Inc(F_RecNo);
              if F_DaoTable.EOF Then
                 Begin
                   Invalid := True;
                   DatabaseError('Invalid bookmark!');
                   Break;
                 End;
            Until GetDaoBookmark(F_DaoTable)=PInteger(Bookmark)^;
           End;
        DoAfterScroll;
        Resync([rmExact, rmCenter]);
      Except
        DoAfterScroll;
        if Invalid Then Raise;
      End;
     End;
End;
}

//******************************************************* NEW METHOD
Procedure TKADaoTable.InternalGotoBookmark(Bookmark: Pointer);
Var
  Delta   : Integer;
  I       : Integer;
  X       : Integer;
  Buffer  : PChar;
  BK      : OleVariant;
  P       : PChar;
  Invalid : Boolean;
Begin
  Invalid := False;
  if NOT F_Active Then DatabaseError('Cannot goto Bookmark - Table is not Active');
  if (F_DaoTable.Bookmarkable) Then
     Begin
      Buffer:=GetActiveRecordBuffer;
      Delta:=PInteger(Bookmark)^-PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData;
      Try
        CheckBrowseMode;
        DoBeforeScroll;
        if Delta = 0 Then F_RecNo:=PDaoInfo(Buffer + F_StartMyInfo)^.RecordNo
        Else
           Begin
             X:=PInteger(Bookmark)^;
             I:= F_BookmarkID.IndexOf(Pointer(X));
             if I = -1 Then
                Begin
                  Invalid := True;
                  DatabaseError('Invalid Bookmark!');
                End
             Else
                Begin
                  BK  := VarArrayCreate([0, 3],varByte);
                  P:=PChar(Bookmark);
                  For X := 0 to 3 do BK[X] := Ord(P[X]);
                  OleVariant(F_DaoTable).Bookmark:=VarAsType(BK, varOleStr);
                  BK:=NULL;
                  F_RecNo:=Integer(F_BookmarkRN.Items[I]);
                End;
           End;
        DoAfterScroll;
        Resync([rmExact, rmCenter]);
      Except
        DoAfterScroll;
        if Invalid Then Raise;
      End;
     End
  Else
     Begin
       DatabaseError('Bookmarks are not supported!');
     End;
End;
//******************************************************* NEW METHOD


Function TKADaoTable.GetBookmarkFlag(Buffer: PChar): TBookmarkFlag;
Begin
  Result:=PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkFlag;
End;

Procedure TKADaoTable.SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag);
Begin
  PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkFlag := Value;
End;

Function TKADaoTable.GetBookmarkStr: TBookmarkStr;
Var
 Buffer : PChar;
 RN     : Integer;
Begin
  Result := '';
  Try
    if F_DaoTable.Bookmarkable Then
       Begin
         Buffer:=GetActiveRecordBuffer;
         if (Buffer <> Nil) Then
         Result := StrPas(PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkString);
         RN     := PDaoInfo(Buffer + F_StartMyInfo)^.RecordNo;
         if F_BookmarkRN.IndexOf(Pointer(RN))=-1 Then
            Begin
              F_BookmarkRN.Add(Pointer(RN));
              F_BookmarkID.Add(Pointer(PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData));
            End;
       End;
  Except
    Result := '';
  End;
End;

Procedure TKADaoTable.SetBookmarkStr(const Value: TBookmarkStr);
var
 PBI : Integer;
Begin
 if (F_DaoTable.Bookmarkable) And (Value <> '') Then
     Begin
      //***************************************************** FOR FUTURE TESTING
      PBI:=StrToInt(Value);
      InternalGotoBookmark(@PBI);
      //************************************************************************
      InternalRefresh;
     End;
End;

Procedure TKADaoTable.GetBookmarkData(Buffer: PChar; Data: Pointer);
Var
  RN : Integer;
Begin
  if (F_DaoTable.Bookmarkable) Then
    Begin
     PInteger(Data)^ := PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData;
     RN              := PDaoInfo(Buffer + F_StartMyInfo)^.RecordNo;
     if F_BookmarkRN.IndexOf(Pointer(RN))=-1 Then
        Begin
          F_BookmarkRN.Add(Pointer(RN));
          F_BookmarkID.Add(Pointer(PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData));
        End;
    End;
End;

Procedure TKADaoTable.SetBookmarkData(Buffer: PChar; Data: Pointer);
Begin
     if Buffer <> nil then PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData := PInteger(Data)^;
End;

Function TKADaoTable.CompareBookmarks(Bookmark1, Bookmark2: TBookmark): Integer;
Function CompareBookmarkMemory(Buf1,Buf2:PChar;Count:Integer):Integer;
 Var X:integer;
 Begin
   Result := 0;
   for X := 0 to Count-1 do
    Begin
      if Buf1[X] < Buf2[X] then
       Begin
          Result := -1;
          Exit;
       End
      Else
      if Buf1[X] > Buf2[X] then
       Begin
          Result := 1;
          Exit;
       End;
    End;
 End;
Const
  ResultCodes     : array[Boolean, Boolean] of ShortInt = ((2,-1),(1,0));
Begin
  Result := ResultCodes[Bookmark1 = nil, Bookmark2 = nil];
  If Result = 2 then
     Begin
      Result := CompareBookmarkMemory(Bookmark1, Bookmark2, BookmarkSize);
     End;
End;

Function TKADaoTable.BookmarkValid(Bookmark: TBookmark): Boolean;
Var
  TmpBookmark:TBookmark;
Begin
  Result := False;
  If (F_Active) And (F_DaoTable.Bookmarkable) And (Assigned(Bookmark)) then
  Begin
   TmpBookmark:=GetBookmark;
   Try
    InternalGotoBookmark(Bookmark);
    CursorPosChanged;
    Result := True;
   Except
    if Assigned(TmpBookmark) Then
       Begin
        InternalGotoBookmark(TmpBookmark);
        CursorPosChanged;
       End;
   End;
  End;
End;
//*********************************************************************************** BOOKMARK FunctionS

Function TKADaoTable.GetRows(NumRows:Integer):OleVariant;
Begin
  Result:=NULL;
  if (F_Active) And (F_DaoTable.Bookmarkable) Then
     Begin
      Result:=F_DaoTable.GetRows(NumRows);
      Inc(F_RecNo,NumRows);
      Try
        Resync([rmExact]);
      Except
        InternalFirst;
        Resync([]);
        Raise;
      End;
     End;
End;

Procedure TKADaoTable.InternalInitFieldDefs;
Var
  X        : Integer;
  Sz       : Integer;
  Typ      : Integer;
  F_Format : String;
Begin
        FieldDefs.Clear;
        with FieldDefs do
        Begin
          For X:=0 To F_DaoTable.Fields.Count-1 do
              Begin
                {$IFDEF DYNADAO}
                Sz:=DaoSizeToBDESize(F_DaoTable.Fields.Item[X].Type,F_DaoTable.Fields.Item[X].Size);
                Typ :=F_DaoTable.Fields.Item[X].Type;
                {$ELSE}
                Sz:=DaoSizeToBDESize(F_DaoTable.Fields.Item[X].Type_,F_DaoTable.Fields.Item[X].Size);
                Typ :=F_DaoTable.Fields.Item[X].Type_;
                {$ENDIF}
                if (Typ=dbDate) And (PropertyExists(OleVariant(F_DaoTable.Fields.Item[X].Properties),'Format')) Then
                   Begin
                     F_Format:=F_DaoTable.Fields.Item[X].Properties.Item['Format'].Value;
                     if AnsiCompareText(F_Format,'Long Time')=0    Then Typ:=dbTime
                        Else
                        if AnsiCompareText(F_Format,'Medium Time')=0  Then Typ:=dbTime
                           Else
                           if AnsiCompareText(F_Format,'Short Time')=0   Then Typ:=dbTime
                              Else
                                if AnsiCompareText(F_Format,'General Date')=0   Then Typ:=dbTimeStamp;
                   End
                Else
                   if (Typ=dbDate) Then Typ:=dbTimeStamp;
                   if (Typ=dbText) And (Sz=0) Then Sz:=255;
                   if (Typ=dbLong) And ((F_DaoTable.Fields.Item[X].Attributes And dbAutoIncrField) > 0) Then Typ := dbAutoIncInteger;
                   Add(F_DaoTable.Fields.Item[X].Name,DaoToBDE(Typ),Sz,False);
              End;
        End;
End;


Function TKADaoTable.GetActiveRecordBuffer:  PChar;
Begin
        case State of
             dsBrowse      : if IsEmpty then Result := nil else Result := ActiveBuffer;
             dsCalcFields  : Result := CalcBuffer;
             dsFilter      : Result := F_FilterBuffer;
             dsEdit,
             dsInsert      : Result := ActiveBuffer;
        else Result:=nil;
        End;
End;


Procedure TKADaoTable.InternalHandleException;
Begin
     Application.HandleException(Self);
End;


Procedure TKADaoTable.DataEvent(Event: TDataEvent; Info: Longint);
Begin
     inherited DataEvent(Event, Info);
     if (Event in [deDataSetScroll,
                   deUpdateState,
                   deDataSetChange]) and Active then
         Begin
           InternalSetToRecord(ActiveBuffer);
         End;
End;

Procedure TKADaoTable.ClearDBCalcFields(Buffer: PChar);
Begin
    FillChar(Buffer[F_StartCalc],CalcFieldsSize,0);
End;

Function TKADaoTable.GetFieldData(Field: TField; Buffer: Pointer): Boolean;
var
  SourceBuffer : PChar;
  Value        : TStringList;
  FieldNumber  : Integer;
  TempString   : String;
Begin
        Result:=False;
        SourceBuffer:=GetActiveRecordBuffer;
        if (not F_Active) or (SourceBuffer=nil) then
           Begin
              Exit;
           End;
        if (Field.FieldKind=fkCalculated) or (Field.FieldKind=fkLookup) then
          Begin
                Inc(SourceBuffer,F_StartCalc+Field.Offset);
                if (SourceBuffer[0]=#0) or (Buffer=nil) then
                  Begin
                    Exit;
                  End
                Else
                  Begin
                    Move(SourceBuffer[1], Buffer^, Field.DataSize);
                    Result:=True;
                  End;
          end
        else
          Begin
           Value :=PDaoInfo(PChar(SourceBuffer)+F_StartMyInfo)^.RecordData;
           FieldNumber:=Field.FieldNo-1;
           if (Value=Nil) Then Exit;
           if (Buffer = Nil)  Then
            Begin
              Result:=(Value.Strings[FieldNumber] <> '');
            End
               Else
            Begin
              Case Field.DataType of
                ftBytes     : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftInteger   : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftAutoInc   : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftSmallint  : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftCurrency  : Result:=FloatToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftFloat     : Result:=FloatToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftDate      : Result:=DateToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftString    : Begin
                                TempString:=Value.Strings[FieldNumber];
                                TempString:=TempString+#0;
                                CopyMemory(PChar(Buffer),PChar(TempString),Length(TempString));
                                Result := True;
                              End;
                ftTime      : Result:=TimeToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftDateTime  : Result:=DateTimeToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftBoolean   : Result:=BooleanToBuffer(Buffer,Value.Strings[FieldNumber]);
              End;
            End;
          End;
End;

Procedure TKADaoTable.SetFieldData(Field: TField; Buffer: Pointer);
var
        DestinationBuffer: PChar;
        Tmp              : String;
        BTmp             : WordBool;
        BBTmp            : Boolean;
Begin
        DestinationBuffer:=GetActiveRecordBuffer;
        if (Field.FieldKind=fkCalculated) or (Field.FieldKind=fkLookup) then
        Begin
                Inc(DestinationBuffer,F_StartCalc+Field.Offset);
                Boolean(DestinationBuffer[0]):=(Buffer<>nil);
                if Boolean(DestinationBuffer[0]) then CopyMemory(@DestinationBuffer[1],Buffer,Field.DataSize);
        end
        Else
        Begin
          Tmp:='';
          if Buffer <> Nil Then
           Begin
            Case Field.DataType of
             ftString     : Tmp := PChar(Buffer);
             ftSmallint   : Tmp := IntToStr(Integer(Buffer^));
             ftWord       : Tmp := IntToStr(Integer(Buffer^));
             ftInteger    : Tmp := IntToStr(Integer(Buffer^));
             ftAutoInc    : Tmp := IntToStr(Integer(Buffer^));

             ftBCD        : Tmp := FloatToStr(Double(Buffer^));
             ftCurrency   : Tmp := FloatToStr(Double(Buffer^));
             ftFloat      : Tmp := FloatToStr(Double(Buffer^));

             ftDate       : Tmp := BufferToDate(Buffer);
             ftTime       : Tmp := BufferToTime(Buffer);
             ftDateTime   : Tmp := BufferToDateTime(Buffer);
             ftBoolean    : Begin
                            BTmp := WordBool(Buffer^);
                            BBTmp:=Boolean(BTmp);
                             Case BBTmp Of
                                  True   : Tmp:='True';
                                  False  : Tmp:='False';
                             End;
                           End;
            End;
           End;
          PDaoInfo(DestinationBuffer+F_StartMyInfo)^.RecordData[Field.FieldNo-1]:=Tmp;
          PDaoInfo(DestinationBuffer+F_StartMyInfo)^.FieldChanged[Field.FieldNo-1]:=Pointer(True);
          DataEvent(deFieldChange, Longint(Field));
        End;
End;

Procedure TKADaoTable.InternalFirst;
Begin
  F_RecNo:=-1;
  F_RecPos:=-1;
  if F_DaoTable.RecordCount=0 Then Exit;
  if F_TableType = dbOpenForwardOnly Then Exit;
  Try
   F_DaoTable.MoveFirst;
   F_DaoTable.MovePrevious;
  Except
  End;
End;

Procedure TKADaoTable.InternalLast;
Begin
     F_RecNo:=-1;
     if F_DaoTable.RecordCount=0 Then Exit;
     if F_TableType = dbOpenForwardOnly Then
        Begin
          While NOT F_DaoTable.EOF Do
              Begin
                F_DaoTable.MoveNext;
                Inc(F_RecPos);
                F_RecNo:=F_RecPos;
              End;
          Dec(F_RecPos);
          F_RecNo:=F_RecPos;
          Exit;
        End;
     Try
        OleVariant(F_DaoTable).MoveLast;
        F_DaoTable.MoveNext;
        F_RecNo:=F_DaoTable.RecordCount;
     Except
     End;
End;

Procedure TKADaoTable.InternalSetToRecord(Buffer: PChar);
Var
  RN     : Integer;
  Delta  : Integer;
Begin
        if F_DaoTable.RecordCount=0 Then Exit;
        RN:=F_RecNo;
        F_RecNo:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordNo;
        if F_TableType = dbOpenForwardOnly Then Exit;
        Delta:=F_RecNo-RN;
        //************************************************************** Testing
        if Delta=0 Then Exit;
        //**********************************************************************
        Try
           If (F_Filtered) And (Assigned(F_OnFilterRecord)) Then
               Begin
                 F_DaoTable.MoveFirst;
                 OleVariant(F_DaoTable).Move(F_RecNo);
               End
           Else
               Begin
                 if Delta <> 0 Then
                    Begin
                      OleVariant(F_DaoTable).Move(Delta);
                    End;
               End;
        Except
        End;
End;

Procedure TKADaoTable.InternalEdit;
Begin
     Try
       F_DaoTable.Edit;
     Except
       Exit;
     End;
     inherited InternalEdit;
End;

Procedure TKADaoTable.InternalCancel;
Begin
     Try
       OleVariant(F_DaoTable).CancelUpdate;
     Except
     End;
     inherited InternalCancel;
End;

Procedure TKADaoTable.InternalPost;
Label Again;
Var
 Buffer    : PChar;
 X         : Integer;
 RData     : TStringList;
 Changed   : Tlist;
 S         : String;
 DTSV      : OleVariant;
 FF        : TField;
 Action    : TDataAction;
 JumpAgain : Boolean;
Begin
 CheckActive;
 Again:
 JumpAgain := False;
 if State = dsEdit then //***************************************************** EDITING A RECORD
  Begin
    Buffer:=GetActiveRecordBuffer;
    RData:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordData;
    Changed:=PDaoInfo(PChar(Buffer)+F_StartMyInfo)^.FieldChanged;
    For X:=0 to RData.Count-1 do
        Begin
        FF:=FindField(F_DaoTable.Fields.Item[X].Name);
        if (Boolean(Changed[X])) And (FF <> Nil) Then
         Begin
          S:=RData.Strings[X];
          if Boolean(F_UpdatableFields.Items[X]) Then
             Begin
              if (FF.IsBlob) And (S = '(Blob#6405246780)')  Then
              Else
              Begin
               if S='' Then
                  Begin
                    F_DaoTable.Fields.Item[X].Value:=NULL
                  End
               Else
                  Begin
                    if (FF.DataType=ftDate) or
                       (FF.DataType=ftTime) or
                       (FF.DataType=ftDateTime) Then
                       Begin
                         DTSV:=ComposeDateTimeVariant(S);
                         F_DaoTable.Fields.Item[X].Value:=VarAsType(DTSV,VarDate);
                       End
                    Else
                       Begin
                         F_DaoTable.Fields.Item[X].Value:=S;
                       End;
                  End;
              End;
             End;
         End;
        End;
    Try
      OleVariant(F_DaoTable).Update;
    Except
      On E:Exception do
           Begin
            If Assigned(OnPostError) Then
               Begin
                   OnPostError(Self,EDatabaseError(E),Action);
                   if Action = daRetry Then
                      Begin
                        JumpAgain := True;
                      End
                   Else
                   if Action = daAbort Then
                      Begin
                        CursorPosChanged;
                        OleVariant(F_DaoTable).CancelUpdate;
                        SetState(dsBrowse);
                        InternalRefresh;
                      End
                   Else
                   if Action = daFail  Then Raise;
               End
            Else
               Begin
                 CursorPosChanged;
                 OleVariant(F_DaoTable).CancelUpdate;
                 SetState(dsBrowse);
                 InternalRefresh;
                 Raise;
               End;
           End;
    End;
    if JumpAgain Then Goto Again;
  End
 Else
  Begin //****************************************************************** ADDING A NEW RECORD
    Buffer:=GetActiveRecordBuffer;
    RData:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordData;
    F_DaoTable.AddNew;
    For X:=0 to RData.Count-1 do
        Begin
         FF:=FindField(F_DaoTable.Fields.Item[X].Name);
         if FF <> Nil Then
         Begin
          S:=RData.Strings[X];
          if Boolean(F_UpdatableFields.Items[X]) Then
             Begin
               if (FF.IsBlob) And (S = '(Blob#6405246780)')  Then
               Else
                 Begin
                   if S='' Then
                      Begin
                        F_DaoTable.Fields.Item[X].Value:=NULL
                      End
                   Else
                       Begin
                         if (FF.DataType=ftDate) or
                            (FF.DataType=ftTime) or
                            (FF.DataType=ftDateTime) Then
                            Begin
                              DTSV:=ComposeDateTimeVariant(S);
                              F_DaoTable.Fields.Item[X].Value:=VarAsType(DTSV,VarDate);
                            End
                         Else
                            Begin
                              F_DaoTable.Fields.Item[X].Value:=S;
                            End;
                       End;
                 End;
             End;
          End;
        End;
      Try
        OleVariant(F_DaoTable).Update;
      Except
        On E:Exception do
           Begin
            If Assigned(OnPostError) Then
               Begin
                   OnPostError(Self,EDatabaseError(E),Action);
                   if Action = daRetry Then
                      Begin
                        JumpAgain := True;
                      End
                   Else
                   if Action = daAbort Then
                      Begin
                        CursorPosChanged;
                        OleVariant(F_DaoTable).CancelUpdate;
                      End
                   Else
                   if Action = daFail Then Raise;
               End
            Else                                                                              
               Begin
                 CursorPosChanged;
                 OleVariant(F_DaoTable).CancelUpdate;
                 Raise;
               End;
           End;
      End;
      if JumpAgain Then Goto Again;
      Try
        InternalLast;
        //************* blocked at 15.08.2000
        //Resync([]);
      Except
       //************************************************************ EXCEPTION NO CURRENT RECORD
      End;
  End;
End;

Procedure TKADaoTable.InternalAddRecord(Buffer: Pointer; Append: Boolean);
Begin
    if Append Then InternalLast;
    InternalPost;
End;

Procedure TKADaoTable.InternalDelete;
Var
  Buffer : PChar;
  X      : Integer;
  I      : Integer;
  RN     : Integer;
  RR     : Integer;
Begin
  Buffer := GetActiveRecordBuffer;
  RN     := PDaoInfo(Buffer + F_StartMyInfo)^.RecordNo;
  I      := F_BookmarkRN.IndexOf(Pointer(RN));
  if I > -1 Then
     Begin
       F_BookmarkRN.Delete(I);
       F_BookmarkID.Delete(I);
     End;
  For X:=0 to F_BookmarkRN.Count-1 do
      Begin
       RR := Integer(F_BookmarkRN.Items[X]);
       if RR > RN Then
          Begin
            Dec(RR);
            F_BookmarkRN.Items[X]:=Pointer(RR);
          End;
      End;
  F_DaoTable.Delete;
  IF (F_DaoTable.EOF) then OleVariant(F_DaoTable).MoveLast Else F_DaoTable.MoveNext;

End;

Procedure TKADaoTable.InternalRefresh;
Begin
     Resync([rmExact, rmCenter]);
End;

Function TKADaoTable.IsCursorOpen: Boolean;
Begin
  Result:=F_Active;
End;

Function TKADaoTable.GetCanModify: Boolean;
Begin
 Result:= NOT F_ReadOnly;
End;

Function TKADaoTable.GetRecordSize: Word;
Begin
  Result:=F_BufferSize;
End;

Function TKADaoTable.AllocRecordBuffer: PChar;
Var
  X:Integer;
Begin
        GetMem(Result,F_BufferSize);
        FillChar(Result^,F_BufferSize,0);
        PDaoInfo(Result+F_StartMyInfo)^.RecordData:=TStringList.Create;
        PDaoInfo(Result+F_StartMyInfo)^.FieldChanged:=TList.Create;
        For X:=0 To F_DaoTable.Fields.Count-1 do
          Begin
            PDaoInfo(Result+F_StartMyInfo)^.RecordData.Add('');
            PDaoInfo(Result+F_StartMyInfo)^.FieldChanged.Add(Pointer(False));
          End;
End;

Procedure TKADaoTable.InternalInitRecord(Buffer: PChar);
Var
  X      : Integer;
  RC     : Integer;
Begin

  //****************************************************************************
     if PDaoInfo(Buffer+F_StartMyInfo)^.RecordData <> Nil Then
        PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Free;
     if PDaoInfo(Buffer+F_StartMyInfo)^.FieldChanged <> Nil Then
        PDaoInfo(Buffer+F_StartMyInfo)^.FieldChanged.Free;
  //****************************************************************************
     FillChar(Buffer^, F_BufferSize, 0);
     PDaoInfo(Buffer+F_StartMyInfo)^.RecordData:=TStringList.Create;
     PDaoInfo(Buffer+F_StartMyInfo)^.FieldChanged:=TList.Create;
     PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkFlag := bfInserted;
     PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.SetText(F_DefaultValues.GetText);
     For X:=0 To F_DaoTable.Fields.Count-1 do
          Begin
            PDaoInfo(Buffer+F_StartMyInfo)^.FieldChanged.Add(Pointer(False));
          End;
     if F_UseRecordCount Then
        Begin
          RC:=GetRecordCount;
          if (RC=-1) And (F_RecNo=-1) Then RC:=0;
        End
     Else
        Begin
          InternalLast;
          RC:=F_RecNo;
        End;
     PDaoInfo(Buffer+F_StartMyInfo)^.RecordNo:=RC;
End;

Procedure TKADaoTable.FreeRecordBuffer(var Buffer: PChar);
Begin
        if Buffer=Nil Then Exit;
        PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Free;
        PDaoInfo(Buffer+F_StartMyInfo)^.RecordData:=Nil;
        PDaoInfo(Buffer+F_StartMyInfo)^.FieldChanged.Free;
        PDaoInfo(Buffer+F_StartMyInfo)^.FieldChanged:=Nil;
        FreeMem(Buffer,F_BufferSize);
        Buffer:=Nil;
End;

Function TKADaoTable.AddLeadingZeros(Value:String):String;
Const
  Zeros='0000000000000000';
Var
  L : Integer;
Begin
  Result := Value;
  L:=Length(Value);
  if L < MYBOOKMARKSIZE Then
     Begin
       L:=MYBOOKMARKSIZE-L;
       Result:=Copy(Zeros,1,L)+Result;
     End;
End;

Function TKADaoTable.GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult;
var
 Acceptable : Boolean;
 X          : Integer;
 RD         : Variant;
 DTS        : TTimeStamp;
 FF         : TField;
Begin
        Result:=grOK;
        Acceptable:=False;
        repeat
                Begin
                        case GetMode of
                        gmCurrent:
                                Begin
                                    Result:=grOK;
                                    if F_DaoTable.EOF then
                                       Begin
                                         Result:=grEOF;
                                       End
                                    Else
                                    if F_DaoTable.BOF then
                                       Begin
                                         Result:=grBOF;
                                       End;
                                End;
                        gmNext:
                                Begin
                                    if NOT F_DaoTable.EOF Then
                                        Begin
                                          if F_DaoTable.BOF Then
                                             Begin
                                               if F_TableType <> dbOpenForwardOnly Then F_DaoTable.MoveFirst;
                                             End
                                          Else
                                             Begin
                                               if F_TableType = dbOpenForwardOnly Then
                                                  Begin
                                                    if F_RecNo <> -1 Then
                                                       Begin
                                                          F_DaoTable.MoveNext;
                                                          Inc(F_RecPos);
                                                       End;
                                                  End
                                                Else
                                                  Begin
                                                    F_DaoTable.MoveNext;
                                                  End;
                                             End;
                                          Inc(F_RecNo);
                                          if F_DaoTable.EOF then
                                             Begin
                                               Result:=grEOF;
                                             End;
                                        end
                                    Else
                                         Begin
                                           Result:=grEOF;
                                         End;
                                End;
                        gmPrior:
                                Begin
                                  if F_RecNo > 0 then
                                     Begin
                                      // *****************************
                                      //   dbOpenForwardOnly table
                                      //   will raise an exception here
                                      //   which is CORRECT!!!
                                      //******************************
                                       if F_TableType <> dbOpenForwardOnly Then
                                          Begin
                                           F_DaoTable.MovePrevious;
                                           Dec(F_RecNo);
                                           Result:=grOK;
                                          End
                                       Else  Result:=grError;
                                     End
                                  else
                                     Begin
                                       Result:=grBOF;
                                     End;
                                End;
                        End;
                        if Result=grOk then
                        Begin
                                with PDaoInfo(Buffer+F_StartMyInfo)^ do
                                Begin
                                        if F_DaoTable.Bookmarkable Then
                                           Begin
                                            BookmarkData:=GetDaoBookmark(F_DaoTable);
                                            FillChar(BookmarkString,BookmarkSize,#0);
                                            StrPCopy(BookmarkString,AddLeadingZeros(IntToStr(BookmarkData)));
                                           End
                                        Else        
                                           Begin
                                             BookmarkData:=0;
                                             FillChar(BookmarkString,BookmarkSize,#0);
                                             StrCopy(BookmarkString,'00000000');
                                           End;
                                        RecordNo     := F_RecNo;
                                        BookmarkFlag := bfCurrent;
                                        For X:=0 To F_DaoTable.Fields.Count-1 do
                                            Begin
                                              FF := FindField(F_DaoTable.Fields.Item[X].Name);
                                              if FF <> Nil Then
                                                Begin
                                                  if NOT FF.IsBlob Then
                                                     Begin
                                                       Try
                                                         RD:=F_DaoTable.Fields.Item[X].Value;
                                                       Except
                                                         RD:=NULL;
                                                       End;
                                                     End
                                                   Else
                                                     RD:='(Blob#6405246780)';
                                                   if VarType(RD) = varNull then RD := ''
                                                   Else
                                                   if (FF.DataType=ftDateTime)
                                                   or (FF.DataType=ftDate)
                                                   or (FF.DataType=ftTime)
                                                   Then
                                                   Begin
                                                     DTS:=DateTimeToTimeStamp(VarAsType(RD,varDate));
                                                     RD:=IntToStr(DTS.Date)+' '+IntToStr(DTS.Time);
                                                    End;
                                                    RecordData.Strings[X]:=RD;
                                                    FieldChanged.Items[X]:=Pointer(False);
                                                End;
                                            End;
                                End;
                                ClearDBCalcFields(Buffer);
                                GetCalcFields(Buffer);
                                Acceptable:=FilterRecord(Buffer);
                                if (GetMode=gmCurrent) and (not Acceptable) then Result:=grError;
                        end
                End;
        until (Result<>grOk) or (Acceptable);
End;

Function TKADaoTable.FilterRecord(Buffer: PChar): Boolean;
var
        SaveState: TDatasetState;
Begin
        Result:=True;
        if (not Filtered) or (not Assigned(OnFilterRecord)) then Exit;
        SaveState:=SetTempState(dsFilter);
        F_FilterBuffer:=Buffer;
        if Assigned(OnFilterRecord) then OnFilterRecord(self,Result);
        RestoreState(SaveState);
End;


Function TKADaoTable.GetRecordCount: Integer;
var
  SaveState: TDataSetState;
  SavePosition: integer;
  TempBuffer: PChar;
Begin
 Result:=-1;
 if Not F_UseRecordCount Then Exit;
 if F_TableType=dbOpenForwardOnly Then Exit;
 if F_DaoTable.RecordCount=0 Then
    Begin
      Result:=0;
      Exit;
    End;
 If (F_Filtered) And (Assigned(F_OnFilterRecord)) Then
     Begin
       Result:=0;
       SaveState:=SetTempState(dsBrowse);
       SavePosition:=F_RecNo;
       Try
         TempBuffer:=AllocRecordBuffer;
         InternalFirst;
         While GetRecord(TempBuffer,gmNext,True)=grOk do Inc(Result);
       Finally
         RestoreState(SaveState);
         F_RecNo:=SavePosition;
         FreeRecordBuffer(TempBuffer);
       End;
     End
 Else
     Begin
      Try
        if F_TableType=dbOpenTable Then
           Begin
             Result:=F_DaoTable.RecordCount;
             Exit;
           End;
        OleVariant(F_DaoTable).MoveFirst;
        OleVariant(F_DaoTable).MoveLast;
        Result:=F_DaoTable.RecordCount;
        F_DaoTable.MoveFirst;
        if F_RecNo=-1 Then
           Begin
            F_DaoTable.MovePrevious;
           End
        Else
           Begin
            OleVariant(F_DaoTable).Move(F_RecNo);
           End;
      Except
      End;
     End;
End;

Function  TKADaoTable.GetRecNo: Integer;
var
  SaveState: TDataSetState;
  SavePosition: integer;
  TempBuffer: PChar;
Begin
  UpdateCursorPos;
   //****************************************************** In Test Phase
  if F_RecNo=-1 Then
     Begin
       Result :=1;
       Exit;
     End;
   //****************************************************** In Test Phase   
  If (F_Filtered) And (Assigned(F_OnFilterRecord)) Then
    Begin
     Result:=-1;
     SaveState:=SetTempState(dsBrowse);
     SavePosition:=F_RecNo;
     Try
       TempBuffer:=AllocRecordBuffer;
       InternalFirst;
       Repeat
         if GetRecord(TempBuffer,gmNext,True)=grOk then Inc(Result);
       Until PDaoInfo(TempBuffer+F_StartMyInfo)^.RecordNo=SavePosition;
     Finally
       RestoreState(SaveState);
       F_RecNo:=SavePosition;
       FreeRecordBuffer(TempBuffer);
     End;
    End                                                                   
 Else
    Begin
      Result:=F_RecNo;
    End;
 //****************************************************** In Test Phase
 Inc(Result);
 //****************************************************** In Test Phase
End;

Procedure TKADaoTable.StringToList(Items: String; List: TStringList);
var
  X: Integer;
Begin
  For X:= 1 To Length(Items) Do If Items[X] = ';' Then Items[X]:= #13;
  List.Clear;
  List.Text:=Items;
  For X:= 0 To List.Count - 1 Do List[X]:= Trim(List[X]);
End;

Procedure TKADaoTable.VariantToList(Items: Variant; List: TStringList);
Var
   X    : Integer;
   V    : Variant;
   Count: Integer;
Begin
   List.Clear;
   if VarIsArray(Items) Then
      Begin
        Count:=(VarArrayHighBound(Items, 1) - VarArrayLowBound(Items, 1))+1;
        For X:=0 to Count-1 do
            Begin
             V:=Items[VarArrayLowBound(Items, 1) + X];
             if VarIsNull(V) Then
                List.Add('NULL')                         
             Else
                List.Add(VarAsType(V,VarString));
            End;
      End
   Else
      Begin
         V:=Items;
         if VarIsNull(V) Then
            List.Add('NULL')
         Else
            List.Add(VarAsType(V,VarString));
      End;
End;

Procedure TKADaoTable.AssignVarValue(Var V :Variant; const Value: TVarRec);
Begin
  with Value do
    case VType of
      vtInteger:
        V := VInteger;
      vtBoolean:
        V := VBoolean;
      vtChar:
        V := VChar;
      vtExtended:
        V := VExtended^;
      vtString:
        V := VString^;
      vtPointer:
        if VPointer <> nil then DatabaseError('Invalid data');
      vtPChar:
        if VPChar <> nil then DatabaseError('Invalid data');
      vtObject:
         DatabaseError('Invalid object');
      vtAnsiString:
        V := string(VAnsiString);
      vtCurrency:
        V := VCurrency^;
      vtVariant:
        if not VarIsEmpty(VVariant^) then V := VVariant^;
    else
      DatabaseError('Invalid data');
    End;
End;

Function  TKADaoTable.BuildKeySQL(KN,KV:TStringList):String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if KN.Count > 0 Then
     Begin
      For X:=0 To KN.Count-1 do
         Begin
          S:=S+'(';
          if F_UseBrackets Then S:=S+'[';
          S:=S+KN.Strings[X];
          if F_UseBrackets Then S:=S+']';
          S:=S+' ';
          FT :=FieldByName(KN.Strings[X]);
          if KV.Strings[X]='NULL' Then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftString,
             ftMemo     : S:= S + ' = "' + KV.Strings[X] + '"';
             ftBoolean,
             ftCurrency,
             ftFloat,
             ftSmallint,
             ftWord,
             ftAutoInc,
             ftInteger : S:= S + ' = ' + KV.Strings[X];
             ftDate    : Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy', StrToDateTime(KV.Strings[X])) + '#';
                         End;
             ftTime    : Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                         End;
             ftDateTime: Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                         End;

             Else
             DatabaseError('Unable to build Lookup Key SQL!')
          End;
          S:=S+')';
          if (X < KN.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

Function  TKADaoTable.BuildLocateSQL(KN,KV:TStringList;Options: TLocateOptions):String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if KN.Count > 0 Then
     Begin
      For X:=0 To KN.Count-1 do
         Begin
          S:=S+'(';
          FT :=FieldByName(KN.Strings[X]);
          if F_UseBrackets Then S:=S+'[';
          S:=S+KN.Strings[X];
          if F_UseBrackets Then S:=S+']';
          S:=S+' ';
          if KV.Strings[X]='NULL' Then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftString,
             ftMemo     :  Begin
                             if loCaseInsensitive in Options Then KV.Strings[X]:=AnsiLowerCase(KV.Strings[X]);
                             If loPartialKey in Options Then
                                Begin
                                  if loCaseInsensitive in Options Then
                                     Begin
                                       if Pos('*',KV.Strings[X]) > 0 Then
                                         S:= S + ' LIKE LCASE("' + KV.Strings[X] + '")'
                                       Else
                                         S:= S + ' LIKE LCASE("' + KV.Strings[X] + '*")';
                                     End
                                  Else
                                     Begin
                                       if Pos('*',KV.Strings[X]) > 0 Then
                                         S:= S + ' LIKE "' + KV.Strings[X] + '"'
                                       Else
                                         S:= S + ' LIKE "' + KV.Strings[X] + '*"';
                                     End;
                                End
                             Else
                                Begin
                                  if loCaseInsensitive in Options Then
                                     Begin
                                       S:= S + ' = LCASE("' + KV.Strings[X] + '")';
                                     End
                                   Else
                                     Begin
                                       S:= S + ' = "' + KV.Strings[X] + '"';
                                     End;
                                End;
                           End;
             ftBoolean,
             ftCurrency,
             ftFloat,
             ftSmallint,
             ftWord,
             ftAutoInc,
             ftInteger : S:= S + ' = ' + KV.Strings[X];
             ftDate    : Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy', StrToDateTime(KV.Strings[X])) + '#';
                         End;
             ftTime    : Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                         End;
             ftDateTime: Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy hh":"nn":"ss', StrToDateTime(KV.Strings[X])) + '#';
                         End;
             Else
             DatabaseError('Unable to build Lookup Key SQL!')
          End;
          S:=S+')';
          if (X < KN.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

Function  TKADaoTable.BuildDetailSQL:String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if F_Master.Count <> F_Detail.Count Then
     Begin
       DatabaseError('The number of Master and Detail fields must be equal!');
     End;
if F_Master.Count > 0 Then
     Begin
      For X:=0 To F_Master.Count-1 do
         Begin
          S:=S+'(';
          if F_UseBrackets Then S:=S+'[';
          S:=S+F_Detail.Strings[X];
          if F_UseBrackets Then S:=S+']';
          S:=S+' ';
          FT :=F_MasterLink.Dataset.FieldByName(F_Master.Strings[X]);
          if FT.IsNull then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftString,
             ftMemo     : S:= S + ' = "' + FT.AsString + '"';
             ftCurrency,
             ftFloat,
             ftSmallint,
             ftWord,
             ftAutoInc,
             ftInteger : S:= S + ' = ' + FT.AsString;
             ftBoolean : If FT.AsBoolean then S:= S + ' = True' Else S:= S + ' = False';
             ftDate    : S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy', FT.AsDateTime) + '#';
             ftTime    : S:= S + ' = #' + FormatDateTime('hh":"nn":"ss', FT.AsDateTime) + '#';
             ftDateTime: S:= S + ' = #' + FormatDateTime('mm"/"dd"/"yyyy hh":"nn":"ss', FT.AsDateTime) + '#';
             Else
             DatabaseError('Unable to build Master/Detail SQL Relationship!')
          End;
          S:=S+')';
          if (X < F_Master.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

Function  TKADaoTable.GetDaoBookMark(RS:Variant):Integer;
Var
 TempBK : Pointer;
Begin
 Result:=0;
 if RS.RecordCount=0 Then Exit;
 TempBK:=TVarData(RS.Bookmark).VPointer;
 Result:=PInteger(PSafeArray(TempBK)^.pvData)^;
End;


Function TKADaoTable.GetFieldIndexName(FiledName:String):String;
Var
  X,Y : Integer;
Begin
 if Assigned(F_Database) And (F_Database.Connected) Then
 Begin
 Try
  For X :=0 To F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Count-1 do
      Begin
        For Y := 0 To F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[X].Fields.Count-1 do
            Begin
              if AnsiCompareText(FiledName,F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[X].Fields.Item[Y].Name)=0 Then
                 Begin
                  Result :=F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[X].Name;
                  Exit;
                 End;
            End;
      End;
  Except
  End;
  End;
  Result := '';
End;

Function TKADaoTable.CheckFieldsInIndex(KF:TStringList):Boolean;
Var
  X,Y  : Integer;
  OK   : Boolean;
Begin
  Result := False;
  if F_IndexName='' Then Exit;
  if (NOT Assigned(F_Database))  Or (NOT F_Database.Connected) Then Exit;
  if KF.Count <> F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[F_IndexName].Fields.Count Then Exit;
  For X :=0 To KF.Count-1 do
      Begin
        OK :=False;
        For Y:=0 To F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[F_IndexName].Fields.Count-1 do
            Begin
             if AnsiCompareText(KF.Strings[X],F_Database.CoreDatabase.TableDefs[F_TableName].Indexes.Item[F_IndexName].Fields.Item[Y].Name)=0 Then OK :=True;
            End;
        if Not OK Then Exit;
      End;
  Result := True;
End;

Function  TKADaoTable.Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean;
Var
 KF     : TStringList;
 KV     : TStringList;
 X      : Integer;
 CR     : Integer;
 RI     : Integer;
 FN     : Integer;
 Find   : Boolean;
 S1,S2  : String;
 L      : Integer;
 Filter : String;
 TempRS : OleVariant;
 BKO,BKC: Integer;
 Delta  : Integer;
 KVV    : Array[0..12] of OleVariant;
 IdxC   : Integer;
 IndexOK: Boolean;
Begin
 Result:=False;
 if IsEmpty Then Exit;
 if (NOT Assigned(F_Database))  Or (NOT F_Database.Connected) Then Exit;
 KF := TStringList.Create;
 KV :=  TStringList.Create;
 StringToList(KeyFields,KF);
 VariantToList(KeyValues,KV);
 If (KF.Count <> KV.Count)  Then DatabaseError('Number of elements in the KeyValues array must be equal to the number of fields.');
 CR:=F_RecNo;
 if F_DaoTable.Bookmarkable Then
    Begin
      TempRS:=F_DaoTable.Clone;
      IndexOK := CheckFieldsInIndex(KF);
      if (TableType=dbOpenTable) And (F_IndexName<>'') And (IndexOK) Then
         Begin
           For X:=0 to 12 do KVV[X]:=VarNull;
           IdxC:=F_Database.CoreDatabase.TableDefs[F_TableName].Indexes[F_IndexName].Fields.Count;
           For X:=0 to IdxC-1 do
               Begin
                 L:=KF.IndexOf(F_Database.CoreDatabase.TableDefs[F_TableName].Indexes[F_IndexName].Fields.Item[X].Name);
                 if L <> -1 Then
                    Begin
                      KVV[X]:=KV.Strings[L];
                    End;
               End;
           TempRS.Index:=F_IndexName;
           TempRS.MoveFirst;
           if IdxC=1 Then OleVariant(TempRS).Seek('=',KVV[0])
           Else
           if IdxC=2 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1])
           Else
           if IdxC=3 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2])
           Else
           if IdxC=4 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2],KVV[3])
           Else
           if IdxC=5 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2],KVV[3],KVV[4])
           Else
           if IdxC=6 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5])
           Else
           if IdxC=7 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6])
           Else
           if IdxC=8 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7])
           Else
           if IdxC=9 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8])
           Else
           if IdxC=10 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9])
           Else
           if IdxC=11 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9],KVV[10])
           Else
           if IdxC=12 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9],KVV[10],KVV[11])
           Else
           if IdxC=13 Then OleVariant(TempRS).Seek('=',KVV[0],KVV[1],KVV[2],KVV[3],KVV[4],KVV[5],KVV[6],KVV[7],KVV[8],KVV[9],KVV[10],KVV[11],KVV[12]);
         End
      Else
         Begin
           Filter:=BuildLocateSQL(KF,KV,Options);
           TempRS.MoveFirst;
           OleVariant(TempRS).Move(CR);
           TempRS.FindFirst(Filter);
         End;
      Find:=NOT TempRS.NoMatch;
      if (Find) Then
          Begin
            Result:= True;
            BKO:=GetDaoBookMark(F_DaoTable);
            BKC:=GetDaoBookMark(TempRS);
            Delta:=BKC-BKO;
            CheckBrowseMode;
            CursorPosChanged;
            DoBeforeScroll;
            if Delta > 0 Then
               Begin
                 Repeat
                   F_DaoTable.MoveNext;
                   Inc(CR);
                   BKO:=GetDaoBookMark(F_DaoTable);
                 Until BKC=BKO;
               End;
            if Delta < 0 Then
               Begin
                  Repeat
                   F_DaoTable.MovePrevious;
                   Dec(CR);
                   BKO:=GetDaoBookMark(F_DaoTable);
                 Until BKC=BKO;
               End;
            F_RecNo:=CR;
            ClearBuffers;
            Resync([rmExact, rmCenter]);
            DoAfterScroll;
          End;
      TempRS.Close;
      TempRS:=NULL;
    End
 Else
    Begin
      CheckBrowseMode;
      CursorPosChanged;
      DoBeforeScroll;
      F_DaoTable.MoveFirst;
      Find:=False;
      RI:=0;
      While Not (F_DaoTable.EOF) Do
            Begin
             Find:=True;
             For X:=0 to KF.Count-1 do
                 Begin
                  FN:=Integer(KF.Objects[X])-1;
                  S1:=KV[X];
                  S2:=VarAsType(F_DaoTable.Fields.Item[FN].Value,VarString);
                  if loCaseInsensitive in Options Then
                      Begin
                       S1:=AnsiLowerCase(S1);
                       S2:=AnsiLowerCase(S2);
                      End;
                  if loPartialKey in Options Then
                      Begin
                       L:=Length(S1);
                       if S1[L]='*' Then System.Delete(S1,L,1);
                       if S1[1]='*' Then System.Delete(S1,1,1);
                       if Pos(S1,S2) = 0 Then Find:=False;
                      End
                  Else
                      Begin
                       if S1 <> S2 Then Find:=False;
                      End;
                  if NOT Find Then Break;
                 End;
             If Find Then
                Begin
                 DoBeforeScroll;
                 F_RecNo:=RI;
                 Result:= True;
                 ClearBuffers;
                 Resync([rmExact, rmCenter]);
                 DoAfterScroll;
                 Break;
                End
             Else
                Begin
                 Inc(RI);
                 F_DaoTable.MoveNext;
                End;
            End;
      if Not(Find) Then
         Begin
           F_DaoTable.MoveFirst;
           OleVariant(F_DaoTable).Move(CR);
           ClearBuffers;
           Resync([rmExact, rmCenter]);
          End;
      DoAfterScroll;
    End;
 KV.Free;
 KF.Free;
End;


Function  TKADaoTable.Find(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions;FindType:Integer): Boolean;
Var
 KF     : TStringList;
 KV     : TStringList;
 X      : Integer;
 CR     : Integer;
 Filter : String;
 {$IFDEF DYNADAO}
 TempRS : OleVariant;
 {$ELSE}
 TempRS : Recordset;
 {$ENDIF}
 BKO,BKC: Integer;
 BKV    : OleVariant;
 Delta  : Integer;
Begin
 Result:=False;
 if IsEmpty Then Exit;
 KF := TStringList.Create;
 KV :=  TStringList.Create;
 StringToList(KeyFields,KF);
 VariantToList(KeyValues,KV);
 If (KF.Count <> KV.Count)  Then DatabaseError('Number of elements in the KeyValues array must be equal to the number of fields.');
 For X:=0 To KF.Count-1 do KF.Objects[X]:=Pointer(FieldByName(KF[X]).FieldNo);
 CR:=F_RecNo;
 if F_DaoTable.Bookmarkable Then
    Begin
      Filter:=BuildLocateSQL(KF,KV,Options);
      TempRS:=F_DaoTable.Clone;
      TempRS.MoveFirst;
      OleVariant(TempRS).Move(CR);
      Case FindType of
           1 : TempRS.FindFirst(Filter);
           2 : TempRS.FindLast(Filter);
           3 : TempRS.FindNext(Filter);
           4 : TempRS.FindPrevious(Filter);
      End;
      if (Not TempRS.NoMatch) Then
          Begin
            Result:= True;
            BKO:=GetDaoBookMark(F_DaoTable);
            BKC:=GetDaoBookMark(TempRS);
            Delta:=BKC-BKO;
            CheckBrowseMode;
            CursorPosChanged;
            DoBeforeScroll;
            //******************************************************************
            BKV:=OleVariant(TempRS).Bookmark;
            OleVariant(F_DaoTable).Bookmark:=VarAsType(BKV, varOleStr);
            F_RecNo:=CR+Delta;
            /////////////////////////////////////////////// OLD METHOD DISABLED
            {
            if Delta > 0 Then
               Begin
                 Repeat
                   F_DaoTable.MoveNext;
                   Inc(CR);
                   BKO:=GetDaoBookMark(F_DaoTable);
                 Until BKC=BKO;
               End;
            if Delta < 0 Then
               Begin
                  Repeat
                   F_DaoTable.MovePrevious;
                   Dec(CR);
                   BKO:=GetDaoBookMark(F_DaoTable);
                 Until BKC=BKO;
               End;
            F_RecNo:=CR;
            }
            //////////////////////////////////////////////// OLD METHOD DISABLED
            //******************************************************************
            ClearBuffers;
            Resync([rmExact, rmCenter]);
            DoAfterScroll;
          End;
      TempRS.Close;
      {$IFDEF DYNADAO}
      TempRS:=NULL;
      {$ELSE}
      TempRS:=Nil;
      {$ENDIF}
    End
 Else
    Result:=False;
End;

Procedure TKADaoTable.SetKeyFields(const KeyFields: string);
Begin
 StringToList(KeyFields,F_KeyFields);
End;

Function TKADaoTable.Find_First(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,1);
End;

Function TKADaoTable.Find_Last(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,2);
End;

Function TKADaoTable.Find_Next(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,3);
End;

Function TKADaoTable.Find_Prior(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,4);
End;

Procedure TKADaoTable.SetFindData(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions);
Begin
 F_FindKeyFields:=KeyFields;
 F_FindKeyValues:=KeyValues;
 F_FindOptions:=Options;
End;

Function TKADaoTable.FindRecord(Restart, GoForward: Boolean): Boolean;
Begin
   Result:=False;
   if (Restart) And (GoForward)         Then Result:=Find_First(F_FindKeyFields,F_FindKeyValues,F_FindOptions);
   if (Restart) And (NOT GoForward)     Then Result:=Find_Last(F_FindKeyFields,F_FindKeyValues,F_FindOptions);
   if (NOT Restart) And (GoForward)     Then Result:=Find_Next(F_FindKeyFields,F_FindKeyValues,F_FindOptions);
   if (NOT Restart) And (NOT GoForward) Then Result:=Find_Prior(F_FindKeyFields,F_FindKeyValues,F_FindOptions);
End;

Procedure TKADaoTable.SetKey(const KeyFields: Array of String;const KeyValues: array of const);
Var
  X : Integer;
Begin
  F_KeyKeyFields:='';
  F_KeyKeyValues:=VarNull;
  For X:=0 to High(KeyFields) do
      Begin
        if X < High(KeyValues) Then
           F_KeyKeyFields := F_KeyKeyFields+KeyFields[X]+';'
        Else
           F_KeyKeyFields := F_KeyKeyFields+KeyFields[X];
       End;
  if High(KeyValues)=0 then
    Begin
      AssignVarValue(F_KeyKeyValues,KeyValues[0]);
    End
  Else
     Begin
       F_KeyKeyValues:=VarArrayCreate([0,High(KeyValues)],varVariant);
       For X:=0 to High(KeyFields) do AssignVarValue(F_KeyKeyValues,KeyValues[X]);
     End;
End;

Function  TKADaoTable.GotoKey: Boolean;
Begin
  Result := Find(F_KeyKeyFields,F_KeyKeyValues,[],3);
End;

Function TKADaoTable.Find_NearestEx(const KeyFields: string; const KeyValues: Variant):Boolean;
Var
  Options:TLocateOptions;
Begin
  Options:=[loCaseInsensitive,loPartialKey];
  Result:=Find(KeyFields,KeyValues,Options,1);
  if Not Result Then Result:=Find(KeyFields,KeyValues,Options,3);
End;

Function TKADaoTable.Find_Nearest(const KeyValues: array of const):Boolean;
Var
  KF         : String;
  KV         : Variant;
  KT         : Variant;
  X          : Integer;
Begin
  KF:='';
  For X:=0 to High(KeyValues) do
      Begin
        if X < High(KeyValues) Then KF := KF+F_KeyFields.Strings[X]+';' Else  KF := KF+F_KeyFields.Strings[X];
       End;
  if High(KeyValues)=0 then
    Begin
      AssignVarValue(KV,KeyValues[0]);
    End
  Else
     Begin
       KV:=VarArrayCreate([0,High(KeyValues)],varVariant);
       For X:=0 to High(KeyValues) do
           Begin
            AssignVarValue(KT,KeyValues[X]);
            KV[X]:=KT;
           End;
     End;
  Result:=Find_NearestEx(KF,KV);
End;


Function TKADaoTable.Seek_NearestEx(const KeyValues: array of const; SeekType:String):Boolean;
Var
 KV     : Variant;
 KT     : Variant;
 X      : Integer;
 CR     : Integer;
 RI     : Integer;
 NumVals: Integer;
 {$IFDEF DYNADAO}
 TempRS : OleVariant;
 {$ELSE}
 TempRS : Recordset;
 {$ENDIF}
Begin
 Result:=False;
 if F_IndexName='' Then Exit;
 if High(KeyValues)=0 then
    Begin
      NumVals:=1;
      AssignVarValue(KV,KeyValues[0]);
    End
  Else
     Begin
       KV:=VarArrayCreate([0,High(KeyValues)],varVariant);
       NumVals:=High(KeyValues)+1;
       For X:=0 to High(KeyValues) do
           Begin
            AssignVarValue(KT,KeyValues[X]);
            KV[X]:=KT;
           End;
     End;
     CR:=F_RecNo;
     TempRS:=F_DaoTable.Clone;
     TempRS.Index:=F_IndexName;
     OleVariant(TempRS).Move(CR);
     if NumVals=1 Then OleVariant(TempRS).Seek(SeekType,KV)
     Else
     if NumVals=2 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1])
     Else
     if NumVals=3 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2])
     Else
     if NumVals=4 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2],KV[3])
     Else
     if NumVals=5 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4])
     Else
     if NumVals=6 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5])
     Else
     if NumVals=7 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6])
     Else
     if NumVals=8 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7])
     Else
     if NumVals=9 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8])
     Else
     if NumVals=10 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9])
     Else
     if NumVals=11 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9],KV[10])
     Else
     if NumVals=12 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9],KV[10],KV[11])
     Else
     if NumVals=12 Then OleVariant(TempRS).Seek(SeekType,KV[0],KV[1],KV[2],KV[3],KV[4],KV[5],KV[6],KV[7],KV[8],KV[9],KV[10],KV[11],KV[12])
     Else
        DatabaseError('Too many seek keys! Maximum is 13!');
     if (Not TempRS.NoMatch) Then
          Begin
            Result:= True;
            CheckBrowseMode;
            CursorPosChanged;
            RI:=0;
            While NOT TempRS.BOF do
                    Begin
                      Inc(RI);
                      TempRS.MovePrevious;
                    End;
            if RI > 0 Then Dec(RI);
            DoBeforeScroll;
            OleVariant(F_DaoTable).Move(RI-CR);
            F_RecNo:=RI;
            ClearBuffers;
            Resync([rmExact, rmCenter]);
            DoAfterScroll;
          End;
     TempRS.Close;
     {$IFDEF DYNADAO}
     TempRS:=NULL;
     {$ELSE}
     TempRS:=Nil;
     {$ENDIF}
End;

Function TKADaoTable.Seek_Nearest(const KeyValues: array of const):Boolean;
Begin
 Result:=Seek_NearestEx(KeyValues,'>=');
End;

Procedure TKADaoTable.FindNearest(const KeyValues: array of const);
Begin
 if Seek_NearestEx(KeyValues,'>=')=False Then
    Begin
    End;
End;

Function TKADaoTable.FindKey(const KeyValues: array of const):Boolean;
Begin
 Result:=Seek_NearestEx(KeyValues,'>=');
End;

Function  TKADaoTable.Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant;
Var
 KF     : TStringList;
 KV     : TStringList;
 RF     : TStringList;
 {$IFDEF DYNADAO}
 RS     : OleVariant;
 TempRS : OleVariant;
 {$ELSE}
 RS     : Recordset;
 TempRS : Recordset;
 {$ENDIF}
 FT     : String;
 X      : Integer;
 FN     : Integer;
Begin
 Result:= NULL;
 if IsEmpty Then Exit;
 KF := TStringList.Create;
 KV := TStringList.Create;
 RF := TStringList.Create;
 StringToList(KeyFields,KF);
 VariantToList(KeyValues,KV);
 StringToList(ResultFields,RF);
 if (KF.Count <> KV.Count)  Then DatabaseError('Number of elements in the KeyValues array must be equal to the number of fields.');
 if (RF.Count=0) Or (ResultFields='') Then DatabaseError('ResultFields are not defined');
 For X:=0 To RF.Count-1 do RF.Objects[X]:=Pointer(FieldByName(RF[X]).FieldNo);
 RS:=F_DaoTable;
 FT:=F_DaoTable.Filter;
 RS.Filter:=BuildKeySQL(KF,KV);
 TempRS:=RS.OpenRecordset(dbOpenSnapshot,dbReadOnly);
 F_Database.Idle;
 If Not(TempRS.EOF and TempRS.BOF) then
    Begin
      TempRS.MoveFirst;
      if RF.Count=1 Then
         Begin
           FN:=Integer(RF.Objects[0])-1;
           Result:=TempRS.Fields.Item[FN].Value                                                                    
         End
      Else
         Begin
           Result:= VarArrayCreate([0,RF.Count - 1], varVariant);
           For X:=0 To RF.Count-1 do
               Begin
                 FN:=Integer(RF.Objects[X])-1;
                 Result[X]:=TempRS.Fields.Item[FN].Value
               End;
         End;
    End;
 TempRS.Close;
 {$IFDEF DYNADAO}
 TempRS:=NULL;
 {$ELSE}
 TempRS:=Nil;
 {$ENDIF}
 RS.Filter:=FT;
 RF.Free;
 KV.Free;
 KF.Free;
End;

{*************************************************************** DAO FIELD TYPES
  dbBoolean = 1;
  dbByte = 2;
  dbInteger = 3;
  dbLong = 4;
  dbCurrency = 5;
  dbSingle = 6;
  dbDouble = 7;
  dbDate = 8;
  dbBinary = 9;
  dbText = 10;
  dbLongBinary = 11;
  dbMemo = 12;
  dbGUID = 15;
  dbBigInt = 16;
  dbVarBinary = 17;
  dbChar = 18;
  dbNumeric = 19;
  dbDecimal = 20;
  dbFloat = 21;
  dbTime = 22;
  dbTimeStamp = 23;
//******************************************************************************
}

Function TKADaoTable.CreateField(FieldName:String;FieldType:Integer;FiledSize:Integer):Boolean;
Var
  FN,FT,FS,FI,FR:Variant;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError('TableName property must be set!');
       Exit;
     End;
  if Not Assigned(F_Database) Then
         Begin
           DatabaseError('Database property must be set!');
           Exit;
         End;
   if Not (F_Database.Connected) Then
         Begin
           DatabaseError('Database is not connected!');
           Exit;
         End;
  if F_Active Then
     Begin
      DatabaseError('Table must be in Inactive state to add fields!');
      Exit;
     End;
  FN:=VarArrayCreate([0, 0], varOleStr);
  FT:=VarArrayCreate([0, 0], varInteger);
  FS:=VarArrayCreate([0, 0], varInteger);
  FI:=VarArrayCreate([0, 0], varInteger);
  FR:=VarArrayCreate([0, 0], varInteger);
  FN[0]:=FieldName;
  FT[0]:=FieldType;
  FS[0]:=DaoSizeToBDESize(FieldType,FiledSize);
  FI[0]:=0;
  FR[0]:=0;
  Try
    Result:=F_Database.AddFieldsToTable(F_TableName,FN,FT,FS,FI,FR);
  Except
    Exit;
  End;
End;

Function TKADaoTable.CreateIndex(FieldName:String;IndexType:Integer):Boolean;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError('TableName property must be set!');
       Exit;
     End;
  if Not Assigned(F_Database) Then
     Begin
       DatabaseError('Database property must be set!');
       Exit;
     End;
   if Not (F_Database.Connected) Then
         Begin
           DatabaseError('Database is not connected!');
           Exit;
         End;
  if F_Active Then
     Begin
       DatabaseError('Cannot create index while table is Active!!');
       Exit;
     End;
  Result:=F_Database.CreateIndex(F_TableName,FieldName,IndexType);
End;

Function TKADaoTable.DeleteField(FieldName:String):Boolean;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError('TableName property must be set!');
       Exit;
     End;
  if Not Assigned(F_Database) Then
     Begin
       DatabaseError('Database property must be set!');
       Exit;
     End;
  if Not (F_Database.Connected) Then
     Begin
       DatabaseError('Database is not connected!');
       Exit;
     End;
  if F_Active Then
     Begin
       DatabaseError('Cannot delete field while table is Active!!');
       Exit;
     End;
  Try
    F_Database.DeleteField(F_TableName,FieldName);
  Except
    Exit;
  End;
  Result:=True;
End;

Function TKADaoTable.DeleteIndex(FieldName:String):Boolean;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError('TableName property must be set!');
       Exit;
     End;
  if Not Assigned(F_Database) Then
     Begin
       DatabaseError('Database property must be set!');
       Exit;
     End;
  if F_Active Then
     Begin
       DatabaseError('Cannot delete index while table is Active!!');
       Exit;
     End;
  if Not (F_Database.Connected) Then
     Begin
       DatabaseError('Database is not connected!');
       Exit;
     End;

  Try
    F_Database.DeleteIndexByFieldName(F_TableName,FieldName);
  Except
    Exit;
  End;
  Result:=True;
End;

Function TKADaoTable.EmptyTable:Boolean;
Begin
 Result := False;
 Try
   First;
   While NOT EOF do Delete;
 Except
   Exit;
 End;
 Result := True;
End;

Function TKADaoTable.InsertSQLString(MDString: String): String;
Begin
  Result:='';
  if Filtered Then Result:= Filter;
  if MDString <> '' then
    Begin
      if Result <> '' Then
         Result := '('+MDString+') AND ('+Result+')'
      Else
         Result := MDString;
    End;
End;

Procedure TKADaoTable.MasterDSChanged;
Begin
  if csDestroying in ComponentState then EXIT;
  if (MasterSource <> NIL) and not(F_MDisabled) then
  Begin
  if F_Master.Count > 0 Then
     Begin
      //*************************************************
      ClearBuffers;
      CheckBrowseMode;
      CloseDaoRecordset;
      OpenDaoRecordset;
      ActivateBuffers;
      First;
      //*************************************************
     End;
  End;
End;

Procedure TKADaoTable.Notification(AComponent: TComponent; Operation: TOperation);
Begin
 If (AComponent = F_Database) And (Operation = opRemove) Then
     Begin
       if F_Active Then Active := False;
       F_Database:= NIL;
     End;
 inherited Notification(AComponent, Operation);
End;


//******************************************************************************
//*                  Master/Detail Data Link Handling
//******************************************************************************
constructor TKADAODataLink.Create(DataSet: TKADaoTable);
Begin
  inherited Create(DataSet);
  F_KADaoTable:= DataSet;
  F_MasterIsChanged:=False;
End;

Procedure TKADAODataLink.ActiveChanged;
Begin
  F_KADaoTable.F_MDisabled:= True;
  if DataSet <> NIL then F_KADaoTable.F_MDisabled:= not(DataSet.Active);
  if (F_KADaoTable.F_Active) then F_KADaoTable.MasterDSChanged Else F_MasterIsChanged:=True;
End;

{$IFNDEF VER100}
  {$IFNDEF VER110}
Function TKADAODataLink.GetDetailDataSet: TDataSet;
Begin
  Result:= F_KADaoTable;
End;
  {$ENDIF}
{$ENDIF}

Procedure TKADAODataLink.RecordChanged(Field: TField);
Begin
  if (Field = NIL) and (F_KADaoTable.Active) then F_KADaoTable.MasterDSChanged;
End;

Procedure TKADAODataLink.CheckBrowseMode;
Begin
  if F_KADaoTable.Active then F_KADaoTable.CheckBrowseMode;
End;

//******************************************************************************
//*                         Blob Stream Handling
//******************************************************************************
constructor TKBlobStream.Create(Field: TBlobField; Mode: TBlobStreamMode);
Var
   RD     : OleVariant;
Begin
     F_BlobData := '';
     F_BlobSize := 0;
     F_Mode     := Mode;
     F_Field    := Field;
     F_DataSet  := F_Field.DataSet as TKADaoTable;
     F_Buffer   := F_DataSet.GetActiveRecordBuffer;
     if not (F_Buffer = nil) then F_DataSet.InternalSetToRecord(F_Buffer);
     F_Opened := True;
     if Mode = bmWrite then Truncate
     Else
     if not F_Field.Modified then
     Begin
          if (F_DataSet.State = dsInsert)
          then
            Begin
              F_BlobData := '';
             End
          Else
             Begin
               if Not (F_Buffer = nil) Then
                  Begin
                    Try
                      if (F_DataSet.BlobOffset <> 0) Or (F_DataSet.BlobNumBytes  <> 0) Then
                         Begin
                           RD:=F_DataSet.F_DaoTable.Fields.Item[F_Field.FieldNo-1].GetChunk(F_DataSet.BlobOffset,F_DataSet.BlobNumBytes);
                         End
                      Else
                         Begin
                           RD:=F_DataSet.F_DaoTable.Fields.Item[F_Field.FieldNo-1].Value;
                         End;
                      if VarType(RD) = varNull then RD := '';
                      F_BlobData:=RD;
                     Except
                      F_BlobData:='';
                     End;
                  End
               Else
                  Begin
                    F_BlobData:='';
                  End;
             End;
          F_BlobSize:=Length(F_BlobData);
          Size := F_BlobSize;
     End;
End;


destructor TKBlobStream.Destroy;
Begin
   if F_Modified then
     try
          F_DataSet.DataEvent(deFieldChange, Longint(F_Field));
          F_BlobData := '';
          F_Buffer   := Nil;
          F_Opened   := False;
     except
          Application.HandleException(Self);
     End;
End;


Function TKBlobStream.Read(var Buffer; Count: Longint): Longint;
Begin
     Result := 0;
     if F_Opened then
     Begin
          if Count > Size - F_Position then
             Result := Size - F_Position else
             Result := Count;
          if Result > 0 then
          Begin
               Move(PChar(F_BlobData)[F_Position], Buffer, Result);
               Inc(F_Position, Result);
          End;
     End;
End;


Function TKBlobStream.Write(const Buffer; Count: Longint): Longint;
var
   pTemp  : Pointer;
   RData  : TStringList;
   Changed: TList;
Begin
     Result := 0;
     if F_Opened then
     Begin
          try
          Begin
               SetLength(F_BlobData,Count+1);
               pTemp:=PChar(F_BlobData);
               CopyMemory(pTemp, @Buffer, Count);
               F_BlobData  := Copy(F_BlobData,1,Count);
               F_BlobSize  := Length(F_BlobData);
               Size := F_BlobSize;
               RData:=PDaoInfo(F_Buffer+F_DataSet.F_StartMyInfo)^.RecordData;
               Changed:=PDaoInfo(F_Buffer+F_DataSet.F_StartMyInfo)^.FieldChanged;
               RData.Strings[F_Field.FieldNo-1]:=F_BlobData;
               Changed[F_Field.FieldNo-1]:=Pointer(True);
               F_Modified := True;
          End;
          finally
          End;
          Inc(F_Position, Count);
          Result := Count;
          F_Modified := True;
     End;
End;


Function TKBlobStream.Seek(Offset: Longint; Origin: Word): Longint;
Begin
     case Origin of
          0: F_Position := Offset;
          1: Inc(F_Position, Offset);
          2: F_Position := F_BlobSize + Offset;
     End;
     Result := F_Position;
End;


Procedure TKBlobStream.Truncate;
Var
   RData  : TStringList;
   Changed: TList;
Begin
     if F_Opened then
        Begin
         RData:=PDaoInfo(F_Buffer+F_DataSet.F_StartMyInfo)^.RecordData;
         Changed:=PDaoInfo(F_Buffer+F_DataSet.F_StartMyInfo)^.FieldChanged;
         SetLength(F_BlobData,F_Position);
         F_BlobSize  := Length(F_BlobData);
         Size := F_BlobSize;
         RData.Strings[F_Field.FieldNo-1]:=F_BlobData;
         Changed[F_Field.FieldNo-1]:=Pointer(True);
         F_Modified := True;
        End;
End;

//***********************************************************************************
Function TKADaoTable.IntegerToBuffer(Buffer: Pointer; S: String): Boolean;
Begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = '' then S := '0';
     Try
       Integer(Buffer^) := StrToInt(S);
     Except
       Integer(Buffer^) := Round(StrToFloat(S));
     End;
End;


Function TKADaoTable.FloatToBuffer(Buffer: Pointer; S: String): Boolean;
Begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = '' then S := '0';
     Double(Buffer^) := StrToFloat(S);
End;

Function TKADaoTable.BooleanToBuffer(Buffer: Pointer; S: String): Boolean;
Begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = ''    Then S := '0';
     if S = '-1'  Then S := '1';
     if AnsiLowerCase(S)='false' Then S := '0';
     if AnsiLowerCase(S)='true'  Then S := '1';
     if AnsiLowerCase(S)='no'    Then S := '0';
     if AnsiLowerCase(S)='yes'   Then S := '1';
     WordBool(Buffer^) := WordBool(StrToInt(S));
End;

//************************************************************************** OK
Function TKADaoTable.DateToBuffer(Buffer: Pointer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
   P    : Integer;
Begin
 Result:=False;
 if Buffer=Nil Then Exit;
 P := Pos(' ',S);
 if P=0 Then Exit;
 Ttmp.Date:=StrToInt(Copy(S,1,P-1));
 System.Delete(S,1,P);
 Ttmp.Time:=StrToInt(S);
 Dtmp := Buffer;
 Dtmp^.Date := Ttmp.Date;
 Result:=True;
End;


//************************************************************************** OK
Function TKADaoTable.TimeToBuffer(Buffer: Pointer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : ^TTimeStamp;
   P    : Integer;
Begin
 Result:=False;
 if Buffer=Nil Then Exit;
 P := Pos(' ',S);
 if P=0 Then Exit;
 Ttmp.Date:=StrToInt(Copy(S,1,P-1));
 System.Delete(S,1,P);
 Ttmp.Time:=StrToInt(S);
 Dtmp:=Buffer;
 Dtmp^.Time:=Ttmp.Time;
 Result:=True;
End;

//************************************************************************** OK
Function TKADaoTable.DateTimeToBuffer(Buffer: Pointer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
   P    : Integer;
Begin
 Result:=False;
 if Buffer=Nil Then Exit;
 P := Pos(' ',S);
 if P=0 Then Exit;
 Ttmp.Date:=StrToInt(Copy(S,1,P-1));
 System.Delete(S,1,P);
 Ttmp.Time:=StrToInt(S);
 Dtmp := Buffer;
 Dtmp^.DateTime := TimeStampToMSecs(Ttmp);
 Result:=True;
End;

//************************************************************************** OK
Function TKADaoTable.BufferToDate(Buffer: Pointer): String;
var
   Dtmp : ^TDateTimeRec;
Begin
     Result := '';
     Dtmp   := Buffer;
     if Dtmp=Nil Then Exit;
     Result := IntToStr(Dtmp.Date)+' '+IntToStr(Dtmp.Time);
End;

//************************************************************************** OK
Function TKADaoTable.BufferToDateTime(Buffer: Pointer): String;
var
   TTmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
Begin
     Result := '';
     Dtmp   := Buffer;
     if Dtmp=Nil Then Exit;
     Ttmp   := MsecsToTimeStamp(Dtmp.DateTime);
     Result := IntToStr(Ttmp.Date)+' '+IntToStr(Ttmp.Time);
End;
//************************************************************************** OK
Function TKADaoTable.BufferToTime(Buffer: Pointer): String;
var
   Dtmp : ^TTimeStamp;
Begin
     Result := '';
     Dtmp   := Buffer;
     if Dtmp=Nil Then Exit;
     //******************************* SHAME MICROSOFT!!!
     Result := IntToStr(693594)+' '+IntToStr(Dtmp.Time);
End;


//***************************************************************** TPARAMETERS
{$IFDEF USEPARAMS}
 {$IFNDEF VER100}
  {$IFNDEF VER110}
procedure TKADaoTable.SetParamsList(Value: TParams);
begin
    F_Params.AssignValues(Value);
end;

procedure TKADaoTable.UpdateParamsList(Sender: TObject);
var
    List: TParams;
begin
    if not (csReading in ComponentState) then
        if ParamCheck or (csDesigning in ComponentState) then
        begin
            List := TParams.Create(Self);
            try
                List.ParseSQL(SQL.Text, True);
                List.AssignValues(F_Params);
                F_Params.Clear;
                F_Params.Assign(List);
            finally
                List.Free;
            end;
        end;
end;

function TKADaoTable.GetParamsCount: Word;
begin
    Result := F_Params.Count;
end;

procedure TKADaoTable.DefineProperties(Filer: TFiler);

    function WriteData: Boolean;
    begin
        if Filer.Ancestor <> nil then
            Result := not F_Params.IsEqual(TKADaoTable(Filer.Ancestor).F_Params)
        else
            Result := F_Params.Count > 0;
    end;

begin
    inherited DefineProperties(Filer);
    Filer.DefineProperty('ParamData', ReadParamData, WriteParamData, WriteData);
end;

procedure TKADaoTable.ReadParamData(Reader: TReader);
begin
    Reader.ReadValue;
    Reader.ReadCollection(F_Params);
end;

procedure TKADaoTable.WriteParamData(Writer: TWriter);
begin
    Writer.WriteCollection(Params);
end;
   {$ENDIF}
 {$ENDIF}
{$ENDIF}
//************************************************************** TPARAMETERS END

//*********************************************************************************** TableName
Procedure TTableNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase  : TKADaodatabase;
  X      : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.F_Database) And (DTable.F_Database.Connected) Then
       Begin
        DBase:=DTable.F_Database;
        DBase.RefreshDefinitions;
        Try
          For X := 0 to DBase.TableNames.Count-1 do Proc(DBase.TableNames.Strings[X]);
        Finally
        End;
       End;
  End;
End;

Function TTableNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;
//*********************************************************************************** QueryName

Procedure TQueryNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase : TKADaodatabase;
  X     : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.F_Database) And (DTable.F_Database.Connected) Then
       Begin
        DBase:=DTable.F_Database;
        DBase.RefreshDefinitions;
        Try
          For X := 0 to DBase.QueryDefNames.Count-1 do Proc(DBase.QueryDefNames.Strings[X]);
        Finally
        End;
       End;
  End;
End;

Function TQueryNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;
//*********************************************************************************** IndexName
Procedure TIndexNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase  : TKADaodatabase;
  X      : Integer;
  Count  : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.F_Database) And (DTable.F_Database.Connected)  Then
    if DTable.TableName <> '' Then
       Begin
        DBase:=DTable.F_Database;
        Try
          DBase.RefreshDefinitions;
          Count :=DBase.CoreDatabase.TableDefs.Item[DTable.TableName].Indexes.Count;
          For X := 0 to  Count-1 do
              Begin
                Proc(DBase.CoreDatabase.TableDefs.Item[DTable.TableName].Indexes.Item[X].Name);
              End;
        Finally
        End;
       End;
  End;
End;


Function TIndexNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;

//***************************************************************************************************************************

Function TTableTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result := Inherited GetAttributes + [paValueList, paSortList];
End;

Function  TTableTypeEditor.GetValue: string;
Begin
 if GetComponent(0) is TKADaoTable then
    Begin
      Result:='StandardTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenTable       then Result:='StandardTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenDynaset     then Result:='DynasetTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenDynamic     then Result:='DynamicTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenSnapshot    then Result:='SnapshotTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenForwardOnly then Result:='ForwardOnlyTable';
    End;
End;

Procedure TTableTypeEditor.GetValues( Proc: TGetStrProc);
Begin
  if GetComponent(0) is TKADaoTable then
     Begin
       Proc('StandardTable');
       Proc('DynasetTable');
       Proc('DynamicTable');
       Proc('SnapshotTable');
       Proc('ForwardOnlyTable');
     End;
End;


Procedure TTableTypeEditor.SetValue(const Value: string);
Var
 Dat : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
       Begin
       Dat:=dbOpenTable;
       if Value='StandardTable'    Then Dat:=dbOpenTable;
       if Value='DynasetTable'     Then Dat:=dbOpenDynaset;
       if Value='DynamicTable'     Then Dat:=dbOpenDynamic;
       if Value='SnapshotTable'    Then Dat:=dbOpenSnapshot;
       if Value='ForwardOnlyTable' Then Dat:=dbOpenForwardOnly;
       Inherited SetValue(IntToStr(Dat));
       Modified;
     End;
End;

//***************************************************************************************************************************

Function TLockTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result := Inherited GetAttributes + [paValueList, paSortList];
End;

Function  TLockTypeEditor.GetValue: string;
Begin
 if GetComponent(0) is TKADaoTable then
    Begin
      Result:='dbPessimistic';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbPessimistic       then Result:='dbPessimistic';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbOptimistic        then Result:='dbOptimistic';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbOptimisticValue   then Result:='dbOptimisticValue';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbReadOnly          then Result:='dbReadOnly';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbOptimisticBatch   then Result:='dbOptimisticBatch';
    End;
End;

Procedure TLockTypeEditor.GetValues( Proc: TGetStrProc);
Begin
  if GetComponent(0) is TKADaoTable then
     Begin
       Proc('dbPessimistic');
       Proc('dbOptimistic');
       Proc('dbOptimisticValue');
       Proc('dbReadOnly');
       Proc('dbOptimisticBatch');
     End;
End;


Procedure TLockTypeEditor.SetValue(const Value: string);
Var
 Dat : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
       Begin
       Dat:=DAOApi.dbPessimistic;
       if Value='dbPessimistic'     Then Dat:=DAOApi.dbPessimistic;
       if Value='dbOptimistic'      Then Dat:=DAOApi.dbOptimistic;
       if Value='dbOptimisticValue' Then Dat:=DAOApi.dbOptimisticValue;
       if Value='dbReadOnly'        Then Dat:=DAOApi.dbReadOnly;
       if Value='dbOptimisticBatch' Then Dat:=DAOApi.dbOptimisticBatch;
       Inherited SetValue(IntToStr(Dat));
       Modified;
     End;
End;


Function TSortByEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TSortByEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TSortByEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

Procedure TSortByEditor.Edit;
Var
 DT:TKADaoTable;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if NOT Assigned(DT.F_Database) Then Exit;
    if NOT (DT.F_Database.Connected) Then Exit;
    if (DT.Active=False) And (Not (csLoading in DT.ComponentState)) Then
       Begin
         Try
           DT.Active:=True;
           DT.Active:=False;
         Except
           DT.F_SortedBy.Clear;
           DT.F_FieldNames.Clear;
           DatabaseError('Cannot obtain field names!');
           Exit;
         End;
       End;
    Application.CreateForm(TSortByDialog,SortDialog);
    if SortDialog.Execute(DT.F_FieldNames,DT.F_SortedBy,DT.F_UseBrackets) Then
       Begin
         DT.SortedBy:=DT.F_SortedBy;
       End;
    SortDialog.Free;
  End;
End;

Function TQueryDefParamsEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TQueryDefParamsEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TQueryDefParamsEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

Procedure TQueryDefParamsEditor.Edit;
Var
 DT      : TKADaoTable;
 X       : Integer;
 Dir     : Integer;
 NP      : Integer;
 Typ     : Integer;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if NOT Assigned(DT.F_Database) Then Exit;
    if NOT (DT.F_Database.Connected) Then Exit;
    if DT.F_QueryDefName='' Then Exit;
    if DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters.Count=0 Then
       Begin
         DatabaseError('This QueryDef object has NO parameters!');
         Exit;
       End;
    DT.F_QD_ParamNames.Clear;
    DT.F_QD_ParamDaoTypes.Clear;
    DT.F_QD_ParamBDETypes.Clear;
    Try
     NP:=0;
     For X := 0 To DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters.Count-1 do
        Begin
          Dir:= DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters[X].Direction;
          if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
             Begin
              Inc(NP);
              {$IFDEF DYNADAO}
              Typ :=DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters[X].Type;
              {$ELSE}
              Typ :=DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters[X].Type_;
              {$ENDIF}
              if (Typ=dbDate) Then Typ:=dbTimeStamp;
              DT.F_QD_ParamNames.Add(DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters[X].Name);
              DT.F_QD_ParamDaoTypes.Add(GetDaoFieldTypeNames(Typ));
              DT.F_QD_ParamBDETypes.Add(GetBDEFieldTypeNames(DaoToBDE(Typ)));
             End;
        End;
     if NP=0 Then
        Begin
           DatabaseError('This QueryDef object has NO INPUT parameters!');
           Exit;
        End;
    Except
      DatabaseError('Cannot obtain QueryDef Parameters');
      Exit;
    End;
    Application.CreateForm(TQueryDefDialog,QueryDefDialog);
    if QueryDefDialog.Execute(DT.F_QD_ParamNames,DT.F_QD_ParamDaoTypes,DT.F_QD_ParamBDETypes,DT.F_QueryDefParameters) Then;
    QueryDefDialog.Free;
    Modified;
  End;
End;


//***************************************************************************************************************************
Function TMasterFieldsEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TMasterFieldsEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TMasterFieldsEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

Procedure TMasterFieldsEditor.Edit;
Var
 MT,DT        : TKADaoTable;
 MF,DF,TF     : TStrings;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if NOT Assigned(DT.F_Database) Then Exit;
    If Not (DT.F_Database.Connected) Then Exit;
    if Not Assigned(DT.MasterSource) Then
       Begin
        DT.F_Master.Clear;
        DT.F_Detail.Clear;
        DT.F_MasterFields.Clear;
        DatabaseError('MasterSource not defined!');
        Exit;
       End;
    if NOT (DT.MasterSource.DataSet is TKADaoTable) Then
       Begin
        DT.F_Master.Clear;
        DT.F_Detail.Clear;
        DT.F_MasterFields.Clear;
        DatabaseError('Cannot link to other datasets exept KADaoTable''s!');
        Exit;
       End;
    MT:=DT.MasterSource.DataSet As TKADaoTable;
    if (DT.Active=False) and Not (csLoading in DT.ComponentState) Then
       Begin
         Try
           DT.Active:=True;
           DT.Active:=False;
         Except
           DT.F_Master.Clear;
           DT.F_Detail.Clear;
           DT.F_MasterFields.Clear;
           DatabaseError('Cannot obtain detail field names!');
           Exit;
         End;
       End;
    if (MT.Active=False) and Not (csLoading in DT.ComponentState) Then
       Begin
         Try
           MT.Active:=True;
           MT.Active:=False;
         Except
           DT.F_Master.Clear;
           DT.F_Detail.Clear;                              
           DT.F_MasterFields.Clear;
           DatabaseError('Cannot obtain master field names!');
           Exit;
         End;
       End;
    MF     := TStringList.Create;
    DF     := TStringList.Create;
    TF     := TStringList.Create;
    MF.SetText(MT.F_MDFieldNames.GetText);
    DF.SetText(DT.F_MDFieldNames.GetText);
    TF.SetText(DT.F_MasterFields.GetText);
    Application.CreateForm(TMasterDetailForm,MasterDetailForm);
    if MasterDetailForm.Execute(DF,MF,TF) Then;
    MasterDetailForm.Free;
    DT.MasterFields:=TF;
    MF.Free;
    DF.Free;
    TF.Free;
    Modified;
  End;
End;

Function TMasterSourcePropertyEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paValueList, paSortList];
End;


Function TMasterSourcePropertyEditor.GetValue: String;
var
  Tab: TKADaoTable;
Begin
  Result:= '';
  Tab:= TKADaoTable(GetComponent(0));
  if Tab.MasterSource <> NIL then Result:= Tab.MasterSource.Name
  else Result:= '';
End;

Procedure TMasterSourcePropertyEditor.GetValues(Proc: TGetStrProc);
var
  Tab: TKADaoTable;
  DS : TDataSource;
  I  : Integer;
Begin
  Tab:= TKADaoTable(GetComponent(0));
  if Tab.Owner = NIL then EXIT;
  for I:= 0 to Tab.Owner.ComponentCount - 1 do
    Begin
      DS:= NIL;
      if Tab.Owner.Components[i] is TDataSource then DS:= TDataSource(Tab.Owner.Components[i]);
      if (DS <> NIL) and (DS.DataSet <> Tab) then Proc(DS.Name);
    End;
End;

Procedure TMasterSourcePropertyEditor.SetValue(const Value: String);
var
  Tab  : TKADaoTable;
  Comp : TComponent;
Begin
  Tab:= TKADaoTable(GetComponent(0));
  if Value = '' then
    Begin
      Tab.MasterSource:= NIL;
      EXIT;
    End;
  if Tab.Owner = NIL then EXIT;
  Comp:= Tab.Owner.FindComponent(Value);
  if (Comp = NIL) or not(Comp is TDataSource) then EXIT;
  if NOT ((Comp AS TDataSource).DataSet is TKADaoTable) Then
       Begin
        DatabaseError('Cannot link to other datasets exept KADaoTable''s!');
        Exit;
       End;
  Tab.MasterSource:= TDataSource(Comp);
  Modified;
End;
//***************************************************************************************************************************

Procedure Register;
Begin
    RegisterComponents('KA Dao', [TKADaoTable]);
    RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'TableName',TTableNameEditor);
    RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'QueryDefName',TQueryNameEditor);
    RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'IndexName',TIndexNameEditor);
    RegisterPropertyEditor(TypeInfo(Integer),TKADaoTable,'TableType',TTableTypeEditor);
    RegisterPropertyEditor(TypeInfo(Integer),TKADaoTable,'LockType',TLockTypeEditor);
    RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'SortedBy',TSortByEditor);
    RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'QueryDefParameters',TQueryDefParamsEditor);
    RegisterPropertyEditor(TypeInfo(TDataSource), TKADaoTable, 'MasterSource', TMasterSourcePropertyEditor);
    RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'MasterFields',TMasterFieldsEditor);
End;
end.

