unit KDaoTable;
{$DEFINE DYNADAO}     //This is the preffered way to use DAO - disable if
                     //one of the bottom options are enabled
{DEFINE DAO35}      //Disable DYNADAO and DAO36 to USE
{DEFINE DAO36}       //Disable DYNADAO and DAO35 to USE
//******************************************************************************
// Protection for absent-minded people
//******************************************************************************
{$IFDEF DYNADAO}
  {$IFDEF DAO36}
   YOU CANNOT DEFINE BOTH DYNADAO AND DAO36
  {$ENDIF}
  {$IFDEF DAO35}
   YOU CANNOT DEFINE BOTH DYNADAO AND DAO35
  {$ENDIF}
{$ELSE}
  {$IFDEF DAO36}
     {$IFDEF DAO35}
        YOU CANNOT DEFINE BOTH DAO35 AND DAO36
     {$ENDIF}
  {$ENDIF}
{$ENDIF}
//******************************************************************************
//                    Delphi Dao Project Version 1.9
//                 Copyright (c) 2000 by Kiril Antonov
//******************************************************************************

//******************************* CHANGES **************************************
// 28.05.2000 - Fixed a minor bug which raises exception when
//              getting GetQueryDefSQLText
// 28.05.2000 - Added FieldChanged TList - each item corresponds to a field
//              in the record
//              If  Boolean(FieldChanged[X]) is true then when posting data this
//              field is updated
//              This prevents from writing bak entire record to the database -
//              only changed fields are posted.
// 28.05.2000 - Added new property editor for SortedBy property which allows an
//              easy method to define sort order of a Table/Query
//              A new property SortedByText gives low level access to the
//              SortedBy property
// 28.05.2000 - Added new property editor for QueryDefParameters property which
//              allows an easy method to enter parameters to QUERYDEF dao object
//              A new property QueryDefParametersText gives low level access to
//              the QueryDefParameters property
// 30.05.2000 - Fixed a bug in GetRecNo which gives some troubles with DBGrids
//
// 31.05.2000 - Changed InternalSetToRecord method to speedup positioning inside
//              a table
//
// 01.06.2000 - Created Master/Detail Relationship support with property editor
//              similar to Delphi
//              A few new properties are anounced:
//                - MasterSource : TDataSource; - DataSource of the Master Table
//                - MasterFields : TStrings;    - A StringList with
//                  relationships in the form: "DetailField -> MasterField"
// 04.06.2000 - Handled default values for fields
//
// 07.06.2000 - Handled empty fields (WITH NOT REQUITRED VALUE)
//              when posting new records to database
//
// 08.06.2000 - Added support for Dynamycally setting DAO Version
//
// 11.06.2000 - Filter is working properly now
//
// 11.06.2000 - Added FULL support for Master/Detail (Table and Query)
//
// 11.06.2000 - Changed many options for Bookmarks
//              to support Dynamic DAO (OleVariant)
//
// 11.06.2000 - Added support for Locate
//
// 11.06.2000 - Added support for Lookup
//
// 12.06.2000 - InternalGotoBookmark rewrited completely
//
// 12.06.2000 - Locate supports TLocateOptions now
//
// 12.06.2000 - Added four new methods:
//              CreateField
//              CreateIndex
//              DeleteField
//              DeleteIndex
//
// 14.06.2000 - Property Editors for Tables, QueryDefs and Indexes use
//              RefreshDefinitions to reflect changes made outside Delphi
//
// 18.06.2000 - Added another method of Locate whish is very fast but works only
//              if Table supports bookmarks
//
// 18.06.2000 - Added GetIndexNames method for Compatibility with TTable
//
// 18.06.2000 - Added FOUR New methods for fast search in a table:
//                Find_First
//                Find_Last
//                Find_Next
//                Find_Prior
//              These new methods are similar to TTable but can search on
//              NON-INDEXED fields
//              Call them as calling Locate method
// 19.06.2000 - Two new method where added  Find_Nearest and Find_NearestEx
//              Call Find_NearestEx as calling a Locate method
//              For Find_Nearest you must first call SetKeyFields method with a
//              semicolon separated Field names and then Call Find_Nearest
//              See the new demos on KADao site for full explanation
// 19.06.2000 - Added new method Seek_Nearest
//              Seek_Nearest works as Dao Seek method so you must set the index
//              in which you want to search
//              See the new demos on KADao site for full explanation
//
// 19.06.2000 - Fixed a minor bug with empty tables
//
// 19.06.2000 - Added support for OnFilterRecord event
//              GetRecordCount And GetRecNo now works as standard specifications
//              require
//
// 27.06.2000 - Added CompareBookmarks method - now multiselect in DBGrid
//              works fine
//
// 28.06.2000 - Added GetFieldNames - it receives as a parameter TStringList
//              and fills them with Names of the fields
//              Each Name has a corresponding TObject wich is an integer
//              describing a Field original DAO type (Not BDE type)
//
// 28.06.2000 - Added QueryDefODBCMaxRecords (works only on ODBC data sources)
//              to limit number of returned records
//              Setting to 0 means NO LIMIT
//
// 28.06.2000 - Added QueryDefType property - it returns a QueryDef Type
//              as a string. Original DAO value is stored in QueryDefTypeInt
//
// 28.06.2000 - Added RecordsAffected variable
//              When using  ExecSQL it teturns then number of affected records
//              and also sets RecordsAffected to the same value.
//
// 28.06.2000 - Added Requery method which is useful for refreshing dynaset
//              tables
//
// 28.06.2000 - Added Seek_NearestEx method
//              An additional parameter is SeekType (String) which can be one of
//              the following: '<', '<=', '=', '>=', '>'
//
// 28.06.2000 - Added SetRecNo internal dataset method (still in beta testing)
//
// 28.06.2000 - Added two new variables BlobOffset and BlobNumBytes
//              Whend one of this variables is different then zero
//              reading from a blob field starts from BlobOffset position
//              and the return information is BlobNumBytes in size
//              When BlobNumBytes is > of entire blob size a smaller amount
//              of bytes is returned (realized using DAO GetChunk method)
//              Warninng! This is blob wide i.e. all blobs are affected
//              So you must set them to Zero each time when the another blob
//              which must be read at all is readed from the record
//
// 28.06.2000 - Added two new read only properties TableDateCreated and
//              TableLastUpdated - works only on standart tables and QueryDefs
//
// 28.06.2000 - Added a new meton AppendToBlob - uses DAO AppendChunk method
//
// 29.06.2000 - Added a new variable QueryDefReturnParams of type OleVariant
//              It contains a results from a QueryDefRecordset
//              If result is only one QueryDefReturnParams is a single variant
//              otherwise QueryDefReturnParams is VarArray
//
// 29.06.2000 - AT LAST FIXED PROBLEM WITH EMPTY RECORDESTS - GREAT VICTORY!!!!
//
// 29.06.2000 - Removed SetRecNo internal dataset method (not yet understand)
//
//
// 03.07.2000 - Added new property UseRecordCount
//              Since DBGrid uses RecordCount Very extensivelly which can
//              slowdown database performance you can turn it off by setting
//              UseRecordCount
//
// 04.07.2000 - AT LAST FIXED PROBLEM WITH RETRIEVING ACTUAL TYPE OF
//              dbDate FIELD TYPE - NOW YOU CAN USE dbTime AND dbTimeStamp !!!
//
// 05.07.2000 - Fixed a very rediculous bug with RETRIEVING ACTUAL TYPE OF
//              dbDate FIELD. Now a ftDateTime is the default type
//              But if you set Format property in MS Acess a dbDate and dbTime
//              also is used!
// 05.07.2000 - Added additional code to DateTimeToBuffer and TimeToBuffer
//              routines to support both method of retrieving Date/Time info
//
// 05.07.2000 - Added support for Forward Only Tables - Works Good but
//              DBGrid violates forward only restrictions so use with care
//              A more complicated changes will be made in future to avoid these
//******************************************************************************


interface
uses                                                     
DAOApi,
{$IFDEF DAO35}
DAO35Api,
{$ENDIF}
{$IFDEF DAO36}
DAO36Api,
{$ENDIF}
Windows, SysUtils, Classes, Db, DBCommon, DBTables, KDaoDataBase, DsgnIntf, ActiveX, Forms;

const
        MYBOOKMARKSIZE=8;

Type
TDaoInfo=record
        RecordNo        : Integer;
        RecordData      : TStringList;
        FieldChanged    : TList;
        BookmarkFlag    : TBookmarkFlag;
        BookmarkData    : Integer;
        DaoBookmark     : TSafeArray;
        BookmarkString  : array[0..MYBOOKMARKSIZE] of Char;
end;
PDaoInfo=^TDaoInfo;

TOO    = (
          dbDenyWrite,
          dbDenyRead,
          dbReadOnly,
          dbAppendOnly,
          dbInconsistent,
          dbConsistent,
          dbSQLPassThrough,
          dbFailOnError,
          dbForwardOnly,
          dbSeeChanges,
          dbRunAsync,
          dbExecDirect
          );
TOOSet = Set of TOO;

TTableNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TQueryNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TIndexNameEditor = class(TStringProperty)
    Public
      Procedure GetValues( Proc: TGetStrProc); override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;

TTableTypeEditor = class(TIntegerProperty)
    Public
     Function  GetValue: string; override;
     Procedure GetValues( Proc: TGetStrProc);override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TLockTypeEditor = class(TIntegerProperty)
    Public
     Function  GetValue: string; override;
     Procedure GetValues( Proc: TGetStrProc);override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TSortByEditor = class(TStringProperty)
    Public
     Function  GetValue: string; override;
     Procedure Edit;override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TQueryDefParamsEditor = class(TStringProperty)
    Public
     Function  GetValue: string; override;
     Procedure Edit;override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TMasterFieldsEditor = class(TStringProperty)
    Public
     Procedure Edit;override;
     Procedure SetValue(const Value: string); override;
     Function  GetAttributes: TPropertyAttributes; override;
    End;

TMasterSourcePropertyEditor = class(TPropertyEditor)
    public
      function GetAttributes: TPropertyAttributes; override;
      function  GetValue: String; override;
      procedure GetValues(Proc: TGetStrProc); override;
      procedure SetValue(const Value: String); override;
  end;

TKADaoTable = class;
TKADAODataLink = class(TMasterDataLink)
    private
      F_KADaoTable        : TKADaoTable;
      F_MasterIsChanged   : Boolean;
    protected
      procedure ActiveChanged; override;
      procedure RecordChanged(Field: TField); override;
      {$IFNDEF VER100}
      function  GetDetailDataSet: TDataSet; override;
      {$ENDIF}
      procedure CheckBrowseMode; override;
    public
      constructor Create(DataSet: TKADaoTable);
  end;



TKADaoTable = class(TDataSet)
private
        F_Active        : Boolean;
        F_RecNo         : Integer;
        F_RecPos        : Integer;
        F_FilterBuffer  : PChar;
        F_BufferSize    : Integer;
        F_StartMyInfo   : Integer;
        F_StartCalc     : Integer;
        F_MDisabled     : Boolean;
        F_KeyFields     : TStringList;

        Function        GetActiveRecordBuffer:  PChar;
        Function        FilterRecord(Buffer: PChar): Boolean;
        Function        AddLeadingZeros(Value:String):String;
protected
        F_Database               : TKADaoDatabase;
        F_ReadOnly               : Boolean;
        {$IFDEF DYNADAO} //****************************************************
        F_DaoTable               : OleVariant;
        {$ELSE}
        F_DaoTable               : Recordset;
        {$ENDIF}
        F_SQL                    : TStrings;
        F_SortedBy               : TStrings;
        F_FieldNames             : TStrings;
        F_FieldTypeNames         : TStrings;
        F_DefaultValues          : TStrings;
        F_MDFieldNames           : TStrings;

        F_QD_ParamNames          : TStrings;
        F_QD_ParamDaoTypes       : TStrings;
        F_QD_ParamBDETypes       : TStrings;
        F_QueryDefMaxRecords     : Integer;
        F_QueryDefType           : String;

        F_MasterLink             : TKADAODataLink;
        F_MasterFields           : TStrings;

        F_Detail                 : TStrings;
        F_Master                 : TStrings;

        F_UseRecordCount         : Boolean;
        F_Filtered               : Boolean;
        F_Filter                 : String;
        F_OnFilterRecord         : TFilterRecordEvent;

        F_TableName              : String;
        F_QueryDefName           : String;
        F_QueryDefParameters     : TStrings;
        F_QueryDefSQLText        : TStrings;
        F_IndexName              : String;
        F_TableType              : Integer;
        F_LockType               : Integer;
        F_OpenOptions            : TOOSet;
        F_RecordSize             : Integer;

        F_DateCreated            : String;
        F_LastUpdated            : String;
        F_OLE_ON                 : Boolean;

        Function        F_Get_Database:TKADaoDatabase;
        Procedure       F_Set_Database(Value:TKADaoDatabase);
        Function        F_Get_TableName:String;
        Procedure       F_Set_TableName(Value:String);
        Function        F_Get_DateCreated:String;
        Function        F_Get_LastUpdated:String;

        Function        F_Get_IndexName:String;
        Procedure       F_Set_IndexName(Value:String);
        Procedure       F_Set_TableType(Value:Integer);
        Procedure       F_Set_LockType(Value:Integer);
        Procedure       F_Set_OpenOptions(Value:TOOSet);
        Procedure       F_Set_ReadOnly(Value:Boolean);
        Procedure       F_Set_Sort(Value:TStrings);

        Procedure       F_Set_SQL(Value:TStrings);
        Procedure       F_Set_QueryDefName(Value:String);
        Procedure       F_Set_QueryDefParameters(Value:TStrings);
        Procedure       F_Set_QueryDefSQLText(Value:TStrings);
        Function        F_Get_QueryDefType:String;

        Procedure       F_Set_UseRecordCount(Value: Boolean);

        Function        F_Get_MasterSource: TDataSource;
        Procedure       F_Set_MasterSource(Value: TDataSource);
        Procedure       F_ProcessMasterFields(Value:TStrings);
        Procedure       F_Set_MasterFields(Value:TStrings);

        Procedure       F_Set_Master(Value:TStrings);
        Procedure       F_Set_Detail(Value:TStrings);
        Function        F_ComposeSQL(SQL:TStrings):String;

        Procedure       F_Set_Filtered(Value:Boolean);
        Procedure       F_Set_Filter(Value:String);
        Procedure       F_Set_OnFilterRecord(Value: TFilterRecordEvent);

        Function        InternalCalcRecordSize:Integer;
        Function        IntegerToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        FloatToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        DateToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        TimeToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        DateTimeToBuffer(Buffer: Pointer; S: String): Boolean;
        Function        BooleanToBuffer(Buffer: Pointer; S: String): Boolean;

        Function        BufferToDate(Buffer: Pointer): String;
        Function        BufferToTime(Buffer: Pointer): String;
        Function        BufferToDateTime(Buffer: Pointer): String;

        Procedure       OpenDaoRecordset;
        Procedure       GetQueryDefReturnParams(QueryDefName:String);
        Procedure       CloseDaoRecordset;

        Procedure       InternalOpen; override;
        Procedure       InternalClose; override;
        Function        IsCursorOpen: Boolean; override;
        Function        GetCanModify: Boolean; override;
        Function        GetRecordSize: Word;override;
        Function        AllocRecordBuffer: PChar; override;
        Procedure       FreeRecordBuffer(var Buffer: PChar); override;
        Procedure       InternalFirst;override;
        Procedure       InternalLast;override;
        Procedure       InternalInitFieldDefs; override;
        Procedure       InternalInitRecord(Buffer: PChar); override;
        Procedure       SetFieldData(Field: TField; Buffer: Pointer);override;
        Procedure       ClearDBCalcFields(Buffer: PChar);

        Procedure       InternalEdit; override;
        Procedure       InternalAddRecord(Buffer: Pointer; Append: Boolean); override;
        Procedure       InternalPost; override;
        Procedure       InternalDelete; override;
        Function        GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult; override;
        Procedure       InternalSetToRecord(Buffer: PChar); override;
        Procedure       InternalRefresh; override;

        Function        GetDaoBookMark(RS:Variant):Integer;
        Procedure       SetDaoBookMark(Var RS:Variant;BookMark:Integer);
        Procedure       InternalGotoBookmark(Bookmark: Pointer); override;

        Function        GetBookmarkFlag(Buffer: PChar): TBookmarkFlag; override;
        Procedure       SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag); override;

        Function        GetBookmarkStr: TBookmarkStr; override;
        Procedure       SetBookmarkStr(const Value: TBookmarkStr); override;

        Procedure       GetBookmarkData(Buffer: PChar; Data: Pointer); override;
        Procedure       SetBookmarkData(Buffer: PChar; Data: Pointer); override;

        Procedure       InternalHandleException; override;
        Procedure       DataEvent(Event: TDataEvent; Info: Longint); override;

        Function        GetRecordCount  : Integer; override;
        Function        GetRecNo        : Integer; override;

        Procedure       StringToList(Items: String; List: TStringList);
        Procedure       VariantToList(Items: Variant; List: TStringList);
        Procedure       AssignVarValue(Var V :Variant;const Value: TVarRec);
        Function        BuildKeySQL(KN,KV:TStringList):String;
        Function        BuildLocateSQL(KN,KV:TStringList;Options: TLocateOptions):String;
        Function        Find(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions;FindType:Integer): Boolean;

        Function        InsertSQLString(MDString: String): String;
        Function        BuildDetailSQL  : String;
        Procedure       MasterDSChanged;

        Procedure       Notification(AComponent: TComponent; Operation: TOperation); override;
  public
        MainDatabaseShutdown             : Boolean;
        QueryDefTypeInt                  : Integer;
        QueryDefReturnParams             : OleVariant;
        RecordsAffected                  : Integer;

        BlobOffset                       : Integer;
        BlobNumBytes                     : Integer;

        {$IFDEF DYNADAO}
        CoreRecordset                    : OleVariant;
        {$ELSE}
        CoreRecordset                    : Recordset;
        {$ENDIF}
        
        Function                           GetFieldData(Field: TField; Buffer: Pointer): Boolean; override;
        Function                           CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream; override;
        Function                           AppendToBlob(Field: TField; Data:String):Boolean;

        Procedure                          SetKeyFields(const KeyFields: string);
        Function                           Find_First(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Last(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Next(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_Prior(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
        Function                           Find_NearestEx(const KeyFields: string; const KeyValues: Variant):Boolean;
        Function                           Find_Nearest(const KeyValues: array of const):Boolean;
        Function                           Seek_Nearest(const KeyValues: array of const):Boolean;
        Function                           Seek_NearestEx(const KeyValues: array of const; SeekType:String):Boolean;

        Function                           Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean; override;
        Function                           Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant; override;

        Function                           CreateField(FieldName:String;FieldType:Integer;FiledSize:Integer):Boolean;
        Function                           CreateIndex(FieldName:String;IndexType:Integer):Boolean;
        Function                           DeleteField(FieldName:String):Boolean;
        Function                           DeleteIndex(FieldName:String):Boolean;

        Function                           CompareBookmarks(Bookmark1, Bookmark2: TBookmark): Integer; override;
        Property  MasterLink             : TKADAODataLink read F_MasterLink;
        Property  FieldNames             : TStrings Read F_FieldNames;
        Property  LinkableFields         : TStrings Read F_MDFieldNames;
        Function                           ExecSQL(SQL:TStringList):Integer;
        Function                           Requery : Boolean;

        Procedure                          GetIndexNames(List: TStrings);
        Procedure                          GetFieldNames(List: TStrings);
        Function                           GetLastDaoError:TDaoErrRec;
        Function                           PropertyExists(PropObject:OleVariant;PropertyName:String):Boolean;
        Constructor                        Create(AOwner: TComponent); override;
        Destructor                         Destroy; override;
  published
        Property Database                : TKADaoDatabase Read F_Get_Database Write F_Set_Database;
        Property TableName               : String Read F_Get_TableName Write F_Set_TableName;
        Property SortedBy                : TStrings Read F_SortedBy Write F_Set_Sort;
        Property SortedByText            : TStrings Read F_SortedBy Write F_Set_Sort;
        Property QueryDefName            : String Read F_QueryDefName Write F_Set_QueryDefName;
        Property QueryDefParameters      : TStrings Read F_QueryDefParameters Write F_Set_QueryDefParameters;
        Property QueryDefParametersText  : TStrings Read F_QueryDefParameters Write F_Set_QueryDefParameters;
        Property QueryDefSQLText         : TStrings Read F_QueryDefSQLText Write F_Set_QueryDefSQLText;
        Property QueryDefODBCMaxRecords  : Integer Read F_QueryDefMaxRecords Write F_QueryDefMaxRecords;
        Property QueryDefType            : String Read F_Get_QueryDefType Write F_QueryDefType;
        Property SQL                     : TStrings Read F_SQL Write F_Set_SQL;
        Property TableType               : Integer Read F_TableType Write F_Set_TableType;
        Property TableDateCreated        : String Read F_Get_DateCreated Write F_DateCreated;
        Property TableLastUpdated        : String Read F_Get_LastUpdated Write F_LastUpdated;
        Property LockType                : Integer Read F_LockType Write F_Set_LockType;
        Property OpenOptions             : TOOSet Read F_OpenOptions Write F_Set_OpenOptions;
        Property IndexName               : String Read F_Get_IndexName Write F_Set_IndexName;
        Property ReadOnly                : Boolean Read F_ReadOnly Write F_Set_ReadOnly;
        Property MasterSource            : TDataSource Read F_Get_MasterSource Write F_Set_MasterSource;
        Property MasterFields            : TStrings Read F_MasterFields Write F_Set_MasterFields;
        Property UseRecordCount          : Boolean Read F_UseRecordCount Write F_Set_UseRecordCount;
        Property Filtered                : Boolean Read F_Filtered Write F_Set_Filtered;
        Property Filter                  : String Read F_Filter Write F_Set_Filter;
        Property OnFilterRecord          : TFilterRecordEvent read F_OnFilterRecord write F_Set_OnFilterRecord;
        Property BeforeOpen;
        Property AfterOpen;
        Property BeforeClose;
        Property AfterClose;
        Property BeforeInsert;
        Property AfterInsert;
        Property BeforeEdit;
        Property AfterEdit;
        Property BeforePost;
        Property AfterPost;
        Property BeforeCancel;
        Property AfterCancel;
        Property BeforeDelete;
        Property AfterDelete;
        Property BeforeScroll;
        Property AfterScroll;
        Property OnCalcFields;
        Property OnDeleteError;
        Property OnEditError;
        Property OnNewRecord;
        Property OnPostError;
        Property Active;
end;

// Handle Memo fields
  TKBlobStream = class(TStream)
  private
    F_Field      : TBlobField;
    F_DataSet    : TKADaoTable;
    F_Buffer     : PChar;
    F_Mode       : TBlobStreamMode;
    F_Opened     : Boolean;
    F_Modified   : Boolean;
    F_Position   : Longint;
    F_BlobData   : TBlobData;
    F_BlobSize   : Integer;
  public
    constructor Create(Field: TBlobField; Mode: TBlobStreamMode);
    destructor Destroy; override;
    function Read(var Buffer; Count: Longint): Longint; override;
    function Write(const Buffer; Count: Longint): Longint; override;
    function Seek(Offset: Longint; Origin: Word): Longint; override;
    procedure Truncate;
  end;



Procedure Register;

implementation
Uses DaoUtils,Dialogs,SortByDialog,QueryDefDialogUnit,MasterDetailFormUnit;

Const
  CRLF=#13+#10;

  //****************************************************************************
constructor TKADaoTable.Create(AOwner: TComponent);
Var
  OLE_INIT:Integer;
begin
  inherited Create(AOwner);
  F_TableName            := '';
  F_TableType            := dbOpenDynaset;
  F_LockType             := dbOptimistic;
  F_OpenOptions          := [dbInconsistent];
  F_ReadOnly             := False;
  F_UseRecordCount       := True;
  MainDatabaseShutdown   := False;
  F_QueryDefName         := '';
  F_QueryDefSQLText      := TStringList.Create;
  F_QueryDefSQLText.Clear;
  F_QueryDefMaxRecords   := 0;
  F_QueryDefType         := '';
  QueryDefTypeInt        := 0;
  RecordsAffected        := 0;
  F_SQL                  := TStringList.Create;
  F_SQL.Clear;
  F_SortedBy             := TStringList.Create;
  F_SortedBy.Clear;
  F_FieldNames           := TStringList.Create;
  F_FieldNames.Clear;
  F_FieldTypeNames       := TStringList.Create;
  F_FieldTypeNames.Clear;
  F_DefaultValues        := TStringList.Create;
  F_DefaultValues.Clear;
  F_MDFieldNames         := TStringList.Create;
  F_MDFieldNames.Clear;
  F_DateCreated          := '';
  F_LastUpdated          := '';
  //****************************************************************************
  F_QD_ParamNames        := TStringList.Create;
  F_QD_ParamNames.Clear;
  F_QD_ParamDaoTypes     := TStringList.Create;
  F_QD_ParamDaoTypes.Clear;
  F_QD_ParamBDETypes     := TStringList.Create;
  F_QD_ParamBDETypes.Clear;

  F_QueryDefParameters   := TStringList.Create;
  F_QueryDefParameters.Clear;
  //************************************************************
  F_MDisabled        := False;
  F_MasterFields         := TStringList.Create;
  F_MasterFields.Clear;
  F_MasterLink           := TKADAODataLink.Create(Self);
  F_Detail               := TStringList.Create;
  F_Detail.Clear;
  F_Master               := TStringList.Create;
  F_Master.Clear;
  F_KeyFields            := TStringList.Create;
  F_KeyFields.Clear;
  //************************************************************
  BlobOffset             := 0;
  BlobNumBytes           := 0;
  //************************************************************
  F_Database             := Nil;

  F_OLE_ON:=False;
  OLE_INIT:= CoInitialize(NIL);
  if (OLE_INIT = S_OK) or (OLE_INIT = S_FALSE) then F_OLE_ON:= True
  else DatabaseError('Unable to init OLE objects!');
end;

destructor TKADaoTable.Destroy;
begin
  if F_Active Then
      Begin
        InternalClose;
        F_Active:=False;
      End;
  F_SQL.Free;
  F_SortedBy.Free;
  F_FieldNames.Free;
  F_FieldTypeNames.Free;
  F_DefaultValues.Free;
  F_MDFieldNames.Free;
  F_QueryDefParameters.Free;
  F_QueryDefSQLText.Free;
  F_QD_ParamNames.Free;
  F_QD_ParamDaoTypes.Free;
  F_QD_ParamBDETypes.Free;
  F_MasterLink.Free;
  F_MasterFields.Free;
  F_Detail.Free;
  F_Master.Free;
  F_KeyFields.Free;
  {$IFDEF DYNADAO}
  F_DaoTable  := NULL;
  {$ELSE}
  F_DaoTable  := Nil;
  {$ENDIF}
  if F_OLE_ON then CoUninitialize;
  inherited Destroy;
end;

Function TKADaoTable.ExecSQL(SQL:TStringList):Integer;
Begin
 Result:=0;
 RecordsAffected:=Result;
 if Assigned(F_Database) Then
    Begin
      F_Database.CoreDatabase.Execute(F_ComposeSQL(SQL),dbFailOnError);
      Result:=F_Database.CoreDatabase.RecordsAffected;
      RecordsAffected:=Result;
    End
 Else
    DatabaseError('TKADaoTable.ExecSQL: Cannot execute SQL query while Database is not assigned!');
End;

Function  TKADaoTable.Requery : Boolean;
Begin
  Result:=False;
  If Not F_Active Then Exit;
  if Not F_DaoTable.Restartable Then Exit;
  ClearBuffers;
  CheckBrowseMode;
  OleVariant(F_DaoTable).Requery;
  ActivateBuffers;
  First;
  Result:=True;
End;

Procedure TKADaoTable.GetIndexNames(List: TStrings);
Var
 Count,X : Integer;
Begin
  List.Clear;
  if Assigned(F_Database) Then
     Begin
      F_Database.RefreshDefinitions;
      Count :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Count;
      For X := 0 to  Count-1 do
          Begin
            List.Add(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Indexes.Item[X].Name);
          End;
     End;
End;

Procedure TKADaoTable.GetFieldNames(List: TStrings);
Var
 Count, X, FT  : Integer;
Begin
  List.Clear;
  if Assigned(F_Database) Then
     Begin
      F_Database.RefreshDefinitions;
      Count :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Count;
      For X := 0 to  Count-1 do
          Begin
            {$IFDEF DYNADAO}
            FT :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Item[X].Type;
            {$ELSE}
            FT :=F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Item[X].Type_;
            {$ENDIF}
            List.AddObject(F_Database.CoreDatabase.TableDefs.Item[F_TableName].Fields.Item[X].Name,TObject(FT));
          End;
     End;
End;

Function  TKADaoTable.GetLastDaoError:TDaoErrRec;
Begin
  Result := F_Database.GetLastDaoError;
End;

Function TKADaoTable.PropertyExists(PropObject:OleVariant;PropertyName:String):Boolean;
Var
  X : Integer;
Begin
  Result := False;
  For X := 0 to PropObject.Count-1 do
      Begin
        if AnsiCompareText(PropObject.Item[X].Name,PropertyName)=0 Then Result := True;
      End;
End;

Function TKADaoTable.F_Get_Database:TKADaoDatabase;
Begin
 if NOT Assigned(F_Database) Then F_Database:=Nil;
 Result:=F_Database;
End;

Procedure TKADaoTable.F_Set_Database(Value:TKADaoDatabase);
Begin
  if Active Then DatabaseError('TKADaoTable.F_Set_Database: Cannot set Database while table is Active!');
  {
  if Value <> Nil Then
     Begin
      F_IndexName:='';
      F_TableName:='';
      F_SQL.Clear;
      F_QueryDefName:='';
      F_QueryDefParameters.Clear;
      F_SortedBy.Clear;
      F_Master.Clear;
      F_Detail.Clear;
      F_MasterFields.Clear;
      F_MasterLink.DataSource:=Nil;
     End;
   }
 F_Database:=Value;
End;

Function TKADaoTable.F_Get_DateCreated:String;
Begin
 Result := '';
 if F_Active Then
    Begin
      if TableType=dbOpenTable Then Result:=F_DaoTable.DateCreated;
      if F_QueryDefName <> '' then Result:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].DateCreated;
    End;
End;

Function TKADaoTable.F_Get_LastUpdated:String;
Begin
 Result := '';
 if F_Active Then
    Begin
      if TableType=dbOpenTable Then Result:=F_DaoTable.LastUpdated;
      if F_QueryDefName <> '' then Result:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].LastUpdated;
    End;
End;

Function TKADaoTable.F_Get_TableName:String;
Begin
 Result:= F_TableName;
End;

Procedure TKADaoTable.F_Set_TableName(Value:String);
Begin
  if Active Then DatabaseError('Cannot set TableName while Table is active!');
  F_TableName:=Value;
  if Value <> '' Then
     Begin
      F_IndexName:='';
      F_SQL.Clear;
      F_QueryDefName:='';
      F_QueryDefParameters.Clear;
      F_SortedBy.Clear;
     End;
End;

Procedure TKADaoTable.F_Set_SQL(Value:TStrings);
Begin
 F_SQL.SetText(Value.GetText);
 if Length(Value.GetText) > 0 Then
    Begin
     F_QueryDefParameters.Clear;
     F_QueryDefName:='';
     F_IndexName:='';;
     F_TableName:='';
    End;                      
End;

Procedure TKADaoTable.F_Set_QueryDefName(Value:String);
Begin
  Try
    if Assigned(F_Database) And (F_Database.Connected) Then
       Begin
         F_QueryDefSQLText.Clear;
         if Value <> '' Then F_QueryDefSQLText.SetText(PChar(F_Database.GetQueryDefSQLText(Value)));
       End;
  Except
  End;
  F_QueryDefName:=Value;
  F_QueryDefType:=F_Get_QueryDefType;
  if Value <> '' Then
     Begin
      F_IndexName:='';
      F_TableName:='';
      F_SQL.Clear;
      F_QueryDefParameters.Clear;
      F_Master.Clear;
      F_Detail.Clear;
      F_MasterFields.Clear;
      MasterLink.DataSource:=Nil;
     End;
End;



Function TKADaoTable.F_Get_IndexName:String;
Begin
 Result:= F_IndexName;
End;

Procedure TKADaoTable.F_Set_IndexName(Value:String);
Begin
  if Active Then
     Begin
       if (TableType=dbOpenTable) And (Value <> '') Then
          Begin
             F_SortedBy.Clear;
             F_DaoTable.Index:=Value;
             ClearBuffers;
             CheckBrowseMode;
             ActivateBuffers;
             First;
          End
       Else if Value <> '' Then DatabaseError('Indexes can be set only on Standard Tables!');
     End
   Else
     Begin
       if (TableType=dbOpenTable) And (Value <> '') Then
          Begin
            F_SortedBy.Clear;
          End
       Else if Value <> '' Then DatabaseError('Indexes can be set only on Standard Tables!');
     End;
  F_IndexName:=Value;
End;

Procedure TKADaoTable.F_Set_TableType(Value:Integer);
Begin
  if Active Then DatabaseError('Cannot set TableType while Table is active!');
  F_TableType:=Value;
End;

Procedure TKADaoTable.F_Set_LockType(Value:Integer);
Begin
  if Active Then DatabaseError('Cannot set LockType while Table is active!');
  F_LockType:=Value;
End;

Procedure TKADaoTable.F_Set_OpenOptions(Value:TOOSet);
Begin
  if Active Then DatabaseError('Cannot set OpenOptions while Table is active!');
  F_OpenOptions:=Value;
End;

Procedure TKADaoTable.F_Set_ReadOnly(Value:Boolean);
Begin
  if Active Then DatabaseError('TKADaoTable.F_Set_ReadOnly: Cannot set ReadOnly while table is Active!');
  F_ReadOnly:=Value;
End;

Procedure TKADaoTable.F_Set_Sort(Value:TStrings);
Begin
 F_SortedBy.SetText(Value.GetText);
 F_IndexName:='';
End;

Procedure TKADaoTable.F_Set_QueryDefParameters(Value:TStrings);
Begin
 F_QueryDefParameters.SetText(Value.GetText);
End;

Procedure TKADaoTable.F_Set_QueryDefSQLText(Value:TStrings);
Begin
//*************************** READ ONLY
End;

Function TKADaoTable.F_Get_QueryDefType:String;
Var
 QDType : Integer;
Begin
 Result:='';
 QueryDefTypeInt:=0;
 if Assigned(F_Database) And (F_Database.Connected) And (F_QueryDefName <> '') Then
    Begin
      {$IFDEF DYNADAO}
      QDType:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].Type;
      {$ELSE}
      QDType:=Database.CoreDatabase.QueryDefs.Item[F_QueryDefName].Type_;
      {$ENDIF}
      if QDType=dbQSelect         Then Begin Result := 'dbQSelect'        ; QueryDefTypeInt := dbQSelect         ; End;
      if QDType=dbQProcedure      Then Begin Result := 'dbQProcedure'     ; QueryDefTypeInt := dbQProcedure      ; End;
      if QDType=dbQAction         Then Begin Result := 'dbQAction'        ; QueryDefTypeInt := dbQAction         ; End;
      if QDType=dbQCrosstab       Then Begin Result := 'dbQCrosstab'      ; QueryDefTypeInt := dbQCrosstab       ; End;
      if QDType=dbQDelete         Then Begin Result := 'dbQDelete'        ; QueryDefTypeInt := dbQDelete         ; End;
      if QDType=dbQUpdate         Then Begin Result := 'dbQUpdate'        ; QueryDefTypeInt := dbQUpdate         ; End;
      if QDType=dbQAppend         Then Begin Result := 'dbQAppend'        ; QueryDefTypeInt := dbQAppend         ; End;
      if QDType=dbQMakeTable      Then Begin Result := 'dbQMakeTable'     ; QueryDefTypeInt := dbQMakeTable      ; End;
      if QDType=dbQDDL            Then Begin Result := 'dbQDDL'           ; QueryDefTypeInt := dbQDDL            ; End;
      if QDType=dbQSQLPassThrough Then Begin Result := 'dbQSQLPassThrough'; QueryDefTypeInt := dbQSQLPassThrough ; End;
      if QDType=dbQSetOperation   Then Begin Result := 'dbQSetOperation'  ; QueryDefTypeInt := dbQSetOperation   ; End;
      if QDType=dbQSPTBulk        Then Begin Result := 'dbQSPTBulk'       ; QueryDefTypeInt := dbQSPTBulk        ; End;
      if QDType=dbQCompound       Then Begin Result := 'dbQCompound'      ; QueryDefTypeInt := dbQCompound       ; End;
    End;
End;

Procedure TKADaoTable.F_Set_UseRecordCount(Value: Boolean);
Begin
 F_UseRecordCount := Value;
 if (F_Active) And (State=dsBrowse) Then InternalRefresh;
End;

Function  TKADaoTable.F_Get_MasterSource : TDataSource;
Begin
 Result:= F_MasterLink.DataSource;
End;

Procedure TKADaoTable.F_Set_MasterSource(Value: TDataSource);
Begin
 F_MasterLink.DataSource:= Value;
End;

Procedure TKADaoTable.F_ProcessMasterFields(Value:TStrings);
Var
  X,I:Integer;
  S,MasterField,DetailField:String;
Begin
  F_Detail.Clear;
  F_Master.Clear;
  if (Value.Count=1) And (Pos(';',Value.Strings[0]) > 0) Then
     Begin
       S := Value.Strings[0]; 
       Repeat
        I := Pos(';',S);
        if I > 0 Then
           Begin
            DetailField:=Copy(S,1,I-1);
            System.Delete(S,1,I);
           End
        Else
           Begin
            DetailField:=S;
           End;
        if Length(DetailField) > 0 Then
           Begin
            MasterField:=DetailField;
            F_Detail.Add(DetailField);
            F_Master.Add(MasterField);
           End;
       Until I = 0;
     End
  Else
  For X:=0 to Value.Count-1 do
      Begin
        S := Value.Strings[X];
        I := Pos(' -> ',S);
        if I > 0 Then
        Begin
         DetailField:=Copy(S,1,I-1);
         System.Delete(S,1,I+Length(' -> ')-1);
         MasterField:=S;
         F_Detail.Add(DetailField);
         F_Master.Add(MasterField);
        End;
      End;
End;

Procedure TKADaoTable.F_Set_MasterFields(Value:TStrings);

Begin
 F_ProcessMasterFields(Value);
 F_MasterFields.SetText(Value.GetText);
End;

Procedure TKADaoTable.F_Set_Master(Value:TStrings);
Begin
 F_Master.SetText(Value.GetText);
End;

Procedure TKADaoTable.F_Set_Detail(Value:TStrings);
Begin
 F_Detail.SetText(Value.GetText);
End;

Function TKADaoTable.F_ComposeSQL(SQL:TStrings):String;
Var
 X  : Integer;
Begin
 Result:='';
 For X:=0 To SQL.Count-1 do
     Begin
       Result := Result+SQL.Strings[X];
       if X <  SQL.Count-1 Then Result := Result+' ';
     End;
End;

Procedure TKADaoTable.F_Set_Filtered(Value:Boolean);
Begin
  F_Filtered:=Value;
  if F_Active Then
     Begin
       ClearBuffers;
       CheckBrowseMode;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
  Inherited Filtered:=Value;
End;

Procedure TKADaoTable.F_Set_Filter(Value:String);
Begin
  F_Filter:=Value;
  if (F_Active) And (F_Filtered) Then
     Begin
       ClearBuffers;
       CheckBrowseMode;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
  Inherited Filter:=Value;
End;

Procedure TKADaoTable.F_Set_OnFilterRecord(Value: TFilterRecordEvent);
Begin
  F_OnFilterRecord:=Value;
  if (F_Active) And (F_Filtered) Then
     Begin
       ClearBuffers;
       CheckBrowseMode;
       CloseDaoRecordset;
       OpenDaoRecordset;
       ActivateBuffers;
       First;
     End;
  Inherited OnFilterRecord:=Value;
End;
//******************************************************************************

Function TKADaoTable.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
Begin
  Result:=TKBlobStream.Create(Field As TBlobField,Mode);
End;

Function TKADaoTable.AppendToBlob(Field: TField; Data:String):Boolean;
Var
 S : String;
Begin
 Result := False;
 If (Not F_Active)
 or (F_ReadOnly)
 or (F_Database.ReadOnly)
 Then Exit;

 F_DaoTable.Edit;
 S:=F_DaoTable.Fields.Item[Field.FieldNo-1].GetChunk(0,F_DaoTable.Fields.Item[Field.FieldNo-1].FieldSize);
 F_DaoTable.Fields.Item[Field.FieldNo-1].AppendChunk(S);
 F_DaoTable.Fields.Item[Field.FieldNo-1].AppendChunk(Data);
 OleVariant(F_DaoTable).Update;
 Result := True;
End;

Function TKADaoTable.InternalCalcRecordSize:Integer;
Begin
 F_RecordSize:=0;
 Result:=F_RecordSize;
End;


Procedure TKADaoTable.GetQueryDefReturnParams(QueryDefName:String);
Var
  X, Dir, NRP : Integer;
Begin
  if NOT VarIsNull(QueryDefReturnParams) Then QueryDefReturnParams:=NULL;
  NRP:=0;
  For X:=0 To F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
      Begin
        Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
        if (Dir=dbParamOutput) Or (Dir=dbParamInputOutput) Or (Dir=dbParamReturnValue) Then Inc(NRP);
      End;
  if NRP=0 Then Exit;
  if NRP=1 Then
     Begin
       QueryDefReturnParams:=F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[0].Name+'='+F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[0].Value;
     End
  Else
     Begin
       QueryDefReturnParams:=VarArrayCreate([0, NRP],varVariant);
       For X:=0 To F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters.Count-1 do
           Begin
             Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
             if (Dir=dbParamOutput) Or (Dir=dbParamInputOutput) Or (Dir=dbParamReturnValue) Then
                QueryDefReturnParams[X]:=F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Name+'='+F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Value;
      End;
     End;
End;

Procedure TKADaoTable.OpenDaoRecordset;
Var
 X         : Integer;
 TabType   : Integer;
 LoType    : Integer;
 Options   : Integer;
 {$IFDEF DYNADAO}
 TempRS    : OleVariant;
 {$ELSE}
 TempRS    : Recordset;
 {$ENDIF}
 TabN      : String;
 TempSort  : String;
 NRP, Dir  : Integer;
begin
        if Not Assigned(F_Database) Then DatabaseError('TKADaoTable.OpenDaoRecordset: Missing Database');
        if (TableName='') And
           (SQL.Count=0)  And
           (QueryDefName='')
        Then DatabaseError('TKADaoTable.OpenDaoRecordset: Missing TableName or QueryDefName or SQL is empty!');
        if F_Database.Connected= False Then DatabaseError('TKADaoTable.OpenDaoRecordset: Database is NOT connected');
        TabType:=F_TableType;
        LoType:=F_LockType;
        Options:=0;

        if dbDenyWrite      in F_OpenOptions Then Options:=Options + DAOApi.dbDenyWrite;
        if dbDenyRead       in F_OpenOptions Then Options:=Options + DAOApi.dbDenyRead;
        if dbReadOnly       in F_OpenOptions Then Options:=Options + DAOApi.dbReadOnly;
        if dbAppendOnly     in F_OpenOptions Then Options:=Options + DAOApi.dbAppendOnly;
        if dbInconsistent   in F_OpenOptions Then Options:=Options + DAOApi.dbInconsistent;
        if dbConsistent     in F_OpenOptions Then Options:=Options + DAOApi.dbConsistent;
        if dbSQLPassThrough in F_OpenOptions Then Options:=Options + DAOApi.dbSQLPassThrough;
        if dbFailOnError    in F_OpenOptions Then Options:=Options + DAOApi.dbFailOnError;
        if dbForwardOnly    in F_OpenOptions Then Options:=Options + DAOApi.dbForwardOnly;
        if dbSeeChanges     in F_OpenOptions Then Options:=Options + DAOApi.dbSeeChanges;
        if dbRunAsync       in F_OpenOptions Then Options:=Options + DAOApi.dbRunAsync;
        if dbExecDirect     in F_OpenOptions Then Options:=Options + DAOApi.dbExecDirect;

        TabN:=TableName;
        if F_SQL.Count > 0 Then TabN:=F_ComposeSQL(F_SQL);
        if F_QueryDefName <> '' Then
           Begin
             TabN:=F_QueryDefName;
             NRP:=0;
             For X:=0 To Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count-1 do
                 Begin
                   Dir := F_Database.CoreDatabase.QueryDefs.Item[QueryDefName].Parameters[X].Direction;
                   if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
                       Begin
                        Try
                         Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Item[X].Value:=F_QueryDefParameters.Strings[NRP];
                         Inc(NRP);
                        Except
                         DatabaseError('Invalid number of QueryDef parameters or parameter is not in valid format!');
                        End;
                       End;
                 End;
           End;
        if (F_QueryDefName <> '') And (Database.CoreDatabase.QueryDefs.Item[TabN].Parameters.Count > 0) Then
            Begin
                F_QueryDefSQLText.Clear;
                if Assigned(F_Database) And (F_Database.Connected) Then
                   F_QueryDefSQLText.SetText(PChar(F_Database.GetQueryDefSQLText(TabN)));
                Database.CoreDatabase.QueryDefs.Item[TabN].MaxRecords:=F_QueryDefMaxRecords;
                F_DaoTable:=Database.CoreDatabase.QueryDefs.Item[TabN].OpenRecordset(TabType,Options,LoType);
                GetQueryDefReturnParams(TabN);
            End
        Else
            Begin
               F_QueryDefSQLText.Clear;
               if (F_QueryDefName <> '') Then
                   Begin
                     F_QueryDefSQLText.SetText(PChar(F_Database.GetQueryDefSQLText(TabN)));
                     Database.CoreDatabase.QueryDefs.Item[TabN].MaxRecords:=F_QueryDefMaxRecords;
                     F_DaoTable:=Database.CoreDatabase.QueryDefs.Item[TabN].OpenRecordset(TabType,Options,LoType);
                   End
               Else
                   Begin
                     F_DaoTable:=Database.CoreDatabase.OpenRecordset(TabN,TabType,Options,LoType);
                   End;
            End;


        F_DefaultValues.Clear;
        For X:=0 To F_DaoTable.Fields.Count-1 do
            Begin
              F_DefaultValues.Add(F_DaoTable.Fields.Item[X].DefaultValue);
            End;

        if F_IndexName <> '' Then F_DaoTable.Index:=F_IndexName
        Else
        if F_SortedBy.Count > 0 Then
           Begin
             TempSort:='';
             For X:=0 To F_SortedBy.Count-1 Do
                Begin
                  TempSort:=TempSort+F_SortedBy.Strings[X];
                  if X < F_SortedBy.Count-1 Then TempSort:=TempSort+',';
                  TempSort:=TempSort+' ';
                End;
             F_DaoTable.Sort:=TempSort;
             TempRS:=F_DaoTable;
             F_DaoTable:=TempRS.OpenRecordset(TabType,Options);
             TempRS.Close;
             {$IFDEF DYNADAO}
             TempRS:=NULL;
             {$ELSE}
             TempRS:=Nil;
             {$ENDIF}
           End;
        if Filtered Then
           Begin
             if Filter<>'' Then
                Begin
                 F_DaoTable.Filter:=Filter;
                 TempRS:=F_DaoTable;
                 F_DaoTable:=TempRS.OpenRecordset(TabType,Options);
                 TempRS.Close;
                 {$IFDEF DYNADAO}
                 TempRS:=NULL;
                 {$ELSE}
                 TempRS:=Nil;
                 {$ENDIF}
                End;
           End;
        if (MasterSource <> NIL) and (not(F_MDisabled)) then
            Begin
              F_ProcessMasterFields(F_MasterFields);
              if (F_Master.Count > 0) Then
                  Begin
                   TabN:=BuildDetailSQL;
                   TabN:=InsertSQLString(TabN);
                   F_DaoTable.Filter:=TabN;
                   TempRS:=F_DaoTable;
                   F_DaoTable:=TempRS.OpenRecordset(TabType,Options);
                   TempRS.Close;
                   {$IFDEF DYNADAO}
                   TempRS:=NULL;
                   {$ELSE}
                   TempRS:=Nil;
                   {$ENDIF}
                  End;
            End;
        CoreRecordset := F_DaoTable;    
End;


Procedure TKADaoTable.InternalOpen;
Var
   X       : Integer;
   TempMD  : Boolean;
Begin
        OpenDaoRecordset;
        if Self.Name='' Then Self.Name:='KADaoTable_'+IntToStr(GetTickCount);
        F_Database.ActiveTableNames.AddObject(Self.Name,Self);
        InternalInitFieldDefs;
        if DefaultFields then CreateFields;
        BindFields(True);
        F_RecNo:=-1;
        BookmarkSize:=MYBOOKMARKSIZE;
        F_StartMyInfo:=InternalCalcRecordSize;
        F_StartCalc:=F_StartMyInfo+SizeOf(TDaoInfo);
        F_BufferSize:=F_RecordSize+Sizeof(TDaoInfo)+CalcFieldsSize;
        //****************************************************************
        TempMD:=F_MDisabled;
        F_MDisabled:= True;
        F_FieldNames.Clear;
        F_MDFieldNames.Clear;
        For X:=0 to FieldDefs.Count-1 do
            Begin
             if NOT (Fields[X].IsBlob) Then
                Begin
                  F_FieldNames.Add(FieldDefs.Items[X].Name);
                  F_FieldTypeNames.Add(GetBDEFieldTypeNames(FieldDefs.Items[X].DataType));
                End;
             if NOT (Fields[X].DataType=ftBlob) Then
                Begin
                  F_MDFieldNames.Add(FieldDefs.Items[X].Name);
                End;
            End;
        F_MDisabled:=TempMD;
        F_Active:=True;
        InternalFirst;
        //****************************************************************
end;

Procedure TKADaoTable.CloseDaoRecordset;
Begin
 F_DaoTable.Close;
End;

Procedure TKADaoTable.InternalClose;
begin
        if Not F_Active Then Exit;
        BindFields(False);
        if DefaultFields then DestroyFields;
        CloseDaoRecordset;
        F_Active:=False;
        if NOT MainDatabaseShutdown Then
           F_Database.ActiveTableNames.Delete(F_Database.ActiveTableNames.IndexOf(Self.Name))
        Else
           MainDatabaseShutdown:=False;
end;

Procedure TKADaoTable.InternalFirst;
begin                                                 
  F_RecNo:=-1;
  F_RecPos:=-1;
  if F_DaoTable.RecordCount=0 Then Exit;
  if F_TableType = dbOpenForwardOnly Then Exit;
  Try
   F_DaoTable.MoveFirst;
   F_DaoTable.MovePrevious;
  Except
  End;
end;

Procedure TKADaoTable.InternalLast;
begin
     F_RecNo:=-1;
     if F_DaoTable.RecordCount=0 Then Exit;
     if F_TableType = dbOpenForwardOnly Then
        Begin
          While NOT F_DaoTable.EOF Do
              Begin
                F_DaoTable.MoveNext;
                Inc(F_RecPos);
                F_RecNo:=F_RecPos;
              End;
          Dec(F_RecPos);
          F_RecNo:=F_RecPos;
          Exit;
        End;
     Try
        OleVariant(F_DaoTable).MoveLast;
        F_DaoTable.MoveNext;
        F_RecNo:=F_DaoTable.RecordCount;
     Except
     End;
end;

Procedure TKADaoTable.InternalSetToRecord(Buffer: PChar);
Var
  RN     : Integer;
  Delta  : Integer;
begin
        if F_DaoTable.RecordCount=0 Then Exit;
        RN:=F_RecNo;
        F_RecNo:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordNo;
        if F_TableType = dbOpenForwardOnly Then Exit;
        Delta:=F_RecNo-RN;
        Try
           //***************************** A slowest method - disabled
           //***************************** F_DaoTable.MoveFirst;
           //***************************** OleVariant(F_DaoTable).Move(F_RecNo);
           If (F_Filtered) And (Assigned(F_OnFilterRecord)) Then
               Begin
                 F_DaoTable.MoveFirst;
                 OleVariant(F_DaoTable).Move(F_RecNo);
               End
           Else
               Begin
                 if Delta <> 0 Then
                    Begin
                      OleVariant(F_DaoTable).Move(Delta);
                    End;
               End;
        Except
          //***************************** HANDLE EXCEPTION WHEN A NEW RECORD IS ADDED OR RECORDSET IS EMPTY
        End;
end;

Procedure TKADaoTable.InternalRefresh;
begin
     Resync([rmExact, rmCenter]);
end;


//*********************************************************************************** BOOKMARK FUNCTIONS
procedure TKADaoTable.InternalGotoBookmark(Bookmark: Pointer);
Var
  TempBK  : Pointer;
  Delta   : Integer;
  Buffer  : PChar;
begin
  if (F_Active) And (F_DaoTable.Bookmarkable) Then
     Begin
      {$IFDEF DYNADAO}
      TempBK:=TVarData(F_DaoTable.Bookmark).VPointer;
      PInteger(PSafeArray(TempBK)^.pvData)^:=PInteger(Bookmark)^;
      {$ELSE}
      F_DaoTable.Bookmark.pvData := PInteger(Bookmark);
      TempBK:=Bookmark;
      {$ENDIF}
      Buffer:=GetActiveRecordBuffer;
      Delta:=PInteger(Bookmark)^-PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData;
      Try
        if Delta < 0 Then
           Begin
            Repeat
              Prior;
              if BOF Then Break;
              {$IFDEF DYNADAO}
              TempBK:=TVarData(F_DaoTable.Bookmark).VPointer;
              {$ELSE}
              TempBK:=F_DaoTable.Bookmark;
              {$ENDIF}
            Until PInteger(PSafeArray(TempBK)^.pvData)^=PInteger(Bookmark)^;
           End;
        if Delta > 0 Then
           Begin
            Repeat
              Next;
              if EOF Then Break;
              {$IFDEF DYNADAO}
              TempBK:=TVarData(F_DaoTable.Bookmark).VPointer;
              {$ELSE}
              TempBK:=F_DaoTable.Bookmark;
              {$ENDIF}
            Until PInteger(PSafeArray(TempBK)^.pvData)^=PInteger(Bookmark)^;
           End;
      Except
      End;
     End;
end;


Function TKADaoTable.GetBookmarkFlag(Buffer: PChar): TBookmarkFlag;
begin
  Result:=PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkFlag;
end;

procedure TKADaoTable.SetBookmarkFlag(Buffer: PChar; Value: TBookmarkFlag);
begin
  PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkFlag := Value;
end;


Function TKADaoTable.GetBookmarkStr: TBookmarkStr;
Var
 Buffer:PChar;
Begin
  Result := '';
  Try
    if F_DaoTable.Bookmarkable Then
       Begin
         Buffer:=GetActiveRecordBuffer;
         if (Buffer <> Nil) Then
         Result := StrPas(PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkString);
       End;
  Except
    Result := '';
  End;
End;

Procedure TKADaoTable.SetBookmarkStr(const Value: TBookmarkStr);
var
 PBI : Integer;
{$IFDEF DYNADAO}
 TempBK : Pointer;
{$ENDIF}
Begin
 if (F_DaoTable.Bookmarkable) And (Value <> '') Then
     Begin
      {$IFDEF DYNADAO}
        TempBK:=TVarData(F_DaoTable.Bookmark).VPointer;
        PInteger(PSafeArray(TempBK)^.pvData)^:=StrToInt(Value);
      {$ELSE}
        PInteger(F_DaoTable.Bookmark.pvData)^ := StrToInt(Value);
      {$ENDIF}
      //***************************************************** FOR FUTURE TESTING
      PBI:=StrToInt(Value);
      InternalGotoBookmark(@PBI);
      //************************************************************************
      InternalRefresh;
     End;
End;

procedure TKADaoTable.GetBookmarkData(Buffer: PChar; Data: Pointer);
begin
     PInteger(Data)^ := PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData;
end;

procedure TKADaoTable.SetBookmarkData(Buffer: PChar; Data: Pointer);
begin
     if Buffer <> nil then PDaoInfo(Buffer + F_StartMyInfo)^.BookmarkData := PInteger(Data)^;
end;

Function TKADaoTable.CompareBookmarks(Bookmark1, Bookmark2: TBookmark): Integer;
Function CompareBookmarkMemory(Buf1,Buf2:PChar;Count:Integer):Integer;
 Var X:integer;
 Begin
   Result := 0;
   for X := 0 to Count-1 do
    Begin
      if Buf1[X] < Buf2[X] then
       Begin
          Result := -1;
          Exit;
       End
      Else
      if Buf1[X] > Buf2[X] then       
       Begin
          Result := 1;
          Exit;                                                              
       End;
    End;
 End;
Const
  ResultCodes     : array[Boolean, Boolean] of ShortInt = ((2,-1),(1,0));
Begin
  Result := ResultCodes[Bookmark1 = nil, Bookmark2 = nil];
  If Result = 2 then
     Begin
      Result := CompareBookmarkMemory(Bookmark1, Bookmark2, BookmarkSize);
     End;
End;
//*********************************************************************************** BOOKMARK FUNCTIONS


Procedure TKADaoTable.InternalInitFieldDefs;
Var
  X        : Integer;
  Sz       : Integer;
  Typ      : Integer;
  F_Format : String;
begin
        FieldDefs.Clear;
        with FieldDefs do
        begin
          For X:=0 To F_DaoTable.Fields.Count-1 do
              Begin
                {$IFDEF DYNADAO}
                Sz:=DaoSizeToBDESize(F_DaoTable.Fields.Item[X].Type,F_DaoTable.Fields.Item[X].Size);
                Typ :=F_DaoTable.Fields.Item[X].Type;
                {$ELSE}
                Sz:=DaoSizeToBDESize(F_DaoTable.Fields.Item[X].Type_,F_DaoTable.Fields.Item[X].Size);
                Typ :=F_DaoTable.Fields.Item[X].Type_;
                {$ENDIF}
                if (Typ=dbDate) And (PropertyExists(OleVariant(F_DaoTable.Fields.Item[X].Properties),'Format')) Then
                   Begin
                     F_Format:=F_DaoTable.Fields.Item[X].Properties.Item['Format'].Value;
                     if AnsiCompareText(F_Format,'Long Time')=0    Then Typ:=dbTimeStamp;
                     if AnsiCompareText(F_Format,'Medium Time')=0  Then Typ:=dbTimeStamp;
                     if AnsiCompareText(F_Format,'Short Time')=0   Then Typ:=dbTime;
                   End
                Else
                   if (Typ=dbDate) Then Typ:=dbTimeStamp; 
                Add(F_DaoTable.Fields.Item[X].Name,DaoToBDE(Typ),Sz,False);
              End;
        end;
end;

Function TKADaoTable.GetActiveRecordBuffer:  PChar;
begin
        case State of
             dsBrowse      : if IsEmpty then Result := nil else Result := ActiveBuffer;
             dsCalcFields  : Result := CalcBuffer;
             dsFilter      : Result := F_FilterBuffer;
             dsEdit,
             dsInsert      : Result := ActiveBuffer;
        else Result:=nil;
        end;
end;


Procedure TKADaoTable.InternalHandleException;
begin
     Application.HandleException(Self);
end;


procedure TKADaoTable.DataEvent(Event: TDataEvent; Info: Longint);
begin
     inherited DataEvent(Event, Info);
     if (Event in [deDataSetScroll,
                   deUpdateState,
                   deDataSetChange]) and Active then
         Begin
           InternalSetToRecord(ActiveBuffer);
         End;
end;

Procedure TKADaoTable.ClearDBCalcFields(Buffer: PChar);
begin
    FillChar(Buffer[F_StartCalc],CalcFieldsSize,0);
end;

Function TKADaoTable.GetFieldData(Field: TField; Buffer: Pointer): Boolean;
var
  SourceBuffer : PChar;
  Value        : TStringList;
  FieldNumber  : Integer;
  TempString   : String;
begin
        Result:=False;
        SourceBuffer:=GetActiveRecordBuffer;
        if (not F_Active) or (SourceBuffer=nil) then
           Begin
              Exit;
           End;
        if (Field.FieldKind=fkCalculated) or (Field.FieldKind=fkLookup) then
          begin
                Inc(SourceBuffer,F_StartCalc+Field.Offset);
                if {(SourceBuffer[0]=#0) or} (Buffer=nil) then
                  Begin
                    Exit;
                  End
                Else
                  Begin
                    Move(SourceBuffer[1], Buffer^, Field.DataSize);
                    Result:=True;
                  End;
          end
        else
          Begin
           Value :=PDaoInfo(PChar(SourceBuffer)+F_StartMyInfo)^.RecordData;
           FieldNumber:=Field.FieldNo-1;
           if (Value=Nil) Then Exit;
           if (Buffer = Nil)  Then
            Begin
              Result:=(Value.Strings[FieldNumber] <> '');
            End
               Else
            Begin
              Case Field.DataType of
                ftBytes     : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftInteger   : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftSmallint  : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftCurrency  : Result:=FloatToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftFloat     : Result:=FloatToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftDate      : Result:=DateToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftString    : Begin
                                TempString:=Value.Strings[FieldNumber];
                                TempString:=TempString+#0;
                                CopyMemory(PChar(Buffer),PChar(TempString),Length(TempString));
                                Result := True;
                              End;
                ftAutoInc   : Result:=IntegerToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftTime      : Result:=TimeToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftDateTime  : Result:=DateTimeToBuffer(Buffer,Value.Strings[FieldNumber]);
                ftBoolean   : Result:=BooleanToBuffer(Buffer,Value.Strings[FieldNumber]);
              End;
            End;
          End;
end;

Procedure TKADaoTable.SetFieldData(Field: TField; Buffer: Pointer);
var
        DestinationBuffer: PChar;
        Tmp              : String;
        BTmp             : WordBool;
        BBTmp            : Boolean;
begin
        DestinationBuffer:=GetActiveRecordBuffer;
        if (Field.FieldKind=fkCalculated) or (Field.FieldKind=fkLookup) then //this is a calculated field
        begin
                Inc(DestinationBuffer,F_StartCalc+Field.Offset);
                Boolean(DestinationBuffer[0]):=(Buffer<>nil);
                if Boolean(DestinationBuffer[0]) then CopyMemory(@DestinationBuffer[1],Buffer,Field.DataSize);
        end
        Else
        Begin
          Tmp:='';
          Case Field.DataType of
            ftString     : Tmp := PChar(Buffer);
            ftSmallint   : Tmp := IntToStr(Integer(Buffer^));
            ftWord       : Tmp := IntToStr(Integer(Buffer^));
            ftAutoInc    : Tmp := IntToStr(Integer(Buffer^));
            ftInteger    : Tmp := IntToStr(Integer(Buffer^));

            ftBCD        : Tmp := FloatToStr(Double(Buffer^));
            ftCurrency   : Tmp := FloatToStr(Double(Buffer^));
            ftFloat      : Tmp := FloatToStr(Double(Buffer^));

            ftDate       : Tmp := BufferToDate(Buffer);
            ftTime       : Tmp := BufferToTime(Buffer);
            ftDateTime   : Tmp := BufferToDateTime(Buffer);
            ftBoolean    : Begin
                            BTmp := WordBool(Buffer^);
                            BBTmp:=Boolean(BTmp);                               
                             Case BBTmp Of
                                  True   : Tmp:='True';
                                  False  : Tmp:='False';
                             End;
                           End;
          End;
          PDaoInfo(DestinationBuffer+F_StartMyInfo)^.RecordData[Field.FieldNo-1]:=Tmp;
          PDaoInfo(DestinationBuffer+F_StartMyInfo)^.FieldChanged[Field.FieldNo-1]:=Pointer(True);
          DataEvent(deFieldChange, Longint(Field));
        End;
end;

procedure TKADaoTable.InternalEdit;
begin
     inherited InternalEdit;
end;

procedure TKADaoTable.InternalAddRecord(Buffer: Pointer; Append: Boolean);
begin
    if Append Then InternalLast;
    InternalPost;
end;

procedure TKADaoTable.InternalPost;
Var
 Buffer : PChar;
 X      : Integer;
 RData  : TStringList;
 Changed: Tlist;
 S      : String;
Begin
 CheckActive;
 if State = dsEdit then //***************************************************** EDITING A RECORD
  Begin
    Buffer:=GetActiveRecordBuffer;
    RData:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordData;
    Changed:=PDaoInfo(PChar(Buffer)+F_StartMyInfo)^.FieldChanged;
    F_DaoTable.Edit;
    For X:=0 to RData.Count-1 do
        Begin
        if Boolean(Changed[X]) Then
         Begin
          S:=RData.Strings[X];
          if (Fields[X].DataType=ftDate) or
             (Fields[X].DataType=ftTime) or
             (Fields[X].DataType=ftDateTime) Then if S <> '' Then S:=RemoveNonDigitChars(S);
          if (F_DaoTable.Fields.Item[X].Attributes And dbUpdatableField) > 0 Then
              Begin
                if (F_DaoTable.Fields.Item[X].Attributes And dbAutoIncrField) = 0 Then
                    Begin
                      if (F_DaoTable.Fields.Item[X].Attributes And dbSystemField) = 0 Then
                          Begin
                            if (Fields[X].IsBlob) And (S = '(Blob)')  Then
                            Else
                              Begin
                                if S='' Then
                                   F_DaoTable.Fields.Item[X].Value:=NULL
                                Else
                                   F_DaoTable.Fields.Item[X].Value:=S;
                              End;
                          End;
                    End;
              End;
         End;
        End;
      OleVariant(F_DaoTable).Update;
  End
 Else
  Begin //****************************************************************** ADDING A NEW RECORD
    Buffer:=GetActiveRecordBuffer;
    RData:=PDaoInfo(Buffer+F_StartMyInfo)^.RecordData;
    F_DaoTable.AddNew;
    For X:=0 to RData.Count-1 do
        Begin
         Begin
          S:=RData.Strings[X];
          if (Fields[X].DataType=ftDate) or
             (Fields[X].DataType=ftTime) or
             (Fields[X].DataType=ftDateTime) Then if S <> '' Then S:=RemoveNonDigitChars(S);
          if (F_DaoTable.Fields.Item[X].Attributes And dbUpdatableField > 0) Then
              Begin
                if (F_DaoTable.Fields.Item[X].Attributes And dbAutoIncrField) = 0 Then
                    Begin
                      if (F_DaoTable.Fields.Item[X].Attributes And dbSystemField) = 0 Then
                          Begin
                            if (Fields[X].IsBlob) And (S = '(Blob)')  Then
                            Else
                              Begin
                                if S='' Then
                                   F_DaoTable.Fields.Item[X].Value:=NULL
                                Else
                                   F_DaoTable.Fields.Item[X].Value:=S;
                              End;
                          End;
                    End;
              End;
          End;
        End;                                                            
      OleVariant(F_DaoTable).Update;
      Try                                                  
        InternalLast;
        Resync([]); 
      Except
       //************************************************************ EXCEPTION NO CURRENT RECORD
      End;
  End;
End;


Procedure TKADaoTable.InternalDelete;
Begin
  F_DaoTable.Delete;
  IF (F_DaoTable.EOF) then OleVariant(F_DaoTable).MoveLast Else F_DaoTable.MoveNext;
End;


Function TKADaoTable.IsCursorOpen: Boolean;
begin
  Result:=F_Active;
end;

Function TKADaoTable.GetCanModify: Boolean;
begin
 Result:= NOT F_ReadOnly;
end;

Function TKADaoTable.GetRecordSize: Word;
begin
  Result:=F_BufferSize;
end;

procedure TKADaoTable.InternalInitRecord(Buffer: PChar);
Var
  X      : Integer;
  DefVal : String;
  RC     : Integer;
begin
     FillChar(Buffer^, F_BufferSize, 0);
     PDaoInfo(Buffer+F_StartMyInfo)^.RecordData:=TStringList.Create;
     PDaoInfo(Buffer+F_StartMyInfo)^.FieldChanged:=TList.Create;
     PDaoInfo(Buffer+F_StartMyInfo)^.DaoBookmark.pvData:=Nil;
     PDaoInfo(Buffer+F_StartMyInfo)^.BookmarkFlag := bfInserted;
     For X:=0 To F_DaoTable.Fields.Count-1 do
          Begin
            DefVal:=F_DefaultValues.Strings[X];
            PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Add(DefVal);
            PDaoInfo(Buffer+F_StartMyInfo)^.FieldChanged.Add(Pointer(False));
          End;
     if F_UseRecordCount Then
        Begin
          RC:=GetRecordCount;
          if (RC=-1) And (F_RecNo=-1) Then RC:=0;
        End
     Else
        Begin
          InternalLast;
          RC:=F_RecNo;
        End;
     PDaoInfo(Buffer+F_StartMyInfo)^.RecordNo:=RC;
end;


Function TKADaoTable.AllocRecordBuffer: PChar;
Var
  X:Integer;
begin
        GetMem(Result,F_BufferSize);
        FillChar(Result^,F_BufferSize,0);
        PDaoInfo(Result+F_StartMyInfo)^.RecordData:=TStringList.Create;
        PDaoInfo(Result+F_StartMyInfo)^.FieldChanged:=TList.Create;
        For X:=0 To F_DaoTable.Fields.Count-1 do
          Begin
            PDaoInfo(Result+F_StartMyInfo)^.RecordData.Add('');
            PDaoInfo(Result+F_StartMyInfo)^.FieldChanged.Add(Pointer(False));
          End;
        PDaoInfo(Result+F_StartMyInfo)^.DaoBookmark.pvData:=Nil;
end;

Procedure TKADaoTable.FreeRecordBuffer(var Buffer: PChar);
begin
        PDaoInfo(Buffer+F_StartMyInfo)^.RecordData.Free;
        PDaoInfo(Buffer+F_StartMyInfo)^.FieldChanged.Free;
        FreeMem(Buffer,F_BufferSize);
        Buffer:=Nil;
end;

Function TKADaoTable.AddLeadingZeros(Value:String):String;
Const
  Zeros='0000000000000000';
Var
  L : Integer;
Begin
  Result := Value;
  L:=Length(Value);
  if L < MYBOOKMARKSIZE Then
     Begin
       L:=MYBOOKMARKSIZE-L;
       Result:=Copy(Zeros,1,L)+Result;
     End;
End;


Function TKADaoTable.GetRecord(Buffer: PChar; GetMode: TGetMode; DoCheck: Boolean): TGetResult;
var
 Acceptable : Boolean;
 X          : Integer;
 RD         : Variant;
 {$IFDEF DYNADAO}
 TempBK     : Pointer;
 {$ENDIF}
begin
        Result:=grOK;
        Acceptable:=False;
        repeat
                begin
                        case GetMode of
                        gmCurrent:
                                begin
                                    Result:=grOK;
                                    if F_DaoTable.EOF then
                                       Begin
                                         Result:=grEOF;
                                       End
                                    Else
                                    if F_DaoTable.BOF then
                                       Begin
                                         Result:=grBOF;
                                       End;
                                end;
                        gmNext:
                                begin
                                    if NOT F_DaoTable.EOF Then
                                        begin
                                          if F_DaoTable.BOF Then
                                             Begin
                                               if F_TableType <> dbOpenForwardOnly Then F_DaoTable.MoveFirst;
                                             End
                                          Else
                                             Begin
                                               if F_TableType = dbOpenForwardOnly Then
                                                  Begin
                                                    if F_RecNo <> -1 Then
                                                       Begin
                                                          F_DaoTable.MoveNext;
                                                          Inc(F_RecPos);
                                                       End;
                                                  End
                                                Else
                                                  Begin
                                                    F_DaoTable.MoveNext;
                                                  End;
                                             End;
                                          Inc(F_RecNo);
                                          if F_DaoTable.EOF then
                                             Begin
                                               Result:=grEOF;
                                             End;
                                        end
                                    Else
                                         Begin
                                           Result:=grEOF;
                                         End;
                                end;
                        gmPrior:
                                begin
                                  if F_RecNo > 0 then
                                     Begin
                                      // *****************************
                                      //   dbOpenForwardOnly table
                                      //   will raise an exception here
                                      //   which is CORRECT!!!
                                      //******************************
                                       if F_TableType <> dbOpenForwardOnly Then
                                          Begin
                                           F_DaoTable.MovePrevious;
                                           Dec(F_RecNo);
                                           Result:=grOK;
                                          End
                                       Else  Result:=grError;
                                     End
                                  else
                                     Begin
                                       Result:=grBOF;
                                     End;
                                end;
                        end;
                        if Result=grOk then
                        begin
                                with PDaoInfo(Buffer+F_StartMyInfo)^ do
                                begin
                                        if F_DaoTable.Bookmarkable Then
                                           Begin
                                        {$IFDEF DYNADAO}
                                            TempBK:=TVarData(F_DaoTable.Bookmark).VPointer;
                                            DaoBookmark:=PSafeArray(TempBK)^;
                                        {$ELSE}
                                            DaoBookmark:=F_DaoTable.Bookmark^;
                                        {$ENDIF}
                                            BookmarkData:=PInteger(DaoBookmark.pvData)^;
                                            FillChar(BookmarkString,BookmarkSize,#0);
                                            StrPCopy(BookmarkString,AddLeadingZeros(IntToStr(BookmarkData)));
                                           End
                                        Else
                                           Begin
                                             DaoBookmark.pvData:=Nil;
                                             BookmarkData:=0;             
                                             FillChar(BookmarkString,BookmarkSize,#0);
                                             StrPCopy(BookmarkString,'00000000');
                                           End;
                                        RecordNo     := F_RecNo;
                                        BookmarkFlag := bfCurrent;
                                        For X:=0 To F_DaoTable.Fields.Count-1 do
                                            Begin
                                             if NOT Fields[X].IsBlob Then
                                                RD:=F_DaoTable.Fields.Item[X].Value
                                             Else
                                                RD:='(Blob)';
                                             if VarType(RD) = varNull then RD := '';
                                             RecordData.Strings[X]:=RD;
                                             FieldChanged.Items[X]:=Pointer(False);
                                            End;
                                End;
                                ClearDBCalcFields(Buffer);
                                GetCalcFields(Buffer);
                                Acceptable:=FilterRecord(Buffer);
                                if (GetMode=gmCurrent) and (not Acceptable) then Result:=grError;
                        end
                end;
        until (Result<>grOk) or (Acceptable);
end;

Function TKADaoTable.FilterRecord(Buffer: PChar): Boolean;
var
        SaveState: TDatasetState;
begin
        Result:=True;
        if (not Filtered) or (not Assigned(OnFilterRecord)) then Exit;
        SaveState:=SetTempState(dsFilter);
        F_FilterBuffer:=Buffer;
        if Assigned(OnFilterRecord) then OnFilterRecord(self,Result);
        RestoreState(SaveState);
end;


Function TKADaoTable.GetRecordCount: Integer;
var
  SaveState: TDataSetState;
  SavePosition: integer;
  TempBuffer: PChar;
Begin
 Result:=-1;
 if Not F_UseRecordCount Then Exit;
 if F_TableType=dbOpenForwardOnly Then Exit;
 if F_DaoTable.RecordCount=0 Then
    Begin
      Result:=0;
      Exit;
    End;
 If (F_Filtered) And (Assigned(F_OnFilterRecord)) Then
     Begin
       Result:=0;
       SaveState:=SetTempState(dsBrowse);
       SavePosition:=F_RecNo;
       Try
         TempBuffer:=AllocRecordBuffer;
         InternalFirst;
         While GetRecord(TempBuffer,gmNext,True)=grOk do Inc(Result);
       Finally
         RestoreState(SaveState);
         F_RecNo:=SavePosition;
         FreeRecordBuffer(TempBuffer);
       end;
     End
 Else
     Begin
      Try
        if F_TableType=dbOpenTable Then
           Begin
             Result:=F_DaoTable.RecordCount;
             Exit;
           End;
        OleVariant(F_DaoTable).MoveLast;
        Result:=F_DaoTable.RecordCount;
        F_DaoTable.MoveFirst;
        if F_RecNo=-1 Then
           Begin
            F_DaoTable.MovePrevious;
           End
        Else
           Begin
            OleVariant(F_DaoTable).Move(F_RecNo);
           End;
      Except
      End;
     End;
End;

Function  TKADaoTable.GetRecNo: Integer;
var
  SaveState: TDataSetState;
  SavePosition: integer;
  TempBuffer: PChar;
Begin
  UpdateCursorPos;
  If (F_Filtered) And (Assigned(F_OnFilterRecord)) Then
    Begin
     Result:=-1;
     SaveState:=SetTempState(dsBrowse);
     SavePosition:=F_RecNo;
     Try
       TempBuffer:=AllocRecordBuffer;
       InternalFirst;
       Repeat
         if GetRecord(TempBuffer,gmNext,True)=grOk then Inc(Result);
       Until PDaoInfo(TempBuffer+F_StartMyInfo)^.RecordNo=SavePosition;
     Finally
       RestoreState(SaveState);
       F_RecNo:=SavePosition;
       FreeRecordBuffer(TempBuffer);
     End;
    End
 Else
    Begin
      Result:=F_RecNo;
    End;
End;

Procedure TKADaoTable.StringToList(Items: String; List: TStringList);
var
  X: Integer;
begin
  For X:= 1 To Length(Items) Do If Items[X] = ';' Then Items[X]:= #13;
  List.Clear;
  List.Text:=Items;
  For X:= 0 To List.Count - 1 Do List[X]:= Trim(List[X]);
end;

Procedure TKADaoTable.VariantToList(Items: Variant; List: TStringList);
Var
   X    : Integer;
   V    : Variant;
   Count: Integer;
Begin
   List.Clear;
   if VarIsArray(Items) Then
      Begin
        Count:=(VarArrayHighBound(Items, 1) - VarArrayLowBound(Items, 1))+1;
        For X:=0 to Count-1 do
            Begin
             V:=Items[VarArrayLowBound(Items, 1) + X];
             if VarIsNull(V) Then
                List.Add('NULL')                         
             Else
                List.Add(VarAsType(V,VarString));
            End;
      End
   Else
      Begin
         V:=Items;
         if VarIsNull(V) Then
            List.Add('NULL')
         Else
            List.Add(VarAsType(V,VarString));
      End;
End;

Procedure TKADaoTable.AssignVarValue(Var V :Variant; const Value: TVarRec);
begin
  with Value do
    case VType of
      vtInteger:
        V := VInteger;
      vtBoolean:
        V := VBoolean;
      vtChar:
        V := VChar;
      vtExtended:
        V := VExtended^;
      vtString:
        V := VString^;
      vtPointer:
        if VPointer <> nil then DatabaseError('Invalid data');
      vtPChar:
        if VPChar <> nil then DatabaseError('Invalid data');
      vtObject:
         DatabaseError('Invalid object');
      vtAnsiString:
        V := string(VAnsiString);
      vtCurrency:
        V := VCurrency^;
      vtVariant:
        if not VarIsEmpty(VVariant^) then V := VVariant^;
    else
      DatabaseError('Invalid data');
    end;
end;



Function  TKADaoTable.BuildKeySQL(KN,KV:TStringList):String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if KN.Count > 0 Then
     Begin
      For X:=0 To KN.Count-1 do
         Begin
          S:=S+'(';
          S:=S+KN.Strings[X]+' ';
          FT :=FieldByName(KN.Strings[X]);
          if KV.Strings[X]='NULL' Then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftString,
             ftMemo     : S:= S + ' = "' + KV.Strings[X] + '"';
             ftBoolean,
             ftCurrency,
             ftFloat,
             ftInteger : S:= S + ' = ' + KV.Strings[X];
             ftDate,
             ftTime,
             ftDateTime: Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('m/d/yy', StrToDateTime(KV.Strings[X])) + '#';
                         End;

             Else
             DatabaseError('Unable to build Lookup Key SQL!')
          End;
          S:=S+')';
          if (X < KN.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

Function  TKADaoTable.BuildLocateSQL(KN,KV:TStringList;Options: TLocateOptions):String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if KN.Count > 0 Then
     Begin
      For X:=0 To KN.Count-1 do
         Begin
          S:=S+'(';
          FT :=FieldByName(KN.Strings[X]);
          if loCaseInsensitive in Options Then
             Begin
               if (FT.DataType=ftString) Or (FT.DataType=ftMemo) Then
                  Begin
                     S:=S+'LCASE('+KN.Strings[X]+') ';
                  End
               Else
                  Begin
                     S:=S+KN.Strings[X]+' ';
                  End;
             End
          Else
             Begin
               S:=S+KN.Strings[X]+' ';
             End;

          if KV.Strings[X]='NULL' Then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftString,
             ftMemo     :  Begin
                             if loCaseInsensitive in Options Then KV.Strings[X]:=AnsiLowerCase(KV.Strings[X]);
                             If loPartialKey in Options Then
                                Begin
                                  if Pos('*',KV.Strings[X]) > 0 Then
                                     S:= S + ' LIKE "' + KV.Strings[X] + '"'
                                  Else
                                     S:= S + ' LIKE "' + KV.Strings[X] + '*"';
                                End
                             Else
                                Begin
                                  S:= S + ' = "' + KV.Strings[X] + '"';
                                End;
                           End;
             ftBoolean,
             ftCurrency,
             ftFloat,
             ftInteger : S:= S + ' = ' + KV.Strings[X];
             ftDate,
             ftTime,
             ftDateTime: Begin
                           KV.Strings[X]:=RemoveNonDigitChars(KV.Strings[X]);
                           S:= S + ' = #' + FormatDateTime('m/d/yy', StrToDateTime(KV.Strings[X])) + '#';
                         End;

             Else
             DatabaseError('Unable to build Lookup Key SQL!')
          End;
          S:=S+')';
          if (X < KN.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

Function  TKADaoTable.GetDaoBookMark(RS:Variant):Integer;
Var
 TempBK : Pointer;
Begin
 TempBK:=TVarData(RS.Bookmark).VPointer;
 Result:=PInteger(PSafeArray(TempBK)^.pvData)^;
End;

Procedure  TKADaoTable.SetDaoBookMark(Var RS:Variant;BookMark:Integer);
Var
 TempBK : Pointer;
Begin
 TempBK:=TVarData(RS.Bookmark).VPointer;
 PInteger(PSafeArray(TempBK)^.pvData)^:=BookMark;
End;

Function  TKADaoTable.Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean;
Var
 KF     : TStringList;
 KV     : TStringList;
 X      : Integer;
 CR     : Integer;
 RI     : Integer;
 FN     : Integer;
 Find   : Boolean;
 S1,S2  : String;
 L      : Integer;

 Filter : String;
 {$IFDEF DYNADAO}
 TempRS : OleVariant;
 {$ELSE}
 TempRS : Recordset;
 {$ENDIF}
 BKO,BKC: Integer;
 Delta  : Integer;
Begin
 Result:=False;
 KF := TStringList.Create;
 KV :=  TStringList.Create;
 StringToList(KeyFields,KF);
 VariantToList(KeyValues,KV);
 If (KF.Count <> KV.Count)  Then DatabaseError('Number of elements in the KeyValues array must be equal to the number of fields.');
 For X:=0 To KF.Count-1 do KF.Objects[X]:=Pointer(FieldByName(KF[X]).FieldNo);
 CR:=F_RecNo;
 if F_DaoTable.Bookmarkable Then
    Begin
      Filter:=BuildLocateSQL(KF,KV,Options);
      TempRS:=F_DaoTable.Clone;
      TempRS.MoveFirst;
      OleVariant(TempRS).Move(CR);
      TempRS.FindFirst(Filter);
      Find:=NOT TempRS.NoMatch;
      if (Find) Then
          Begin
            if F_Database.Version='3.5' Then
               Begin
                 BKO:=GetDaoBookMark(F_DaoTable);
                 BKC:=GetDaoBookMark(TempRS);
                 Delta:=BKC-BKO;
                 Result:= True;
                 CursorPosChanged;
                 DoBeforeScroll;
                 OleVariant(F_DaoTable).Move(Delta);
                 F_RecNo:=CR+Delta;
                 ClearBuffers;
                 Resync([rmExact, rmCenter]);
                 DoAfterScroll;
               End;
            //************************ A BUG IN DAO 3.6 does something with
            //                         Bookmarks when they are cloned
            if F_Database.Version='3.6' Then
               Begin
                 Result:= True;
                 CursorPosChanged;
                 RI:=0;
                 While NOT TempRS.BOF do
                    Begin
                      Inc(RI);
                      TempRS.MovePrevious;
                    End;
                 if RI > 0 Then Dec(RI);
                 DoBeforeScroll;
                 OleVariant(F_DaoTable).Move(RI-CR);
                 F_RecNo:=RI;
                 ClearBuffers;
                 Resync([rmExact, rmCenter]);
                 DoAfterScroll;
               End;
          End;
      TempRS.Close;
      {$IFDEF DYNADAO}
      TempRS:=NULL;
      {$ELSE}
      TempRS:=Nil;
      {$ENDIF}
    End
 Else
    Begin
      CursorPosChanged;
      F_DaoTable.MoveFirst;
      Find:=False;
      RI:=0;
      While Not (F_DaoTable.EOF) Do
            Begin
             Find:=True;
             For X:=0 to KF.Count-1 do
                 Begin
                  FN:=Integer(KF.Objects[X])-1;
                  S1:=KV[X];
                  S2:=VarAsType(F_DaoTable.Fields.Item[FN].Value,VarString);
                  if loCaseInsensitive in Options Then
                      Begin
                       S1:=AnsiLowerCase(S1);
                       S2:=AnsiLowerCase(S2);
                      End;
                  if loPartialKey in Options Then
                      Begin
                       L:=Length(S1);
                       if S1[L]='*' Then System.Delete(S1,L,1);
                       if S1[1]='*' Then System.Delete(S1,1,1);
                       if Pos(S1,S2) = 0 Then Find:=False;
                      End
                  Else
                      Begin
                       if S1 <> S2 Then Find:=False;
                      End;
                  if NOT Find Then Break;
                 End;
             If Find Then
                Begin
                 DoBeforeScroll;
                 F_RecNo:=RI;
                 Result:= True;
                 ClearBuffers;
                 Resync([rmExact, rmCenter]);
                 DoAfterScroll;
                 Break;
                End
             Else
                Begin
                 Inc(RI);
                 F_DaoTable.MoveNext;
                End;
            End;
      if Not(Find) Then
         Begin
           F_DaoTable.MoveFirst;
           OleVariant(F_DaoTable).Move(CR);
           Resync([rmExact, rmCenter]);
          End;
    End;
 KV.Free;
 KF.Free;
End;

Function  TKADaoTable.Find(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions;FindType:Integer): Boolean;
Var
 KF     : TStringList;
 KV     : TStringList;
 X      : Integer;
 CR     : Integer;
 RI     : Integer;
 Filter : String;
 {$IFDEF DYNADAO}
 TempRS : OleVariant;
 {$ELSE}
 TempRS : Recordset;
 {$ENDIF}
 BKO,BKC: Integer;
 Delta  : Integer;
Begin
 Result:=False;
 KF := TStringList.Create;
 KV :=  TStringList.Create;
 StringToList(KeyFields,KF);
 VariantToList(KeyValues,KV);
 If (KF.Count <> KV.Count)  Then DatabaseError('Number of elements in the KeyValues array must be equal to the number of fields.');
 For X:=0 To KF.Count-1 do KF.Objects[X]:=Pointer(FieldByName(KF[X]).FieldNo);
 CR:=F_RecNo;
 if F_DaoTable.Bookmarkable Then
    Begin
      Filter:=BuildLocateSQL(KF,KV,Options);
      TempRS:=F_DaoTable.Clone;
      TempRS.MoveFirst;
      OleVariant(TempRS).Move(CR);
      Case FindType of
           1 : TempRS.FindFirst(Filter);
           2 : TempRS.FindLast(Filter);
           3 : TempRS.FindNext(Filter);
           4 : TempRS.FindPrevious(Filter);
      End;
      if (Not TempRS.NoMatch) Then
          Begin
            Result:= True;
            if F_Database.Version='3.5' Then
               Begin
                BKO:=GetDaoBookMark(F_DaoTable);
                BKC:=GetDaoBookMark(TempRS);
                Delta:=BKC-BKO;
                CursorPosChanged;
                DoBeforeScroll;
                OleVariant(F_DaoTable).Move(Delta);
                F_RecNo:=CR+Delta;
                ClearBuffers;
                Resync([rmExact, rmCenter]);
                DoAfterScroll;
               End;
            if F_Database.Version='3.6' Then
               Begin
                 Result:= True;
                 CursorPosChanged;
                 RI:=0;
                 While NOT TempRS.BOF do
                    Begin
                      Inc(RI);
                      TempRS.MovePrevious;
                    End;
                 if RI > 0 Then Dec(RI);
                 DoBeforeScroll;
                 OleVariant(F_DaoTable).Move(RI-CR);
                 F_RecNo:=RI;
                 ClearBuffers;
                 Resync([rmExact, rmCenter]);
                 DoAfterScroll;
               End;
          End;
      TempRS.Close;
      {$IFDEF DYNADAO}
      TempRS:=NULL;
      {$ELSE}
      TempRS:=Nil;
      {$ENDIF}
    End
 Else
    Result:=False;
End;

Procedure TKADaoTable.SetKeyFields(const KeyFields: string);
Begin
 StringToList(KeyFields,F_KeyFields);
End;

Function TKADaoTable.Find_First(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,1);
End;

Function TKADaoTable.Find_Last(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,2);
End;

Function TKADaoTable.Find_Next(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,3);
End;

Function TKADaoTable.Find_NearestEx(const KeyFields: string; const KeyValues: Variant):Boolean;
Var
  Options:TLocateOptions;
Begin
  Options:=[loCaseInsensitive,loPartialKey];
  Result:=Find(KeyFields,KeyValues,Options,1);
  if Not Result Then Result:=Find(KeyFields,KeyValues,Options,3);
End;

Function TKADaoTable.Find_Nearest(const KeyValues: array of const):Boolean;
Var
  KF         : String;
  KV         : Variant;
  KT         : Variant;
  X          : Integer;
Begin
  KF:='';
  For X:=0 to High(KeyValues) do
      Begin
        if X < High(KeyValues) Then KF := KF+F_KeyFields.Strings[X]+';' Else  KF := KF+F_KeyFields.Strings[X];
       End;
  if High(KeyValues)=0 then
    Begin
      AssignVarValue(KV,KeyValues[0]);
    End
  Else
     Begin
       KV:=VarArrayCreate([0,High(KeyValues)],varVariant);
       For X:=0 to High(KeyValues) do
           Begin
            AssignVarValue(KT,KeyValues[X]);
            KV[X]:=KT;
           End;
     End;
  Result:=Find_NearestEx(KF,KV);
End;


Function TKADaoTable.Seek_NearestEx(const KeyValues: array of const; SeekType:String):Boolean;
Var
 KV     : Variant;
 KT     : Variant;
 X      : Integer;
 CR     : Integer;
 RI     : Integer;
 {$IFDEF DYNADAO}
 TempRS : OleVariant;
 {$ELSE}
 TempRS : Recordset;
 {$ENDIF}
Begin
 Result:=False;
 if F_IndexName='' Then Exit;
 if High(KeyValues)=0 then
    Begin
      AssignVarValue(KV,KeyValues[0]);
    End
  Else
     Begin
       KV:=VarArrayCreate([0,High(KeyValues)],varVariant);
       For X:=0 to High(KeyValues) do
           Begin
            AssignVarValue(KT,KeyValues[X]);
            KV[X]:=KT;
           End;
     End;
     CR:=F_RecNo;
     TempRS:=F_DaoTable.Clone;
     TempRS.Index:=F_IndexName;
     OleVariant(TempRS).Move(CR);
     OleVariant(TempRS).Seek(SeekType,KV);
     if (Not TempRS.NoMatch) Then
          Begin
            Result:= True;
            CursorPosChanged;
            RI:=0;
            While NOT TempRS.BOF do
                    Begin
                      Inc(RI);
                      TempRS.MovePrevious;
                    End;
            if RI > 0 Then Dec(RI);
            DoBeforeScroll;
            OleVariant(F_DaoTable).Move(RI-CR);
            F_RecNo:=RI;
            ClearBuffers;
            Resync([rmExact, rmCenter]);
            DoAfterScroll;
          End;
     TempRS.Close;
     {$IFDEF DYNADAO}
     TempRS:=NULL;
     {$ELSE}
     TempRS:=Nil;
     {$ENDIF}
End;

Function TKADaoTable.Seek_Nearest(const KeyValues: array of const):Boolean;
Begin
 Result:=Seek_NearestEx(KeyValues,'>=');
End;

Function TKADaoTable.Find_Prior(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions):Boolean;
Begin
  Result:=Find(KeyFields,KeyValues,Options,4);
End;

Function  TKADaoTable.Lookup(const KeyFields: string; const KeyValues: Variant; const ResultFields: string): Variant;
Var
 KF     : TStringList;
 KV     : TStringList;
 RF     : TStringList;
 {$IFDEF DYNADAO}
 RS     : OleVariant;
 TempRS : OleVariant;
 {$ELSE}
 RS     : Recordset;
 TempRS : Recordset;
 {$ENDIF}
 FT     : String;
 X      : Integer;
 FN     : Integer;
Begin
 Result:= NULL;
 KF := TStringList.Create;
 KV := TStringList.Create;
 RF := TStringList.Create;
 StringToList(KeyFields,KF);
 VariantToList(KeyValues,KV);
 StringToList(ResultFields,RF);
 if (KF.Count <> KV.Count)  Then DatabaseError('Number of elements in the KeyValues array must be equal to the number of fields.');
 if (RF.Count=0) Or (ResultFields='') Then DatabaseError('ResultFields are not defined');
 For X:=0 To RF.Count-1 do RF.Objects[X]:=Pointer(FieldByName(RF[X]).FieldNo);

 RS:=F_DaoTable;
 FT:=F_DaoTable.Filter;
 RS.Filter:=BuildKeySQL(KF,KV);
 TempRS:=RS.OpenRecordset(dbOpenSnapshot,dbReadOnly);
 If Not(TempRS.EOF and TempRS.BOF) then
    Begin
      TempRS.MoveFirst;
      if RF.Count=1 Then
         Begin                                                                     
           FN:=Integer(RF.Objects[0])-1;
           Result:=TempRS.Fields.Item[FN].Value
         End
      Else
         Begin
           Result:= VarArrayCreate([0,RF.Count - 1], varVariant);
           For X:=0 To RF.Count-1 do
               Begin
                 FN:=Integer(RF.Objects[X])-1;
                 Result[X]:=TempRS.Fields.Item[FN].Value
               End;
         End;
    End;
 TempRS.Close;
 {$IFDEF DYNADAO}
 TempRS:=NULL;
 {$ELSE}
 TempRS:=Nil;
 {$ENDIF}
 RS.Filter:=FT;
 RF.Free;
 KV.Free;
 KF.Free;
End;

{*************************************************************** DAO FIELD TYPES
  dbBoolean = 1;
  dbByte = 2;
  dbInteger = 3;
  dbLong = 4;
  dbCurrency = 5;
  dbSingle = 6;
  dbDouble = 7;
  dbDate = 8;
  dbBinary = 9;
  dbText = 10;
  dbLongBinary = 11;
  dbMemo = 12;
  dbGUID = 15;
  dbBigInt = 16;
  dbVarBinary = 17;
  dbChar = 18;
  dbNumeric = 19;
  dbDecimal = 20;
  dbFloat = 21;
  dbTime = 22;
  dbTimeStamp = 23;
//******************************************************************************
}

Function TKADaoTable.CreateField(FieldName:String;FieldType:Integer;FiledSize:Integer):Boolean;
Var
  FN,FT,FS,FI:Variant;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError('TableName property must be set!');
       Exit;
     End;
  if Not Assigned(F_Database) Then
         Begin
           DatabaseError('Database property must be set!');
           Exit;
         End;
  if F_Active Then Exit;
  FN:=VarArrayCreate([0, 0], varOleStr);
  FT:=VarArrayCreate([0, 0], varInteger);
  FS:=VarArrayCreate([0, 0], varInteger);
  FI:=VarArrayCreate([0, 0], varInteger);
  FN[0]:=FieldName;
  FT[0]:=FieldType;
  FS[0]:=DaoSizeToBDESize(FieldType,FiledSize);
  FI[0]:=0;
  Try
    Result:=F_Database.AddFieldsToTable(F_TableName,FN,FT,FS,FI);
  Except
    Exit;
  End;
End;

Function TKADaoTable.CreateIndex(FieldName:String;IndexType:Integer):Boolean;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError('TableName property must be set!');
       Exit;
     End;
  if Not Assigned(F_Database) Then
     Begin
       DatabaseError('Database property must be set!');
       Exit;
     End;
  if F_Active Then
     Begin
       DatabaseError('Cannot create index while table is Active!!');
       Exit;
     End;
  Result:=F_Database.CreateIndex(F_TableName,FieldName,IndexType);
End;

Function TKADaoTable.DeleteField(FieldName:String):Boolean;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError('TableName property must be set!');
       Exit;
     End;
  if Not Assigned(F_Database) Then
     Begin
       DatabaseError('Database property must be set!');
       Exit;
     End;
  if F_Active Then
     Begin
       DatabaseError('Cannot delete field while table is Active!!');
       Exit;
     End;
  Try
    F_Database.DeleteField(F_TableName,FieldName);
  Except
    Exit;
  End;
  Result:=True;
End;

Function TKADaoTable.DeleteIndex(FieldName:String):Boolean;
Begin
  Result:=False;
  if F_TableName='' Then
     Begin
       DatabaseError('TableName property must be set!');
       Exit;
     End;
  if Not Assigned(F_Database) Then
     Begin
       DatabaseError('Database property must be set!');
       Exit;
     End;
  if F_Active Then
     Begin
       DatabaseError('Cannot delete index while table is Active!!');
       Exit;
     End;
  Try
    F_Database.DeleteIndexByFieldName(F_TableName,FieldName);
  Except
    Exit;
  End;
  Result:=True;
End;



function TKADaoTable.InsertSQLString(MDString: String): String;
begin
  Result:='';
  if Filtered Then Result:= Filter;
  if MDString <> '' then
    begin
      if Result <> '' Then
         Result := '('+MDString+') AND ('+Result+')'
      Else
         Result := MDString;
    end;
end;

Function  TKADaoTable.BuildDetailSQL:String;
Var
 X  : Integer;
 S  : String;
 FT : TField;
Begin
S:='';
Result:='';
if F_Master.Count <> F_Detail.Count Then
     Begin
       DatabaseError('The number of Master and Detail fields must be equal!');
     End;
if F_Master.Count > 0 Then
     Begin
      For X:=0 To F_Master.Count-1 do
         Begin
          S:=S+'(';
          S:=S+F_Detail.Strings[X]+' ';
          FT :=F_MasterLink.Dataset.FieldByName(F_Master.Strings[X]);
          if FT.IsNull then S:= S + 'IS NULL'
          Else
          Case FT.DataType of
             ftString,
             ftMemo     : S:= S + ' = "' + FT.AsString + '"';
             ftCurrency,
             ftFloat,
             ftInteger : S:= S + ' = ' + FT.AsString;
             ftBoolean : If FT.AsBoolean then S:= S + ' = True' Else S:= S + ' = False';
             ftDate,
             ftTime,
             ftDateTime: S:= S + ' = #' + FormatDateTime('m/d/yy', FT.AsDateTime) + '#';
             Else
             DatabaseError('Unable to build Master/Detail SQL Relationship!')
          End;
          S:=S+')';
          if (X < F_Master.Count-1) Then S:=S+' AND ';
         End;
     End;
 Result := S;
End;

Procedure TKADaoTable.MasterDSChanged;
Begin
  if csDestroying in ComponentState then EXIT;
  if (MasterSource <> NIL) and not(F_MDisabled) then
  Begin
  if F_Master.Count > 0 Then
     Begin
      //*************************************************
      ClearBuffers;
      CheckBrowseMode;
      CloseDaoRecordset;
      OpenDaoRecordset;
      ActivateBuffers;
      First;
      //*************************************************
     End;
  End;
End;

Procedure TKADaoTable.Notification(AComponent: TComponent; Operation: TOperation);
Begin
 If (AComponent = F_Database) And (Operation = opRemove) Then F_Database:= NIL;
 inherited Notification(AComponent, Operation);
End;


//******************************************************************************
//*                  Master/Detail Data Link Handling
//******************************************************************************
constructor TKADAODataLink.Create(DataSet: TKADaoTable);
begin
  inherited Create(DataSet);
  F_KADaoTable:= DataSet;
  F_MasterIsChanged:=False;
end;

procedure TKADAODataLink.ActiveChanged;
begin
  F_KADaoTable.F_MDisabled:= True;
  if DataSet <> NIL then F_KADaoTable.F_MDisabled:= not(DataSet.Active);
  if (F_KADaoTable.F_Active) then F_KADaoTable.MasterDSChanged Else F_MasterIsChanged:=True;
end;

{$IFNDEF VER100}
function TKADAODataLink.GetDetailDataSet: TDataSet;
begin
  Result:= F_KADaoTable;
end;
{$ENDIF}

procedure TKADAODataLink.RecordChanged(Field: TField);
begin
  if (Field = NIL) and (F_KADaoTable.Active) then F_KADaoTable.MasterDSChanged;
end;

procedure TKADAODataLink.CheckBrowseMode;
begin
  if F_KADaoTable.Active then F_KADaoTable.CheckBrowseMode;
end;

//******************************************************************************
//*                         Blob Stream Handling
//******************************************************************************
constructor TKBlobStream.Create(Field: TBlobField; Mode: TBlobStreamMode);
Var
   RD     : OleVariant;
begin
     F_BlobData := '';
     F_Mode     := Mode;
     F_Field    := Field;
     F_DataSet  := F_Field.DataSet as TKADaoTable;
     F_Buffer   := F_DataSet.GetActiveRecordBuffer;
     if not (F_Buffer = nil) then F_DataSet.InternalSetToRecord(F_Buffer);
     F_Opened := True;
     if not F_Field.Modified then
     begin
          if (F_DataSet.State = dsInsert)
          then
            Begin                                                  
              F_BlobData := '';
             End
          Else
             Begin
               if Not (F_Buffer = nil) Then
                  Begin
                    Try
                      if (F_DataSet.BlobOffset <> 0) Or (F_DataSet.BlobNumBytes  <> 0) Then
                         Begin
                           RD:=F_DataSet.F_DaoTable.Fields.Item[F_Field.FieldNo-1].GetChunk(F_DataSet.BlobOffset,F_DataSet.BlobNumBytes);
                         End
                      Else
                         Begin
                           RD:=F_DataSet.F_DaoTable.Fields.Item[F_Field.FieldNo-1].Value;
                         End;  
                      if VarType(RD) = varNull then RD := '';
                      F_BlobData:=RD;
                     Except
                      F_BlobData:='';
                     End;
                  End
               Else
                  Begin
                    F_BlobData:='';
                  End;
             End;
          F_BlobSize:=Length(F_BlobData);
     end;
     if Mode = bmWrite then Truncate;
end;


destructor TKBlobStream.Destroy;
begin
   if F_Modified then
     try
          F_DataSet.DataEvent(deFieldChange, Longint(F_Field));
          F_BlobData:='';
          F_Buffer:=Nil;
     except
          Application.HandleException(Self);
     end;
end;


function TKBlobStream.Read(var Buffer; Count: Longint): Longint;
begin
     Result := 0;
     if F_Opened then
     begin
          if Count > Size - F_Position then
             Result := Size - F_Position else
             Result := Count;
          if Result > 0 then
          begin
               Move(PChar(F_BlobData)[F_Position], Buffer, Result);
               Inc(F_Position, Result);
          end;
     end;
end;


function TKBlobStream.Write(const Buffer; Count: Longint): Longint;
var
   pTemp  : Pointer;
   RData  : TStringList;
   Changed: TList;
begin
     Result := 0;
     if F_Opened then
     begin
          try
          begin
               SetLength(F_BlobData,Count+1);
               pTemp:=PChar(F_BlobData);
               CopyMemory(pTemp, @Buffer, Count);
               F_BlobData  := Copy(F_BlobData,1,Count);
               F_BlobSize  := Length(F_BlobData);
               RData:=PDaoInfo(F_Buffer+F_DataSet.F_StartMyInfo)^.RecordData;
               Changed:=PDaoInfo(F_Buffer+F_DataSet.F_StartMyInfo)^.FieldChanged;
               RData.Strings[F_Field.FieldNo-1]:=F_BlobData;
               Changed[F_Field.FieldNo-1]:=Pointer(True);
               F_Modified := True;
          end;
          finally
          end;
          Inc(F_Position, Count);
          Result := Count;
          F_Modified := True;
     end;
end;


function TKBlobStream.Seek(Offset: Longint; Origin: Word): Longint;
begin
     case Origin of
          0: F_Position := Offset;
          1: Inc(F_Position, Offset);
          2: F_Position := F_BlobSize + Offset;
     end;
     Result := F_Position;
end;


procedure TKBlobStream.Truncate;
begin
     if F_Opened then F_Modified := True;
end;

//***********************************************************************************
Function TKADaoTable.IntegerToBuffer(Buffer: Pointer; S: String): Boolean;
begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = '' then S := '0';
     Integer(Buffer^) := StrToInt(S);
end;


Function TKADaoTable.FloatToBuffer(Buffer: Pointer; S: String): Boolean;
begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = '' then S := '0';
     Double(Buffer^) := StrToFloat(S);
end;


Function TKADaoTable.DateToBuffer(Buffer: Pointer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   dTmp : ^TDateTimeRec;
begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     S:=RemoveNonDigitChars(S);
     Ttmp.Date := 0;
     Ttmp.Time := 0;
     if S <> '' then Ttmp := DateTimeToTimeStamp(StrToDateTime(S));
     Dtmp := Buffer;
     Dtmp.Date := Ttmp.Date;
end;


Function TKADaoTable.TimeToBuffer(Buffer: Pointer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
   P    : Integer;
begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     S:=RemoveNonDigitChars(S);
     if Pos(DateDelimiter,S) > 0 Then
        Begin
          P:=Pos(' ',S);
          if P > 0 Then System.Delete(S,1,P);
        End;
     Ttmp.Date := 0;
     Ttmp.Time := 0;
     if S <> '' then
     begin
       Ttmp := DateTimeToTimeStamp(StrToTime(S))
     end;
     Dtmp := Buffer;
     Dtmp.Time := Ttmp.Time;
end;


Function TKADaoTable.DateTimeToBuffer(Buffer: Pointer; S: String): Boolean;
var
   Ttmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     S:=RemoveNonDigitChars(S);
     Ttmp.Date := 0;
     Ttmp.Time := 0;
     if Pos(DateDelimiter,S)=0 Then
        Begin
          S:= DateToStr(Now)+' '+S;
          S:= RemoveNonDigitChars(S);
        End;
     if S <> '' then Ttmp := DateTimeToTimeStamp(StrToDateTime(S));
     Dtmp := Buffer;
     Dtmp^.DateTime := TimeStampToMSecs(Ttmp);
end;


Function TKADaoTable.BooleanToBuffer(Buffer: Pointer; S: String): Boolean;
begin
     Result:=False;
     if Buffer=Nil Then Exit;
     Result := (S <> '');
     if S = ''    Then S := '0';
     if S = '-1'  Then S := '1';
     if AnsiLowerCase(S)='false' Then S := '0';
     if AnsiLowerCase(S)='true'  Then S := '1';
     if AnsiLowerCase(S)='no'    Then S := '0';
     if AnsiLowerCase(S)='yes'   Then S := '1';
     WordBool(Buffer^) := WordBool(StrToInt(S));
end;


Function TKADaoTable.BufferToDate(Buffer: Pointer): String;
var
   Ttmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
begin
     Dtmp := Buffer;
     Ttmp.Date := Dtmp^.Date;
     Result := DateToStr(TimeStampToDateTime(Ttmp));
end;


Function TKADaoTable.BufferToTime(Buffer: Pointer): String;
var
   TTmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
begin
     Dtmp := Buffer;
     Ttmp.Time := Dtmp^.Time;
     Result := FormatDateTime('hh:nn:ss', TimeStampToDateTime(Ttmp));
end;


Function TKADaoTable.BufferToDateTime(Buffer: Pointer): String;
var
   TTmp : TTimeStamp;
   Dtmp : ^TDateTimeRec;
begin
     Dtmp   := Buffer;
     Ttmp   := MsecsToTimeStamp(Dtmp.DateTime);
     Result := DateTimeToStr(TimeStampToDateTime(TTmp));
end;



//*********************************************************************************** TableName
Procedure TTableNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase : TKADaodatabase;
  X     : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.F_Database) And (DTable.F_Database.Connected) Then
       Begin
        DBase:=DTable.F_Database;
        DBase.RefreshDefinitions;
        Try
          For X := 0 to DBase.TableNames.Count-1 do Proc(DBase.TableNames.Strings[X]);
        Finally
        End;
       End;
  End;
End;

Function TTableNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;
//*********************************************************************************** QueryName

Procedure TQueryNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase : TKADaodatabase;
  X     : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.F_Database) And (DTable.F_Database.Connected) Then
       Begin
        DBase:=DTable.F_Database;
        DBase.RefreshDefinitions;
        Try
          For X := 0 to DBase.QueryDefNames.Count-1 do Proc(DBase.QueryDefNames.Strings[X]);
        Finally
        End;
       End;
  End;
End;

Function TQueryNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;
//*********************************************************************************** IndexName
Procedure TIndexNameEditor.GetValues( Proc: TGetStrProc);
Var
  DTable : TKADaoTable;
  DBase  : TKADaodatabase;
  X      : Integer;
  Count  : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
  Begin
    DTable := TKADaoTable(GetComponent(0));
    if Assigned(DTable.F_Database) And (DTable.F_Database.Connected)  Then 
    if DTable.TableName <> '' Then
       Begin
        DBase:=DTable.F_Database;
        Try
          DBase.RefreshDefinitions;
          Count :=DBase.CoreDatabase.TableDefs.Item[DTable.TableName].Indexes.Count;
          For X := 0 to  Count-1 do
              Begin
                Proc(DBase.CoreDatabase.TableDefs.Item[DTable.TableName].Indexes.Item[X].Name);
              End;
        Finally
        End;
       End;
  End;
End;


Function TIndexNameEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= Inherited GetAttributes + [paValueList, paSortList];
End;

//***************************************************************************************************************************

Function TTableTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result := Inherited GetAttributes + [paValueList, paSortList];
End;

Function  TTableTypeEditor.GetValue: string;
Begin
 if GetComponent(0) is TKADaoTable then
    Begin
      Result:='StandardTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenTable       then Result:='StandardTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenDynaset     then Result:='DynasetTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenDynamic     then Result:='DynamicTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenSnapshot    then Result:='SnapshotTable';
      if TKADaoTable(GetComponent(0)).F_TableType=dbOpenForwardOnly then Result:='ForwardOnlyTable';
    End;
End;

Procedure TTableTypeEditor.GetValues( Proc: TGetStrProc);
Begin
  if GetComponent(0) is TKADaoTable then
     Begin
       Proc('StandardTable');
       Proc('DynasetTable');
       Proc('DynamicTable');
       Proc('SnapshotTable');
       Proc('ForwardOnlyTable');
     End;
End;


Procedure TTableTypeEditor.SetValue(const Value: string);
Var
 Dat : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
       Begin
       Dat:=dbOpenTable;
       if Value='StandardTable'    Then Dat:=dbOpenTable;
       if Value='DynasetTable'     Then Dat:=dbOpenDynaset;
       if Value='DynamicTable'     Then Dat:=dbOpenDynamic;
       if Value='SnapshotTable'    Then Dat:=dbOpenSnapshot;
       if Value='ForwardOnlyTable' Then Dat:=dbOpenForwardOnly;
       Inherited SetValue(IntToStr(Dat));
       Modified;
     End;
End;

//***************************************************************************************************************************

Function TLockTypeEditor.GetAttributes: TPropertyAttributes;
Begin
  Result := Inherited GetAttributes + [paValueList, paSortList];
End;

Function  TLockTypeEditor.GetValue: string;
Begin
 if GetComponent(0) is TKADaoTable then
    Begin
      Result:='dbPessimistic';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbPessimistic       then Result:='dbPessimistic';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbOptimistic        then Result:='dbOptimistic';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbOptimisticValue   then Result:='dbOptimisticValue';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbReadOnly          then Result:='dbReadOnly';
      if TKADaoTable(GetComponent(0)).F_LockType=DAOApi.dbOptimisticBatch   then Result:='dbOptimisticBatch';
    End;
End;

Procedure TLockTypeEditor.GetValues( Proc: TGetStrProc);
Begin
  if GetComponent(0) is TKADaoTable then
     Begin
       Proc('dbPessimistic');
       Proc('dbOptimistic');
       Proc('dbOptimisticValue');
       Proc('dbReadOnly');
       Proc('dbOptimisticBatch');
     End;
End;

                                                                  
Procedure TLockTypeEditor.SetValue(const Value: string);
Var
 Dat : Integer;
Begin
  if GetComponent(0) is TKADaoTable then
       Begin
       Dat:=DAOApi.dbPessimistic;
       if Value='dbPessimistic'     Then Dat:=DAOApi.dbPessimistic;
       if Value='dbOptimistic'      Then Dat:=DAOApi.dbOptimistic;
       if Value='dbOptimisticValue' Then Dat:=DAOApi.dbOptimisticValue;
       if Value='dbReadOnly'        Then Dat:=DAOApi.dbReadOnly;
       if Value='dbOptimisticBatch' Then Dat:=DAOApi.dbOptimisticBatch;
       Inherited SetValue(IntToStr(Dat));
       Modified;
     End;
End;


Function TSortByEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TSortByEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TSortByEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

procedure TSortByEditor.Edit;
Var
 DT:TKADaoTable;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if NOT (DT.F_Database.Connected) Then Exit;
    if (DT.Active=False) And (Not (csLoading in DT.ComponentState)) Then
       Begin
         Try
           DT.Active:=True;
           DT.Active:=False;
         Except
           DT.F_SortedBy.Clear;
           DT.F_FieldNames.Clear;
           DatabaseError('Cannot obtain field names!');
           Exit;
         End;
       End;
    Application.CreateForm(TSortByDialog,SortDialog);
    if SortDialog.Execute(DT.F_FieldNames,DT.F_SortedBy) Then
       Begin
         DT.SortedBy:=DT.F_SortedBy;
       End;
    SortDialog.Free;
  End;
End;

Function TQueryDefParamsEditor.GetValue: string;
Begin
 Result := '(TStringList)'
End;

Function TQueryDefParamsEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TQueryDefParamsEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

procedure TQueryDefParamsEditor.Edit;
Var
 DT      : TKADaoTable;
 X       : Integer;
 Dir     : Integer;
 NP      : Integer;
 Typ     : Integer;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    if NOT (DT.F_Database.Connected) Then Exit;
    if DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters.Count=0 Then
       Begin
         DatabaseError('This QueryDef object has NO parameters!');
         Exit;
       End;
    DT.F_QD_ParamNames.Clear;
    DT.F_QD_ParamDaoTypes.Clear;
    DT.F_QD_ParamBDETypes.Clear;
    Try
     NP:=0;
     For X := 0 To DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters.Count-1 do
        Begin
          Dir:= DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters[X].Direction;
          if (Dir=dbParamInput) Or (Dir=dbParamInputOutput) Then
             Begin
              Inc(NP);
              {$IFDEF DYNADAO}
              Typ :=DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters[X].Type;
              {$ELSE}
              Typ :=DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters[X].Type_;
              {$ENDIF}
              if (Typ=dbDate) Then Typ:=dbTimeStamp;
              DT.F_QD_ParamNames.Add(DT.Database.CoreDatabase.QueryDefs.Item[DT.QueryDefName].Parameters[X].Name);     
              DT.F_QD_ParamDaoTypes.Add(GetDaoFieldTypeNames(Typ));
              DT.F_QD_ParamBDETypes.Add(GetBDEFieldTypeNames(DaoToBDE(Typ)));
             End;
        End;
     if NP=0 Then
        Begin
           DatabaseError('This QueryDef object has NO INPUT parameters!');
           Exit;
        End;
    Except
      DatabaseError('Cannot obtain QueryDef Parameters');
      Exit;
    End;
    Application.CreateForm(TQueryDefDialog,QueryDefDialog);
    if QueryDefDialog.Execute(DT.F_QD_ParamNames,DT.F_QD_ParamDaoTypes,DT.F_QD_ParamBDETypes,DT.F_QueryDefParameters) Then;
    QueryDefDialog.Free;
    Modified;
  End;
End;


//***************************************************************************************************************************
Function TMasterFieldsEditor.GetAttributes: TPropertyAttributes;
Begin
  Result:= [paDialog];
End;

Procedure TMasterFieldsEditor.SetValue(const Value: string);
Begin
if GetComponent(0) is TKADaoTable then
  Begin
    inherited SetValue(Value);
    Modified;
  End;
End;

procedure TMasterFieldsEditor.Edit;
Var
 MT,DT        : TKADaoTable;
 MF,DF,TF     : TStrings;
Begin
 if GetComponent(0) is TKADaoTable then
  Begin
    DT:=GetComponent(0) AS TKADaoTable;
    If Not (DT.F_Database.Connected) Then Exit;
    if Not Assigned(DT.MasterSource) Then
       Begin
        DT.F_Master.Clear;
        DT.F_Detail.Clear;
        DT.F_MasterFields.Clear;
        DatabaseError('MasterSource not defined!');
        Exit;
       End;
    if NOT (DT.MasterSource.DataSet is TKADaoTable) Then
       Begin
        DT.F_Master.Clear;
        DT.F_Detail.Clear;
        DT.F_MasterFields.Clear;
        DatabaseError('Cannot link to other datasets exept KADaoTable''s!');
        Exit;
       End;
    MT:=DT.MasterSource.DataSet As TKADaoTable;
    if (DT.Active=False) and Not (csLoading in DT.ComponentState) Then
       Begin
         Try
           DT.Active:=True;
           DT.Active:=False;
         Except
           DT.F_Master.Clear;
           DT.F_Detail.Clear;
           DT.F_MasterFields.Clear;
           DatabaseError('Cannot obtain detail field names!');
           Exit;
         End;
       End;
    if (MT.Active=False) and Not (csLoading in DT.ComponentState) Then
       Begin
         Try
           MT.Active:=True;
           MT.Active:=False;
         Except
           DT.F_Master.Clear;
           DT.F_Detail.Clear;                              
           DT.F_MasterFields.Clear;
           DatabaseError('Cannot obtain master field names!');
           Exit;
         End;
       End;
    MF     := TStringList.Create;
    DF     := TStringList.Create;
    TF     := TStringList.Create;
    MF.SetText(MT.F_MDFieldNames.GetText);
    DF.SetText(DT.F_MDFieldNames.GetText);
    TF.SetText(DT.F_MasterFields.GetText);
    Application.CreateForm(TMasterDetailForm,MasterDetailForm);
    if MasterDetailForm.Execute(DF,MF,TF) Then;
    MasterDetailForm.Free;
    DT.MasterFields:=TF;
    MF.Free;
    DF.Free;
    TF.Free;
    Modified;
  End;
End;

function TMasterSourcePropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result:= [paValueList, paSortList];
end;


function TMasterSourcePropertyEditor.GetValue: String;
var
  Tab: TKADaoTable;
begin
  Result:= '';
  Tab:= TKADaoTable(GetComponent(0));
  if Tab.MasterSource <> NIL then Result:= Tab.MasterSource.Name
  else Result:= '';
end;

procedure TMasterSourcePropertyEditor.GetValues(Proc: TGetStrProc);
var
  Tab: TKADaoTable;
  DS : TDataSource;
  I  : Integer;
begin
  Tab:= TKADaoTable(GetComponent(0));
  if Tab.Owner = NIL then EXIT;
  for I:= 0 to Tab.Owner.ComponentCount - 1 do
    begin
      DS:= NIL;
      if Tab.Owner.Components[i] is TDataSource then DS:= TDataSource(Tab.Owner.Components[i]);
      if (DS <> NIL) and (DS.DataSet <> Tab) then Proc(DS.Name);
    end;
end;

procedure TMasterSourcePropertyEditor.SetValue(const Value: String);
var
  Tab  : TKADaoTable;
  Comp : TComponent;
begin
  Tab:= TKADaoTable(GetComponent(0));
  if Value = '' then
    begin
      Tab.MasterSource:= NIL;
      EXIT;
    end;
  if Tab.Owner = NIL then EXIT;
  Comp:= Tab.Owner.FindComponent(Value);
  if (Comp = NIL) or not(Comp is TDataSource) then EXIT;
  if NOT ((Comp AS TDataSource).DataSet is TKADaoTable) Then
       Begin
        DatabaseError('Cannot link to other datasets exept KADaoTable''s!');
        Exit;
       End;
  Tab.MasterSource:= TDataSource(Comp);
  Modified;
end;
//***************************************************************************************************************************

Procedure Register;
begin
    RegisterComponents('KA Dao', [TKADaoTable]);
    RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'TableName',TTableNameEditor);
    RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'QueryDefName',TQueryNameEditor);
    RegisterPropertyEditor(TypeInfo(String),TKADaoTable,'IndexName',TIndexNameEditor);
    RegisterPropertyEditor(TypeInfo(Integer),TKADaoTable,'TableType',TTableTypeEditor);
    RegisterPropertyEditor(TypeInfo(Integer),TKADaoTable,'LockType',TLockTypeEditor);
    RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'SortedBy',TSortByEditor);
    RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'QueryDefParameters',TQueryDefParamsEditor);
    RegisterPropertyEditor(TypeInfo(TDataSource), TKADaoTable, 'MasterSource', TMasterSourcePropertyEditor);
    RegisterPropertyEditor(TypeInfo(TStrings),TKADaoTable,'MasterFields',TMasterFieldsEditor);
end;
end.


