unit DaoUtils;
//******************************************************************************
//                    Delphi Dao Project Version 1.9
//                 Copyright (c) 2000 by Kiril Antonov
//******************************************************************************
{$DEFINE BULGARIAN}
interface
Uses Db;
  Function RemoveNonDigitChars(DT:String):String;
  Function RemoveNonDigitChars_II(DT:String):String;
  Function DaoSizeToBDESize(DaoType:Integer;DaoSize:Integer):Integer;
  Function DaoToBDE(DaoType:Integer):TFieldType;
  Function GetBDEFieldTypeNames(BDEType:TFieldType):String;
  Function GetDaoFieldTypeNames(DaoType:Integer):String;
implementation
Uses
DAOApi,Windows,SysUtils,Dialogs,Registry;

Function RemoveNonDigitChars(DT:String):String;
Var
  Allow  : String;
  Reg    : TRegistry;
  X,L,P  : Integer;
  LDS,SDS: String;
Begin
  Result:=DT;
  L:=Length(DT);
  if L=0 Then Exit;
  Allow := '1234567890';
  //****************************************************** FOR BULGARIAN LANGUAGE ONLY
  {$IFDEF BULGARIAN}
  P:=Pos('.',DT);
  if P > 0 Then Delete(DT,P,2);
  {$ENDIF}
  //****************************************************** FOR BULGARIAN LANGUAGE ONLY
  Reg   := TRegistry.Create;
  Try
   Reg.RootKey := HKEY_CURRENT_USER;
   if Reg.OpenKey('Control Panel\International',False) Then
     Begin
       Allow:=Allow+Reg.ReadString('sDate');
       Allow:=Allow+Reg.ReadString('sTime');
       SDS:=Reg.ReadString('sShortDate');
       LDS:=Reg.ReadString('sLongDate');
     End;
  Finally
   Reg.Free;
  End;
  For X:=1 to L do
      Begin
       if Pos(DT[X],Allow)=0 Then DT[X]:=' ';
      End;
  Repeat
    P:= Pos('  ',DT);
    if P > 0 Then Delete(DT,P,1);
  Until P=0;
  Result:=DT;
End;

Function RemoveNonDigitChars_II(DT:String):String;
Var
 P: Integer;
Begin
 Result:=DT;
 P:=Pos(' ',Result);
 if P > 0 Then Result:=Copy(Result,1,P-1);
End;

Function DaoSizeToBDESize(DaoType:Integer;DaoSize:Integer):Integer;
Begin
 Result:=0;
 Case DaoType of
        dbBoolean    : Result := 0;
        dbByte       : Result := 0;
        dbInteger    : Result := 0;
        dbLong       : Result := 0;
        dbCurrency   : Result := 0;
        dbSingle     : Result := 0;
        dbDouble     : Result := 0;
        dbDate       : Result := 0;
        dbBinary     : Result := DaoSize;
        dbText       : Result := DaoSize;
        dbLongBinary : Result := DaoSize;
        dbMemo       : Result := DaoSize;
        dbGUID       : Result := 0;
        dbBigInt     : Result := 0;
        dbVarBinary  : Result := DaoSize;
        dbChar       : Result := DaoSize;
        dbNumeric    : Result := 0;
        dbDecimal    : Result := 0;
        dbFloat      : Result := 0;
        dbTime       : Result := 0;
        dbTimeStamp  : Result := 0;
 End;
End;

Function DaoToBDE(DaoType:Integer):TFieldType;
Begin
 Result:=ftUnknown;
 Case DaoType of
        dbBoolean    : Result := ftBoolean;
        dbByte       : Result := ftInteger;
        dbInteger    : Result := ftInteger;
        dbLong       : Result := ftInteger;
        dbCurrency   : Result := ftCurrency;
        dbSingle     : Result := ftFloat;
        dbDouble     : Result := ftFloat;
        dbDate       : Result := ftDate;
        dbBinary     : Result := ftBlob;
        dbText       : Result := ftString;
        dbLongBinary : Result := ftBlob;
        dbMemo       : Result := ftMemo;
        dbGUID       : Result := ftAutoInc;
        dbBigInt     : Result := ftInteger;
        dbVarBinary  : Result := ftBlob;
        dbChar       : Result := ftString;
        dbNumeric    : Result := ftFloat;
        dbDecimal    : Result := ftFloat;
        dbFloat      : Result := ftFloat;
        dbTime       : Result := ftTime;
        dbTimeStamp  : Result := ftDateTime;
 End;
End;

Function GetBDEFieldTypeNames(BDEType:TFieldType):String;
Begin
 Result:='ftUnknown';
 Case BDEType of
        ftBoolean    : Result := 'ftBoolean';
        ftInteger    : Result := 'ftInteger';
        ftCurrency   : Result := 'ftCurrency';
        ftFloat      : Result := 'ftFloat';
        ftDate       : Result := 'ftDate';
        ftBlob       : Result := 'ftBlob';
        ftString     : Result := 'ftString';
        ftMemo       : Result := 'ftMemo';
        ftAutoInc    : Result := 'ftAutoInc';
        ftTime       : Result := 'ftTime';
        ftDateTime   : Result := 'ftDateTime';
 End;
End;

Function GetDaoFieldTypeNames(DaoType:Integer):String;
Begin
 Result:='dbUnknown';
 Case DaoType of
        dbBoolean    : Result := 'dbBoolean';
        dbByte       : Result := 'dbByte';
        dbInteger    : Result := 'dbInteger';
        dbLong       : Result := 'dbLong';
        dbCurrency   : Result := 'dbCurrency';
        dbSingle     : Result := 'dbSingle';
        dbDouble     : Result := 'dbDouble';
        dbDate       : Result := 'dbDate';
        dbBinary     : Result := 'dbBinary';
        dbText       : Result := 'dbText';
        dbLongBinary : Result := 'dbLongBinary';
        dbMemo       : Result := 'dbMemo';
        dbGUID       : Result := 'dbGUID';
        dbBigInt     : Result := 'dbBigInt';
        dbVarBinary  : Result := 'dbVarBinary';
        dbChar       : Result := 'dbChar';
        dbNumeric    : Result := 'dbNumeric';
        dbDecimal    : Result := 'dbDecimal';
        dbFloat      : Result := 'dbFloat';
        dbTime       : Result := 'dbTime';
        dbTimeStamp  : Result := 'dbTimeStamp';
 End;
End;

end.
