unit UnitMenuItems;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, ExtCtrls, Menus, MainMenu97, ImgList;

type
  TFormMenuItems = class(TForm)
    Panel1: TPanel;
    TreeView: TTreeView;
    Panel2: TPanel;
    Panel3: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    ImageList1: TImageList;
    OpenDialog: TOpenDialog;
    PopupMenu1: TPopupMenu;
    Bitmap1: TMenuItem;
    Limpiar1: TMenuItem;
    ScrollBox: TScrollBox;
    ButtonBitmap: TBitBtn;
    ButtonClear: TBitBtn;
    Image: TImage;
    Bevel1: TBevel;
    Panel4: TPanel;
    Label1: TLabel;
    ComboBoxColor: TComboBox;
    CheckBoxConvert: TCheckBox;
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ButtonBitmapClick(Sender: TObject);
    procedure TreeViewChange(Sender: TObject; Node: TTreeNode);
    procedure Limpiar1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ComboBoxColorChange(Sender: TObject);
    procedure ImageDblClick(Sender: TObject);
  private
    FMainMenu : TMainMenu;
    procedure SetMainMenu (AMainMenu : TMainMenu);
    function GetMenuItemBitmaps (index : integer) : TMenuItemBitmap;
    function GetCount : integer;
    procedure GetColorValue (const s : string);
    procedure SyncBitmap;
  protected
    procedure WMGetMinMaxInfo (var Msg: Tmessage); message WM_GETMINMAXINFO;
  public
    Modified : boolean;
    property MainMenu : TMainMenu read FMainMenu write SetMainMenu;
    property MenuItemBitmaps [index : integer] : TMenuItemBitmap read GetMenuItemBitmaps;
    property Count : integer read GetCount;
  end;

implementation

uses
  ImageZoom;

{$R *.DFM}

function TFormMenuItems.GetCount;
begin
  Result := TreeView.Items.Count;
end;

function TFormMenuItems.GetMenuItemBitmaps;
begin
  Result := TreeView.Items [index].Data;
end;

procedure TFormMenuItems.SetMainMenu;
var
  i : integer;
procedure AddMenuItem (MenuItem : TMenuItem);
var
  j : integer;
  TreeNode, Node : TTreeNode;
  Rec : TMenuItemBitmap;
begin
  Rec := TMenuItemBitmap.Create;
  Rec.MenuItem := MenuItem;
  TreeNode := TreeView.Items.AddChildObject (TreeView.Selected, Format ('%s: %s', [MenuItem.Name, MenuItem.Caption]), Rec);
  TreeNode.ImageIndex := 1;
  for j := 0 to MenuItem.Count - 1 do
    begin
      TreeView.Selected := TreeNode;
      if MenuItem.Items [j].Caption <> '-'
        then
        begin
          Rec := TMenuItemBitmap.Create;
          Rec.MenuItem := MenuItem.Items [j];
          Node := TreeView.Items.AddChildObject (TreeView.Selected, Format ('%s: %s', [MenuItem.Items [j].Name, MenuItem.Items [j].Caption]), Rec);
          Node.ImageIndex := 2;
        end
        else
        begin
          Node := TreeView.Items.AddChild (TreeView.Selected, '-');
          Node.ImageIndex := 3;
        end;
      if MenuItem.Items [j].Count > 0
        then AddMenuItem (MenuItem.Items [j]);
    end;
end;
begin
  if FMainMenu <> AMainMenu
    then
    begin
      FMainMenu := AMainMenu;
      TreeView.Items.Clear;
      for i := 0 to MainMenu.Items.Count - 1 do
        begin
          TreeView.Selected := nil;
          AddMenuItem (MainMenu.Items [i]);
        end;
    end;
end;

procedure TFormMenuItems.FormShow(Sender: TObject);
begin
  TreeView.FullExpand;
  if TreeView.Items.Count > 0
    then TreeView.Selected := TreeView.Items [0];
  TreeViewChange(TreeView, TreeView.Selected);
end;

procedure TFormMenuItems.WMGetMinMaxInfo;
begin
  inherited;
  with PMinMaxInfo(MSG.lparam)^ do
    with ptMinTrackSize do
      begin
        X := 332;
        Y := 130;
      end;
end;

procedure TFormMenuItems.FormDestroy(Sender: TObject);
var
  i : integer;
begin
  for i := 0 to TreeView.Items.Count - 1 do
    if TreeView.Items [i].Data <> nil
      then TMenuItemBitmap (TreeView.Items [i].Data).Free;
end;

procedure TFormMenuItems.SyncBitmap;
var
  LastColor, NewColor : TColor;
  x, y : integer;
begin
  with TreeView.Selected do
    begin
      if TMenuItemBitmap (Data).Bitmap = nil
        then TMenuItemBitmap (Data).Bitmap := TBitmap.Create;
      with TMenuItemBitmap (Data) do
        begin
          Bitmap.Assign (Image.Picture.Graphic);
          if not Bitmap.Empty
            then
            begin
              NewColor := StringToColor (ComboBoxColor.Text);
              if CheckBoxConvert.Checked
                then
                begin
                  LastColor := Bitmap.Canvas.Pixels [0, Bitmap.Height - 1];
                  for x := 0 to Bitmap.Width - 1 do
                    for y := 0 to Bitmap.Height - 1 do
                      if Bitmap.Canvas.Pixels [x, y] = LastColor
                        then Bitmap.Canvas.Pixels [x, y] := NewColor;
                end;
              Bitmap.Canvas.Pixels [0, Bitmap.Height - 1] := NewColor;
              Image.Picture.Assign (Bitmap);
            end;
        end;
    end;
end;

procedure TFormMenuItems.ButtonBitmapClick(Sender: TObject);
begin
  if OpenDialog.Execute
    then
    begin
      Modified := true;
      Image.Picture.LoadFromFile (OpenDialog.FileName);
      ComboBoxColor.Text := ColorToString (Image.Picture.Bitmap.TransparentColor xor $02000000);
      ComboBoxColor.Enabled := true;
      Image.Enabled := true;
      with TreeView.Selected do
        if Data <> nil
          then SyncBitmap;
    end;
end;

procedure TFormMenuItems.TreeViewChange(Sender: TObject; Node: TTreeNode);
begin
  ButtonBitmap.Enabled := (TreeView.Selected <> nil) and (TreeView.Selected.ImageIndex <> 3);
  ButtonClear.Enabled := ButtonBitmap.Enabled;
  if TreeView.Selected <> nil
    then with TreeView.Selected do
      if (Data <> nil) and (TMenuItemBitmap (Data).Bitmap <> nil) and (not (TMenuItemBitmap (Data).Bitmap.Empty))
        then
        begin
          Image.Picture.Assign (TMenuItemBitmap (Data).Bitmap);
          ComboBoxColor.Text := ColorToString (Image.Picture.Bitmap.TransparentColor xor $02000000);
        end
        else Image.Picture.Assign (nil)
    else Image.Picture.Assign (nil);
  if Image.Picture.Bitmap.Empty
    then
    begin
      ComboBoxColor.Text := '';
      ComboBoxColor.Enabled := false;
    end
    else ComboBoxColor.Enabled := true;
  Image.Enabled := ComboBoxColor.Enabled;
end;

procedure TFormMenuItems.Limpiar1Click(Sender: TObject);
begin
  Modified := true;
  Image.Picture.Assign (nil);
  ComboBoxColor.Text := '';
  ComboBoxColor.Enabled := false;
  with TreeView.Selected do
    if Data <> nil
      then
      begin
        TMenuItemBitmap (Data).Bitmap.Free;
        TMenuItemBitmap (Data).Bitmap := nil;
      end;
end;

procedure TFormMenuItems.GetColorValue;
begin
  ComboBoxColor.Items.Add (s);
end;

procedure TFormMenuItems.FormCreate(Sender: TObject);
begin
  GetColorValues (GetColorValue);
end;

procedure TFormMenuItems.ComboBoxColorChange(Sender: TObject);
begin
  Modified := true;
  SyncBitmap;
end;

procedure TFormMenuItems.ImageDblClick(Sender: TObject);
begin
  FormZoom := TFormZoom.Create (Application);
  try
    FormZoom.Left := Image.ClientOrigin.X + Image.Width div 2 - FormZoom.Width div 2;
    FormZoom.Top := Image.ClientOrigin.Y + Image.Height div 2 - FormZoom.Height div 2;
    FormZoom.Image.Picture.Assign (Image.Picture);
    FormZoom.Show;
  except
    FormZoom.Free;
  end;
end;

end.
