unit OptionBox97;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TB97Ctls, Menus;

type
  TOptionBox97 = class(TToolbarButton97)
  private
    PopupMenu : TPopupMenu;
    FItems : TStrings;
    FItemIndex : integer;
    FDropDownOnClick : boolean;
    OldOnClick : TNotifyEvent;
    FOnItemSelected : TNotifyEvent;
    FChangeCaptionOnSelect : boolean;
    FOldOnClicks : TList;
    FInitializing : boolean;
    procedure SetItems (AItems : TStrings);
    procedure MenuItemClick (Sender : TObject);
    procedure ButtonClick (Sender : TObject);
    procedure SetItemIndex (value : integer);
    procedure StringListChanged (Sender : TObject);
    procedure AssignMenus;
    procedure AssignEvents;
    procedure SetChangeCaptionOnSelect (value : boolean);
    function GetDropDownMenu : TPopupMenu;
    procedure SetDropDownMenu (AMenu : TPopupMenu);
  protected
    NoModifyTag : boolean;
    procedure Loaded; override;
    property Initializing : boolean read FInitializing;
  public
    constructor Create (AOwner : TComponent); override;
    destructor Destroy; override;
    procedure Initialize;
    procedure Click; override;
  published
    property Items : TStrings read FItems write SetItems;
    property DropDownOnClick : boolean read FDropDownOnClick write FDropDownOnClick default false;
    property ChangeCaptionOnSelect : boolean read FChangeCaptionOnSelect write SetChangeCaptionOnSelect default true;
    property OnItemSelected : TNotifyEvent read FOnItemSelected write FOnItemSelected;
    property ItemIndex : integer read FItemIndex write SetItemIndex;
    property DropDownMenu : TPopupMenu read GetDropDownMenu write SetDropDownMenu;
  end;

procedure Register;

implementation

constructor TOptionBox97.Create;
begin
  inherited Create (AOwner);
  FItems := TStringList.Create;
  FItemIndex := -1;
  FChangeCaptionOnSelect := true;
  FOldOnClicks := TList.Create;
  if not (csDesigning in ComponentState)
    then PopupMenu := TPopupMenu.Create (self);
end;

destructor TOptionBox97.Destroy;
begin
  FItems.Free;
  while FOldOnClicks.Count > 0 do
    begin
      if FOldOnClicks [0] <> nil
        then dispose (@TMethod (FOldOnClicks [0]^));
      FOldOnClicks.Delete (0);
    end;
  FOldOnClicks.Free;
  if not (csDesigning in ComponentState)
    then PopupMenu.Free;
  inherited Destroy;
end;

procedure TOptionBox97.Initialize;
begin
  FInitializing := true;
  try
    if not (csDesigning in ComponentState)
      then
      begin
        if (DropDownMenu = nil)
          then
          begin
            DropDownMenu := PopupMenu;
            AssignMenus;
          end
          else AssignEvents;
        (FItems as TStringList).OnChange := StringListChanged;
        if FDropDownOnClick
          then
          begin
            OldOnClick := OnClick;
            OnClick := ButtonClick;
          end;
        if DropDownMenu.Items.Count <= 0
          then
          begin
            DropDownMenu := nil;
            DropDownCombo := false;
            DropDownArrow := false;
         end;
      end;
  finally
    FInitializing := false;
  end;
  SetItemIndex (FItemIndex);
end;

procedure TOptionBox97.SetItems;
begin
  FItems.Assign (AItems);
end;

procedure TOptionBox97.MenuItemClick;
var
  Event : TNotifyEvent;
begin
  if FChangeCaptionOnSelect
    then Caption := (Sender as TMenuItem).Caption;
  FItemIndex := (Sender as TMenuItem).Tag;
  if (Sender as TMenuItem).MenuIndex < FOldOnClicks.Count
    then if FOldOnClicks [(Sender as TMenuItem).MenuIndex] <> nil
      then
      begin
        Event := TNotifyEvent (FOldOnClicks [(Sender as TMenuItem).MenuIndex]^);
        Event (Sender);
      end;
  if assigned (FOnItemSelected)
    then FOnItemSelected (self);
end;

procedure TOptionBox97.SetChangeCaptionOnSelect;
begin
  if value <> FChangeCaptionOnSelect
    then
    begin
      FChangeCaptionOnSelect := value;
      SetItemIndex (FItemIndex);
    end;
end;

procedure TOptionBox97.Click;
begin
  if FDropDownOnClick and (assigned (OldOnClick)) and (DropDownMenu <> nil) and (not DropDownCombo)
    then OldOnClick (self)
    else if (not DropDownCombo) and (not FDropDownOnClick) and (assigned (OnClick)) and (DropDownMenu <> nil)
      then OnClick (self);
  inherited Click;
end;

procedure TOptionBox97.ButtonClick;
var
  Point : TPoint;
begin
  if assigned (OldOnClick)
    then OldOnClick (self);
  if (DropDownMenu <> nil) and (DropDownMenu.Items.Count > 0)
    then
    begin
      Point.X := 0;
      Point.Y := Height;
      Point := ClientToScreen (Point);
      DropDownMenu.Popup (Point.X, Point.Y);
    end;
end;

procedure TOptionBox97.SetItemIndex;
begin
  try
    if (not (csReading in ComponentState)) and (not Initializing)
      then if FChangeCaptionOnSelect
        then if value <> -1
          then if not (csDesigning in ComponentState)
            then Caption := DropDownMenu.Items.Items [Value].Caption
            else if DropDownMenu <> nil
              then Caption := DropDownMenu.Items.Items [Value].Caption
              else Caption := FItems [value]
          else Caption := '';
  except
    raise Exception.Create ('ItemIndex out of bounds');
  end;
  FItemIndex := Value;
end;

function TOptionBox97.GetDropDownMenu;
begin
  Result := inherited DropDownMenu;
end;

procedure TOptionBox97.SetDropDownMenu;
begin
  inherited DropDownMenu := AMenu;
  SetItemIndex (FItemIndex);
end;

procedure TOptionBox97.AssignMenus;
var
  i : integer;
begin
  if DropDownMenu.Items <> nil
    then with DropDownMenu.Items do
      while Count > 0 do
        Remove (Items [0]);
  for i := 0 to FItems.Count - 1 do
    begin
      DropDownMenu.Items.Add (TMenuItem.Create (PopupMenu));
      with DropDownMenu.Items.Items [i] do
        begin
          Caption := FItems [i];
          OnClick := MenuItemClick;
          if not NoModifyTag
            then Tag := i;
        end;
    end;
end;

procedure TOptionBox97.AssignEvents;
var
  i : integer;
  Met : ^TMethod;
begin
  FItems.Clear;
  if DropDownMenu.Items <> nil
    then with DropDownMenu.Items do
      for i := 0 to Count - 1 do
        begin
          with Items [i] do
            begin
              if assigned (OnClick)
                then
                begin
                  new (Met);
                  with TMethod (OnClick) do
                    begin
                      Met.Code := Code;
                      Met.Data := Data;
                    end;
                end
                else Met := nil;
              FOldOnClicks.Add (Met);
              OnClick := MenuItemClick;
              if not NoModifyTag
                then Tag := i;
              FItems.Add (Caption);
            end;
        end;
  PopupMenu.Free;
  PopupMenu := nil;
end;

procedure TOptionBox97.StringListChanged;
begin
  AssignMenus;
end;

procedure TOptionBox97.Loaded;
begin
  inherited Loaded;
  Initialize;
end;

procedure Register;
begin
  RegisterComponents('New', [TOptionBox97]);
end;

end.
