unit MouseHook;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, BaseHook;

type
  TMouseHook = class(TBaseHook)
  private
    FMouseHookStruct : TMouseHookStruct;
  protected
    procedure AssignStruct (address : Pointer); override;
    procedure FillParams (var AIdHook : Integer; var AHHookAddr : PHandle; var AInstallCountAddr : PInteger;
                          var HookProc : Pointer; var AHooksList : TList); override;
  public
    property MouseHookStruct : TMouseHookStruct read FMouseHookStruct;
  end;

procedure Register;

implementation

var
  MouseHooks : TList;
  HHook : THandle;
  InstallCount : Integer;

function MouseProc (nCode : integer; wParam : integer; lParam : Longint) : longint; stdcall;
begin
  Result := HookProc (HHook, MouseHooks, nCode, wParam, lParam);
end;

{ TMouseHook }


procedure TMouseHook.AssignStruct;
begin
  FMouseHookStruct := TMouseHookStruct (address^);
end;

procedure TMouseHook.FillParams;
begin
  AIdHook := WH_MOUSE;
  AHHookAddr := @HHook;
  AInstallCountAddr := @installCount;
  HookProc := @MouseProc;
  AHooksList := MouseHooks;
end;          

{ Register Proc }

procedure Register;
begin
  RegisterComponents('Misc2', [TMouseHook]);
end;

initialization
  InstallCount := 0;
  MouseHooks := TList.Create;
finalization
  MouseHooks.Free;
end.
