unit MainMenu97Reg;

interface

uses
  Classes, MainMenu97, DsgnIntf;

type
  TMenuItemBitmapsProperty = class (TClassProperty)
  public
    MenuBitmaps : TMenuItemBitmaps;
    MainMenu97 : TMainMenu97;
    function GetAttributes : TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

uses
  SysUtils, UnitMenuItems, Graphics, Controls, Forms, Dialogs;

type
  ExposeMenuBitmaps = class (TMenuItemBitmaps)
  private
    function GetMainMenu97 : TMainMenu97;
  public
    property MainMenu97 : TMainMenu97 read GetMainMenu97;
  end;

function ExposeMenuBitmaps.GetMainMenu97;
begin
  Result := inherited MainMenu97;
end;

function TMenuItemBitmapsProperty.GetAttributes;
begin
  Result := [paReadOnly, paDialog];
end;

procedure TMenuItemBitmapsProperty.Edit;
var
  Dialog : TFormMenuItems;
  i : integer;
  Item : TMenuItemBitmap;
  Bitmap, Bitmap2 : TBitmap;
begin
  {$IfDEF VER130}
  MessageDlg ('It''s recommended that you use ImageList and ImageIndex with your ' +
              'original menus to assign bitmaps in Delphi 5. Any bitmap Assigned using ' +
              'this dialog won''t work in Delphi 5. It''s included only for compatibility ' +
              'with older version of TMainMenu97.', mtWarning, [mbOk], 0);
  {$EndIf}            
  MenuBitmaps := TMenuItemBitmaps (GetOrdValue);
  MainMenu97 := ExposeMenuBitmaps (MenuBitmaps).MainMenu97;
  if MainMenu97.MainMenu <> nil
    then
    begin
      Dialog := TFormMenuItems.Create (Application);
      Dialog.Caption := GetName + ' Property';
      try
        Dialog.MainMenu := MainMenu97.MainMenu;
        for i := 0 to Dialog.Count - 1 do
          begin
            Item := Dialog.MenuItemBitmaps [i];
            try
              Bitmap := MenuBitmaps [Item.MenuItem];
              if (Bitmap <> nil) and (not Bitmap.Empty)
                then
                begin
                  Item.Bitmap := TBitmap.Create;
                  Item.Bitmap.Assign (Bitmap);
                end;
            except
            end;
          end;
        if Dialog.ShowModal = mrOk
          then
          begin
            if Dialog.Modified
              then Modified;
            MenuBitmaps.Clear;
            for i := 0 to Dialog.Count - 1 do
              begin
                if Dialog.MenuItemBitmaps [i] <> nil
                  then
                  begin
                    Bitmap := Dialog.MenuItemBitmaps [i].Bitmap;
                    if (Bitmap <> nil) and (not Bitmap.Empty)
                      then
                      begin
                        Bitmap2 := TBitmap.Create;
                        Bitmap2.Assign (Bitmap);
                        MenuBitmaps.Add (Dialog.MenuItemBitmaps [i].MenuItem, Bitmap2);
                      end;
                  end;
              end;
          end;
      finally
        Dialog.Free;
      end;
    end
    else raise Exception.Create ('There''s no a main menu assigned');
end;

procedure Register;
begin
  RegisterComponents('New', [TMainMenu97]);
  RegisterPropertyEditor (TypeInfo (TMenuItemBitmaps), TMainMenu97, '', TMenuItemBitmapsProperty);
end;

end.
