{
  Author: Jos Sebastin Battig
  E-Mail: k2xt@iname.com
  Version: 3.0
}

unit MainMenu97;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TB97, TB97Tlbr, TB97Ctls, Menus, KeyboardHook, OptionBox97, ExtCtrls, MouseHook;

const
  WM_PROCESSRESIZE = WM_USER + 1;
  WM_SHOWPOPUP = WM_USER + 2;
  WM_RAISEBUTTON = WM_USER + 3;
  WM_SYNCHRONIZE = WM_USER + 4;

type
  TWhatDo = (wdDelete, wdHide, wdNothing);

  TMainMenu97 = class;
  TMenuItemBitmap = class
  public
    MenuName : string;
    MenuItem : TMenuItem;
    Bitmap : TBitmap;
    destructor Destroy; override;
  end;

  TMenuItemBitmaps = class (TPersistent)
  private
    ABitmaps : TList;
    FMainMenu97 : TMainMenu97;
    function GetBitmaps (index : TMenuItem) : TBitmap;
    procedure SetBitmaps (index : TMenuItem; ABitmap : TBitmap);
    procedure ReadData (Stream : TStream);
    procedure WriteData (Stream : TStream);
  protected
    property MainMenu97 : TMainMenu97 read FMainMenu97 write FMainMenu97;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Clear;
    procedure Add (MenuItem : TMenuItem; Bitmap : TBitmap);
    property Bitmaps [index : TMenuItem] : TBitmap read GetBitmaps write SetBitmaps; default;
  end;

  TMenu97MenuItem = class (TMenuItem)
  private
    FDeep : Integer;
    FOriginalMenuItem : TMenuItem;
  public
    property OriginalMenuItem : TMenuItem read FOriginalMenuItem write FOriginalMenuItem;
    property Deep : Integer read FDeep Write FDeep;
  end;

  TMenuOptionBox97 = class (TOptionBox97)
  private
    FOriginalMenuItem : TMenuItem;
    function GetCaption : string;
    procedure SetCaption (const Value : string);
  public
    constructor Create (AOwner : TComponent); override;
    property OriginalMenuItem : TMenuItem read FOriginalMenuItem write FOriginalMenuItem;
  published
    property Caption : string read GetCaption write SetCaption;
  end;

  TMainMenu97 = class(TToolbar97)
  private
    FEnabled : boolean;
    FMainMenu : TMainMenu;
    FPopups : TList;
    FWhatDo : TWhatDo;
    FBitmaps : TMenuItemBitmaps;
    FBitmapsChecked : TMenuItemBitmaps;
    FExtraButton : TToolbarButton97;
    OldDock : TDock97;
    OldDockChanged : TNotifyEvent;
    OldDockResized : TNotifyEvent;
    FAutoCreateMenu : boolean;
    FKeyboardHook : TKeyboardHook;
    Activated : Boolean;
    ActiveButton : TControl;
    ActiveButtonIndex : Integer;
    MenuOpened : Boolean;
    MustPopup : Boolean;
    ManualClosed : Boolean;
    IgnoreRight : Boolean;
    IgnoreLeft : Boolean;
    PopupsShown : Integer;
    TimerClose : TTimer;
    OneClose : Boolean;
    WaitLeftAltUp : Boolean;
    Firstbutton : Integer;
    FMouseHook : TMouseHook;
    IgnoreMouse : Boolean;
    FSystemMenuIcon : TIcon;
    FPopupMenuSystemMenu : TPopupMenu;
    FTimerNoIgnoreMouse : TTimer;
    OldMenuOpened : Boolean;
    FtimerSync : TTimer;
    SyncCount : Integer;
    function GetPopups (index : integer) : TPopupMenu;
    procedure SetMainMenu (AMainMenu : TMainMenu);
    function GetPopupsCount : integer;
    procedure DockChanged (Sender : TObject);
    procedure DockResized (Sender : TObject);
    procedure WMProcessResize (var Msg : TMessage); message WM_PROCESSRESIZE;
    procedure AssignMenuItemToButton (MenuItem : TMenuItem; Button : pointer);
    procedure AssignMenuItemToMenuItem (MenuItem, NewMenuItem : TMenuItem);
    function KeyboardHookEvent (Sender: TObject; nCode : Integer; wParam : Word; lParam : Longint) : Longint;
    function MouseHookEvent (Sender: TObject; nCode : Integer; wParam : Word; lParam : Longint) : Longint;
    procedure PopupClosed;
    procedure PopupOpened;
    procedure PopupSelect;
    procedure InitPopup (button : TMenuOptionBox97; ButtonIndex : integer);
    procedure SetIgnoreRightState (AIgnore : Boolean);
    procedure SetIgnoreLeftState (aIgnore : Boolean);
    procedure WMShowPopup (var Msg : TMessage); Message WM_SHOWPOPUP;
    procedure WMRaiseButton (var Msg : TMessage); Message WM_RAISEBUTTON;
    procedure ClosePopup (Sender : TObject);
    procedure PrepareButtonClose;
    procedure ChangeButton;
    function FindMenu (Menu : THandle) : TMenuItem;
    function FindItem (Menu : TMenuItem; ID : UINT) : TMenuItem;
    procedure SetsystemMenuIcon (AIcon : TIcon);
    procedure IconImageClick (Sender : TObject);
    procedure NoIgnoreMouse (Sender : TObject);
    procedure WMSynchronize (var Msg : TMessage); Message WM_SYNCHRONIZE;
    procedure OnTimerSync (Sender : TObject);
    function LastButtonIndex : Integer;
  protected
    procedure DefineProperties (Filer : TFiler); override;
    procedure Loaded; override;
    procedure Notification (AComponent: TComponent; Operation: TOperation); override;
    procedure FixupReferences;
    procedure SetEnabled (value : boolean); {$IfDef Ver130} override; {$EndIf}
  public
    constructor Create (AOwner : TComponent); override;
    destructor Destroy; override;
    procedure CreateMenu;
    procedure Synchronize;
    property Popups [index : integer] : TPopupMenu read GetPopups;
    property PopupsCount : integer read GetPopupsCount;
  published
    property MainMenu : TMainMenu read FMainMenu write SetMainMenu;
    property WhatDoWithOldMenus : TWhatDo read FWhatDo write FWhatDo default wdDelete;
    property Bitmaps : TMenuItemBitmaps read FBitmaps stored false;
    property BitmapsChecked : TMenuItemBitmaps read FBitmapsChecked stored false;
    property AutoCreateMenu : boolean read FAutoCreateMenu write FAutoCreateMenu default true;
    property Enabled : boolean read FEnabled write SetEnabled default true;
    property SystemMenuIcon : TIcon read FSystemMenuIcon Write SetSystemMenuIcon;
    property PopupMenuSystemMenu : TPopupMenu read FPopupMenuSystemMenu Write FPopupMenuSystemMenu;
  end;

implementation

uses
  UnitMenuItems;

var
  MenusCount : Integer = 0;

procedure KeyboardEvent(VKey, ScanCode : Byte; Flags : Longint);
begin
  keybd_event (VKey, ScanCode, Flags, 0);
end;

{$IfDef Ver130}
var
  OldPopupListWndProc : Pointer = nil;

{$Warnings OFF}
function PopupListWndProc(WindowHandle : HWND; Msg : UINT; wParam : longint; lParam : longint) : longint; stdcall;
var
  Menu97 : TMainMenu97;
  i : Integer;
  MenuItemInfo : TMenuItemInfo;
  aMenu, aMenuItem : TMenuItem;
begin
  Menu97 := nil;
  try
    if Screen.ActiveForm <> nil
      then
      begin
        for i := 0 to Screen.ActiveForm.ComponentCount - 1 do
          if Screen.ActiveForm.Components [i] is TMainMenu97
            then
            begin
              Menu97 := Screen.ActiveForm.Components [i] as TMainMenu97;
              Break;
            end;
      end;
    case Msg of
      WM_NCDESTROY :
        begin
          Result := CallWindowProc (OldPopupListWndProc, WindowHandle, Msg, wParam, lParam);
          OldPopupListWndProc := nil;
          Exit;
        end;
      WM_ENTERMENULOOP:
        begin
          if Menu97 <> nil
            then Menu97.PopupOpened;
        end;
      WM_EXITMENULOOP:
        begin
          if Menu97 <> nil
            then Menu97.PopupClosed;
        end;
      WM_MENUSELECT:
        if (hiword (wParam) = $FFFF) and (lParam = 0) //(Menuflag = $FFFF) and (Menu = 0)
          then
          begin
            if Menu97 <> nil
              then Menu97.PopupClosed;
          end
          else if Menu97 <> nil
            then
            begin
              MenuItemInfo.dwItemData := 0;
              MenuItemInfo.cbSize := SizeOf (MenuItemInfo);
              MenuItemInfo.fMask := MIIM_DATA;
              Menu97.SetIgnoreRightState (hiword (wParam) and MF_POPUP <> 0);
              if GetMenuItemInfo (lParam, loword (wParam), false, MenuItemInfo)
                then
                begin
                  aMenu := Menu97.findMenu (lParam);
                  if aMenu <> nil
                    then
                    begin
                      aMenuItem := menu97.Finditem (aMenu, loword (wParam));
                      if (aMenuItem <> nil) and (aMenuItem is TMenu97MenuItem)
                        then Menu97.SetIgnoreLeftState ((aMenuItem as TMenu97MenuItem).Deep > 1)
                        else Menu97.SetIgnoreLeftState (False);
                    end;
                end
                else Menu97.setignoreleftstate (False);
            end;
      WM_COMMAND: if Menu97 <> nil
        then Menu97.PopupSelect;
      WM_INITMENUPOPUP: if Menu97 <> nil
        then
        begin
          for I := 0 to Menu97.ControlCount - 1 do
            if Menu97.Controls [i] is TMenuOptionBox97
              then with Menu97.Controls [i] as TMenuOptionBox97 do
                if DropDownMenu.Handle = wParam
                  then
                  begin
                    Menu97.InitPopup (Menu97.Controls [i] as TMenuOptionBox97, i);
                    KeyboardEvent (VK_DOWN, Lo(MapVirtualKey(VK_DOWN,0)), 0);
                    KeyboardEvent (VK_DOWN, Lo(MapVirtualKey(VK_DOWN,0)), KEYEVENTF_KEYUP);
                    Menu97.SetIgnoreRightState (false);
                    Menu97.SetIgnoreLeftState (false);
                    Result := CallWindowProc (OldPopupListWndProc, WindowHandle, Msg, wParam, lParam);
                    Exit;
                  end;
          if Menu97.FindMenu (wParam) = nil
            then
            begin
              Menu97.Activated := False;
              Menu97.MenuOpened := False;
            end;
        end;
    end;
    Result := CallWindowProc (OldPopupListWndProc, WindowHandle, Msg, wParam, lParam);
  except
    Application.HandleException(Menu97);
  end;
end;
{$Warnings ON}
{$EndIf}

{ TMenuOptionBox97 }

constructor TMenuOptionBox97.Create;
begin
  inherited Create (AOwner);
  NoModifyTag := true;
end;

function TMenuOptionBox97.GetCaption;
begin
  Result := inherited Caption;
end;

procedure TMenuOptionBox97.SetCaption;
var
  DC: HDC;
  Rect: TRect;
begin
  inherited Caption := value;
  Rect := ClientRect;
  DC := GetDC(0);
  Canvas.Handle := DC;
  Canvas.Font := Font;
  DrawText(Canvas.Handle, PChar (Caption), length (Caption), Rect, (DT_EXPANDTABS or DT_CALCRECT));
  Canvas.Handle := 0;
  ReleaseDC(0, DC);
  SetBounds(Left, Top, Rect.Right + 10, {Top + }Height); // Corrected a bug here that caused the toolbar to grow in heigth
end;

{ TMenuItemBitmap }

destructor TMenuItemBitmap.Destroy;
begin
  Bitmap.Free;
  inherited Destroy;
end;

{ TMenuItemBitmaps }

constructor TMenuItemBitmaps.Create;
begin
  inherited Create;
  ABitmaps := TList.Create;
end;

destructor TMenuItemBitmaps.Destroy;
begin
  Clear;
  ABitmaps.Free;
  inherited Destroy;
end;

procedure TMenuItemBitmaps.Clear;
begin
  while ABitmaps.Count > 0 do
    begin
      TMenuItemBitmap (ABitmaps [0]).Free;
      ABitmaps.Delete (0);
    end;
end;

procedure TMenuItemBitmaps.Add;
var
  Item : TMenuItemBitmap;
begin
  Item := TMenuItemBitmap.Create;
  Item.MenuItem := MenuItem;
  Item.Bitmap := Bitmap;
  Item.MenuName := MenuItem.Name;
  ABitmaps.Add (Item);
end;

function TMenuItemBitmaps.GetBitmaps;
var
  i : integer;
begin
  for i := 0 to ABitmaps.Count - 1 do
    if TMenuItemBitmap (ABitmaps [i]).MenuItem = index
      then
      begin
        Result := TMenuItemBitmap (ABitmaps [i]).Bitmap;
        exit;
      end;
  Result := nil;
end;

procedure TMenuItemBitmaps.SetBitmaps;
var
  i : integer;
begin
  for i := 0 to ABitmaps.Count - 1 do
    if TMenuItemBitmap (ABitmaps [i]).MenuItem = index
      then
      begin
        if TMenuItemBitmap (ABitmaps [i]).Bitmap = nil
          then TMenuItemBitmap (ABitmaps [i]).Bitmap := TBitmap.Create;
        TMenuItemBitmap (ABitmaps [i]).Bitmap.Assign (ABitmap);
        break;
      end;
end;

procedure TMenuItemBitmaps.ReadData;
var
  i, n, ASize : integer;
  MemStream : TMemoryStream;
  MenuItemBitmap : TMenuItemBitmap;
  Reader : TReader;
begin
  Reader := TReader.Create (Stream, 1024);
  try
    with Reader do
      begin
        n := ReadInteger;
        for i := 0 to n - 1 do
          begin
            MenuItemBitmap := TMenuItemBitmap.Create;
            try
              with MenuItemBitmap do
                begin
                  MenuName := ReadString;
                  ASize := ReadInteger;
                  if ASize > 0
                    then
                    begin
                      MemStream := TMemoryStream.Create;
                      try
                        MemStream.SetSize (ASize);
                        Read (MemStream.Memory^, ASize);
                        Bitmap := TBitmap.Create;
                        Bitmap.LoadFromStream (MemStream);
                      finally
                        MemStream.Free;
                      end;
                    end;
                end;
            finally
              ABitmaps.Add (MenuItemBitmap);
            end;
          end;
      end;
  finally
    Reader.Free;
  end;
end;

procedure TMenuItemBitmaps.WriteData;
var
  i : integer;
  MemStream : TMemoryStream;
  Writer : TWriter;
begin
  Writer := TWriter.Create (Stream, 1024);
  try
    with Writer do
      begin
        WriteInteger (ABitmaps.Count);
        for i := 0 to ABitmaps.Count - 1 do
          with TMenuItemBitmap (ABitmaps [i]) do
            begin
              WriteString (MenuItem.Name);
              if (Bitmap = nil) or (Bitmap.Empty)
                then WriteInteger (0)
                else
                begin
                  MemStream := TMemoryStream.Create;
                  try
                    Bitmap.SaveToStream (MemStream);
                    WriteInteger (MemStream.Size);
                    Write (MemStream.Memory^, MemStream.Size);
                  finally
                    MemStream.Free;
                  end;
                end;
            end;
      end;
  finally
    Writer.Free;
  end;
end;

{ TMainMenu97 }

constructor TMainMenu97.Create;
begin
  inherited Create (AOwner);
  Inc (MenusCount);
  FPopups := TList.Create;
  FBitmaps := TMenuItemBitmaps.create;
  FBitmaps.MainMenu97 := self;
  FbitmapsChecked := TMenuItemBitmaps.Create;
  FBitmapsChecked.MainMenu97 := self;
  FAutoCreateMenu := true;
  FEnabled := true;
  FSystemMenuIcon := TIcon.Create;
  if not (csDesigning in ComponentState)
    then
    begin
      FKeyboardHook := TKeyboardHook.Create (Self);
      FKeyboardHook.OnHookProc := KeyboardHookEvent;
      FKeyboardHook.Hooked := True;
      FMouseHook := TMouseHook.Create (Self);
      FMouseHook.OnHookProc := MouseHookEvent;
      FMouseHook.Hooked := True;
      TimerClose := TTimer.Create (Self);
      TimerClose.Enabled := False;
      TimerClose.Interval := 50;
      TimerClose.OnTimer := ClosePopup;
      FTimerNoIgnoreMouse := TTimer.Create (Self);
      FTimerNoIgnoreMouse.Enabled := False;
      FTimerNoIgnoreMouse.Interval := 50;
      FTimerNoIgnoreMouse.OnTimer := NoIgnoreMouse;
      FtimerSync := TTimer.Create (Self);
      FtimerSync.Enabled := False;
      FtimerSync.Interval := 50;
      FtimerSync.OnTimer := OnTimerSync;
    end;
  ActiveButton := nil;
end;

destructor TMainMenu97.Destroy;
begin
  TimerClose.Free;
  FPopups.Free;
  FBitmaps.Free;
  FBitmapsChecked.Free;
  FKeyboardHook.Free;
  FMouseHook.Free;
  FSystemMenuIcon.Free;
  FTimerNoIgnoreMouse.Free;
  FtimerSync.Free;
  Dec (MenusCount);
  {$IfDef Ver130}
  if (MenusCount = 0) and (OldPopupListWndProc <> nil)
    then SetWindowLong (PopupList.Window, GWL_WNDPROC, Longint (OldPopupListWndProc));
  {$EndIf}
  inherited Destroy;
end;

function TMainMenu97.GetPopupsCount;
begin
  Result := FPopups.Count;
end;

procedure TMainMenu97.SetMainMenu;
begin
  if AMainMenu <> FMainMenu
    then
    begin
      FMainMenu := AMainMenu;
      if not (csLoading in ComponentState)
        then
        begin
          FBitmaps.Clear;
          FBitmapsChecked.Clear;
        end;
    end;
end;

procedure TMainMenu97.DefineProperties;
begin
  inherited DefineProperties (Filer);
  Filer.DefineBinaryProperty ('TheBitmaps', FBitmaps.ReadData, FBitmaps.WriteData, FBitmaps.ABitmaps.Count > 0);
  Filer.DefineBinaryProperty ('TheBitmapsChecked', FBitmapsChecked.ReadData, FBitmapsChecked.WriteData, FBitmapsChecked.ABitmaps.Count > 0);
end;

procedure TMainMenu97.Notification;
var
  i : integer;
begin
  inherited Notification (AComponent, Operation);
  if (Operation = opRemove) and (AComponent is TMenuItem)
    then
    begin
      for i := 0 to FBitmaps.ABitmaps.Count - 1 do
        if TMenuItemBitmap (FBitmaps.ABitmaps [i]).MenuItem = AComponent
          then
          begin
            FBitmaps.ABitmaps.Delete (i);
            break;
          end;
    end;
  if (Operation = opRemove) and (AComponent = MainMenu)
    then
    begin
      MainMenu := nil;
      FBitmaps.Clear;
      FBitmapsChecked.Clear;
    end
    else if (Operation = opRemove) and (AComponent = FPopupMenuSystemMenu)
      then FPopupMenuSystemMenu := nil;
end;

function TMainMenu97.GetPopups;
begin
  Result := TPopupMenu (FPopups [index]);
end;

procedure TMainMenu97.FixupReferences;
var
  i : integer;
  Item : TMenuItem;
  MName : string;
begin
  if MainMenu <> nil
    then
    begin
      for i := 0 to FBitmaps.ABitmaps.Count - 1 do
        begin
          MName := TMenuItemBitmap (FBitmaps.ABitmaps [i]).MenuName;
          Item := TMenuItem (Owner.FindComponent (MName));
          TMenuItemBitmap (FBitmaps.ABitmaps [i]).MenuItem := Item;
        end;
      for i := 0 to FBitmapsChecked.ABitmaps.Count - 1 do
        begin
          MName := TMenuItemBitmap (FBitmapsChecked.ABitmaps [i]).MenuName;
          Item := TMenuItem (Owner.FindComponent (MName));
          TMenuItemBitmap (FBitmapsChecked.ABitmaps [i]).MenuItem := Item;
        end;
    end;
end;

procedure TMainMenu97.DockChanged;
begin
  if assigned (OldDockChanged)
    then OldDockChanged (Sender);
  if OldDock <> nil
    then OldDock.OnResize := OldDockResized;
  if DockedTo <> nil
    then
    begin
      OldDockResized := DockedTo.OnResize;
      DockedTo.OnResize := DockResized;
      DockResized (DockedTo);
    end
    else if FExtraButton <> nil
      then FExtraButton.Width := 0;
  OldDock := DockedTo;
end;

procedure TMainMenu97.DockResized;
begin
  if assigned (OldDockResized)
    then OldDockResized (Sender);
  if FExtraButton <> nil
    then with Sender as TDock97 do
      if Width > (self.Width - FExtraButton.Width)
        then FExtraButton.Width := Width - (self.Width - FExtraButton.Width);
end;

procedure TMainMenu97.WMProcessResize;
begin
  if DockedTo <> nil
    then DockResized (DockedTo);
end;

procedure TMainMenu97.Loaded;
begin
  inherited Loaded;
  FixupReferences;
  if (not (csDesigning in ComponentState)) and (FMainMenu <> nil) and (FAutoCreateMenu)
    then CreateMenu;
end;

procedure TMainMenu97.CreateMenu;
const
  ItemCount : integer = 0;
var
  i, j : integer;
  Button : TMenuOptionBox97;
  Deep : integer;
  SystemMenuImage : TImage;
procedure AddItems (MenuFrom, MenuTo : TMenuItem);
var
  i : integer;
  Sub : TMenu97MenuItem;
  ABitMapCh, ABitMap, Bit, BitCh : TBitMap;
  H, HCh : THandle;
  MenuItemInfo : TMenuItemInfo;
begin
  inc (Deep);
  try
    if Deep = 1
      then
      begin
        Bit := FBitmaps [MenuFrom];
        if (Bit <> nil) and (not Bit.Empty)
          then
          begin
            Button.Glyph.Assign (Bit);
            Button.Width := Button.Width + Bit.Width;
          end;
      end;
    for i := 0 to MenuFrom.Count - 1 do
      begin
        Sub := TMenu97MenuItem.Create (MenuTo);
        Sub.Deep := Deep;
        if WhatDoWithOldMenus in [wdHide, wdNothing]
          then Sub.OriginalMenuItem := MenuFrom [i];
        AssignMenuItemToMenuItem (MenuFrom [i], Sub);
        MenuTo.Add (Sub);
        MenuItemInfo.cbSize := SizeOf (MenuItemInfo);
        MenuItemInfo.fMask := MIIM_DATA;
        if Sub.Visible
          then
          begin
            GetMenuItemInfo (MenuTo.handle, Sub.MenuIndex, true, MenuItemInfo);
            if Deep > 1
              then MenuItemInfo.dwItemData := cardinal (MenuTo)
              else MenuItemInfo.dwItemData := 0;
            SetMenuItemInfo (MenuTo.handle, Sub.MenuIndex, true, MenuItemInfo);
          end;
        if MenuFrom.Items [i].Count > 0
          then AddItems (MenuFrom.Items [i], Sub);
      end;
    for i := 0 to MenuTo.Count - 1 do
      begin
        Bit := FBitmaps [MenuFrom.Items [i]];
        BitCh := FBitmapsChecked [MenuFrom.Items [i]];
        if (Bit <> nil) and (not Bit.Empty)
          then
          begin
            ABitmap := TBitmap.Create;
            ABitmap.Assign (Bit);
            H := ABitmap.Handle;
          end
          else H := 0;
        if (BitCh <> nil) and (not BitCh.Empty)
          then
          begin
            ABitmapCh := TBitmap.Create;
            ABitmapCh.Assign (BitCh);
            HCh := ABitmapCh.Handle;
          end
          else HCh := 0;
        SetMenuItemBitmaps (MenuTo.Handle, i, MF_BYPOSITION, H, HCh)
      end;
  finally
    dec (Deep);
  end;
end;
begin
  if (not (csDesigning in ComponentState)) and (FMainMenu <> nil)
    then
    begin
      if not FSystemMenuIcon.Empty
        then
        begin
          SystemMenuImage := TImage.Create (Self);
          with SystemMenuImage do
            begin
              Width := 17;
              Height := 16;
              Picture.Assign (FSystemMenuIcon);
              OnClick := IconImageClick;
              Parent := Self;
            end;
        end;
      j := 0;
      Deep := 0;
      with FMainMenu.Items do
        for i := 0 to Count - 1 do
          begin
            if not FMainMenu.Items.Items [i].Visible
              then continue;
            Button := TMenuOptionBox97.Create (self);
            with Button do
              begin
                if WhatDoWithOldMenus in [wdHide, wdNothing]
                  then OriginalMenuItem := FMainMenu.Items.Items [i];
                Opaque := false;
                Font.Height := 8;
                ChangeCaptionOnSelect := false;
                DropDownArrow := false;
                DropDownOnClick := true;
                Left := j;
                Height := 19;
                Parent := self;
                {$IfDef Ver130}
                Images := MainMenu.Images;
                {$EndIf}
                FPopups.Add (TPopupMenu.Create (Owner));
                DropDownMenu := TPopupMenu (FPopups [i]);
                {$IfDef Ver130}
                TPopupMenu (FPopups [i]).Images := MainMenu.Images;
                {$EndIf}
                AddItems (FMainMenu.Items.Items [i], TPopupMenu (FPopups [i]).Items);
                Initialize;
                inc (j, Width);
              end;
            AssignMenuItemToButton (FMainMenu.Items.Items [i], Button);
          end;
      {
        The extra button was included in earlier versions to extend the size of the
        toolbar that contains the menu to use all the size of the dock where it's placed.
        Usually the size of the dock will be the width of the form for main menus.
        In the newest versions of TB97 you can use the property FullSize to acchieve this
        behavior, that's why the extra button now is not any longer instantiated
        
      FExtraButton := TToolbarButton97.Create (self);
      with FExtraButton do
        begin
          Opaque := false;
          Left := j;
          Height := 19;
          Parent := self;
          Enabled := false;
          Width := 0;
        end;}
      OldDockChanged := OnDockChanged;
      OnDockChanged := DockChanged;
      if DockedTo <> nil
        then DockChanged (DockedTo);
      j := 0;
      for i := 0 to ComponentCount - 1 do
        begin
          if Components [i] is TOptionBox97
            then
            begin
              (Components [i] as TOptionBox97).Height := 19;
              case FWhatDo of
                wdDelete : FMainMenu.Items.Delete (0);
                wdHide : FMainMenu.Items.Items [j].Visible := false;
                wdNothing : (* Nothing to do *);
              end;
              inc (j);
            end;
        end;
      PostMessage (Handle, WM_PROCESSRESIZE, 0, 0);
      Firstbutton := -1;
      for i := 0 to ControlCount - 1 do
        if Controls [i] is TOptionBox97
          then
          begin
            Firstbutton := i;
            Break;
          end;
      {$IfDef Ver130}
      if OldPopupListWndProc = nil
        then OldPopupListWndProc := pointer (SetWindowLong (PopupList.Window, GWL_WNDPROC, Longint (@PopupListWndProc)));
      {$EndIf}
    end;
end;

procedure TMainMenu97.Synchronize;
begin
  if WhatDoWithOldMenus = wdDelete
    then raise Exception.Create ('Cannot synchronize with WhatDoWithOldMenus = wdDelete');
  Inc (SyncCount);
  try
    if SyncCount <= 1
      then OldMenuOpened := MenuOpened;
    if MenuOpened
      then
      begin
        PreparebuttonClose;
        MustPopup := False;
      end;
    PostMessage (Handle, WM_SYNCHRONIZE, 0, 0);
  except
    Dec (SyncCount);
    raise;
  end;
end;

procedure TMainMenu97.AssignMenuItemToButton;
begin
  with TMenuOptionBox97 (Button) do
    begin
      Caption := MenuItem.Caption;
      Hint := MenuItem.Hint;
      OnClick := MenuItem.OnClick;
      Enabled := MenuItem.Enabled;
      {$IfDef Ver130}
      ImageIndex := MenuItem.ImageIndex;
      if ImageIndex = -1
        then Images := nil;
      Action := MenuItem.Action;
      {$EndIf}
    end;
end;

procedure TMainMenu97.AssignMenuItemToMenuItem;
begin
  with NewMenuItem do
    begin
      {$IfDef Ver130}
      AutoHotkeys := MenuItem.AutoHotkeys;
      AutoLineReduction := MenuItem.AutoLineReduction;
      Bitmap := MenuItem.Bitmap;
      ImageIndex := MenuItem.ImageIndex;
      SubMenuImages := MenuItem.SubMenuImages;
      {$EndIf}
      OnClick := MenuItem.OnClick;
      Caption := MenuItem.Caption;
      Break := MenuItem.Break;
      Checked := MenuItem.Checked;
      Default := MenuItem.Default;
      Enabled := MenuItem.Enabled;
      GroupIndex := MenuItem.GroupIndex;
      HelpContext := MenuItem.HelpContext;
      Hint := MenuItem.Hint;
      MenuIndex := MenuItem.MenuIndex;
      RadioItem := MenuItem.RadioItem;
      ShortCut := MenuItem.ShortCut;
      Tag := MenuItem.Tag;
      Visible := MenuItem.Visible;
      {$IfDef Ver130}
      Action := MenuItem.Action;
      {$EndIf}
    end;
end;

procedure TMainMenu97.SetEnabled;
var
  i : integer;
begin
  if value <> FEnabled
    then
    begin
      FEnabled := value;
      for i := 0 to ComponentCount - 1 do
        if Components [i] is TMenuOptionBox97
          then if Trim ((Components [i] as TMenuOptionBox97).Caption) <> ''
            then (Components [i] as TMenuOptionBox97).Enabled := FEnabled;
    end;
end;

procedure TMainMenu97.PrepareButtonClose;
begin
  if Menuopened
    then
    begin
      MustPopup := True;
      IgnoreMouse := True;
    end;
  ManualClosed := True;
  if MenuOpened
    then
    begin
      KeyboardEvent (VK_ESCAPE, Lo(MapVirtualKey(VK_ESCAPE,0)), 0);
      KeyboardEvent (VK_ESCAPE, Lo(MapVirtualKey(VK_ESCAPE,0)), KEYEVENTF_KEYUP);
      TimerClose.Enabled := True;
      OneClose := True;
    end;
end;

procedure TMainMenu97.ChangeButton;
begin
  if ActiveButton is TMenuOptionBox97
    then (ActiveButton as TMenuOptionBox97).MouseLeft;
  ActiveButton := Controls [Activebuttonindex];
  if ActiveButton is TMenuOptionBox97
    then (ActiveButton as TMenuOptionBox97).MouseEntered;
end;

function TMainMenu97.KeyboardHookEvent;
begin
  Result := 0;
  if (wParam in [VK_MENU, VK_F10]) and (lParam and (1 shl 31) = 0)
    then WaitLeftAltUp := (wParam = VK_F10) or (GetKeyState (VK_LMENU) <> 0)
    else if (WaitLeftAltUp) and (not (wParam in [VK_MENU, VK_F10]))
      then WaitLeftaltUp := False;
  if ((lParam and (1 shl 31) <> 0) and (wParam in [VK_DOWN, VK_RIGHT, VK_LEFT, VK_ESCAPE]) and Activated) or
     ((lParam and (1 shl 31) = 0) and (wParam in [VK_MENU, VK_F10])) or
     ((lParam and (1 shl 31) <> 0) and (wParam in [VK_MENU, VK_F10]) and (not WaitLeftaltUp)) or
     (ControlCount = 0) or
     (not (Owner as TForm).Active) or (nCode = HC_NOREMOVE)
    then Exit;
  case wParam of
    VK_MENU, VK_F10 :
      begin
        if not Activated
          then
          begin
            SetFocus;
            ActiveButton := Controls [Firstbutton] as TMenuOptionBox97;
            ActiveButtonIndex := Firstbutton;
            (ActiveButton as TMenuOptionBox97).MouseEntered;
          end
          else if ActiveButton <> nil
            then
            begin
              if ActiveButton is TMenuOptionBox97
                then (ActiveButton as TMenuOptionBox97).MouseLeft;
              ActiveButton := nil;
            end;
        Activated := not Activated;
        Result := 1;
      end;
    VK_RIGHT : if (ActiveButton <> nil) and (not IgnoreRight)
      then
      begin
        PrepareButtonClose;
        if ActiveButtonIndex < LastButtonIndex
          then Inc (ActiveButtonIndex)
          else ActiveButtonIndex := 0;//Firstbutton;
        ChangeButton;
      end;
    VK_LEFT : if (ActiveButton <> nil) and (not IgnoreLeft)
      then
      begin
        PrepareButtonClose;
        if ActiveButtonIndex > 0//Firstbutton
          then dec (ActiveButtonIndex)
          else ActiveButtonIndex := LastButtonIndex;
        ChangeButton;
      end;
    VK_DOWN : if (ActiveButton <> nil) and (not MenuOpened)
      then
      begin
        if ActiveButton is TMenuOptionBox97
          then
          begin
            (ActiveButton as TMenuOptionBox97).MouseLeft;
            (ActiveButton as TMenuOptionBox97).Click;
            MenuOpened := True;
          end
          else if ActiveButton is TImage
            then if FPopupMenuSystemMenu <> nil
              then IconImageClick (nil);
        Result := 1;
      end;
    VK_ESCAPE:
      begin
        if (not MenuOpened) and (not ManualClosed)
          then
          begin
            Activated := False;
            if ActiveButton <> nil
              then
              begin
                if ActiveButton is TMenuOptionBox97
                  then (ActiveButton as TMenuOptionBox97).MouseLeft;
                ActiveButton := nil;
              end;
          end;
        ManualClosed := False;
        if ActiveButton <> nil
          then PostMessage (Handle, WM_RAISEBUTTON, 0, 0);
      end;
  end;
end;

procedure tMainMenu97.PopupClosed;
begin
  MenuOpened := False;
  if MustPopup
    then PostMessage (Handle, WM_SHOWPOPUP, 0, 0);
  MustPopup := False;
  ManualClosed := False;
  if (ActiveButton <> nil) and (ActiveButton is TMenuOptionBox97)
    then
    begin
      (ActiveButton as TMenuOptionBox97).MouseLeft;
      (ActiveButton as TMenuOptionBox97).MouseEntered;
    end;
  Dec (popupsShown);
  OneClose := False;
  if PopupsShown < 0
    then PopupsShown := 0;
  IgnoreLeft := False;
  IgnoreRight := False;
end;

procedure TMainMenu97.PopupOpened;
begin
  Activated := True;
  MenuOpened := True;
  Inc (PopupsShown);
end;

procedure TMainMenu97.PopupSelect;
begin
  MenuOpened := False;
  Activated := false;
  ManualClosed := False;
  if (ActiveButton <> nil) and (ActiveButton is TMenuOptionBox97)
    then (ActiveButton as TMenuOptionBox97).MouseLeft;
  ActiveButton := nil;
end;

procedure TMainMenu97.InitPopup;
begin
  ActiveButton := Button;
  ActiveButtonIndex := ButtonIndex;
  FTimerNoIgnoreMouse.Enabled := True;
end;

procedure TMainMenu97.WMShowPopup;
begin
  if ActiveButton <> nil
    then if ActiveButton is TMenuOptionBox97
      then
      begin
        (ActiveButton as TMenuOptionBox97).Click;
      end
      else if ActiveButton is TImage
        then if FPopupMenuSystemMenu <> nil
          then
          begin
            IconImageClick (nil);
          end;
end;

procedure TMainMenu97.WMRaiseButton;
begin
  if (ActiveButton <> nil) and (ActiveButton is TMenuOptionBox97)
    then
    begin
      (ActiveButton as TMenuOptionBox97).MouseLeft;
      (ActiveButton as TMenuOptionBox97).MouseEntered;
    end;
end;

procedure TMainMenu97.SetIgnorerightState;
begin
  IgnoreRight := AIgnore;
end;

procedure TMainMenu97.SetIgnoreLeftState;
begin
  IgnoreLeft := aIgnore;
end;

procedure TMainMenu97.ClosePopup;
begin
  TimerClose.Enabled := (PopupsShown > 0) and OneClose;
  if TimerClose.Enabled
    then
    begin
      KeyboardEvent (VK_ESCAPE, Lo(MapVirtualKey(VK_ESCAPE,0)), 0);
      KeyboardEvent (VK_ESCAPE, Lo(MapVirtualKey(VK_ESCAPE,0)), KEYEVENTF_KEYUP);
    end;
end;

function TMainMenu97.MouseHookEvent;
var
  Control : TControl;
  i : Integer;
begin
  Result := 0;
  if Activated and MenuOpened and (wParam = WM_MOUSEMOVE) and (not IgnoreMouse)
    then
    begin
      if lParam <> 0
        then with TMouseHookStruct (Pointer (lParam)^) do
          begin
            if WindowFromPoint (pt) = Handle
              then
              begin
                Control := ControlAtPos (ScreenToClient (pt), False, True);
                if Control <> nil
                  then
                  begin
                    if Control <> ActiveButton
                      then if (Control is TMenuOptionBox97) or (Control is TImage)
                        then
                        begin
                          PrepareButtonClose;
                          for i := 0 to ControlCount - 1 do
                            if Control = Controls [i]
                              then
                              begin
                                ActiveButtonIndex := i;
                                Break;
                              end;
                          Changebutton;
                        end;
                  end;
              end;
          end;
    end;
end;

function TMainMenu97.FindMenu;
var
  i : Integer;
  function FindMenuHandle (PopupMenu : TMenuItem) : TMenuItem;
  var
    i : Integer;
  begin
    Result := nil;
    if PopupMenu.Handle = Menu
      then Result := PopupMenu
      else
      begin
        for i := 0 to PopupMenu.Count - 1 do
          if PopupMenu.Items [i].Count > 0
            then if PopupMenu.Items [i].Handle = menu
              then
              begin
                Result := PopupMenu.Items [i];
                Exit;
              end
              else
              begin
                Result := FindMenuHandle (PopupMenu.Items [i]);
                if Result <> nil
                  then Exit;
              end;
      end;
  end;
begin
  Result := nil;
  for i := 0 to ControlCount - 1 do
    if Controls [i] is TMenuOptionBox97
      then with Controls [i] as TMenuOptionBox97 do
        begin
          Result := FindMenuHandle (DropDownMenu.items);
          if Result <> nil
            then Exit;
        end;
  if Result = nil
    then if FPopupMenuSystemMenu <> nil
      then Result := FindMenuHandle (FPopupMenuSystemMenu.Items);
end;

function TMainMenu97.FindItem;
var
  i : Integer;
begin
  Result := nil;
  for i := 0 to Menu.Count - 1 do
    if ID = GetMenuItemID (Menu.Handle, i)
      then
      begin
        Result := Menu.Items [i];
        Exit;
      end;
end;

procedure TMainMenu97.SetsystemMenuIcon;
begin
  FSystemMenuIcon.Assign (AIcon);
end;

procedure TMainMenu97.IconImageClick;
var
  p : TPoint;
begin
  ActiveButton := Controls [0];
  p := ClientToScreen (Point (Controls [0].Left, Controls [0].Height + 3));
  PopupMenuSystemMenu.Popup (p.x, p.y);
end;

procedure TMainMenu97.NoIgnoreMouse;
begin
  FTimerNoIgnoreMouse.Enabled := False;
  IgnoreMouse := False;
end;

procedure TMainMenu97.WMSYnchronize;
var
  i : Integer;
  procedure ProcessSubMenu (Menu : TMenuItem);
  var
    i : integer;
    Sub : TMenu97MenuItem;
  begin
    for i := 0 to Menu.Count - 1 do
      begin
        Sub := Menu [i] as TMenu97MenuItem;
        AssignMenuItemToMenuItem (Sub.OriginalMenuItem, Sub);
        if Menu.Items [i].Count > 0
          then ProcessSubMenu (Menu.Items [i]);
      end;
  end;
begin
  if PopupsShown > 0
    then
    begin
      FtimerSync.Enabled := True;
      Exit;
    end;
  try  
    for i := 0 to ComponentCount - 1 do
      begin
        if Components [i] is TMenuOptionBox97
          then
          begin
            with Components [i] as TMenuOptionBox97 do
              begin
                AssignMenuItemToButton (OriginalMenuItem, self.Components [i] as TMenuOptionBox97);
                ProcessSubMenu (DropDownMenu.Items);
              end;
          end;
      end;
  finally
    Dec (SyncCount);
  end;
  if SyncCount < 0
    then SyncCount := 0;
  if (SyncCount = 0) and OldMenuOpened
    then
    begin
      SendMessage (Handle, WM_SHOWPOPUP, 0, 0);
      MenuOpened := True;
      Application.ProcessMessages;
    end;
end;

procedure TMainMEnu97.OnTimerSync;
begin
  FtimerSync.Enabled := False;
  PostMessage (Handle, WM_SYNCHRONIZE, 0, 0);
end;

function TMainMenu97.LastButtonIndex;
begin
  if FExtraButton = nil
    then Result := ControlCount - 1
    else Result := ControlCount - 2;
end;

end.
