unit KeyboardHook;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  BaseHook;

type
  TKeyboardHook = class(TBaseHook)
  private
    { Private declarations }
  protected
    procedure FillParams (var AIdHook : Integer; var AHHookAddr : PHandle; var AInstallCountAddr : PInteger;
                          var HookProc : Pointer; var AHooksList : TList); override;
  public
    { Public declarations }
  end;

procedure Register;

implementation

var
  KeyboardHooks : TList;
  HHook : THandle;
  InstallCount : Integer;

function KeyboardProc (nCode : integer; wParam : integer; lParam : Longint) : longint; stdcall;
begin
  Result := HookProc (HHook, keyboardHooks, nCode, wParam, lParam);
end;

{ TMouseHook }


procedure TKeyboardHook.FillParams;
begin
  AIdHook := WH_KEYBOARD;
  AHHookAddr := @HHook;
  AInstallCountAddr := @installCount;
  HookProc := @KeyboardProc;
  AHooksList := KeyboardHooks;
end;

procedure Register;
begin
  RegisterComponents('Misc2', [TKeyboardHook]);
end;

initialization
  KeyboardHooks := TList.Create;
  InstallCount := 0;
finalization
  KeyboardHooks.Free;
end.
