unit BaseHook;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  THookProcEvent = function (Sender: TObject; nCode : Integer; wParam : Word; lParam : longint) : longint of object;
  PHandle = ^THandle;
  PInteger = ^integer;

  TBaseHook = class(TComponent)
  private
    FOnHookProc : THookProcEvent;
    FHooked : Boolean;
    HHookAddr : PHandle;
    InstallCountAddr : PInteger;
    HookProc : Pointer;
    HooksList : TList;
    IdHook : Integer;
    procedure SetHooked (Value : Boolean);
  protected
    function DoHookProc (nCode : Integer; wParam : Word; lParam : Longint) : longint; virtual;
    procedure InstallHook; virtual;
    procedure UninstallHook; virtual;
    procedure AssignStruct (address : Pointer); virtual;
    procedure FillParams (var AIdHook : Integer; var AHHookAddr : PHandle; var AInstallCountAddr : PInteger;
                          var HookProc : Pointer; var AHooksList : TList); virtual; abstract;
  public
    constructor Create (AOwner : TComponent); override;
    destructor Destroy; override;
    procedure ReInstallHook;
  published
    property Hooked : Boolean read FHooked Write SetHooked default false;
    property OnHookProc : THookProcEvent read FOnHookProc Write FOnHookProc;
  end;

function HookProc (HHook : THandle; List : TList; nCode : integer; wParam : integer; lParam : Longint) : Longint;

implementation

{ TBaseHook }

function HookProc (HHook : THandle; List : TList; nCode : integer; wParam : integer; lParam : Longint) : longint;
var
  i : Integer;
begin
  Result := 0;
  if nCode >= 0
    then for i := 0 to List.Count - 1 do
      if TBaseHook (List [i]).Hooked
        then
        begin
          Result := TbaseHook (List [i]).DoHookProc (nCode, wParam, lParam);
          if Result <> 0
            then Break;
        end;
  if Result = 0
    then Result := CallNextHookEx (HHook, nCode, wParam, lParam);
end;

constructor TBaseHook.Create;
begin
  inherited;
  FillParams (idHook, HHookAddr, InstallCountAddr, HookProc, HooksList);
  HooksList.Add (Self);
end;

destructor TBaseHook.Destroy;
begin
  HooksList.Remove (Self);
  if Hooked
    then if not (csDesigning in ComponentState)
      then UninstallHook;
  inherited;
end;

procedure TBaseHook.AssignStruct;
begin
end;

function TBaseHook.DoHookProc;
begin
  if Assigned (FOnHookProc)
    then
    begin
      AssignStruct (Pointer (lParam));
      Result := FOnHookProc (self, nCode, wParam, lParam);
    end
    else Result := 0;
end;

procedure TBaseHook.ReInstallHook;
begin
  if Hooked
    then
    begin
      UninstallHook;
      InstallHook;
    end;
end;

procedure TBaseHook.InstallHook;
begin
  if HHookAddr^ = 0
    then
    begin
      HHookAddr^ := SetWindowsHookEx (IdHook, HookProc, 0, GetCurrentThreadId);
      if HHookAddr^ <> 0
        then
        begin
          FHooked := true;
          InstallCountAddr^ := 1;
        end
    end
    else
    begin
      Inc (InstallCountAddr^);
      FHooked := True;
    end;
end;

procedure TBaseHook.UninstallHook;
begin
  if InstallCountAddr^ = 1
    then if HHookAddr^ <> 0
      then
      begin
        UnhookWindowsHookEx (HHookAddr^);
        HHookAddr^ := 0;
        FHooked := False;
        InstallCountAddr^ := 0;
      end
      else raise Exception.Create ('The hook should be installed?!')
    else
    begin
      Dec (InstallCountAddr^);
      FHooked := False;
    end;
end;

procedure TBaseHook.SetHooked;
begin
  if Hooked <> Value
    then if not (csDesigning in ComponentState)
      then if value
        then InstallHook
        else UninstallHook
      else FHooked := Value;
end;

end.
