unit DDListBox;
{
  TDDListBox is a JPG-file sorter. Try out the demo program JPGSorter to see
  how the component functions. Comments are welcome.
}
{-----------------------------------------------------------------------}
{                                                                       }
{               Copyright (C) 1997 by Tat Choi Chan (F~)            }
{                    E-mail: yll@hkstar.com                             }
{***********************************************************************}
{ This component can be freely used in non-commercial environments and  }
{ re-distributed, provided this notice is not modified in any way.      }
{ ----------------------------------------------------------------------}
{ Version 1.0. Date last modified:  15 Dec., 1997  HONG kONG            }
{ ----------------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ShellAPI, Menus ,JPEG ;

type
  TAction = ( taNone, taCopy, taMove, taDelete, taRename );

  TDDListBox = class(TListBox)
  private
    { Private declarations }
  FDirectory : String;
  FPopUpMenu : TPopUpMenu;
  FImage : TImage;
  FactPWidth, FactPHeight,
  FImageTop, FImageLeft, FImageWidth, FImageHeight : integer;
  FItemNo : integer;
  FShowJPG : Boolean;
  FAction : TAction;
  FF : TShFileOpStruct;
  procedure ShowPicture( i : integer );
  protected
    { Protected declarations }
    procedure SetImage( image : TImage );
    Procedure SetDirectory( s : string );
    function GetImage : TImage;

    procedure MouseMove( Shift: TShiftState; X, Y: Integer); override;
    procedure Click; override;
    Procedure DblClick; override;
    procedure DragOver( Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean); override;
    procedure DragDrop( Source: TObject; X, Y: Integer); override;
    procedure MouseDown( Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer); override;
    Function MakePopUpMenu : TPopUpMenu ;
    procedure ReadDirectory( s : string );

    procedure ToggleShowJPG( Sender: TObject );
    procedure ZoomIn( Sender: TObject );
    procedure Rename( Sender: TObject );
    procedure DeletePict( Sender: TObject );
    procedure SortIt( Sender: TObject );

    procedure ChkUpdate;

    procedure InitialFF;
    procedure SetFFpFrom( s : Ansistring );
    procedure SetFFpTo( s : Ansistring );
    procedure SetFFAction( act : TAction );
    function  DoIt( act : TAction; S : AnsiString  ):Boolean;



  public
    { Public declarations }
    Constructor Create( aOwner: TComponent ); override;

  published
    { Published declarations }
  property  Directory : string
             read FDirectory write SetDirectory;
  property Image : TImage
             read GetImage write SetImage ;
  property ShowJPG : Boolean
             read FShowJPG write FShowJPG;
  property Action : TAction
             read FAction write FAction ;
  property OnMouseDown;
  property OnDragOver;
  property OnDragDrop;

  end;

procedure Register;

implementation

uses ReName{ TOKRightDlg }, ZoomInFm{TFormZoomIn;} ;

var
  OKRightDlg : TOKRightDlg;
  FrmZoomIn  :  TZoomInFm;


Constructor TDDListBox.Create( aOwner: TComponent );
begin
  inherited Create( aOwner );
  Directory := '';
  FItemNo := 0;
  FShowJPG := true;
  Sorted := true;
  Self.PopupMenu := MakePopUpMenu;
  InitialFF;
end;

procedure TDDListBox.SetDirectory( s : string );
begin
   if s <> FDirectory  then
       ReadDirectory( s );
end;

procedure TDDListBox.ReadDirectory( s : string );
VAR  Found, sLen : integer;
     SearchRec : TSearchRec;
     sPath : string;
begin
       Self.Clear;
       sLen := Length( s );
       if s[sLen] <> '\' then
          sPath := s + '\'
       else
          sPath := s;
       FDirectory := sPath;
       sPath := sPath + '*.jpg';
       Found := FindFirst( sPath, faAnyFile, SearchRec);
       while Found = 0 do
       begin
         self.items.Add( SearchRec.Name );
         Found := FindNext(SearchRec);
       end;
       FindClose(SearchRec);
end;

procedure TDDListBox.SetImage( image : TImage );
begin
  if FImage <> image then
  begin
    FImage := image;
    FImageTop := image.Top;
    FImageLeft := image.Left;
    FImageWidth := image.Width;
    FImageHeight := image.Height;
    FImage.Stretch := true;
    FImage.Invalidate;

  end;
end;

function TDDListBox.GetImage :TImage;
begin
  Result := FImage;
end;

procedure TDDListBox.DragOver( Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
begin
  if Source is TDDListBox then
    Accept := true;
end;

procedure TDDListBox.DragDrop( Source: TObject; X, Y: Integer);
var indx :integer;
     So : TDDListBox;
     count, cnt, selNo, SoCount : integer;
     L : Ansistring;
begin

      So := TDDListBox( Source );
      indx := So.ItemIndex - 1;
        if indx < 0 then indx := 0;
      selNo := So.SelCount;
      SoCount := So.Items.Count-1;

      if SelNo > 1 then
      begin
        for count := 0 to SoCount do
          if So.Selected[ count ] then
          begin
              Self.Items.Add( So.Items.Strings[ count] );
              L := L + So.Items.Strings[ count] + #0;
              // copy or move files from source
          end;
           L := L + #0;
           if SetCurrentDirectory( Pchar(So.Directory+#0) ) and
              Doit(  So.Action, L  ) then
            begin
                if ( So.FAction = taDelete ) or
                ( So.FAction = taMove )  then
               begin
               for count := 0 to SoCount do
                 if So.Selected[ count ] then
                 begin
                   for cnt := 1 to SelNo do
                     So.Items.Delete( count );
                     indx := count - 1;
                     if indx < 0 then indx := 0;
                     break;
                  end;
               end;
            end;     // setDir & DoIt
        end   // selNo > 1

      else
      begin
        // copy or move file from source ( once only )
        if Self.Items.IndexOf( So.Items.Strings[ So.ItemIndex ] ) = -1 then
        begin
        Self.Items.Add( So.Items.Strings[ So.ItemIndex ] );
        L := L + So.Items.Strings[ So.ItemIndex ] + #0 + #0;
        if SetCurrentDirectory( Pchar(So.Directory+#0) ) and
              Doit(  So.Action, L  ) then
             if ( So.FAction = taDelete ) or
                ( So.FAction = taMove )  then
               begin
                 So.Items.Delete( So.ItemIndex );
                 So.ItemIndex := indx;
               end;
         end;
      end;
    So.ShowPicture( so.ItemIndex );
    ChkUpdate;
end;

procedure TDDListBox.Click;
begin
   inherited Click;
   if assigned ( Fimage ) then
       ShowPicture( Self.ItemIndex );

end;

procedure TDDListBox.DblClick;
begin
   inherited DblClick;
   ZoomIn( self );
end;

procedure TDDListBox.MouseDown( Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
begin
 if (ssLeft in Shift) and
     ( Self.ItemAtPos( point( X, Y ), true )<>-1 ) then
     begin
        Self.BeginDrag( False );
       if ssShift in Shift then
         FAction := taCopy
       else
         FAction := taMove ;

       if ssAlt in Shift then
         FAction := taMove ;
     end;
end;

procedure TDDListBox.MouseMove( Shift: TShiftState; X, Y: Integer);
var  i : integer;
begin
   inherited MouseMove( Shift, X, Y );
   i := Self.ItemAtPos( point( x,y), true );

   if assigned ( Fimage ) and FShowJPG then
     if ( i <> -1 ) and ( i <> FItemNo ) then
       ShowPicture( i );

    itemindex := i ;
end;

procedure TDDListBox.ShowPicture( i : integer );
var  xImage : Timage;
     ratio : real;
begin
     FItemNo := i;

     try
       xImage := Timage.Create( self );

       xImage.Picture.loadfromfile( FDirectory + items.Strings[i] );
       FactpHeight := xImage.picture.height;
       FactPWidth :=xImage.picture.width;
       FImage.Height := FImageHeight;
       FImage.Width := FImageWidth;
       ratio := xImage.picture.width /xImage.picture.height;

       if ratio >= 1.0 then
         FImage.height := round( FImage.Width /ratio )
       else
         FImage.width := round( FImage.Height *ratio );

       FImage.picture.loadfromfile( FDirectory + items.Strings[i] );

     finally
       ximage.free;
     end;

end;

Function TDDListBox.MakePopUpMenu : TPopUpMenu ;
var
 MenuItem : TMenuItem;
begin
  FPopUpMenu := TPopUpMenu.Create( Self );

  MenuItem := TMenuItem.Create( FPopUpMenu );
  MenuItem.Caption := '&Zoom In';
  MenuItem.OnClick := ZoomIn ;
  FPopUpMenu.Items.Add( MenuItem );

  MenuItem := TMenuItem.Create( FPopUpMenu );
  MenuItem.Caption := '&Auto Show';
  MenuItem.Checked := true;
  MenuItem.OnClick := ToggleShowJPG ;
  FPopUpMenu.Items.Add( MenuItem );

  MenuItem := TMenuItem.Create( FPopUpMenu );
  MenuItem.Caption := '&Rename';
  MenuItem.OnClick := Rename ;
  FPopUpMenu.Items.Add( MenuItem );

  MenuItem := TMenuItem.Create( FPopUpMenu );
  MenuItem.Caption := '&Sorted';
  MenuItem.OnClick := SortIt ;
  MenuItem.Checked := true;
  FPopUpMenu.Items.Add( MenuItem );

  MenuItem := TMenuItem.Create( FPopUpMenu );
  MenuItem.Caption := '-';
  MenuItem.OnClick := ToggleShowJPG ;
  FPopUpMenu.Items.Add( MenuItem );

  MenuItem := TMenuItem.Create( FPopUpMenu );
  MenuItem.Caption := '&Delete';
  MenuItem.OnClick := DeletePict ;
  FPopUpMenu.Items.Add( MenuItem );

  Result := FPopUpMenu;
end;

procedure TDDListBox.ToggleShowJPG( Sender: TObject );
begin
      FShowJPG := not FShowJPG;
      MultiSelect := not MultiSelect;
      FPopUpMenu.Items[1].Checked := not FPopUpMenu.Items[1].Checked
end;

procedure TDDListBox.ReName( Sender: TObject );
var L, L2 : AnsiString;
    SameDir : Boolean;
    indx : integer;
begin

  if OKRightDlg = nil then
    OKRightDlg :=  TOKRightDlg.Create( self );
    OKRightDlg.Edit1.text := Self.Items.Strings[
                             Self.ItemIndex ];
    if OKRightDlg.ShowModal= mrOK then
    begin
      SameDir := true;
      L :=  Self.Items.Strings[Self.ItemIndex]+#0+ #0 ;
      L2 := ExtractFileDir( OKRightDlg.Edit1.text );
      if L2 = '' then
        L2 := Self.Directory + OKRightDlg.Edit1.text + #0
      else
      begin
        L2 := OKRightDlg.Edit1.text + #0 ;
        SameDir := false;
      end;
      SetFFpTo( L2 );
      if SetCurrentDirectory( Pchar(Self.Directory+#0) ) and
       Doit(  taRename, L  ) then
       if  SameDir then
           Self.Items.Strings[ItemIndex] := OKRightDlg.Edit1.text
       else
       begin
          indx := ItemIndex - 1;
          if Indx < 0 then Indx := 0;
          Self.Items.delete( ItemIndex );
          Self.ItemIndex := indx;
       end;

    end;
end;

procedure TDDListBox.ZoomIn( Sender: TObject );
begin
      if FrmZoomIn=nil then
        FrmZoomIn := TZoomInFm.Create( Self );
      FrmZoomIn.ClientWidth := FactPWidth;
      FrmZoomIn.ClientHeight := FactPHeight;
      FrmZoomIn.imageZm.picture.loadfromfile( FDirectory +
         Self.items.Strings[ Self.ItemIndex ]) ;
      FrmZoomIn.show;
end;

procedure TDDListBox.DeletePict( Sender: TObject );
var SelNo, SeCount, count, cnt, indx : integer;
    L : AnsiString;
begin
     SelNo := Self.SelCount;
     SeCount := Self.Items.Count -1 ;

      if SelNo > 1 then
      begin
        for count := 0 to SeCount do
          if Self.Selected[ count ] then
          begin
             for cnt := 1 to SelNo do
               L := L +  Self.Items.Strings[cnt] + #0 ;
             break;
          end;

            L := L + #0 ;
            if SetCurrentDirectory( Pchar(Self.Directory+#0) ) and
              Doit(  taDelete, L  ) then
                for count := 0 to SeCount do
                  if Self.Selected[ count ] then
                  begin
                     for cnt := 1 to SelNo do
                       Self.Items.Delete(count);
                     indx := count - 1;
                     if indx < 0 then indx := 0;
                     break;
                  end;
                   //  for count := 0
                   // SetCurDir & DoIt
           end     // selNo > 1
           else
           begin
            L := L +  Self.Items.Strings[Self.ItemIndex]+#0+ #0 ;
            if SetCurrentDirectory( Pchar(Self.Directory+#0) ) and
              Doit(  taDelete, L  ) then
              begin
                indx := ItemIndex - 1 ;
                if indx < 0 then indx := 0;
                Self.Items.Delete( Self.ItemIndex );
              end;
           end;
          ChkUpdate; 
          Self.ItemIndex := Indx;
          Self.ShowPicture( indx );
         // Delete file
end;

procedure TDDListBox.SortIt( Sender: TObject );
begin
    Self.Clear;
    Self.Sorted := not Self.Sorted;
    FPopUpMenu.Items[3].Checked := not FPopUpMenu.Items[3].Checked ;
    ReadDirectory( FDirectory );
end;

procedure TDDListBox.InitialFF;
begin
  With FF do
  begin
    Wnd :=  0 ;
    fFlags := FOF_ALLOWUNDO OR FOF_NOCONFIRMATION
       OR FOF_SILENT;
  end;
end;

procedure TDDListBox.setFFAction( act : TAction );
begin
  with FF do
  case act of
    taRename : wFunc := FO_RENAME;
    taDelete : wFunc := FO_DELETE;
    taMove : wFunc := FO_MOVE;
    taCopy : wFunc := FO_COPY;
  end;
end;

procedure TDDListBox.SetFFpFrom( s : Ansistring );
begin
  FF.pFrom := Pchar( S );
end;

procedure TDDListBox.SetFFpTo( s : Ansistring );
begin
  FF.pTo := Pchar( S );
end;

function TDDListBox.DoIt( act: TAction; S: AnsiString  ):Boolean;
begin
  SetFFAction( act );
  FF.pFrom := Pchar( S );
  if act <> taRename then
    FF.pTo := Pchar( Self.Directory + #0 );
  if ShFileOperation( FF ) = 0 then
    result := true
  else
    result := false;

end;

procedure TDDListBox.ChkUpdate;
var i :integer;
    D : TDDListBox;
begin
    for i := 0 to Tform( Self.parent ).controlcount-1 do
        if Self.Parent.Controls[i] is TDDListBox then
        begin
           D := TDDListBox(Self.Parent.Controls[i]);
           if (D.name <> Self.name ) and (Self.Directory = D.Directory) then
             D.ReadDirectory( D.Directory );
        end;
end;

procedure Register;
begin
  RegisterComponents('MyComp', [TDDListBox]);
end;

end.
