unit JListBox;

interface

uses Messages, SysUtils, Classes, Controls, Forms, Graphics,
     Stdctrls, Windows;

type
  TEditListBox = Class(TCustomEdit)
     protected
        procedure doExit;override;
        procedure KeyDown(var Key: Word; Shift: TShiftState);override;
  end;
  TJustListBox = class(TListBox)
    private
        FMultiselect: Boolean;
        FAlignment : TAlignment;
        FTextMargin : integer;
        IndicedeLista: Integer;
        FEditable: Boolean;
        FMaxLength: Integer;
        EditListBox1: TEditListBox;
        FCanInsert: Boolean;
        FCanDelete: Boolean;
        function GetAlignment : TAlignment;
        procedure SetAlignment(Value : TAlignment);
        function GetEditable : Boolean;
        procedure SetEditable(Value : Boolean);
        function GetCanInsert : Boolean;
        procedure SetCanInsert(Value : Boolean);
        function GetCanDelete : Boolean;
        procedure SetCanDelete(Value : Boolean);
        function GetMultiSelect : Boolean;
        procedure SetMultiSelect(Value : Boolean);
        function GetMaxLength : Integer;
        procedure SetMaxLength(Value : Integer);
        procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
        function CalcTextMargin : integer;
        procedure KeyPress(var Key: Char);override;
        procedure KeyDown(var Key: Word; Shift: TShiftState); override;
        procedure PonerEnEdicion(var Key: Char);
    protected
        procedure Click; override;
        procedure DblClick; override;
        procedure Loaded; override;
        procedure doExit;override;

    public
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
        property Editable: Boolean read GetEditable write SetEditable default False;
        property CanInsert: Boolean read GetCanInsert write SetCanInsert default False;
        property CanDelete: Boolean read GetCanDelete write SetCanDelete default False;
        property MultiSelect: Boolean read GetMultiselect write SetMultiselect default False;
        property MaxLength: Integer read GetMaxLength write SetMaxLength default 0;
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        property OnKeyUp;
        property OnKeyDown;
        property OnKeyPress;
        property OnEnter;
        property OnExit;
        property Alignment : TAlignment read GetAlignment write SetAlignment;
  end;
procedure Register;

implementation

procedure Register;
begin
     RegisterComponents('Standard', [TJustListBox]);
end;

function TJustListBox.GetAlignment : TAlignment;
begin
     Result := FAlignment
end;

procedure TJustListBox.SetAlignment(Value : TAlignment);
begin
     FAlignment := Value;
end;

function TJustListBox.GetEditable : Boolean;
begin
     Result := FEditable;
end;

procedure TJustListBox.SetEditable(Value : Boolean);
begin
     FEditable := Value;
     if Value then
        MultiSelect := False;
end;

function TJustListBox.GetCanInsert : Boolean;
begin
     Result := FCanInsert;
end;

procedure TJustListBox.SetCanInsert(Value : Boolean);
begin
     FCanInsert := Value;
     if Value then
        Editable := True;
end;

function TJustListBox.GetCanDelete : Boolean;
begin
     Result := FCanDelete;
end;

procedure TJustListBox.SetCanDelete(Value : Boolean);
begin
     FCanDelete := Value;
     if Value then
        Editable := True;
end;

function TJustListBox.GetMultiSelect : Boolean;
begin
     Result := FMultiselect;
end;

procedure TJustListBox.SetMultiSelect(Value : Boolean);
begin
     FMultiSelect := Value;
     if Value then
     begin
          FEditable := False;
          FCanInsert := False;
          FCanDelete := False;
     end;
end;

function TJustListBox.GetMaxLength : Integer;
begin
     Result := FMaxLength;
end;

procedure TJustListBox.SetMaxLength(Value : Integer);
begin
     FMaxLength := Value;
     EditListBox1.MaxLength := Value;
end;

procedure TJustListBox.Click;
begin
     inherited Click;
     Repaint;
end;

procedure TJustListBox.DblClick;
var
   Key: Char;
begin
     Key := chr(0);
     if FEditable then
        PonerEnEdicion(Key);
     inherited DblClick;
     Repaint;
end;

procedure TJustListBox.KeyDown(var Key: Word; Shift: TShiftState);
var
   Tecla: Char;
begin
     Tecla := char(Key);
     if Key = VK_DELETE then
     begin
          if FCanDelete then
          begin
               if Items.Count > 0 then
                  if ItemIndex > -1 then
                     Items.Delete(ItemIndex);
               if Items.Count > 0 then
                  ItemIndex := 0;
          end;
     end
     else
         if Key = VK_INSERT then
         begin
              if FCanInsert then
              begin
                   if Items.Count > 0 then
                   begin
                        Items.Insert(ItemIndex, 'Nuevo Item');
                        ItemIndex := ItemIndex - 1;
                   end
                   else
                   begin
                        Items.Insert(0, 'Nuevo Item');
                        ItemIndex := 0;
                   end;
                   if Items.Count > 0 then
                      PonerEnEdicion(Tecla);
              end;
         end
         else
             if ((Key in [VK_DOWN, VK_RIGHT]) and (ItemIndex = Items.Count - 1)) or
                ((Key = VK_RETURN) and (Items.Count = 0)) then
             begin
                  if FEditable then
                  begin
                       Items.Add('Nuevo Item');
                       ItemIndex := Items.Count - 1;
                       PonerEnEdicion(Tecla);
                  end;
             end
             else
                 if not FEditable then
                    inherited KeyDown(Key, []);

end;
procedure TJustListBox.KeyPress(var Key : Char);
const
     TabKey = Char(VK_TAB);
     EnterKey = Char(VK_RETURN);
begin
     if not (Key in [chr(VK_LEFT), chr(VK_RIGHT), chr(VK_UP), chr(VK_DOWN), chr(VK_INSERT), chr(VK_DELETE)]) then
        if ItemIndex > -1 then
           if FEditable then
           begin
                PonerEnEdicion(Key);
                Key := #0;
           end
           else
               inherited KeyPress(Key);
end;

procedure TJustListBox.PonerEnEdicion(var Key: Char);
begin
     IndicedeLista := ItemIndex;
     EditListBox1.Text := Items[ItemIndex];
     EditListBox1.Top := ItemHeight * (ItemIndex);
     EditListBox1.BringToFront;
     EditListBox1.Visible := true;
     if Key in [chr(VK_DOWN), chr(VK_RIGHT)] then
        Key := chr(0);
     EditListBox1.KeyPress(Key);
     EditListBox1.SetFocus;
end;

constructor TJustListBox.Create(AOwner: TComponent);
var
   Altura: Integer;
   Anchura: Integer;
   Fuente: TFont;
   Texto: String;
begin
     EditListBox1 := (TEditListBox.Create(nil));
     EditListBox1.Parent := inherited Create(AOwner);
     Altura := ItemHeight;
     Anchura := Width;
     Fuente := Font;
     FTextMargin := CalcTextMargin;
     with EditListBox1 do
     begin
          Visible := False;
          BorderStyle := bsNone;
          Font.Name := Fuente.Name;
          Font.Size := Fuente.Size;
          Height := Altura - 2;
          width := Anchura - 4;
     end;

end;

destructor TJustListBox.Destroy;
begin
     inherited Destroy;
end;

procedure TJustListBox.Loaded;
begin
     inherited Loaded;
end;

procedure TJustListBox.doExit;
begin
     ItemIndex := -1;
     Repaint;
     inherited doExit;
end;

procedure TEditListBox.doExit;
begin
     inherited doExit;
     if (Text = 'Nuevo Item') or
        (Text = '') then
     begin
          (Parent as TJustListBox).Items.Delete((Parent as TJustListBox).ItemIndex);
          (Parent as TJustListBox).SetFocus;
          (Parent as TJustListBox).ItemIndex := (Parent as TJustListBox).Items.Count - 1;
     end
     else
     begin
          (Parent as TJustListBox).Items[(Parent as TJustListBox).ItemIndex] := Text;
          (Parent as TJustListBox).SetFocus;
          (Parent as TJustListBox).ItemIndex := (Parent as TJustListBox).IndicedeLista;
     end;
end;

procedure TEditListBox.KeyDown(var Key: Word; Shift: TShiftState);
begin
     if Key = VK_ESCAPE then
     begin
          Text := (Parent as TJustListBox).Items[(Parent as TJustListBox).ItemIndex];
          Visible := False;
          Parent.SetFocus;
     end;
     if Key = VK_RETURN then
     begin
          Visible := False;
          Parent.SetFocus;
     end;
     if Key in [VK_UP, VK_DOWN] then
     begin
          if Key = VK_UP then
             if ((Parent as TJustListBox).ItemIndex > 0) then
             begin
                  (Parent as TJustListBox).IndicedeLista := (Parent as TJustListBox).IndicedeLista - 1;
             end
             else
                 (Parent as TJustListBox).IndicedeLista := 0;
          if Key = VK_DOWN then
             if (Parent as TJustListBox).ItemIndex < (Parent as TJustListBox).Items.Count - 1 then
             begin
                  (Parent as TJustListBox).IndicedeLista := (Parent as TJustListBox).IndicedeLista + 1;
             end
             else
                 (Parent as TJustListBox).IndicedeLista := (Parent as TJustListBox).Items.Count - 1;
          Visible := False;
          Parent.SetFocus;
     end;
end;

procedure TJustListBox.WMPaint(var Message: TWMPaint);
var
  Width, Indent, Left, I: Integer;
  R: TRect;
  DC: HDC;
  PS: TPaintStruct;
  S: string;
  Canvas: TControlCanvas;
  n, altura: Integer;
  ItemSeleccionado: Integer;
begin
  ItemSeleccionado := ItemIndex;
  if (FAlignment = taLeftJustify) then
  begin
       inherited;
       Exit;
  end;
        try
           Canvas := TControlCanvas.Create;
           Canvas.Control := Self;
           DC := Message.DC;
           if DC = 0 then
              DC := BeginPaint(Handle, PS);
           Canvas.Handle := DC;
           Canvas.Font := Font;
           with Canvas do
           begin
                if Items.Count > 0 then
                   for n := 0 to Items.Count - 1 do
                   begin
                        if not Selected[n] then
                        begin
                             S := Items[n];
                             R := ClientRect;
                             R.Top := ItemHeight * n;
                             R.Bottom := ItemHeight * (n + 1) ;
                             if (BorderStyle = bsSingle) then
                             begin
                                  Brush.Color := clWindowFrame;
                                  FrameRect(R);
                                  InflateRect(R, 0, 0);
                             end;
                             Brush.Color := Color;
                             Pen.Style := psClear;
                             Font.Color := clWindowText;
                             Width := TextWidth(S);
                             if BorderStyle = bsNone then
                                Indent := 0
                             else
                                 Indent := FTextMargin;
                             Altura := ItemHeight * n;
                             if FAlignment = taRightJustify then
                                Left := R.Right - Width - Indent
                             else
                                 Left := (R.Left + R.Right - Width) div 2;
                             TextRect(R, Left, Altura, S);
                        end
                        else
                        begin
                             S := Items[n];
                             R := ClientRect;
                             R.Top := ItemHeight * n;
                             R.Bottom := ItemHeight * (n + 1);
                             if (BorderStyle = bsSingle) then
                             begin
                                  Brush.Color := clWindowFrame;
                                  FrameRect(R);
                                  InflateRect(R, 0, 0);
                             end;
                             Brush.Color := clHighlight;
                             Pen.Style := psDot;
                             FrameRect(R);
                             Font.Color := clWhite;
                             Width := TextWidth(S);
                             Altura := ItemHeight * n;
                             TextRect(R, 0, Altura, S);
                             ItemIndex := ItemSeleccionado;
                        end;

                   end;
           end;
        finally
               Canvas.Handle := 0;
               if Message.DC = 0 then
               EndPaint(Handle, PS);
        end;
end;

function TJustListBox.CalcTextMargin : integer;
var
  DC: HDC;
  SaveFont: HFont;
  I: Integer;
  SysMetrics, Metrics: TTextMetric;
begin
  DC := GetDC(0);
  GetTextMetrics(DC, SysMetrics);
  SaveFont := SelectObject(DC, Font.Handle);
  GetTextMetrics(DC, Metrics);
  SelectObject(DC, SaveFont);
  ReleaseDC(0, DC);
  I := SysMetrics.tmHeight - 1;
  if I > Metrics.tmHeight then I := Metrics.tmHeight - 1;
  Result := I div 4;
end;

end.
