{*****************************************************************************
 TjgNTShares v1.0 by John Gonzalez 1999

 Description : Component to interface with the NetShare* API's.

 Events :
   OnGotShareList - Called when a list of shares have been retrieved in
                    asynchronous mode.

 Methods :
   Execute - Retrieves the shares on specified machine. Works in the
             background if the async parameter is true.

 Properties :
   Items - List of shares retrieved.
   ErrorCode - Win32 error code if there was a problem.
   MachineName - Machine to enumerate shares on.

 Revision History :
   6/10/99 Initial release.

*****************************************************************************}
unit jgNTShares;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     jgNTCommon, jgNTSharesC, jgNTBase;

type
  TjgNTShares = class(TjgNTBase)
  private
    comp : TjgNTSharesC;
    FOnGotShareList : TNotifyEvent;
    function  GetItems : TShareItemList;
    function  GetMachineName : string;
    procedure SetMachineName(const value: string);
    procedure DoOnGotShareList;
    function  GetErrorCode : DWord;
  public
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    function Execute(async : boolean) : boolean;
    property Items : TShareItemList read GetItems;
    property ErrorCode : DWord read GetErrorCode;
  published
    property MachineName : string read GetMachineName write SetMachineName;
    property OnGotShareList : TNotifyEvent read FOnGotShareList write FOnGotShareList;
  end;

  TGetShareListThread = class(TThread)
  private
    FOwner : TjgNTShares;
    procedure Finished;
  protected
    procedure Execute; override;
  public
    constructor Create(owner : TjgNTShares);
  end;

implementation

{ TjgNTShares }

{*****************************************************************************}
constructor TjgNTShares.Create(AOwner: TComponent);
begin
  comp:= TjgNTSharesC.Create;
  inherited;
end;

{*****************************************************************************}
destructor TjgNTShares.Destroy;
begin
  comp.Free;
  inherited;
end;

{*****************************************************************************}
function TjgNTShares.GetItems : TShareItemList;
begin
  result:= comp.items;
end;

{*****************************************************************************}
function TjgNTShares.Execute(async : boolean) : boolean;
begin
  result:= true;
  if async then TGetShareListThread.Create(self)
  else result:= comp.Execute;
end;

{*****************************************************************************}
procedure TjgNTShares.DoOnGotShareList;
begin
  if Assigned(FOnGotShareList) then FOnGotShareList(self);
end;

{*****************************************************************************}
function TjgNTShares.GetMachineName : string;
begin
  result:= comp.MachineName;
end;

{*****************************************************************************}
procedure TjgNTShares.SetMachineName(const value : string);
begin
  comp.MachineName:= value;
end;

{*****************************************************************************}
function TjgNTShares.GetErrorCode: DWord;
begin
  result:= comp.ErrorCode;
end;

{ TGetShareListThread }

{*****************************************************************************}
constructor TGetShareListThread.Create(owner : TjgNTShares);
begin
  FOwner:= owner;
  freeOnTerminate:= true;
  inherited Create(false);
end;

{*****************************************************************************}
procedure TGetShareListThread.Execute;
begin
  FOwner.comp.Execute;
  Synchronize(Finished);
end;

{*****************************************************************************}
procedure TGetShareListThread.Finished;
begin
  FOwner.DoOnGotShareList;
end;

end.
