{*****************************************************************************
 TjgNTMessengerC v1.0 by John Gonzalez 1999

 Description :
   Sends a text message to an NT or 9x (WinPopup) machine.

 Events : None

 Methods :
   Execute - Sends the text to the destination machine.

 Properties :
   Destination - The name of the destination machine. (NETBIOS name)
   DestType - Indicates whether the destination machine is NT or 9x. This
              determines the method used to send the text.
   Source - Text describing the originating machine.
   Text - The text to send.

 Revision History :
   6/10/99  Initial release.

*****************************************************************************}
unit jgNTMessengerC;

interface

uses Windows, SysUtils, Classes, jgNTBaseC, jgNTCommon, jgNTApi;

type
  TDestType = (dtNT, dt9x);
  TjgNTMessengerC = class(TjgNTBaseC)
  private
    FDestination : string;
    FSource : string;
    FText : string;
    FDestType : TDestType;
    function SendNT : boolean;
    function Send9x : boolean;
  public
    constructor Create;
    function  Execute : boolean;
    property  Destination : string read FDestination write FDestination;
    property  DestType : TDestType read FDestType write FDestType;
    property  Source : string read FSource write FSource;
    property  Text : string read FText write FText;
  end;

implementation

{******************************************************************************}
constructor TjgNTMessengerC.Create;
begin
  FDestType:= dtNT;
end;

{*****************************************************************************}
function TjgNTMessengerC.SendNT : boolean;
var
  src, dest : array [0..16] of WideChar;
  pSrc, msgText : PWideChar;
  size : DWord;
begin
  FErrorCode:= 0; { Default to no error }

  { Convert destination to UNICODE }
  FillChar(dest,SizeOf(dest),0);
  StringToWideChar(FDestination,dest,SizeOf(dest));

  { Convert source to UNICODE. If source is not specified get computer name }
  if Length(FSource) = 0 then FSource:= jgGetComputerName;
  FillChar(src,SizeOf(src),0);
  StringToWideChar(FSource,src,SizeOf(src));
  pSrc:= @src;

  { Convert text to UNICODE. Allocate a buffer because we never know how
    big text could be }
  size:= Length(Ftext) * 2 + 2;
  GetMem(msgText,size);
  try
    FillChar(msgText^,size,0);
    StringToWideChar(FText,msgText,size);
    if NetMessageBufferSend(nil,dest,pSrc,msgText,size) <> 0 then
      FErrorCode:= GetLastError;
  finally
    FreeMem(msgText);
  end;
  result:= FErrorCode = 0;
end;

{*****************************************************************************}
function TjgNTMessengerC.Send9x : boolean;
var
  hSlot : THandle;
  bytesWritten : DWord;
  slotName, msg : string;
begin
  result:= false;
  slotName:= '\\' + FDestination + '\mailslot\messngr';
  hSlot:= CreateFile(PChar(slotName),GENERIC_WRITE,FILE_SHARE_READ,
                     nil,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
  if hSlot = INVALID_HANDLE_VALUE then
    begin
      FErrorCode:= GetLastError;
      exit;
    end;
  if Length(FSource) = 0 then FSource:= jgGetComputerName;
  msg:= source + #0 + FDestination + #0 + FText;
  try
    bytesWritten:= 0;
    if (not WriteFile(hSlot,Pointer(msg)^,Length(msg),bytesWritten,nil)) or
        (bytesWritten <> Length(msg)) then
      begin
        FErrorCode:= GetLastError;
        exit;
      end;
  finally
    CloseHandle(hSlot);
  end;
  result:= FErrorCode = 0;
end;

{*****************************************************************************}
function TjgNTMessengerC.Execute : boolean;
begin
  if FDestType = dtNT then result:= SendNT else result:= Send9x;
end;

end.

