{*****************************************************************************
 TjgNTMessenger v1.0 by John Gonzalez 1999

 Description : Sends a message to an NT or 9x (WinPopup) machine.

 Events :
   None

 Methods :
   Execute - Sends the text.

 Properties :
   Destination - Name of destination machine.
   Source - Name of originating machine.
   Text - Actual text to send.
   DestType - Specifies the destination machine as W9x or NT.

 Revision History :
   6/10/99  Initial release.

*****************************************************************************}
unit jgNTMessenger;

interface

uses Windows, SysUtils, Classes, jgNTCommon, jgNTApi, jgNTBase, jgNTMessengerC;

type
  TjgNTMessenger = class(TjgNTBase)
  private
    comp : TjgNTMessengerC;
    function  GetDestination: string;
    function  GetDestType: TDestType;
    function  GetSource: string;
    function  GetText: string;
    procedure SetDestination(const Value: string);
    procedure SetDestType(const Value: TDestType);
    procedure SetSource(const Value: string);
    procedure SetText(const Value: string);
    function  GetErrorCode: DWord;
  public
    constructor Create(AOwner : TComponent); override;
    destructor  Destroy; override;
    function Execute : boolean;
  published
    property Destination : string read GetDestination write SetDestination;
    property ErrorCode : DWord read GetErrorCode;
    property Source : string read GetSource write SetSource;
    property Text : string read GetText write SetText;
    property DestType : TDestType read GetDestType write SetDestType default dtNT;
  end;

implementation

{*****************************************************************************}
constructor TjgNTMessenger.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  comp:= TjgNTMessengerC.Create;
  comp.destType:= dtNT;
end;

{*****************************************************************************}
destructor TjgNTMessenger.Destroy;
begin
  inherited Destroy;
  comp.Free;
end;

{*****************************************************************************}
function TjgNTMessenger.Execute : boolean;
begin
  result:= comp.Execute;
end;

{*****************************************************************************
* Description :
*
*****************************************************************************}
function TjgNTMessenger.GetDestination: string;
begin
  result:= comp.destination;
end;

{*****************************************************************************
* Description :
*
*****************************************************************************}
function TjgNTMessenger.GetDestType: TDestType;
begin
  result:= comp.destType;
end;

{*****************************************************************************
* Description :
*
*****************************************************************************}
function TjgNTMessenger.GetErrorCode: DWord;
begin
  result:= comp.ErrorCode;
end;

{******************************************************************************}
function TjgNTMessenger.GetSource: string;
begin
  result:= comp.source;
end;

{*****************************************************************************
* Description :
*
*****************************************************************************}
function TjgNTMessenger.GetText: string;
begin
  result:= comp.text;
end;

{*****************************************************************************
* Description :
*
*****************************************************************************}
procedure TjgNTMessenger.SetDestination(const Value: string);
begin
  comp.destination:= value;
end;

{*****************************************************************************
* Description :
*
*****************************************************************************}
procedure TjgNTMessenger.SetDestType(const Value: TDestType);
begin
  comp.destType:= value;
end;

{*****************************************************************************
* Description :
*
*****************************************************************************}
procedure TjgNTMessenger.SetSource(const Value: string);
begin
  comp.source:= value;
end;

{*****************************************************************************
* Description :
*
*****************************************************************************}
procedure TjgNTMessenger.SetText(const Value: string);
begin
  comp.text:= value;
end;

end.

