{*****************************************************************************
 TjgNTjobs v1.0 by John Gonzalez 1999

 Description : Component to interface with the Netjob* API's.

 Events :
   OnGotjobList - Called when a list of jobs have been retrieved in
                  asynchronous mode.

 Methods :
   Execute - Retrieves the jobs on specified machine.
             Runs in the background if parameter is true.

 Properties :
   Items - List of jobs retrieved.
   ErrorCode - WIN32 error code if there was a problem.
   MachineName - Machine to enumerate jobs on.

 Revision History :
   6/10/99 Initial release.

*****************************************************************************}
unit jgNTJobs;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
     jgNTCommon, jgNTJobsC, jgNTBase;

type
  TjgNTJobs = class(TjgNTBase)
  private
    comp : TjgNTJobsC;
    FOnGotJobList : TNotifyEvent;
    function  GetItems: TJobItemList;
    function  GetMachineName: string;
    procedure SetMachineName(const value: string);
    procedure DoOnGotJobList;
    function  GetErrorCode: DWord;
  public
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy; override;
    function  Execute(async : boolean) : boolean;
    function  IsServiceRunning : boolean;
    procedure StartJobService;
    property Items : TJobItemList read GetItems;
    property ErrorCode : DWord read GetErrorCode;
  published
    property MachineName : string read GetMachineName write SetMachineName;
    property OnGotJobList : TNotifyEvent read FOnGotJobList write FOnGotJobList;
  end;

  { TGetjobListThread }
  TGetJobListThread = class(TThread)
  private
    FOwner : TjgNTJobs;
    procedure Finished;
  protected
    procedure Execute; override;
  public
    constructor Create(owner : TjgNTJobs);
  end;

implementation

{*****************************************************************************}
constructor TjgNTJobs.Create(AOwner: TComponent);
begin
  comp:= TjgNTJobsC.Create;
  inherited;
end;

{*****************************************************************************}
destructor TjgNTJobs.Destroy;
begin
  comp.Free;
  inherited;
end;

{*****************************************************************************}
function TjgNTJobs.GetItems : TJobItemList;
begin
  result:= comp.items;
end;

{*****************************************************************************}
function TjgNTJobs.Execute(async : boolean) : boolean;
begin
  result:= true;
  if async then TGetJobListThread.Create(self)
  else result:= comp.Execute;
end;

{******************************************************************************}
function TjgNTJobs.IsServiceRunning: boolean;
begin
  result:= comp.IsServiceRunning;
end;

{******************************************************************************}
procedure TjgNTJobs.StartJobService;
begin
  comp.StartJobService;
end;

{*****************************************************************************}
procedure TjgNTJobs.DoOnGotJobList;
begin
  if Assigned(FOnGotJobList) then FOnGotJobList(self);
end;

{*****************************************************************************}
function TjgNTJobs.GetMachineName : string;
begin
  result:= comp.MachineName;
end;

{*****************************************************************************}
procedure TjgNTJobs.SetMachineName(const value : string);
begin
  comp.MachineName:= value;
end;

{*****************************************************************************}
function TjgNTJobs.GetErrorCode: DWord;
begin
  result:= comp.ErrorCode;
end;

{ TGetJobListThread }

{*****************************************************************************}
constructor TGetJobListThread.Create(owner : TjgNTJobs);
begin
  FOwner:= owner;
  freeOnTerminate:= true;
  inherited Create(false);
end;

{*****************************************************************************}
procedure TGetJobListThread.Execute;
begin
  FOwner.comp.Execute;
  Synchronize(Finished);
end;

{*****************************************************************************}
procedure TGetJobListThread.Finished;
begin
  FOwner.DoOnGotJobList;
end;

end.
