unit jgNTCommon;

interface

uses Windows, SysUtils;

type
  EjgNT = class(Exception)
  public
    error : DWord;
    constructor Create(const msg : string; errorCode : integer);
  end;

function jgGetPDC(domain : string) : string;
function jgIsDelphiRunning : boolean;
function jgGetComputerName : string;

implementation

uses jgNTApi;

{ EjgNT }

{*****************************************************************************}
constructor EjgNT.Create(const msg : string; errorCode : integer);
begin
  error:= errorCode;
  inherited Create(msg);
end;

{*****************************************************************************}
function jgGetPDC(domain : string) : string;
var
  controller : PWideChar;
  buffer : array[0..128] of WideChar;
  size : DWord;
begin
  { Convert domain to unicode }
  size:= SizeOf(buffer);
  NetGetDCName(nil,StringToWideChar(domain,buffer,size),pointer(controller));

  { Convert controller to ANSI }
  result:= WideCharToString(controller);
  NetApiBufferFree(controller);
end;

{*****************************************************************************}
function jgIsDelphiRunning : boolean;
begin
  result:= FindWindow('TApplication'#0,nil) +
           FindWindow('TAlignPalette'#0,nil) +
           FindWindow('TPropertyInspector'#0,nil) +
           FindWindow('TAppBuilder'#0,nil) > 0;
end;

{******************************************************************************}
function jgGetComputerName : string;
var
  size : DWord;
  buffer : array[0..16] of char;
begin
  size:= SizeOf(buffer);
  GetComputerName(buffer,size);
  result:= StrPas(buffer);
end;

end.
