{*****************************************************************************
 TjgNTBase v1.0 by John Gonzalez 1999

 Description : Base TComponent descendent for all Form based NT components.

 Events :
   None

 Methods :
   None

 Properties :
   About - Displays about box at design time.

 Revision History :
   6/10/99  Initial release.

*****************************************************************************}
unit jgNTBase;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, DsgnIntf;

type
  TjgNTAboutBoxProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TJGNTBase = class(TComponent)
  private
    FAbout: TjgNTAboutBoxProperty;
  published
    property About: TjgNTAboutBoxProperty read FAbout write FAbout;
  end;

procedure Register;

implementation

uses jgNTAbout;

{*****************************************************************************}
procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TjgNTAboutBoxProperty),nil,
                         'ABOUT', TjgNTAboutBoxProperty);
end;

{*****************************************************************************}
procedure TjgNTAboutBoxProperty.Edit;
begin
  with TfrmAbout.Create(nil) do
    begin
      ShowModal;
      Free;
    end;
end;

{*****************************************************************************}
function TjgNTAboutBoxProperty.GetAttributes: TPropertyAttributes;
begin
  result:= [paMultiSelect, paDialog, paReadOnly];
end;

{*****************************************************************************}
function TjgNTAboutBoxProperty.GetValue: string;
begin
  result:= 'About jgNT Components';
end;

end.
