{*****************************************************************************
 jgNTApi v1.0 by John Gonzalez 1999

 Description : Pascal conversions of needed header files.

 Revision History :
   Initial release 6/10/99

*****************************************************************************}
unit jgNTApi;

interface

uses Windows;

{*****************************************************************************}
{ ?? }
const
  STATUS_MORE_ENTRIES    = $00000105;
  STATUS_NO_MORE_ENTRIES = $8000001A;

{*****************************************************************************}
{ lmcons.h }
type
  NET_API_STATUS = DWORD;

{*****************************************************************************}
{ lmerr.h }
const
  NERR_Success = 0;
  NERR_BASE = 2100;
  NERR_InvalidComputer = NERR_BASE + 251; // This computer name is invalid.

{*****************************************************************************}
{ winnt.h }
type
  SID_NAME_USE = integer;
  PSID_NAME_USE = ^SID_NAME_USE;

  PSID_IDENTIFIER_AUTHORITY = ^SID_IDENTIFIER_AUTHORITY;
  SID_IDENTIFIER_AUTHORITY = record
    value : array[0..5] of byte;
  end;

  PACL = ^ACL;
  ACL = record
    aclRevision, sbz1 : byte;
    aclSize, aceCount, sbz2 : Word;
  end;

  { ACL_SIZE_INFORMATION }
  PACL_SIZE_INFORMATION = ^ACL_SIZE_INFORMATION;
  ACL_SIZE_INFORMATION = record
    AceCount, AclBytesInUse, AclBytesFree : DWORD;
  end;

  { ACE_HEADER}
  PACE_HEADER = ^ACE_HEADER;
  ACE_HEADER = record
    AceType : BYTE;
    AceFlags : BYTE;
    AceSize : WORD;
  end;

  { ACCESS_ALLOWED_ACE }
  PACCESS_ALLOWED_ACE = ^ACCESS_ALLOWED_ACE;
  ACCESS_ALLOWED_ACE = record
    header : ACE_HEADER;
    mask : ACCESS_MASK;
    sidStart : DWORD;
  end;

  { ACCESS_DENIED_ACE }
  PACCESS_DENIED_ACE = ^ACCESS_DENIED_ACE;
  ACCESS_DENIED_ACE = record
    header : ACE_HEADER;
    mask : ACCESS_MASK;
    sidStart : DWORD;
  end;

  PSECURITY_ATTRIBUTES = ^SECURITY_ATTRIBUTES;
  SECURITY_ATTRIBUTES = record
    nLength : DWord;
    lpSecurityDescriptor : pointer;
    bInheritHandle : boolean;
  end;

  SECURITY_DESCRIPTOR = pointer;

const
  SID_REVISION = 1;

  { Access Types }
  NOT_USED_ACCESS   = 0;
  GRANT_ACCESS      = 1;
  SET_ACCESS        = 2;
  DENY_ACCESS       = 3;
  REVOKE_ACCESS     = 4;
  SET_AUDIT_SUCCESS = 5;
  SET_AUDIT_FAILURE = 6;

  { ACE Types }
  ACCESS_ALLOWED_ACE_TYPE = 0;
  ACCESS_DENIED_ACE_TYPE  = 1;
  SYSTEM_AUDIT_ACE_TYPE   = 2;
  SYSTEM_ALARM_ACE_TYPE   = 3;

  { User Types }
  SidTypeUser = 1;
  SidTypeGroup = 2;
  SidTypeDomain = 3;
  SidTypeAlias = 4;
  SidTypeWellKnownGroup = 5;
  SidTypeDeletedAccount = 6;
  SidTypeInvalid = 7;
  SidTypeUnknown = 8;

  SECURITY_DESCRIPTOR_REVISION = 1;
  ACL_REVISION  = 2;
  ACL_REVISION1 = 1;
  ACL_REVISION2 = 2;
  ACL_REVISION3 = 3;

  { Start Type }
  SERVICE_BOOT_START   = $00000000;
  SERVICE_SYSTEM_START = $00000001;
  SERVICE_AUTO_START   = $00000002;
  SERVICE_DEMAND_START = $00000003;
  SERVICE_DISABLED     = $00000004;

  { Service Types (Bit Mask) }
  SERVICE_WIN32_OWN_PROCESS   =  $00000010;
  SERVICE_WIN32_SHARE_PROCESS =  $00000020;
  SERVICE_WIN32               =  (SERVICE_WIN32_OWN_PROCESS or
                                   SERVICE_WIN32_SHARE_PROCESS);

  SERVICE_KERNEL_DRIVER      =  $00000001;
  SERVICE_FILE_SYSTEM_DRIVER =  $00000002;
  SERVICE_ADAPTER            =  $00000004;
  SERVICE_RECOGNIZER_DRIVER  =  $00000008;
  SERVICE_DRIVER             =  (SERVICE_KERNEL_DRIVER or
                                 SERVICE_FILE_SYSTEM_DRIVER or
                                 SERVICE_RECOGNIZER_DRIVER);

  SERVICE_INTERACTIVE_PROCESS =  $00000100;

  SERVICE_TYPE_ALL =  (SERVICE_WIN32 or SERVICE_ADAPTER or
                       SERVICE_DRIVER or SERVICE_INTERACTIVE_PROCESS);

  { Error control type }
  SERVICE_ERROR_IGNORE   = $00000000;
  SERVICE_ERROR_NORMAL   = $00000001;
  SERVICE_ERROR_SEVERE   = $00000002;
  SERVICE_ERROR_CRITICAL = $00000003;

  EVENTLOG_SUCCESS          = $0000;
  EVENTLOG_ERROR_TYPE       = $0001;
  EVENTLOG_WARNING_TYPE     = $0002;
  EVENTLOG_INFORMATION_TYPE = $0004;
  EVENTLOG_AUDIT_SUCCESS    = $0008;
  EVENTLOG_AUDIT_FAILURE    = $0010;

  FILE_READ_DATA            = $0001;     // file & pipe
  FILE_LIST_DIRECTORY       = $0001;     // directory
  FILE_WRITE_DATA           = $0002;     // file & pipe
  FILE_ADD_FILE             = $0002;     // directory
  FILE_APPEND_DATA          = $0004;     // file
  FILE_ADD_SUBDIRECTORY     = $0004;     // directory
  FILE_CREATE_PIPE_INSTANCE = $0004;     // named pipe
  FILE_READ_EA              = $0008;     // file & directory
  FILE_READ_PROPERTIES      = FILE_READ_EA;
  FILE_WRITE_EA             = $0010;    // file & directory
  FILE_WRITE_PROPERTIES     = FILE_WRITE_EA;
  FILE_EXECUTE              = $0020;    // file
  FILE_TRAVERSE             = $0020;    // directory
  FILE_DELETE_CHILD         = $0040;    // directory
  FILE_READ_ATTRIBUTES      = $0080;    // all
  FILE_WRITE_ATTRIBUTES     = $0100;    // all
  FILE_ALL_ACCESS           = STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or $1FF;
  FILE_GENERIC_READ         = STANDARD_RIGHTS_READ or FILE_READ_DATA or
                              FILE_READ_ATTRIBUTES or FILE_READ_EA or
                              SYNCHRONIZE;
  FILE_GENERIC_WRITE        = STANDARD_RIGHTS_WRITE or FILE_WRITE_DATA or
                              FILE_WRITE_ATTRIBUTES or FILE_WRITE_EA or
                              FILE_APPEND_DATA or SYNCHRONIZE;
  FILE_GENERIC_EXECUTE      = STANDARD_RIGHTS_EXECUTE or FILE_READ_ATTRIBUTES or
                              FILE_EXECUTE or SYNCHRONIZE;
  FILE_SHARE_READ               = $00000001;
  FILE_SHARE_WRITE              = $00000002;
  FILE_ATTRIBUTE_READONLY       = $00000001;
  FILE_ATTRIBUTE_HIDDEN         = $00000002;
  FILE_ATTRIBUTE_SYSTEM         = $00000004;
  FILE_ATTRIBUTE_DIRECTORY      = $00000010;
  FILE_ATTRIBUTE_ARCHIVE        = $00000020;
  FILE_ATTRIBUTE_NORMAL         = $00000080;
  FILE_ATTRIBUTE_TEMPORARY      = $00000100;
  FILE_ATTRIBUTE_COMPRESSED     = $00000800;
  FILE_NOTIFY_CHANGE_FILE_NAME  = $00000001;
  FILE_NOTIFY_CHANGE_DIR_NAME   = $00000002;
  FILE_NOTIFY_CHANGE_ATTRIBUTES = $00000004;
  FILE_NOTIFY_CHANGE_SIZE       = $00000008;
  FILE_NOTIFY_CHANGE_LAST_WRITE = $00000010;
  FILE_NOTIFY_CHANGE_SECURITY   = $00000100;
  MAILSLOT_NO_MESSAGE           = -1;
  MAILSLOT_WAIT_FOREVER         = -1;
  FILE_CASE_SENSITIVE_SEARCH    = $00000001;
  FILE_CASE_PRESERVED_NAMES     = $00000002;
  FILE_UNICODE_ON_DISK          = $00000004;
  FILE_PERSISTENT_ACLS          = $00000008;
  FILE_FILE_COMPRESSION         = $00000010;
  FILE_VOLUME_IS_COMPRESSED     = $00008000;

  function AddAccessAllowedAce(acl : PACL; dwAceRevision, accessMask : DWord;
                               pSid : PSID) : boolean; stdcall;

{*****************************************************************************}
{ lmaccess.h }
type
  TUserInfo3 = record
    name : PWideChar;
    password : PWideChar;
    passwordAge : LongInt;
    priv : LongInt;
    homeDir : PWideChar;
    comment : PWideChar;
    flags : LongInt;
    scriptPath : PWideChar;
    authFlags : LongInt;
    fullName : PWideChar;
    usrComment : PWideChar;
    parms : PWideChar;
    workstations : PWideChar;
    lastLogon : LongInt;
    lastLogoff : LongInt;
    acctExpires : LongInt;
    maxStorage : LongInt;
    unitsPerWeek : LongInt;
    logonHours : PBYTE;
    badPwCount : LongInt;
    numLogons : LongInt;
    logonServer : PWideChar;
    countryCode : LongInt;
    codePage : LongInt;
    userId : LongInt;
    primaryGroupId : LongInt;
    profile : PWideChar;
    homeDirDrive : PWideChar;
    passwordExpired : LongInt;
  end;

  TLocalGroupInfo1 = record
    name : PWideChar;
    comment : PWideChar;
  end;

  TNetDisplayUser = record
    name : PWideChar;
    comment : PWideChar;
    flags : LongInt;
    fullName : PWideChar;
    userId : LongInt;
    nextIndex : LongInt;
  end;

  TNetDisplayMachine = record
    name : PWideChar;
    comment : PWideChar;
    flags : DWORD;
    userId : DWORD;
    nextIndex : DWORD;
  end;

  TNetDisplayGroup = record
    name : LPWSTR;
    comment : LPWSTR;
    groupId : DWORD;
    attributes : DWORD;
    nextIndex : DWORD;
  end;

const
  ACCESS_NONE   = $00;
  ACCESS_READ   = $01;
  ACCESS_WRITE  = $02;
  ACCESS_CREATE = $04;
  ACCESS_EXEC   = $08;
  ACCESS_DELETE = $10;
  ACCESS_ATRIB  = $20;
  ACCESS_PERM   = $40;
  ACCESS_ALL    = ACCESS_READ or ACCESS_WRITE or
                  ACCESS_CREATE or ACCESS_EXEC or
                  ACCESS_DELETE or ACCESS_ATRIB or
                  ACCESS_PERM;

  function NetQueryDisplayInformation(serverName : LPWSTR; level : DWORD; index : DWORD; entriesRequested : DWORD;
                                      preferredMaximumLength : DWORD; var returnedEntryCount : DWORD;
                                      var sortedBuffer : pointer) : NET_API_STATUS;  stdcall;
  function NetGetDCName(const serverName, domainName : PWideChar; var bufptr : pointer) :
                        NET_API_STATUS; stdcall;
  function NetGetAnyDCName(serverName, domainName : LPWSTR; var dcName : pointer) :
                           NET_API_STATUS; stdcall;
  function NetLocalGroupEnum(serverName : LPWSTR; level : DWORD; var bufptr : pointer;
                             prefMaxLen : DWORD; var entriesRead, totalEntries,
                             resumeHandle: DWORD) : NET_API_STATUS; stdcall;
  function NetUserGetInfo(servername, username : PWideChar; level : LongInt;
                          bufptr : pointer) : NET_API_STATUS; stdcall;

{*****************************************************************************}
  { lmapibuf.h }
  function NetApiBufferFree(buffer : pointer) : NET_API_STATUS; stdcall;

{*****************************************************************************}
  { lmserver.h }
type
  TServerInfo100 = record
    platformID : DWORD;
    name : LPWSTR;
  end;

  TServerInfo101 = record
    platformID : DWORD;
    name : LPWSTR;
    versionMajor : DWORD;
    versionMinor : DWORD;
    _type : DWORD;
    comment : LPWSTR;
  end;

const
  SV_TYPE_WORKSTATION        = $00000001; // All Net workstations
  SV_TYPE_SERVER             = $00000002; // All Net servers
  SV_TYPE_SQLSERVER          = $00000004; // Any server running with Microsoft SQL Server
  SV_TYPE_DOMAIN_CTRL        = $00000008; // Primary domain controller
  SV_TYPE_DOMAIN_BAKCTRL     = $00000010; // Backup domain controller
  SV_TYPE_TIMESOURCE         = $00000020; // Server running the Timesource service
  SV_TYPE_AFP                = $00000040; // Apple File Protocol servers
  SV_TYPE_NOVELL             = $00000080; // Novell servers
  SV_TYPE_DOMAIN_MEMBER      = $00000100; // LAN Manager 2.xDomain Member
  SV_TYPE_LOCAL_LIST_ONLY    = $40000000; // Servers maintained by the browser. See the following Remarks section.
  SV_TYPE_PRINT              = $00000200; // Server sharing print queue
  SV_TYPE_DIALIN             = $00000400; // Server running dial-in service
  SV_TYPE_XENIX_SERVER       = $00000800; // Xenix server
  SV_TYPE_MFPN               = $00004000; // Microsoft File and Print for Netware
  SV_TYPE_NT                 = $00001000; // Windows NT (either Workstation or Server)
  SV_TYPE_WFW                = $00002000; // Server running Windows for Workgroups
  SV_TYPE_SERVER_NT          = $00008000; // Windows NT Non-DC server
  SV_TYPE_POTENTIAL_BROWSER  = $00010000; // Server that can run the Browser service
  SV_TYPE_BACKUP_BROWSER     = $00020000; // Server running a Browser service as backup
  SV_TYPE_MASTER_BROWSER     = $00040000; // Server running the master Browser service
  SV_TYPE_DOMAIN_MASTER      = $00080000; // Server running the domain master Browser
  SV_TYPE_DOMAIN_ENUM        = $80000000; // Primary Domain
  SV_TYPE_WINDOWS            = $00400000; // Windows 95 or later
  SV_TYPE_ALL                = $fffffff; // All servers

  function NetServerEnum(serverName : LPWSTR; level : DWORD; var bufptr : pointer;
                       prefMaxLen : DWORD; var entriesRead : DWORD;
                       var totalEntries : DWORD; serverType : DWORD;
                       domain : LPWSTR; var resumeHandle : DWORD) :
                       NET_API_STATUS; stdcall;
  function NetServerGetInfo(serverName : PWideChar; level : DWord; var bufPtr : pointer) :
                            NET_API_STATUS; stdcall;

{*****************************************************************************}
{ lmmsg.h }
  function NetMessageBufferSend(serverName, msgName, fromName, buf : PWideChar;
                                bufLen : integer) : integer; stdcall;

{*****************************************************************************}
{ lmat.h }
type
  TAtInfo = record
    jobTime : DWord;
    DaysOfMonth : DWord;
    daysOfWeek : UChar;
    flags : UChar;
    command : PWideChar;
  end;

  TAtEnum = record
    jobId : DWord;
    jobTime : DWord;
    daysOfMonth : DWord;
    daysOfWeek : UChar;
    flags : UChar;
    command : PWideChar;
  end;

const
  JOB_RUN_PERIODICALLY = 1;
  JOB_EXEC_ERROR = 2;
  JOB_RUNS_TODAY = 4;
  JOB_ADD_CURRENT_DATE = 8;
  JOB_NONINTERACTIVE = 16;

  function NetScheduleJobAdd(serverName : PWideChar; buffer : pointer;
                             var jobId : DWord) : NET_API_STATUS; stdcall;
  function NetScheduleJobDel(serverName : PWideChar; minJobId, maxJobId : DWord) :
                             NET_API_STATUS; stdcall;
  function NetScheduleJobEnum(serverName : LPWSTR; var buffer : pointer;
                              maxLength : DWord; var entriesRead, totalEntries,
                              resumeHandle : DWord) : NET_API_STATUS; stdcall;
  function NetScheduleJobGetInfo(serverName : PWideChar; jobId : DWord;
                                 var buffer : pointer) : NET_API_STATUS; stdcall;

{*****************************************************************************}
{ lmshare.h }
type
  TShareInfo502 = record
    name : PWChar;
    shareType : DWord;
    remark : PWChar;
    permissions : DWord;
    maxUses : DWord;
    currentUses : DWord;
    path : PWChar;
    password : PWChar;
    reserved : DWord;
    securityDescriptor : PSECURITY_DESCRIPTOR;
  end;

const
  STYPE_DISKTREE = 0;
  STYPE_PRINTQ   = 1;
  STYPE_DEVICE   = 2;
  STYPE_IPC      = 3;
  STYPE_DFS      = 100;

  function NetShareAdd(serverName : PWideChar; level : DWord;
                       buffer : pointer; var parm_err : DWord) : NET_API_STATUS;
                       stdcall;
  function NetShareDel(serverName : PWideChar; netName : PWideChar;
                       reserved : DWord) : NET_API_STATUS; stdcall;
  function NetShareEnum(serverName : LPWSTR; level : DWord; var buffer : pointer;
                        maxLength : DWord; var entriesRead, totalEntries,
                        resumeHandle : DWord) : NET_API_STATUS; stdcall;
  function NetShareGetInfo(serverName : PWideChar; netName : PWideChar;
                           level : DWord; var buffer : pointer) : NET_API_STATUS; stdcall;
  function NetShareSetInfo(serverName : PWideChar; netName : PWideChar;
                           level : DWord; buffer : pointer;
                           var parm_err : DWord) : NET_API_STATUS; stdcall;
  function NetShareCheck(serverName : PWideChar; device : PWideChar;
                         _type : DWord) : NET_API_STATUS; stdcall;

{*****************************************************************************}
const
  advapi32 = 'advapi32.dll';
  netapi32 = 'netapi32.dll';

implementation

  { winnt.h }
  function AddAccessAllowedAce; external advapi32;


  { lmaccess.h }
  function NetQueryDisplayInformation; external netapi32;
  function NetGetDCName; external netapi32;
  function NetGetAnyDCName; external netapi32;
  function NetLocalGroupEnum; external netapi32;
  function NetUserGetInfo; external netapi32;

  { lmapibuf.h }
  function NetApiBufferFree; external netapi32;

  { lmserver.h }
  function NetServerEnum; external netapi32;
  function NetServerGetInfo; external netapi32;

  { lmmsg.h }
  function NetMessageBufferSend; external netapi32;

  { lmat.h }
  function NetScheduleJobAdd; external netapi32;
  function NetScheduleJobDel; external netapi32;
  function NetScheduleJobEnum; external netapi32;
  function NetScheduleJobGetInfo; external netapi32;

  { lmshare.h }
  function NetShareAdd; external netapi32;
  function NetShareDel; external netapi32;
  function NetShareEnum; external netapi32;
  function NetShareGetInfo; external netapi32;
  function NetShareCheck; external netapi32;
  function NetShareSetInfo; external netapi32;

end.
