unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  jgNTSharesC, jgNTBase, jgNTShares, ComCtrls, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    edMachineName: TEdit;
    Label1: TLabel;
    cmdGetSharesAsync: TButton;
    cmdAddShare: TButton;
    cmdDeleteShare: TButton;
    Panel2: TPanel;
    lvShares: TListView;
    jgNTShares1: TjgNTShares;
    cmdGetShares: TButton;
    procedure cmdDeleteShareClick(Sender: TObject);
    procedure lvSharesDblClick(Sender: TObject);
    procedure cmdAddShareClick(Sender: TObject);
    procedure cmdGetSharesClick(Sender: TObject);
    procedure jgNTShares1GotShareList(Sender: TObject);
    procedure cmdGetSharesAsyncClick(Sender: TObject);
  private
    procedure UpdateListItem(li : TListItem; si : TShareItem);
    function  EditShare(shareItem : TShareItem) : boolean;
    procedure FillListView;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses Unit2;

{****************************************************************}
procedure TForm1.cmdGetSharesClick(Sender: TObject);
begin
  if not jgNTShares1.Execute(false) then
    begin
      ShowMessage('An error has occured while retrieving shares. (' +
                  SysErrorMessage(jgNTShares1.errorCode) + ')');
      exit;
    end;
  FillListView;
end;

{*****************************************************************************}
procedure TForm1.UpdateListItem(li : TListItem; si : TShareItem);
begin
  with li, si do
    begin
      data:= pointer(si);
      caption:= name;
      subItems.Clear;
      subItems.Add(shareTypesText[si.shareType]);
      subItems.Add(path);
      subItems.Add(comment);
      subItems.Add(IntToStr(currentConnections));
      if maxConnections = DWord(-1) then
        subItems.Add('Unlimited')
      else
        subItems.Add(IntToStr(maxConnections));
    end;
end;

{*****************************************************************************}
procedure TForm1.FillListView;
var
  i : integer;
begin
  lvShares.Items.BeginUpdate;
  lvShares.Items.Clear;
  if jgNTShares1.items.Count = 0 then
    begin
      lvShares.Items.Add.Caption:= 'No Shares';
      lvShares.Enabled:= false;
      exit;
    end;

  for i:= 0 to jgNTShares1.items.Count - 1 do
    UpdateListItem(lvShares.Items.Add,jgNTShares1.items[i]);
  lvShares.Enabled:= true;
  lvShares.Items.EndUpdate;
end;

{*****************************************************************************}
procedure TForm1.cmdDeleteShareClick(Sender: TObject);
var
  li : TListItem;
  si : TShareItem;
begin
  li:= lvShares.Selected;
  if li = nil then exit;
  si:= li.data;
  if si = nil then exit;
  si.DeleteShare;
  li.Free;
  if lvShares.Items.Count = 0 then
    begin
      lvShares.Items.Add.Caption:= 'No Shares';
      lvShares.Enabled:= false;
    end;
end;

{*****************************************************************************}
procedure TForm1.lvSharesDblClick(Sender: TObject);
var
  li : TListItem;
  si : TShareItem;
begin
  li:= lvShares.Selected;
  if li = nil then exit;
  si:= TShareItem(li.data);
  if si = nil then exit;
  if EditShare(si) then
    begin
      si.UpdateShare;
      UpdateListItem(li,si);
    end;
end;

{*****************************************************************************}
function TForm1.EditShare(shareItem : TShareItem) : boolean;
begin
  with TForm2.Create(self) do
    begin
      edShareName.text:= shareItem.name;
      cboxType.itemIndex:= Ord(shareItem.shareType);
      edShareComment.text:= shareItem.comment;
      edSharePath.text:= shareItem.path;
      if shareItem.maxConnections = DWord(-1) then
        begin
          udMaxConnections.position:= 0;
          cbUnlimited.checked:= true;
        end
      else
        udMaxConnections.position:= shareItem.maxConnections;
      result:= ShowModal = mrOk;
      if result then
        begin
          shareItem.name:= edShareName.text;
          shareItem.shareType:= TShareTypes(cboxType.itemIndex);
          shareItem.comment:= edShareComment.text;
          shareItem.path:= edSharePath.text;
          if cbUnlimited.checked then shareItem.maxConnections:= DWord(-1)
          else shareItem.maxConnections:= udMaxConnections.position;
        end;
      Free;
    end;
end;

{*****************************************************************************}
procedure TForm1.cmdAddShareClick(Sender: TObject);
var
  si : TShareItem;
  li : TListItem;
begin
  si:= jgNTShares1.items.Add;
  if EditShare(si) then
    begin
      si.CreateShare;
      if lvShares.Enabled = false then
        begin
          lvShares.Enabled:= true;
          lvShares.Items.Clear;
        end;
      li:= lvShares.items.Add;
      UpdateListItem(li,si);
    end
  else si.Free;
end;

{****************************************************************}
procedure TForm1.jgNTShares1GotShareList(Sender: TObject);
begin
  if jgNTShares1.errorCode > 0 then
    begin
      ShowMessage('An error has occured while retrieving shares. (' +
                  SysErrorMessage(jgNTShares1.errorCode) + ')');
      exit;
    end;
  FillListView;
end;

{****************************************************************}
procedure TForm1.cmdGetSharesAsyncClick(Sender: TObject);
begin
  with jgNTShares1 do
    begin
      MachineName:= edMachineName.text;
      Execute(true);
    end;
end;

end.

