unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, jgNTJobsC, jgNTJobs, ExtCtrls, jgNTBase;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    lvJobs: TListView;
    Panel2: TPanel;
    Label1: TLabel;
    edMachineName: TEdit;
    cmdGetJobsAsync: TButton;
    cmdAdd: TButton;
    cmdDelete: TButton;
    jgNTJobs1: TjgNTJobs;
    cmdGetJobs: TButton;
    procedure cmdGetJobsAsyncClick(Sender: TObject);
    procedure cmdAddClick(Sender: TObject);
    procedure lvJobsDblClick(Sender: TObject);
    procedure cmdDeleteClick(Sender: TObject);
    procedure jgNTJobs1GotJobList(Sender: TObject);
    procedure cmdGetJobsClick(Sender: TObject);
  private
    procedure UpdateListItem(li : TListItem; ji : TJobItem);
    procedure EditJob(jobItem : TJobItem);
    procedure FillListView;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses Unit2;

{*****************************************************************************}
procedure TForm1.cmdGetJobsAsyncClick(Sender: TObject);
begin
  with jgNTJobs1 do
    begin
      MachineName:= edMachineName.text;
      if not IsServiceRunning then
        begin
          if MessageDlg('Scheduler service is not running on ' +
                        machineName + '. Do you want to start it ?',
                        mtConfirmation,[mbYes,mbNo],0) = mrNo then exit;
          StartJobService;
        end;
      Execute(true);
    end;
end;

{*****************************************************************************}
procedure TForm1.UpdateListItem(li : TListItem; ji : TJobItem);
var
  str : string;
  i : integer;
begin
  with li, ji do
    begin
      data:= pointer(ji);
      caption:= IntToStr(jobId);
      subItems.Clear;
      subItems.Add(TimeToStr(jobTime));

      str:= '';
      if dowMonday in daysOfWeek then str:= str + 'Monday, ';
      if dowTuesday in daysOfWeek then str:= str + 'Tuesday, ';
      if dowWednesday in daysOfWeek then str:= str + 'Wednesday, ';
      if dowThursday in daysOfWeek then str:= str + 'Thursday, ';
      if dowFriday in daysOfWeek then str:= str + 'Friday, ';
      if dowSaturday in daysOfWeek then str:= str + 'Saturday, ';
      if dowSunday in daysOfWeek then str:= str + 'Sunday, ';
      system.Delete(str,Length(str) - 1,3);

      for i:= 1 to 31 do
        if Days[i] then str:= str + IntToStr(i) + ' ';

      if every then str:= 'Each ' + str
      else
        if (daysOfWeek <> []) or (daysOfMonth <> 0) then
          str:= 'Next ' + str
      else
        if today then str:= 'Today ' + str
      else
        str:= 'Tomorrow ' + str;
      subItems.Add(str);
      subItems.Add(command);
      if interactive then subItems.Add('Yes') else subItems.Add('No');
      if error then subItems.Add('Yes') else subItems.Add('No');
    end;
end;

{*****************************************************************************}
procedure TForm1.cmdAddClick(Sender: TObject);
var
  ji : TJobItem;
  li : TListItem;
begin
  ji:= jgNTJobs1.items.Add;
  EditJob(ji);
  if ji.AddJob then
    begin
      if lvJobs.Enabled = false then
        begin
          lvJobs.Enabled:= true;
          lvJobs.Items.Clear;
        end;
      li:= lvJobs.items.Add;
      UpdateListItem(li,ji);
    end;
end;

{*****************************************************************************}
procedure TForm1.lvJobsDblClick(Sender: TObject);
var
  li : TListItem;
  ji : TJobItem;
begin
  li:= lvJobs.Selected;
  if li = nil then exit;
  ji:= TJobItem(li.data);
  if ji = nil then exit;
  EditJob(ji);
  if ji.UpdateJob then UpdateListItem(li,ji)
  else
    begin
      li.Free;
      if lvJobs.Items.Count = 0 then
        begin
          lvJobs.Items.Add.Caption:= 'No jobs';
          lvJobs.Enabled:= false;
        end;
    end;
end;

{*****************************************************************************}
procedure TForm1.EditJob(jobItem : TJobItem);
var
  hour, min, sec, mSec : Word;
  i : integer;
begin
  with TForm2.Create(self) do
    begin
      cbMon.checked:= dowMonday in jobItem.daysOfWeek;
      cbTue.checked:= dowTuesday in jobItem.daysOfWeek;
      cbWed.checked:= dowWednesday in jobItem.daysOfWeek;
      cbThu.checked:= dowThursday in jobItem.daysOfWeek;
      cbFri.checked:= dowFriday in jobItem.daysOfWeek;
      cbSat.checked:= dowSaturday in jobItem.daysOfWeek;
      cbSun.checked:= dowSunday in jobItem.daysOfWeek;
      for i:= 1 to 31 do lbDays.selected[i - 1]:= jobItem.days[i];

      DecodeTime(jobItem.jobTime,hour,min,sec,mSec);
      if hour > 12 then
        begin
          hour:= hour - 12;
          cbPM.checked:= true;
        end;
      udHour.position:= hour;
      udMinutes.position:= min;
      cbEvery.checked:= jobItem.every;
      cbInteractive.checked:= jobItem.interactive;
      edCommand.text:= jobItem.command;
      if ShowModal = mrOk then
        begin
          jobItem.daysOfWeek:= [];
          if cbMon.checked then jobItem.daysOfWeek:= [dowMonday];
          if cbTue.checked then jobItem.daysOfWeek:=
            jobItem.daysOfWeek + [dowTuesday];
          if cbWed.checked then jobItem.daysOfWeek:=
            jobItem.daysOfWeek + [dowWednesday];
          if cbThu.checked then jobItem.daysOfWeek:=
            jobItem.daysOfWeek + [dowThursday];
          if cbFri.checked then jobItem.daysOfWeek:=
            jobItem.daysOfWeek + [dowFriday];
          if cbSat.checked then jobItem.daysOfWeek:=
            jobItem.daysOfWeek + [dowSaturday];
          if cbSun.checked then jobItem.daysOfWeek:=
            jobItem.daysOfWeek + [dowSunday];

          for i:= 1 to 31 do jobItem.days[i]:= lbDays.selected[i - 1];
          hour:= udHour.position;
          min:= udMinutes.position;
          if cbPM.checked then hour:= hour + 12;
          jobItem.jobTime:= EncodeTime(hour,min,0,0);
          jobItem.every:= cbEvery.checked;
          jobItem.interactive:= cbInteractive.checked;
          jobItem.command:= edCommand.text;
        end;
      Free;
    end;
end;

{*****************************************************************************}
procedure TForm1.cmdDeleteClick(Sender: TObject);
var
  li : TListItem;
  ji : TJobItem;
begin
  li:= lvJobs.Selected;
  if li = nil then exit;
  ji:= li.data;
  if ji = nil then exit;
  ji.DeleteJob;
  li.Free;
  if lvJobs.Items.Count = 0 then
    begin
      lvJobs.Items.Add.Caption:= 'No jobs';
      lvJobs.Enabled:= false;
    end;
end;

{*****************************************************************************}
procedure TForm1.jgNTJobs1GotJobList(Sender: TObject);
begin
  if jgNTJobs1.errorCode > 0 then
    begin
      ShowMessage('An error has occured while retrieving jobs. (' +
                  SysErrorMessage(jgNTJobs1.errorCode) + ')');
      exit;
    end;
  FillListView;
end;

{****************************************************************}
procedure TForm1.cmdGetJobsClick(Sender: TObject);
begin
  if not jgNTJobs1.Execute(false) then
    begin
      ShowMessage('An error has occured while retrieving jobs. (' +
                  SysErrorMessage(jgNTJobs1.errorCode) + ')');
      exit;
    end;
  FillListView;
end;

{****************************************************************}
procedure TForm1.FillListView;
var
  i : integer;
begin
  lvJobs.Items.Clear;
  if jgNTJobs1.items.Count = 0 then
    begin
      lvJobs.Items.Add.Caption:= 'No jobs';
      lvJobs.Enabled:= false;
      exit;
    end;

  for i:= 0 to jgNTJobs1.items.Count - 1 do
    UpdateListItem(lvJobs.Items.Add,jgNTJobs1.items[i]);
  lvJobs.Enabled:= true;
end;

end.
