library islog;
(*##*)
(*******************************************************************
*                                                                 *
*   I  S  L  O  G           part of IS2SQL project                 *
*                                                                 *
*   Copyright (c) 1999,                                *
*   DLL    is2sql.dll                            *
*   Part of is2sql                                                 *
*                                                                 *
*   for more information see readme.txt                            *
*                                                                 *
*   Conditional defines:                                           *
*                                                                 *
*   Last Revision: Feb 22 1999                                     *
*   Last fix     : Feb 22 1999                                    *
*   Lines        :                                                 *
*   History      :                                                *
*   Printed      : ---                                             *
*                                                                 *
********************************************************************)
(*##*)

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  Project-View Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the BORLNDMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using BORLNDMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils, Classes, Dialogs, Windows, Registry,
  util1, isutil1, logmeter,
  FLogInfo in 'FLogInfo.pas' {FormLogInfo}; { About form }

const
  MAX_PATH = 128;
  logfn: String[255] = '';
var
  SaveExit: Pointer;
{ show or hide information panel
}
function logInfoPanel(AShow: Boolean): Boolean; stdcall;
begin
  if AShow then begin
    if FormLogInfo = Nil
    then FormLogInfo:= TFormLogInfo.Create(Nil);
    with FormLogInfo do begin
      Show;
      Update;
    end;
  end else begin
    FormLogInfo.Hide;
    FormLogInfo.Free;
    FormLogInfo:= Nil;
  end;
  Result:= True;
end;

function logstartfunc(ALogStart: TLogStart): Boolean; stdcall;
var
  S: String;
  FN: array[0..MAX_PATH- 1] of Char;
  F: TFileStream;
begin
  Result:= False;
  s:= ALogStart.FN;
  if not util1.IsAbsolutePath(S) then begin
    SetString(S, FN, GetModuleFileName(hInstance, FN, SizeOf(FN)));
    S:= ConcatPath(ExtractFilePath(S), logfn);
  end;
  if not FileExists(S) then begin
    try
      F:= TFileStream.Create(S, fmCreate);
      { remoteIP t0 dt len empno lst }
      S:= 'ip'#9#9'Date'#9#9'Time'#9#9#9'Duration'#9'Bytes'#9'emp no'#9'Host'#9'db'#9'user'#9'key'#9'form'#9'family'#9'Description'#13#10;
      F.Write(S[1], Length(S));
      F.Free;
    except
      Exit;
    end;
  end;
  logfn:= S;
  Result:= True;
end;

{   remoteIP: String[4*4];  ( )
    t0,                 
    dt: TDateTime;    
    len: Integer;      ,  
    empno: Integer;    
    lst: String[128]; ,,,,,, }
function logfunc(ALogP: TLogStruc): Boolean; stdcall;
var
  S: String;
  F: TFileStream;
{ put field delimiter}
procedure Dlmt;
begin
  S:= #9;
  F.Write(S[1], Length(S));
end;

begin
  Result:= False;
  with ALogP do begin
    {}
    try
      F:= TFileStream.Create(logfn, fmOpenWrite + fmShareDenyNone);
    except
      Exit;
    end;
    try
      F.Seek(0, soFromEnd);
      S:= remoteIP;
      F.Write(S[1], Length(S));
      Dlmt;
      S:= DateTimeToStr(t0);
      F.Write(S[1], Length(S));
      Dlmt;
      S:= TimeToStr(dt);
      F.Write(S[1], Length(S));
      Dlmt;
      S:= IntToStr(len);
      F.Write(S[1], Length(S));
      Dlmt;
      F.Write(lst[1], Length(lst));
      S:= #13#10;
      F.Write(S[1], Length(S));
      {
      logevt.Text:= DateTimeToStr(t0);
      }
    finally
      F.Free;
    end;
  end;
  Result:= True;
end;

function LoadIni: Boolean;
var
  S: String;
  Rg: TRegistry;
begin
  Rg:= TRegistry.Create;
  Rg.RootKey:= HKEY_LOCAL_MACHINE;
  Rg.OpenKeyReadOnly(RGPATH);
  try
    S:= '';
    S:= Rg.ReadString('LongDateFormat');
  except
  end;
  if S <> '' then begin
    LongDateFormat:= S;
  end;

  try
    S:= '';
    S:= Rg.ReadString('ShortDateFormat');
  except
  end;
  if S <> '' then begin
    ShortDateFormat:= S;
  end;

  try
    S:= '';
    S:= Rg.ReadString('LongTimeFormat');
  except
  end;
  if S <> '' then begin
    LongTimeFormat:= S;
  end;

  try
    S:= '';
    S:= Rg.ReadString('ShortTimeFormat');
  except
  end;
  if S <> '' then begin
    ShortTimeFormat:= S;
  end;

  try
    S:= '';
    S:= Rg.ReadString('DecimalSeparator');
  except
  end;
  if Length(S) >= 1 then begin
    DecimalSeparator:= S[1];
  end;
  Rg.Free;
  LoadIni:= True;
end;

procedure LibExit;
begin
  // restore exit procedure chain
  ExitProc := SaveExit;
end;

exports
  logfunc index 1 name 'logfunc',
  logstartfunc index 2 name 'logstartfunc',
  logInfoPanel index 3;

begin
  {..}
  FormLogInfo:= Nil;
  // save exit procedure chain & install LibExit exit procedure
  // SaveExit:= ExitProc;
  // ExitProc:= @LibExit;
  if LoadIni then begin
  end;
end.
