unit utilwin;
(*##*)
(*******************************************************************
*                                                                 *
*   U  T  I  L  W  I  N   Ensen's windows routines for Delphi      *
*                                                                 *
*   Copyright (c) 1998, A.Ivanov. All rights reserved.             *
*   Microsoft Windows routines                                    *
*   Conditional defines:                                           *
*                                                                 *
*   Last Revision: Apr 04 2000                                     *
*   Last fix     : Apr 04 2000                                    *
*   Lines        :                                                 *
*   History      :                                                *
*   Printed      : ---                                             *
*                                                                 *
********************************************************************)
(*##*)
{ ini file routines }
interface
uses
  Classes, SysUtils, Windows;

function IsFileExtAssociatesWithCmd(AExtension, AFileType, ACmd: String;
  var AFileDescription: String; var AFileIcon: String;
  var ACmdDescription, ACmdProgram, ACmdParamString,
  ADDEApplication, ADDETopic, ADDEItem: String): Boolean;

// Parameters:    AExtension        .gif
//                AFileType         MyAppFileType
//                AFileDescription  '' == AFileType
//                AFileIconIndex    <0- do not assign icon
//
//                ACmd              '' =='open'
//                ACmdDescription,
//                ACmdProgram       '' - clear command ACmd.
//                ACmdParamString
//
// return AExtDescription, if AExtension (like .png) exists
function InstallFileExt(AExtension: String; AFileType: String; AFileDescription: String; AFileIconIndex: Integer;
  ACmd, ACmdDescription, ACmdProgram, ACmdParamString: String;
  ADDEApplication, ADDETopic, ADDEItem: String;
  AOverrideFileDescription, ADefaultCmd: Boolean): Boolean;

function DeInstallFileExt(AExtension, AFileType: String): Boolean;

implementation
uses
  Registry, util1;

function IsFileExtAssociatesWithCmd(AExtension, AFileType, ACmd: String;
  var AFileDescription: String; var AFileIcon: String;
  var ACmdDescription, ACmdProgram, ACmdParamString,
  ADDEApplication, ADDETopic, ADDEItem: String): Boolean;
var
  Reg: TRegistry;
  S: String;
begin
  Result:= False;
  AFileDescription:= '';
  AFileIcon:= '';
  ACmdDescription:= '';
  ACmdProgram:= '';
  ACmdParamString:= '';
  ADDEApplication:= '';
  ADDETopic:= '';
  ADDEItem:= '';
  Reg:= TRegistry.Create;
  try
  with Reg do begin
    RootKey:= HKEY_CLASSES_ROOT;
    if KeyExists(AExtension) then begin
      // read file type description
      if OpenKeyReadOnly(AExtension) then begin
        S:= ReadString('');
        // is file type link exists
        if (CompareText(AFileType, S) = 0) then begin
          // read file type description
          if OpenKeyReadOnly('\' + AFileType) then begin
            AFileDescription:= ReadString('');
            // file icon
            OpenKeyReadOnly('DefaultIcon');
            AFileIcon:= ReadString('');
            // command. Default command: open
            if Length(ACmd) = 0
            then ACmd:= 'open';
            // default command
            if OpenKeyReadOnly('\' + AFileType + '\Shell\')
            then S:= ReadString('');
            if OpenKeyReadOnly('\' + AFileType + '\Shell\'+ACmd) then begin
              Result:= True;
              // command description
              if OpenKeyReadOnly('\' + AFileType + '\Shell\'+ACmd)
              then ACmdDescription:= ReadString('');
              // command string
              if OpenKeyReadOnly('\' + AFileType + '\Shell\'+ACmd+'\command')
              then ACmdProgram:= ReadString('');
              // ddeexec
              if OpenKey('\' + AFileType + '\Shell\'+ACmd+'\ddeexec', False) then begin
                if OpenKeyReadOnly('\' + AFileType + '\Shell\'+ACmd+'\ddeexec')
                then ADDEItem:= ReadString('');
                if OpenKeyReadOnly('\' + AFileType + '\Shell\'+ACmd+'\ddeexec\Application')
                then ADDEApplication:= ReadString('');
                if OpenKeyReadOnly('\' + AFileType + '\Shell\'+ACmd+'\ddeexec\Topic')
                then ADDETopic:= ReadString('');
              end;
            end;
          end;
        end;
      end;
    end;
  end;
  except
  end;
  Reg.Free;
end;

function InstallFileExt(AExtension: String; AFileType: String; AFileDescription: String; AFileIconIndex: Integer;
  ACmd, ACmdDescription, ACmdProgram, ACmdParamString: String;
  ADDEApplication, ADDETopic, ADDEItem: String;
  AOverrideFileDescription, ADefaultCmd: Boolean): Boolean;
var
  Reg: TRegistry;
  S: String;
  i: Integer;
  SL: TStrings;
begin
  Reg := TRegistry.Create;
  try
  with Reg do begin
    // 1. associate file extension and file type
    // write file extension (like .png) link to description (default value)
    RootKey := HKEY_CLASSES_ROOT;
    if KeyExists(AExtension) then begin
      // read description's link
      OpenKey(AExtension, False);
      S:= ReadString('');
      // is description's link exists, use it
      if Length(S) > 0
      then AFileType:= S
      else begin
        // create new link
        WriteString('', AFileType);
      end;
    end else begin
      // create new key
      OpenKey(AExtension, True);
      // create new link to description
      WriteString('', AFileType);
    end;

    // 2. file type description
    if Length(AFileDescription) = 0
    then AFileDescription:= AFileType;
    // write file description: default (description), default icon, shell open command
    OpenKey('\' + AFileType, True);
    S:= ReadString('');
    // create or replace file description
    if AOverrideFileDescription or (Length(S) = 0)
    then WriteString('', AFileDescription);
    // create or replace file icon
    OpenKey('DefaultIcon', True);
    S:= ReadString('');
    if (AFileIconIndex >=0) and ((Length(S)=0) or AOverrideFileDescription)
    then WriteString('', ACmdProgram + ','+IntToStr(AFileIconIndex));

    if Length(ACmdProgram) = 0 then begin
      // NT requires delete all
      if OpenKey('\' + AFileType + '\Shell\'+ACmd+'\command', False) then begin
        SL:= TStringList.Create;
        GetValueNames(SL);
        for i:= 0 to SL.Count - 1 do begin
          DeleteKey(SL[i]);
        end;
      end;
      {
      DeleteKey('\' + AFileType + '\Shell\'+ACmd+'ddeexec\Application');
      DeleteKey('\' + AFileType + '\Shell\'+ACmd+'ddeexec\Topic');
      DeleteKey('\' + AFileType + '\Shell\'+ACmd+'ddeexec');
      DeleteKey('\' + AFileType + '\Shell\'+ACmd+'command');
      DeleteKey('\' + AFileType + '\Shell\'+ACmd);
      }
    end else begin
      // create or replace command. Default command: open
      if Length(ACmd) = 0
      then ACmd:= 'open';
      // default command
      OpenKey('\' + AFileType + '\Shell\', True);
      S:= ReadString('');
      if ADefaultCmd or (Length(S) = 0)
      then WriteString('', ACmd);
      // command description
      OpenKey('\' + AFileType + '\Shell\'+ACmd, True);
      WriteString('', ACmdDescription);
      // command string
      OpenKey('\' + AFileType + '\Shell\'+ACmd+'\command', True);
      WriteString('', '"' + ACmdProgram + '" "' + ACmdParamString + '"');
    end;
    // ddeexec
    if Length(ADDEApplication) = 0 then begin
      // NT requires delete all
      if OpenKey('\' + AFileType + '\Shell\'+ACmd+'\ddeexec', False) then begin
        SL:= TStringList.Create;
        GetValueNames(SL);
        for i:= 0 to SL.Count - 1 do begin
          DeleteKey(SL[i]);
        end;
      end;
    end else begin
      OpenKey('\' + AFileType + '\Shell\'+ACmd+'\ddeexec', True);
      WriteString('', ADDEItem);
      OpenKey('\' + AFileType + '\Shell\'+ACmd+'\ddeexec\Application', True);
      WriteString('', ADDEApplication);
      OpenKey('\' + AFileType + '\Shell\'+ACmd+'\ddeexec\Topic', True);
      WriteString('', ADDETopic);
      //
    end;
  end;
  Result := True;
  except
    Result := False;
  end;
  Reg.Free;
end;

function DeInstallFileExt(AExtension, AFileType: String): Boolean;
var
  Reg: TRegistry;
begin
  Reg := TRegistry.Create;
  try
    with Reg do begin
      RootKey := HKEY_CLASSES_ROOT;
      DeleteKey(AExtension);
      DeleteKey('\' + AFileType);
     end;
   Result := True;
  except
   Result := False;
  end;
  Reg.Free;
end;

end.
